# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['FlowSourceInitArgs', 'FlowSource']

@pulumi.input_type
class FlowSourceInitArgs:
    def __init__(__self__, *,
                 description: pulumi.Input[str],
                 decryption: Optional[pulumi.Input['FlowSourceEncryptionArgs']] = None,
                 entitlement_arn: Optional[pulumi.Input[str]] = None,
                 flow_arn: Optional[pulumi.Input[str]] = None,
                 gateway_bridge_source: Optional[pulumi.Input['FlowSourceGatewayBridgeSourceArgs']] = None,
                 ingest_port: Optional[pulumi.Input[int]] = None,
                 max_bitrate: Optional[pulumi.Input[int]] = None,
                 max_latency: Optional[pulumi.Input[int]] = None,
                 min_latency: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input['FlowSourceProtocol']] = None,
                 sender_control_port: Optional[pulumi.Input[int]] = None,
                 sender_ip_address: Optional[pulumi.Input[str]] = None,
                 source_listener_address: Optional[pulumi.Input[str]] = None,
                 source_listener_port: Optional[pulumi.Input[int]] = None,
                 stream_id: Optional[pulumi.Input[str]] = None,
                 vpc_interface_name: Optional[pulumi.Input[str]] = None,
                 whitelist_cidr: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a FlowSource resource.
        :param pulumi.Input[str] description: A description for the source. This value is not used or seen outside of the current AWS Elemental MediaConnect account.
        :param pulumi.Input['FlowSourceEncryptionArgs'] decryption: The type of encryption that is used on the content ingested from this source.
        :param pulumi.Input[str] entitlement_arn: The ARN of the entitlement that allows you to subscribe to content that comes from another AWS account. The entitlement is set by the content originator and the ARN is generated as part of the originator's flow.
        :param pulumi.Input[str] flow_arn: The ARN of the flow.
        :param pulumi.Input['FlowSourceGatewayBridgeSourceArgs'] gateway_bridge_source: The source configuration for cloud flows receiving a stream from a bridge.
        :param pulumi.Input[int] ingest_port: The port that the flow will be listening on for incoming content.
        :param pulumi.Input[int] max_bitrate: The smoothing max bitrate for RIST, RTP, and RTP-FEC streams.
        :param pulumi.Input[int] max_latency: The maximum latency in milliseconds. This parameter applies only to RIST-based and Zixi-based streams.
        :param pulumi.Input[int] min_latency: The minimum latency in milliseconds.
        :param pulumi.Input[str] name: The name of the source.
        :param pulumi.Input['FlowSourceProtocol'] protocol: The protocol that is used by the source.
        :param pulumi.Input[int] sender_control_port: The port that the flow uses to send outbound requests to initiate connection with the sender for fujitsu-qos protocol.
        :param pulumi.Input[str] sender_ip_address: The IP address that the flow communicates with to initiate connection with the sender for fujitsu-qos protocol.
        :param pulumi.Input[str] source_listener_address: Source IP or domain name for SRT-caller protocol.
        :param pulumi.Input[int] source_listener_port: Source port for SRT-caller protocol.
        :param pulumi.Input[str] stream_id: The stream ID that you want to use for this transport. This parameter applies only to Zixi-based streams.
        :param pulumi.Input[str] vpc_interface_name: The name of the VPC Interface this Source is configured with.
        :param pulumi.Input[str] whitelist_cidr: The range of IP addresses that should be allowed to contribute content to your source. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
        """
        pulumi.set(__self__, "description", description)
        if decryption is not None:
            pulumi.set(__self__, "decryption", decryption)
        if entitlement_arn is not None:
            pulumi.set(__self__, "entitlement_arn", entitlement_arn)
        if flow_arn is not None:
            pulumi.set(__self__, "flow_arn", flow_arn)
        if gateway_bridge_source is not None:
            pulumi.set(__self__, "gateway_bridge_source", gateway_bridge_source)
        if ingest_port is not None:
            pulumi.set(__self__, "ingest_port", ingest_port)
        if max_bitrate is not None:
            pulumi.set(__self__, "max_bitrate", max_bitrate)
        if max_latency is not None:
            pulumi.set(__self__, "max_latency", max_latency)
        if min_latency is not None:
            pulumi.set(__self__, "min_latency", min_latency)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if sender_control_port is not None:
            pulumi.set(__self__, "sender_control_port", sender_control_port)
        if sender_ip_address is not None:
            pulumi.set(__self__, "sender_ip_address", sender_ip_address)
        if source_listener_address is not None:
            pulumi.set(__self__, "source_listener_address", source_listener_address)
        if source_listener_port is not None:
            pulumi.set(__self__, "source_listener_port", source_listener_port)
        if stream_id is not None:
            pulumi.set(__self__, "stream_id", stream_id)
        if vpc_interface_name is not None:
            pulumi.set(__self__, "vpc_interface_name", vpc_interface_name)
        if whitelist_cidr is not None:
            pulumi.set(__self__, "whitelist_cidr", whitelist_cidr)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Input[str]:
        """
        A description for the source. This value is not used or seen outside of the current AWS Elemental MediaConnect account.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[str]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def decryption(self) -> Optional[pulumi.Input['FlowSourceEncryptionArgs']]:
        """
        The type of encryption that is used on the content ingested from this source.
        """
        return pulumi.get(self, "decryption")

    @decryption.setter
    def decryption(self, value: Optional[pulumi.Input['FlowSourceEncryptionArgs']]):
        pulumi.set(self, "decryption", value)

    @property
    @pulumi.getter(name="entitlementArn")
    def entitlement_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the entitlement that allows you to subscribe to content that comes from another AWS account. The entitlement is set by the content originator and the ARN is generated as part of the originator's flow.
        """
        return pulumi.get(self, "entitlement_arn")

    @entitlement_arn.setter
    def entitlement_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "entitlement_arn", value)

    @property
    @pulumi.getter(name="flowArn")
    def flow_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the flow.
        """
        return pulumi.get(self, "flow_arn")

    @flow_arn.setter
    def flow_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "flow_arn", value)

    @property
    @pulumi.getter(name="gatewayBridgeSource")
    def gateway_bridge_source(self) -> Optional[pulumi.Input['FlowSourceGatewayBridgeSourceArgs']]:
        """
        The source configuration for cloud flows receiving a stream from a bridge.
        """
        return pulumi.get(self, "gateway_bridge_source")

    @gateway_bridge_source.setter
    def gateway_bridge_source(self, value: Optional[pulumi.Input['FlowSourceGatewayBridgeSourceArgs']]):
        pulumi.set(self, "gateway_bridge_source", value)

    @property
    @pulumi.getter(name="ingestPort")
    def ingest_port(self) -> Optional[pulumi.Input[int]]:
        """
        The port that the flow will be listening on for incoming content.
        """
        return pulumi.get(self, "ingest_port")

    @ingest_port.setter
    def ingest_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ingest_port", value)

    @property
    @pulumi.getter(name="maxBitrate")
    def max_bitrate(self) -> Optional[pulumi.Input[int]]:
        """
        The smoothing max bitrate for RIST, RTP, and RTP-FEC streams.
        """
        return pulumi.get(self, "max_bitrate")

    @max_bitrate.setter
    def max_bitrate(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_bitrate", value)

    @property
    @pulumi.getter(name="maxLatency")
    def max_latency(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum latency in milliseconds. This parameter applies only to RIST-based and Zixi-based streams.
        """
        return pulumi.get(self, "max_latency")

    @max_latency.setter
    def max_latency(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_latency", value)

    @property
    @pulumi.getter(name="minLatency")
    def min_latency(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum latency in milliseconds.
        """
        return pulumi.get(self, "min_latency")

    @min_latency.setter
    def min_latency(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_latency", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the source.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input['FlowSourceProtocol']]:
        """
        The protocol that is used by the source.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input['FlowSourceProtocol']]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="senderControlPort")
    def sender_control_port(self) -> Optional[pulumi.Input[int]]:
        """
        The port that the flow uses to send outbound requests to initiate connection with the sender for fujitsu-qos protocol.
        """
        return pulumi.get(self, "sender_control_port")

    @sender_control_port.setter
    def sender_control_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "sender_control_port", value)

    @property
    @pulumi.getter(name="senderIpAddress")
    def sender_ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        The IP address that the flow communicates with to initiate connection with the sender for fujitsu-qos protocol.
        """
        return pulumi.get(self, "sender_ip_address")

    @sender_ip_address.setter
    def sender_ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sender_ip_address", value)

    @property
    @pulumi.getter(name="sourceListenerAddress")
    def source_listener_address(self) -> Optional[pulumi.Input[str]]:
        """
        Source IP or domain name for SRT-caller protocol.
        """
        return pulumi.get(self, "source_listener_address")

    @source_listener_address.setter
    def source_listener_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_listener_address", value)

    @property
    @pulumi.getter(name="sourceListenerPort")
    def source_listener_port(self) -> Optional[pulumi.Input[int]]:
        """
        Source port for SRT-caller protocol.
        """
        return pulumi.get(self, "source_listener_port")

    @source_listener_port.setter
    def source_listener_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "source_listener_port", value)

    @property
    @pulumi.getter(name="streamId")
    def stream_id(self) -> Optional[pulumi.Input[str]]:
        """
        The stream ID that you want to use for this transport. This parameter applies only to Zixi-based streams.
        """
        return pulumi.get(self, "stream_id")

    @stream_id.setter
    def stream_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "stream_id", value)

    @property
    @pulumi.getter(name="vpcInterfaceName")
    def vpc_interface_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the VPC Interface this Source is configured with.
        """
        return pulumi.get(self, "vpc_interface_name")

    @vpc_interface_name.setter
    def vpc_interface_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_interface_name", value)

    @property
    @pulumi.getter(name="whitelistCidr")
    def whitelist_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        The range of IP addresses that should be allowed to contribute content to your source. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
        """
        return pulumi.get(self, "whitelist_cidr")

    @whitelist_cidr.setter
    def whitelist_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "whitelist_cidr", value)


class FlowSource(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 decryption: Optional[pulumi.Input[Union['FlowSourceEncryptionArgs', 'FlowSourceEncryptionArgsDict']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 entitlement_arn: Optional[pulumi.Input[str]] = None,
                 flow_arn: Optional[pulumi.Input[str]] = None,
                 gateway_bridge_source: Optional[pulumi.Input[Union['FlowSourceGatewayBridgeSourceArgs', 'FlowSourceGatewayBridgeSourceArgsDict']]] = None,
                 ingest_port: Optional[pulumi.Input[int]] = None,
                 max_bitrate: Optional[pulumi.Input[int]] = None,
                 max_latency: Optional[pulumi.Input[int]] = None,
                 min_latency: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input['FlowSourceProtocol']] = None,
                 sender_control_port: Optional[pulumi.Input[int]] = None,
                 sender_ip_address: Optional[pulumi.Input[str]] = None,
                 source_listener_address: Optional[pulumi.Input[str]] = None,
                 source_listener_port: Optional[pulumi.Input[int]] = None,
                 stream_id: Optional[pulumi.Input[str]] = None,
                 vpc_interface_name: Optional[pulumi.Input[str]] = None,
                 whitelist_cidr: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Resource schema for AWS::MediaConnect::FlowSource

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['FlowSourceEncryptionArgs', 'FlowSourceEncryptionArgsDict']] decryption: The type of encryption that is used on the content ingested from this source.
        :param pulumi.Input[str] description: A description for the source. This value is not used or seen outside of the current AWS Elemental MediaConnect account.
        :param pulumi.Input[str] entitlement_arn: The ARN of the entitlement that allows you to subscribe to content that comes from another AWS account. The entitlement is set by the content originator and the ARN is generated as part of the originator's flow.
        :param pulumi.Input[str] flow_arn: The ARN of the flow.
        :param pulumi.Input[Union['FlowSourceGatewayBridgeSourceArgs', 'FlowSourceGatewayBridgeSourceArgsDict']] gateway_bridge_source: The source configuration for cloud flows receiving a stream from a bridge.
        :param pulumi.Input[int] ingest_port: The port that the flow will be listening on for incoming content.
        :param pulumi.Input[int] max_bitrate: The smoothing max bitrate for RIST, RTP, and RTP-FEC streams.
        :param pulumi.Input[int] max_latency: The maximum latency in milliseconds. This parameter applies only to RIST-based and Zixi-based streams.
        :param pulumi.Input[int] min_latency: The minimum latency in milliseconds.
        :param pulumi.Input[str] name: The name of the source.
        :param pulumi.Input['FlowSourceProtocol'] protocol: The protocol that is used by the source.
        :param pulumi.Input[int] sender_control_port: The port that the flow uses to send outbound requests to initiate connection with the sender for fujitsu-qos protocol.
        :param pulumi.Input[str] sender_ip_address: The IP address that the flow communicates with to initiate connection with the sender for fujitsu-qos protocol.
        :param pulumi.Input[str] source_listener_address: Source IP or domain name for SRT-caller protocol.
        :param pulumi.Input[int] source_listener_port: Source port for SRT-caller protocol.
        :param pulumi.Input[str] stream_id: The stream ID that you want to use for this transport. This parameter applies only to Zixi-based streams.
        :param pulumi.Input[str] vpc_interface_name: The name of the VPC Interface this Source is configured with.
        :param pulumi.Input[str] whitelist_cidr: The range of IP addresses that should be allowed to contribute content to your source. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FlowSourceInitArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource schema for AWS::MediaConnect::FlowSource

        :param str resource_name: The name of the resource.
        :param FlowSourceInitArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FlowSourceInitArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 decryption: Optional[pulumi.Input[Union['FlowSourceEncryptionArgs', 'FlowSourceEncryptionArgsDict']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 entitlement_arn: Optional[pulumi.Input[str]] = None,
                 flow_arn: Optional[pulumi.Input[str]] = None,
                 gateway_bridge_source: Optional[pulumi.Input[Union['FlowSourceGatewayBridgeSourceArgs', 'FlowSourceGatewayBridgeSourceArgsDict']]] = None,
                 ingest_port: Optional[pulumi.Input[int]] = None,
                 max_bitrate: Optional[pulumi.Input[int]] = None,
                 max_latency: Optional[pulumi.Input[int]] = None,
                 min_latency: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input['FlowSourceProtocol']] = None,
                 sender_control_port: Optional[pulumi.Input[int]] = None,
                 sender_ip_address: Optional[pulumi.Input[str]] = None,
                 source_listener_address: Optional[pulumi.Input[str]] = None,
                 source_listener_port: Optional[pulumi.Input[int]] = None,
                 stream_id: Optional[pulumi.Input[str]] = None,
                 vpc_interface_name: Optional[pulumi.Input[str]] = None,
                 whitelist_cidr: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FlowSourceInitArgs.__new__(FlowSourceInitArgs)

            __props__.__dict__["decryption"] = decryption
            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            __props__.__dict__["entitlement_arn"] = entitlement_arn
            __props__.__dict__["flow_arn"] = flow_arn
            __props__.__dict__["gateway_bridge_source"] = gateway_bridge_source
            __props__.__dict__["ingest_port"] = ingest_port
            __props__.__dict__["max_bitrate"] = max_bitrate
            __props__.__dict__["max_latency"] = max_latency
            __props__.__dict__["min_latency"] = min_latency
            __props__.__dict__["name"] = name
            __props__.__dict__["protocol"] = protocol
            __props__.__dict__["sender_control_port"] = sender_control_port
            __props__.__dict__["sender_ip_address"] = sender_ip_address
            __props__.__dict__["source_listener_address"] = source_listener_address
            __props__.__dict__["source_listener_port"] = source_listener_port
            __props__.__dict__["stream_id"] = stream_id
            __props__.__dict__["vpc_interface_name"] = vpc_interface_name
            __props__.__dict__["whitelist_cidr"] = whitelist_cidr
            __props__.__dict__["ingest_ip"] = None
            __props__.__dict__["source_arn"] = None
            __props__.__dict__["source_ingest_port"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["name"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(FlowSource, __self__).__init__(
            'aws-native:mediaconnect:FlowSource',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'FlowSource':
        """
        Get an existing FlowSource resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = FlowSourceInitArgs.__new__(FlowSourceInitArgs)

        __props__.__dict__["decryption"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["entitlement_arn"] = None
        __props__.__dict__["flow_arn"] = None
        __props__.__dict__["gateway_bridge_source"] = None
        __props__.__dict__["ingest_ip"] = None
        __props__.__dict__["ingest_port"] = None
        __props__.__dict__["max_bitrate"] = None
        __props__.__dict__["max_latency"] = None
        __props__.__dict__["min_latency"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["protocol"] = None
        __props__.__dict__["sender_control_port"] = None
        __props__.__dict__["sender_ip_address"] = None
        __props__.__dict__["source_arn"] = None
        __props__.__dict__["source_ingest_port"] = None
        __props__.__dict__["source_listener_address"] = None
        __props__.__dict__["source_listener_port"] = None
        __props__.__dict__["stream_id"] = None
        __props__.__dict__["vpc_interface_name"] = None
        __props__.__dict__["whitelist_cidr"] = None
        return FlowSource(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def decryption(self) -> pulumi.Output[Optional['outputs.FlowSourceEncryption']]:
        """
        The type of encryption that is used on the content ingested from this source.
        """
        return pulumi.get(self, "decryption")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        A description for the source. This value is not used or seen outside of the current AWS Elemental MediaConnect account.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="entitlementArn")
    def entitlement_arn(self) -> pulumi.Output[Optional[str]]:
        """
        The ARN of the entitlement that allows you to subscribe to content that comes from another AWS account. The entitlement is set by the content originator and the ARN is generated as part of the originator's flow.
        """
        return pulumi.get(self, "entitlement_arn")

    @property
    @pulumi.getter(name="flowArn")
    def flow_arn(self) -> pulumi.Output[Optional[str]]:
        """
        The ARN of the flow.
        """
        return pulumi.get(self, "flow_arn")

    @property
    @pulumi.getter(name="gatewayBridgeSource")
    def gateway_bridge_source(self) -> pulumi.Output[Optional['outputs.FlowSourceGatewayBridgeSource']]:
        """
        The source configuration for cloud flows receiving a stream from a bridge.
        """
        return pulumi.get(self, "gateway_bridge_source")

    @property
    @pulumi.getter(name="ingestIp")
    def ingest_ip(self) -> pulumi.Output[str]:
        """
        The IP address that the flow will be listening on for incoming content.
        """
        return pulumi.get(self, "ingest_ip")

    @property
    @pulumi.getter(name="ingestPort")
    def ingest_port(self) -> pulumi.Output[Optional[int]]:
        """
        The port that the flow will be listening on for incoming content.
        """
        return pulumi.get(self, "ingest_port")

    @property
    @pulumi.getter(name="maxBitrate")
    def max_bitrate(self) -> pulumi.Output[Optional[int]]:
        """
        The smoothing max bitrate for RIST, RTP, and RTP-FEC streams.
        """
        return pulumi.get(self, "max_bitrate")

    @property
    @pulumi.getter(name="maxLatency")
    def max_latency(self) -> pulumi.Output[Optional[int]]:
        """
        The maximum latency in milliseconds. This parameter applies only to RIST-based and Zixi-based streams.
        """
        return pulumi.get(self, "max_latency")

    @property
    @pulumi.getter(name="minLatency")
    def min_latency(self) -> pulumi.Output[Optional[int]]:
        """
        The minimum latency in milliseconds.
        """
        return pulumi.get(self, "min_latency")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the source.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[Optional['FlowSourceProtocol']]:
        """
        The protocol that is used by the source.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="senderControlPort")
    def sender_control_port(self) -> pulumi.Output[Optional[int]]:
        """
        The port that the flow uses to send outbound requests to initiate connection with the sender for fujitsu-qos protocol.
        """
        return pulumi.get(self, "sender_control_port")

    @property
    @pulumi.getter(name="senderIpAddress")
    def sender_ip_address(self) -> pulumi.Output[Optional[str]]:
        """
        The IP address that the flow communicates with to initiate connection with the sender for fujitsu-qos protocol.
        """
        return pulumi.get(self, "sender_ip_address")

    @property
    @pulumi.getter(name="sourceArn")
    def source_arn(self) -> pulumi.Output[str]:
        """
        The ARN of the source.
        """
        return pulumi.get(self, "source_arn")

    @property
    @pulumi.getter(name="sourceIngestPort")
    def source_ingest_port(self) -> pulumi.Output[str]:
        """
        The port that the flow will be listening on for incoming content.(ReadOnly)
        """
        return pulumi.get(self, "source_ingest_port")

    @property
    @pulumi.getter(name="sourceListenerAddress")
    def source_listener_address(self) -> pulumi.Output[Optional[str]]:
        """
        Source IP or domain name for SRT-caller protocol.
        """
        return pulumi.get(self, "source_listener_address")

    @property
    @pulumi.getter(name="sourceListenerPort")
    def source_listener_port(self) -> pulumi.Output[Optional[int]]:
        """
        Source port for SRT-caller protocol.
        """
        return pulumi.get(self, "source_listener_port")

    @property
    @pulumi.getter(name="streamId")
    def stream_id(self) -> pulumi.Output[Optional[str]]:
        """
        The stream ID that you want to use for this transport. This parameter applies only to Zixi-based streams.
        """
        return pulumi.get(self, "stream_id")

    @property
    @pulumi.getter(name="vpcInterfaceName")
    def vpc_interface_name(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the VPC Interface this Source is configured with.
        """
        return pulumi.get(self, "vpc_interface_name")

    @property
    @pulumi.getter(name="whitelistCidr")
    def whitelist_cidr(self) -> pulumi.Output[Optional[str]]:
        """
        The range of IP addresses that should be allowed to contribute content to your source. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
        """
        return pulumi.get(self, "whitelist_cidr")

