# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['FlowArgs', 'Flow']

@pulumi.input_type
class FlowArgs:
    def __init__(__self__, *,
                 source: pulumi.Input['FlowSourceArgs'],
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 maintenance: Optional[pulumi.Input['FlowMaintenanceArgs']] = None,
                 media_streams: Optional[pulumi.Input[Sequence[pulumi.Input['FlowMediaStreamArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 source_failover_config: Optional[pulumi.Input['FlowFailoverConfigArgs']] = None,
                 source_monitoring_config: Optional[pulumi.Input['FlowSourceMonitoringConfigArgs']] = None,
                 vpc_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['FlowVpcInterfaceArgs']]]] = None):
        """
        The set of arguments for constructing a Flow resource.
        :param pulumi.Input['FlowSourceArgs'] source: The source of the flow.
        :param pulumi.Input[str] availability_zone: The Availability Zone that you want to create the flow in. These options are limited to the Availability Zones within the current AWS.
        :param pulumi.Input['FlowMaintenanceArgs'] maintenance: The maintenance settings you want to use for the flow.
        :param pulumi.Input[Sequence[pulumi.Input['FlowMediaStreamArgs']]] media_streams: The media streams associated with the flow. You can associate any of these media streams with sources and outputs on the flow.
        :param pulumi.Input[str] name: The name of the flow.
        :param pulumi.Input['FlowFailoverConfigArgs'] source_failover_config: The source failover config of the flow.
        :param pulumi.Input['FlowSourceMonitoringConfigArgs'] source_monitoring_config: The source monitoring config of the flow.
        :param pulumi.Input[Sequence[pulumi.Input['FlowVpcInterfaceArgs']]] vpc_interfaces: The VPC interfaces that you added to this flow.
        """
        pulumi.set(__self__, "source", source)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if maintenance is not None:
            pulumi.set(__self__, "maintenance", maintenance)
        if media_streams is not None:
            pulumi.set(__self__, "media_streams", media_streams)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if source_failover_config is not None:
            pulumi.set(__self__, "source_failover_config", source_failover_config)
        if source_monitoring_config is not None:
            pulumi.set(__self__, "source_monitoring_config", source_monitoring_config)
        if vpc_interfaces is not None:
            pulumi.set(__self__, "vpc_interfaces", vpc_interfaces)

    @property
    @pulumi.getter
    def source(self) -> pulumi.Input['FlowSourceArgs']:
        """
        The source of the flow.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: pulumi.Input['FlowSourceArgs']):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[str]]:
        """
        The Availability Zone that you want to create the flow in. These options are limited to the Availability Zones within the current AWS.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_zone", value)

    @property
    @pulumi.getter
    def maintenance(self) -> Optional[pulumi.Input['FlowMaintenanceArgs']]:
        """
        The maintenance settings you want to use for the flow.
        """
        return pulumi.get(self, "maintenance")

    @maintenance.setter
    def maintenance(self, value: Optional[pulumi.Input['FlowMaintenanceArgs']]):
        pulumi.set(self, "maintenance", value)

    @property
    @pulumi.getter(name="mediaStreams")
    def media_streams(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FlowMediaStreamArgs']]]]:
        """
        The media streams associated with the flow. You can associate any of these media streams with sources and outputs on the flow.
        """
        return pulumi.get(self, "media_streams")

    @media_streams.setter
    def media_streams(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FlowMediaStreamArgs']]]]):
        pulumi.set(self, "media_streams", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the flow.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="sourceFailoverConfig")
    def source_failover_config(self) -> Optional[pulumi.Input['FlowFailoverConfigArgs']]:
        """
        The source failover config of the flow.
        """
        return pulumi.get(self, "source_failover_config")

    @source_failover_config.setter
    def source_failover_config(self, value: Optional[pulumi.Input['FlowFailoverConfigArgs']]):
        pulumi.set(self, "source_failover_config", value)

    @property
    @pulumi.getter(name="sourceMonitoringConfig")
    def source_monitoring_config(self) -> Optional[pulumi.Input['FlowSourceMonitoringConfigArgs']]:
        """
        The source monitoring config of the flow.
        """
        return pulumi.get(self, "source_monitoring_config")

    @source_monitoring_config.setter
    def source_monitoring_config(self, value: Optional[pulumi.Input['FlowSourceMonitoringConfigArgs']]):
        pulumi.set(self, "source_monitoring_config", value)

    @property
    @pulumi.getter(name="vpcInterfaces")
    def vpc_interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FlowVpcInterfaceArgs']]]]:
        """
        The VPC interfaces that you added to this flow.
        """
        return pulumi.get(self, "vpc_interfaces")

    @vpc_interfaces.setter
    def vpc_interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FlowVpcInterfaceArgs']]]]):
        pulumi.set(self, "vpc_interfaces", value)


class Flow(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 maintenance: Optional[pulumi.Input[Union['FlowMaintenanceArgs', 'FlowMaintenanceArgsDict']]] = None,
                 media_streams: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FlowMediaStreamArgs', 'FlowMediaStreamArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 source: Optional[pulumi.Input[Union['FlowSourceArgs', 'FlowSourceArgsDict']]] = None,
                 source_failover_config: Optional[pulumi.Input[Union['FlowFailoverConfigArgs', 'FlowFailoverConfigArgsDict']]] = None,
                 source_monitoring_config: Optional[pulumi.Input[Union['FlowSourceMonitoringConfigArgs', 'FlowSourceMonitoringConfigArgsDict']]] = None,
                 vpc_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FlowVpcInterfaceArgs', 'FlowVpcInterfaceArgsDict']]]]] = None,
                 __props__=None):
        """
        Resource schema for AWS::MediaConnect::Flow

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] availability_zone: The Availability Zone that you want to create the flow in. These options are limited to the Availability Zones within the current AWS.
        :param pulumi.Input[Union['FlowMaintenanceArgs', 'FlowMaintenanceArgsDict']] maintenance: The maintenance settings you want to use for the flow.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FlowMediaStreamArgs', 'FlowMediaStreamArgsDict']]]] media_streams: The media streams associated with the flow. You can associate any of these media streams with sources and outputs on the flow.
        :param pulumi.Input[str] name: The name of the flow.
        :param pulumi.Input[Union['FlowSourceArgs', 'FlowSourceArgsDict']] source: The source of the flow.
        :param pulumi.Input[Union['FlowFailoverConfigArgs', 'FlowFailoverConfigArgsDict']] source_failover_config: The source failover config of the flow.
        :param pulumi.Input[Union['FlowSourceMonitoringConfigArgs', 'FlowSourceMonitoringConfigArgsDict']] source_monitoring_config: The source monitoring config of the flow.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FlowVpcInterfaceArgs', 'FlowVpcInterfaceArgsDict']]]] vpc_interfaces: The VPC interfaces that you added to this flow.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FlowArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource schema for AWS::MediaConnect::Flow

        :param str resource_name: The name of the resource.
        :param FlowArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FlowArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 maintenance: Optional[pulumi.Input[Union['FlowMaintenanceArgs', 'FlowMaintenanceArgsDict']]] = None,
                 media_streams: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FlowMediaStreamArgs', 'FlowMediaStreamArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 source: Optional[pulumi.Input[Union['FlowSourceArgs', 'FlowSourceArgsDict']]] = None,
                 source_failover_config: Optional[pulumi.Input[Union['FlowFailoverConfigArgs', 'FlowFailoverConfigArgsDict']]] = None,
                 source_monitoring_config: Optional[pulumi.Input[Union['FlowSourceMonitoringConfigArgs', 'FlowSourceMonitoringConfigArgsDict']]] = None,
                 vpc_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FlowVpcInterfaceArgs', 'FlowVpcInterfaceArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FlowArgs.__new__(FlowArgs)

            __props__.__dict__["availability_zone"] = availability_zone
            __props__.__dict__["maintenance"] = maintenance
            __props__.__dict__["media_streams"] = media_streams
            __props__.__dict__["name"] = name
            if source is None and not opts.urn:
                raise TypeError("Missing required property 'source'")
            __props__.__dict__["source"] = source
            __props__.__dict__["source_failover_config"] = source_failover_config
            __props__.__dict__["source_monitoring_config"] = source_monitoring_config
            __props__.__dict__["vpc_interfaces"] = vpc_interfaces
            __props__.__dict__["egress_ip"] = None
            __props__.__dict__["flow_arn"] = None
            __props__.__dict__["flow_availability_zone"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["availabilityZone", "name", "source.name"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Flow, __self__).__init__(
            'aws-native:mediaconnect:Flow',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Flow':
        """
        Get an existing Flow resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = FlowArgs.__new__(FlowArgs)

        __props__.__dict__["availability_zone"] = None
        __props__.__dict__["egress_ip"] = None
        __props__.__dict__["flow_arn"] = None
        __props__.__dict__["flow_availability_zone"] = None
        __props__.__dict__["maintenance"] = None
        __props__.__dict__["media_streams"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["source"] = None
        __props__.__dict__["source_failover_config"] = None
        __props__.__dict__["source_monitoring_config"] = None
        __props__.__dict__["vpc_interfaces"] = None
        return Flow(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> pulumi.Output[Optional[str]]:
        """
        The Availability Zone that you want to create the flow in. These options are limited to the Availability Zones within the current AWS.
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter(name="egressIp")
    def egress_ip(self) -> pulumi.Output[str]:
        """
        The IP address from which video will be sent to output destinations.
        """
        return pulumi.get(self, "egress_ip")

    @property
    @pulumi.getter(name="flowArn")
    def flow_arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN), a unique identifier for any AWS resource, of the flow.
        """
        return pulumi.get(self, "flow_arn")

    @property
    @pulumi.getter(name="flowAvailabilityZone")
    def flow_availability_zone(self) -> pulumi.Output[str]:
        """
        The Availability Zone that you want to create the flow in. These options are limited to the Availability Zones within the current AWS.(ReadOnly)
        """
        return pulumi.get(self, "flow_availability_zone")

    @property
    @pulumi.getter
    def maintenance(self) -> pulumi.Output[Optional['outputs.FlowMaintenance']]:
        """
        The maintenance settings you want to use for the flow.
        """
        return pulumi.get(self, "maintenance")

    @property
    @pulumi.getter(name="mediaStreams")
    def media_streams(self) -> pulumi.Output[Optional[Sequence['outputs.FlowMediaStream']]]:
        """
        The media streams associated with the flow. You can associate any of these media streams with sources and outputs on the flow.
        """
        return pulumi.get(self, "media_streams")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the flow.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def source(self) -> pulumi.Output['outputs.FlowSource']:
        """
        The source of the flow.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter(name="sourceFailoverConfig")
    def source_failover_config(self) -> pulumi.Output[Optional['outputs.FlowFailoverConfig']]:
        """
        The source failover config of the flow.
        """
        return pulumi.get(self, "source_failover_config")

    @property
    @pulumi.getter(name="sourceMonitoringConfig")
    def source_monitoring_config(self) -> pulumi.Output[Optional['outputs.FlowSourceMonitoringConfig']]:
        """
        The source monitoring config of the flow.
        """
        return pulumi.get(self, "source_monitoring_config")

    @property
    @pulumi.getter(name="vpcInterfaces")
    def vpc_interfaces(self) -> pulumi.Output[Optional[Sequence['outputs.FlowVpcInterface']]]:
        """
        The VPC interfaces that you added to this flow.
        """
        return pulumi.get(self, "vpc_interfaces")

