# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['BridgeArgs', 'Bridge']

@pulumi.input_type
class BridgeArgs:
    def __init__(__self__, *,
                 placement_arn: pulumi.Input[str],
                 sources: pulumi.Input[Sequence[pulumi.Input['BridgeSourceArgs']]],
                 egress_gateway_bridge: Optional[pulumi.Input['BridgeEgressGatewayBridgeArgs']] = None,
                 ingress_gateway_bridge: Optional[pulumi.Input['BridgeIngressGatewayBridgeArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 outputs: Optional[pulumi.Input[Sequence[pulumi.Input['BridgeOutputArgs']]]] = None,
                 source_failover_config: Optional[pulumi.Input['BridgeFailoverConfigArgs']] = None):
        """
        The set of arguments for constructing a Bridge resource.
        :param pulumi.Input[str] placement_arn: The placement Amazon Resource Number (ARN) of the bridge.
        :param pulumi.Input[Sequence[pulumi.Input['BridgeSourceArgs']]] sources: The sources on this bridge.
        :param pulumi.Input['BridgeEgressGatewayBridgeArgs'] egress_gateway_bridge: Create a bridge with the egress bridge type. An egress bridge is a cloud-to-ground bridge. The content comes from an existing MediaConnect flow and is delivered to your premises.
        :param pulumi.Input['BridgeIngressGatewayBridgeArgs'] ingress_gateway_bridge: Create a bridge with the ingress bridge type. An ingress bridge is a ground-to-cloud bridge. The content originates at your premises and is delivered to the cloud.
        :param pulumi.Input[str] name: The name of the bridge.
        :param pulumi.Input[Sequence[pulumi.Input['BridgeOutputArgs']]] outputs: The outputs on this bridge.
        :param pulumi.Input['BridgeFailoverConfigArgs'] source_failover_config: The settings for source failover.
        """
        pulumi.set(__self__, "placement_arn", placement_arn)
        pulumi.set(__self__, "sources", sources)
        if egress_gateway_bridge is not None:
            pulumi.set(__self__, "egress_gateway_bridge", egress_gateway_bridge)
        if ingress_gateway_bridge is not None:
            pulumi.set(__self__, "ingress_gateway_bridge", ingress_gateway_bridge)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if outputs is not None:
            pulumi.set(__self__, "outputs", outputs)
        if source_failover_config is not None:
            pulumi.set(__self__, "source_failover_config", source_failover_config)

    @property
    @pulumi.getter(name="placementArn")
    def placement_arn(self) -> pulumi.Input[str]:
        """
        The placement Amazon Resource Number (ARN) of the bridge.
        """
        return pulumi.get(self, "placement_arn")

    @placement_arn.setter
    def placement_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "placement_arn", value)

    @property
    @pulumi.getter
    def sources(self) -> pulumi.Input[Sequence[pulumi.Input['BridgeSourceArgs']]]:
        """
        The sources on this bridge.
        """
        return pulumi.get(self, "sources")

    @sources.setter
    def sources(self, value: pulumi.Input[Sequence[pulumi.Input['BridgeSourceArgs']]]):
        pulumi.set(self, "sources", value)

    @property
    @pulumi.getter(name="egressGatewayBridge")
    def egress_gateway_bridge(self) -> Optional[pulumi.Input['BridgeEgressGatewayBridgeArgs']]:
        """
        Create a bridge with the egress bridge type. An egress bridge is a cloud-to-ground bridge. The content comes from an existing MediaConnect flow and is delivered to your premises.
        """
        return pulumi.get(self, "egress_gateway_bridge")

    @egress_gateway_bridge.setter
    def egress_gateway_bridge(self, value: Optional[pulumi.Input['BridgeEgressGatewayBridgeArgs']]):
        pulumi.set(self, "egress_gateway_bridge", value)

    @property
    @pulumi.getter(name="ingressGatewayBridge")
    def ingress_gateway_bridge(self) -> Optional[pulumi.Input['BridgeIngressGatewayBridgeArgs']]:
        """
        Create a bridge with the ingress bridge type. An ingress bridge is a ground-to-cloud bridge. The content originates at your premises and is delivered to the cloud.
        """
        return pulumi.get(self, "ingress_gateway_bridge")

    @ingress_gateway_bridge.setter
    def ingress_gateway_bridge(self, value: Optional[pulumi.Input['BridgeIngressGatewayBridgeArgs']]):
        pulumi.set(self, "ingress_gateway_bridge", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the bridge.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def outputs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BridgeOutputArgs']]]]:
        """
        The outputs on this bridge.
        """
        return pulumi.get(self, "outputs")

    @outputs.setter
    def outputs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BridgeOutputArgs']]]]):
        pulumi.set(self, "outputs", value)

    @property
    @pulumi.getter(name="sourceFailoverConfig")
    def source_failover_config(self) -> Optional[pulumi.Input['BridgeFailoverConfigArgs']]:
        """
        The settings for source failover.
        """
        return pulumi.get(self, "source_failover_config")

    @source_failover_config.setter
    def source_failover_config(self, value: Optional[pulumi.Input['BridgeFailoverConfigArgs']]):
        pulumi.set(self, "source_failover_config", value)


class Bridge(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 egress_gateway_bridge: Optional[pulumi.Input[Union['BridgeEgressGatewayBridgeArgs', 'BridgeEgressGatewayBridgeArgsDict']]] = None,
                 ingress_gateway_bridge: Optional[pulumi.Input[Union['BridgeIngressGatewayBridgeArgs', 'BridgeIngressGatewayBridgeArgsDict']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 outputs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BridgeOutputArgs', 'BridgeOutputArgsDict']]]]] = None,
                 placement_arn: Optional[pulumi.Input[str]] = None,
                 source_failover_config: Optional[pulumi.Input[Union['BridgeFailoverConfigArgs', 'BridgeFailoverConfigArgsDict']]] = None,
                 sources: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BridgeSourceArgs', 'BridgeSourceArgsDict']]]]] = None,
                 __props__=None):
        """
        Resource schema for AWS::MediaConnect::Bridge

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['BridgeEgressGatewayBridgeArgs', 'BridgeEgressGatewayBridgeArgsDict']] egress_gateway_bridge: Create a bridge with the egress bridge type. An egress bridge is a cloud-to-ground bridge. The content comes from an existing MediaConnect flow and is delivered to your premises.
        :param pulumi.Input[Union['BridgeIngressGatewayBridgeArgs', 'BridgeIngressGatewayBridgeArgsDict']] ingress_gateway_bridge: Create a bridge with the ingress bridge type. An ingress bridge is a ground-to-cloud bridge. The content originates at your premises and is delivered to the cloud.
        :param pulumi.Input[str] name: The name of the bridge.
        :param pulumi.Input[Sequence[pulumi.Input[Union['BridgeOutputArgs', 'BridgeOutputArgsDict']]]] outputs: The outputs on this bridge.
        :param pulumi.Input[str] placement_arn: The placement Amazon Resource Number (ARN) of the bridge.
        :param pulumi.Input[Union['BridgeFailoverConfigArgs', 'BridgeFailoverConfigArgsDict']] source_failover_config: The settings for source failover.
        :param pulumi.Input[Sequence[pulumi.Input[Union['BridgeSourceArgs', 'BridgeSourceArgsDict']]]] sources: The sources on this bridge.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BridgeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource schema for AWS::MediaConnect::Bridge

        :param str resource_name: The name of the resource.
        :param BridgeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BridgeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 egress_gateway_bridge: Optional[pulumi.Input[Union['BridgeEgressGatewayBridgeArgs', 'BridgeEgressGatewayBridgeArgsDict']]] = None,
                 ingress_gateway_bridge: Optional[pulumi.Input[Union['BridgeIngressGatewayBridgeArgs', 'BridgeIngressGatewayBridgeArgsDict']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 outputs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BridgeOutputArgs', 'BridgeOutputArgsDict']]]]] = None,
                 placement_arn: Optional[pulumi.Input[str]] = None,
                 source_failover_config: Optional[pulumi.Input[Union['BridgeFailoverConfigArgs', 'BridgeFailoverConfigArgsDict']]] = None,
                 sources: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BridgeSourceArgs', 'BridgeSourceArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BridgeArgs.__new__(BridgeArgs)

            __props__.__dict__["egress_gateway_bridge"] = egress_gateway_bridge
            __props__.__dict__["ingress_gateway_bridge"] = ingress_gateway_bridge
            __props__.__dict__["name"] = name
            __props__.__dict__["outputs"] = outputs
            if placement_arn is None and not opts.urn:
                raise TypeError("Missing required property 'placement_arn'")
            __props__.__dict__["placement_arn"] = placement_arn
            __props__.__dict__["source_failover_config"] = source_failover_config
            if sources is None and not opts.urn:
                raise TypeError("Missing required property 'sources'")
            __props__.__dict__["sources"] = sources
            __props__.__dict__["bridge_arn"] = None
            __props__.__dict__["bridge_state"] = None
        super(Bridge, __self__).__init__(
            'aws-native:mediaconnect:Bridge',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Bridge':
        """
        Get an existing Bridge resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = BridgeArgs.__new__(BridgeArgs)

        __props__.__dict__["bridge_arn"] = None
        __props__.__dict__["bridge_state"] = None
        __props__.__dict__["egress_gateway_bridge"] = None
        __props__.__dict__["ingress_gateway_bridge"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["outputs"] = None
        __props__.__dict__["placement_arn"] = None
        __props__.__dict__["source_failover_config"] = None
        __props__.__dict__["sources"] = None
        return Bridge(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="bridgeArn")
    def bridge_arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Number (ARN) of the bridge.
        """
        return pulumi.get(self, "bridge_arn")

    @property
    @pulumi.getter(name="bridgeState")
    def bridge_state(self) -> pulumi.Output['BridgeStateEnum']:
        """
        The current status of the bridge. Possible values are: ACTIVE or STANDBY.
        """
        return pulumi.get(self, "bridge_state")

    @property
    @pulumi.getter(name="egressGatewayBridge")
    def egress_gateway_bridge(self) -> pulumi.Output[Optional['outputs.BridgeEgressGatewayBridge']]:
        """
        Create a bridge with the egress bridge type. An egress bridge is a cloud-to-ground bridge. The content comes from an existing MediaConnect flow and is delivered to your premises.
        """
        return pulumi.get(self, "egress_gateway_bridge")

    @property
    @pulumi.getter(name="ingressGatewayBridge")
    def ingress_gateway_bridge(self) -> pulumi.Output[Optional['outputs.BridgeIngressGatewayBridge']]:
        """
        Create a bridge with the ingress bridge type. An ingress bridge is a ground-to-cloud bridge. The content originates at your premises and is delivered to the cloud.
        """
        return pulumi.get(self, "ingress_gateway_bridge")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the bridge.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def outputs(self) -> pulumi.Output[Optional[Sequence['outputs.BridgeOutput']]]:
        """
        The outputs on this bridge.
        """
        return pulumi.get(self, "outputs")

    @property
    @pulumi.getter(name="placementArn")
    def placement_arn(self) -> pulumi.Output[str]:
        """
        The placement Amazon Resource Number (ARN) of the bridge.
        """
        return pulumi.get(self, "placement_arn")

    @property
    @pulumi.getter(name="sourceFailoverConfig")
    def source_failover_config(self) -> pulumi.Output[Optional['outputs.BridgeFailoverConfig']]:
        """
        The settings for source failover.
        """
        return pulumi.get(self, "source_failover_config")

    @property
    @pulumi.getter
    def sources(self) -> pulumi.Output[Sequence['outputs.BridgeSource']]:
        """
        The sources on this bridge.
        """
        return pulumi.get(self, "sources")

