# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'BridgeEgressGatewayBridgeArgs',
    'BridgeEgressGatewayBridgeArgsDict',
    'BridgeFailoverConfigArgs',
    'BridgeFailoverConfigArgsDict',
    'BridgeFlowSourceArgs',
    'BridgeFlowSourceArgsDict',
    'BridgeIngressGatewayBridgeArgs',
    'BridgeIngressGatewayBridgeArgsDict',
    'BridgeNetworkOutputArgs',
    'BridgeNetworkOutputArgsDict',
    'BridgeNetworkSourceArgs',
    'BridgeNetworkSourceArgsDict',
    'BridgeOutputResourceBridgeNetworkOutputArgs',
    'BridgeOutputResourceBridgeNetworkOutputArgsDict',
    'BridgeOutputArgs',
    'BridgeOutputArgsDict',
    'BridgeSourceBridgeFlowSourceArgs',
    'BridgeSourceBridgeFlowSourceArgsDict',
    'BridgeSourceBridgeNetworkSourceArgs',
    'BridgeSourceBridgeNetworkSourceArgsDict',
    'BridgeSourcePriorityArgs',
    'BridgeSourcePriorityArgsDict',
    'BridgeSourceVpcInterfaceAttachmentArgs',
    'BridgeSourceVpcInterfaceAttachmentArgsDict',
    'BridgeSourceArgs',
    'BridgeSourceArgsDict',
    'BridgeVpcInterfaceAttachmentArgs',
    'BridgeVpcInterfaceAttachmentArgsDict',
    'FlowEncryptionArgs',
    'FlowEncryptionArgsDict',
    'FlowEntitlementEncryptionArgs',
    'FlowEntitlementEncryptionArgsDict',
    'FlowFailoverConfigSourcePriorityPropertiesArgs',
    'FlowFailoverConfigSourcePriorityPropertiesArgsDict',
    'FlowFailoverConfigArgs',
    'FlowFailoverConfigArgsDict',
    'FlowFmtpArgs',
    'FlowFmtpArgsDict',
    'FlowGatewayBridgeSourceArgs',
    'FlowGatewayBridgeSourceArgsDict',
    'FlowInputConfigurationArgs',
    'FlowInputConfigurationArgsDict',
    'FlowInterfaceArgs',
    'FlowInterfaceArgsDict',
    'FlowMaintenanceArgs',
    'FlowMaintenanceArgsDict',
    'FlowMediaStreamAttributesArgs',
    'FlowMediaStreamAttributesArgsDict',
    'FlowMediaStreamSourceConfigurationArgs',
    'FlowMediaStreamSourceConfigurationArgsDict',
    'FlowMediaStreamArgs',
    'FlowMediaStreamArgsDict',
    'FlowOutputDestinationConfigurationArgs',
    'FlowOutputDestinationConfigurationArgsDict',
    'FlowOutputEncodingParametersArgs',
    'FlowOutputEncodingParametersArgsDict',
    'FlowOutputEncryptionArgs',
    'FlowOutputEncryptionArgsDict',
    'FlowOutputInterfaceArgs',
    'FlowOutputInterfaceArgsDict',
    'FlowOutputMediaStreamOutputConfigurationArgs',
    'FlowOutputMediaStreamOutputConfigurationArgsDict',
    'FlowOutputVpcInterfaceAttachmentArgs',
    'FlowOutputVpcInterfaceAttachmentArgsDict',
    'FlowSourceEncryptionArgs',
    'FlowSourceEncryptionArgsDict',
    'FlowSourceGatewayBridgeSourceArgs',
    'FlowSourceGatewayBridgeSourceArgsDict',
    'FlowSourceMonitoringConfigArgs',
    'FlowSourceMonitoringConfigArgsDict',
    'FlowSourceVpcInterfaceAttachmentArgs',
    'FlowSourceVpcInterfaceAttachmentArgsDict',
    'FlowSourceArgs',
    'FlowSourceArgsDict',
    'FlowVpcInterfaceAttachmentArgs',
    'FlowVpcInterfaceAttachmentArgsDict',
    'FlowVpcInterfaceArgs',
    'FlowVpcInterfaceArgsDict',
    'GatewayNetworkArgs',
    'GatewayNetworkArgsDict',
]

MYPY = False

if not MYPY:
    class BridgeEgressGatewayBridgeArgsDict(TypedDict):
        max_bitrate: pulumi.Input[int]
        """
        The maximum expected bitrate of the egress bridge.
        """
elif False:
    BridgeEgressGatewayBridgeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class BridgeEgressGatewayBridgeArgs:
    def __init__(__self__, *,
                 max_bitrate: pulumi.Input[int]):
        """
        :param pulumi.Input[int] max_bitrate: The maximum expected bitrate of the egress bridge.
        """
        pulumi.set(__self__, "max_bitrate", max_bitrate)

    @property
    @pulumi.getter(name="maxBitrate")
    def max_bitrate(self) -> pulumi.Input[int]:
        """
        The maximum expected bitrate of the egress bridge.
        """
        return pulumi.get(self, "max_bitrate")

    @max_bitrate.setter
    def max_bitrate(self, value: pulumi.Input[int]):
        pulumi.set(self, "max_bitrate", value)


if not MYPY:
    class BridgeFailoverConfigArgsDict(TypedDict):
        """
        The settings for source failover.
        """
        failover_mode: pulumi.Input['BridgeFailoverModeEnum']
        """
        The type of failover you choose for this flow. FAILOVER allows switching between different streams.
        """
        source_priority: NotRequired[pulumi.Input['BridgeSourcePriorityArgsDict']]
        """
        The priority you want to assign to a source. You can have a primary stream and a backup stream or two equally prioritized streams.
        """
        state: NotRequired[pulumi.Input['BridgeFailoverConfigStateEnum']]
        """
        The state of source failover on the flow. If the state is inactive, the flow can have only one source. If the state is active, the flow can have one or two sources.
        """
elif False:
    BridgeFailoverConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class BridgeFailoverConfigArgs:
    def __init__(__self__, *,
                 failover_mode: pulumi.Input['BridgeFailoverModeEnum'],
                 source_priority: Optional[pulumi.Input['BridgeSourcePriorityArgs']] = None,
                 state: Optional[pulumi.Input['BridgeFailoverConfigStateEnum']] = None):
        """
        The settings for source failover.
        :param pulumi.Input['BridgeFailoverModeEnum'] failover_mode: The type of failover you choose for this flow. FAILOVER allows switching between different streams.
        :param pulumi.Input['BridgeSourcePriorityArgs'] source_priority: The priority you want to assign to a source. You can have a primary stream and a backup stream or two equally prioritized streams.
        :param pulumi.Input['BridgeFailoverConfigStateEnum'] state: The state of source failover on the flow. If the state is inactive, the flow can have only one source. If the state is active, the flow can have one or two sources.
        """
        pulumi.set(__self__, "failover_mode", failover_mode)
        if source_priority is not None:
            pulumi.set(__self__, "source_priority", source_priority)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="failoverMode")
    def failover_mode(self) -> pulumi.Input['BridgeFailoverModeEnum']:
        """
        The type of failover you choose for this flow. FAILOVER allows switching between different streams.
        """
        return pulumi.get(self, "failover_mode")

    @failover_mode.setter
    def failover_mode(self, value: pulumi.Input['BridgeFailoverModeEnum']):
        pulumi.set(self, "failover_mode", value)

    @property
    @pulumi.getter(name="sourcePriority")
    def source_priority(self) -> Optional[pulumi.Input['BridgeSourcePriorityArgs']]:
        """
        The priority you want to assign to a source. You can have a primary stream and a backup stream or two equally prioritized streams.
        """
        return pulumi.get(self, "source_priority")

    @source_priority.setter
    def source_priority(self, value: Optional[pulumi.Input['BridgeSourcePriorityArgs']]):
        pulumi.set(self, "source_priority", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input['BridgeFailoverConfigStateEnum']]:
        """
        The state of source failover on the flow. If the state is inactive, the flow can have only one source. If the state is active, the flow can have one or two sources.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input['BridgeFailoverConfigStateEnum']]):
        pulumi.set(self, "state", value)


if not MYPY:
    class BridgeFlowSourceArgsDict(TypedDict):
        """
        The source of the bridge. A flow source originates in MediaConnect as an existing cloud flow.
        """
        flow_arn: pulumi.Input[str]
        """
        The ARN of the cloud flow used as a source of this bridge.
        """
        name: pulumi.Input[str]
        """
        The name of the flow source.
        """
        flow_vpc_interface_attachment: NotRequired[pulumi.Input['BridgeVpcInterfaceAttachmentArgsDict']]
        """
        The name of the VPC interface attachment to use for this source.
        """
elif False:
    BridgeFlowSourceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class BridgeFlowSourceArgs:
    def __init__(__self__, *,
                 flow_arn: pulumi.Input[str],
                 name: pulumi.Input[str],
                 flow_vpc_interface_attachment: Optional[pulumi.Input['BridgeVpcInterfaceAttachmentArgs']] = None):
        """
        The source of the bridge. A flow source originates in MediaConnect as an existing cloud flow.
        :param pulumi.Input[str] flow_arn: The ARN of the cloud flow used as a source of this bridge.
        :param pulumi.Input[str] name: The name of the flow source.
        :param pulumi.Input['BridgeVpcInterfaceAttachmentArgs'] flow_vpc_interface_attachment: The name of the VPC interface attachment to use for this source.
        """
        pulumi.set(__self__, "flow_arn", flow_arn)
        pulumi.set(__self__, "name", name)
        if flow_vpc_interface_attachment is not None:
            pulumi.set(__self__, "flow_vpc_interface_attachment", flow_vpc_interface_attachment)

    @property
    @pulumi.getter(name="flowArn")
    def flow_arn(self) -> pulumi.Input[str]:
        """
        The ARN of the cloud flow used as a source of this bridge.
        """
        return pulumi.get(self, "flow_arn")

    @flow_arn.setter
    def flow_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "flow_arn", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the flow source.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="flowVpcInterfaceAttachment")
    def flow_vpc_interface_attachment(self) -> Optional[pulumi.Input['BridgeVpcInterfaceAttachmentArgs']]:
        """
        The name of the VPC interface attachment to use for this source.
        """
        return pulumi.get(self, "flow_vpc_interface_attachment")

    @flow_vpc_interface_attachment.setter
    def flow_vpc_interface_attachment(self, value: Optional[pulumi.Input['BridgeVpcInterfaceAttachmentArgs']]):
        pulumi.set(self, "flow_vpc_interface_attachment", value)


if not MYPY:
    class BridgeIngressGatewayBridgeArgsDict(TypedDict):
        max_bitrate: pulumi.Input[int]
        """
        The maximum expected bitrate of the ingress bridge.
        """
        max_outputs: pulumi.Input[int]
        """
        The maximum number of outputs on the ingress bridge.
        """
elif False:
    BridgeIngressGatewayBridgeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class BridgeIngressGatewayBridgeArgs:
    def __init__(__self__, *,
                 max_bitrate: pulumi.Input[int],
                 max_outputs: pulumi.Input[int]):
        """
        :param pulumi.Input[int] max_bitrate: The maximum expected bitrate of the ingress bridge.
        :param pulumi.Input[int] max_outputs: The maximum number of outputs on the ingress bridge.
        """
        pulumi.set(__self__, "max_bitrate", max_bitrate)
        pulumi.set(__self__, "max_outputs", max_outputs)

    @property
    @pulumi.getter(name="maxBitrate")
    def max_bitrate(self) -> pulumi.Input[int]:
        """
        The maximum expected bitrate of the ingress bridge.
        """
        return pulumi.get(self, "max_bitrate")

    @max_bitrate.setter
    def max_bitrate(self, value: pulumi.Input[int]):
        pulumi.set(self, "max_bitrate", value)

    @property
    @pulumi.getter(name="maxOutputs")
    def max_outputs(self) -> pulumi.Input[int]:
        """
        The maximum number of outputs on the ingress bridge.
        """
        return pulumi.get(self, "max_outputs")

    @max_outputs.setter
    def max_outputs(self, value: pulumi.Input[int]):
        pulumi.set(self, "max_outputs", value)


if not MYPY:
    class BridgeNetworkOutputArgsDict(TypedDict):
        """
        The output of the bridge. A network output is delivered to your premises.
        """
        ip_address: pulumi.Input[str]
        """
        The network output IP Address.
        """
        name: pulumi.Input[str]
        """
        The network output name.
        """
        network_name: pulumi.Input[str]
        """
        The network output's gateway network name.
        """
        port: pulumi.Input[int]
        """
        The network output port.
        """
        protocol: pulumi.Input['BridgeProtocolEnum']
        """
        The network output protocol.
        """
        ttl: pulumi.Input[int]
        """
        The network output TTL.
        """
elif False:
    BridgeNetworkOutputArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class BridgeNetworkOutputArgs:
    def __init__(__self__, *,
                 ip_address: pulumi.Input[str],
                 name: pulumi.Input[str],
                 network_name: pulumi.Input[str],
                 port: pulumi.Input[int],
                 protocol: pulumi.Input['BridgeProtocolEnum'],
                 ttl: pulumi.Input[int]):
        """
        The output of the bridge. A network output is delivered to your premises.
        :param pulumi.Input[str] ip_address: The network output IP Address.
        :param pulumi.Input[str] name: The network output name.
        :param pulumi.Input[str] network_name: The network output's gateway network name.
        :param pulumi.Input[int] port: The network output port.
        :param pulumi.Input['BridgeProtocolEnum'] protocol: The network output protocol.
        :param pulumi.Input[int] ttl: The network output TTL.
        """
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "network_name", network_name)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "ttl", ttl)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> pulumi.Input[str]:
        """
        The network output IP Address.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: pulumi.Input[str]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The network output name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkName")
    def network_name(self) -> pulumi.Input[str]:
        """
        The network output's gateway network name.
        """
        return pulumi.get(self, "network_name")

    @network_name.setter
    def network_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "network_name", value)

    @property
    @pulumi.getter
    def port(self) -> pulumi.Input[int]:
        """
        The network output port.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[int]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Input['BridgeProtocolEnum']:
        """
        The network output protocol.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input['BridgeProtocolEnum']):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter
    def ttl(self) -> pulumi.Input[int]:
        """
        The network output TTL.
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: pulumi.Input[int]):
        pulumi.set(self, "ttl", value)


if not MYPY:
    class BridgeNetworkSourceArgsDict(TypedDict):
        """
        The source of the bridge. A network source originates at your premises.
        """
        multicast_ip: pulumi.Input[str]
        """
        The network source multicast IP.
        """
        name: pulumi.Input[str]
        """
        The name of the network source.
        """
        network_name: pulumi.Input[str]
        """
        The network source's gateway network name.
        """
        port: pulumi.Input[int]
        """
        The network source port.
        """
        protocol: pulumi.Input['BridgeProtocolEnum']
        """
        The network source protocol.
        """
elif False:
    BridgeNetworkSourceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class BridgeNetworkSourceArgs:
    def __init__(__self__, *,
                 multicast_ip: pulumi.Input[str],
                 name: pulumi.Input[str],
                 network_name: pulumi.Input[str],
                 port: pulumi.Input[int],
                 protocol: pulumi.Input['BridgeProtocolEnum']):
        """
        The source of the bridge. A network source originates at your premises.
        :param pulumi.Input[str] multicast_ip: The network source multicast IP.
        :param pulumi.Input[str] name: The name of the network source.
        :param pulumi.Input[str] network_name: The network source's gateway network name.
        :param pulumi.Input[int] port: The network source port.
        :param pulumi.Input['BridgeProtocolEnum'] protocol: The network source protocol.
        """
        pulumi.set(__self__, "multicast_ip", multicast_ip)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "network_name", network_name)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter(name="multicastIp")
    def multicast_ip(self) -> pulumi.Input[str]:
        """
        The network source multicast IP.
        """
        return pulumi.get(self, "multicast_ip")

    @multicast_ip.setter
    def multicast_ip(self, value: pulumi.Input[str]):
        pulumi.set(self, "multicast_ip", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the network source.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkName")
    def network_name(self) -> pulumi.Input[str]:
        """
        The network source's gateway network name.
        """
        return pulumi.get(self, "network_name")

    @network_name.setter
    def network_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "network_name", value)

    @property
    @pulumi.getter
    def port(self) -> pulumi.Input[int]:
        """
        The network source port.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[int]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Input['BridgeProtocolEnum']:
        """
        The network source protocol.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input['BridgeProtocolEnum']):
        pulumi.set(self, "protocol", value)


if not MYPY:
    class BridgeOutputResourceBridgeNetworkOutputArgsDict(TypedDict):
        """
        The output of the bridge. A network output is delivered to your premises.
        """
        ip_address: pulumi.Input[str]
        """
        The network output IP Address.
        """
        network_name: pulumi.Input[str]
        """
        The network output's gateway network name.
        """
        port: pulumi.Input[int]
        """
        The network output port.
        """
        protocol: pulumi.Input['BridgeOutputResourceBridgeNetworkOutputProtocol']
        """
        The network output protocol.
        """
        ttl: pulumi.Input[int]
        """
        The network output TTL.
        """
elif False:
    BridgeOutputResourceBridgeNetworkOutputArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class BridgeOutputResourceBridgeNetworkOutputArgs:
    def __init__(__self__, *,
                 ip_address: pulumi.Input[str],
                 network_name: pulumi.Input[str],
                 port: pulumi.Input[int],
                 protocol: pulumi.Input['BridgeOutputResourceBridgeNetworkOutputProtocol'],
                 ttl: pulumi.Input[int]):
        """
        The output of the bridge. A network output is delivered to your premises.
        :param pulumi.Input[str] ip_address: The network output IP Address.
        :param pulumi.Input[str] network_name: The network output's gateway network name.
        :param pulumi.Input[int] port: The network output port.
        :param pulumi.Input['BridgeOutputResourceBridgeNetworkOutputProtocol'] protocol: The network output protocol.
        :param pulumi.Input[int] ttl: The network output TTL.
        """
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "network_name", network_name)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "ttl", ttl)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> pulumi.Input[str]:
        """
        The network output IP Address.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: pulumi.Input[str]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter(name="networkName")
    def network_name(self) -> pulumi.Input[str]:
        """
        The network output's gateway network name.
        """
        return pulumi.get(self, "network_name")

    @network_name.setter
    def network_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "network_name", value)

    @property
    @pulumi.getter
    def port(self) -> pulumi.Input[int]:
        """
        The network output port.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[int]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Input['BridgeOutputResourceBridgeNetworkOutputProtocol']:
        """
        The network output protocol.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input['BridgeOutputResourceBridgeNetworkOutputProtocol']):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter
    def ttl(self) -> pulumi.Input[int]:
        """
        The network output TTL.
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: pulumi.Input[int]):
        pulumi.set(self, "ttl", value)


if not MYPY:
    class BridgeOutputArgsDict(TypedDict):
        """
        The output of the bridge.
        """
        network_output: NotRequired[pulumi.Input['BridgeNetworkOutputArgsDict']]
        """
        The output of the bridge. A network output is delivered to your premises.
        """
elif False:
    BridgeOutputArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class BridgeOutputArgs:
    def __init__(__self__, *,
                 network_output: Optional[pulumi.Input['BridgeNetworkOutputArgs']] = None):
        """
        The output of the bridge.
        :param pulumi.Input['BridgeNetworkOutputArgs'] network_output: The output of the bridge. A network output is delivered to your premises.
        """
        if network_output is not None:
            pulumi.set(__self__, "network_output", network_output)

    @property
    @pulumi.getter(name="networkOutput")
    def network_output(self) -> Optional[pulumi.Input['BridgeNetworkOutputArgs']]:
        """
        The output of the bridge. A network output is delivered to your premises.
        """
        return pulumi.get(self, "network_output")

    @network_output.setter
    def network_output(self, value: Optional[pulumi.Input['BridgeNetworkOutputArgs']]):
        pulumi.set(self, "network_output", value)


if not MYPY:
    class BridgeSourceBridgeFlowSourceArgsDict(TypedDict):
        """
        The source of the bridge. A flow source originates in MediaConnect as an existing cloud flow.
        """
        flow_arn: pulumi.Input[str]
        """
        The ARN of the cloud flow used as a source of this bridge.
        """
        flow_vpc_interface_attachment: NotRequired[pulumi.Input['BridgeSourceVpcInterfaceAttachmentArgsDict']]
        """
        The name of the VPC interface attachment to use for this source.
        """
elif False:
    BridgeSourceBridgeFlowSourceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class BridgeSourceBridgeFlowSourceArgs:
    def __init__(__self__, *,
                 flow_arn: pulumi.Input[str],
                 flow_vpc_interface_attachment: Optional[pulumi.Input['BridgeSourceVpcInterfaceAttachmentArgs']] = None):
        """
        The source of the bridge. A flow source originates in MediaConnect as an existing cloud flow.
        :param pulumi.Input[str] flow_arn: The ARN of the cloud flow used as a source of this bridge.
        :param pulumi.Input['BridgeSourceVpcInterfaceAttachmentArgs'] flow_vpc_interface_attachment: The name of the VPC interface attachment to use for this source.
        """
        pulumi.set(__self__, "flow_arn", flow_arn)
        if flow_vpc_interface_attachment is not None:
            pulumi.set(__self__, "flow_vpc_interface_attachment", flow_vpc_interface_attachment)

    @property
    @pulumi.getter(name="flowArn")
    def flow_arn(self) -> pulumi.Input[str]:
        """
        The ARN of the cloud flow used as a source of this bridge.
        """
        return pulumi.get(self, "flow_arn")

    @flow_arn.setter
    def flow_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "flow_arn", value)

    @property
    @pulumi.getter(name="flowVpcInterfaceAttachment")
    def flow_vpc_interface_attachment(self) -> Optional[pulumi.Input['BridgeSourceVpcInterfaceAttachmentArgs']]:
        """
        The name of the VPC interface attachment to use for this source.
        """
        return pulumi.get(self, "flow_vpc_interface_attachment")

    @flow_vpc_interface_attachment.setter
    def flow_vpc_interface_attachment(self, value: Optional[pulumi.Input['BridgeSourceVpcInterfaceAttachmentArgs']]):
        pulumi.set(self, "flow_vpc_interface_attachment", value)


if not MYPY:
    class BridgeSourceBridgeNetworkSourceArgsDict(TypedDict):
        """
        The source of the bridge. A network source originates at your premises.
        """
        multicast_ip: pulumi.Input[str]
        """
        The network source multicast IP.
        """
        network_name: pulumi.Input[str]
        """
        The network source's gateway network name.
        """
        port: pulumi.Input[int]
        """
        The network source port.
        """
        protocol: pulumi.Input['BridgeSourceProtocolEnum']
        """
        The network source protocol.
        """
elif False:
    BridgeSourceBridgeNetworkSourceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class BridgeSourceBridgeNetworkSourceArgs:
    def __init__(__self__, *,
                 multicast_ip: pulumi.Input[str],
                 network_name: pulumi.Input[str],
                 port: pulumi.Input[int],
                 protocol: pulumi.Input['BridgeSourceProtocolEnum']):
        """
        The source of the bridge. A network source originates at your premises.
        :param pulumi.Input[str] multicast_ip: The network source multicast IP.
        :param pulumi.Input[str] network_name: The network source's gateway network name.
        :param pulumi.Input[int] port: The network source port.
        :param pulumi.Input['BridgeSourceProtocolEnum'] protocol: The network source protocol.
        """
        pulumi.set(__self__, "multicast_ip", multicast_ip)
        pulumi.set(__self__, "network_name", network_name)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter(name="multicastIp")
    def multicast_ip(self) -> pulumi.Input[str]:
        """
        The network source multicast IP.
        """
        return pulumi.get(self, "multicast_ip")

    @multicast_ip.setter
    def multicast_ip(self, value: pulumi.Input[str]):
        pulumi.set(self, "multicast_ip", value)

    @property
    @pulumi.getter(name="networkName")
    def network_name(self) -> pulumi.Input[str]:
        """
        The network source's gateway network name.
        """
        return pulumi.get(self, "network_name")

    @network_name.setter
    def network_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "network_name", value)

    @property
    @pulumi.getter
    def port(self) -> pulumi.Input[int]:
        """
        The network source port.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[int]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Input['BridgeSourceProtocolEnum']:
        """
        The network source protocol.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input['BridgeSourceProtocolEnum']):
        pulumi.set(self, "protocol", value)


if not MYPY:
    class BridgeSourcePriorityArgsDict(TypedDict):
        """
        The priority you want to assign to a source. You can have a primary stream and a backup stream or two equally prioritized streams.
        """
        primary_source: NotRequired[pulumi.Input[str]]
        """
        The name of the source you choose as the primary source for this flow.
        """
elif False:
    BridgeSourcePriorityArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class BridgeSourcePriorityArgs:
    def __init__(__self__, *,
                 primary_source: Optional[pulumi.Input[str]] = None):
        """
        The priority you want to assign to a source. You can have a primary stream and a backup stream or two equally prioritized streams.
        :param pulumi.Input[str] primary_source: The name of the source you choose as the primary source for this flow.
        """
        if primary_source is not None:
            pulumi.set(__self__, "primary_source", primary_source)

    @property
    @pulumi.getter(name="primarySource")
    def primary_source(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the source you choose as the primary source for this flow.
        """
        return pulumi.get(self, "primary_source")

    @primary_source.setter
    def primary_source(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "primary_source", value)


if not MYPY:
    class BridgeSourceVpcInterfaceAttachmentArgsDict(TypedDict):
        """
        The settings for attaching a VPC interface to an resource.
        """
        vpc_interface_name: NotRequired[pulumi.Input[str]]
        """
        The name of the VPC interface to use for this resource.
        """
elif False:
    BridgeSourceVpcInterfaceAttachmentArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class BridgeSourceVpcInterfaceAttachmentArgs:
    def __init__(__self__, *,
                 vpc_interface_name: Optional[pulumi.Input[str]] = None):
        """
        The settings for attaching a VPC interface to an resource.
        :param pulumi.Input[str] vpc_interface_name: The name of the VPC interface to use for this resource.
        """
        if vpc_interface_name is not None:
            pulumi.set(__self__, "vpc_interface_name", vpc_interface_name)

    @property
    @pulumi.getter(name="vpcInterfaceName")
    def vpc_interface_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the VPC interface to use for this resource.
        """
        return pulumi.get(self, "vpc_interface_name")

    @vpc_interface_name.setter
    def vpc_interface_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_interface_name", value)


if not MYPY:
    class BridgeSourceArgsDict(TypedDict):
        """
        The bridge's source.
        """
        flow_source: NotRequired[pulumi.Input['BridgeFlowSourceArgsDict']]
        """
        The source of the bridge. A flow source originates in MediaConnect as an existing cloud flow.
        """
        network_source: NotRequired[pulumi.Input['BridgeNetworkSourceArgsDict']]
        """
        The source of the bridge. A network source originates at your premises.
        """
elif False:
    BridgeSourceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class BridgeSourceArgs:
    def __init__(__self__, *,
                 flow_source: Optional[pulumi.Input['BridgeFlowSourceArgs']] = None,
                 network_source: Optional[pulumi.Input['BridgeNetworkSourceArgs']] = None):
        """
        The bridge's source.
        :param pulumi.Input['BridgeFlowSourceArgs'] flow_source: The source of the bridge. A flow source originates in MediaConnect as an existing cloud flow.
        :param pulumi.Input['BridgeNetworkSourceArgs'] network_source: The source of the bridge. A network source originates at your premises.
        """
        if flow_source is not None:
            pulumi.set(__self__, "flow_source", flow_source)
        if network_source is not None:
            pulumi.set(__self__, "network_source", network_source)

    @property
    @pulumi.getter(name="flowSource")
    def flow_source(self) -> Optional[pulumi.Input['BridgeFlowSourceArgs']]:
        """
        The source of the bridge. A flow source originates in MediaConnect as an existing cloud flow.
        """
        return pulumi.get(self, "flow_source")

    @flow_source.setter
    def flow_source(self, value: Optional[pulumi.Input['BridgeFlowSourceArgs']]):
        pulumi.set(self, "flow_source", value)

    @property
    @pulumi.getter(name="networkSource")
    def network_source(self) -> Optional[pulumi.Input['BridgeNetworkSourceArgs']]:
        """
        The source of the bridge. A network source originates at your premises.
        """
        return pulumi.get(self, "network_source")

    @network_source.setter
    def network_source(self, value: Optional[pulumi.Input['BridgeNetworkSourceArgs']]):
        pulumi.set(self, "network_source", value)


if not MYPY:
    class BridgeVpcInterfaceAttachmentArgsDict(TypedDict):
        """
        The settings for attaching a VPC interface to an resource.
        """
        vpc_interface_name: NotRequired[pulumi.Input[str]]
        """
        The name of the VPC interface to use for this resource.
        """
elif False:
    BridgeVpcInterfaceAttachmentArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class BridgeVpcInterfaceAttachmentArgs:
    def __init__(__self__, *,
                 vpc_interface_name: Optional[pulumi.Input[str]] = None):
        """
        The settings for attaching a VPC interface to an resource.
        :param pulumi.Input[str] vpc_interface_name: The name of the VPC interface to use for this resource.
        """
        if vpc_interface_name is not None:
            pulumi.set(__self__, "vpc_interface_name", vpc_interface_name)

    @property
    @pulumi.getter(name="vpcInterfaceName")
    def vpc_interface_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the VPC interface to use for this resource.
        """
        return pulumi.get(self, "vpc_interface_name")

    @vpc_interface_name.setter
    def vpc_interface_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_interface_name", value)


if not MYPY:
    class FlowEncryptionArgsDict(TypedDict):
        """
        Information about the encryption of the flow.
        """
        role_arn: pulumi.Input[str]
        """
        The ARN of the role that you created during setup (when you set up AWS Elemental MediaConnect as a trusted entity).
        """
        algorithm: NotRequired[pulumi.Input['FlowEncryptionAlgorithm']]
        """
        The type of algorithm that is used for the encryption (such as aes128, aes192, or aes256).
        """
        constant_initialization_vector: NotRequired[pulumi.Input[str]]
        """
        A 128-bit, 16-byte hex value represented by a 32-character string, to be used with the key for encrypting content. This parameter is not valid for static key encryption.
        """
        device_id: NotRequired[pulumi.Input[str]]
        """
        The value of one of the devices that you configured with your digital rights management (DRM) platform key provider. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        key_type: NotRequired[pulumi.Input['FlowEncryptionKeyType']]
        """
        The type of key that is used for the encryption. If no keyType is provided, the service will use the default setting (static-key).
        """
        region: NotRequired[pulumi.Input[str]]
        """
        The AWS Region that the API Gateway proxy endpoint was created in. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        resource_id: NotRequired[pulumi.Input[str]]
        """
        An identifier for the content. The service sends this value to the key server to identify the current endpoint. The resource ID is also known as the content ID. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        secret_arn: NotRequired[pulumi.Input[str]]
        """
         The ARN of the secret that you created in AWS Secrets Manager to store the encryption key. This parameter is required for static key encryption and is not valid for SPEKE encryption.
        """
        url: NotRequired[pulumi.Input[str]]
        """
        The URL from the API Gateway proxy that you set up to talk to your key server. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
elif False:
    FlowEncryptionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FlowEncryptionArgs:
    def __init__(__self__, *,
                 role_arn: pulumi.Input[str],
                 algorithm: Optional[pulumi.Input['FlowEncryptionAlgorithm']] = None,
                 constant_initialization_vector: Optional[pulumi.Input[str]] = None,
                 device_id: Optional[pulumi.Input[str]] = None,
                 key_type: Optional[pulumi.Input['FlowEncryptionKeyType']] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 resource_id: Optional[pulumi.Input[str]] = None,
                 secret_arn: Optional[pulumi.Input[str]] = None,
                 url: Optional[pulumi.Input[str]] = None):
        """
        Information about the encryption of the flow.
        :param pulumi.Input[str] role_arn: The ARN of the role that you created during setup (when you set up AWS Elemental MediaConnect as a trusted entity).
        :param pulumi.Input['FlowEncryptionAlgorithm'] algorithm: The type of algorithm that is used for the encryption (such as aes128, aes192, or aes256).
        :param pulumi.Input[str] constant_initialization_vector: A 128-bit, 16-byte hex value represented by a 32-character string, to be used with the key for encrypting content. This parameter is not valid for static key encryption.
        :param pulumi.Input[str] device_id: The value of one of the devices that you configured with your digital rights management (DRM) platform key provider. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        :param pulumi.Input['FlowEncryptionKeyType'] key_type: The type of key that is used for the encryption. If no keyType is provided, the service will use the default setting (static-key).
        :param pulumi.Input[str] region: The AWS Region that the API Gateway proxy endpoint was created in. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        :param pulumi.Input[str] resource_id: An identifier for the content. The service sends this value to the key server to identify the current endpoint. The resource ID is also known as the content ID. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        :param pulumi.Input[str] secret_arn:  The ARN of the secret that you created in AWS Secrets Manager to store the encryption key. This parameter is required for static key encryption and is not valid for SPEKE encryption.
        :param pulumi.Input[str] url: The URL from the API Gateway proxy that you set up to talk to your key server. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        pulumi.set(__self__, "role_arn", role_arn)
        if algorithm is not None:
            pulumi.set(__self__, "algorithm", algorithm)
        if constant_initialization_vector is not None:
            pulumi.set(__self__, "constant_initialization_vector", constant_initialization_vector)
        if device_id is not None:
            pulumi.set(__self__, "device_id", device_id)
        if key_type is not None:
            pulumi.set(__self__, "key_type", key_type)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)
        if secret_arn is not None:
            pulumi.set(__self__, "secret_arn", secret_arn)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Input[str]:
        """
        The ARN of the role that you created during setup (when you set up AWS Elemental MediaConnect as a trusted entity).
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter
    def algorithm(self) -> Optional[pulumi.Input['FlowEncryptionAlgorithm']]:
        """
        The type of algorithm that is used for the encryption (such as aes128, aes192, or aes256).
        """
        return pulumi.get(self, "algorithm")

    @algorithm.setter
    def algorithm(self, value: Optional[pulumi.Input['FlowEncryptionAlgorithm']]):
        pulumi.set(self, "algorithm", value)

    @property
    @pulumi.getter(name="constantInitializationVector")
    def constant_initialization_vector(self) -> Optional[pulumi.Input[str]]:
        """
        A 128-bit, 16-byte hex value represented by a 32-character string, to be used with the key for encrypting content. This parameter is not valid for static key encryption.
        """
        return pulumi.get(self, "constant_initialization_vector")

    @constant_initialization_vector.setter
    def constant_initialization_vector(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "constant_initialization_vector", value)

    @property
    @pulumi.getter(name="deviceId")
    def device_id(self) -> Optional[pulumi.Input[str]]:
        """
        The value of one of the devices that you configured with your digital rights management (DRM) platform key provider. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        return pulumi.get(self, "device_id")

    @device_id.setter
    def device_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "device_id", value)

    @property
    @pulumi.getter(name="keyType")
    def key_type(self) -> Optional[pulumi.Input['FlowEncryptionKeyType']]:
        """
        The type of key that is used for the encryption. If no keyType is provided, the service will use the default setting (static-key).
        """
        return pulumi.get(self, "key_type")

    @key_type.setter
    def key_type(self, value: Optional[pulumi.Input['FlowEncryptionKeyType']]):
        pulumi.set(self, "key_type", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The AWS Region that the API Gateway proxy endpoint was created in. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        An identifier for the content. The service sends this value to the key server to identify the current endpoint. The resource ID is also known as the content ID. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)

    @property
    @pulumi.getter(name="secretArn")
    def secret_arn(self) -> Optional[pulumi.Input[str]]:
        """
         The ARN of the secret that you created in AWS Secrets Manager to store the encryption key. This parameter is required for static key encryption and is not valid for SPEKE encryption.
        """
        return pulumi.get(self, "secret_arn")

    @secret_arn.setter
    def secret_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_arn", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        The URL from the API Gateway proxy that you set up to talk to your key server. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)


if not MYPY:
    class FlowEntitlementEncryptionArgsDict(TypedDict):
        """
        Information about the encryption of the flow.
        """
        algorithm: pulumi.Input['FlowEntitlementEncryptionAlgorithm']
        """
        The type of algorithm that is used for the encryption (such as aes128, aes192, or aes256).
        """
        role_arn: pulumi.Input[str]
        """
        The ARN of the role that you created during setup (when you set up AWS Elemental MediaConnect as a trusted entity).
        """
        constant_initialization_vector: NotRequired[pulumi.Input[str]]
        """
        A 128-bit, 16-byte hex value represented by a 32-character string, to be used with the key for encrypting content. This parameter is not valid for static key encryption.
        """
        device_id: NotRequired[pulumi.Input[str]]
        """
        The value of one of the devices that you configured with your digital rights management (DRM) platform key provider. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        key_type: NotRequired[pulumi.Input['FlowEntitlementEncryptionKeyType']]
        """
        The type of key that is used for the encryption. If no keyType is provided, the service will use the default setting (static-key).
        """
        region: NotRequired[pulumi.Input[str]]
        """
        The AWS Region that the API Gateway proxy endpoint was created in. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        resource_id: NotRequired[pulumi.Input[str]]
        """
        An identifier for the content. The service sends this value to the key server to identify the current endpoint. The resource ID is also known as the content ID. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        secret_arn: NotRequired[pulumi.Input[str]]
        """
         The ARN of the secret that you created in AWS Secrets Manager to store the encryption key. This parameter is required for static key encryption and is not valid for SPEKE encryption.
        """
        url: NotRequired[pulumi.Input[str]]
        """
        The URL from the API Gateway proxy that you set up to talk to your key server. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
elif False:
    FlowEntitlementEncryptionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FlowEntitlementEncryptionArgs:
    def __init__(__self__, *,
                 algorithm: pulumi.Input['FlowEntitlementEncryptionAlgorithm'],
                 role_arn: pulumi.Input[str],
                 constant_initialization_vector: Optional[pulumi.Input[str]] = None,
                 device_id: Optional[pulumi.Input[str]] = None,
                 key_type: Optional[pulumi.Input['FlowEntitlementEncryptionKeyType']] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 resource_id: Optional[pulumi.Input[str]] = None,
                 secret_arn: Optional[pulumi.Input[str]] = None,
                 url: Optional[pulumi.Input[str]] = None):
        """
        Information about the encryption of the flow.
        :param pulumi.Input['FlowEntitlementEncryptionAlgorithm'] algorithm: The type of algorithm that is used for the encryption (such as aes128, aes192, or aes256).
        :param pulumi.Input[str] role_arn: The ARN of the role that you created during setup (when you set up AWS Elemental MediaConnect as a trusted entity).
        :param pulumi.Input[str] constant_initialization_vector: A 128-bit, 16-byte hex value represented by a 32-character string, to be used with the key for encrypting content. This parameter is not valid for static key encryption.
        :param pulumi.Input[str] device_id: The value of one of the devices that you configured with your digital rights management (DRM) platform key provider. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        :param pulumi.Input['FlowEntitlementEncryptionKeyType'] key_type: The type of key that is used for the encryption. If no keyType is provided, the service will use the default setting (static-key).
        :param pulumi.Input[str] region: The AWS Region that the API Gateway proxy endpoint was created in. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        :param pulumi.Input[str] resource_id: An identifier for the content. The service sends this value to the key server to identify the current endpoint. The resource ID is also known as the content ID. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        :param pulumi.Input[str] secret_arn:  The ARN of the secret that you created in AWS Secrets Manager to store the encryption key. This parameter is required for static key encryption and is not valid for SPEKE encryption.
        :param pulumi.Input[str] url: The URL from the API Gateway proxy that you set up to talk to your key server. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        pulumi.set(__self__, "algorithm", algorithm)
        pulumi.set(__self__, "role_arn", role_arn)
        if constant_initialization_vector is not None:
            pulumi.set(__self__, "constant_initialization_vector", constant_initialization_vector)
        if device_id is not None:
            pulumi.set(__self__, "device_id", device_id)
        if key_type is not None:
            pulumi.set(__self__, "key_type", key_type)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)
        if secret_arn is not None:
            pulumi.set(__self__, "secret_arn", secret_arn)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def algorithm(self) -> pulumi.Input['FlowEntitlementEncryptionAlgorithm']:
        """
        The type of algorithm that is used for the encryption (such as aes128, aes192, or aes256).
        """
        return pulumi.get(self, "algorithm")

    @algorithm.setter
    def algorithm(self, value: pulumi.Input['FlowEntitlementEncryptionAlgorithm']):
        pulumi.set(self, "algorithm", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Input[str]:
        """
        The ARN of the role that you created during setup (when you set up AWS Elemental MediaConnect as a trusted entity).
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter(name="constantInitializationVector")
    def constant_initialization_vector(self) -> Optional[pulumi.Input[str]]:
        """
        A 128-bit, 16-byte hex value represented by a 32-character string, to be used with the key for encrypting content. This parameter is not valid for static key encryption.
        """
        return pulumi.get(self, "constant_initialization_vector")

    @constant_initialization_vector.setter
    def constant_initialization_vector(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "constant_initialization_vector", value)

    @property
    @pulumi.getter(name="deviceId")
    def device_id(self) -> Optional[pulumi.Input[str]]:
        """
        The value of one of the devices that you configured with your digital rights management (DRM) platform key provider. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        return pulumi.get(self, "device_id")

    @device_id.setter
    def device_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "device_id", value)

    @property
    @pulumi.getter(name="keyType")
    def key_type(self) -> Optional[pulumi.Input['FlowEntitlementEncryptionKeyType']]:
        """
        The type of key that is used for the encryption. If no keyType is provided, the service will use the default setting (static-key).
        """
        return pulumi.get(self, "key_type")

    @key_type.setter
    def key_type(self, value: Optional[pulumi.Input['FlowEntitlementEncryptionKeyType']]):
        pulumi.set(self, "key_type", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The AWS Region that the API Gateway proxy endpoint was created in. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        An identifier for the content. The service sends this value to the key server to identify the current endpoint. The resource ID is also known as the content ID. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)

    @property
    @pulumi.getter(name="secretArn")
    def secret_arn(self) -> Optional[pulumi.Input[str]]:
        """
         The ARN of the secret that you created in AWS Secrets Manager to store the encryption key. This parameter is required for static key encryption and is not valid for SPEKE encryption.
        """
        return pulumi.get(self, "secret_arn")

    @secret_arn.setter
    def secret_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_arn", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        The URL from the API Gateway proxy that you set up to talk to your key server. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)


if not MYPY:
    class FlowFailoverConfigSourcePriorityPropertiesArgsDict(TypedDict):
        """
        The priority you want to assign to a source. You can have a primary stream and a backup stream or two equally prioritized streams.
        """
        primary_source: pulumi.Input[str]
        """
        The name of the source you choose as the primary source for this flow.
        """
elif False:
    FlowFailoverConfigSourcePriorityPropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FlowFailoverConfigSourcePriorityPropertiesArgs:
    def __init__(__self__, *,
                 primary_source: pulumi.Input[str]):
        """
        The priority you want to assign to a source. You can have a primary stream and a backup stream or two equally prioritized streams.
        :param pulumi.Input[str] primary_source: The name of the source you choose as the primary source for this flow.
        """
        pulumi.set(__self__, "primary_source", primary_source)

    @property
    @pulumi.getter(name="primarySource")
    def primary_source(self) -> pulumi.Input[str]:
        """
        The name of the source you choose as the primary source for this flow.
        """
        return pulumi.get(self, "primary_source")

    @primary_source.setter
    def primary_source(self, value: pulumi.Input[str]):
        pulumi.set(self, "primary_source", value)


if not MYPY:
    class FlowFailoverConfigArgsDict(TypedDict):
        """
        The settings for source failover
        """
        failover_mode: NotRequired[pulumi.Input['FlowFailoverConfigFailoverMode']]
        """
        The type of failover you choose for this flow. MERGE combines the source streams into a single stream, allowing graceful recovery from any single-source loss. FAILOVER allows switching between different streams.
        """
        recovery_window: NotRequired[pulumi.Input[int]]
        """
        Search window time to look for dash-7 packets
        """
        source_priority: NotRequired[pulumi.Input['FlowFailoverConfigSourcePriorityPropertiesArgsDict']]
        """
        The priority you want to assign to a source. You can have a primary stream and a backup stream or two equally prioritized streams.
        """
        state: NotRequired[pulumi.Input['FlowFailoverConfigState']]
        """
        The state of source failover on the flow. If the state is inactive, the flow can have only one source. If the state is active, the flow can have one or two sources.
        """
elif False:
    FlowFailoverConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FlowFailoverConfigArgs:
    def __init__(__self__, *,
                 failover_mode: Optional[pulumi.Input['FlowFailoverConfigFailoverMode']] = None,
                 recovery_window: Optional[pulumi.Input[int]] = None,
                 source_priority: Optional[pulumi.Input['FlowFailoverConfigSourcePriorityPropertiesArgs']] = None,
                 state: Optional[pulumi.Input['FlowFailoverConfigState']] = None):
        """
        The settings for source failover
        :param pulumi.Input['FlowFailoverConfigFailoverMode'] failover_mode: The type of failover you choose for this flow. MERGE combines the source streams into a single stream, allowing graceful recovery from any single-source loss. FAILOVER allows switching between different streams.
        :param pulumi.Input[int] recovery_window: Search window time to look for dash-7 packets
        :param pulumi.Input['FlowFailoverConfigSourcePriorityPropertiesArgs'] source_priority: The priority you want to assign to a source. You can have a primary stream and a backup stream or two equally prioritized streams.
        :param pulumi.Input['FlowFailoverConfigState'] state: The state of source failover on the flow. If the state is inactive, the flow can have only one source. If the state is active, the flow can have one or two sources.
        """
        if failover_mode is not None:
            pulumi.set(__self__, "failover_mode", failover_mode)
        if recovery_window is not None:
            pulumi.set(__self__, "recovery_window", recovery_window)
        if source_priority is not None:
            pulumi.set(__self__, "source_priority", source_priority)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="failoverMode")
    def failover_mode(self) -> Optional[pulumi.Input['FlowFailoverConfigFailoverMode']]:
        """
        The type of failover you choose for this flow. MERGE combines the source streams into a single stream, allowing graceful recovery from any single-source loss. FAILOVER allows switching between different streams.
        """
        return pulumi.get(self, "failover_mode")

    @failover_mode.setter
    def failover_mode(self, value: Optional[pulumi.Input['FlowFailoverConfigFailoverMode']]):
        pulumi.set(self, "failover_mode", value)

    @property
    @pulumi.getter(name="recoveryWindow")
    def recovery_window(self) -> Optional[pulumi.Input[int]]:
        """
        Search window time to look for dash-7 packets
        """
        return pulumi.get(self, "recovery_window")

    @recovery_window.setter
    def recovery_window(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "recovery_window", value)

    @property
    @pulumi.getter(name="sourcePriority")
    def source_priority(self) -> Optional[pulumi.Input['FlowFailoverConfigSourcePriorityPropertiesArgs']]:
        """
        The priority you want to assign to a source. You can have a primary stream and a backup stream or two equally prioritized streams.
        """
        return pulumi.get(self, "source_priority")

    @source_priority.setter
    def source_priority(self, value: Optional[pulumi.Input['FlowFailoverConfigSourcePriorityPropertiesArgs']]):
        pulumi.set(self, "source_priority", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input['FlowFailoverConfigState']]:
        """
        The state of source failover on the flow. If the state is inactive, the flow can have only one source. If the state is active, the flow can have one or two sources.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input['FlowFailoverConfigState']]):
        pulumi.set(self, "state", value)


if not MYPY:
    class FlowFmtpArgsDict(TypedDict):
        """
        A set of parameters that define the media stream.
        """
        channel_order: NotRequired[pulumi.Input[str]]
        """
        The format of the audio channel.
        """
        colorimetry: NotRequired[pulumi.Input['FlowFmtpColorimetry']]
        """
        The format used for the representation of color.
        """
        exact_framerate: NotRequired[pulumi.Input[str]]
        """
        The frame rate for the video stream, in frames/second. For example: 60000/1001.
        """
        par: NotRequired[pulumi.Input[str]]
        """
        The pixel aspect ratio (PAR) of the video.
        """
        range: NotRequired[pulumi.Input['FlowFmtpRange']]
        """
        The encoding range of the video.
        """
        scan_mode: NotRequired[pulumi.Input['FlowFmtpScanMode']]
        """
        The type of compression that was used to smooth the video's appearance.
        """
        tcs: NotRequired[pulumi.Input['FlowFmtpTcs']]
        """
        The transfer characteristic system (TCS) that is used in the video.
        """
elif False:
    FlowFmtpArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FlowFmtpArgs:
    def __init__(__self__, *,
                 channel_order: Optional[pulumi.Input[str]] = None,
                 colorimetry: Optional[pulumi.Input['FlowFmtpColorimetry']] = None,
                 exact_framerate: Optional[pulumi.Input[str]] = None,
                 par: Optional[pulumi.Input[str]] = None,
                 range: Optional[pulumi.Input['FlowFmtpRange']] = None,
                 scan_mode: Optional[pulumi.Input['FlowFmtpScanMode']] = None,
                 tcs: Optional[pulumi.Input['FlowFmtpTcs']] = None):
        """
        A set of parameters that define the media stream.
        :param pulumi.Input[str] channel_order: The format of the audio channel.
        :param pulumi.Input['FlowFmtpColorimetry'] colorimetry: The format used for the representation of color.
        :param pulumi.Input[str] exact_framerate: The frame rate for the video stream, in frames/second. For example: 60000/1001.
        :param pulumi.Input[str] par: The pixel aspect ratio (PAR) of the video.
        :param pulumi.Input['FlowFmtpRange'] range: The encoding range of the video.
        :param pulumi.Input['FlowFmtpScanMode'] scan_mode: The type of compression that was used to smooth the video's appearance.
        :param pulumi.Input['FlowFmtpTcs'] tcs: The transfer characteristic system (TCS) that is used in the video.
        """
        if channel_order is not None:
            pulumi.set(__self__, "channel_order", channel_order)
        if colorimetry is not None:
            pulumi.set(__self__, "colorimetry", colorimetry)
        if exact_framerate is not None:
            pulumi.set(__self__, "exact_framerate", exact_framerate)
        if par is not None:
            pulumi.set(__self__, "par", par)
        if range is not None:
            pulumi.set(__self__, "range", range)
        if scan_mode is not None:
            pulumi.set(__self__, "scan_mode", scan_mode)
        if tcs is not None:
            pulumi.set(__self__, "tcs", tcs)

    @property
    @pulumi.getter(name="channelOrder")
    def channel_order(self) -> Optional[pulumi.Input[str]]:
        """
        The format of the audio channel.
        """
        return pulumi.get(self, "channel_order")

    @channel_order.setter
    def channel_order(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "channel_order", value)

    @property
    @pulumi.getter
    def colorimetry(self) -> Optional[pulumi.Input['FlowFmtpColorimetry']]:
        """
        The format used for the representation of color.
        """
        return pulumi.get(self, "colorimetry")

    @colorimetry.setter
    def colorimetry(self, value: Optional[pulumi.Input['FlowFmtpColorimetry']]):
        pulumi.set(self, "colorimetry", value)

    @property
    @pulumi.getter(name="exactFramerate")
    def exact_framerate(self) -> Optional[pulumi.Input[str]]:
        """
        The frame rate for the video stream, in frames/second. For example: 60000/1001.
        """
        return pulumi.get(self, "exact_framerate")

    @exact_framerate.setter
    def exact_framerate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "exact_framerate", value)

    @property
    @pulumi.getter
    def par(self) -> Optional[pulumi.Input[str]]:
        """
        The pixel aspect ratio (PAR) of the video.
        """
        return pulumi.get(self, "par")

    @par.setter
    def par(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "par", value)

    @property
    @pulumi.getter
    def range(self) -> Optional[pulumi.Input['FlowFmtpRange']]:
        """
        The encoding range of the video.
        """
        return pulumi.get(self, "range")

    @range.setter
    def range(self, value: Optional[pulumi.Input['FlowFmtpRange']]):
        pulumi.set(self, "range", value)

    @property
    @pulumi.getter(name="scanMode")
    def scan_mode(self) -> Optional[pulumi.Input['FlowFmtpScanMode']]:
        """
        The type of compression that was used to smooth the video's appearance.
        """
        return pulumi.get(self, "scan_mode")

    @scan_mode.setter
    def scan_mode(self, value: Optional[pulumi.Input['FlowFmtpScanMode']]):
        pulumi.set(self, "scan_mode", value)

    @property
    @pulumi.getter
    def tcs(self) -> Optional[pulumi.Input['FlowFmtpTcs']]:
        """
        The transfer characteristic system (TCS) that is used in the video.
        """
        return pulumi.get(self, "tcs")

    @tcs.setter
    def tcs(self, value: Optional[pulumi.Input['FlowFmtpTcs']]):
        pulumi.set(self, "tcs", value)


if not MYPY:
    class FlowGatewayBridgeSourceArgsDict(TypedDict):
        """
        The source configuration for cloud flows receiving a stream from a bridge.
        """
        bridge_arn: pulumi.Input[str]
        """
        The ARN of the bridge feeding this flow.
        """
        vpc_interface_attachment: NotRequired[pulumi.Input['FlowVpcInterfaceAttachmentArgsDict']]
        """
        The name of the VPC interface attachment to use for this bridge source.
        """
elif False:
    FlowGatewayBridgeSourceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FlowGatewayBridgeSourceArgs:
    def __init__(__self__, *,
                 bridge_arn: pulumi.Input[str],
                 vpc_interface_attachment: Optional[pulumi.Input['FlowVpcInterfaceAttachmentArgs']] = None):
        """
        The source configuration for cloud flows receiving a stream from a bridge.
        :param pulumi.Input[str] bridge_arn: The ARN of the bridge feeding this flow.
        :param pulumi.Input['FlowVpcInterfaceAttachmentArgs'] vpc_interface_attachment: The name of the VPC interface attachment to use for this bridge source.
        """
        pulumi.set(__self__, "bridge_arn", bridge_arn)
        if vpc_interface_attachment is not None:
            pulumi.set(__self__, "vpc_interface_attachment", vpc_interface_attachment)

    @property
    @pulumi.getter(name="bridgeArn")
    def bridge_arn(self) -> pulumi.Input[str]:
        """
        The ARN of the bridge feeding this flow.
        """
        return pulumi.get(self, "bridge_arn")

    @bridge_arn.setter
    def bridge_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "bridge_arn", value)

    @property
    @pulumi.getter(name="vpcInterfaceAttachment")
    def vpc_interface_attachment(self) -> Optional[pulumi.Input['FlowVpcInterfaceAttachmentArgs']]:
        """
        The name of the VPC interface attachment to use for this bridge source.
        """
        return pulumi.get(self, "vpc_interface_attachment")

    @vpc_interface_attachment.setter
    def vpc_interface_attachment(self, value: Optional[pulumi.Input['FlowVpcInterfaceAttachmentArgs']]):
        pulumi.set(self, "vpc_interface_attachment", value)


if not MYPY:
    class FlowInputConfigurationArgsDict(TypedDict):
        """
        The transport parameters associated with an incoming media stream.
        """
        input_port: pulumi.Input[int]
        """
        The port that the flow listens on for an incoming media stream.
        """
        interface: pulumi.Input['FlowInterfaceArgsDict']
        """
        The VPC interface where the media stream comes in from.
        """
elif False:
    FlowInputConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FlowInputConfigurationArgs:
    def __init__(__self__, *,
                 input_port: pulumi.Input[int],
                 interface: pulumi.Input['FlowInterfaceArgs']):
        """
        The transport parameters associated with an incoming media stream.
        :param pulumi.Input[int] input_port: The port that the flow listens on for an incoming media stream.
        :param pulumi.Input['FlowInterfaceArgs'] interface: The VPC interface where the media stream comes in from.
        """
        pulumi.set(__self__, "input_port", input_port)
        pulumi.set(__self__, "interface", interface)

    @property
    @pulumi.getter(name="inputPort")
    def input_port(self) -> pulumi.Input[int]:
        """
        The port that the flow listens on for an incoming media stream.
        """
        return pulumi.get(self, "input_port")

    @input_port.setter
    def input_port(self, value: pulumi.Input[int]):
        pulumi.set(self, "input_port", value)

    @property
    @pulumi.getter
    def interface(self) -> pulumi.Input['FlowInterfaceArgs']:
        """
        The VPC interface where the media stream comes in from.
        """
        return pulumi.get(self, "interface")

    @interface.setter
    def interface(self, value: pulumi.Input['FlowInterfaceArgs']):
        pulumi.set(self, "interface", value)


if not MYPY:
    class FlowInterfaceArgsDict(TypedDict):
        """
        The VPC interface that you want to use for the media stream associated with the output.
        """
        name: pulumi.Input[str]
        """
        The name of the VPC interface that you want to use for the media stream associated with the output.
        """
elif False:
    FlowInterfaceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FlowInterfaceArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str]):
        """
        The VPC interface that you want to use for the media stream associated with the output.
        :param pulumi.Input[str] name: The name of the VPC interface that you want to use for the media stream associated with the output.
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the VPC interface that you want to use for the media stream associated with the output.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)


if not MYPY:
    class FlowMaintenanceArgsDict(TypedDict):
        """
        The maintenance setting of a flow.
        """
        maintenance_day: pulumi.Input['FlowMaintenanceMaintenanceDay']
        """
        A day of a week when the maintenance will happen. Use Monday/Tuesday/Wednesday/Thursday/Friday/Saturday/Sunday.
        """
        maintenance_start_hour: pulumi.Input[str]
        """
        UTC time when the maintenance will happen. Use 24-hour HH:MM format. Minutes must be 00. Example: 13:00. The default value is 02:00.
        """
elif False:
    FlowMaintenanceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FlowMaintenanceArgs:
    def __init__(__self__, *,
                 maintenance_day: pulumi.Input['FlowMaintenanceMaintenanceDay'],
                 maintenance_start_hour: pulumi.Input[str]):
        """
        The maintenance setting of a flow.
        :param pulumi.Input['FlowMaintenanceMaintenanceDay'] maintenance_day: A day of a week when the maintenance will happen. Use Monday/Tuesday/Wednesday/Thursday/Friday/Saturday/Sunday.
        :param pulumi.Input[str] maintenance_start_hour: UTC time when the maintenance will happen. Use 24-hour HH:MM format. Minutes must be 00. Example: 13:00. The default value is 02:00.
        """
        pulumi.set(__self__, "maintenance_day", maintenance_day)
        pulumi.set(__self__, "maintenance_start_hour", maintenance_start_hour)

    @property
    @pulumi.getter(name="maintenanceDay")
    def maintenance_day(self) -> pulumi.Input['FlowMaintenanceMaintenanceDay']:
        """
        A day of a week when the maintenance will happen. Use Monday/Tuesday/Wednesday/Thursday/Friday/Saturday/Sunday.
        """
        return pulumi.get(self, "maintenance_day")

    @maintenance_day.setter
    def maintenance_day(self, value: pulumi.Input['FlowMaintenanceMaintenanceDay']):
        pulumi.set(self, "maintenance_day", value)

    @property
    @pulumi.getter(name="maintenanceStartHour")
    def maintenance_start_hour(self) -> pulumi.Input[str]:
        """
        UTC time when the maintenance will happen. Use 24-hour HH:MM format. Minutes must be 00. Example: 13:00. The default value is 02:00.
        """
        return pulumi.get(self, "maintenance_start_hour")

    @maintenance_start_hour.setter
    def maintenance_start_hour(self, value: pulumi.Input[str]):
        pulumi.set(self, "maintenance_start_hour", value)


if not MYPY:
    class FlowMediaStreamAttributesArgsDict(TypedDict):
        """
        Attributes that are related to the media stream.
        """
        fmtp: NotRequired[pulumi.Input['FlowFmtpArgsDict']]
        """
        A set of parameters that define the media stream.
        """
        lang: NotRequired[pulumi.Input[str]]
        """
        The audio language, in a format that is recognized by the receiver.
        """
elif False:
    FlowMediaStreamAttributesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FlowMediaStreamAttributesArgs:
    def __init__(__self__, *,
                 fmtp: Optional[pulumi.Input['FlowFmtpArgs']] = None,
                 lang: Optional[pulumi.Input[str]] = None):
        """
        Attributes that are related to the media stream.
        :param pulumi.Input['FlowFmtpArgs'] fmtp: A set of parameters that define the media stream.
        :param pulumi.Input[str] lang: The audio language, in a format that is recognized by the receiver.
        """
        if fmtp is not None:
            pulumi.set(__self__, "fmtp", fmtp)
        if lang is not None:
            pulumi.set(__self__, "lang", lang)

    @property
    @pulumi.getter
    def fmtp(self) -> Optional[pulumi.Input['FlowFmtpArgs']]:
        """
        A set of parameters that define the media stream.
        """
        return pulumi.get(self, "fmtp")

    @fmtp.setter
    def fmtp(self, value: Optional[pulumi.Input['FlowFmtpArgs']]):
        pulumi.set(self, "fmtp", value)

    @property
    @pulumi.getter
    def lang(self) -> Optional[pulumi.Input[str]]:
        """
        The audio language, in a format that is recognized by the receiver.
        """
        return pulumi.get(self, "lang")

    @lang.setter
    def lang(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lang", value)


if not MYPY:
    class FlowMediaStreamSourceConfigurationArgsDict(TypedDict):
        """
        The media stream that is associated with the source, and the parameters for that association.
        """
        encoding_name: pulumi.Input['FlowMediaStreamSourceConfigurationEncodingName']
        """
        The format that was used to encode the data. For ancillary data streams, set the encoding name to smpte291. For audio streams, set the encoding name to pcm. For video, 2110 streams, set the encoding name to raw. For video, JPEG XS streams, set the encoding name to jxsv.
        """
        media_stream_name: pulumi.Input[str]
        """
        A name that helps you distinguish one media stream from another.
        """
        input_configurations: NotRequired[pulumi.Input[Sequence[pulumi.Input['FlowInputConfigurationArgsDict']]]]
        """
        The media streams that you want to associate with the source.
        """
elif False:
    FlowMediaStreamSourceConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FlowMediaStreamSourceConfigurationArgs:
    def __init__(__self__, *,
                 encoding_name: pulumi.Input['FlowMediaStreamSourceConfigurationEncodingName'],
                 media_stream_name: pulumi.Input[str],
                 input_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['FlowInputConfigurationArgs']]]] = None):
        """
        The media stream that is associated with the source, and the parameters for that association.
        :param pulumi.Input['FlowMediaStreamSourceConfigurationEncodingName'] encoding_name: The format that was used to encode the data. For ancillary data streams, set the encoding name to smpte291. For audio streams, set the encoding name to pcm. For video, 2110 streams, set the encoding name to raw. For video, JPEG XS streams, set the encoding name to jxsv.
        :param pulumi.Input[str] media_stream_name: A name that helps you distinguish one media stream from another.
        :param pulumi.Input[Sequence[pulumi.Input['FlowInputConfigurationArgs']]] input_configurations: The media streams that you want to associate with the source.
        """
        pulumi.set(__self__, "encoding_name", encoding_name)
        pulumi.set(__self__, "media_stream_name", media_stream_name)
        if input_configurations is not None:
            pulumi.set(__self__, "input_configurations", input_configurations)

    @property
    @pulumi.getter(name="encodingName")
    def encoding_name(self) -> pulumi.Input['FlowMediaStreamSourceConfigurationEncodingName']:
        """
        The format that was used to encode the data. For ancillary data streams, set the encoding name to smpte291. For audio streams, set the encoding name to pcm. For video, 2110 streams, set the encoding name to raw. For video, JPEG XS streams, set the encoding name to jxsv.
        """
        return pulumi.get(self, "encoding_name")

    @encoding_name.setter
    def encoding_name(self, value: pulumi.Input['FlowMediaStreamSourceConfigurationEncodingName']):
        pulumi.set(self, "encoding_name", value)

    @property
    @pulumi.getter(name="mediaStreamName")
    def media_stream_name(self) -> pulumi.Input[str]:
        """
        A name that helps you distinguish one media stream from another.
        """
        return pulumi.get(self, "media_stream_name")

    @media_stream_name.setter
    def media_stream_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "media_stream_name", value)

    @property
    @pulumi.getter(name="inputConfigurations")
    def input_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FlowInputConfigurationArgs']]]]:
        """
        The media streams that you want to associate with the source.
        """
        return pulumi.get(self, "input_configurations")

    @input_configurations.setter
    def input_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FlowInputConfigurationArgs']]]]):
        pulumi.set(self, "input_configurations", value)


if not MYPY:
    class FlowMediaStreamArgsDict(TypedDict):
        """
        A single track or stream of media that contains video, audio, or ancillary data. After you add a media stream to a flow, you can associate it with sources and outputs on that flow, as long as they use the CDI protocol or the ST 2110 JPEG XS protocol. Each source or output can consist of one or many media streams.
        """
        media_stream_id: pulumi.Input[int]
        """
        A unique identifier for the media stream.
        """
        media_stream_name: pulumi.Input[str]
        """
        A name that helps you distinguish one media stream from another.
        """
        media_stream_type: pulumi.Input['FlowMediaStreamMediaStreamType']
        """
        The type of media stream.
        """
        attributes: NotRequired[pulumi.Input['FlowMediaStreamAttributesArgsDict']]
        """
        Attributes that are related to the media stream.
        """
        clock_rate: NotRequired[pulumi.Input[int]]
        """
        The sample rate for the stream. This value in measured in kHz.
        """
        description: NotRequired[pulumi.Input[str]]
        """
        A description that can help you quickly identify what your media stream is used for.
        """
        fmt: NotRequired[pulumi.Input[int]]
        """
        The format type number (sometimes referred to as RTP payload type) of the media stream. MediaConnect assigns this value to the media stream. For ST 2110 JPEG XS outputs, you need to provide this value to the receiver.
        """
        video_format: NotRequired[pulumi.Input['FlowMediaStreamVideoFormat']]
        """
        The resolution of the video.
        """
elif False:
    FlowMediaStreamArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FlowMediaStreamArgs:
    def __init__(__self__, *,
                 media_stream_id: pulumi.Input[int],
                 media_stream_name: pulumi.Input[str],
                 media_stream_type: pulumi.Input['FlowMediaStreamMediaStreamType'],
                 attributes: Optional[pulumi.Input['FlowMediaStreamAttributesArgs']] = None,
                 clock_rate: Optional[pulumi.Input[int]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 fmt: Optional[pulumi.Input[int]] = None,
                 video_format: Optional[pulumi.Input['FlowMediaStreamVideoFormat']] = None):
        """
        A single track or stream of media that contains video, audio, or ancillary data. After you add a media stream to a flow, you can associate it with sources and outputs on that flow, as long as they use the CDI protocol or the ST 2110 JPEG XS protocol. Each source or output can consist of one or many media streams.
        :param pulumi.Input[int] media_stream_id: A unique identifier for the media stream.
        :param pulumi.Input[str] media_stream_name: A name that helps you distinguish one media stream from another.
        :param pulumi.Input['FlowMediaStreamMediaStreamType'] media_stream_type: The type of media stream.
        :param pulumi.Input['FlowMediaStreamAttributesArgs'] attributes: Attributes that are related to the media stream.
        :param pulumi.Input[int] clock_rate: The sample rate for the stream. This value in measured in kHz.
        :param pulumi.Input[str] description: A description that can help you quickly identify what your media stream is used for.
        :param pulumi.Input[int] fmt: The format type number (sometimes referred to as RTP payload type) of the media stream. MediaConnect assigns this value to the media stream. For ST 2110 JPEG XS outputs, you need to provide this value to the receiver.
        :param pulumi.Input['FlowMediaStreamVideoFormat'] video_format: The resolution of the video.
        """
        pulumi.set(__self__, "media_stream_id", media_stream_id)
        pulumi.set(__self__, "media_stream_name", media_stream_name)
        pulumi.set(__self__, "media_stream_type", media_stream_type)
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)
        if clock_rate is not None:
            pulumi.set(__self__, "clock_rate", clock_rate)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if fmt is not None:
            pulumi.set(__self__, "fmt", fmt)
        if video_format is not None:
            pulumi.set(__self__, "video_format", video_format)

    @property
    @pulumi.getter(name="mediaStreamId")
    def media_stream_id(self) -> pulumi.Input[int]:
        """
        A unique identifier for the media stream.
        """
        return pulumi.get(self, "media_stream_id")

    @media_stream_id.setter
    def media_stream_id(self, value: pulumi.Input[int]):
        pulumi.set(self, "media_stream_id", value)

    @property
    @pulumi.getter(name="mediaStreamName")
    def media_stream_name(self) -> pulumi.Input[str]:
        """
        A name that helps you distinguish one media stream from another.
        """
        return pulumi.get(self, "media_stream_name")

    @media_stream_name.setter
    def media_stream_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "media_stream_name", value)

    @property
    @pulumi.getter(name="mediaStreamType")
    def media_stream_type(self) -> pulumi.Input['FlowMediaStreamMediaStreamType']:
        """
        The type of media stream.
        """
        return pulumi.get(self, "media_stream_type")

    @media_stream_type.setter
    def media_stream_type(self, value: pulumi.Input['FlowMediaStreamMediaStreamType']):
        pulumi.set(self, "media_stream_type", value)

    @property
    @pulumi.getter
    def attributes(self) -> Optional[pulumi.Input['FlowMediaStreamAttributesArgs']]:
        """
        Attributes that are related to the media stream.
        """
        return pulumi.get(self, "attributes")

    @attributes.setter
    def attributes(self, value: Optional[pulumi.Input['FlowMediaStreamAttributesArgs']]):
        pulumi.set(self, "attributes", value)

    @property
    @pulumi.getter(name="clockRate")
    def clock_rate(self) -> Optional[pulumi.Input[int]]:
        """
        The sample rate for the stream. This value in measured in kHz.
        """
        return pulumi.get(self, "clock_rate")

    @clock_rate.setter
    def clock_rate(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "clock_rate", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A description that can help you quickly identify what your media stream is used for.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def fmt(self) -> Optional[pulumi.Input[int]]:
        """
        The format type number (sometimes referred to as RTP payload type) of the media stream. MediaConnect assigns this value to the media stream. For ST 2110 JPEG XS outputs, you need to provide this value to the receiver.
        """
        return pulumi.get(self, "fmt")

    @fmt.setter
    def fmt(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "fmt", value)

    @property
    @pulumi.getter(name="videoFormat")
    def video_format(self) -> Optional[pulumi.Input['FlowMediaStreamVideoFormat']]:
        """
        The resolution of the video.
        """
        return pulumi.get(self, "video_format")

    @video_format.setter
    def video_format(self, value: Optional[pulumi.Input['FlowMediaStreamVideoFormat']]):
        pulumi.set(self, "video_format", value)


if not MYPY:
    class FlowOutputDestinationConfigurationArgsDict(TypedDict):
        """
        The definition of a media stream that is associated with the output.
        """
        destination_ip: pulumi.Input[str]
        """
        The IP address where contents of the media stream will be sent.
        """
        destination_port: pulumi.Input[int]
        """
        The port to use when the content of the media stream is distributed to the output.
        """
        interface: pulumi.Input['FlowOutputInterfaceArgsDict']
        """
        The VPC interface that is used for the media stream associated with the output.
        """
elif False:
    FlowOutputDestinationConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FlowOutputDestinationConfigurationArgs:
    def __init__(__self__, *,
                 destination_ip: pulumi.Input[str],
                 destination_port: pulumi.Input[int],
                 interface: pulumi.Input['FlowOutputInterfaceArgs']):
        """
        The definition of a media stream that is associated with the output.
        :param pulumi.Input[str] destination_ip: The IP address where contents of the media stream will be sent.
        :param pulumi.Input[int] destination_port: The port to use when the content of the media stream is distributed to the output.
        :param pulumi.Input['FlowOutputInterfaceArgs'] interface: The VPC interface that is used for the media stream associated with the output.
        """
        pulumi.set(__self__, "destination_ip", destination_ip)
        pulumi.set(__self__, "destination_port", destination_port)
        pulumi.set(__self__, "interface", interface)

    @property
    @pulumi.getter(name="destinationIp")
    def destination_ip(self) -> pulumi.Input[str]:
        """
        The IP address where contents of the media stream will be sent.
        """
        return pulumi.get(self, "destination_ip")

    @destination_ip.setter
    def destination_ip(self, value: pulumi.Input[str]):
        pulumi.set(self, "destination_ip", value)

    @property
    @pulumi.getter(name="destinationPort")
    def destination_port(self) -> pulumi.Input[int]:
        """
        The port to use when the content of the media stream is distributed to the output.
        """
        return pulumi.get(self, "destination_port")

    @destination_port.setter
    def destination_port(self, value: pulumi.Input[int]):
        pulumi.set(self, "destination_port", value)

    @property
    @pulumi.getter
    def interface(self) -> pulumi.Input['FlowOutputInterfaceArgs']:
        """
        The VPC interface that is used for the media stream associated with the output.
        """
        return pulumi.get(self, "interface")

    @interface.setter
    def interface(self, value: pulumi.Input['FlowOutputInterfaceArgs']):
        pulumi.set(self, "interface", value)


if not MYPY:
    class FlowOutputEncodingParametersArgsDict(TypedDict):
        """
        A collection of parameters that determine how MediaConnect will convert the content. These fields only apply to outputs on flows that have a CDI source.
        """
        compression_factor: pulumi.Input[float]
        """
        A value that is used to calculate compression for an output. The bitrate of the output is calculated as follows: Output bitrate = (1 / compressionFactor) * (source bitrate) This property only applies to outputs that use the ST 2110 JPEG XS protocol, with a flow source that uses the CDI protocol. Valid values are in the range of 3.0 to 10.0, inclusive.
        """
        encoder_profile: NotRequired[pulumi.Input['FlowOutputEncodingParametersEncoderProfile']]
        """
        A setting on the encoder that drives compression settings. This property only applies to video media streams associated with outputs that use the ST 2110 JPEG XS protocol, with a flow source that uses the CDI protocol.
        """
elif False:
    FlowOutputEncodingParametersArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FlowOutputEncodingParametersArgs:
    def __init__(__self__, *,
                 compression_factor: pulumi.Input[float],
                 encoder_profile: Optional[pulumi.Input['FlowOutputEncodingParametersEncoderProfile']] = None):
        """
        A collection of parameters that determine how MediaConnect will convert the content. These fields only apply to outputs on flows that have a CDI source.
        :param pulumi.Input[float] compression_factor: A value that is used to calculate compression for an output. The bitrate of the output is calculated as follows: Output bitrate = (1 / compressionFactor) * (source bitrate) This property only applies to outputs that use the ST 2110 JPEG XS protocol, with a flow source that uses the CDI protocol. Valid values are in the range of 3.0 to 10.0, inclusive.
        :param pulumi.Input['FlowOutputEncodingParametersEncoderProfile'] encoder_profile: A setting on the encoder that drives compression settings. This property only applies to video media streams associated with outputs that use the ST 2110 JPEG XS protocol, with a flow source that uses the CDI protocol.
        """
        pulumi.set(__self__, "compression_factor", compression_factor)
        if encoder_profile is not None:
            pulumi.set(__self__, "encoder_profile", encoder_profile)

    @property
    @pulumi.getter(name="compressionFactor")
    def compression_factor(self) -> pulumi.Input[float]:
        """
        A value that is used to calculate compression for an output. The bitrate of the output is calculated as follows: Output bitrate = (1 / compressionFactor) * (source bitrate) This property only applies to outputs that use the ST 2110 JPEG XS protocol, with a flow source that uses the CDI protocol. Valid values are in the range of 3.0 to 10.0, inclusive.
        """
        return pulumi.get(self, "compression_factor")

    @compression_factor.setter
    def compression_factor(self, value: pulumi.Input[float]):
        pulumi.set(self, "compression_factor", value)

    @property
    @pulumi.getter(name="encoderProfile")
    def encoder_profile(self) -> Optional[pulumi.Input['FlowOutputEncodingParametersEncoderProfile']]:
        """
        A setting on the encoder that drives compression settings. This property only applies to video media streams associated with outputs that use the ST 2110 JPEG XS protocol, with a flow source that uses the CDI protocol.
        """
        return pulumi.get(self, "encoder_profile")

    @encoder_profile.setter
    def encoder_profile(self, value: Optional[pulumi.Input['FlowOutputEncodingParametersEncoderProfile']]):
        pulumi.set(self, "encoder_profile", value)


if not MYPY:
    class FlowOutputEncryptionArgsDict(TypedDict):
        """
        Information about the encryption of the flow.
        """
        role_arn: pulumi.Input[str]
        """
        The ARN of the role that you created during setup (when you set up AWS Elemental MediaConnect as a trusted entity).
        """
        secret_arn: pulumi.Input[str]
        """
         The ARN of the secret that you created in AWS Secrets Manager to store the encryption key. This parameter is required for static key encryption and is not valid for SPEKE encryption.
        """
        algorithm: NotRequired[pulumi.Input['FlowOutputEncryptionAlgorithm']]
        """
        The type of algorithm that is used for the encryption (such as aes128, aes192, or aes256).
        """
        key_type: NotRequired[pulumi.Input['FlowOutputEncryptionKeyType']]
        """
        The type of key that is used for the encryption. If no keyType is provided, the service will use the default setting (static-key).
        """
elif False:
    FlowOutputEncryptionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FlowOutputEncryptionArgs:
    def __init__(__self__, *,
                 role_arn: pulumi.Input[str],
                 secret_arn: pulumi.Input[str],
                 algorithm: Optional[pulumi.Input['FlowOutputEncryptionAlgorithm']] = None,
                 key_type: Optional[pulumi.Input['FlowOutputEncryptionKeyType']] = None):
        """
        Information about the encryption of the flow.
        :param pulumi.Input[str] role_arn: The ARN of the role that you created during setup (when you set up AWS Elemental MediaConnect as a trusted entity).
        :param pulumi.Input[str] secret_arn:  The ARN of the secret that you created in AWS Secrets Manager to store the encryption key. This parameter is required for static key encryption and is not valid for SPEKE encryption.
        :param pulumi.Input['FlowOutputEncryptionAlgorithm'] algorithm: The type of algorithm that is used for the encryption (such as aes128, aes192, or aes256).
        :param pulumi.Input['FlowOutputEncryptionKeyType'] key_type: The type of key that is used for the encryption. If no keyType is provided, the service will use the default setting (static-key).
        """
        pulumi.set(__self__, "role_arn", role_arn)
        pulumi.set(__self__, "secret_arn", secret_arn)
        if algorithm is not None:
            pulumi.set(__self__, "algorithm", algorithm)
        if key_type is not None:
            pulumi.set(__self__, "key_type", key_type)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Input[str]:
        """
        The ARN of the role that you created during setup (when you set up AWS Elemental MediaConnect as a trusted entity).
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter(name="secretArn")
    def secret_arn(self) -> pulumi.Input[str]:
        """
         The ARN of the secret that you created in AWS Secrets Manager to store the encryption key. This parameter is required for static key encryption and is not valid for SPEKE encryption.
        """
        return pulumi.get(self, "secret_arn")

    @secret_arn.setter
    def secret_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "secret_arn", value)

    @property
    @pulumi.getter
    def algorithm(self) -> Optional[pulumi.Input['FlowOutputEncryptionAlgorithm']]:
        """
        The type of algorithm that is used for the encryption (such as aes128, aes192, or aes256).
        """
        return pulumi.get(self, "algorithm")

    @algorithm.setter
    def algorithm(self, value: Optional[pulumi.Input['FlowOutputEncryptionAlgorithm']]):
        pulumi.set(self, "algorithm", value)

    @property
    @pulumi.getter(name="keyType")
    def key_type(self) -> Optional[pulumi.Input['FlowOutputEncryptionKeyType']]:
        """
        The type of key that is used for the encryption. If no keyType is provided, the service will use the default setting (static-key).
        """
        return pulumi.get(self, "key_type")

    @key_type.setter
    def key_type(self, value: Optional[pulumi.Input['FlowOutputEncryptionKeyType']]):
        pulumi.set(self, "key_type", value)


if not MYPY:
    class FlowOutputInterfaceArgsDict(TypedDict):
        """
        The VPC interface that you want to use for the media stream associated with the output.
        """
        name: pulumi.Input[str]
        """
        The name of the VPC interface that you want to use for the media stream associated with the output.
        """
elif False:
    FlowOutputInterfaceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FlowOutputInterfaceArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str]):
        """
        The VPC interface that you want to use for the media stream associated with the output.
        :param pulumi.Input[str] name: The name of the VPC interface that you want to use for the media stream associated with the output.
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the VPC interface that you want to use for the media stream associated with the output.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)


if not MYPY:
    class FlowOutputMediaStreamOutputConfigurationArgsDict(TypedDict):
        """
        The media stream that is associated with the output, and the parameters for that association.
        """
        encoding_name: pulumi.Input['FlowOutputMediaStreamOutputConfigurationEncodingName']
        """
        The format that will be used to encode the data. For ancillary data streams, set the encoding name to smpte291. For audio streams, set the encoding name to pcm. For video streams on sources or outputs that use the CDI protocol, set the encoding name to raw. For video streams on sources or outputs that use the ST 2110 JPEG XS protocol, set the encoding name to jxsv.
        """
        media_stream_name: pulumi.Input[str]
        """
        A name that helps you distinguish one media stream from another.
        """
        destination_configurations: NotRequired[pulumi.Input[Sequence[pulumi.Input['FlowOutputDestinationConfigurationArgsDict']]]]
        """
        The media streams that you want to associate with the output.
        """
        encoding_parameters: NotRequired[pulumi.Input['FlowOutputEncodingParametersArgsDict']]
        """
        A collection of parameters that determine how MediaConnect will convert the content. These fields only apply to outputs on flows that have a CDI source.
        """
elif False:
    FlowOutputMediaStreamOutputConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FlowOutputMediaStreamOutputConfigurationArgs:
    def __init__(__self__, *,
                 encoding_name: pulumi.Input['FlowOutputMediaStreamOutputConfigurationEncodingName'],
                 media_stream_name: pulumi.Input[str],
                 destination_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['FlowOutputDestinationConfigurationArgs']]]] = None,
                 encoding_parameters: Optional[pulumi.Input['FlowOutputEncodingParametersArgs']] = None):
        """
        The media stream that is associated with the output, and the parameters for that association.
        :param pulumi.Input['FlowOutputMediaStreamOutputConfigurationEncodingName'] encoding_name: The format that will be used to encode the data. For ancillary data streams, set the encoding name to smpte291. For audio streams, set the encoding name to pcm. For video streams on sources or outputs that use the CDI protocol, set the encoding name to raw. For video streams on sources or outputs that use the ST 2110 JPEG XS protocol, set the encoding name to jxsv.
        :param pulumi.Input[str] media_stream_name: A name that helps you distinguish one media stream from another.
        :param pulumi.Input[Sequence[pulumi.Input['FlowOutputDestinationConfigurationArgs']]] destination_configurations: The media streams that you want to associate with the output.
        :param pulumi.Input['FlowOutputEncodingParametersArgs'] encoding_parameters: A collection of parameters that determine how MediaConnect will convert the content. These fields only apply to outputs on flows that have a CDI source.
        """
        pulumi.set(__self__, "encoding_name", encoding_name)
        pulumi.set(__self__, "media_stream_name", media_stream_name)
        if destination_configurations is not None:
            pulumi.set(__self__, "destination_configurations", destination_configurations)
        if encoding_parameters is not None:
            pulumi.set(__self__, "encoding_parameters", encoding_parameters)

    @property
    @pulumi.getter(name="encodingName")
    def encoding_name(self) -> pulumi.Input['FlowOutputMediaStreamOutputConfigurationEncodingName']:
        """
        The format that will be used to encode the data. For ancillary data streams, set the encoding name to smpte291. For audio streams, set the encoding name to pcm. For video streams on sources or outputs that use the CDI protocol, set the encoding name to raw. For video streams on sources or outputs that use the ST 2110 JPEG XS protocol, set the encoding name to jxsv.
        """
        return pulumi.get(self, "encoding_name")

    @encoding_name.setter
    def encoding_name(self, value: pulumi.Input['FlowOutputMediaStreamOutputConfigurationEncodingName']):
        pulumi.set(self, "encoding_name", value)

    @property
    @pulumi.getter(name="mediaStreamName")
    def media_stream_name(self) -> pulumi.Input[str]:
        """
        A name that helps you distinguish one media stream from another.
        """
        return pulumi.get(self, "media_stream_name")

    @media_stream_name.setter
    def media_stream_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "media_stream_name", value)

    @property
    @pulumi.getter(name="destinationConfigurations")
    def destination_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FlowOutputDestinationConfigurationArgs']]]]:
        """
        The media streams that you want to associate with the output.
        """
        return pulumi.get(self, "destination_configurations")

    @destination_configurations.setter
    def destination_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FlowOutputDestinationConfigurationArgs']]]]):
        pulumi.set(self, "destination_configurations", value)

    @property
    @pulumi.getter(name="encodingParameters")
    def encoding_parameters(self) -> Optional[pulumi.Input['FlowOutputEncodingParametersArgs']]:
        """
        A collection of parameters that determine how MediaConnect will convert the content. These fields only apply to outputs on flows that have a CDI source.
        """
        return pulumi.get(self, "encoding_parameters")

    @encoding_parameters.setter
    def encoding_parameters(self, value: Optional[pulumi.Input['FlowOutputEncodingParametersArgs']]):
        pulumi.set(self, "encoding_parameters", value)


if not MYPY:
    class FlowOutputVpcInterfaceAttachmentArgsDict(TypedDict):
        """
        The settings for attaching a VPC interface to an output.
        """
        vpc_interface_name: NotRequired[pulumi.Input[str]]
        """
        The name of the VPC interface to use for this output.
        """
elif False:
    FlowOutputVpcInterfaceAttachmentArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FlowOutputVpcInterfaceAttachmentArgs:
    def __init__(__self__, *,
                 vpc_interface_name: Optional[pulumi.Input[str]] = None):
        """
        The settings for attaching a VPC interface to an output.
        :param pulumi.Input[str] vpc_interface_name: The name of the VPC interface to use for this output.
        """
        if vpc_interface_name is not None:
            pulumi.set(__self__, "vpc_interface_name", vpc_interface_name)

    @property
    @pulumi.getter(name="vpcInterfaceName")
    def vpc_interface_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the VPC interface to use for this output.
        """
        return pulumi.get(self, "vpc_interface_name")

    @vpc_interface_name.setter
    def vpc_interface_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_interface_name", value)


if not MYPY:
    class FlowSourceEncryptionArgsDict(TypedDict):
        """
        Information about the encryption of the flow.
        """
        role_arn: pulumi.Input[str]
        """
        The ARN of the role that you created during setup (when you set up AWS Elemental MediaConnect as a trusted entity).
        """
        algorithm: NotRequired[pulumi.Input['FlowSourceEncryptionAlgorithm']]
        """
        The type of algorithm that is used for the encryption (such as aes128, aes192, or aes256).
        """
        constant_initialization_vector: NotRequired[pulumi.Input[str]]
        """
        A 128-bit, 16-byte hex value represented by a 32-character string, to be used with the key for encrypting content. This parameter is not valid for static key encryption.
        """
        device_id: NotRequired[pulumi.Input[str]]
        """
        The value of one of the devices that you configured with your digital rights management (DRM) platform key provider. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        key_type: NotRequired[pulumi.Input['FlowSourceEncryptionKeyType']]
        """
        The type of key that is used for the encryption. If no keyType is provided, the service will use the default setting (static-key).
        """
        region: NotRequired[pulumi.Input[str]]
        """
        The AWS Region that the API Gateway proxy endpoint was created in. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        resource_id: NotRequired[pulumi.Input[str]]
        """
        An identifier for the content. The service sends this value to the key server to identify the current endpoint. The resource ID is also known as the content ID. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        secret_arn: NotRequired[pulumi.Input[str]]
        """
         The ARN of the secret that you created in AWS Secrets Manager to store the encryption key. This parameter is required for static key encryption and is not valid for SPEKE encryption.
        """
        url: NotRequired[pulumi.Input[str]]
        """
        The URL from the API Gateway proxy that you set up to talk to your key server. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
elif False:
    FlowSourceEncryptionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FlowSourceEncryptionArgs:
    def __init__(__self__, *,
                 role_arn: pulumi.Input[str],
                 algorithm: Optional[pulumi.Input['FlowSourceEncryptionAlgorithm']] = None,
                 constant_initialization_vector: Optional[pulumi.Input[str]] = None,
                 device_id: Optional[pulumi.Input[str]] = None,
                 key_type: Optional[pulumi.Input['FlowSourceEncryptionKeyType']] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 resource_id: Optional[pulumi.Input[str]] = None,
                 secret_arn: Optional[pulumi.Input[str]] = None,
                 url: Optional[pulumi.Input[str]] = None):
        """
        Information about the encryption of the flow.
        :param pulumi.Input[str] role_arn: The ARN of the role that you created during setup (when you set up AWS Elemental MediaConnect as a trusted entity).
        :param pulumi.Input['FlowSourceEncryptionAlgorithm'] algorithm: The type of algorithm that is used for the encryption (such as aes128, aes192, or aes256).
        :param pulumi.Input[str] constant_initialization_vector: A 128-bit, 16-byte hex value represented by a 32-character string, to be used with the key for encrypting content. This parameter is not valid for static key encryption.
        :param pulumi.Input[str] device_id: The value of one of the devices that you configured with your digital rights management (DRM) platform key provider. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        :param pulumi.Input['FlowSourceEncryptionKeyType'] key_type: The type of key that is used for the encryption. If no keyType is provided, the service will use the default setting (static-key).
        :param pulumi.Input[str] region: The AWS Region that the API Gateway proxy endpoint was created in. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        :param pulumi.Input[str] resource_id: An identifier for the content. The service sends this value to the key server to identify the current endpoint. The resource ID is also known as the content ID. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        :param pulumi.Input[str] secret_arn:  The ARN of the secret that you created in AWS Secrets Manager to store the encryption key. This parameter is required for static key encryption and is not valid for SPEKE encryption.
        :param pulumi.Input[str] url: The URL from the API Gateway proxy that you set up to talk to your key server. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        pulumi.set(__self__, "role_arn", role_arn)
        if algorithm is not None:
            pulumi.set(__self__, "algorithm", algorithm)
        if constant_initialization_vector is not None:
            pulumi.set(__self__, "constant_initialization_vector", constant_initialization_vector)
        if device_id is not None:
            pulumi.set(__self__, "device_id", device_id)
        if key_type is not None:
            pulumi.set(__self__, "key_type", key_type)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)
        if secret_arn is not None:
            pulumi.set(__self__, "secret_arn", secret_arn)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Input[str]:
        """
        The ARN of the role that you created during setup (when you set up AWS Elemental MediaConnect as a trusted entity).
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter
    def algorithm(self) -> Optional[pulumi.Input['FlowSourceEncryptionAlgorithm']]:
        """
        The type of algorithm that is used for the encryption (such as aes128, aes192, or aes256).
        """
        return pulumi.get(self, "algorithm")

    @algorithm.setter
    def algorithm(self, value: Optional[pulumi.Input['FlowSourceEncryptionAlgorithm']]):
        pulumi.set(self, "algorithm", value)

    @property
    @pulumi.getter(name="constantInitializationVector")
    def constant_initialization_vector(self) -> Optional[pulumi.Input[str]]:
        """
        A 128-bit, 16-byte hex value represented by a 32-character string, to be used with the key for encrypting content. This parameter is not valid for static key encryption.
        """
        return pulumi.get(self, "constant_initialization_vector")

    @constant_initialization_vector.setter
    def constant_initialization_vector(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "constant_initialization_vector", value)

    @property
    @pulumi.getter(name="deviceId")
    def device_id(self) -> Optional[pulumi.Input[str]]:
        """
        The value of one of the devices that you configured with your digital rights management (DRM) platform key provider. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        return pulumi.get(self, "device_id")

    @device_id.setter
    def device_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "device_id", value)

    @property
    @pulumi.getter(name="keyType")
    def key_type(self) -> Optional[pulumi.Input['FlowSourceEncryptionKeyType']]:
        """
        The type of key that is used for the encryption. If no keyType is provided, the service will use the default setting (static-key).
        """
        return pulumi.get(self, "key_type")

    @key_type.setter
    def key_type(self, value: Optional[pulumi.Input['FlowSourceEncryptionKeyType']]):
        pulumi.set(self, "key_type", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The AWS Region that the API Gateway proxy endpoint was created in. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        An identifier for the content. The service sends this value to the key server to identify the current endpoint. The resource ID is also known as the content ID. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)

    @property
    @pulumi.getter(name="secretArn")
    def secret_arn(self) -> Optional[pulumi.Input[str]]:
        """
         The ARN of the secret that you created in AWS Secrets Manager to store the encryption key. This parameter is required for static key encryption and is not valid for SPEKE encryption.
        """
        return pulumi.get(self, "secret_arn")

    @secret_arn.setter
    def secret_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_arn", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        The URL from the API Gateway proxy that you set up to talk to your key server. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)


if not MYPY:
    class FlowSourceGatewayBridgeSourceArgsDict(TypedDict):
        """
        The source configuration for cloud flows receiving a stream from a bridge.
        """
        bridge_arn: pulumi.Input[str]
        """
        The ARN of the bridge feeding this flow.
        """
        vpc_interface_attachment: NotRequired[pulumi.Input['FlowSourceVpcInterfaceAttachmentArgsDict']]
        """
        The name of the VPC interface attachment to use for this bridge source.
        """
elif False:
    FlowSourceGatewayBridgeSourceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FlowSourceGatewayBridgeSourceArgs:
    def __init__(__self__, *,
                 bridge_arn: pulumi.Input[str],
                 vpc_interface_attachment: Optional[pulumi.Input['FlowSourceVpcInterfaceAttachmentArgs']] = None):
        """
        The source configuration for cloud flows receiving a stream from a bridge.
        :param pulumi.Input[str] bridge_arn: The ARN of the bridge feeding this flow.
        :param pulumi.Input['FlowSourceVpcInterfaceAttachmentArgs'] vpc_interface_attachment: The name of the VPC interface attachment to use for this bridge source.
        """
        pulumi.set(__self__, "bridge_arn", bridge_arn)
        if vpc_interface_attachment is not None:
            pulumi.set(__self__, "vpc_interface_attachment", vpc_interface_attachment)

    @property
    @pulumi.getter(name="bridgeArn")
    def bridge_arn(self) -> pulumi.Input[str]:
        """
        The ARN of the bridge feeding this flow.
        """
        return pulumi.get(self, "bridge_arn")

    @bridge_arn.setter
    def bridge_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "bridge_arn", value)

    @property
    @pulumi.getter(name="vpcInterfaceAttachment")
    def vpc_interface_attachment(self) -> Optional[pulumi.Input['FlowSourceVpcInterfaceAttachmentArgs']]:
        """
        The name of the VPC interface attachment to use for this bridge source.
        """
        return pulumi.get(self, "vpc_interface_attachment")

    @vpc_interface_attachment.setter
    def vpc_interface_attachment(self, value: Optional[pulumi.Input['FlowSourceVpcInterfaceAttachmentArgs']]):
        pulumi.set(self, "vpc_interface_attachment", value)


if not MYPY:
    class FlowSourceMonitoringConfigArgsDict(TypedDict):
        """
        The settings for source monitoring.
        """
        thumbnail_state: pulumi.Input['FlowSourceMonitoringConfigThumbnailState']
        """
        The state of thumbnail monitoring.
        """
elif False:
    FlowSourceMonitoringConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FlowSourceMonitoringConfigArgs:
    def __init__(__self__, *,
                 thumbnail_state: pulumi.Input['FlowSourceMonitoringConfigThumbnailState']):
        """
        The settings for source monitoring.
        :param pulumi.Input['FlowSourceMonitoringConfigThumbnailState'] thumbnail_state: The state of thumbnail monitoring.
        """
        pulumi.set(__self__, "thumbnail_state", thumbnail_state)

    @property
    @pulumi.getter(name="thumbnailState")
    def thumbnail_state(self) -> pulumi.Input['FlowSourceMonitoringConfigThumbnailState']:
        """
        The state of thumbnail monitoring.
        """
        return pulumi.get(self, "thumbnail_state")

    @thumbnail_state.setter
    def thumbnail_state(self, value: pulumi.Input['FlowSourceMonitoringConfigThumbnailState']):
        pulumi.set(self, "thumbnail_state", value)


if not MYPY:
    class FlowSourceVpcInterfaceAttachmentArgsDict(TypedDict):
        """
        The settings for attaching a VPC interface to an resource.
        """
        vpc_interface_name: NotRequired[pulumi.Input[str]]
        """
        The name of the VPC interface to use for this resource.
        """
elif False:
    FlowSourceVpcInterfaceAttachmentArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FlowSourceVpcInterfaceAttachmentArgs:
    def __init__(__self__, *,
                 vpc_interface_name: Optional[pulumi.Input[str]] = None):
        """
        The settings for attaching a VPC interface to an resource.
        :param pulumi.Input[str] vpc_interface_name: The name of the VPC interface to use for this resource.
        """
        if vpc_interface_name is not None:
            pulumi.set(__self__, "vpc_interface_name", vpc_interface_name)

    @property
    @pulumi.getter(name="vpcInterfaceName")
    def vpc_interface_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the VPC interface to use for this resource.
        """
        return pulumi.get(self, "vpc_interface_name")

    @vpc_interface_name.setter
    def vpc_interface_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_interface_name", value)


if not MYPY:
    class FlowSourceArgsDict(TypedDict):
        """
        The settings for the source of the flow.
        """
        decryption: NotRequired[pulumi.Input['FlowEncryptionArgsDict']]
        """
        The type of decryption that is used on the content ingested from this source.
        """
        description: NotRequired[pulumi.Input[str]]
        """
        A description for the source. This value is not used or seen outside of the current AWS Elemental MediaConnect account.
        """
        entitlement_arn: NotRequired[pulumi.Input[str]]
        """
        The ARN of the entitlement that allows you to subscribe to content that comes from another AWS account. The entitlement is set by the content originator and the ARN is generated as part of the originator's flow.
        """
        gateway_bridge_source: NotRequired[pulumi.Input['FlowGatewayBridgeSourceArgsDict']]
        """
        The source configuration for cloud flows receiving a stream from a bridge.
        """
        ingest_ip: NotRequired[pulumi.Input[str]]
        """
        The IP address that the flow will be listening on for incoming content.
        """
        ingest_port: NotRequired[pulumi.Input[int]]
        """
        The port that the flow will be listening on for incoming content.
        """
        max_bitrate: NotRequired[pulumi.Input[int]]
        """
        The smoothing max bitrate for RIST, RTP, and RTP-FEC streams.
        """
        max_latency: NotRequired[pulumi.Input[int]]
        """
        The maximum latency in milliseconds. This parameter applies only to RIST-based and Zixi-based streams.
        """
        max_sync_buffer: NotRequired[pulumi.Input[int]]
        """
        The size of the buffer (in milliseconds) to use to sync incoming source data.
        """
        media_stream_source_configurations: NotRequired[pulumi.Input[Sequence[pulumi.Input['FlowMediaStreamSourceConfigurationArgsDict']]]]
        """
        The media stream that is associated with the source, and the parameters for that association.
        """
        min_latency: NotRequired[pulumi.Input[int]]
        """
        The minimum latency in milliseconds.
        """
        name: NotRequired[pulumi.Input[str]]
        """
        The name of the source.
        """
        protocol: NotRequired[pulumi.Input['FlowSourceProtocol']]
        """
        The protocol that is used by the source.
        """
        sender_control_port: NotRequired[pulumi.Input[int]]
        """
        The port that the flow uses to send outbound requests to initiate connection with the sender for fujitsu-qos protocol.
        """
        sender_ip_address: NotRequired[pulumi.Input[str]]
        """
        The IP address that the flow communicates with to initiate connection with the sender for fujitsu-qos protocol.
        """
        source_arn: NotRequired[pulumi.Input[str]]
        """
        The ARN of the source.
        """
        source_ingest_port: NotRequired[pulumi.Input[str]]
        """
        The port that the flow will be listening on for incoming content.(ReadOnly)
        """
        source_listener_address: NotRequired[pulumi.Input[str]]
        """
        Source IP or domain name for SRT-caller protocol.
        """
        source_listener_port: NotRequired[pulumi.Input[int]]
        """
        Source port for SRT-caller protocol.
        """
        stream_id: NotRequired[pulumi.Input[str]]
        """
        The stream ID that you want to use for this transport. This parameter applies only to Zixi-based streams.
        """
        vpc_interface_name: NotRequired[pulumi.Input[str]]
        """
        The name of the VPC Interface this Source is configured with.
        """
        whitelist_cidr: NotRequired[pulumi.Input[str]]
        """
        The range of IP addresses that should be allowed to contribute content to your source. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
        """
elif False:
    FlowSourceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FlowSourceArgs:
    def __init__(__self__, *,
                 decryption: Optional[pulumi.Input['FlowEncryptionArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 entitlement_arn: Optional[pulumi.Input[str]] = None,
                 gateway_bridge_source: Optional[pulumi.Input['FlowGatewayBridgeSourceArgs']] = None,
                 ingest_ip: Optional[pulumi.Input[str]] = None,
                 ingest_port: Optional[pulumi.Input[int]] = None,
                 max_bitrate: Optional[pulumi.Input[int]] = None,
                 max_latency: Optional[pulumi.Input[int]] = None,
                 max_sync_buffer: Optional[pulumi.Input[int]] = None,
                 media_stream_source_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['FlowMediaStreamSourceConfigurationArgs']]]] = None,
                 min_latency: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input['FlowSourceProtocol']] = None,
                 sender_control_port: Optional[pulumi.Input[int]] = None,
                 sender_ip_address: Optional[pulumi.Input[str]] = None,
                 source_arn: Optional[pulumi.Input[str]] = None,
                 source_ingest_port: Optional[pulumi.Input[str]] = None,
                 source_listener_address: Optional[pulumi.Input[str]] = None,
                 source_listener_port: Optional[pulumi.Input[int]] = None,
                 stream_id: Optional[pulumi.Input[str]] = None,
                 vpc_interface_name: Optional[pulumi.Input[str]] = None,
                 whitelist_cidr: Optional[pulumi.Input[str]] = None):
        """
        The settings for the source of the flow.
        :param pulumi.Input['FlowEncryptionArgs'] decryption: The type of decryption that is used on the content ingested from this source.
        :param pulumi.Input[str] description: A description for the source. This value is not used or seen outside of the current AWS Elemental MediaConnect account.
        :param pulumi.Input[str] entitlement_arn: The ARN of the entitlement that allows you to subscribe to content that comes from another AWS account. The entitlement is set by the content originator and the ARN is generated as part of the originator's flow.
        :param pulumi.Input['FlowGatewayBridgeSourceArgs'] gateway_bridge_source: The source configuration for cloud flows receiving a stream from a bridge.
        :param pulumi.Input[str] ingest_ip: The IP address that the flow will be listening on for incoming content.
        :param pulumi.Input[int] ingest_port: The port that the flow will be listening on for incoming content.
        :param pulumi.Input[int] max_bitrate: The smoothing max bitrate for RIST, RTP, and RTP-FEC streams.
        :param pulumi.Input[int] max_latency: The maximum latency in milliseconds. This parameter applies only to RIST-based and Zixi-based streams.
        :param pulumi.Input[int] max_sync_buffer: The size of the buffer (in milliseconds) to use to sync incoming source data.
        :param pulumi.Input[Sequence[pulumi.Input['FlowMediaStreamSourceConfigurationArgs']]] media_stream_source_configurations: The media stream that is associated with the source, and the parameters for that association.
        :param pulumi.Input[int] min_latency: The minimum latency in milliseconds.
        :param pulumi.Input[str] name: The name of the source.
        :param pulumi.Input['FlowSourceProtocol'] protocol: The protocol that is used by the source.
        :param pulumi.Input[int] sender_control_port: The port that the flow uses to send outbound requests to initiate connection with the sender for fujitsu-qos protocol.
        :param pulumi.Input[str] sender_ip_address: The IP address that the flow communicates with to initiate connection with the sender for fujitsu-qos protocol.
        :param pulumi.Input[str] source_arn: The ARN of the source.
        :param pulumi.Input[str] source_ingest_port: The port that the flow will be listening on for incoming content.(ReadOnly)
        :param pulumi.Input[str] source_listener_address: Source IP or domain name for SRT-caller protocol.
        :param pulumi.Input[int] source_listener_port: Source port for SRT-caller protocol.
        :param pulumi.Input[str] stream_id: The stream ID that you want to use for this transport. This parameter applies only to Zixi-based streams.
        :param pulumi.Input[str] vpc_interface_name: The name of the VPC Interface this Source is configured with.
        :param pulumi.Input[str] whitelist_cidr: The range of IP addresses that should be allowed to contribute content to your source. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
        """
        if decryption is not None:
            pulumi.set(__self__, "decryption", decryption)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if entitlement_arn is not None:
            pulumi.set(__self__, "entitlement_arn", entitlement_arn)
        if gateway_bridge_source is not None:
            pulumi.set(__self__, "gateway_bridge_source", gateway_bridge_source)
        if ingest_ip is not None:
            pulumi.set(__self__, "ingest_ip", ingest_ip)
        if ingest_port is not None:
            pulumi.set(__self__, "ingest_port", ingest_port)
        if max_bitrate is not None:
            pulumi.set(__self__, "max_bitrate", max_bitrate)
        if max_latency is not None:
            pulumi.set(__self__, "max_latency", max_latency)
        if max_sync_buffer is not None:
            pulumi.set(__self__, "max_sync_buffer", max_sync_buffer)
        if media_stream_source_configurations is not None:
            pulumi.set(__self__, "media_stream_source_configurations", media_stream_source_configurations)
        if min_latency is not None:
            pulumi.set(__self__, "min_latency", min_latency)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if sender_control_port is not None:
            pulumi.set(__self__, "sender_control_port", sender_control_port)
        if sender_ip_address is not None:
            pulumi.set(__self__, "sender_ip_address", sender_ip_address)
        if source_arn is not None:
            pulumi.set(__self__, "source_arn", source_arn)
        if source_ingest_port is not None:
            pulumi.set(__self__, "source_ingest_port", source_ingest_port)
        if source_listener_address is not None:
            pulumi.set(__self__, "source_listener_address", source_listener_address)
        if source_listener_port is not None:
            pulumi.set(__self__, "source_listener_port", source_listener_port)
        if stream_id is not None:
            pulumi.set(__self__, "stream_id", stream_id)
        if vpc_interface_name is not None:
            pulumi.set(__self__, "vpc_interface_name", vpc_interface_name)
        if whitelist_cidr is not None:
            pulumi.set(__self__, "whitelist_cidr", whitelist_cidr)

    @property
    @pulumi.getter
    def decryption(self) -> Optional[pulumi.Input['FlowEncryptionArgs']]:
        """
        The type of decryption that is used on the content ingested from this source.
        """
        return pulumi.get(self, "decryption")

    @decryption.setter
    def decryption(self, value: Optional[pulumi.Input['FlowEncryptionArgs']]):
        pulumi.set(self, "decryption", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A description for the source. This value is not used or seen outside of the current AWS Elemental MediaConnect account.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="entitlementArn")
    def entitlement_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the entitlement that allows you to subscribe to content that comes from another AWS account. The entitlement is set by the content originator and the ARN is generated as part of the originator's flow.
        """
        return pulumi.get(self, "entitlement_arn")

    @entitlement_arn.setter
    def entitlement_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "entitlement_arn", value)

    @property
    @pulumi.getter(name="gatewayBridgeSource")
    def gateway_bridge_source(self) -> Optional[pulumi.Input['FlowGatewayBridgeSourceArgs']]:
        """
        The source configuration for cloud flows receiving a stream from a bridge.
        """
        return pulumi.get(self, "gateway_bridge_source")

    @gateway_bridge_source.setter
    def gateway_bridge_source(self, value: Optional[pulumi.Input['FlowGatewayBridgeSourceArgs']]):
        pulumi.set(self, "gateway_bridge_source", value)

    @property
    @pulumi.getter(name="ingestIp")
    def ingest_ip(self) -> Optional[pulumi.Input[str]]:
        """
        The IP address that the flow will be listening on for incoming content.
        """
        return pulumi.get(self, "ingest_ip")

    @ingest_ip.setter
    def ingest_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ingest_ip", value)

    @property
    @pulumi.getter(name="ingestPort")
    def ingest_port(self) -> Optional[pulumi.Input[int]]:
        """
        The port that the flow will be listening on for incoming content.
        """
        return pulumi.get(self, "ingest_port")

    @ingest_port.setter
    def ingest_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ingest_port", value)

    @property
    @pulumi.getter(name="maxBitrate")
    def max_bitrate(self) -> Optional[pulumi.Input[int]]:
        """
        The smoothing max bitrate for RIST, RTP, and RTP-FEC streams.
        """
        return pulumi.get(self, "max_bitrate")

    @max_bitrate.setter
    def max_bitrate(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_bitrate", value)

    @property
    @pulumi.getter(name="maxLatency")
    def max_latency(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum latency in milliseconds. This parameter applies only to RIST-based and Zixi-based streams.
        """
        return pulumi.get(self, "max_latency")

    @max_latency.setter
    def max_latency(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_latency", value)

    @property
    @pulumi.getter(name="maxSyncBuffer")
    def max_sync_buffer(self) -> Optional[pulumi.Input[int]]:
        """
        The size of the buffer (in milliseconds) to use to sync incoming source data.
        """
        return pulumi.get(self, "max_sync_buffer")

    @max_sync_buffer.setter
    def max_sync_buffer(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_sync_buffer", value)

    @property
    @pulumi.getter(name="mediaStreamSourceConfigurations")
    def media_stream_source_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FlowMediaStreamSourceConfigurationArgs']]]]:
        """
        The media stream that is associated with the source, and the parameters for that association.
        """
        return pulumi.get(self, "media_stream_source_configurations")

    @media_stream_source_configurations.setter
    def media_stream_source_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FlowMediaStreamSourceConfigurationArgs']]]]):
        pulumi.set(self, "media_stream_source_configurations", value)

    @property
    @pulumi.getter(name="minLatency")
    def min_latency(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum latency in milliseconds.
        """
        return pulumi.get(self, "min_latency")

    @min_latency.setter
    def min_latency(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_latency", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the source.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input['FlowSourceProtocol']]:
        """
        The protocol that is used by the source.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input['FlowSourceProtocol']]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="senderControlPort")
    def sender_control_port(self) -> Optional[pulumi.Input[int]]:
        """
        The port that the flow uses to send outbound requests to initiate connection with the sender for fujitsu-qos protocol.
        """
        return pulumi.get(self, "sender_control_port")

    @sender_control_port.setter
    def sender_control_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "sender_control_port", value)

    @property
    @pulumi.getter(name="senderIpAddress")
    def sender_ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        The IP address that the flow communicates with to initiate connection with the sender for fujitsu-qos protocol.
        """
        return pulumi.get(self, "sender_ip_address")

    @sender_ip_address.setter
    def sender_ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sender_ip_address", value)

    @property
    @pulumi.getter(name="sourceArn")
    def source_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the source.
        """
        return pulumi.get(self, "source_arn")

    @source_arn.setter
    def source_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_arn", value)

    @property
    @pulumi.getter(name="sourceIngestPort")
    def source_ingest_port(self) -> Optional[pulumi.Input[str]]:
        """
        The port that the flow will be listening on for incoming content.(ReadOnly)
        """
        return pulumi.get(self, "source_ingest_port")

    @source_ingest_port.setter
    def source_ingest_port(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_ingest_port", value)

    @property
    @pulumi.getter(name="sourceListenerAddress")
    def source_listener_address(self) -> Optional[pulumi.Input[str]]:
        """
        Source IP or domain name for SRT-caller protocol.
        """
        return pulumi.get(self, "source_listener_address")

    @source_listener_address.setter
    def source_listener_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_listener_address", value)

    @property
    @pulumi.getter(name="sourceListenerPort")
    def source_listener_port(self) -> Optional[pulumi.Input[int]]:
        """
        Source port for SRT-caller protocol.
        """
        return pulumi.get(self, "source_listener_port")

    @source_listener_port.setter
    def source_listener_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "source_listener_port", value)

    @property
    @pulumi.getter(name="streamId")
    def stream_id(self) -> Optional[pulumi.Input[str]]:
        """
        The stream ID that you want to use for this transport. This parameter applies only to Zixi-based streams.
        """
        return pulumi.get(self, "stream_id")

    @stream_id.setter
    def stream_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "stream_id", value)

    @property
    @pulumi.getter(name="vpcInterfaceName")
    def vpc_interface_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the VPC Interface this Source is configured with.
        """
        return pulumi.get(self, "vpc_interface_name")

    @vpc_interface_name.setter
    def vpc_interface_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_interface_name", value)

    @property
    @pulumi.getter(name="whitelistCidr")
    def whitelist_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        The range of IP addresses that should be allowed to contribute content to your source. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
        """
        return pulumi.get(self, "whitelist_cidr")

    @whitelist_cidr.setter
    def whitelist_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "whitelist_cidr", value)


if not MYPY:
    class FlowVpcInterfaceAttachmentArgsDict(TypedDict):
        """
        The settings for attaching a VPC interface to an resource.
        """
        vpc_interface_name: NotRequired[pulumi.Input[str]]
        """
        The name of the VPC interface to use for this resource.
        """
elif False:
    FlowVpcInterfaceAttachmentArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FlowVpcInterfaceAttachmentArgs:
    def __init__(__self__, *,
                 vpc_interface_name: Optional[pulumi.Input[str]] = None):
        """
        The settings for attaching a VPC interface to an resource.
        :param pulumi.Input[str] vpc_interface_name: The name of the VPC interface to use for this resource.
        """
        if vpc_interface_name is not None:
            pulumi.set(__self__, "vpc_interface_name", vpc_interface_name)

    @property
    @pulumi.getter(name="vpcInterfaceName")
    def vpc_interface_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the VPC interface to use for this resource.
        """
        return pulumi.get(self, "vpc_interface_name")

    @vpc_interface_name.setter
    def vpc_interface_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_interface_name", value)


if not MYPY:
    class FlowVpcInterfaceArgsDict(TypedDict):
        """
        The details of a VPC interface.
        """
        name: pulumi.Input[str]
        """
        Immutable and has to be a unique against other VpcInterfaces in this Flow.
        """
        role_arn: pulumi.Input[str]
        """
        Role Arn MediaConnect can assume to create ENIs in customer's account.
        """
        security_group_ids: pulumi.Input[Sequence[pulumi.Input[str]]]
        """
        Security Group IDs to be used on ENI.
        """
        subnet_id: pulumi.Input[str]
        """
        Subnet must be in the AZ of the Flow
        """
        network_interface_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        IDs of the network interfaces created in customer's account by MediaConnect.
        """
        network_interface_type: NotRequired[pulumi.Input['FlowVpcInterfaceNetworkInterfaceType']]
        """
        The type of network adapter that you want MediaConnect to use on this interface. If you don't set this value, it defaults to ENA.
        """
elif False:
    FlowVpcInterfaceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FlowVpcInterfaceArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 role_arn: pulumi.Input[str],
                 security_group_ids: pulumi.Input[Sequence[pulumi.Input[str]]],
                 subnet_id: pulumi.Input[str],
                 network_interface_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 network_interface_type: Optional[pulumi.Input['FlowVpcInterfaceNetworkInterfaceType']] = None):
        """
        The details of a VPC interface.
        :param pulumi.Input[str] name: Immutable and has to be a unique against other VpcInterfaces in this Flow.
        :param pulumi.Input[str] role_arn: Role Arn MediaConnect can assume to create ENIs in customer's account.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: Security Group IDs to be used on ENI.
        :param pulumi.Input[str] subnet_id: Subnet must be in the AZ of the Flow
        :param pulumi.Input[Sequence[pulumi.Input[str]]] network_interface_ids: IDs of the network interfaces created in customer's account by MediaConnect.
        :param pulumi.Input['FlowVpcInterfaceNetworkInterfaceType'] network_interface_type: The type of network adapter that you want MediaConnect to use on this interface. If you don't set this value, it defaults to ENA.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "role_arn", role_arn)
        pulumi.set(__self__, "security_group_ids", security_group_ids)
        pulumi.set(__self__, "subnet_id", subnet_id)
        if network_interface_ids is not None:
            pulumi.set(__self__, "network_interface_ids", network_interface_ids)
        if network_interface_type is not None:
            pulumi.set(__self__, "network_interface_type", network_interface_type)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Immutable and has to be a unique against other VpcInterfaces in this Flow.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Input[str]:
        """
        Role Arn MediaConnect can assume to create ENIs in customer's account.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Security Group IDs to be used on ENI.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "security_group_ids", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[str]:
        """
        Subnet must be in the AZ of the Flow
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="networkInterfaceIds")
    def network_interface_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        IDs of the network interfaces created in customer's account by MediaConnect.
        """
        return pulumi.get(self, "network_interface_ids")

    @network_interface_ids.setter
    def network_interface_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "network_interface_ids", value)

    @property
    @pulumi.getter(name="networkInterfaceType")
    def network_interface_type(self) -> Optional[pulumi.Input['FlowVpcInterfaceNetworkInterfaceType']]:
        """
        The type of network adapter that you want MediaConnect to use on this interface. If you don't set this value, it defaults to ENA.
        """
        return pulumi.get(self, "network_interface_type")

    @network_interface_type.setter
    def network_interface_type(self, value: Optional[pulumi.Input['FlowVpcInterfaceNetworkInterfaceType']]):
        pulumi.set(self, "network_interface_type", value)


if not MYPY:
    class GatewayNetworkArgsDict(TypedDict):
        """
        The network settings for a gateway.
        """
        cidr_block: pulumi.Input[str]
        """
        A unique IP address range to use for this network. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
        """
        name: pulumi.Input[str]
        """
        The name of the network. This name is used to reference the network and must be unique among networks in this gateway.
        """
elif False:
    GatewayNetworkArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GatewayNetworkArgs:
    def __init__(__self__, *,
                 cidr_block: pulumi.Input[str],
                 name: pulumi.Input[str]):
        """
        The network settings for a gateway.
        :param pulumi.Input[str] cidr_block: A unique IP address range to use for this network. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
        :param pulumi.Input[str] name: The name of the network. This name is used to reference the network and must be unique among networks in this gateway.
        """
        pulumi.set(__self__, "cidr_block", cidr_block)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="cidrBlock")
    def cidr_block(self) -> pulumi.Input[str]:
        """
        A unique IP address range to use for this network. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
        """
        return pulumi.get(self, "cidr_block")

    @cidr_block.setter
    def cidr_block(self, value: pulumi.Input[str]):
        pulumi.set(self, "cidr_block", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the network. This name is used to reference the network and must be unique among networks in this gateway.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)


