# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AlertAction',
    'AlertLambdaConfiguration',
    'AlertSnsConfiguration',
    'AnomalyDetectorAppFlowConfig',
    'AnomalyDetectorCloudwatchConfig',
    'AnomalyDetectorConfig',
    'AnomalyDetectorCsvFormatDescriptor',
    'AnomalyDetectorFileFormatDescriptor',
    'AnomalyDetectorJsonFormatDescriptor',
    'AnomalyDetectorMetric',
    'AnomalyDetectorMetricSet',
    'AnomalyDetectorMetricSource',
    'AnomalyDetectorRdsSourceConfig',
    'AnomalyDetectorRedshiftSourceConfig',
    'AnomalyDetectorS3SourceConfig',
    'AnomalyDetectorTimestampColumn',
    'AnomalyDetectorVpcConfiguration',
]

@pulumi.output_type
class AlertAction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lambdaConfiguration":
            suggest = "lambda_configuration"
        elif key == "snsConfiguration":
            suggest = "sns_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlertAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlertAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlertAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 lambda_configuration: Optional['outputs.AlertLambdaConfiguration'] = None,
                 sns_configuration: Optional['outputs.AlertSnsConfiguration'] = None):
        """
        :param 'AlertLambdaConfiguration' lambda_configuration: A configuration for an AWS Lambda channel.
        :param 'AlertSnsConfiguration' sns_configuration: A configuration for an Amazon SNS channel.
        """
        if lambda_configuration is not None:
            pulumi.set(__self__, "lambda_configuration", lambda_configuration)
        if sns_configuration is not None:
            pulumi.set(__self__, "sns_configuration", sns_configuration)

    @property
    @pulumi.getter(name="lambdaConfiguration")
    def lambda_configuration(self) -> Optional['outputs.AlertLambdaConfiguration']:
        """
        A configuration for an AWS Lambda channel.
        """
        return pulumi.get(self, "lambda_configuration")

    @property
    @pulumi.getter(name="snsConfiguration")
    def sns_configuration(self) -> Optional['outputs.AlertSnsConfiguration']:
        """
        A configuration for an Amazon SNS channel.
        """
        return pulumi.get(self, "sns_configuration")


@pulumi.output_type
class AlertLambdaConfiguration(dict):
    """
    Configuration options for a Lambda alert action.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lambdaArn":
            suggest = "lambda_arn"
        elif key == "roleArn":
            suggest = "role_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlertLambdaConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlertLambdaConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlertLambdaConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 lambda_arn: str,
                 role_arn: str):
        """
        Configuration options for a Lambda alert action.
        :param str lambda_arn: ARN of a Lambda to send alert notifications to.
        :param str role_arn: ARN of an IAM role that LookoutMetrics should assume to access the Lambda function.
        """
        pulumi.set(__self__, "lambda_arn", lambda_arn)
        pulumi.set(__self__, "role_arn", role_arn)

    @property
    @pulumi.getter(name="lambdaArn")
    def lambda_arn(self) -> str:
        """
        ARN of a Lambda to send alert notifications to.
        """
        return pulumi.get(self, "lambda_arn")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> str:
        """
        ARN of an IAM role that LookoutMetrics should assume to access the Lambda function.
        """
        return pulumi.get(self, "role_arn")


@pulumi.output_type
class AlertSnsConfiguration(dict):
    """
    Configuration options for an SNS alert action.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "roleArn":
            suggest = "role_arn"
        elif key == "snsTopicArn":
            suggest = "sns_topic_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlertSnsConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlertSnsConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlertSnsConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 role_arn: str,
                 sns_topic_arn: str):
        """
        Configuration options for an SNS alert action.
        :param str role_arn: ARN of an IAM role that LookoutMetrics should assume to access the SNS topic.
        :param str sns_topic_arn: ARN of an SNS topic to send alert notifications to.
        """
        pulumi.set(__self__, "role_arn", role_arn)
        pulumi.set(__self__, "sns_topic_arn", sns_topic_arn)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> str:
        """
        ARN of an IAM role that LookoutMetrics should assume to access the SNS topic.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="snsTopicArn")
    def sns_topic_arn(self) -> str:
        """
        ARN of an SNS topic to send alert notifications to.
        """
        return pulumi.get(self, "sns_topic_arn")


@pulumi.output_type
class AnomalyDetectorAppFlowConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "flowName":
            suggest = "flow_name"
        elif key == "roleArn":
            suggest = "role_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AnomalyDetectorAppFlowConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AnomalyDetectorAppFlowConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AnomalyDetectorAppFlowConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 flow_name: str,
                 role_arn: str):
        """
        :param str flow_name: name of the flow.
        :param str role_arn: An IAM role that gives Amazon Lookout for Metrics permission to access the flow.
        """
        pulumi.set(__self__, "flow_name", flow_name)
        pulumi.set(__self__, "role_arn", role_arn)

    @property
    @pulumi.getter(name="flowName")
    def flow_name(self) -> str:
        """
        name of the flow.
        """
        return pulumi.get(self, "flow_name")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> str:
        """
        An IAM role that gives Amazon Lookout for Metrics permission to access the flow.
        """
        return pulumi.get(self, "role_arn")


@pulumi.output_type
class AnomalyDetectorCloudwatchConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "roleArn":
            suggest = "role_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AnomalyDetectorCloudwatchConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AnomalyDetectorCloudwatchConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AnomalyDetectorCloudwatchConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 role_arn: str):
        """
        :param str role_arn: An IAM role that gives Amazon Lookout for Metrics permission to access data in Amazon CloudWatch.
        """
        pulumi.set(__self__, "role_arn", role_arn)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> str:
        """
        An IAM role that gives Amazon Lookout for Metrics permission to access data in Amazon CloudWatch.
        """
        return pulumi.get(self, "role_arn")


@pulumi.output_type
class AnomalyDetectorConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "anomalyDetectorFrequency":
            suggest = "anomaly_detector_frequency"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AnomalyDetectorConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AnomalyDetectorConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AnomalyDetectorConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 anomaly_detector_frequency: 'AnomalyDetectorFrequency'):
        """
        :param 'AnomalyDetectorFrequency' anomaly_detector_frequency: Frequency of anomaly detection
        """
        pulumi.set(__self__, "anomaly_detector_frequency", anomaly_detector_frequency)

    @property
    @pulumi.getter(name="anomalyDetectorFrequency")
    def anomaly_detector_frequency(self) -> 'AnomalyDetectorFrequency':
        """
        Frequency of anomaly detection
        """
        return pulumi.get(self, "anomaly_detector_frequency")


@pulumi.output_type
class AnomalyDetectorCsvFormatDescriptor(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containsHeader":
            suggest = "contains_header"
        elif key == "fileCompression":
            suggest = "file_compression"
        elif key == "headerList":
            suggest = "header_list"
        elif key == "quoteSymbol":
            suggest = "quote_symbol"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AnomalyDetectorCsvFormatDescriptor. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AnomalyDetectorCsvFormatDescriptor.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AnomalyDetectorCsvFormatDescriptor.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 charset: Optional[str] = None,
                 contains_header: Optional[bool] = None,
                 delimiter: Optional[str] = None,
                 file_compression: Optional['AnomalyDetectorCsvFormatDescriptorFileCompression'] = None,
                 header_list: Optional[Sequence[str]] = None,
                 quote_symbol: Optional[str] = None):
        """
        :param str charset: The character set in which the source CSV file is written.
        :param bool contains_header: Whether or not the source CSV file contains a header.
        :param str delimiter: The character used to delimit the source CSV file.
        :param 'AnomalyDetectorCsvFormatDescriptorFileCompression' file_compression: The level of compression of the source CSV file.
        :param Sequence[str] header_list: A list of the source CSV file's headers, if any.
        :param str quote_symbol: The character used as a quote character.
        """
        if charset is not None:
            pulumi.set(__self__, "charset", charset)
        if contains_header is not None:
            pulumi.set(__self__, "contains_header", contains_header)
        if delimiter is not None:
            pulumi.set(__self__, "delimiter", delimiter)
        if file_compression is not None:
            pulumi.set(__self__, "file_compression", file_compression)
        if header_list is not None:
            pulumi.set(__self__, "header_list", header_list)
        if quote_symbol is not None:
            pulumi.set(__self__, "quote_symbol", quote_symbol)

    @property
    @pulumi.getter
    def charset(self) -> Optional[str]:
        """
        The character set in which the source CSV file is written.
        """
        return pulumi.get(self, "charset")

    @property
    @pulumi.getter(name="containsHeader")
    def contains_header(self) -> Optional[bool]:
        """
        Whether or not the source CSV file contains a header.
        """
        return pulumi.get(self, "contains_header")

    @property
    @pulumi.getter
    def delimiter(self) -> Optional[str]:
        """
        The character used to delimit the source CSV file.
        """
        return pulumi.get(self, "delimiter")

    @property
    @pulumi.getter(name="fileCompression")
    def file_compression(self) -> Optional['AnomalyDetectorCsvFormatDescriptorFileCompression']:
        """
        The level of compression of the source CSV file.
        """
        return pulumi.get(self, "file_compression")

    @property
    @pulumi.getter(name="headerList")
    def header_list(self) -> Optional[Sequence[str]]:
        """
        A list of the source CSV file's headers, if any.
        """
        return pulumi.get(self, "header_list")

    @property
    @pulumi.getter(name="quoteSymbol")
    def quote_symbol(self) -> Optional[str]:
        """
        The character used as a quote character.
        """
        return pulumi.get(self, "quote_symbol")


@pulumi.output_type
class AnomalyDetectorFileFormatDescriptor(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "csvFormatDescriptor":
            suggest = "csv_format_descriptor"
        elif key == "jsonFormatDescriptor":
            suggest = "json_format_descriptor"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AnomalyDetectorFileFormatDescriptor. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AnomalyDetectorFileFormatDescriptor.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AnomalyDetectorFileFormatDescriptor.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 csv_format_descriptor: Optional['outputs.AnomalyDetectorCsvFormatDescriptor'] = None,
                 json_format_descriptor: Optional['outputs.AnomalyDetectorJsonFormatDescriptor'] = None):
        """
        :param 'AnomalyDetectorCsvFormatDescriptor' csv_format_descriptor: Contains information about how a source CSV data file should be analyzed.
        :param 'AnomalyDetectorJsonFormatDescriptor' json_format_descriptor: Contains information about how a source JSON data file should be analyzed.
        """
        if csv_format_descriptor is not None:
            pulumi.set(__self__, "csv_format_descriptor", csv_format_descriptor)
        if json_format_descriptor is not None:
            pulumi.set(__self__, "json_format_descriptor", json_format_descriptor)

    @property
    @pulumi.getter(name="csvFormatDescriptor")
    def csv_format_descriptor(self) -> Optional['outputs.AnomalyDetectorCsvFormatDescriptor']:
        """
        Contains information about how a source CSV data file should be analyzed.
        """
        return pulumi.get(self, "csv_format_descriptor")

    @property
    @pulumi.getter(name="jsonFormatDescriptor")
    def json_format_descriptor(self) -> Optional['outputs.AnomalyDetectorJsonFormatDescriptor']:
        """
        Contains information about how a source JSON data file should be analyzed.
        """
        return pulumi.get(self, "json_format_descriptor")


@pulumi.output_type
class AnomalyDetectorJsonFormatDescriptor(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fileCompression":
            suggest = "file_compression"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AnomalyDetectorJsonFormatDescriptor. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AnomalyDetectorJsonFormatDescriptor.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AnomalyDetectorJsonFormatDescriptor.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 charset: Optional[str] = None,
                 file_compression: Optional['AnomalyDetectorJsonFormatDescriptorFileCompression'] = None):
        """
        :param str charset: The character set in which the source JSON file is written.
        :param 'AnomalyDetectorJsonFormatDescriptorFileCompression' file_compression: The level of compression of the source CSV file.
        """
        if charset is not None:
            pulumi.set(__self__, "charset", charset)
        if file_compression is not None:
            pulumi.set(__self__, "file_compression", file_compression)

    @property
    @pulumi.getter
    def charset(self) -> Optional[str]:
        """
        The character set in which the source JSON file is written.
        """
        return pulumi.get(self, "charset")

    @property
    @pulumi.getter(name="fileCompression")
    def file_compression(self) -> Optional['AnomalyDetectorJsonFormatDescriptorFileCompression']:
        """
        The level of compression of the source CSV file.
        """
        return pulumi.get(self, "file_compression")


@pulumi.output_type
class AnomalyDetectorMetric(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "aggregationFunction":
            suggest = "aggregation_function"
        elif key == "metricName":
            suggest = "metric_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AnomalyDetectorMetric. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AnomalyDetectorMetric.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AnomalyDetectorMetric.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aggregation_function: 'AnomalyDetectorMetricAggregationFunction',
                 metric_name: str,
                 namespace: Optional[str] = None):
        """
        :param 'AnomalyDetectorMetricAggregationFunction' aggregation_function: Operator used to aggregate metric values
        :param str metric_name: The name of the metric.
        :param str namespace: The namespace for the metric.
        """
        pulumi.set(__self__, "aggregation_function", aggregation_function)
        pulumi.set(__self__, "metric_name", metric_name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)

    @property
    @pulumi.getter(name="aggregationFunction")
    def aggregation_function(self) -> 'AnomalyDetectorMetricAggregationFunction':
        """
        Operator used to aggregate metric values
        """
        return pulumi.get(self, "aggregation_function")

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> str:
        """
        The name of the metric.
        """
        return pulumi.get(self, "metric_name")

    @property
    @pulumi.getter
    def namespace(self) -> Optional[str]:
        """
        The namespace for the metric.
        """
        return pulumi.get(self, "namespace")


@pulumi.output_type
class AnomalyDetectorMetricSet(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metricList":
            suggest = "metric_list"
        elif key == "metricSetName":
            suggest = "metric_set_name"
        elif key == "metricSource":
            suggest = "metric_source"
        elif key == "dimensionList":
            suggest = "dimension_list"
        elif key == "metricSetDescription":
            suggest = "metric_set_description"
        elif key == "metricSetFrequency":
            suggest = "metric_set_frequency"
        elif key == "timestampColumn":
            suggest = "timestamp_column"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AnomalyDetectorMetricSet. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AnomalyDetectorMetricSet.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AnomalyDetectorMetricSet.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 metric_list: Sequence['outputs.AnomalyDetectorMetric'],
                 metric_set_name: str,
                 metric_source: 'outputs.AnomalyDetectorMetricSource',
                 dimension_list: Optional[Sequence[str]] = None,
                 metric_set_description: Optional[str] = None,
                 metric_set_frequency: Optional['AnomalyDetectorMetricSetMetricSetFrequency'] = None,
                 offset: Optional[int] = None,
                 timestamp_column: Optional['outputs.AnomalyDetectorTimestampColumn'] = None,
                 timezone: Optional[str] = None):
        """
        :param Sequence['AnomalyDetectorMetric'] metric_list: Metrics captured by this MetricSet.
        :param str metric_set_name: The name of the MetricSet.
        :param 'AnomalyDetectorMetricSource' metric_source: Contains information about how the source data should be interpreted.
        :param Sequence[str] dimension_list: Dimensions for this MetricSet.
        :param str metric_set_description: A description for the MetricSet.
        :param 'AnomalyDetectorMetricSetMetricSetFrequency' metric_set_frequency: A frequency period to aggregate the data
        :param int offset: Offset, in seconds, between the frequency interval and the time at which the metrics are available.
        :param 'AnomalyDetectorTimestampColumn' timestamp_column: Contains information about the column used for tracking time in your source data.
        :param str timezone: The time zone in which your source data was recorded.
        """
        pulumi.set(__self__, "metric_list", metric_list)
        pulumi.set(__self__, "metric_set_name", metric_set_name)
        pulumi.set(__self__, "metric_source", metric_source)
        if dimension_list is not None:
            pulumi.set(__self__, "dimension_list", dimension_list)
        if metric_set_description is not None:
            pulumi.set(__self__, "metric_set_description", metric_set_description)
        if metric_set_frequency is not None:
            pulumi.set(__self__, "metric_set_frequency", metric_set_frequency)
        if offset is not None:
            pulumi.set(__self__, "offset", offset)
        if timestamp_column is not None:
            pulumi.set(__self__, "timestamp_column", timestamp_column)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)

    @property
    @pulumi.getter(name="metricList")
    def metric_list(self) -> Sequence['outputs.AnomalyDetectorMetric']:
        """
        Metrics captured by this MetricSet.
        """
        return pulumi.get(self, "metric_list")

    @property
    @pulumi.getter(name="metricSetName")
    def metric_set_name(self) -> str:
        """
        The name of the MetricSet.
        """
        return pulumi.get(self, "metric_set_name")

    @property
    @pulumi.getter(name="metricSource")
    def metric_source(self) -> 'outputs.AnomalyDetectorMetricSource':
        """
        Contains information about how the source data should be interpreted.
        """
        return pulumi.get(self, "metric_source")

    @property
    @pulumi.getter(name="dimensionList")
    def dimension_list(self) -> Optional[Sequence[str]]:
        """
        Dimensions for this MetricSet.
        """
        return pulumi.get(self, "dimension_list")

    @property
    @pulumi.getter(name="metricSetDescription")
    def metric_set_description(self) -> Optional[str]:
        """
        A description for the MetricSet.
        """
        return pulumi.get(self, "metric_set_description")

    @property
    @pulumi.getter(name="metricSetFrequency")
    def metric_set_frequency(self) -> Optional['AnomalyDetectorMetricSetMetricSetFrequency']:
        """
        A frequency period to aggregate the data
        """
        return pulumi.get(self, "metric_set_frequency")

    @property
    @pulumi.getter
    def offset(self) -> Optional[int]:
        """
        Offset, in seconds, between the frequency interval and the time at which the metrics are available.
        """
        return pulumi.get(self, "offset")

    @property
    @pulumi.getter(name="timestampColumn")
    def timestamp_column(self) -> Optional['outputs.AnomalyDetectorTimestampColumn']:
        """
        Contains information about the column used for tracking time in your source data.
        """
        return pulumi.get(self, "timestamp_column")

    @property
    @pulumi.getter
    def timezone(self) -> Optional[str]:
        """
        The time zone in which your source data was recorded.
        """
        return pulumi.get(self, "timezone")


@pulumi.output_type
class AnomalyDetectorMetricSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appFlowConfig":
            suggest = "app_flow_config"
        elif key == "cloudwatchConfig":
            suggest = "cloudwatch_config"
        elif key == "rdsSourceConfig":
            suggest = "rds_source_config"
        elif key == "redshiftSourceConfig":
            suggest = "redshift_source_config"
        elif key == "s3SourceConfig":
            suggest = "s3_source_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AnomalyDetectorMetricSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AnomalyDetectorMetricSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AnomalyDetectorMetricSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 app_flow_config: Optional['outputs.AnomalyDetectorAppFlowConfig'] = None,
                 cloudwatch_config: Optional['outputs.AnomalyDetectorCloudwatchConfig'] = None,
                 rds_source_config: Optional['outputs.AnomalyDetectorRdsSourceConfig'] = None,
                 redshift_source_config: Optional['outputs.AnomalyDetectorRedshiftSourceConfig'] = None,
                 s3_source_config: Optional['outputs.AnomalyDetectorS3SourceConfig'] = None):
        """
        :param 'AnomalyDetectorAppFlowConfig' app_flow_config: Details about an AppFlow datasource.
        :param 'AnomalyDetectorCloudwatchConfig' cloudwatch_config: Details about an Amazon CloudWatch monitoring datasource.
        :param 'AnomalyDetectorRdsSourceConfig' rds_source_config: Details about an Amazon Relational Database Service (RDS) datasource.
        :param 'AnomalyDetectorRedshiftSourceConfig' redshift_source_config: Details about an Amazon Redshift database datasource.
        :param 'AnomalyDetectorS3SourceConfig' s3_source_config: Contains information about the configuration of the S3 bucket that contains source files.
        """
        if app_flow_config is not None:
            pulumi.set(__self__, "app_flow_config", app_flow_config)
        if cloudwatch_config is not None:
            pulumi.set(__self__, "cloudwatch_config", cloudwatch_config)
        if rds_source_config is not None:
            pulumi.set(__self__, "rds_source_config", rds_source_config)
        if redshift_source_config is not None:
            pulumi.set(__self__, "redshift_source_config", redshift_source_config)
        if s3_source_config is not None:
            pulumi.set(__self__, "s3_source_config", s3_source_config)

    @property
    @pulumi.getter(name="appFlowConfig")
    def app_flow_config(self) -> Optional['outputs.AnomalyDetectorAppFlowConfig']:
        """
        Details about an AppFlow datasource.
        """
        return pulumi.get(self, "app_flow_config")

    @property
    @pulumi.getter(name="cloudwatchConfig")
    def cloudwatch_config(self) -> Optional['outputs.AnomalyDetectorCloudwatchConfig']:
        """
        Details about an Amazon CloudWatch monitoring datasource.
        """
        return pulumi.get(self, "cloudwatch_config")

    @property
    @pulumi.getter(name="rdsSourceConfig")
    def rds_source_config(self) -> Optional['outputs.AnomalyDetectorRdsSourceConfig']:
        """
        Details about an Amazon Relational Database Service (RDS) datasource.
        """
        return pulumi.get(self, "rds_source_config")

    @property
    @pulumi.getter(name="redshiftSourceConfig")
    def redshift_source_config(self) -> Optional['outputs.AnomalyDetectorRedshiftSourceConfig']:
        """
        Details about an Amazon Redshift database datasource.
        """
        return pulumi.get(self, "redshift_source_config")

    @property
    @pulumi.getter(name="s3SourceConfig")
    def s3_source_config(self) -> Optional['outputs.AnomalyDetectorS3SourceConfig']:
        """
        Contains information about the configuration of the S3 bucket that contains source files.
        """
        return pulumi.get(self, "s3_source_config")


@pulumi.output_type
class AnomalyDetectorRdsSourceConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "databaseHost":
            suggest = "database_host"
        elif key == "databaseName":
            suggest = "database_name"
        elif key == "databasePort":
            suggest = "database_port"
        elif key == "dbInstanceIdentifier":
            suggest = "db_instance_identifier"
        elif key == "roleArn":
            suggest = "role_arn"
        elif key == "secretManagerArn":
            suggest = "secret_manager_arn"
        elif key == "tableName":
            suggest = "table_name"
        elif key == "vpcConfiguration":
            suggest = "vpc_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AnomalyDetectorRdsSourceConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AnomalyDetectorRdsSourceConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AnomalyDetectorRdsSourceConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 database_host: str,
                 database_name: str,
                 database_port: int,
                 db_instance_identifier: str,
                 role_arn: str,
                 secret_manager_arn: str,
                 table_name: str,
                 vpc_configuration: 'outputs.AnomalyDetectorVpcConfiguration'):
        """
        :param str database_host: The host name of the database.
        :param str database_name: The name of the RDS database.
        :param int database_port: The port number where the database can be accessed.
        :param str db_instance_identifier: A string identifying the database instance.
        :param str role_arn: The Amazon Resource Name (ARN) of the role.
        :param str secret_manager_arn: The Amazon Resource Name (ARN) of the AWS Secrets Manager role.
        :param str table_name: The name of the table in the database.
        :param 'AnomalyDetectorVpcConfiguration' vpc_configuration: An object containing information about the Amazon Virtual Private Cloud (VPC) configuration.
        """
        pulumi.set(__self__, "database_host", database_host)
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "database_port", database_port)
        pulumi.set(__self__, "db_instance_identifier", db_instance_identifier)
        pulumi.set(__self__, "role_arn", role_arn)
        pulumi.set(__self__, "secret_manager_arn", secret_manager_arn)
        pulumi.set(__self__, "table_name", table_name)
        pulumi.set(__self__, "vpc_configuration", vpc_configuration)

    @property
    @pulumi.getter(name="databaseHost")
    def database_host(self) -> str:
        """
        The host name of the database.
        """
        return pulumi.get(self, "database_host")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> str:
        """
        The name of the RDS database.
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter(name="databasePort")
    def database_port(self) -> int:
        """
        The port number where the database can be accessed.
        """
        return pulumi.get(self, "database_port")

    @property
    @pulumi.getter(name="dbInstanceIdentifier")
    def db_instance_identifier(self) -> str:
        """
        A string identifying the database instance.
        """
        return pulumi.get(self, "db_instance_identifier")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> str:
        """
        The Amazon Resource Name (ARN) of the role.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="secretManagerArn")
    def secret_manager_arn(self) -> str:
        """
        The Amazon Resource Name (ARN) of the AWS Secrets Manager role.
        """
        return pulumi.get(self, "secret_manager_arn")

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> str:
        """
        The name of the table in the database.
        """
        return pulumi.get(self, "table_name")

    @property
    @pulumi.getter(name="vpcConfiguration")
    def vpc_configuration(self) -> 'outputs.AnomalyDetectorVpcConfiguration':
        """
        An object containing information about the Amazon Virtual Private Cloud (VPC) configuration.
        """
        return pulumi.get(self, "vpc_configuration")


@pulumi.output_type
class AnomalyDetectorRedshiftSourceConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterIdentifier":
            suggest = "cluster_identifier"
        elif key == "databaseHost":
            suggest = "database_host"
        elif key == "databaseName":
            suggest = "database_name"
        elif key == "databasePort":
            suggest = "database_port"
        elif key == "roleArn":
            suggest = "role_arn"
        elif key == "secretManagerArn":
            suggest = "secret_manager_arn"
        elif key == "tableName":
            suggest = "table_name"
        elif key == "vpcConfiguration":
            suggest = "vpc_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AnomalyDetectorRedshiftSourceConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AnomalyDetectorRedshiftSourceConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AnomalyDetectorRedshiftSourceConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster_identifier: str,
                 database_host: str,
                 database_name: str,
                 database_port: int,
                 role_arn: str,
                 secret_manager_arn: str,
                 table_name: str,
                 vpc_configuration: 'outputs.AnomalyDetectorVpcConfiguration'):
        """
        :param str cluster_identifier: A string identifying the Redshift cluster.
        :param str database_host: The name of the database host.
        :param str database_name: The Redshift database name.
        :param int database_port: The port number where the database can be accessed.
        :param str role_arn: The Amazon Resource Name (ARN) of the role providing access to the database.
        :param str secret_manager_arn: The Amazon Resource Name (ARN) of the AWS Secrets Manager role.
        :param str table_name: The table name of the Redshift database.
        :param 'AnomalyDetectorVpcConfiguration' vpc_configuration: Contains information about the Amazon Virtual Private Cloud (VPC) configuration.
        """
        pulumi.set(__self__, "cluster_identifier", cluster_identifier)
        pulumi.set(__self__, "database_host", database_host)
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "database_port", database_port)
        pulumi.set(__self__, "role_arn", role_arn)
        pulumi.set(__self__, "secret_manager_arn", secret_manager_arn)
        pulumi.set(__self__, "table_name", table_name)
        pulumi.set(__self__, "vpc_configuration", vpc_configuration)

    @property
    @pulumi.getter(name="clusterIdentifier")
    def cluster_identifier(self) -> str:
        """
        A string identifying the Redshift cluster.
        """
        return pulumi.get(self, "cluster_identifier")

    @property
    @pulumi.getter(name="databaseHost")
    def database_host(self) -> str:
        """
        The name of the database host.
        """
        return pulumi.get(self, "database_host")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> str:
        """
        The Redshift database name.
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter(name="databasePort")
    def database_port(self) -> int:
        """
        The port number where the database can be accessed.
        """
        return pulumi.get(self, "database_port")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> str:
        """
        The Amazon Resource Name (ARN) of the role providing access to the database.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="secretManagerArn")
    def secret_manager_arn(self) -> str:
        """
        The Amazon Resource Name (ARN) of the AWS Secrets Manager role.
        """
        return pulumi.get(self, "secret_manager_arn")

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> str:
        """
        The table name of the Redshift database.
        """
        return pulumi.get(self, "table_name")

    @property
    @pulumi.getter(name="vpcConfiguration")
    def vpc_configuration(self) -> 'outputs.AnomalyDetectorVpcConfiguration':
        """
        Contains information about the Amazon Virtual Private Cloud (VPC) configuration.
        """
        return pulumi.get(self, "vpc_configuration")


@pulumi.output_type
class AnomalyDetectorS3SourceConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fileFormatDescriptor":
            suggest = "file_format_descriptor"
        elif key == "roleArn":
            suggest = "role_arn"
        elif key == "historicalDataPathList":
            suggest = "historical_data_path_list"
        elif key == "templatedPathList":
            suggest = "templated_path_list"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AnomalyDetectorS3SourceConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AnomalyDetectorS3SourceConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AnomalyDetectorS3SourceConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 file_format_descriptor: 'outputs.AnomalyDetectorFileFormatDescriptor',
                 role_arn: str,
                 historical_data_path_list: Optional[Sequence[str]] = None,
                 templated_path_list: Optional[Sequence[str]] = None):
        """
        :param 'AnomalyDetectorFileFormatDescriptor' file_format_descriptor: Contains information about a source file's formatting.
        :param str role_arn: The ARN of an IAM role that has read and write access permissions to the source S3 bucket.
        :param Sequence[str] historical_data_path_list: A list of paths to the historical data files.
        :param Sequence[str] templated_path_list: A list of templated paths to the source files.
        """
        pulumi.set(__self__, "file_format_descriptor", file_format_descriptor)
        pulumi.set(__self__, "role_arn", role_arn)
        if historical_data_path_list is not None:
            pulumi.set(__self__, "historical_data_path_list", historical_data_path_list)
        if templated_path_list is not None:
            pulumi.set(__self__, "templated_path_list", templated_path_list)

    @property
    @pulumi.getter(name="fileFormatDescriptor")
    def file_format_descriptor(self) -> 'outputs.AnomalyDetectorFileFormatDescriptor':
        """
        Contains information about a source file's formatting.
        """
        return pulumi.get(self, "file_format_descriptor")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> str:
        """
        The ARN of an IAM role that has read and write access permissions to the source S3 bucket.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="historicalDataPathList")
    def historical_data_path_list(self) -> Optional[Sequence[str]]:
        """
        A list of paths to the historical data files.
        """
        return pulumi.get(self, "historical_data_path_list")

    @property
    @pulumi.getter(name="templatedPathList")
    def templated_path_list(self) -> Optional[Sequence[str]]:
        """
        A list of templated paths to the source files.
        """
        return pulumi.get(self, "templated_path_list")


@pulumi.output_type
class AnomalyDetectorTimestampColumn(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "columnFormat":
            suggest = "column_format"
        elif key == "columnName":
            suggest = "column_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AnomalyDetectorTimestampColumn. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AnomalyDetectorTimestampColumn.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AnomalyDetectorTimestampColumn.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 column_format: Optional[str] = None,
                 column_name: Optional[str] = None):
        """
        :param str column_format: A timestamp format for the timestamps in the dataset
        :param str column_name: The name of the timestamp column.
        """
        if column_format is not None:
            pulumi.set(__self__, "column_format", column_format)
        if column_name is not None:
            pulumi.set(__self__, "column_name", column_name)

    @property
    @pulumi.getter(name="columnFormat")
    def column_format(self) -> Optional[str]:
        """
        A timestamp format for the timestamps in the dataset
        """
        return pulumi.get(self, "column_format")

    @property
    @pulumi.getter(name="columnName")
    def column_name(self) -> Optional[str]:
        """
        The name of the timestamp column.
        """
        return pulumi.get(self, "column_name")


@pulumi.output_type
class AnomalyDetectorVpcConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "securityGroupIdList":
            suggest = "security_group_id_list"
        elif key == "subnetIdList":
            suggest = "subnet_id_list"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AnomalyDetectorVpcConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AnomalyDetectorVpcConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AnomalyDetectorVpcConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 security_group_id_list: Sequence[str],
                 subnet_id_list: Sequence[str]):
        """
        :param Sequence[str] security_group_id_list: An array of strings containing the list of security groups.
        :param Sequence[str] subnet_id_list: An array of strings containing the Amazon VPC subnet IDs (e.g., `subnet-0bb1c79de3EXAMPLE` .
        """
        pulumi.set(__self__, "security_group_id_list", security_group_id_list)
        pulumi.set(__self__, "subnet_id_list", subnet_id_list)

    @property
    @pulumi.getter(name="securityGroupIdList")
    def security_group_id_list(self) -> Sequence[str]:
        """
        An array of strings containing the list of security groups.
        """
        return pulumi.get(self, "security_group_id_list")

    @property
    @pulumi.getter(name="subnetIdList")
    def subnet_id_list(self) -> Sequence[str]:
        """
        An array of strings containing the Amazon VPC subnet IDs (e.g., `subnet-0bb1c79de3EXAMPLE` .
        """
        return pulumi.get(self, "subnet_id_list")


