# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'DeliveryDestinationDestinationPolicy',
    'MetricFilterDimension',
    'MetricFilterMetricTransformation',
]

@pulumi.output_type
class DeliveryDestinationDestinationPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deliveryDestinationName":
            suggest = "delivery_destination_name"
        elif key == "deliveryDestinationPolicy":
            suggest = "delivery_destination_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeliveryDestinationDestinationPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeliveryDestinationDestinationPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeliveryDestinationDestinationPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 delivery_destination_name: str,
                 delivery_destination_policy: str):
        """
        :param str delivery_destination_name: The name of the delivery destination to assign this policy to
        :param str delivery_destination_policy: The contents of the policy attached to the delivery destination
        """
        pulumi.set(__self__, "delivery_destination_name", delivery_destination_name)
        pulumi.set(__self__, "delivery_destination_policy", delivery_destination_policy)

    @property
    @pulumi.getter(name="deliveryDestinationName")
    def delivery_destination_name(self) -> str:
        """
        The name of the delivery destination to assign this policy to
        """
        return pulumi.get(self, "delivery_destination_name")

    @property
    @pulumi.getter(name="deliveryDestinationPolicy")
    def delivery_destination_policy(self) -> str:
        """
        The contents of the policy attached to the delivery destination
        """
        return pulumi.get(self, "delivery_destination_policy")


@pulumi.output_type
class MetricFilterDimension(dict):
    """
    Specifies the CW metric dimensions to publish with this metric.
      Because dimensions are part of the unique identifier for a metric, whenever a unique dimension name/value pair is extracted from your logs, you are creating a new variation of that metric.
     For more information about publishing dimensions with metrics created by metric filters, see [Publishing dimensions with metrics from values in JSON or space-delimited log events](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/FilterAndPatternSyntax.html#logs-metric-filters-dimensions).
      Metrics extracted from log events are charged as custom metrics. To prevent unexpected high charges, do not specify high-cardinality fields such as ``IPAddress`` or ``requestID`` as dimensions. Each different value found for a dimension is treated as a separate metric and accrues charges as a separate custom metric. 
     To help prevent accidental high charges, Amazon disables a metric filter if it generates 1000 different name/value pairs for the dimensions that you have specified within a certain amount of time.
     You can also set up a billing alarm to alert you if your charges are higher than expected. For more information, see [Creating a Billing Alarm to Monitor Your Estimated Charges](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/monitor_estimated_charges_with_cloudwatch.html).
    """
    def __init__(__self__, *,
                 key: str,
                 value: str):
        """
        Specifies the CW metric dimensions to publish with this metric.
          Because dimensions are part of the unique identifier for a metric, whenever a unique dimension name/value pair is extracted from your logs, you are creating a new variation of that metric.
         For more information about publishing dimensions with metrics created by metric filters, see [Publishing dimensions with metrics from values in JSON or space-delimited log events](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/FilterAndPatternSyntax.html#logs-metric-filters-dimensions).
          Metrics extracted from log events are charged as custom metrics. To prevent unexpected high charges, do not specify high-cardinality fields such as ``IPAddress`` or ``requestID`` as dimensions. Each different value found for a dimension is treated as a separate metric and accrues charges as a separate custom metric. 
         To help prevent accidental high charges, Amazon disables a metric filter if it generates 1000 different name/value pairs for the dimensions that you have specified within a certain amount of time.
         You can also set up a billing alarm to alert you if your charges are higher than expected. For more information, see [Creating a Billing Alarm to Monitor Your Estimated Charges](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/monitor_estimated_charges_with_cloudwatch.html).
        :param str key: The name for the CW metric dimension that the metric filter creates.
                Dimension names must contain only ASCII characters, must include at least one non-whitespace character, and cannot start with a colon (:).
        :param str value: The log event field that will contain the value for this dimension. This dimension will only be published for a metric if the value is found in the log event. For example, ``$.eventType`` for JSON log events, or ``$server`` for space-delimited log events.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The name for the CW metric dimension that the metric filter creates.
         Dimension names must contain only ASCII characters, must include at least one non-whitespace character, and cannot start with a colon (:).
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The log event field that will contain the value for this dimension. This dimension will only be published for a metric if the value is found in the log event. For example, ``$.eventType`` for JSON log events, or ``$server`` for space-delimited log events.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class MetricFilterMetricTransformation(dict):
    """
    ``MetricTransformation`` is a property of the ``AWS::Logs::MetricFilter`` resource that describes how to transform log streams into a CloudWatch metric.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metricName":
            suggest = "metric_name"
        elif key == "metricNamespace":
            suggest = "metric_namespace"
        elif key == "metricValue":
            suggest = "metric_value"
        elif key == "defaultValue":
            suggest = "default_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetricFilterMetricTransformation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetricFilterMetricTransformation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetricFilterMetricTransformation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 metric_name: str,
                 metric_namespace: str,
                 metric_value: str,
                 default_value: Optional[float] = None,
                 dimensions: Optional[Sequence['outputs.MetricFilterDimension']] = None,
                 unit: Optional['MetricFilterMetricTransformationUnit'] = None):
        """
        ``MetricTransformation`` is a property of the ``AWS::Logs::MetricFilter`` resource that describes how to transform log streams into a CloudWatch metric.
        :param str metric_name: The name of the CloudWatch metric.
        :param str metric_namespace: A custom namespace to contain your metric in CloudWatch. Use namespaces to group together metrics that are similar. For more information, see [Namespaces](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Namespace).
        :param str metric_value: The value that is published to the CloudWatch metric. For example, if you're counting the occurrences of a particular term like ``Error``, specify 1 for the metric value. If you're counting the number of bytes transferred, reference the value that is in the log event by using $. followed by the name of the field that you specified in the filter pattern, such as ``$.size``.
        :param float default_value: (Optional) The value to emit when a filter pattern does not match a log event. This value can be null.
        :param Sequence['MetricFilterDimension'] dimensions: The fields to use as dimensions for the metric. One metric filter can include as many as three dimensions.
                 Metrics extracted from log events are charged as custom metrics. To prevent unexpected high charges, do not specify high-cardinality fields such as ``IPAddress`` or ``requestID`` as dimensions. Each different value found for a dimension is treated as a separate metric and accrues charges as a separate custom metric. 
                CloudWatch Logs disables a metric filter if it generates 1000 different name/value pairs for your specified dimensions within a certain amount of time. This helps to prevent accidental high charges.
                You can also set up a billing alarm to alert you if your charges are higher than expected. For more information, see [Creating a Billing Alarm to Monitor Your Estimated Charges](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/monitor_estimated_charges_with_cloudwatch.html).
        :param 'MetricFilterMetricTransformationUnit' unit: The unit to assign to the metric. If you omit this, the unit is set as ``None``.
        """
        pulumi.set(__self__, "metric_name", metric_name)
        pulumi.set(__self__, "metric_namespace", metric_namespace)
        pulumi.set(__self__, "metric_value", metric_value)
        if default_value is not None:
            pulumi.set(__self__, "default_value", default_value)
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)
        if unit is not None:
            pulumi.set(__self__, "unit", unit)

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> str:
        """
        The name of the CloudWatch metric.
        """
        return pulumi.get(self, "metric_name")

    @property
    @pulumi.getter(name="metricNamespace")
    def metric_namespace(self) -> str:
        """
        A custom namespace to contain your metric in CloudWatch. Use namespaces to group together metrics that are similar. For more information, see [Namespaces](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Namespace).
        """
        return pulumi.get(self, "metric_namespace")

    @property
    @pulumi.getter(name="metricValue")
    def metric_value(self) -> str:
        """
        The value that is published to the CloudWatch metric. For example, if you're counting the occurrences of a particular term like ``Error``, specify 1 for the metric value. If you're counting the number of bytes transferred, reference the value that is in the log event by using $. followed by the name of the field that you specified in the filter pattern, such as ``$.size``.
        """
        return pulumi.get(self, "metric_value")

    @property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> Optional[float]:
        """
        (Optional) The value to emit when a filter pattern does not match a log event. This value can be null.
        """
        return pulumi.get(self, "default_value")

    @property
    @pulumi.getter
    def dimensions(self) -> Optional[Sequence['outputs.MetricFilterDimension']]:
        """
        The fields to use as dimensions for the metric. One metric filter can include as many as three dimensions.
          Metrics extracted from log events are charged as custom metrics. To prevent unexpected high charges, do not specify high-cardinality fields such as ``IPAddress`` or ``requestID`` as dimensions. Each different value found for a dimension is treated as a separate metric and accrues charges as a separate custom metric. 
         CloudWatch Logs disables a metric filter if it generates 1000 different name/value pairs for your specified dimensions within a certain amount of time. This helps to prevent accidental high charges.
         You can also set up a billing alarm to alert you if your charges are higher than expected. For more information, see [Creating a Billing Alarm to Monitor Your Estimated Charges](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/monitor_estimated_charges_with_cloudwatch.html).
        """
        return pulumi.get(self, "dimensions")

    @property
    @pulumi.getter
    def unit(self) -> Optional['MetricFilterMetricTransformationUnit']:
        """
        The unit to assign to the metric. If you omit this, the unit is set as ``None``.
        """
        return pulumi.get(self, "unit")


