# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetLogGroupResult',
    'AwaitableGetLogGroupResult',
    'get_log_group',
    'get_log_group_output',
]

@pulumi.output_type
class GetLogGroupResult:
    def __init__(__self__, arn=None, data_protection_policy=None, kms_key_id=None, log_group_class=None, retention_in_days=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if data_protection_policy and not isinstance(data_protection_policy, dict):
            raise TypeError("Expected argument 'data_protection_policy' to be a dict")
        pulumi.set(__self__, "data_protection_policy", data_protection_policy)
        if kms_key_id and not isinstance(kms_key_id, str):
            raise TypeError("Expected argument 'kms_key_id' to be a str")
        pulumi.set(__self__, "kms_key_id", kms_key_id)
        if log_group_class and not isinstance(log_group_class, str):
            raise TypeError("Expected argument 'log_group_class' to be a str")
        pulumi.set(__self__, "log_group_class", log_group_class)
        if retention_in_days and not isinstance(retention_in_days, int):
            raise TypeError("Expected argument 'retention_in_days' to be a int")
        pulumi.set(__self__, "retention_in_days", retention_in_days)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def arn(self) -> Optional[str]:
        """
        The ARN of the log group, such as `arn:aws:logs:us-west-1:123456789012:log-group:/mystack-testgroup-12ABC1AB12A1:*`
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="dataProtectionPolicy")
    def data_protection_policy(self) -> Optional[Any]:
        """
        Creates a data protection policy and assigns it to the log group. A data protection policy can help safeguard sensitive data that's ingested by the log group by auditing and masking the sensitive log data. When a user who does not have permission to view masked data views a log event that includes masked data, the sensitive data is replaced by asterisks.
         For more information, including a list of types of data that can be audited and masked, see [Protect sensitive log data with masking](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/mask-sensitive-log-data.html).

        Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::Logs::LogGroup` for more information about the expected schema for this property.
        """
        return pulumi.get(self, "data_protection_policy")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the KMS key to use when encrypting log data.
         To associate an KMS key with the log group, specify the ARN of that KMS key here. If you do so, ingested data is encrypted using this key. This association is stored as long as the data encrypted with the KMS key is still within CWL. This enables CWL to decrypt this data whenever it is requested.
         If you attempt to associate a KMS key with the log group but the KMS key doesn't exist or is deactivated, you will receive an ``InvalidParameterException`` error.
         Log group data is always encrypted in CWL. If you omit this key, the encryption does not use KMS. For more information, see [Encrypt log data in using](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/encrypt-log-data-kms.html)
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="logGroupClass")
    def log_group_class(self) -> Optional['LogGroupClass']:
        """
        Specifies the log group class for this log group. There are two classes:
          +  The ``Standard`` log class supports all CWL features.
          +  The ``Infrequent Access`` log class supports a subset of CWL features and incurs lower costs.
          
         For details about the features supported by each class, see [Log classes](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch_Logs_Log_Classes.html)
        """
        return pulumi.get(self, "log_group_class")

    @property
    @pulumi.getter(name="retentionInDays")
    def retention_in_days(self) -> Optional[int]:
        """
        The number of days to retain the log events in the specified log group. Possible values are: 1, 3, 5, 7, 14, 30, 60, 90, 120, 150, 180, 365, 400, 545, 731, 1096, 1827, 2192, 2557, 2922, 3288, and 3653.
         To set a log group so that its log events do not expire, use [DeleteRetentionPolicy](https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DeleteRetentionPolicy.html).
        """
        return pulumi.get(self, "retention_in_days")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        An array of key-value pairs to apply to the log group.
         For more information, see [Tag](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html).
        """
        return pulumi.get(self, "tags")


class AwaitableGetLogGroupResult(GetLogGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLogGroupResult(
            arn=self.arn,
            data_protection_policy=self.data_protection_policy,
            kms_key_id=self.kms_key_id,
            log_group_class=self.log_group_class,
            retention_in_days=self.retention_in_days,
            tags=self.tags)


def get_log_group(log_group_name: Optional[str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLogGroupResult:
    """
    The ``AWS::Logs::LogGroup`` resource specifies a log group. A log group defines common properties for log streams, such as their retention and access control rules. Each log stream must belong to one log group.
     You can create up to 1,000,000 log groups per Region per account. You must use the following guidelines when naming a log group:
      +  Log group names must be unique within a Region for an AWS account.
      +  Log group names can be between 1 and 512 characters long.
      +  Log group names consist of the following characters: a-z, A-Z, 0-9, '_' (underscore), '-' (hyphen), '/' (forward slash), and '.' (period).


    :param str log_group_name: The name of the log group. If you don't specify a name, CFNlong generates a unique ID for the log group.
    """
    __args__ = dict()
    __args__['logGroupName'] = log_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:logs:getLogGroup', __args__, opts=opts, typ=GetLogGroupResult).value

    return AwaitableGetLogGroupResult(
        arn=pulumi.get(__ret__, 'arn'),
        data_protection_policy=pulumi.get(__ret__, 'data_protection_policy'),
        kms_key_id=pulumi.get(__ret__, 'kms_key_id'),
        log_group_class=pulumi.get(__ret__, 'log_group_class'),
        retention_in_days=pulumi.get(__ret__, 'retention_in_days'),
        tags=pulumi.get(__ret__, 'tags'))
def get_log_group_output(log_group_name: Optional[pulumi.Input[str]] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetLogGroupResult]:
    """
    The ``AWS::Logs::LogGroup`` resource specifies a log group. A log group defines common properties for log streams, such as their retention and access control rules. Each log stream must belong to one log group.
     You can create up to 1,000,000 log groups per Region per account. You must use the following guidelines when naming a log group:
      +  Log group names must be unique within a Region for an AWS account.
      +  Log group names can be between 1 and 512 characters long.
      +  Log group names consist of the following characters: a-z, A-Z, 0-9, '_' (underscore), '-' (hyphen), '/' (forward slash), and '.' (period).


    :param str log_group_name: The name of the log group. If you don't specify a name, CFNlong generates a unique ID for the log group.
    """
    __args__ = dict()
    __args__['logGroupName'] = log_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:logs:getLogGroup', __args__, opts=opts, typ=GetLogGroupResult)
    return __ret__.apply(lambda __response__: GetLogGroupResult(
        arn=pulumi.get(__response__, 'arn'),
        data_protection_policy=pulumi.get(__response__, 'data_protection_policy'),
        kms_key_id=pulumi.get(__response__, 'kms_key_id'),
        log_group_class=pulumi.get(__response__, 'log_group_class'),
        retention_in_days=pulumi.get(__response__, 'retention_in_days'),
        tags=pulumi.get(__response__, 'tags')))
