# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._inputs import *

__all__ = ['DeliveryDestinationArgs', 'DeliveryDestination']

@pulumi.input_type
class DeliveryDestinationArgs:
    def __init__(__self__, *,
                 delivery_destination_policy: Optional[pulumi.Input[Sequence[pulumi.Input['DeliveryDestinationDestinationPolicyArgs']]]] = None,
                 destination_resource_arn: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a DeliveryDestination resource.
        :param pulumi.Input[Sequence[pulumi.Input['DeliveryDestinationDestinationPolicyArgs']]] delivery_destination_policy: IAM policy that grants permissions to CloudWatch Logs to deliver logs cross-account to a specified destination in this account.
               
               The policy must be in JSON string format.
               
               Length Constraints: Maximum length of 51200
        :param pulumi.Input[str] destination_resource_arn: The ARN of the Amazon Web Services destination that this delivery destination represents. That Amazon Web Services destination can be a log group in CloudWatch Logs, an Amazon S3 bucket, or a delivery stream in Firehose.
        :param pulumi.Input[str] name: The name of this delivery destination.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: The tags that have been assigned to this delivery destination.
        """
        if delivery_destination_policy is not None:
            pulumi.set(__self__, "delivery_destination_policy", delivery_destination_policy)
        if destination_resource_arn is not None:
            pulumi.set(__self__, "destination_resource_arn", destination_resource_arn)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="deliveryDestinationPolicy")
    def delivery_destination_policy(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeliveryDestinationDestinationPolicyArgs']]]]:
        """
        IAM policy that grants permissions to CloudWatch Logs to deliver logs cross-account to a specified destination in this account.

        The policy must be in JSON string format.

        Length Constraints: Maximum length of 51200
        """
        return pulumi.get(self, "delivery_destination_policy")

    @delivery_destination_policy.setter
    def delivery_destination_policy(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeliveryDestinationDestinationPolicyArgs']]]]):
        pulumi.set(self, "delivery_destination_policy", value)

    @property
    @pulumi.getter(name="destinationResourceArn")
    def destination_resource_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the Amazon Web Services destination that this delivery destination represents. That Amazon Web Services destination can be a log group in CloudWatch Logs, an Amazon S3 bucket, or a delivery stream in Firehose.
        """
        return pulumi.get(self, "destination_resource_arn")

    @destination_resource_arn.setter
    def destination_resource_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_resource_arn", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of this delivery destination.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        The tags that have been assigned to this delivery destination.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


class DeliveryDestination(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 delivery_destination_policy: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DeliveryDestinationDestinationPolicyArgs', 'DeliveryDestinationDestinationPolicyArgsDict']]]]] = None,
                 destination_resource_arn: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        This structure contains information about one delivery destination in your account.

        A delivery destination is an AWS resource that represents an AWS service that logs can be sent to CloudWatch Logs, Amazon S3, are supported as Kinesis Data Firehose delivery destinations.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DeliveryDestinationDestinationPolicyArgs', 'DeliveryDestinationDestinationPolicyArgsDict']]]] delivery_destination_policy: IAM policy that grants permissions to CloudWatch Logs to deliver logs cross-account to a specified destination in this account.
               
               The policy must be in JSON string format.
               
               Length Constraints: Maximum length of 51200
        :param pulumi.Input[str] destination_resource_arn: The ARN of the Amazon Web Services destination that this delivery destination represents. That Amazon Web Services destination can be a log group in CloudWatch Logs, an Amazon S3 bucket, or a delivery stream in Firehose.
        :param pulumi.Input[str] name: The name of this delivery destination.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: The tags that have been assigned to this delivery destination.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[DeliveryDestinationArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This structure contains information about one delivery destination in your account.

        A delivery destination is an AWS resource that represents an AWS service that logs can be sent to CloudWatch Logs, Amazon S3, are supported as Kinesis Data Firehose delivery destinations.

        :param str resource_name: The name of the resource.
        :param DeliveryDestinationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DeliveryDestinationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 delivery_destination_policy: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DeliveryDestinationDestinationPolicyArgs', 'DeliveryDestinationDestinationPolicyArgsDict']]]]] = None,
                 destination_resource_arn: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DeliveryDestinationArgs.__new__(DeliveryDestinationArgs)

            __props__.__dict__["delivery_destination_policy"] = delivery_destination_policy
            __props__.__dict__["destination_resource_arn"] = destination_resource_arn
            __props__.__dict__["name"] = name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["delivery_destination_type"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["destinationResourceArn", "name"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(DeliveryDestination, __self__).__init__(
            'aws-native:logs:DeliveryDestination',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'DeliveryDestination':
        """
        Get an existing DeliveryDestination resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = DeliveryDestinationArgs.__new__(DeliveryDestinationArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["delivery_destination_policy"] = None
        __props__.__dict__["delivery_destination_type"] = None
        __props__.__dict__["destination_resource_arn"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["tags"] = None
        return DeliveryDestination(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN) that uniquely identifies this delivery destination.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="deliveryDestinationPolicy")
    def delivery_destination_policy(self) -> pulumi.Output[Optional[Sequence['outputs.DeliveryDestinationDestinationPolicy']]]:
        """
        IAM policy that grants permissions to CloudWatch Logs to deliver logs cross-account to a specified destination in this account.

        The policy must be in JSON string format.

        Length Constraints: Maximum length of 51200
        """
        return pulumi.get(self, "delivery_destination_policy")

    @property
    @pulumi.getter(name="deliveryDestinationType")
    def delivery_destination_type(self) -> pulumi.Output[str]:
        """
        Displays whether this delivery destination is CloudWatch Logs, Amazon S3, or Kinesis Data Firehose.
        """
        return pulumi.get(self, "delivery_destination_type")

    @property
    @pulumi.getter(name="destinationResourceArn")
    def destination_resource_arn(self) -> pulumi.Output[Optional[str]]:
        """
        The ARN of the Amazon Web Services destination that this delivery destination represents. That Amazon Web Services destination can be a log group in CloudWatch Logs, an Amazon S3 bucket, or a delivery stream in Firehose.
        """
        return pulumi.get(self, "destination_resource_arn")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of this delivery destination.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        The tags that have been assigned to this delivery destination.
        """
        return pulumi.get(self, "tags")

