# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = ['AccountPolicyArgs', 'AccountPolicy']

@pulumi.input_type
class AccountPolicyArgs:
    def __init__(__self__, *,
                 policy_document: pulumi.Input[str],
                 policy_type: pulumi.Input['AccountPolicyPolicyType'],
                 policy_name: Optional[pulumi.Input[str]] = None,
                 scope: Optional[pulumi.Input['AccountPolicyScope']] = None,
                 selection_criteria: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a AccountPolicy resource.
        :param pulumi.Input[str] policy_document: The body of the policy document you want to use for this topic.
               
               You can only add one policy per PolicyType.
               
               The policy must be in JSON string format.
               
               Length Constraints: Maximum length of 30720
        :param pulumi.Input['AccountPolicyPolicyType'] policy_type: Type of the policy.
        :param pulumi.Input[str] policy_name: The name of the account policy
        :param pulumi.Input['AccountPolicyScope'] scope: Scope for policy application
        :param pulumi.Input[str] selection_criteria: Log group  selection criteria to apply policy only to a subset of log groups. SelectionCriteria string can be up to 25KB and cloudwatchlogs determines the length of selectionCriteria by using its UTF-8 bytes
        """
        pulumi.set(__self__, "policy_document", policy_document)
        pulumi.set(__self__, "policy_type", policy_type)
        if policy_name is not None:
            pulumi.set(__self__, "policy_name", policy_name)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if selection_criteria is not None:
            pulumi.set(__self__, "selection_criteria", selection_criteria)

    @property
    @pulumi.getter(name="policyDocument")
    def policy_document(self) -> pulumi.Input[str]:
        """
        The body of the policy document you want to use for this topic.

        You can only add one policy per PolicyType.

        The policy must be in JSON string format.

        Length Constraints: Maximum length of 30720
        """
        return pulumi.get(self, "policy_document")

    @policy_document.setter
    def policy_document(self, value: pulumi.Input[str]):
        pulumi.set(self, "policy_document", value)

    @property
    @pulumi.getter(name="policyType")
    def policy_type(self) -> pulumi.Input['AccountPolicyPolicyType']:
        """
        Type of the policy.
        """
        return pulumi.get(self, "policy_type")

    @policy_type.setter
    def policy_type(self, value: pulumi.Input['AccountPolicyPolicyType']):
        pulumi.set(self, "policy_type", value)

    @property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the account policy
        """
        return pulumi.get(self, "policy_name")

    @policy_name.setter
    def policy_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_name", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input['AccountPolicyScope']]:
        """
        Scope for policy application
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input['AccountPolicyScope']]):
        pulumi.set(self, "scope", value)

    @property
    @pulumi.getter(name="selectionCriteria")
    def selection_criteria(self) -> Optional[pulumi.Input[str]]:
        """
        Log group  selection criteria to apply policy only to a subset of log groups. SelectionCriteria string can be up to 25KB and cloudwatchlogs determines the length of selectionCriteria by using its UTF-8 bytes
        """
        return pulumi.get(self, "selection_criteria")

    @selection_criteria.setter
    def selection_criteria(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "selection_criteria", value)


class AccountPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 policy_document: Optional[pulumi.Input[str]] = None,
                 policy_name: Optional[pulumi.Input[str]] = None,
                 policy_type: Optional[pulumi.Input['AccountPolicyPolicyType']] = None,
                 scope: Optional[pulumi.Input['AccountPolicyScope']] = None,
                 selection_criteria: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        The AWS::Logs::AccountPolicy resource specifies a CloudWatch Logs AccountPolicy.

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        account_policy = aws_native.logs.AccountPolicy("accountPolicy",
            policy_name="TestPolicy",
            policy_document="{ \\"Name\\": \\"data-protection-policy\\", \\"Description\\": \\"\\", \\"Version\\": \\"2021-06-01\\", \\"Statement\\": [ { \\"Sid\\": \\"audit-policy\\", \\"DataIdentifier\\": [ \\"arn:aws:dataprotection::aws:data-identifier/EmailAddress\\" ], \\"Operation\\": { \\"Audit\\": { \\"FindingsDestination\\": { \\"CloudWatchLogs\\": { \\"LogGroup\\": \\"EXISTING_LOG_GROUP_NAME\\" } } } } }, { \\"Sid\\": \\"redact-policy\\", \\"DataIdentifier\\": [ \\"arn:aws:dataprotection::aws:data-identifier/EmailAddress\\" ], \\"Operation\\": { \\"Deidentify\\": { \\"MaskConfig\\": {} } } } ] }",
            policy_type=aws_native.logs.AccountPolicyPolicyType.DATA_PROTECTION_POLICY,
            scope=aws_native.logs.AccountPolicyScope.ALL)

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        account_policy = aws_native.logs.AccountPolicy("accountPolicy",
            policy_name="TestPolicy",
            policy_document="{ \\"Name\\": \\"data-protection-policy\\", \\"Description\\": \\"\\", \\"Version\\": \\"2021-06-01\\", \\"Statement\\": [ { \\"Sid\\": \\"audit-policy\\", \\"DataIdentifier\\": [ \\"arn:aws:dataprotection::aws:data-identifier/EmailAddress\\" ], \\"Operation\\": { \\"Audit\\": { \\"FindingsDestination\\": { \\"CloudWatchLogs\\": { \\"LogGroup\\": \\"EXISTING_LOG_GROUP_NAME\\" } } } } }, { \\"Sid\\": \\"redact-policy\\", \\"DataIdentifier\\": [ \\"arn:aws:dataprotection::aws:data-identifier/EmailAddress\\" ], \\"Operation\\": { \\"Deidentify\\": { \\"MaskConfig\\": {} } } } ] }",
            policy_type=aws_native.logs.AccountPolicyPolicyType.DATA_PROTECTION_POLICY,
            scope=aws_native.logs.AccountPolicyScope.ALL)

        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] policy_document: The body of the policy document you want to use for this topic.
               
               You can only add one policy per PolicyType.
               
               The policy must be in JSON string format.
               
               Length Constraints: Maximum length of 30720
        :param pulumi.Input[str] policy_name: The name of the account policy
        :param pulumi.Input['AccountPolicyPolicyType'] policy_type: Type of the policy.
        :param pulumi.Input['AccountPolicyScope'] scope: Scope for policy application
        :param pulumi.Input[str] selection_criteria: Log group  selection criteria to apply policy only to a subset of log groups. SelectionCriteria string can be up to 25KB and cloudwatchlogs determines the length of selectionCriteria by using its UTF-8 bytes
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AccountPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The AWS::Logs::AccountPolicy resource specifies a CloudWatch Logs AccountPolicy.

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        account_policy = aws_native.logs.AccountPolicy("accountPolicy",
            policy_name="TestPolicy",
            policy_document="{ \\"Name\\": \\"data-protection-policy\\", \\"Description\\": \\"\\", \\"Version\\": \\"2021-06-01\\", \\"Statement\\": [ { \\"Sid\\": \\"audit-policy\\", \\"DataIdentifier\\": [ \\"arn:aws:dataprotection::aws:data-identifier/EmailAddress\\" ], \\"Operation\\": { \\"Audit\\": { \\"FindingsDestination\\": { \\"CloudWatchLogs\\": { \\"LogGroup\\": \\"EXISTING_LOG_GROUP_NAME\\" } } } } }, { \\"Sid\\": \\"redact-policy\\", \\"DataIdentifier\\": [ \\"arn:aws:dataprotection::aws:data-identifier/EmailAddress\\" ], \\"Operation\\": { \\"Deidentify\\": { \\"MaskConfig\\": {} } } } ] }",
            policy_type=aws_native.logs.AccountPolicyPolicyType.DATA_PROTECTION_POLICY,
            scope=aws_native.logs.AccountPolicyScope.ALL)

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        account_policy = aws_native.logs.AccountPolicy("accountPolicy",
            policy_name="TestPolicy",
            policy_document="{ \\"Name\\": \\"data-protection-policy\\", \\"Description\\": \\"\\", \\"Version\\": \\"2021-06-01\\", \\"Statement\\": [ { \\"Sid\\": \\"audit-policy\\", \\"DataIdentifier\\": [ \\"arn:aws:dataprotection::aws:data-identifier/EmailAddress\\" ], \\"Operation\\": { \\"Audit\\": { \\"FindingsDestination\\": { \\"CloudWatchLogs\\": { \\"LogGroup\\": \\"EXISTING_LOG_GROUP_NAME\\" } } } } }, { \\"Sid\\": \\"redact-policy\\", \\"DataIdentifier\\": [ \\"arn:aws:dataprotection::aws:data-identifier/EmailAddress\\" ], \\"Operation\\": { \\"Deidentify\\": { \\"MaskConfig\\": {} } } } ] }",
            policy_type=aws_native.logs.AccountPolicyPolicyType.DATA_PROTECTION_POLICY,
            scope=aws_native.logs.AccountPolicyScope.ALL)

        ```

        :param str resource_name: The name of the resource.
        :param AccountPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AccountPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 policy_document: Optional[pulumi.Input[str]] = None,
                 policy_name: Optional[pulumi.Input[str]] = None,
                 policy_type: Optional[pulumi.Input['AccountPolicyPolicyType']] = None,
                 scope: Optional[pulumi.Input['AccountPolicyScope']] = None,
                 selection_criteria: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AccountPolicyArgs.__new__(AccountPolicyArgs)

            if policy_document is None and not opts.urn:
                raise TypeError("Missing required property 'policy_document'")
            __props__.__dict__["policy_document"] = policy_document
            __props__.__dict__["policy_name"] = policy_name
            if policy_type is None and not opts.urn:
                raise TypeError("Missing required property 'policy_type'")
            __props__.__dict__["policy_type"] = policy_type
            __props__.__dict__["scope"] = scope
            __props__.__dict__["selection_criteria"] = selection_criteria
            __props__.__dict__["account_id"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["policyName", "policyType"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(AccountPolicy, __self__).__init__(
            'aws-native:logs:AccountPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'AccountPolicy':
        """
        Get an existing AccountPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = AccountPolicyArgs.__new__(AccountPolicyArgs)

        __props__.__dict__["account_id"] = None
        __props__.__dict__["policy_document"] = None
        __props__.__dict__["policy_name"] = None
        __props__.__dict__["policy_type"] = None
        __props__.__dict__["scope"] = None
        __props__.__dict__["selection_criteria"] = None
        return AccountPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[str]:
        """
        User account id
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="policyDocument")
    def policy_document(self) -> pulumi.Output[str]:
        """
        The body of the policy document you want to use for this topic.

        You can only add one policy per PolicyType.

        The policy must be in JSON string format.

        Length Constraints: Maximum length of 30720
        """
        return pulumi.get(self, "policy_document")

    @property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> pulumi.Output[str]:
        """
        The name of the account policy
        """
        return pulumi.get(self, "policy_name")

    @property
    @pulumi.getter(name="policyType")
    def policy_type(self) -> pulumi.Output['AccountPolicyPolicyType']:
        """
        Type of the policy.
        """
        return pulumi.get(self, "policy_type")

    @property
    @pulumi.getter
    def scope(self) -> pulumi.Output[Optional['AccountPolicyScope']]:
        """
        Scope for policy application
        """
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter(name="selectionCriteria")
    def selection_criteria(self) -> pulumi.Output[Optional[str]]:
        """
        Log group  selection criteria to apply policy only to a subset of log groups. SelectionCriteria string can be up to 25KB and cloudwatchlogs determines the length of selectionCriteria by using its UTF-8 bytes
        """
        return pulumi.get(self, "selection_criteria")

