# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'ApiKeyRestrictions',
    'MapConfiguration',
    'PlaceIndexDataSourceConfiguration',
]

@pulumi.output_type
class ApiKeyRestrictions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowActions":
            suggest = "allow_actions"
        elif key == "allowResources":
            suggest = "allow_resources"
        elif key == "allowReferers":
            suggest = "allow_referers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiKeyRestrictions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiKeyRestrictions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiKeyRestrictions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_actions: Sequence[str],
                 allow_resources: Sequence[str],
                 allow_referers: Optional[Sequence[str]] = None):
        """
        :param Sequence[str] allow_actions: A list of allowed actions that an API key resource grants permissions to perform. You must have at least one action for each type of resource. For example, if you have a place resource, you must include at least one place action.
               
               The following are valid values for the actions.
               
               - *Map actions*
               
               - `geo:GetMap*` - Allows all actions needed for map rendering.
               - *Place actions*
               
               - `geo:SearchPlaceIndexForText` - Allows geocoding.
               - `geo:SearchPlaceIndexForPosition` - Allows reverse geocoding.
               - `geo:SearchPlaceIndexForSuggestions` - Allows generating suggestions from text.
               - `geo:GetPlace` - Allows finding a place by place ID.
               - *Route actions*
               
               - `geo:CalculateRoute` - Allows point to point routing.
               - `geo:CalculateRouteMatrix` - Allows calculating a matrix of routes.
               
               > You must use these strings exactly. For example, to provide access to map rendering, the only valid action is `geo:GetMap*` as an input to the list. `["geo:GetMap*"]` is valid but `["geo:GetMapTile"]` is not. Similarly, you cannot use `["geo:SearchPlaceIndexFor*"]` - you must list each of the Place actions separately.
        :param Sequence[str] allow_resources: A list of allowed resource ARNs that a API key bearer can perform actions on.
               
               - The ARN must be the correct ARN for a map, place, or route ARN. You may include wildcards in the resource-id to match multiple resources of the same type.
               - The resources must be in the same `partition` , `region` , and `account-id` as the key that is being created.
               - Other than wildcards, you must include the full ARN, including the `arn` , `partition` , `service` , `region` , `account-id` and `resource-id` delimited by colons (:).
               - No spaces allowed, even with wildcards. For example, `arn:aws:geo:region: *account-id* :map/ExampleMap*` .
               
               For more information about ARN format, see [Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) .
        :param Sequence[str] allow_referers: An optional list of allowed HTTP referers for which requests must originate from. Requests using this API key from other domains will not be allowed.
               
               Requirements:
               
               - Contain only alphanumeric characters (A–Z, a–z, 0–9) or any symbols in this list `$\\-._+!*`(),;/?:@=&`
               - May contain a percent (%) if followed by 2 hexadecimal digits (A-F, a-f, 0-9); this is used for URL encoding purposes.
               - May contain wildcard characters question mark (?) and asterisk (*).
               
               Question mark (?) will replace any single character (including hexadecimal digits).
               
               Asterisk (*) will replace any multiple characters (including multiple hexadecimal digits).
               - No spaces allowed. For example, `https://example.com` .
        """
        pulumi.set(__self__, "allow_actions", allow_actions)
        pulumi.set(__self__, "allow_resources", allow_resources)
        if allow_referers is not None:
            pulumi.set(__self__, "allow_referers", allow_referers)

    @property
    @pulumi.getter(name="allowActions")
    def allow_actions(self) -> Sequence[str]:
        """
        A list of allowed actions that an API key resource grants permissions to perform. You must have at least one action for each type of resource. For example, if you have a place resource, you must include at least one place action.

        The following are valid values for the actions.

        - *Map actions*

        - `geo:GetMap*` - Allows all actions needed for map rendering.
        - *Place actions*

        - `geo:SearchPlaceIndexForText` - Allows geocoding.
        - `geo:SearchPlaceIndexForPosition` - Allows reverse geocoding.
        - `geo:SearchPlaceIndexForSuggestions` - Allows generating suggestions from text.
        - `geo:GetPlace` - Allows finding a place by place ID.
        - *Route actions*

        - `geo:CalculateRoute` - Allows point to point routing.
        - `geo:CalculateRouteMatrix` - Allows calculating a matrix of routes.

        > You must use these strings exactly. For example, to provide access to map rendering, the only valid action is `geo:GetMap*` as an input to the list. `["geo:GetMap*"]` is valid but `["geo:GetMapTile"]` is not. Similarly, you cannot use `["geo:SearchPlaceIndexFor*"]` - you must list each of the Place actions separately.
        """
        return pulumi.get(self, "allow_actions")

    @property
    @pulumi.getter(name="allowResources")
    def allow_resources(self) -> Sequence[str]:
        """
        A list of allowed resource ARNs that a API key bearer can perform actions on.

        - The ARN must be the correct ARN for a map, place, or route ARN. You may include wildcards in the resource-id to match multiple resources of the same type.
        - The resources must be in the same `partition` , `region` , and `account-id` as the key that is being created.
        - Other than wildcards, you must include the full ARN, including the `arn` , `partition` , `service` , `region` , `account-id` and `resource-id` delimited by colons (:).
        - No spaces allowed, even with wildcards. For example, `arn:aws:geo:region: *account-id* :map/ExampleMap*` .

        For more information about ARN format, see [Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) .
        """
        return pulumi.get(self, "allow_resources")

    @property
    @pulumi.getter(name="allowReferers")
    def allow_referers(self) -> Optional[Sequence[str]]:
        """
        An optional list of allowed HTTP referers for which requests must originate from. Requests using this API key from other domains will not be allowed.

        Requirements:

        - Contain only alphanumeric characters (A–Z, a–z, 0–9) or any symbols in this list `$\\-._+!*`(),;/?:@=&`
        - May contain a percent (%) if followed by 2 hexadecimal digits (A-F, a-f, 0-9); this is used for URL encoding purposes.
        - May contain wildcard characters question mark (?) and asterisk (*).

        Question mark (?) will replace any single character (including hexadecimal digits).

        Asterisk (*) will replace any multiple characters (including multiple hexadecimal digits).
        - No spaces allowed. For example, `https://example.com` .
        """
        return pulumi.get(self, "allow_referers")


@pulumi.output_type
class MapConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customLayers":
            suggest = "custom_layers"
        elif key == "politicalView":
            suggest = "political_view"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MapConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MapConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MapConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 style: str,
                 custom_layers: Optional[Sequence[str]] = None,
                 political_view: Optional[str] = None):
        """
        :param str style: Specifies the map style selected from an available data provider.
               
               Valid [Esri map styles](https://docs.aws.amazon.com/location/latest/developerguide/esri.html) :
               
               - `VectorEsriDarkGrayCanvas` – The Esri Dark Gray Canvas map style. A vector basemap with a dark gray, neutral background with minimal colors, labels, and features that's designed to draw attention to your thematic content.
               - `RasterEsriImagery` – The Esri Imagery map style. A raster basemap that provides one meter or better satellite and aerial imagery in many parts of the world and lower resolution satellite imagery worldwide.
               - `VectorEsriLightGrayCanvas` – The Esri Light Gray Canvas map style, which provides a detailed vector basemap with a light gray, neutral background style with minimal colors, labels, and features that's designed to draw attention to your thematic content.
               - `VectorEsriTopographic` – The Esri Light map style, which provides a detailed vector basemap with a classic Esri map style.
               - `VectorEsriStreets` – The Esri Street Map style, which provides a detailed vector basemap for the world symbolized with a classic Esri street map style. The vector tile layer is similar in content and style to the World Street Map raster map.
               - `VectorEsriNavigation` – The Esri Navigation map style, which provides a detailed basemap for the world symbolized with a custom navigation map style that's designed for use during the day in mobile devices.
               
               Valid [HERE Technologies map styles](https://docs.aws.amazon.com/location/latest/developerguide/HERE.html) :
               
               - `VectorHereContrast` – The HERE Contrast (Berlin) map style is a high contrast detailed base map of the world that blends 3D and 2D rendering.
               
               > The `VectorHereContrast` style has been renamed from `VectorHereBerlin` . `VectorHereBerlin` has been deprecated, but will continue to work in applications that use it.
               - `VectorHereExplore` – A default HERE map style containing a neutral, global map and its features including roads, buildings, landmarks, and water features. It also now includes a fully designed map of Japan.
               - `VectorHereExploreTruck` – A global map containing truck restrictions and attributes (e.g. width / height / HAZMAT) symbolized with highlighted segments and icons on top of HERE Explore to support use cases within transport and logistics.
               - `RasterHereExploreSatellite` – A global map containing high resolution satellite imagery.
               - `HybridHereExploreSatellite` – A global map displaying the road network, street names, and city labels over satellite imagery. This style will automatically retrieve both raster and vector tiles, and your charges will be based on total tiles retrieved.
               
               > Hybrid styles use both vector and raster tiles when rendering the map that you see. This means that more tiles are retrieved than when using either vector or raster tiles alone. Your charges will include all tiles retrieved.
               
               Valid [GrabMaps map styles](https://docs.aws.amazon.com/location/latest/developerguide/grab.html) :
               
               - `VectorGrabStandardLight` – The Grab Standard Light map style provides a basemap with detailed land use coloring, area names, roads, landmarks, and points of interest covering Southeast Asia.
               - `VectorGrabStandardDark` – The Grab Standard Dark map style provides a dark variation of the standard basemap covering Southeast Asia.
               
               > Grab provides maps only for countries in Southeast Asia, and is only available in the Asia Pacific (Singapore) Region ( `ap-southeast-1` ). For more information, see [GrabMaps countries and area covered](https://docs.aws.amazon.com/location/latest/developerguide/grab.html#grab-coverage-area) . 
               
               Valid [Open Data map styles](https://docs.aws.amazon.com/location/latest/developerguide/open-data.html) :
               
               - `VectorOpenDataStandardLight` – The Open Data Standard Light map style provides a detailed basemap for the world suitable for website and mobile application use. The map includes highways major roads, minor roads, railways, water features, cities, parks, landmarks, building footprints, and administrative boundaries.
               - `VectorOpenDataStandardDark` – Open Data Standard Dark is a dark-themed map style that provides a detailed basemap for the world suitable for website and mobile application use. The map includes highways major roads, minor roads, railways, water features, cities, parks, landmarks, building footprints, and administrative boundaries.
               - `VectorOpenDataVisualizationLight` – The Open Data Visualization Light map style is a light-themed style with muted colors and fewer features that aids in understanding overlaid data.
               - `VectorOpenDataVisualizationDark` – The Open Data Visualization Dark map style is a dark-themed style with muted colors and fewer features that aids in understanding overlaid data.
        :param Sequence[str] custom_layers: Specifies the custom layers for the style. Leave unset to not enable any custom layer, or, for styles that support custom layers, you can enable layer(s), such as the `POI` layer for the VectorEsriNavigation style.
               
               > Currenlty only `VectorEsriNavigation` supports CustomLayers. For more information, see [Custom Layers](https://docs.aws.amazon.com//location/latest/developerguide/map-concepts.html#map-custom-layers) .
        :param str political_view: Specifies the map political view selected from an available data provider.
        """
        pulumi.set(__self__, "style", style)
        if custom_layers is not None:
            pulumi.set(__self__, "custom_layers", custom_layers)
        if political_view is not None:
            pulumi.set(__self__, "political_view", political_view)

    @property
    @pulumi.getter
    def style(self) -> str:
        """
        Specifies the map style selected from an available data provider.

        Valid [Esri map styles](https://docs.aws.amazon.com/location/latest/developerguide/esri.html) :

        - `VectorEsriDarkGrayCanvas` – The Esri Dark Gray Canvas map style. A vector basemap with a dark gray, neutral background with minimal colors, labels, and features that's designed to draw attention to your thematic content.
        - `RasterEsriImagery` – The Esri Imagery map style. A raster basemap that provides one meter or better satellite and aerial imagery in many parts of the world and lower resolution satellite imagery worldwide.
        - `VectorEsriLightGrayCanvas` – The Esri Light Gray Canvas map style, which provides a detailed vector basemap with a light gray, neutral background style with minimal colors, labels, and features that's designed to draw attention to your thematic content.
        - `VectorEsriTopographic` – The Esri Light map style, which provides a detailed vector basemap with a classic Esri map style.
        - `VectorEsriStreets` – The Esri Street Map style, which provides a detailed vector basemap for the world symbolized with a classic Esri street map style. The vector tile layer is similar in content and style to the World Street Map raster map.
        - `VectorEsriNavigation` – The Esri Navigation map style, which provides a detailed basemap for the world symbolized with a custom navigation map style that's designed for use during the day in mobile devices.

        Valid [HERE Technologies map styles](https://docs.aws.amazon.com/location/latest/developerguide/HERE.html) :

        - `VectorHereContrast` – The HERE Contrast (Berlin) map style is a high contrast detailed base map of the world that blends 3D and 2D rendering.

        > The `VectorHereContrast` style has been renamed from `VectorHereBerlin` . `VectorHereBerlin` has been deprecated, but will continue to work in applications that use it.
        - `VectorHereExplore` – A default HERE map style containing a neutral, global map and its features including roads, buildings, landmarks, and water features. It also now includes a fully designed map of Japan.
        - `VectorHereExploreTruck` – A global map containing truck restrictions and attributes (e.g. width / height / HAZMAT) symbolized with highlighted segments and icons on top of HERE Explore to support use cases within transport and logistics.
        - `RasterHereExploreSatellite` – A global map containing high resolution satellite imagery.
        - `HybridHereExploreSatellite` – A global map displaying the road network, street names, and city labels over satellite imagery. This style will automatically retrieve both raster and vector tiles, and your charges will be based on total tiles retrieved.

        > Hybrid styles use both vector and raster tiles when rendering the map that you see. This means that more tiles are retrieved than when using either vector or raster tiles alone. Your charges will include all tiles retrieved.

        Valid [GrabMaps map styles](https://docs.aws.amazon.com/location/latest/developerguide/grab.html) :

        - `VectorGrabStandardLight` – The Grab Standard Light map style provides a basemap with detailed land use coloring, area names, roads, landmarks, and points of interest covering Southeast Asia.
        - `VectorGrabStandardDark` – The Grab Standard Dark map style provides a dark variation of the standard basemap covering Southeast Asia.

        > Grab provides maps only for countries in Southeast Asia, and is only available in the Asia Pacific (Singapore) Region ( `ap-southeast-1` ). For more information, see [GrabMaps countries and area covered](https://docs.aws.amazon.com/location/latest/developerguide/grab.html#grab-coverage-area) . 

        Valid [Open Data map styles](https://docs.aws.amazon.com/location/latest/developerguide/open-data.html) :

        - `VectorOpenDataStandardLight` – The Open Data Standard Light map style provides a detailed basemap for the world suitable for website and mobile application use. The map includes highways major roads, minor roads, railways, water features, cities, parks, landmarks, building footprints, and administrative boundaries.
        - `VectorOpenDataStandardDark` – Open Data Standard Dark is a dark-themed map style that provides a detailed basemap for the world suitable for website and mobile application use. The map includes highways major roads, minor roads, railways, water features, cities, parks, landmarks, building footprints, and administrative boundaries.
        - `VectorOpenDataVisualizationLight` – The Open Data Visualization Light map style is a light-themed style with muted colors and fewer features that aids in understanding overlaid data.
        - `VectorOpenDataVisualizationDark` – The Open Data Visualization Dark map style is a dark-themed style with muted colors and fewer features that aids in understanding overlaid data.
        """
        return pulumi.get(self, "style")

    @property
    @pulumi.getter(name="customLayers")
    def custom_layers(self) -> Optional[Sequence[str]]:
        """
        Specifies the custom layers for the style. Leave unset to not enable any custom layer, or, for styles that support custom layers, you can enable layer(s), such as the `POI` layer for the VectorEsriNavigation style.

        > Currenlty only `VectorEsriNavigation` supports CustomLayers. For more information, see [Custom Layers](https://docs.aws.amazon.com//location/latest/developerguide/map-concepts.html#map-custom-layers) .
        """
        return pulumi.get(self, "custom_layers")

    @property
    @pulumi.getter(name="politicalView")
    def political_view(self) -> Optional[str]:
        """
        Specifies the map political view selected from an available data provider.
        """
        return pulumi.get(self, "political_view")


@pulumi.output_type
class PlaceIndexDataSourceConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "intendedUse":
            suggest = "intended_use"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PlaceIndexDataSourceConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PlaceIndexDataSourceConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PlaceIndexDataSourceConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 intended_use: Optional['PlaceIndexIntendedUse'] = None):
        """
        :param 'PlaceIndexIntendedUse' intended_use: Specifies how the results of an operation will be stored by the caller.
               
               Valid values include:
               
               - `SingleUse` specifies that the results won't be stored.
               - `Storage` specifies that the result can be cached or stored in a database.
               
               Default value: `SingleUse`
        """
        if intended_use is not None:
            pulumi.set(__self__, "intended_use", intended_use)

    @property
    @pulumi.getter(name="intendedUse")
    def intended_use(self) -> Optional['PlaceIndexIntendedUse']:
        """
        Specifies how the results of an operation will be stored by the caller.

        Valid values include:

        - `SingleUse` specifies that the results won't be stored.
        - `Storage` specifies that the result can be cached or stored in a database.

        Default value: `SingleUse`
        """
        return pulumi.get(self, "intended_use")


