# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetPlaceIndexResult',
    'AwaitableGetPlaceIndexResult',
    'get_place_index',
    'get_place_index_output',
]

@pulumi.output_type
class GetPlaceIndexResult:
    def __init__(__self__, arn=None, create_time=None, data_source_configuration=None, description=None, index_arn=None, pricing_plan=None, tags=None, update_time=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if data_source_configuration and not isinstance(data_source_configuration, dict):
            raise TypeError("Expected argument 'data_source_configuration' to be a dict")
        pulumi.set(__self__, "data_source_configuration", data_source_configuration)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if index_arn and not isinstance(index_arn, str):
            raise TypeError("Expected argument 'index_arn' to be a str")
        pulumi.set(__self__, "index_arn", index_arn)
        if pricing_plan and not isinstance(pricing_plan, str):
            raise TypeError("Expected argument 'pricing_plan' to be a str")
        pulumi.set(__self__, "pricing_plan", pricing_plan)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if update_time and not isinstance(update_time, str):
            raise TypeError("Expected argument 'update_time' to be a str")
        pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter
    def arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) for the place index resource. Used to specify a resource across AWS .

        - Format example: `arn:aws:geo:region:account-id:place-index/ExamplePlaceIndex`
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[str]:
        """
        The timestamp for when the place index resource was created in [ISO 8601](https://docs.aws.amazon.com/https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ` .
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="dataSourceConfiguration")
    def data_source_configuration(self) -> Optional['outputs.PlaceIndexDataSourceConfiguration']:
        """
        Specifies the data storage option requesting Places.
        """
        return pulumi.get(self, "data_source_configuration")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The optional description for the place index resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="indexArn")
    def index_arn(self) -> Optional[str]:
        """
        Synonym for `Arn` . The Amazon Resource Name (ARN) for the place index resource. Used to specify a resource across AWS .

        - Format example: `arn:aws:geo:region:account-id:place-index/ExamplePlaceIndex`
        """
        return pulumi.get(self, "index_arn")

    @property
    @pulumi.getter(name="pricingPlan")
    def pricing_plan(self) -> Optional['PlaceIndexPricingPlan']:
        """
        No longer used. If included, the only allowed value is `RequestBasedUsage` .

        *Allowed Values* : `RequestBasedUsage`
        """
        return pulumi.get(self, "pricing_plan")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[str]:
        """
        The timestamp for when the place index resource was last updated in [ISO 8601](https://docs.aws.amazon.com/https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ` .
        """
        return pulumi.get(self, "update_time")


class AwaitableGetPlaceIndexResult(GetPlaceIndexResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPlaceIndexResult(
            arn=self.arn,
            create_time=self.create_time,
            data_source_configuration=self.data_source_configuration,
            description=self.description,
            index_arn=self.index_arn,
            pricing_plan=self.pricing_plan,
            tags=self.tags,
            update_time=self.update_time)


def get_place_index(index_name: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPlaceIndexResult:
    """
    Definition of AWS::Location::PlaceIndex Resource Type


    :param str index_name: The name of the place index resource.
           
           Requirements:
           
           - Contain only alphanumeric characters (A–Z, a–z, 0–9), hyphens (-), periods (.), and underscores (_).
           - Must be a unique place index resource name.
           - No spaces allowed. For example, `ExamplePlaceIndex` .
    """
    __args__ = dict()
    __args__['indexName'] = index_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:location:getPlaceIndex', __args__, opts=opts, typ=GetPlaceIndexResult).value

    return AwaitableGetPlaceIndexResult(
        arn=pulumi.get(__ret__, 'arn'),
        create_time=pulumi.get(__ret__, 'create_time'),
        data_source_configuration=pulumi.get(__ret__, 'data_source_configuration'),
        description=pulumi.get(__ret__, 'description'),
        index_arn=pulumi.get(__ret__, 'index_arn'),
        pricing_plan=pulumi.get(__ret__, 'pricing_plan'),
        tags=pulumi.get(__ret__, 'tags'),
        update_time=pulumi.get(__ret__, 'update_time'))
def get_place_index_output(index_name: Optional[pulumi.Input[str]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetPlaceIndexResult]:
    """
    Definition of AWS::Location::PlaceIndex Resource Type


    :param str index_name: The name of the place index resource.
           
           Requirements:
           
           - Contain only alphanumeric characters (A–Z, a–z, 0–9), hyphens (-), periods (.), and underscores (_).
           - Must be a unique place index resource name.
           - No spaces allowed. For example, `ExamplePlaceIndex` .
    """
    __args__ = dict()
    __args__['indexName'] = index_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:location:getPlaceIndex', __args__, opts=opts, typ=GetPlaceIndexResult)
    return __ret__.apply(lambda __response__: GetPlaceIndexResult(
        arn=pulumi.get(__response__, 'arn'),
        create_time=pulumi.get(__response__, 'create_time'),
        data_source_configuration=pulumi.get(__response__, 'data_source_configuration'),
        description=pulumi.get(__response__, 'description'),
        index_arn=pulumi.get(__response__, 'index_arn'),
        pricing_plan=pulumi.get(__response__, 'pricing_plan'),
        tags=pulumi.get(__response__, 'tags'),
        update_time=pulumi.get(__response__, 'update_time')))
