# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetMapResult',
    'AwaitableGetMapResult',
    'get_map',
    'get_map_output',
]

@pulumi.output_type
class GetMapResult:
    def __init__(__self__, arn=None, create_time=None, description=None, map_arn=None, pricing_plan=None, tags=None, update_time=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if map_arn and not isinstance(map_arn, str):
            raise TypeError("Expected argument 'map_arn' to be a str")
        pulumi.set(__self__, "map_arn", map_arn)
        if pricing_plan and not isinstance(pricing_plan, str):
            raise TypeError("Expected argument 'pricing_plan' to be a str")
        pulumi.set(__self__, "pricing_plan", pricing_plan)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if update_time and not isinstance(update_time, str):
            raise TypeError("Expected argument 'update_time' to be a str")
        pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter
    def arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) for the map resource. Used to specify a resource across all AWS .

        - Format example: `arn:aws:geo:region:account-id:maps/ExampleMap`
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[str]:
        """
        The timestamp for when the map resource was created in [ISO 8601](https://docs.aws.amazon.com/https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ` .
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        An optional description for the map resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="mapArn")
    def map_arn(self) -> Optional[str]:
        """
        Synonym for `Arn` . The Amazon Resource Name (ARN) for the map resource. Used to specify a resource across all AWS .

        - Format example: `arn:aws:geo:region:account-id:maps/ExampleMap`
        """
        return pulumi.get(self, "map_arn")

    @property
    @pulumi.getter(name="pricingPlan")
    def pricing_plan(self) -> Optional['MapPricingPlan']:
        """
        No longer used. If included, the only allowed value is `RequestBasedUsage` .

        *Allowed Values* : `RequestBasedUsage`
        """
        return pulumi.get(self, "pricing_plan")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[str]:
        """
        The timestamp for when the map resource was last updated in [ISO 8601](https://docs.aws.amazon.com/https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ` .
        """
        return pulumi.get(self, "update_time")


class AwaitableGetMapResult(GetMapResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMapResult(
            arn=self.arn,
            create_time=self.create_time,
            description=self.description,
            map_arn=self.map_arn,
            pricing_plan=self.pricing_plan,
            tags=self.tags,
            update_time=self.update_time)


def get_map(map_name: Optional[str] = None,
            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMapResult:
    """
    Definition of AWS::Location::Map Resource Type


    :param str map_name: The name for the map resource.
           
           Requirements:
           
           - Must contain only alphanumeric characters (A–Z, a–z, 0–9), hyphens (-), periods (.), and underscores (_).
           - Must be a unique map resource name.
           - No spaces allowed. For example, `ExampleMap` .
    """
    __args__ = dict()
    __args__['mapName'] = map_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:location:getMap', __args__, opts=opts, typ=GetMapResult).value

    return AwaitableGetMapResult(
        arn=pulumi.get(__ret__, 'arn'),
        create_time=pulumi.get(__ret__, 'create_time'),
        description=pulumi.get(__ret__, 'description'),
        map_arn=pulumi.get(__ret__, 'map_arn'),
        pricing_plan=pulumi.get(__ret__, 'pricing_plan'),
        tags=pulumi.get(__ret__, 'tags'),
        update_time=pulumi.get(__ret__, 'update_time'))
def get_map_output(map_name: Optional[pulumi.Input[str]] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetMapResult]:
    """
    Definition of AWS::Location::Map Resource Type


    :param str map_name: The name for the map resource.
           
           Requirements:
           
           - Must contain only alphanumeric characters (A–Z, a–z, 0–9), hyphens (-), periods (.), and underscores (_).
           - Must be a unique map resource name.
           - No spaces allowed. For example, `ExampleMap` .
    """
    __args__ = dict()
    __args__['mapName'] = map_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:location:getMap', __args__, opts=opts, typ=GetMapResult)
    return __ret__.apply(lambda __response__: GetMapResult(
        arn=pulumi.get(__response__, 'arn'),
        create_time=pulumi.get(__response__, 'create_time'),
        description=pulumi.get(__response__, 'description'),
        map_arn=pulumi.get(__response__, 'map_arn'),
        pricing_plan=pulumi.get(__response__, 'pricing_plan'),
        tags=pulumi.get(__response__, 'tags'),
        update_time=pulumi.get(__response__, 'update_time')))
