# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._inputs import *

__all__ = ['ApiKeyArgs', 'ApiKey']

@pulumi.input_type
class ApiKeyArgs:
    def __init__(__self__, *,
                 restrictions: pulumi.Input['ApiKeyRestrictionsArgs'],
                 description: Optional[pulumi.Input[str]] = None,
                 expire_time: Optional[pulumi.Input[str]] = None,
                 force_delete: Optional[pulumi.Input[bool]] = None,
                 force_update: Optional[pulumi.Input[bool]] = None,
                 key_name: Optional[pulumi.Input[str]] = None,
                 no_expiry: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a ApiKey resource.
        :param pulumi.Input['ApiKeyRestrictionsArgs'] restrictions: The API key restrictions for the API key resource.
        :param pulumi.Input[str] description: Updates the description for the API key resource.
        :param pulumi.Input[str] expire_time: The optional timestamp for when the API key resource will expire in [ISO 8601 format](https://docs.aws.amazon.com/https://www.iso.org/iso-8601-date-and-time-format.html) .
        :param pulumi.Input[bool] force_delete: ForceDelete bypasses an API key's expiry conditions and deletes the key. Set the parameter `true` to delete the key or to `false` to not preemptively delete the API key.
               
               Valid values: `true` , or `false` .
               
               > This action is irreversible. Only use ForceDelete if you are certain the key is no longer in use.
        :param pulumi.Input[bool] force_update: The boolean flag to be included for updating `ExpireTime` or Restrictions details.
               Must be set to `true` to update an API key resource that has been used in the past 7 days. `False` if force update is not preferred.
        :param pulumi.Input[str] key_name: A custom name for the API key resource.
               
               Requirements:
               
               - Contain only alphanumeric characters (A–Z, a–z, 0–9), hyphens (-), periods (.), and underscores (_).
               - Must be a unique API key name.
               - No spaces allowed. For example, `ExampleAPIKey` .
        :param pulumi.Input[bool] no_expiry: Whether the API key should expire. Set to `true` to set the API key to have no expiration time.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: An array of key-value pairs to apply to this resource.
        """
        pulumi.set(__self__, "restrictions", restrictions)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if expire_time is not None:
            pulumi.set(__self__, "expire_time", expire_time)
        if force_delete is not None:
            pulumi.set(__self__, "force_delete", force_delete)
        if force_update is not None:
            pulumi.set(__self__, "force_update", force_update)
        if key_name is not None:
            pulumi.set(__self__, "key_name", key_name)
        if no_expiry is not None:
            pulumi.set(__self__, "no_expiry", no_expiry)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def restrictions(self) -> pulumi.Input['ApiKeyRestrictionsArgs']:
        """
        The API key restrictions for the API key resource.
        """
        return pulumi.get(self, "restrictions")

    @restrictions.setter
    def restrictions(self, value: pulumi.Input['ApiKeyRestrictionsArgs']):
        pulumi.set(self, "restrictions", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Updates the description for the API key resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> Optional[pulumi.Input[str]]:
        """
        The optional timestamp for when the API key resource will expire in [ISO 8601 format](https://docs.aws.amazon.com/https://www.iso.org/iso-8601-date-and-time-format.html) .
        """
        return pulumi.get(self, "expire_time")

    @expire_time.setter
    def expire_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expire_time", value)

    @property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> Optional[pulumi.Input[bool]]:
        """
        ForceDelete bypasses an API key's expiry conditions and deletes the key. Set the parameter `true` to delete the key or to `false` to not preemptively delete the API key.

        Valid values: `true` , or `false` .

        > This action is irreversible. Only use ForceDelete if you are certain the key is no longer in use.
        """
        return pulumi.get(self, "force_delete")

    @force_delete.setter
    def force_delete(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_delete", value)

    @property
    @pulumi.getter(name="forceUpdate")
    def force_update(self) -> Optional[pulumi.Input[bool]]:
        """
        The boolean flag to be included for updating `ExpireTime` or Restrictions details.
        Must be set to `true` to update an API key resource that has been used in the past 7 days. `False` if force update is not preferred.
        """
        return pulumi.get(self, "force_update")

    @force_update.setter
    def force_update(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_update", value)

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> Optional[pulumi.Input[str]]:
        """
        A custom name for the API key resource.

        Requirements:

        - Contain only alphanumeric characters (A–Z, a–z, 0–9), hyphens (-), periods (.), and underscores (_).
        - Must be a unique API key name.
        - No spaces allowed. For example, `ExampleAPIKey` .
        """
        return pulumi.get(self, "key_name")

    @key_name.setter
    def key_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_name", value)

    @property
    @pulumi.getter(name="noExpiry")
    def no_expiry(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the API key should expire. Set to `true` to set the API key to have no expiration time.
        """
        return pulumi.get(self, "no_expiry")

    @no_expiry.setter
    def no_expiry(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "no_expiry", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


class ApiKey(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 expire_time: Optional[pulumi.Input[str]] = None,
                 force_delete: Optional[pulumi.Input[bool]] = None,
                 force_update: Optional[pulumi.Input[bool]] = None,
                 key_name: Optional[pulumi.Input[str]] = None,
                 no_expiry: Optional[pulumi.Input[bool]] = None,
                 restrictions: Optional[pulumi.Input[Union['ApiKeyRestrictionsArgs', 'ApiKeyRestrictionsArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        Definition of AWS::Location::APIKey Resource Type

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Updates the description for the API key resource.
        :param pulumi.Input[str] expire_time: The optional timestamp for when the API key resource will expire in [ISO 8601 format](https://docs.aws.amazon.com/https://www.iso.org/iso-8601-date-and-time-format.html) .
        :param pulumi.Input[bool] force_delete: ForceDelete bypasses an API key's expiry conditions and deletes the key. Set the parameter `true` to delete the key or to `false` to not preemptively delete the API key.
               
               Valid values: `true` , or `false` .
               
               > This action is irreversible. Only use ForceDelete if you are certain the key is no longer in use.
        :param pulumi.Input[bool] force_update: The boolean flag to be included for updating `ExpireTime` or Restrictions details.
               Must be set to `true` to update an API key resource that has been used in the past 7 days. `False` if force update is not preferred.
        :param pulumi.Input[str] key_name: A custom name for the API key resource.
               
               Requirements:
               
               - Contain only alphanumeric characters (A–Z, a–z, 0–9), hyphens (-), periods (.), and underscores (_).
               - Must be a unique API key name.
               - No spaces allowed. For example, `ExampleAPIKey` .
        :param pulumi.Input[bool] no_expiry: Whether the API key should expire. Set to `true` to set the API key to have no expiration time.
        :param pulumi.Input[Union['ApiKeyRestrictionsArgs', 'ApiKeyRestrictionsArgsDict']] restrictions: The API key restrictions for the API key resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: An array of key-value pairs to apply to this resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ApiKeyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Definition of AWS::Location::APIKey Resource Type

        :param str resource_name: The name of the resource.
        :param ApiKeyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApiKeyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 expire_time: Optional[pulumi.Input[str]] = None,
                 force_delete: Optional[pulumi.Input[bool]] = None,
                 force_update: Optional[pulumi.Input[bool]] = None,
                 key_name: Optional[pulumi.Input[str]] = None,
                 no_expiry: Optional[pulumi.Input[bool]] = None,
                 restrictions: Optional[pulumi.Input[Union['ApiKeyRestrictionsArgs', 'ApiKeyRestrictionsArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApiKeyArgs.__new__(ApiKeyArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["expire_time"] = expire_time
            __props__.__dict__["force_delete"] = force_delete
            __props__.__dict__["force_update"] = force_update
            __props__.__dict__["key_name"] = key_name
            __props__.__dict__["no_expiry"] = no_expiry
            if restrictions is None and not opts.urn:
                raise TypeError("Missing required property 'restrictions'")
            __props__.__dict__["restrictions"] = restrictions
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["key_arn"] = None
            __props__.__dict__["update_time"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["keyName"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(ApiKey, __self__).__init__(
            'aws-native:location:ApiKey',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'ApiKey':
        """
        Get an existing ApiKey resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ApiKeyArgs.__new__(ApiKeyArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["create_time"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["expire_time"] = None
        __props__.__dict__["force_delete"] = None
        __props__.__dict__["force_update"] = None
        __props__.__dict__["key_arn"] = None
        __props__.__dict__["key_name"] = None
        __props__.__dict__["no_expiry"] = None
        __props__.__dict__["restrictions"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["update_time"] = None
        return ApiKey(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN) for the resource. Used when you need to specify a resource across all AWS .
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        The timestamp for when the API key resource was created in ISO 8601 format: YYYY-MM-DDThh:mm:ss.sssZ.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Updates the description for the API key resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> pulumi.Output[Optional[str]]:
        """
        The optional timestamp for when the API key resource will expire in [ISO 8601 format](https://docs.aws.amazon.com/https://www.iso.org/iso-8601-date-and-time-format.html) .
        """
        return pulumi.get(self, "expire_time")

    @property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> pulumi.Output[Optional[bool]]:
        """
        ForceDelete bypasses an API key's expiry conditions and deletes the key. Set the parameter `true` to delete the key or to `false` to not preemptively delete the API key.

        Valid values: `true` , or `false` .

        > This action is irreversible. Only use ForceDelete if you are certain the key is no longer in use.
        """
        return pulumi.get(self, "force_delete")

    @property
    @pulumi.getter(name="forceUpdate")
    def force_update(self) -> pulumi.Output[Optional[bool]]:
        """
        The boolean flag to be included for updating `ExpireTime` or Restrictions details.
        Must be set to `true` to update an API key resource that has been used in the past 7 days. `False` if force update is not preferred.
        """
        return pulumi.get(self, "force_update")

    @property
    @pulumi.getter(name="keyArn")
    def key_arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN) for the API key resource. Used when you need to specify a resource across all AWS .
        """
        return pulumi.get(self, "key_arn")

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> pulumi.Output[str]:
        """
        A custom name for the API key resource.

        Requirements:

        - Contain only alphanumeric characters (A–Z, a–z, 0–9), hyphens (-), periods (.), and underscores (_).
        - Must be a unique API key name.
        - No spaces allowed. For example, `ExampleAPIKey` .
        """
        return pulumi.get(self, "key_name")

    @property
    @pulumi.getter(name="noExpiry")
    def no_expiry(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether the API key should expire. Set to `true` to set the API key to have no expiration time.
        """
        return pulumi.get(self, "no_expiry")

    @property
    @pulumi.getter
    def restrictions(self) -> pulumi.Output['outputs.ApiKeyRestrictions']:
        """
        The API key restrictions for the API key resource.
        """
        return pulumi.get(self, "restrictions")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        The timestamp for when the API key resource was last updated in ISO 8601 format: `YYYY-MM-DDThh:mm:ss.sssZ` .
        """
        return pulumi.get(self, "update_time")

