# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'LicenseBorrowConfiguration',
    'LicenseConsumptionConfiguration',
    'LicenseEntitlement',
    'LicenseIssuerData',
    'LicenseMetadata',
    'LicenseProvisionalConfiguration',
    'LicenseValidityDateFormat',
]

@pulumi.output_type
class LicenseBorrowConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowEarlyCheckIn":
            suggest = "allow_early_check_in"
        elif key == "maxTimeToLiveInMinutes":
            suggest = "max_time_to_live_in_minutes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LicenseBorrowConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LicenseBorrowConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LicenseBorrowConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_early_check_in: bool,
                 max_time_to_live_in_minutes: int):
        """
        :param bool allow_early_check_in: Indicates whether early check-ins are allowed.
        :param int max_time_to_live_in_minutes: Maximum time for the borrow configuration, in minutes.
        """
        pulumi.set(__self__, "allow_early_check_in", allow_early_check_in)
        pulumi.set(__self__, "max_time_to_live_in_minutes", max_time_to_live_in_minutes)

    @property
    @pulumi.getter(name="allowEarlyCheckIn")
    def allow_early_check_in(self) -> bool:
        """
        Indicates whether early check-ins are allowed.
        """
        return pulumi.get(self, "allow_early_check_in")

    @property
    @pulumi.getter(name="maxTimeToLiveInMinutes")
    def max_time_to_live_in_minutes(self) -> int:
        """
        Maximum time for the borrow configuration, in minutes.
        """
        return pulumi.get(self, "max_time_to_live_in_minutes")


@pulumi.output_type
class LicenseConsumptionConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "borrowConfiguration":
            suggest = "borrow_configuration"
        elif key == "provisionalConfiguration":
            suggest = "provisional_configuration"
        elif key == "renewType":
            suggest = "renew_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LicenseConsumptionConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LicenseConsumptionConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LicenseConsumptionConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 borrow_configuration: Optional['outputs.LicenseBorrowConfiguration'] = None,
                 provisional_configuration: Optional['outputs.LicenseProvisionalConfiguration'] = None,
                 renew_type: Optional[str] = None):
        """
        :param 'LicenseBorrowConfiguration' borrow_configuration: Details about a borrow configuration.
        :param 'LicenseProvisionalConfiguration' provisional_configuration: Details about a provisional configuration.
        :param str renew_type: Renewal frequency.
        """
        if borrow_configuration is not None:
            pulumi.set(__self__, "borrow_configuration", borrow_configuration)
        if provisional_configuration is not None:
            pulumi.set(__self__, "provisional_configuration", provisional_configuration)
        if renew_type is not None:
            pulumi.set(__self__, "renew_type", renew_type)

    @property
    @pulumi.getter(name="borrowConfiguration")
    def borrow_configuration(self) -> Optional['outputs.LicenseBorrowConfiguration']:
        """
        Details about a borrow configuration.
        """
        return pulumi.get(self, "borrow_configuration")

    @property
    @pulumi.getter(name="provisionalConfiguration")
    def provisional_configuration(self) -> Optional['outputs.LicenseProvisionalConfiguration']:
        """
        Details about a provisional configuration.
        """
        return pulumi.get(self, "provisional_configuration")

    @property
    @pulumi.getter(name="renewType")
    def renew_type(self) -> Optional[str]:
        """
        Renewal frequency.
        """
        return pulumi.get(self, "renew_type")


@pulumi.output_type
class LicenseEntitlement(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowCheckIn":
            suggest = "allow_check_in"
        elif key == "maxCount":
            suggest = "max_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LicenseEntitlement. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LicenseEntitlement.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LicenseEntitlement.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 unit: str,
                 allow_check_in: Optional[bool] = None,
                 max_count: Optional[int] = None,
                 overage: Optional[bool] = None,
                 value: Optional[str] = None):
        """
        :param str name: Entitlement name.
        :param str unit: Entitlement unit.
        :param bool allow_check_in: Indicates whether check-ins are allowed.
        :param int max_count: Maximum entitlement count. Use if the unit is not None.
        :param bool overage: Indicates whether overages are allowed.
        :param str value: Entitlement resource. Use only if the unit is None.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "unit", unit)
        if allow_check_in is not None:
            pulumi.set(__self__, "allow_check_in", allow_check_in)
        if max_count is not None:
            pulumi.set(__self__, "max_count", max_count)
        if overage is not None:
            pulumi.set(__self__, "overage", overage)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Entitlement name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def unit(self) -> str:
        """
        Entitlement unit.
        """
        return pulumi.get(self, "unit")

    @property
    @pulumi.getter(name="allowCheckIn")
    def allow_check_in(self) -> Optional[bool]:
        """
        Indicates whether check-ins are allowed.
        """
        return pulumi.get(self, "allow_check_in")

    @property
    @pulumi.getter(name="maxCount")
    def max_count(self) -> Optional[int]:
        """
        Maximum entitlement count. Use if the unit is not None.
        """
        return pulumi.get(self, "max_count")

    @property
    @pulumi.getter
    def overage(self) -> Optional[bool]:
        """
        Indicates whether overages are allowed.
        """
        return pulumi.get(self, "overage")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        Entitlement resource. Use only if the unit is None.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class LicenseIssuerData(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "signKey":
            suggest = "sign_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LicenseIssuerData. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LicenseIssuerData.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LicenseIssuerData.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 sign_key: Optional[str] = None):
        """
        :param str name: Issuer name.
        :param str sign_key: Asymmetric KMS key from AWS Key Management Service . The KMS key must have a key usage of sign and verify, and support the RSASSA-PSS SHA-256 signing algorithm.
        """
        pulumi.set(__self__, "name", name)
        if sign_key is not None:
            pulumi.set(__self__, "sign_key", sign_key)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Issuer name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="signKey")
    def sign_key(self) -> Optional[str]:
        """
        Asymmetric KMS key from AWS Key Management Service . The KMS key must have a key usage of sign and verify, and support the RSASSA-PSS SHA-256 signing algorithm.
        """
        return pulumi.get(self, "sign_key")


@pulumi.output_type
class LicenseMetadata(dict):
    def __init__(__self__, *,
                 name: str,
                 value: str):
        """
        :param str name: The key name.
        :param str value: The value.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The key name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class LicenseProvisionalConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxTimeToLiveInMinutes":
            suggest = "max_time_to_live_in_minutes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LicenseProvisionalConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LicenseProvisionalConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LicenseProvisionalConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_time_to_live_in_minutes: int):
        """
        :param int max_time_to_live_in_minutes: Maximum time for the provisional configuration, in minutes.
        """
        pulumi.set(__self__, "max_time_to_live_in_minutes", max_time_to_live_in_minutes)

    @property
    @pulumi.getter(name="maxTimeToLiveInMinutes")
    def max_time_to_live_in_minutes(self) -> int:
        """
        Maximum time for the provisional configuration, in minutes.
        """
        return pulumi.get(self, "max_time_to_live_in_minutes")


@pulumi.output_type
class LicenseValidityDateFormat(dict):
    def __init__(__self__, *,
                 begin: str,
                 end: str):
        """
        :param str begin: Validity begin date for the license.
        :param str end: Validity begin date for the license.
        """
        pulumi.set(__self__, "begin", begin)
        pulumi.set(__self__, "end", end)

    @property
    @pulumi.getter
    def begin(self) -> str:
        """
        Validity begin date for the license.
        """
        return pulumi.get(self, "begin")

    @property
    @pulumi.getter
    def end(self) -> str:
        """
        Validity begin date for the license.
        """
        return pulumi.get(self, "end")


