# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = ['DeploymentArgs', 'Deployment']

@pulumi.input_type
class DeploymentArgs:
    def __init__(__self__, *,
                 deployment_pattern_name: pulumi.Input[str],
                 specifications: pulumi.Input[Mapping[str, pulumi.Input[str]]],
                 workload_name: pulumi.Input[str],
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a Deployment resource.
        :param pulumi.Input[str] deployment_pattern_name: Workload deployment pattern name
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] specifications: LaunchWizard deployment specifications
        :param pulumi.Input[str] workload_name: Workload Name for LaunchWizard deployment
        :param pulumi.Input[str] name: Name of LaunchWizard deployment
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: Tags for LaunchWizard deployment
        """
        pulumi.set(__self__, "deployment_pattern_name", deployment_pattern_name)
        pulumi.set(__self__, "specifications", specifications)
        pulumi.set(__self__, "workload_name", workload_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="deploymentPatternName")
    def deployment_pattern_name(self) -> pulumi.Input[str]:
        """
        Workload deployment pattern name
        """
        return pulumi.get(self, "deployment_pattern_name")

    @deployment_pattern_name.setter
    def deployment_pattern_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "deployment_pattern_name", value)

    @property
    @pulumi.getter
    def specifications(self) -> pulumi.Input[Mapping[str, pulumi.Input[str]]]:
        """
        LaunchWizard deployment specifications
        """
        return pulumi.get(self, "specifications")

    @specifications.setter
    def specifications(self, value: pulumi.Input[Mapping[str, pulumi.Input[str]]]):
        pulumi.set(self, "specifications", value)

    @property
    @pulumi.getter(name="workloadName")
    def workload_name(self) -> pulumi.Input[str]:
        """
        Workload Name for LaunchWizard deployment
        """
        return pulumi.get(self, "workload_name")

    @workload_name.setter
    def workload_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "workload_name", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of LaunchWizard deployment
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        Tags for LaunchWizard deployment
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


class Deployment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 deployment_pattern_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 specifications: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 workload_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Definition of AWS::LaunchWizard::Deployment Resource Type

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] deployment_pattern_name: Workload deployment pattern name
        :param pulumi.Input[str] name: Name of LaunchWizard deployment
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] specifications: LaunchWizard deployment specifications
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: Tags for LaunchWizard deployment
        :param pulumi.Input[str] workload_name: Workload Name for LaunchWizard deployment
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DeploymentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Definition of AWS::LaunchWizard::Deployment Resource Type

        :param str resource_name: The name of the resource.
        :param DeploymentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DeploymentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 deployment_pattern_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 specifications: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 workload_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DeploymentArgs.__new__(DeploymentArgs)

            if deployment_pattern_name is None and not opts.urn:
                raise TypeError("Missing required property 'deployment_pattern_name'")
            __props__.__dict__["deployment_pattern_name"] = deployment_pattern_name
            __props__.__dict__["name"] = name
            if specifications is None and not opts.urn:
                raise TypeError("Missing required property 'specifications'")
            __props__.__dict__["specifications"] = specifications
            __props__.__dict__["tags"] = tags
            if workload_name is None and not opts.urn:
                raise TypeError("Missing required property 'workload_name'")
            __props__.__dict__["workload_name"] = workload_name
            __props__.__dict__["arn"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["deleted_at"] = None
            __props__.__dict__["deployment_id"] = None
            __props__.__dict__["resource_group"] = None
            __props__.__dict__["status"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["deploymentPatternName", "name", "workloadName"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Deployment, __self__).__init__(
            'aws-native:launchwizard:Deployment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Deployment':
        """
        Get an existing Deployment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = DeploymentArgs.__new__(DeploymentArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["created_at"] = None
        __props__.__dict__["deleted_at"] = None
        __props__.__dict__["deployment_id"] = None
        __props__.__dict__["deployment_pattern_name"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["resource_group"] = None
        __props__.__dict__["specifications"] = None
        __props__.__dict__["status"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["workload_name"] = None
        return Deployment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        ARN of the LaunchWizard deployment
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        """
        Timestamp of LaunchWizard deployment creation
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="deletedAt")
    def deleted_at(self) -> pulumi.Output[str]:
        """
        Timestamp of LaunchWizard deployment deletion
        """
        return pulumi.get(self, "deleted_at")

    @property
    @pulumi.getter(name="deploymentId")
    def deployment_id(self) -> pulumi.Output[str]:
        """
        Deployment ID of the LaunchWizard deployment
        """
        return pulumi.get(self, "deployment_id")

    @property
    @pulumi.getter(name="deploymentPatternName")
    def deployment_pattern_name(self) -> pulumi.Output[str]:
        """
        Workload deployment pattern name
        """
        return pulumi.get(self, "deployment_pattern_name")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of LaunchWizard deployment
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> pulumi.Output[str]:
        """
        Resource Group Name created for LaunchWizard deployment
        """
        return pulumi.get(self, "resource_group")

    @property
    @pulumi.getter
    def specifications(self) -> pulumi.Output[Mapping[str, str]]:
        """
        LaunchWizard deployment specifications
        """
        return pulumi.get(self, "specifications")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output['DeploymentStatus']:
        """
        Status of LaunchWizard deployment
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        Tags for LaunchWizard deployment
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="workloadName")
    def workload_name(self) -> pulumi.Output[str]:
        """
        Workload Name for LaunchWizard deployment
        """
        return pulumi.get(self, "workload_name")

