# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LayerVersionArgs', 'LayerVersion']

@pulumi.input_type
class LayerVersionArgs:
    def __init__(__self__, *,
                 content: pulumi.Input['LayerVersionContentArgs'],
                 compatible_architectures: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 compatible_runtimes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 layer_name: Optional[pulumi.Input[str]] = None,
                 license_info: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a LayerVersion resource.
        :param pulumi.Input['LayerVersionContentArgs'] content: The function layer archive.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] compatible_architectures: A list of compatible instruction set architectures.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] compatible_runtimes: A list of compatible function runtimes. Used for filtering with ListLayers and ListLayerVersions.
        :param pulumi.Input[str] description: The description of the version.
        :param pulumi.Input[str] layer_name: The name or Amazon Resource Name (ARN) of the layer.
        :param pulumi.Input[str] license_info: The layer's software license.
        """
        pulumi.set(__self__, "content", content)
        if compatible_architectures is not None:
            pulumi.set(__self__, "compatible_architectures", compatible_architectures)
        if compatible_runtimes is not None:
            pulumi.set(__self__, "compatible_runtimes", compatible_runtimes)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if layer_name is not None:
            pulumi.set(__self__, "layer_name", layer_name)
        if license_info is not None:
            pulumi.set(__self__, "license_info", license_info)

    @property
    @pulumi.getter
    def content(self) -> pulumi.Input['LayerVersionContentArgs']:
        """
        The function layer archive.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: pulumi.Input['LayerVersionContentArgs']):
        pulumi.set(self, "content", value)

    @property
    @pulumi.getter(name="compatibleArchitectures")
    def compatible_architectures(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of compatible instruction set architectures.
        """
        return pulumi.get(self, "compatible_architectures")

    @compatible_architectures.setter
    def compatible_architectures(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "compatible_architectures", value)

    @property
    @pulumi.getter(name="compatibleRuntimes")
    def compatible_runtimes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of compatible function runtimes. Used for filtering with ListLayers and ListLayerVersions.
        """
        return pulumi.get(self, "compatible_runtimes")

    @compatible_runtimes.setter
    def compatible_runtimes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "compatible_runtimes", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the version.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="layerName")
    def layer_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name or Amazon Resource Name (ARN) of the layer.
        """
        return pulumi.get(self, "layer_name")

    @layer_name.setter
    def layer_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "layer_name", value)

    @property
    @pulumi.getter(name="licenseInfo")
    def license_info(self) -> Optional[pulumi.Input[str]]:
        """
        The layer's software license.
        """
        return pulumi.get(self, "license_info")

    @license_info.setter
    def license_info(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "license_info", value)


class LayerVersion(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compatible_architectures: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 compatible_runtimes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 content: Optional[pulumi.Input[Union['LayerVersionContentArgs', 'LayerVersionContentArgsDict']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 layer_name: Optional[pulumi.Input[str]] = None,
                 license_info: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::Lambda::LayerVersion

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] compatible_architectures: A list of compatible instruction set architectures.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] compatible_runtimes: A list of compatible function runtimes. Used for filtering with ListLayers and ListLayerVersions.
        :param pulumi.Input[Union['LayerVersionContentArgs', 'LayerVersionContentArgsDict']] content: The function layer archive.
        :param pulumi.Input[str] description: The description of the version.
        :param pulumi.Input[str] layer_name: The name or Amazon Resource Name (ARN) of the layer.
        :param pulumi.Input[str] license_info: The layer's software license.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LayerVersionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::Lambda::LayerVersion

        :param str resource_name: The name of the resource.
        :param LayerVersionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LayerVersionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compatible_architectures: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 compatible_runtimes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 content: Optional[pulumi.Input[Union['LayerVersionContentArgs', 'LayerVersionContentArgsDict']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 layer_name: Optional[pulumi.Input[str]] = None,
                 license_info: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LayerVersionArgs.__new__(LayerVersionArgs)

            __props__.__dict__["compatible_architectures"] = compatible_architectures
            __props__.__dict__["compatible_runtimes"] = compatible_runtimes
            if content is None and not opts.urn:
                raise TypeError("Missing required property 'content'")
            __props__.__dict__["content"] = content
            __props__.__dict__["description"] = description
            __props__.__dict__["layer_name"] = layer_name
            __props__.__dict__["license_info"] = license_info
            __props__.__dict__["layer_version_arn"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["compatibleArchitectures[*]", "compatibleRuntimes[*]", "content", "description", "layerName", "licenseInfo"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(LayerVersion, __self__).__init__(
            'aws-native:lambda:LayerVersion',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'LayerVersion':
        """
        Get an existing LayerVersion resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = LayerVersionArgs.__new__(LayerVersionArgs)

        __props__.__dict__["compatible_architectures"] = None
        __props__.__dict__["compatible_runtimes"] = None
        __props__.__dict__["content"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["layer_name"] = None
        __props__.__dict__["layer_version_arn"] = None
        __props__.__dict__["license_info"] = None
        return LayerVersion(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compatibleArchitectures")
    def compatible_architectures(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of compatible instruction set architectures.
        """
        return pulumi.get(self, "compatible_architectures")

    @property
    @pulumi.getter(name="compatibleRuntimes")
    def compatible_runtimes(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of compatible function runtimes. Used for filtering with ListLayers and ListLayerVersions.
        """
        return pulumi.get(self, "compatible_runtimes")

    @property
    @pulumi.getter
    def content(self) -> pulumi.Output['outputs.LayerVersionContent']:
        """
        The function layer archive.
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the version.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="layerName")
    def layer_name(self) -> pulumi.Output[Optional[str]]:
        """
        The name or Amazon Resource Name (ARN) of the layer.
        """
        return pulumi.get(self, "layer_name")

    @property
    @pulumi.getter(name="layerVersionArn")
    def layer_version_arn(self) -> pulumi.Output[str]:
        """
        The ARN of the layer version.
        """
        return pulumi.get(self, "layer_version_arn")

    @property
    @pulumi.getter(name="licenseInfo")
    def license_info(self) -> pulumi.Output[Optional[str]]:
        """
        The layer's software license.
        """
        return pulumi.get(self, "license_info")

