# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetCodeSigningConfigResult',
    'AwaitableGetCodeSigningConfigResult',
    'get_code_signing_config',
    'get_code_signing_config_output',
]

@pulumi.output_type
class GetCodeSigningConfigResult:
    def __init__(__self__, allowed_publishers=None, code_signing_config_arn=None, code_signing_config_id=None, code_signing_policies=None, description=None, tags=None):
        if allowed_publishers and not isinstance(allowed_publishers, dict):
            raise TypeError("Expected argument 'allowed_publishers' to be a dict")
        pulumi.set(__self__, "allowed_publishers", allowed_publishers)
        if code_signing_config_arn and not isinstance(code_signing_config_arn, str):
            raise TypeError("Expected argument 'code_signing_config_arn' to be a str")
        pulumi.set(__self__, "code_signing_config_arn", code_signing_config_arn)
        if code_signing_config_id and not isinstance(code_signing_config_id, str):
            raise TypeError("Expected argument 'code_signing_config_id' to be a str")
        pulumi.set(__self__, "code_signing_config_id", code_signing_config_id)
        if code_signing_policies and not isinstance(code_signing_policies, dict):
            raise TypeError("Expected argument 'code_signing_policies' to be a dict")
        pulumi.set(__self__, "code_signing_policies", code_signing_policies)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="allowedPublishers")
    def allowed_publishers(self) -> Optional['outputs.CodeSigningConfigAllowedPublishers']:
        """
        When the CodeSigningConfig is later on attached to a function, the function code will be expected to be signed by profiles from this list
        """
        return pulumi.get(self, "allowed_publishers")

    @property
    @pulumi.getter(name="codeSigningConfigArn")
    def code_signing_config_arn(self) -> Optional[str]:
        """
        A unique Arn for CodeSigningConfig resource
        """
        return pulumi.get(self, "code_signing_config_arn")

    @property
    @pulumi.getter(name="codeSigningConfigId")
    def code_signing_config_id(self) -> Optional[str]:
        """
        A unique identifier for CodeSigningConfig resource
        """
        return pulumi.get(self, "code_signing_config_id")

    @property
    @pulumi.getter(name="codeSigningPolicies")
    def code_signing_policies(self) -> Optional['outputs.CodeSigningConfigCodeSigningPolicies']:
        """
        Policies to control how to act if a signature is invalid
        """
        return pulumi.get(self, "code_signing_policies")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A description of the CodeSigningConfig
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        A list of tags to apply to CodeSigningConfig resource
        """
        return pulumi.get(self, "tags")


class AwaitableGetCodeSigningConfigResult(GetCodeSigningConfigResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCodeSigningConfigResult(
            allowed_publishers=self.allowed_publishers,
            code_signing_config_arn=self.code_signing_config_arn,
            code_signing_config_id=self.code_signing_config_id,
            code_signing_policies=self.code_signing_policies,
            description=self.description,
            tags=self.tags)


def get_code_signing_config(code_signing_config_arn: Optional[str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCodeSigningConfigResult:
    """
    Resource Type definition for AWS::Lambda::CodeSigningConfig.


    :param str code_signing_config_arn: A unique Arn for CodeSigningConfig resource
    """
    __args__ = dict()
    __args__['codeSigningConfigArn'] = code_signing_config_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:lambda:getCodeSigningConfig', __args__, opts=opts, typ=GetCodeSigningConfigResult).value

    return AwaitableGetCodeSigningConfigResult(
        allowed_publishers=pulumi.get(__ret__, 'allowed_publishers'),
        code_signing_config_arn=pulumi.get(__ret__, 'code_signing_config_arn'),
        code_signing_config_id=pulumi.get(__ret__, 'code_signing_config_id'),
        code_signing_policies=pulumi.get(__ret__, 'code_signing_policies'),
        description=pulumi.get(__ret__, 'description'),
        tags=pulumi.get(__ret__, 'tags'))
def get_code_signing_config_output(code_signing_config_arn: Optional[pulumi.Input[str]] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetCodeSigningConfigResult]:
    """
    Resource Type definition for AWS::Lambda::CodeSigningConfig.


    :param str code_signing_config_arn: A unique Arn for CodeSigningConfig resource
    """
    __args__ = dict()
    __args__['codeSigningConfigArn'] = code_signing_config_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:lambda:getCodeSigningConfig', __args__, opts=opts, typ=GetCodeSigningConfigResult)
    return __ret__.apply(lambda __response__: GetCodeSigningConfigResult(
        allowed_publishers=pulumi.get(__response__, 'allowed_publishers'),
        code_signing_config_arn=pulumi.get(__response__, 'code_signing_config_arn'),
        code_signing_config_id=pulumi.get(__response__, 'code_signing_config_id'),
        code_signing_policies=pulumi.get(__response__, 'code_signing_policies'),
        description=pulumi.get(__response__, 'description'),
        tags=pulumi.get(__response__, 'tags')))
