# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetAliasResult',
    'AwaitableGetAliasResult',
    'get_alias',
    'get_alias_output',
]

@pulumi.output_type
class GetAliasResult:
    def __init__(__self__, alias_arn=None, description=None, function_version=None, provisioned_concurrency_config=None, routing_config=None):
        if alias_arn and not isinstance(alias_arn, str):
            raise TypeError("Expected argument 'alias_arn' to be a str")
        pulumi.set(__self__, "alias_arn", alias_arn)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if function_version and not isinstance(function_version, str):
            raise TypeError("Expected argument 'function_version' to be a str")
        pulumi.set(__self__, "function_version", function_version)
        if provisioned_concurrency_config and not isinstance(provisioned_concurrency_config, dict):
            raise TypeError("Expected argument 'provisioned_concurrency_config' to be a dict")
        pulumi.set(__self__, "provisioned_concurrency_config", provisioned_concurrency_config)
        if routing_config and not isinstance(routing_config, dict):
            raise TypeError("Expected argument 'routing_config' to be a dict")
        pulumi.set(__self__, "routing_config", routing_config)

    @property
    @pulumi.getter(name="aliasArn")
    def alias_arn(self) -> Optional[str]:
        """
        Lambda Alias ARN generated by the service.
        """
        return pulumi.get(self, "alias_arn")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A description of the alias.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="functionVersion")
    def function_version(self) -> Optional[str]:
        """
        The function version that the alias invokes.
        """
        return pulumi.get(self, "function_version")

    @property
    @pulumi.getter(name="provisionedConcurrencyConfig")
    def provisioned_concurrency_config(self) -> Optional['outputs.AliasProvisionedConcurrencyConfiguration']:
        """
        Specifies a provisioned concurrency configuration for a function's alias.
        """
        return pulumi.get(self, "provisioned_concurrency_config")

    @property
    @pulumi.getter(name="routingConfig")
    def routing_config(self) -> Optional['outputs.AliasRoutingConfiguration']:
        """
        The routing configuration of the alias.
        """
        return pulumi.get(self, "routing_config")


class AwaitableGetAliasResult(GetAliasResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAliasResult(
            alias_arn=self.alias_arn,
            description=self.description,
            function_version=self.function_version,
            provisioned_concurrency_config=self.provisioned_concurrency_config,
            routing_config=self.routing_config)


def get_alias(alias_arn: Optional[str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAliasResult:
    """
    Resource Type definition for AWS::Lambda::Alias


    :param str alias_arn: Lambda Alias ARN generated by the service.
    """
    __args__ = dict()
    __args__['aliasArn'] = alias_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:lambda:getAlias', __args__, opts=opts, typ=GetAliasResult).value

    return AwaitableGetAliasResult(
        alias_arn=pulumi.get(__ret__, 'alias_arn'),
        description=pulumi.get(__ret__, 'description'),
        function_version=pulumi.get(__ret__, 'function_version'),
        provisioned_concurrency_config=pulumi.get(__ret__, 'provisioned_concurrency_config'),
        routing_config=pulumi.get(__ret__, 'routing_config'))
def get_alias_output(alias_arn: Optional[pulumi.Input[str]] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAliasResult]:
    """
    Resource Type definition for AWS::Lambda::Alias


    :param str alias_arn: Lambda Alias ARN generated by the service.
    """
    __args__ = dict()
    __args__['aliasArn'] = alias_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:lambda:getAlias', __args__, opts=opts, typ=GetAliasResult)
    return __ret__.apply(lambda __response__: GetAliasResult(
        alias_arn=pulumi.get(__response__, 'alias_arn'),
        description=pulumi.get(__response__, 'description'),
        function_version=pulumi.get(__response__, 'function_version'),
        provisioned_concurrency_config=pulumi.get(__response__, 'provisioned_concurrency_config'),
        routing_config=pulumi.get(__response__, 'routing_config')))
