# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['FunctionArgs', 'Function']

@pulumi.input_type
class FunctionArgs:
    def __init__(__self__, *,
                 code: pulumi.Input['FunctionCodeArgs'],
                 role: pulumi.Input[str],
                 architectures: Optional[pulumi.Input[Sequence[pulumi.Input['FunctionArchitecturesItem']]]] = None,
                 code_signing_config_arn: Optional[pulumi.Input[str]] = None,
                 dead_letter_config: Optional[pulumi.Input['FunctionDeadLetterConfigArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 environment: Optional[pulumi.Input['FunctionEnvironmentArgs']] = None,
                 ephemeral_storage: Optional[pulumi.Input['FunctionEphemeralStorageArgs']] = None,
                 file_system_configs: Optional[pulumi.Input[Sequence[pulumi.Input['FunctionFileSystemConfigArgs']]]] = None,
                 function_name: Optional[pulumi.Input[str]] = None,
                 handler: Optional[pulumi.Input[str]] = None,
                 image_config: Optional[pulumi.Input['FunctionImageConfigArgs']] = None,
                 kms_key_arn: Optional[pulumi.Input[str]] = None,
                 layers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 logging_config: Optional[pulumi.Input['FunctionLoggingConfigArgs']] = None,
                 memory_size: Optional[pulumi.Input[int]] = None,
                 package_type: Optional[pulumi.Input['FunctionPackageType']] = None,
                 recursive_loop: Optional[pulumi.Input['FunctionRecursiveLoop']] = None,
                 reserved_concurrent_executions: Optional[pulumi.Input[int]] = None,
                 runtime: Optional[pulumi.Input[str]] = None,
                 runtime_management_config: Optional[pulumi.Input['FunctionRuntimeManagementConfigArgs']] = None,
                 snap_start: Optional[pulumi.Input['FunctionSnapStartArgs']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None,
                 timeout: Optional[pulumi.Input[int]] = None,
                 tracing_config: Optional[pulumi.Input['FunctionTracingConfigArgs']] = None,
                 vpc_config: Optional[pulumi.Input['FunctionVpcConfigArgs']] = None):
        """
        The set of arguments for constructing a Function resource.
        :param pulumi.Input['FunctionCodeArgs'] code: The code for the function.
        :param pulumi.Input[str] role: The Amazon Resource Name (ARN) of the function's execution role.
        :param pulumi.Input[Sequence[pulumi.Input['FunctionArchitecturesItem']]] architectures: The instruction set architecture that the function supports. Enter a string array with one of the valid values (arm64 or x86_64). The default value is ``x86_64``.
        :param pulumi.Input[str] code_signing_config_arn: To enable code signing for this function, specify the ARN of a code-signing configuration. A code-signing configuration includes a set of signing profiles, which define the trusted publishers for this function.
        :param pulumi.Input['FunctionDeadLetterConfigArgs'] dead_letter_config: A dead-letter queue configuration that specifies the queue or topic where Lambda sends asynchronous events when they fail processing. For more information, see [Dead-letter queues](https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#invocation-dlq).
        :param pulumi.Input[str] description: A description of the function.
        :param pulumi.Input['FunctionEnvironmentArgs'] environment: Environment variables that are accessible from function code during execution.
        :param pulumi.Input['FunctionEphemeralStorageArgs'] ephemeral_storage: The size of the function's ``/tmp`` directory in MB. The default value is 512, but it can be any whole number between 512 and 10,240 MB.
        :param pulumi.Input[Sequence[pulumi.Input['FunctionFileSystemConfigArgs']]] file_system_configs: Connection settings for an Amazon EFS file system. To connect a function to a file system, a mount target must be available in every Availability Zone that your function connects to. If your template contains an [AWS::EFS::MountTarget](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-mounttarget.html) resource, you must also specify a ``DependsOn`` attribute to ensure that the mount target is created or updated before the function.
                For more information about using the ``DependsOn`` attribute, see [DependsOn Attribute](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-dependson.html).
        :param pulumi.Input[str] function_name: The name of the Lambda function, up to 64 characters in length. If you don't specify a name, CFN generates one.
                If you specify a name, you cannot perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
        :param pulumi.Input[str] handler: The name of the method within your code that Lambda calls to run your function. Handler is required if the deployment package is a .zip file archive. The format includes the file name. It can also include namespaces and other qualifiers, depending on the runtime. For more information, see [Lambda programming model](https://docs.aws.amazon.com/lambda/latest/dg/foundation-progmodel.html).
        :param pulumi.Input['FunctionImageConfigArgs'] image_config: Configuration values that override the container image Dockerfile settings. For more information, see [Container image settings](https://docs.aws.amazon.com/lambda/latest/dg/images-create.html#images-parms).
        :param pulumi.Input[str] kms_key_arn: The ARN of the KMSlong (KMS) customer managed key that's used to encrypt your function's [environment variables](https://docs.aws.amazon.com/lambda/latest/dg/configuration-envvars.html#configuration-envvars-encryption). When [Lambda SnapStart](https://docs.aws.amazon.com/lambda/latest/dg/snapstart-security.html) is activated, Lambda also uses this key is to encrypt your function's snapshot. If you deploy your function using a container image, Lambda also uses this key to encrypt your function when it's deployed. Note that this is not the same key that's used to protect your container image in the Amazon Elastic Container Registry (Amazon ECR). If you don't provide a customer managed key, Lambda uses a default service key.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] layers: A list of [function layers](https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html) to add to the function's execution environment. Specify each layer by its ARN, including the version.
        :param pulumi.Input['FunctionLoggingConfigArgs'] logging_config: The function's Amazon CloudWatch Logs configuration settings.
        :param pulumi.Input[int] memory_size: The amount of [memory available to the function](https://docs.aws.amazon.com/lambda/latest/dg/configuration-function-common.html#configuration-memory-console) at runtime. Increasing the function memory also increases its CPU allocation. The default value is 128 MB. The value can be any multiple of 1 MB. Note that new AWS accounts have reduced concurrency and memory quotas. AWS raises these quotas automatically based on your usage. You can also request a quota increase.
        :param pulumi.Input['FunctionPackageType'] package_type: The type of deployment package. Set to ``Image`` for container image and set ``Zip`` for .zip file archive.
        :param pulumi.Input['FunctionRecursiveLoop'] recursive_loop: The status of your function's recursive loop detection configuration.
               
               When this value is set to `Allow` and Lambda detects your function being invoked as part of a recursive loop, it doesn't take any action.
               
               When this value is set to `Terminate` and Lambda detects your function being invoked as part of a recursive loop, it stops your function being invoked and notifies you.
        :param pulumi.Input[int] reserved_concurrent_executions: The number of simultaneous executions to reserve for the function.
        :param pulumi.Input[str] runtime: The identifier of the function's [runtime](https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html). Runtime is required if the deployment package is a .zip file archive. Specifying a runtime results in an error if you're deploying a function using a container image.
                The following list includes deprecated runtimes. Lambda blocks creating new functions and updating existing functions shortly after each runtime is deprecated. For more information, see [Runtime use after deprecation](https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtime-deprecation-levels).
                For a list of all currently supported runtimes, see [Supported runtimes](https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtimes-supported).
        :param pulumi.Input['FunctionRuntimeManagementConfigArgs'] runtime_management_config: Sets the runtime management configuration for a function's version. For more information, see [Runtime updates](https://docs.aws.amazon.com/lambda/latest/dg/runtimes-update.html).
        :param pulumi.Input['FunctionSnapStartArgs'] snap_start: The function's [SnapStart](https://docs.aws.amazon.com/lambda/latest/dg/snapstart.html) setting.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: A list of [tags](https://docs.aws.amazon.com/lambda/latest/dg/tagging.html) to apply to the function.
        :param pulumi.Input[int] timeout: The amount of time (in seconds) that Lambda allows a function to run before stopping it. The default is 3 seconds. The maximum allowed value is 900 seconds. For more information, see [Lambda execution environment](https://docs.aws.amazon.com/lambda/latest/dg/runtimes-context.html).
        :param pulumi.Input['FunctionTracingConfigArgs'] tracing_config: Set ``Mode`` to ``Active`` to sample and trace a subset of incoming requests with [X-Ray](https://docs.aws.amazon.com/lambda/latest/dg/services-xray.html).
        :param pulumi.Input['FunctionVpcConfigArgs'] vpc_config: For network connectivity to AWS resources in a VPC, specify a list of security groups and subnets in the VPC. When you connect a function to a VPC, it can access resources and the internet only through that VPC. For more information, see [Configuring a Lambda function to access resources in a VPC](https://docs.aws.amazon.com/lambda/latest/dg/configuration-vpc.html).
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "role", role)
        if architectures is not None:
            pulumi.set(__self__, "architectures", architectures)
        if code_signing_config_arn is not None:
            pulumi.set(__self__, "code_signing_config_arn", code_signing_config_arn)
        if dead_letter_config is not None:
            pulumi.set(__self__, "dead_letter_config", dead_letter_config)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if ephemeral_storage is not None:
            pulumi.set(__self__, "ephemeral_storage", ephemeral_storage)
        if file_system_configs is not None:
            pulumi.set(__self__, "file_system_configs", file_system_configs)
        if function_name is not None:
            pulumi.set(__self__, "function_name", function_name)
        if handler is not None:
            pulumi.set(__self__, "handler", handler)
        if image_config is not None:
            pulumi.set(__self__, "image_config", image_config)
        if kms_key_arn is not None:
            pulumi.set(__self__, "kms_key_arn", kms_key_arn)
        if layers is not None:
            pulumi.set(__self__, "layers", layers)
        if logging_config is not None:
            pulumi.set(__self__, "logging_config", logging_config)
        if memory_size is not None:
            pulumi.set(__self__, "memory_size", memory_size)
        if package_type is not None:
            pulumi.set(__self__, "package_type", package_type)
        if recursive_loop is not None:
            pulumi.set(__self__, "recursive_loop", recursive_loop)
        if reserved_concurrent_executions is not None:
            pulumi.set(__self__, "reserved_concurrent_executions", reserved_concurrent_executions)
        if runtime is not None:
            pulumi.set(__self__, "runtime", runtime)
        if runtime_management_config is not None:
            pulumi.set(__self__, "runtime_management_config", runtime_management_config)
        if snap_start is not None:
            pulumi.set(__self__, "snap_start", snap_start)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if tracing_config is not None:
            pulumi.set(__self__, "tracing_config", tracing_config)
        if vpc_config is not None:
            pulumi.set(__self__, "vpc_config", vpc_config)

    @property
    @pulumi.getter
    def code(self) -> pulumi.Input['FunctionCodeArgs']:
        """
        The code for the function.
        """
        return pulumi.get(self, "code")

    @code.setter
    def code(self, value: pulumi.Input['FunctionCodeArgs']):
        pulumi.set(self, "code", value)

    @property
    @pulumi.getter
    def role(self) -> pulumi.Input[str]:
        """
        The Amazon Resource Name (ARN) of the function's execution role.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: pulumi.Input[str]):
        pulumi.set(self, "role", value)

    @property
    @pulumi.getter
    def architectures(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FunctionArchitecturesItem']]]]:
        """
        The instruction set architecture that the function supports. Enter a string array with one of the valid values (arm64 or x86_64). The default value is ``x86_64``.
        """
        return pulumi.get(self, "architectures")

    @architectures.setter
    def architectures(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FunctionArchitecturesItem']]]]):
        pulumi.set(self, "architectures", value)

    @property
    @pulumi.getter(name="codeSigningConfigArn")
    def code_signing_config_arn(self) -> Optional[pulumi.Input[str]]:
        """
        To enable code signing for this function, specify the ARN of a code-signing configuration. A code-signing configuration includes a set of signing profiles, which define the trusted publishers for this function.
        """
        return pulumi.get(self, "code_signing_config_arn")

    @code_signing_config_arn.setter
    def code_signing_config_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "code_signing_config_arn", value)

    @property
    @pulumi.getter(name="deadLetterConfig")
    def dead_letter_config(self) -> Optional[pulumi.Input['FunctionDeadLetterConfigArgs']]:
        """
        A dead-letter queue configuration that specifies the queue or topic where Lambda sends asynchronous events when they fail processing. For more information, see [Dead-letter queues](https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#invocation-dlq).
        """
        return pulumi.get(self, "dead_letter_config")

    @dead_letter_config.setter
    def dead_letter_config(self, value: Optional[pulumi.Input['FunctionDeadLetterConfigArgs']]):
        pulumi.set(self, "dead_letter_config", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A description of the function.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input['FunctionEnvironmentArgs']]:
        """
        Environment variables that are accessible from function code during execution.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input['FunctionEnvironmentArgs']]):
        pulumi.set(self, "environment", value)

    @property
    @pulumi.getter(name="ephemeralStorage")
    def ephemeral_storage(self) -> Optional[pulumi.Input['FunctionEphemeralStorageArgs']]:
        """
        The size of the function's ``/tmp`` directory in MB. The default value is 512, but it can be any whole number between 512 and 10,240 MB.
        """
        return pulumi.get(self, "ephemeral_storage")

    @ephemeral_storage.setter
    def ephemeral_storage(self, value: Optional[pulumi.Input['FunctionEphemeralStorageArgs']]):
        pulumi.set(self, "ephemeral_storage", value)

    @property
    @pulumi.getter(name="fileSystemConfigs")
    def file_system_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FunctionFileSystemConfigArgs']]]]:
        """
        Connection settings for an Amazon EFS file system. To connect a function to a file system, a mount target must be available in every Availability Zone that your function connects to. If your template contains an [AWS::EFS::MountTarget](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-mounttarget.html) resource, you must also specify a ``DependsOn`` attribute to ensure that the mount target is created or updated before the function.
         For more information about using the ``DependsOn`` attribute, see [DependsOn Attribute](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-dependson.html).
        """
        return pulumi.get(self, "file_system_configs")

    @file_system_configs.setter
    def file_system_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FunctionFileSystemConfigArgs']]]]):
        pulumi.set(self, "file_system_configs", value)

    @property
    @pulumi.getter(name="functionName")
    def function_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Lambda function, up to 64 characters in length. If you don't specify a name, CFN generates one.
         If you specify a name, you cannot perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
        """
        return pulumi.get(self, "function_name")

    @function_name.setter
    def function_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "function_name", value)

    @property
    @pulumi.getter
    def handler(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the method within your code that Lambda calls to run your function. Handler is required if the deployment package is a .zip file archive. The format includes the file name. It can also include namespaces and other qualifiers, depending on the runtime. For more information, see [Lambda programming model](https://docs.aws.amazon.com/lambda/latest/dg/foundation-progmodel.html).
        """
        return pulumi.get(self, "handler")

    @handler.setter
    def handler(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "handler", value)

    @property
    @pulumi.getter(name="imageConfig")
    def image_config(self) -> Optional[pulumi.Input['FunctionImageConfigArgs']]:
        """
        Configuration values that override the container image Dockerfile settings. For more information, see [Container image settings](https://docs.aws.amazon.com/lambda/latest/dg/images-create.html#images-parms).
        """
        return pulumi.get(self, "image_config")

    @image_config.setter
    def image_config(self, value: Optional[pulumi.Input['FunctionImageConfigArgs']]):
        pulumi.set(self, "image_config", value)

    @property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the KMSlong (KMS) customer managed key that's used to encrypt your function's [environment variables](https://docs.aws.amazon.com/lambda/latest/dg/configuration-envvars.html#configuration-envvars-encryption). When [Lambda SnapStart](https://docs.aws.amazon.com/lambda/latest/dg/snapstart-security.html) is activated, Lambda also uses this key is to encrypt your function's snapshot. If you deploy your function using a container image, Lambda also uses this key to encrypt your function when it's deployed. Note that this is not the same key that's used to protect your container image in the Amazon Elastic Container Registry (Amazon ECR). If you don't provide a customer managed key, Lambda uses a default service key.
        """
        return pulumi.get(self, "kms_key_arn")

    @kms_key_arn.setter
    def kms_key_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_arn", value)

    @property
    @pulumi.getter
    def layers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of [function layers](https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html) to add to the function's execution environment. Specify each layer by its ARN, including the version.
        """
        return pulumi.get(self, "layers")

    @layers.setter
    def layers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "layers", value)

    @property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> Optional[pulumi.Input['FunctionLoggingConfigArgs']]:
        """
        The function's Amazon CloudWatch Logs configuration settings.
        """
        return pulumi.get(self, "logging_config")

    @logging_config.setter
    def logging_config(self, value: Optional[pulumi.Input['FunctionLoggingConfigArgs']]):
        pulumi.set(self, "logging_config", value)

    @property
    @pulumi.getter(name="memorySize")
    def memory_size(self) -> Optional[pulumi.Input[int]]:
        """
        The amount of [memory available to the function](https://docs.aws.amazon.com/lambda/latest/dg/configuration-function-common.html#configuration-memory-console) at runtime. Increasing the function memory also increases its CPU allocation. The default value is 128 MB. The value can be any multiple of 1 MB. Note that new AWS accounts have reduced concurrency and memory quotas. AWS raises these quotas automatically based on your usage. You can also request a quota increase.
        """
        return pulumi.get(self, "memory_size")

    @memory_size.setter
    def memory_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "memory_size", value)

    @property
    @pulumi.getter(name="packageType")
    def package_type(self) -> Optional[pulumi.Input['FunctionPackageType']]:
        """
        The type of deployment package. Set to ``Image`` for container image and set ``Zip`` for .zip file archive.
        """
        return pulumi.get(self, "package_type")

    @package_type.setter
    def package_type(self, value: Optional[pulumi.Input['FunctionPackageType']]):
        pulumi.set(self, "package_type", value)

    @property
    @pulumi.getter(name="recursiveLoop")
    def recursive_loop(self) -> Optional[pulumi.Input['FunctionRecursiveLoop']]:
        """
        The status of your function's recursive loop detection configuration.

        When this value is set to `Allow` and Lambda detects your function being invoked as part of a recursive loop, it doesn't take any action.

        When this value is set to `Terminate` and Lambda detects your function being invoked as part of a recursive loop, it stops your function being invoked and notifies you.
        """
        return pulumi.get(self, "recursive_loop")

    @recursive_loop.setter
    def recursive_loop(self, value: Optional[pulumi.Input['FunctionRecursiveLoop']]):
        pulumi.set(self, "recursive_loop", value)

    @property
    @pulumi.getter(name="reservedConcurrentExecutions")
    def reserved_concurrent_executions(self) -> Optional[pulumi.Input[int]]:
        """
        The number of simultaneous executions to reserve for the function.
        """
        return pulumi.get(self, "reserved_concurrent_executions")

    @reserved_concurrent_executions.setter
    def reserved_concurrent_executions(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "reserved_concurrent_executions", value)

    @property
    @pulumi.getter
    def runtime(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier of the function's [runtime](https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html). Runtime is required if the deployment package is a .zip file archive. Specifying a runtime results in an error if you're deploying a function using a container image.
         The following list includes deprecated runtimes. Lambda blocks creating new functions and updating existing functions shortly after each runtime is deprecated. For more information, see [Runtime use after deprecation](https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtime-deprecation-levels).
         For a list of all currently supported runtimes, see [Supported runtimes](https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtimes-supported).
        """
        return pulumi.get(self, "runtime")

    @runtime.setter
    def runtime(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "runtime", value)

    @property
    @pulumi.getter(name="runtimeManagementConfig")
    def runtime_management_config(self) -> Optional[pulumi.Input['FunctionRuntimeManagementConfigArgs']]:
        """
        Sets the runtime management configuration for a function's version. For more information, see [Runtime updates](https://docs.aws.amazon.com/lambda/latest/dg/runtimes-update.html).
        """
        return pulumi.get(self, "runtime_management_config")

    @runtime_management_config.setter
    def runtime_management_config(self, value: Optional[pulumi.Input['FunctionRuntimeManagementConfigArgs']]):
        pulumi.set(self, "runtime_management_config", value)

    @property
    @pulumi.getter(name="snapStart")
    def snap_start(self) -> Optional[pulumi.Input['FunctionSnapStartArgs']]:
        """
        The function's [SnapStart](https://docs.aws.amazon.com/lambda/latest/dg/snapstart.html) setting.
        """
        return pulumi.get(self, "snap_start")

    @snap_start.setter
    def snap_start(self, value: Optional[pulumi.Input['FunctionSnapStartArgs']]):
        pulumi.set(self, "snap_start", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        A list of [tags](https://docs.aws.amazon.com/lambda/latest/dg/tagging.html) to apply to the function.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[int]]:
        """
        The amount of time (in seconds) that Lambda allows a function to run before stopping it. The default is 3 seconds. The maximum allowed value is 900 seconds. For more information, see [Lambda execution environment](https://docs.aws.amazon.com/lambda/latest/dg/runtimes-context.html).
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout", value)

    @property
    @pulumi.getter(name="tracingConfig")
    def tracing_config(self) -> Optional[pulumi.Input['FunctionTracingConfigArgs']]:
        """
        Set ``Mode`` to ``Active`` to sample and trace a subset of incoming requests with [X-Ray](https://docs.aws.amazon.com/lambda/latest/dg/services-xray.html).
        """
        return pulumi.get(self, "tracing_config")

    @tracing_config.setter
    def tracing_config(self, value: Optional[pulumi.Input['FunctionTracingConfigArgs']]):
        pulumi.set(self, "tracing_config", value)

    @property
    @pulumi.getter(name="vpcConfig")
    def vpc_config(self) -> Optional[pulumi.Input['FunctionVpcConfigArgs']]:
        """
        For network connectivity to AWS resources in a VPC, specify a list of security groups and subnets in the VPC. When you connect a function to a VPC, it can access resources and the internet only through that VPC. For more information, see [Configuring a Lambda function to access resources in a VPC](https://docs.aws.amazon.com/lambda/latest/dg/configuration-vpc.html).
        """
        return pulumi.get(self, "vpc_config")

    @vpc_config.setter
    def vpc_config(self, value: Optional[pulumi.Input['FunctionVpcConfigArgs']]):
        pulumi.set(self, "vpc_config", value)


class Function(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 architectures: Optional[pulumi.Input[Sequence[pulumi.Input['FunctionArchitecturesItem']]]] = None,
                 code: Optional[pulumi.Input[Union['FunctionCodeArgs', 'FunctionCodeArgsDict']]] = None,
                 code_signing_config_arn: Optional[pulumi.Input[str]] = None,
                 dead_letter_config: Optional[pulumi.Input[Union['FunctionDeadLetterConfigArgs', 'FunctionDeadLetterConfigArgsDict']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 environment: Optional[pulumi.Input[Union['FunctionEnvironmentArgs', 'FunctionEnvironmentArgsDict']]] = None,
                 ephemeral_storage: Optional[pulumi.Input[Union['FunctionEphemeralStorageArgs', 'FunctionEphemeralStorageArgsDict']]] = None,
                 file_system_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FunctionFileSystemConfigArgs', 'FunctionFileSystemConfigArgsDict']]]]] = None,
                 function_name: Optional[pulumi.Input[str]] = None,
                 handler: Optional[pulumi.Input[str]] = None,
                 image_config: Optional[pulumi.Input[Union['FunctionImageConfigArgs', 'FunctionImageConfigArgsDict']]] = None,
                 kms_key_arn: Optional[pulumi.Input[str]] = None,
                 layers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 logging_config: Optional[pulumi.Input[Union['FunctionLoggingConfigArgs', 'FunctionLoggingConfigArgsDict']]] = None,
                 memory_size: Optional[pulumi.Input[int]] = None,
                 package_type: Optional[pulumi.Input['FunctionPackageType']] = None,
                 recursive_loop: Optional[pulumi.Input['FunctionRecursiveLoop']] = None,
                 reserved_concurrent_executions: Optional[pulumi.Input[int]] = None,
                 role: Optional[pulumi.Input[str]] = None,
                 runtime: Optional[pulumi.Input[str]] = None,
                 runtime_management_config: Optional[pulumi.Input[Union['FunctionRuntimeManagementConfigArgs', 'FunctionRuntimeManagementConfigArgsDict']]] = None,
                 snap_start: Optional[pulumi.Input[Union['FunctionSnapStartArgs', 'FunctionSnapStartArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 timeout: Optional[pulumi.Input[int]] = None,
                 tracing_config: Optional[pulumi.Input[Union['FunctionTracingConfigArgs', 'FunctionTracingConfigArgsDict']]] = None,
                 vpc_config: Optional[pulumi.Input[Union['FunctionVpcConfigArgs', 'FunctionVpcConfigArgsDict']]] = None,
                 __props__=None):
        """
        The ``AWS::Lambda::Function`` resource creates a Lambda function. To create a function, you need a [deployment package](https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-package.html) and an [execution role](https://docs.aws.amazon.com/lambda/latest/dg/lambda-intro-execution-role.html). The deployment package is a .zip file archive or container image that contains your function code. The execution role grants the function permission to use AWS services, such as Amazon CloudWatch Logs for log streaming and AWS X-Ray for request tracing.
         You set the package type to ``Image`` if the deployment package is a [container image](https://docs.aws.amazon.com/lambda/latest/dg/lambda-images.html). For a container image, the code property must include the URI of a container image in the Amazon ECR registry. You do not need to specify the handler and runtime properties.
         You set the package type to ``Zip`` if the deployment package is a [.zip file archive](https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-package.html#gettingstarted-package-zip). For a .zip file archive, the code property specifies the location of the .zip file. You must also specify the handler and runtime properties. For a Python example, see [Deploy Python Lambda functions with .zip file archives](https://docs.aws.amazon.com/lambda/latest/dg/python-package.html).
         You can use [code signing](https://docs.aws.amazon.com/lambda/latest/dg/configuration-codesigning.html) if your deployment package is a .zip file archive. To enable code signing for this function, specify the ARN of a code-signing configuration. When a user attempts to deploy a code package with ``UpdateFunctionCode``, Lambda checks that the code package has a valid signature from a trusted publisher. The code-signing configuration includes a set of signing profiles, which define the trusted publishers for this function.
         Note that you configure [provisioned concurrency](https://docs.aws.amazon.com/lambda/latest/dg/provisioned-concurrency.html) on a ``AWS::Lambda::Version`` or a ``AWS::Lambda::Alias``.
         For a complete introduction to Lambda functions, see [What is Lambda?](https://docs.aws.amazon.com/lambda/latest/dg/lambda-welcome.html) in the *Lambda developer guide.*

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        function = aws_native.lambda_.Function("function",
            handler="index.handler",
            role="arn:aws:iam::123456789012:role/lambda-role",
            code={
                "zip_file": \"\"\"exports.handler = function(event){
            console.log(JSON.stringify(event, null, 2))
            const response = {
                statusCode: 200,
                body: JSON.stringify('Hello from Lambda!')
            }
            return response
        };
        \"\"\",
            },
            runtime="nodejs18.x",
            tracing_config={
                "mode": aws_native.lambda_.FunctionTracingConfigMode.ACTIVE,
            })
        version = aws_native.lambda_.Version("version",
            function_name=function.id,
            description="v1")
        alias = aws_native.lambda_.Alias("alias",
            function_name=function.id,
            function_version=version.version,
            name="BLUE")

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        function = aws_native.lambda_.Function("function",
            handler="index.handler",
            role="arn:aws:iam::123456789012:role/lambda-role",
            code={
                "zip_file": \"\"\"exports.handler = function(event){
            console.log(JSON.stringify(event, null, 2))
            const response = {
                statusCode: 200,
                body: JSON.stringify('Hello again from Lambda!')
            }
            return response
        }
        \"\"\",
            },
            runtime="nodejs18.x",
            tracing_config={
                "mode": aws_native.lambda_.FunctionTracingConfigMode.ACTIVE,
            })
        version = aws_native.lambda_.Version("version",
            function_name=function.id,
            description="v1")
        new_version = aws_native.lambda_.Version("newVersion",
            function_name=function.id,
            description="v2")
        alias = aws_native.lambda_.Alias("alias",
            function_name=function.id,
            function_version=new_version.version,
            name="BLUE",
            routing_config={
                "additional_version_weights": [{
                    "function_version": version.version,
                    "function_weight": 0.5,
                }],
            })

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        function = aws_native.lambda_.Function("function",
            handler="index.handler",
            role="arn:aws:iam::123456789012:role/lambda-role",
            code={
                "zip_file": \"\"\"exports.handler = async (event) => {
            console.log(JSON.stringify(event, null, 2));
            const response = {
                statusCode: 200,
                body: JSON.stringify('Hello from Lambda!'),
            };
            return response;
        };
        \"\"\",
            },
            runtime="nodejs18.x",
            tracing_config={
                "mode": aws_native.lambda_.FunctionTracingConfigMode.ACTIVE,
            })
        version = aws_native.lambda_.Version("version", function_name=function.id)
        asyncconfig = aws_native.lambda_.EventInvokeConfig("asyncconfig",
            destination_config={
                "on_failure": {
                    "destination": "arn:aws:sqs:us-east-2:123456789012:dlq",
                },
                "on_success": {
                    "destination": "arn:aws:sqs:us-east-2:123456789012:dlq",
                },
            },
            function_name=function.id,
            maximum_event_age_in_seconds=300,
            maximum_retry_attempts=1,
            qualifier=version.version)

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        primer = aws_native.lambda_.Function("primer",
            runtime="nodejs18.x",
            role="arn:aws:iam::123456789012:role/lambda-role",
            handler="index.handler",
            code={
                "zip_file": \"\"\"const { S3Client, ListBucketsCommand } = require("@aws-sdk/client-s3");
        const s3 = new S3Client({ region: "us-east-1" }); // replace "us-east-1" with your AWS region

        exports.handler = async function(event) {
          const command = new ListBucketsCommand({});
          const response = await s3.send(command);
          return response.Buckets;
        };
        \"\"\",
            },
            description="List Amazon S3 buckets in us-east-1.",
            tracing_config={
                "mode": aws_native.lambda_.FunctionTracingConfigMode.ACTIVE,
            })

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        function = aws_native.lambda_.Function("function",
            handler="index.handler",
            role="arn:aws:iam::123456789012:role/lambda-role",
            code={
                "s3_bucket": "my-bucket",
                "s3_key": "function.zip",
            },
            runtime="nodejs18.x",
            timeout=5,
            tracing_config={
                "mode": aws_native.lambda_.FunctionTracingConfigMode.ACTIVE,
            },
            vpc_config={
                "security_group_ids": ["sg-085912345678492fb"],
                "subnet_ids": [
                    "subnet-071f712345678e7c8",
                    "subnet-07fd123456788a036",
                ],
            })

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        function = aws_native.lambda_.Function("function",
            handler="index.handler",
            role="arn:aws:iam::123456789012:role/lambda-role",
            code={
                "zip_file": \"\"\"exports.handler = async (event) => {
            console.log(JSON.stringify(event, null, 2));
            const response = {
                statusCode: 200,
                body: JSON.stringify('Hello from Lambda!'),
            };
            return response;
        };
        \"\"\",
            },
            runtime="nodejs18.x",
            tracing_config={
                "mode": aws_native.lambda_.FunctionTracingConfigMode.ACTIVE,
            })
        version = aws_native.lambda_.Version("version",
            function_name=function.id,
            description="v1",
            provisioned_concurrency_config={
                "provisioned_concurrent_executions": 20,
            })

        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input['FunctionArchitecturesItem']]] architectures: The instruction set architecture that the function supports. Enter a string array with one of the valid values (arm64 or x86_64). The default value is ``x86_64``.
        :param pulumi.Input[Union['FunctionCodeArgs', 'FunctionCodeArgsDict']] code: The code for the function.
        :param pulumi.Input[str] code_signing_config_arn: To enable code signing for this function, specify the ARN of a code-signing configuration. A code-signing configuration includes a set of signing profiles, which define the trusted publishers for this function.
        :param pulumi.Input[Union['FunctionDeadLetterConfigArgs', 'FunctionDeadLetterConfigArgsDict']] dead_letter_config: A dead-letter queue configuration that specifies the queue or topic where Lambda sends asynchronous events when they fail processing. For more information, see [Dead-letter queues](https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#invocation-dlq).
        :param pulumi.Input[str] description: A description of the function.
        :param pulumi.Input[Union['FunctionEnvironmentArgs', 'FunctionEnvironmentArgsDict']] environment: Environment variables that are accessible from function code during execution.
        :param pulumi.Input[Union['FunctionEphemeralStorageArgs', 'FunctionEphemeralStorageArgsDict']] ephemeral_storage: The size of the function's ``/tmp`` directory in MB. The default value is 512, but it can be any whole number between 512 and 10,240 MB.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FunctionFileSystemConfigArgs', 'FunctionFileSystemConfigArgsDict']]]] file_system_configs: Connection settings for an Amazon EFS file system. To connect a function to a file system, a mount target must be available in every Availability Zone that your function connects to. If your template contains an [AWS::EFS::MountTarget](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-mounttarget.html) resource, you must also specify a ``DependsOn`` attribute to ensure that the mount target is created or updated before the function.
                For more information about using the ``DependsOn`` attribute, see [DependsOn Attribute](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-dependson.html).
        :param pulumi.Input[str] function_name: The name of the Lambda function, up to 64 characters in length. If you don't specify a name, CFN generates one.
                If you specify a name, you cannot perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
        :param pulumi.Input[str] handler: The name of the method within your code that Lambda calls to run your function. Handler is required if the deployment package is a .zip file archive. The format includes the file name. It can also include namespaces and other qualifiers, depending on the runtime. For more information, see [Lambda programming model](https://docs.aws.amazon.com/lambda/latest/dg/foundation-progmodel.html).
        :param pulumi.Input[Union['FunctionImageConfigArgs', 'FunctionImageConfigArgsDict']] image_config: Configuration values that override the container image Dockerfile settings. For more information, see [Container image settings](https://docs.aws.amazon.com/lambda/latest/dg/images-create.html#images-parms).
        :param pulumi.Input[str] kms_key_arn: The ARN of the KMSlong (KMS) customer managed key that's used to encrypt your function's [environment variables](https://docs.aws.amazon.com/lambda/latest/dg/configuration-envvars.html#configuration-envvars-encryption). When [Lambda SnapStart](https://docs.aws.amazon.com/lambda/latest/dg/snapstart-security.html) is activated, Lambda also uses this key is to encrypt your function's snapshot. If you deploy your function using a container image, Lambda also uses this key to encrypt your function when it's deployed. Note that this is not the same key that's used to protect your container image in the Amazon Elastic Container Registry (Amazon ECR). If you don't provide a customer managed key, Lambda uses a default service key.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] layers: A list of [function layers](https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html) to add to the function's execution environment. Specify each layer by its ARN, including the version.
        :param pulumi.Input[Union['FunctionLoggingConfigArgs', 'FunctionLoggingConfigArgsDict']] logging_config: The function's Amazon CloudWatch Logs configuration settings.
        :param pulumi.Input[int] memory_size: The amount of [memory available to the function](https://docs.aws.amazon.com/lambda/latest/dg/configuration-function-common.html#configuration-memory-console) at runtime. Increasing the function memory also increases its CPU allocation. The default value is 128 MB. The value can be any multiple of 1 MB. Note that new AWS accounts have reduced concurrency and memory quotas. AWS raises these quotas automatically based on your usage. You can also request a quota increase.
        :param pulumi.Input['FunctionPackageType'] package_type: The type of deployment package. Set to ``Image`` for container image and set ``Zip`` for .zip file archive.
        :param pulumi.Input['FunctionRecursiveLoop'] recursive_loop: The status of your function's recursive loop detection configuration.
               
               When this value is set to `Allow` and Lambda detects your function being invoked as part of a recursive loop, it doesn't take any action.
               
               When this value is set to `Terminate` and Lambda detects your function being invoked as part of a recursive loop, it stops your function being invoked and notifies you.
        :param pulumi.Input[int] reserved_concurrent_executions: The number of simultaneous executions to reserve for the function.
        :param pulumi.Input[str] role: The Amazon Resource Name (ARN) of the function's execution role.
        :param pulumi.Input[str] runtime: The identifier of the function's [runtime](https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html). Runtime is required if the deployment package is a .zip file archive. Specifying a runtime results in an error if you're deploying a function using a container image.
                The following list includes deprecated runtimes. Lambda blocks creating new functions and updating existing functions shortly after each runtime is deprecated. For more information, see [Runtime use after deprecation](https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtime-deprecation-levels).
                For a list of all currently supported runtimes, see [Supported runtimes](https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtimes-supported).
        :param pulumi.Input[Union['FunctionRuntimeManagementConfigArgs', 'FunctionRuntimeManagementConfigArgsDict']] runtime_management_config: Sets the runtime management configuration for a function's version. For more information, see [Runtime updates](https://docs.aws.amazon.com/lambda/latest/dg/runtimes-update.html).
        :param pulumi.Input[Union['FunctionSnapStartArgs', 'FunctionSnapStartArgsDict']] snap_start: The function's [SnapStart](https://docs.aws.amazon.com/lambda/latest/dg/snapstart.html) setting.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: A list of [tags](https://docs.aws.amazon.com/lambda/latest/dg/tagging.html) to apply to the function.
        :param pulumi.Input[int] timeout: The amount of time (in seconds) that Lambda allows a function to run before stopping it. The default is 3 seconds. The maximum allowed value is 900 seconds. For more information, see [Lambda execution environment](https://docs.aws.amazon.com/lambda/latest/dg/runtimes-context.html).
        :param pulumi.Input[Union['FunctionTracingConfigArgs', 'FunctionTracingConfigArgsDict']] tracing_config: Set ``Mode`` to ``Active`` to sample and trace a subset of incoming requests with [X-Ray](https://docs.aws.amazon.com/lambda/latest/dg/services-xray.html).
        :param pulumi.Input[Union['FunctionVpcConfigArgs', 'FunctionVpcConfigArgsDict']] vpc_config: For network connectivity to AWS resources in a VPC, specify a list of security groups and subnets in the VPC. When you connect a function to a VPC, it can access resources and the internet only through that VPC. For more information, see [Configuring a Lambda function to access resources in a VPC](https://docs.aws.amazon.com/lambda/latest/dg/configuration-vpc.html).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FunctionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The ``AWS::Lambda::Function`` resource creates a Lambda function. To create a function, you need a [deployment package](https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-package.html) and an [execution role](https://docs.aws.amazon.com/lambda/latest/dg/lambda-intro-execution-role.html). The deployment package is a .zip file archive or container image that contains your function code. The execution role grants the function permission to use AWS services, such as Amazon CloudWatch Logs for log streaming and AWS X-Ray for request tracing.
         You set the package type to ``Image`` if the deployment package is a [container image](https://docs.aws.amazon.com/lambda/latest/dg/lambda-images.html). For a container image, the code property must include the URI of a container image in the Amazon ECR registry. You do not need to specify the handler and runtime properties.
         You set the package type to ``Zip`` if the deployment package is a [.zip file archive](https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-package.html#gettingstarted-package-zip). For a .zip file archive, the code property specifies the location of the .zip file. You must also specify the handler and runtime properties. For a Python example, see [Deploy Python Lambda functions with .zip file archives](https://docs.aws.amazon.com/lambda/latest/dg/python-package.html).
         You can use [code signing](https://docs.aws.amazon.com/lambda/latest/dg/configuration-codesigning.html) if your deployment package is a .zip file archive. To enable code signing for this function, specify the ARN of a code-signing configuration. When a user attempts to deploy a code package with ``UpdateFunctionCode``, Lambda checks that the code package has a valid signature from a trusted publisher. The code-signing configuration includes a set of signing profiles, which define the trusted publishers for this function.
         Note that you configure [provisioned concurrency](https://docs.aws.amazon.com/lambda/latest/dg/provisioned-concurrency.html) on a ``AWS::Lambda::Version`` or a ``AWS::Lambda::Alias``.
         For a complete introduction to Lambda functions, see [What is Lambda?](https://docs.aws.amazon.com/lambda/latest/dg/lambda-welcome.html) in the *Lambda developer guide.*

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        function = aws_native.lambda_.Function("function",
            handler="index.handler",
            role="arn:aws:iam::123456789012:role/lambda-role",
            code={
                "zip_file": \"\"\"exports.handler = function(event){
            console.log(JSON.stringify(event, null, 2))
            const response = {
                statusCode: 200,
                body: JSON.stringify('Hello from Lambda!')
            }
            return response
        };
        \"\"\",
            },
            runtime="nodejs18.x",
            tracing_config={
                "mode": aws_native.lambda_.FunctionTracingConfigMode.ACTIVE,
            })
        version = aws_native.lambda_.Version("version",
            function_name=function.id,
            description="v1")
        alias = aws_native.lambda_.Alias("alias",
            function_name=function.id,
            function_version=version.version,
            name="BLUE")

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        function = aws_native.lambda_.Function("function",
            handler="index.handler",
            role="arn:aws:iam::123456789012:role/lambda-role",
            code={
                "zip_file": \"\"\"exports.handler = function(event){
            console.log(JSON.stringify(event, null, 2))
            const response = {
                statusCode: 200,
                body: JSON.stringify('Hello again from Lambda!')
            }
            return response
        }
        \"\"\",
            },
            runtime="nodejs18.x",
            tracing_config={
                "mode": aws_native.lambda_.FunctionTracingConfigMode.ACTIVE,
            })
        version = aws_native.lambda_.Version("version",
            function_name=function.id,
            description="v1")
        new_version = aws_native.lambda_.Version("newVersion",
            function_name=function.id,
            description="v2")
        alias = aws_native.lambda_.Alias("alias",
            function_name=function.id,
            function_version=new_version.version,
            name="BLUE",
            routing_config={
                "additional_version_weights": [{
                    "function_version": version.version,
                    "function_weight": 0.5,
                }],
            })

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        function = aws_native.lambda_.Function("function",
            handler="index.handler",
            role="arn:aws:iam::123456789012:role/lambda-role",
            code={
                "zip_file": \"\"\"exports.handler = async (event) => {
            console.log(JSON.stringify(event, null, 2));
            const response = {
                statusCode: 200,
                body: JSON.stringify('Hello from Lambda!'),
            };
            return response;
        };
        \"\"\",
            },
            runtime="nodejs18.x",
            tracing_config={
                "mode": aws_native.lambda_.FunctionTracingConfigMode.ACTIVE,
            })
        version = aws_native.lambda_.Version("version", function_name=function.id)
        asyncconfig = aws_native.lambda_.EventInvokeConfig("asyncconfig",
            destination_config={
                "on_failure": {
                    "destination": "arn:aws:sqs:us-east-2:123456789012:dlq",
                },
                "on_success": {
                    "destination": "arn:aws:sqs:us-east-2:123456789012:dlq",
                },
            },
            function_name=function.id,
            maximum_event_age_in_seconds=300,
            maximum_retry_attempts=1,
            qualifier=version.version)

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        primer = aws_native.lambda_.Function("primer",
            runtime="nodejs18.x",
            role="arn:aws:iam::123456789012:role/lambda-role",
            handler="index.handler",
            code={
                "zip_file": \"\"\"const { S3Client, ListBucketsCommand } = require("@aws-sdk/client-s3");
        const s3 = new S3Client({ region: "us-east-1" }); // replace "us-east-1" with your AWS region

        exports.handler = async function(event) {
          const command = new ListBucketsCommand({});
          const response = await s3.send(command);
          return response.Buckets;
        };
        \"\"\",
            },
            description="List Amazon S3 buckets in us-east-1.",
            tracing_config={
                "mode": aws_native.lambda_.FunctionTracingConfigMode.ACTIVE,
            })

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        function = aws_native.lambda_.Function("function",
            handler="index.handler",
            role="arn:aws:iam::123456789012:role/lambda-role",
            code={
                "s3_bucket": "my-bucket",
                "s3_key": "function.zip",
            },
            runtime="nodejs18.x",
            timeout=5,
            tracing_config={
                "mode": aws_native.lambda_.FunctionTracingConfigMode.ACTIVE,
            },
            vpc_config={
                "security_group_ids": ["sg-085912345678492fb"],
                "subnet_ids": [
                    "subnet-071f712345678e7c8",
                    "subnet-07fd123456788a036",
                ],
            })

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        function = aws_native.lambda_.Function("function",
            handler="index.handler",
            role="arn:aws:iam::123456789012:role/lambda-role",
            code={
                "zip_file": \"\"\"exports.handler = async (event) => {
            console.log(JSON.stringify(event, null, 2));
            const response = {
                statusCode: 200,
                body: JSON.stringify('Hello from Lambda!'),
            };
            return response;
        };
        \"\"\",
            },
            runtime="nodejs18.x",
            tracing_config={
                "mode": aws_native.lambda_.FunctionTracingConfigMode.ACTIVE,
            })
        version = aws_native.lambda_.Version("version",
            function_name=function.id,
            description="v1",
            provisioned_concurrency_config={
                "provisioned_concurrent_executions": 20,
            })

        ```

        :param str resource_name: The name of the resource.
        :param FunctionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FunctionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 architectures: Optional[pulumi.Input[Sequence[pulumi.Input['FunctionArchitecturesItem']]]] = None,
                 code: Optional[pulumi.Input[Union['FunctionCodeArgs', 'FunctionCodeArgsDict']]] = None,
                 code_signing_config_arn: Optional[pulumi.Input[str]] = None,
                 dead_letter_config: Optional[pulumi.Input[Union['FunctionDeadLetterConfigArgs', 'FunctionDeadLetterConfigArgsDict']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 environment: Optional[pulumi.Input[Union['FunctionEnvironmentArgs', 'FunctionEnvironmentArgsDict']]] = None,
                 ephemeral_storage: Optional[pulumi.Input[Union['FunctionEphemeralStorageArgs', 'FunctionEphemeralStorageArgsDict']]] = None,
                 file_system_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FunctionFileSystemConfigArgs', 'FunctionFileSystemConfigArgsDict']]]]] = None,
                 function_name: Optional[pulumi.Input[str]] = None,
                 handler: Optional[pulumi.Input[str]] = None,
                 image_config: Optional[pulumi.Input[Union['FunctionImageConfigArgs', 'FunctionImageConfigArgsDict']]] = None,
                 kms_key_arn: Optional[pulumi.Input[str]] = None,
                 layers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 logging_config: Optional[pulumi.Input[Union['FunctionLoggingConfigArgs', 'FunctionLoggingConfigArgsDict']]] = None,
                 memory_size: Optional[pulumi.Input[int]] = None,
                 package_type: Optional[pulumi.Input['FunctionPackageType']] = None,
                 recursive_loop: Optional[pulumi.Input['FunctionRecursiveLoop']] = None,
                 reserved_concurrent_executions: Optional[pulumi.Input[int]] = None,
                 role: Optional[pulumi.Input[str]] = None,
                 runtime: Optional[pulumi.Input[str]] = None,
                 runtime_management_config: Optional[pulumi.Input[Union['FunctionRuntimeManagementConfigArgs', 'FunctionRuntimeManagementConfigArgsDict']]] = None,
                 snap_start: Optional[pulumi.Input[Union['FunctionSnapStartArgs', 'FunctionSnapStartArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 timeout: Optional[pulumi.Input[int]] = None,
                 tracing_config: Optional[pulumi.Input[Union['FunctionTracingConfigArgs', 'FunctionTracingConfigArgsDict']]] = None,
                 vpc_config: Optional[pulumi.Input[Union['FunctionVpcConfigArgs', 'FunctionVpcConfigArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FunctionArgs.__new__(FunctionArgs)

            __props__.__dict__["architectures"] = architectures
            if code is None and not opts.urn:
                raise TypeError("Missing required property 'code'")
            __props__.__dict__["code"] = code
            __props__.__dict__["code_signing_config_arn"] = code_signing_config_arn
            __props__.__dict__["dead_letter_config"] = dead_letter_config
            __props__.__dict__["description"] = description
            __props__.__dict__["environment"] = environment
            __props__.__dict__["ephemeral_storage"] = ephemeral_storage
            __props__.__dict__["file_system_configs"] = file_system_configs
            __props__.__dict__["function_name"] = function_name
            __props__.__dict__["handler"] = handler
            __props__.__dict__["image_config"] = image_config
            __props__.__dict__["kms_key_arn"] = kms_key_arn
            __props__.__dict__["layers"] = layers
            __props__.__dict__["logging_config"] = logging_config
            __props__.__dict__["memory_size"] = memory_size
            __props__.__dict__["package_type"] = package_type
            __props__.__dict__["recursive_loop"] = recursive_loop
            __props__.__dict__["reserved_concurrent_executions"] = reserved_concurrent_executions
            if role is None and not opts.urn:
                raise TypeError("Missing required property 'role'")
            __props__.__dict__["role"] = role
            __props__.__dict__["runtime"] = runtime
            __props__.__dict__["runtime_management_config"] = runtime_management_config
            __props__.__dict__["snap_start"] = snap_start
            __props__.__dict__["tags"] = tags
            __props__.__dict__["timeout"] = timeout
            __props__.__dict__["tracing_config"] = tracing_config
            __props__.__dict__["vpc_config"] = vpc_config
            __props__.__dict__["arn"] = None
            __props__.__dict__["snap_start_response"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["functionName"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Function, __self__).__init__(
            'aws-native:lambda:Function',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Function':
        """
        Get an existing Function resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = FunctionArgs.__new__(FunctionArgs)

        __props__.__dict__["architectures"] = None
        __props__.__dict__["arn"] = None
        __props__.__dict__["code"] = None
        __props__.__dict__["code_signing_config_arn"] = None
        __props__.__dict__["dead_letter_config"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["environment"] = None
        __props__.__dict__["ephemeral_storage"] = None
        __props__.__dict__["file_system_configs"] = None
        __props__.__dict__["function_name"] = None
        __props__.__dict__["handler"] = None
        __props__.__dict__["image_config"] = None
        __props__.__dict__["kms_key_arn"] = None
        __props__.__dict__["layers"] = None
        __props__.__dict__["logging_config"] = None
        __props__.__dict__["memory_size"] = None
        __props__.__dict__["package_type"] = None
        __props__.__dict__["recursive_loop"] = None
        __props__.__dict__["reserved_concurrent_executions"] = None
        __props__.__dict__["role"] = None
        __props__.__dict__["runtime"] = None
        __props__.__dict__["runtime_management_config"] = None
        __props__.__dict__["snap_start"] = None
        __props__.__dict__["snap_start_response"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["timeout"] = None
        __props__.__dict__["tracing_config"] = None
        __props__.__dict__["vpc_config"] = None
        return Function(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def architectures(self) -> pulumi.Output[Optional[Sequence['FunctionArchitecturesItem']]]:
        """
        The instruction set architecture that the function supports. Enter a string array with one of the valid values (arm64 or x86_64). The default value is ``x86_64``.
        """
        return pulumi.get(self, "architectures")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN) of the function.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def code(self) -> pulumi.Output['outputs.FunctionCode']:
        """
        The code for the function.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter(name="codeSigningConfigArn")
    def code_signing_config_arn(self) -> pulumi.Output[Optional[str]]:
        """
        To enable code signing for this function, specify the ARN of a code-signing configuration. A code-signing configuration includes a set of signing profiles, which define the trusted publishers for this function.
        """
        return pulumi.get(self, "code_signing_config_arn")

    @property
    @pulumi.getter(name="deadLetterConfig")
    def dead_letter_config(self) -> pulumi.Output[Optional['outputs.FunctionDeadLetterConfig']]:
        """
        A dead-letter queue configuration that specifies the queue or topic where Lambda sends asynchronous events when they fail processing. For more information, see [Dead-letter queues](https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#invocation-dlq).
        """
        return pulumi.get(self, "dead_letter_config")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        A description of the function.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def environment(self) -> pulumi.Output[Optional['outputs.FunctionEnvironment']]:
        """
        Environment variables that are accessible from function code during execution.
        """
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter(name="ephemeralStorage")
    def ephemeral_storage(self) -> pulumi.Output[Optional['outputs.FunctionEphemeralStorage']]:
        """
        The size of the function's ``/tmp`` directory in MB. The default value is 512, but it can be any whole number between 512 and 10,240 MB.
        """
        return pulumi.get(self, "ephemeral_storage")

    @property
    @pulumi.getter(name="fileSystemConfigs")
    def file_system_configs(self) -> pulumi.Output[Optional[Sequence['outputs.FunctionFileSystemConfig']]]:
        """
        Connection settings for an Amazon EFS file system. To connect a function to a file system, a mount target must be available in every Availability Zone that your function connects to. If your template contains an [AWS::EFS::MountTarget](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-mounttarget.html) resource, you must also specify a ``DependsOn`` attribute to ensure that the mount target is created or updated before the function.
         For more information about using the ``DependsOn`` attribute, see [DependsOn Attribute](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-dependson.html).
        """
        return pulumi.get(self, "file_system_configs")

    @property
    @pulumi.getter(name="functionName")
    def function_name(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the Lambda function, up to 64 characters in length. If you don't specify a name, CFN generates one.
         If you specify a name, you cannot perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
        """
        return pulumi.get(self, "function_name")

    @property
    @pulumi.getter
    def handler(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the method within your code that Lambda calls to run your function. Handler is required if the deployment package is a .zip file archive. The format includes the file name. It can also include namespaces and other qualifiers, depending on the runtime. For more information, see [Lambda programming model](https://docs.aws.amazon.com/lambda/latest/dg/foundation-progmodel.html).
        """
        return pulumi.get(self, "handler")

    @property
    @pulumi.getter(name="imageConfig")
    def image_config(self) -> pulumi.Output[Optional['outputs.FunctionImageConfig']]:
        """
        Configuration values that override the container image Dockerfile settings. For more information, see [Container image settings](https://docs.aws.amazon.com/lambda/latest/dg/images-create.html#images-parms).
        """
        return pulumi.get(self, "image_config")

    @property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> pulumi.Output[Optional[str]]:
        """
        The ARN of the KMSlong (KMS) customer managed key that's used to encrypt your function's [environment variables](https://docs.aws.amazon.com/lambda/latest/dg/configuration-envvars.html#configuration-envvars-encryption). When [Lambda SnapStart](https://docs.aws.amazon.com/lambda/latest/dg/snapstart-security.html) is activated, Lambda also uses this key is to encrypt your function's snapshot. If you deploy your function using a container image, Lambda also uses this key to encrypt your function when it's deployed. Note that this is not the same key that's used to protect your container image in the Amazon Elastic Container Registry (Amazon ECR). If you don't provide a customer managed key, Lambda uses a default service key.
        """
        return pulumi.get(self, "kms_key_arn")

    @property
    @pulumi.getter
    def layers(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of [function layers](https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html) to add to the function's execution environment. Specify each layer by its ARN, including the version.
        """
        return pulumi.get(self, "layers")

    @property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> pulumi.Output[Optional['outputs.FunctionLoggingConfig']]:
        """
        The function's Amazon CloudWatch Logs configuration settings.
        """
        return pulumi.get(self, "logging_config")

    @property
    @pulumi.getter(name="memorySize")
    def memory_size(self) -> pulumi.Output[Optional[int]]:
        """
        The amount of [memory available to the function](https://docs.aws.amazon.com/lambda/latest/dg/configuration-function-common.html#configuration-memory-console) at runtime. Increasing the function memory also increases its CPU allocation. The default value is 128 MB. The value can be any multiple of 1 MB. Note that new AWS accounts have reduced concurrency and memory quotas. AWS raises these quotas automatically based on your usage. You can also request a quota increase.
        """
        return pulumi.get(self, "memory_size")

    @property
    @pulumi.getter(name="packageType")
    def package_type(self) -> pulumi.Output[Optional['FunctionPackageType']]:
        """
        The type of deployment package. Set to ``Image`` for container image and set ``Zip`` for .zip file archive.
        """
        return pulumi.get(self, "package_type")

    @property
    @pulumi.getter(name="recursiveLoop")
    def recursive_loop(self) -> pulumi.Output[Optional['FunctionRecursiveLoop']]:
        """
        The status of your function's recursive loop detection configuration.

        When this value is set to `Allow` and Lambda detects your function being invoked as part of a recursive loop, it doesn't take any action.

        When this value is set to `Terminate` and Lambda detects your function being invoked as part of a recursive loop, it stops your function being invoked and notifies you.
        """
        return pulumi.get(self, "recursive_loop")

    @property
    @pulumi.getter(name="reservedConcurrentExecutions")
    def reserved_concurrent_executions(self) -> pulumi.Output[Optional[int]]:
        """
        The number of simultaneous executions to reserve for the function.
        """
        return pulumi.get(self, "reserved_concurrent_executions")

    @property
    @pulumi.getter
    def role(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN) of the function's execution role.
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter
    def runtime(self) -> pulumi.Output[Optional[str]]:
        """
        The identifier of the function's [runtime](https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html). Runtime is required if the deployment package is a .zip file archive. Specifying a runtime results in an error if you're deploying a function using a container image.
         The following list includes deprecated runtimes. Lambda blocks creating new functions and updating existing functions shortly after each runtime is deprecated. For more information, see [Runtime use after deprecation](https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtime-deprecation-levels).
         For a list of all currently supported runtimes, see [Supported runtimes](https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html#runtimes-supported).
        """
        return pulumi.get(self, "runtime")

    @property
    @pulumi.getter(name="runtimeManagementConfig")
    def runtime_management_config(self) -> pulumi.Output[Optional['outputs.FunctionRuntimeManagementConfig']]:
        """
        Sets the runtime management configuration for a function's version. For more information, see [Runtime updates](https://docs.aws.amazon.com/lambda/latest/dg/runtimes-update.html).
        """
        return pulumi.get(self, "runtime_management_config")

    @property
    @pulumi.getter(name="snapStart")
    def snap_start(self) -> pulumi.Output[Optional['outputs.FunctionSnapStart']]:
        """
        The function's [SnapStart](https://docs.aws.amazon.com/lambda/latest/dg/snapstart.html) setting.
        """
        return pulumi.get(self, "snap_start")

    @property
    @pulumi.getter(name="snapStartResponse")
    def snap_start_response(self) -> pulumi.Output['outputs.FunctionSnapStartResponse']:
        return pulumi.get(self, "snap_start_response")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        A list of [tags](https://docs.aws.amazon.com/lambda/latest/dg/tagging.html) to apply to the function.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def timeout(self) -> pulumi.Output[Optional[int]]:
        """
        The amount of time (in seconds) that Lambda allows a function to run before stopping it. The default is 3 seconds. The maximum allowed value is 900 seconds. For more information, see [Lambda execution environment](https://docs.aws.amazon.com/lambda/latest/dg/runtimes-context.html).
        """
        return pulumi.get(self, "timeout")

    @property
    @pulumi.getter(name="tracingConfig")
    def tracing_config(self) -> pulumi.Output[Optional['outputs.FunctionTracingConfig']]:
        """
        Set ``Mode`` to ``Active`` to sample and trace a subset of incoming requests with [X-Ray](https://docs.aws.amazon.com/lambda/latest/dg/services-xray.html).
        """
        return pulumi.get(self, "tracing_config")

    @property
    @pulumi.getter(name="vpcConfig")
    def vpc_config(self) -> pulumi.Output[Optional['outputs.FunctionVpcConfig']]:
        """
        For network connectivity to AWS resources in a VPC, specify a list of security groups and subnets in the VPC. When you connect a function to a VPC, it can access resources and the internet only through that VPC. For more information, see [Configuring a Lambda function to access resources in a VPC](https://docs.aws.amazon.com/lambda/latest/dg/configuration-vpc.html).
        """
        return pulumi.get(self, "vpc_config")

