# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetPrincipalPermissionsResult',
    'AwaitableGetPrincipalPermissionsResult',
    'get_principal_permissions',
    'get_principal_permissions_output',
]

@pulumi.output_type
class GetPrincipalPermissionsResult:
    def __init__(__self__, principal_identifier=None, resource_identifier=None):
        if principal_identifier and not isinstance(principal_identifier, str):
            raise TypeError("Expected argument 'principal_identifier' to be a str")
        pulumi.set(__self__, "principal_identifier", principal_identifier)
        if resource_identifier and not isinstance(resource_identifier, str):
            raise TypeError("Expected argument 'resource_identifier' to be a str")
        pulumi.set(__self__, "resource_identifier", resource_identifier)

    @property
    @pulumi.getter(name="principalIdentifier")
    def principal_identifier(self) -> Optional[str]:
        """
        Json encoding of the input principal. For example: `{"DataLakePrincipalIdentifier":"arn:aws:iam::123456789012:role/ExampleRole"}`
        """
        return pulumi.get(self, "principal_identifier")

    @property
    @pulumi.getter(name="resourceIdentifier")
    def resource_identifier(self) -> Optional[str]:
        """
        Json encoding of the input resource. For example: `{"Catalog":null,"Database":null,"Table":null,"TableWithColumns":null,"DataLocation":null,"DataCellsFilter":{"TableCatalogId":"123456789012","DatabaseName":"ExampleDatabase","TableName":"ExampleTable","Name":"ExampleFilter"},"LFTag":null,"LFTagPolicy":null}`
        """
        return pulumi.get(self, "resource_identifier")


class AwaitableGetPrincipalPermissionsResult(GetPrincipalPermissionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPrincipalPermissionsResult(
            principal_identifier=self.principal_identifier,
            resource_identifier=self.resource_identifier)


def get_principal_permissions(principal_identifier: Optional[str] = None,
                              resource_identifier: Optional[str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPrincipalPermissionsResult:
    """
    The ``AWS::LakeFormation::PrincipalPermissions`` resource represents the permissions that a principal has on a GLUDC resource (such as GLUlong databases or GLUlong tables). When you create a ``PrincipalPermissions`` resource, the permissions are granted via the LFlong ``GrantPermissions`` API operation. When you delete a ``PrincipalPermissions`` resource, the permissions on principal-resource pair are revoked via the LFlong ``RevokePermissions`` API operation.


    :param str principal_identifier: Json encoding of the input principal. For example: `{"DataLakePrincipalIdentifier":"arn:aws:iam::123456789012:role/ExampleRole"}`
    :param str resource_identifier: Json encoding of the input resource. For example: `{"Catalog":null,"Database":null,"Table":null,"TableWithColumns":null,"DataLocation":null,"DataCellsFilter":{"TableCatalogId":"123456789012","DatabaseName":"ExampleDatabase","TableName":"ExampleTable","Name":"ExampleFilter"},"LFTag":null,"LFTagPolicy":null}`
    """
    __args__ = dict()
    __args__['principalIdentifier'] = principal_identifier
    __args__['resourceIdentifier'] = resource_identifier
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:lakeformation:getPrincipalPermissions', __args__, opts=opts, typ=GetPrincipalPermissionsResult).value

    return AwaitableGetPrincipalPermissionsResult(
        principal_identifier=pulumi.get(__ret__, 'principal_identifier'),
        resource_identifier=pulumi.get(__ret__, 'resource_identifier'))
def get_principal_permissions_output(principal_identifier: Optional[pulumi.Input[str]] = None,
                                     resource_identifier: Optional[pulumi.Input[str]] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetPrincipalPermissionsResult]:
    """
    The ``AWS::LakeFormation::PrincipalPermissions`` resource represents the permissions that a principal has on a GLUDC resource (such as GLUlong databases or GLUlong tables). When you create a ``PrincipalPermissions`` resource, the permissions are granted via the LFlong ``GrantPermissions`` API operation. When you delete a ``PrincipalPermissions`` resource, the permissions on principal-resource pair are revoked via the LFlong ``RevokePermissions`` API operation.


    :param str principal_identifier: Json encoding of the input principal. For example: `{"DataLakePrincipalIdentifier":"arn:aws:iam::123456789012:role/ExampleRole"}`
    :param str resource_identifier: Json encoding of the input resource. For example: `{"Catalog":null,"Database":null,"Table":null,"TableWithColumns":null,"DataLocation":null,"DataCellsFilter":{"TableCatalogId":"123456789012","DatabaseName":"ExampleDatabase","TableName":"ExampleTable","Name":"ExampleFilter"},"LFTag":null,"LFTagPolicy":null}`
    """
    __args__ = dict()
    __args__['principalIdentifier'] = principal_identifier
    __args__['resourceIdentifier'] = resource_identifier
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:lakeformation:getPrincipalPermissions', __args__, opts=opts, typ=GetPrincipalPermissionsResult)
    return __ret__.apply(lambda __response__: GetPrincipalPermissionsResult(
        principal_identifier=pulumi.get(__response__, 'principal_identifier'),
        resource_identifier=pulumi.get(__response__, 'resource_identifier')))
