# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['DeliveryStreamArgs', 'DeliveryStream']

@pulumi.input_type
class DeliveryStreamArgs:
    def __init__(__self__, *,
                 amazon_open_search_serverless_destination_configuration: Optional[pulumi.Input['DeliveryStreamAmazonOpenSearchServerlessDestinationConfigurationArgs']] = None,
                 amazonopensearchservice_destination_configuration: Optional[pulumi.Input['DeliveryStreamAmazonopensearchserviceDestinationConfigurationArgs']] = None,
                 delivery_stream_encryption_configuration_input: Optional[pulumi.Input['DeliveryStreamEncryptionConfigurationInputArgs']] = None,
                 delivery_stream_name: Optional[pulumi.Input[str]] = None,
                 delivery_stream_type: Optional[pulumi.Input['DeliveryStreamType']] = None,
                 elasticsearch_destination_configuration: Optional[pulumi.Input['DeliveryStreamElasticsearchDestinationConfigurationArgs']] = None,
                 extended_s3_destination_configuration: Optional[pulumi.Input['DeliveryStreamExtendedS3DestinationConfigurationArgs']] = None,
                 http_endpoint_destination_configuration: Optional[pulumi.Input['DeliveryStreamHttpEndpointDestinationConfigurationArgs']] = None,
                 iceberg_destination_configuration: Optional[pulumi.Input['DeliveryStreamIcebergDestinationConfigurationArgs']] = None,
                 kinesis_stream_source_configuration: Optional[pulumi.Input['DeliveryStreamKinesisStreamSourceConfigurationArgs']] = None,
                 msk_source_configuration: Optional[pulumi.Input['DeliveryStreamMskSourceConfigurationArgs']] = None,
                 redshift_destination_configuration: Optional[pulumi.Input['DeliveryStreamRedshiftDestinationConfigurationArgs']] = None,
                 s3_destination_configuration: Optional[pulumi.Input['DeliveryStreamS3DestinationConfigurationArgs']] = None,
                 snowflake_destination_configuration: Optional[pulumi.Input['DeliveryStreamSnowflakeDestinationConfigurationArgs']] = None,
                 splunk_destination_configuration: Optional[pulumi.Input['DeliveryStreamSplunkDestinationConfigurationArgs']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a DeliveryStream resource.
        :param pulumi.Input['DeliveryStreamAmazonOpenSearchServerlessDestinationConfigurationArgs'] amazon_open_search_serverless_destination_configuration: Describes the configuration of a destination in the Serverless offering for Amazon OpenSearch Service.
        :param pulumi.Input['DeliveryStreamAmazonopensearchserviceDestinationConfigurationArgs'] amazonopensearchservice_destination_configuration: The destination in Amazon OpenSearch Service. You can specify only one destination.
        :param pulumi.Input['DeliveryStreamEncryptionConfigurationInputArgs'] delivery_stream_encryption_configuration_input: Specifies the type and Amazon Resource Name (ARN) of the CMK to use for Server-Side Encryption (SSE).
        :param pulumi.Input[str] delivery_stream_name: The name of the delivery stream.
        :param pulumi.Input['DeliveryStreamType'] delivery_stream_type: The delivery stream type. This can be one of the following values:
               
               - `DirectPut` : Provider applications access the delivery stream directly.
               - `KinesisStreamAsSource` : The delivery stream uses a Kinesis data stream as a source.
        :param pulumi.Input['DeliveryStreamElasticsearchDestinationConfigurationArgs'] elasticsearch_destination_configuration: An Amazon ES destination for the delivery stream.
               
               Conditional. You must specify only one destination configuration.
               
               If you change the delivery stream destination from an Amazon ES destination to an Amazon S3 or Amazon Redshift destination, update requires [some interruptions](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-some-interrupt) .
        :param pulumi.Input['DeliveryStreamExtendedS3DestinationConfigurationArgs'] extended_s3_destination_configuration: An Amazon S3 destination for the delivery stream.
               
               Conditional. You must specify only one destination configuration.
               
               If you change the delivery stream destination from an Amazon Extended S3 destination to an Amazon ES destination, update requires [some interruptions](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-some-interrupt) .
        :param pulumi.Input['DeliveryStreamHttpEndpointDestinationConfigurationArgs'] http_endpoint_destination_configuration: Enables configuring Kinesis Firehose to deliver data to any HTTP endpoint destination. You can specify only one destination.
        :param pulumi.Input['DeliveryStreamIcebergDestinationConfigurationArgs'] iceberg_destination_configuration: Specifies the destination configure settings for Apache Iceberg Table.
               
               Amazon Data Firehose is in preview release and is subject to change.
        :param pulumi.Input['DeliveryStreamKinesisStreamSourceConfigurationArgs'] kinesis_stream_source_configuration: When a Kinesis stream is used as the source for the delivery stream, a [KinesisStreamSourceConfiguration](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-kinesisstreamsourceconfiguration.html) containing the Kinesis stream ARN and the role ARN for the source stream.
        :param pulumi.Input['DeliveryStreamMskSourceConfigurationArgs'] msk_source_configuration: The configuration for the Amazon MSK cluster to be used as the source for a delivery stream.
        :param pulumi.Input['DeliveryStreamRedshiftDestinationConfigurationArgs'] redshift_destination_configuration: An Amazon Redshift destination for the delivery stream.
               
               Conditional. You must specify only one destination configuration.
               
               If you change the delivery stream destination from an Amazon Redshift destination to an Amazon ES destination, update requires [some interruptions](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-some-interrupt) .
        :param pulumi.Input['DeliveryStreamS3DestinationConfigurationArgs'] s3_destination_configuration: The `S3DestinationConfiguration` property type specifies an Amazon Simple Storage Service (Amazon S3) destination to which Amazon Kinesis Data Firehose (Kinesis Data Firehose) delivers data.
               
               Conditional. You must specify only one destination configuration.
               
               If you change the delivery stream destination from an Amazon S3 destination to an Amazon ES destination, update requires [some interruptions](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-some-interrupt) .
        :param pulumi.Input['DeliveryStreamSnowflakeDestinationConfigurationArgs'] snowflake_destination_configuration: Configure Snowflake destination
        :param pulumi.Input['DeliveryStreamSplunkDestinationConfigurationArgs'] splunk_destination_configuration: The configuration of a destination in Splunk for the delivery stream.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: A set of tags to assign to the delivery stream. A tag is a key-value pair that you can define and assign to AWS resources. Tags are metadata. For example, you can add friendly names and descriptions or other types of information that can help you distinguish the delivery stream. For more information about tags, see [Using Cost Allocation Tags](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html) in the AWS Billing and Cost Management User Guide.
               
               You can specify up to 50 tags when creating a delivery stream.
               
               If you specify tags in the `CreateDeliveryStream` action, Amazon Data Firehose performs an additional authorization on the `firehose:TagDeliveryStream` action to verify if users have permissions to create tags. If you do not provide this permission, requests to create new Firehose delivery streams with IAM resource tags will fail with an `AccessDeniedException` such as following.
               
               *AccessDeniedException*
               
               User: arn:aws:sts::x:assumed-role/x/x is not authorized to perform: firehose:TagDeliveryStream on resource: arn:aws:firehose:us-east-1:x:deliverystream/x with an explicit deny in an identity-based policy.
               
               For an example IAM policy, see [Tag example.](https://docs.aws.amazon.com/firehose/latest/APIReference/API_CreateDeliveryStream.html#API_CreateDeliveryStream_Examples)
        """
        if amazon_open_search_serverless_destination_configuration is not None:
            pulumi.set(__self__, "amazon_open_search_serverless_destination_configuration", amazon_open_search_serverless_destination_configuration)
        if amazonopensearchservice_destination_configuration is not None:
            pulumi.set(__self__, "amazonopensearchservice_destination_configuration", amazonopensearchservice_destination_configuration)
        if delivery_stream_encryption_configuration_input is not None:
            pulumi.set(__self__, "delivery_stream_encryption_configuration_input", delivery_stream_encryption_configuration_input)
        if delivery_stream_name is not None:
            pulumi.set(__self__, "delivery_stream_name", delivery_stream_name)
        if delivery_stream_type is not None:
            pulumi.set(__self__, "delivery_stream_type", delivery_stream_type)
        if elasticsearch_destination_configuration is not None:
            pulumi.set(__self__, "elasticsearch_destination_configuration", elasticsearch_destination_configuration)
        if extended_s3_destination_configuration is not None:
            pulumi.set(__self__, "extended_s3_destination_configuration", extended_s3_destination_configuration)
        if http_endpoint_destination_configuration is not None:
            pulumi.set(__self__, "http_endpoint_destination_configuration", http_endpoint_destination_configuration)
        if iceberg_destination_configuration is not None:
            pulumi.set(__self__, "iceberg_destination_configuration", iceberg_destination_configuration)
        if kinesis_stream_source_configuration is not None:
            pulumi.set(__self__, "kinesis_stream_source_configuration", kinesis_stream_source_configuration)
        if msk_source_configuration is not None:
            pulumi.set(__self__, "msk_source_configuration", msk_source_configuration)
        if redshift_destination_configuration is not None:
            pulumi.set(__self__, "redshift_destination_configuration", redshift_destination_configuration)
        if s3_destination_configuration is not None:
            pulumi.set(__self__, "s3_destination_configuration", s3_destination_configuration)
        if snowflake_destination_configuration is not None:
            pulumi.set(__self__, "snowflake_destination_configuration", snowflake_destination_configuration)
        if splunk_destination_configuration is not None:
            pulumi.set(__self__, "splunk_destination_configuration", splunk_destination_configuration)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="amazonOpenSearchServerlessDestinationConfiguration")
    def amazon_open_search_serverless_destination_configuration(self) -> Optional[pulumi.Input['DeliveryStreamAmazonOpenSearchServerlessDestinationConfigurationArgs']]:
        """
        Describes the configuration of a destination in the Serverless offering for Amazon OpenSearch Service.
        """
        return pulumi.get(self, "amazon_open_search_serverless_destination_configuration")

    @amazon_open_search_serverless_destination_configuration.setter
    def amazon_open_search_serverless_destination_configuration(self, value: Optional[pulumi.Input['DeliveryStreamAmazonOpenSearchServerlessDestinationConfigurationArgs']]):
        pulumi.set(self, "amazon_open_search_serverless_destination_configuration", value)

    @property
    @pulumi.getter(name="amazonopensearchserviceDestinationConfiguration")
    def amazonopensearchservice_destination_configuration(self) -> Optional[pulumi.Input['DeliveryStreamAmazonopensearchserviceDestinationConfigurationArgs']]:
        """
        The destination in Amazon OpenSearch Service. You can specify only one destination.
        """
        return pulumi.get(self, "amazonopensearchservice_destination_configuration")

    @amazonopensearchservice_destination_configuration.setter
    def amazonopensearchservice_destination_configuration(self, value: Optional[pulumi.Input['DeliveryStreamAmazonopensearchserviceDestinationConfigurationArgs']]):
        pulumi.set(self, "amazonopensearchservice_destination_configuration", value)

    @property
    @pulumi.getter(name="deliveryStreamEncryptionConfigurationInput")
    def delivery_stream_encryption_configuration_input(self) -> Optional[pulumi.Input['DeliveryStreamEncryptionConfigurationInputArgs']]:
        """
        Specifies the type and Amazon Resource Name (ARN) of the CMK to use for Server-Side Encryption (SSE).
        """
        return pulumi.get(self, "delivery_stream_encryption_configuration_input")

    @delivery_stream_encryption_configuration_input.setter
    def delivery_stream_encryption_configuration_input(self, value: Optional[pulumi.Input['DeliveryStreamEncryptionConfigurationInputArgs']]):
        pulumi.set(self, "delivery_stream_encryption_configuration_input", value)

    @property
    @pulumi.getter(name="deliveryStreamName")
    def delivery_stream_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the delivery stream.
        """
        return pulumi.get(self, "delivery_stream_name")

    @delivery_stream_name.setter
    def delivery_stream_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "delivery_stream_name", value)

    @property
    @pulumi.getter(name="deliveryStreamType")
    def delivery_stream_type(self) -> Optional[pulumi.Input['DeliveryStreamType']]:
        """
        The delivery stream type. This can be one of the following values:

        - `DirectPut` : Provider applications access the delivery stream directly.
        - `KinesisStreamAsSource` : The delivery stream uses a Kinesis data stream as a source.
        """
        return pulumi.get(self, "delivery_stream_type")

    @delivery_stream_type.setter
    def delivery_stream_type(self, value: Optional[pulumi.Input['DeliveryStreamType']]):
        pulumi.set(self, "delivery_stream_type", value)

    @property
    @pulumi.getter(name="elasticsearchDestinationConfiguration")
    def elasticsearch_destination_configuration(self) -> Optional[pulumi.Input['DeliveryStreamElasticsearchDestinationConfigurationArgs']]:
        """
        An Amazon ES destination for the delivery stream.

        Conditional. You must specify only one destination configuration.

        If you change the delivery stream destination from an Amazon ES destination to an Amazon S3 or Amazon Redshift destination, update requires [some interruptions](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-some-interrupt) .
        """
        return pulumi.get(self, "elasticsearch_destination_configuration")

    @elasticsearch_destination_configuration.setter
    def elasticsearch_destination_configuration(self, value: Optional[pulumi.Input['DeliveryStreamElasticsearchDestinationConfigurationArgs']]):
        pulumi.set(self, "elasticsearch_destination_configuration", value)

    @property
    @pulumi.getter(name="extendedS3DestinationConfiguration")
    def extended_s3_destination_configuration(self) -> Optional[pulumi.Input['DeliveryStreamExtendedS3DestinationConfigurationArgs']]:
        """
        An Amazon S3 destination for the delivery stream.

        Conditional. You must specify only one destination configuration.

        If you change the delivery stream destination from an Amazon Extended S3 destination to an Amazon ES destination, update requires [some interruptions](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-some-interrupt) .
        """
        return pulumi.get(self, "extended_s3_destination_configuration")

    @extended_s3_destination_configuration.setter
    def extended_s3_destination_configuration(self, value: Optional[pulumi.Input['DeliveryStreamExtendedS3DestinationConfigurationArgs']]):
        pulumi.set(self, "extended_s3_destination_configuration", value)

    @property
    @pulumi.getter(name="httpEndpointDestinationConfiguration")
    def http_endpoint_destination_configuration(self) -> Optional[pulumi.Input['DeliveryStreamHttpEndpointDestinationConfigurationArgs']]:
        """
        Enables configuring Kinesis Firehose to deliver data to any HTTP endpoint destination. You can specify only one destination.
        """
        return pulumi.get(self, "http_endpoint_destination_configuration")

    @http_endpoint_destination_configuration.setter
    def http_endpoint_destination_configuration(self, value: Optional[pulumi.Input['DeliveryStreamHttpEndpointDestinationConfigurationArgs']]):
        pulumi.set(self, "http_endpoint_destination_configuration", value)

    @property
    @pulumi.getter(name="icebergDestinationConfiguration")
    def iceberg_destination_configuration(self) -> Optional[pulumi.Input['DeliveryStreamIcebergDestinationConfigurationArgs']]:
        """
        Specifies the destination configure settings for Apache Iceberg Table.

        Amazon Data Firehose is in preview release and is subject to change.
        """
        return pulumi.get(self, "iceberg_destination_configuration")

    @iceberg_destination_configuration.setter
    def iceberg_destination_configuration(self, value: Optional[pulumi.Input['DeliveryStreamIcebergDestinationConfigurationArgs']]):
        pulumi.set(self, "iceberg_destination_configuration", value)

    @property
    @pulumi.getter(name="kinesisStreamSourceConfiguration")
    def kinesis_stream_source_configuration(self) -> Optional[pulumi.Input['DeliveryStreamKinesisStreamSourceConfigurationArgs']]:
        """
        When a Kinesis stream is used as the source for the delivery stream, a [KinesisStreamSourceConfiguration](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-kinesisstreamsourceconfiguration.html) containing the Kinesis stream ARN and the role ARN for the source stream.
        """
        return pulumi.get(self, "kinesis_stream_source_configuration")

    @kinesis_stream_source_configuration.setter
    def kinesis_stream_source_configuration(self, value: Optional[pulumi.Input['DeliveryStreamKinesisStreamSourceConfigurationArgs']]):
        pulumi.set(self, "kinesis_stream_source_configuration", value)

    @property
    @pulumi.getter(name="mskSourceConfiguration")
    def msk_source_configuration(self) -> Optional[pulumi.Input['DeliveryStreamMskSourceConfigurationArgs']]:
        """
        The configuration for the Amazon MSK cluster to be used as the source for a delivery stream.
        """
        return pulumi.get(self, "msk_source_configuration")

    @msk_source_configuration.setter
    def msk_source_configuration(self, value: Optional[pulumi.Input['DeliveryStreamMskSourceConfigurationArgs']]):
        pulumi.set(self, "msk_source_configuration", value)

    @property
    @pulumi.getter(name="redshiftDestinationConfiguration")
    def redshift_destination_configuration(self) -> Optional[pulumi.Input['DeliveryStreamRedshiftDestinationConfigurationArgs']]:
        """
        An Amazon Redshift destination for the delivery stream.

        Conditional. You must specify only one destination configuration.

        If you change the delivery stream destination from an Amazon Redshift destination to an Amazon ES destination, update requires [some interruptions](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-some-interrupt) .
        """
        return pulumi.get(self, "redshift_destination_configuration")

    @redshift_destination_configuration.setter
    def redshift_destination_configuration(self, value: Optional[pulumi.Input['DeliveryStreamRedshiftDestinationConfigurationArgs']]):
        pulumi.set(self, "redshift_destination_configuration", value)

    @property
    @pulumi.getter(name="s3DestinationConfiguration")
    def s3_destination_configuration(self) -> Optional[pulumi.Input['DeliveryStreamS3DestinationConfigurationArgs']]:
        """
        The `S3DestinationConfiguration` property type specifies an Amazon Simple Storage Service (Amazon S3) destination to which Amazon Kinesis Data Firehose (Kinesis Data Firehose) delivers data.

        Conditional. You must specify only one destination configuration.

        If you change the delivery stream destination from an Amazon S3 destination to an Amazon ES destination, update requires [some interruptions](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-some-interrupt) .
        """
        return pulumi.get(self, "s3_destination_configuration")

    @s3_destination_configuration.setter
    def s3_destination_configuration(self, value: Optional[pulumi.Input['DeliveryStreamS3DestinationConfigurationArgs']]):
        pulumi.set(self, "s3_destination_configuration", value)

    @property
    @pulumi.getter(name="snowflakeDestinationConfiguration")
    def snowflake_destination_configuration(self) -> Optional[pulumi.Input['DeliveryStreamSnowflakeDestinationConfigurationArgs']]:
        """
        Configure Snowflake destination
        """
        return pulumi.get(self, "snowflake_destination_configuration")

    @snowflake_destination_configuration.setter
    def snowflake_destination_configuration(self, value: Optional[pulumi.Input['DeliveryStreamSnowflakeDestinationConfigurationArgs']]):
        pulumi.set(self, "snowflake_destination_configuration", value)

    @property
    @pulumi.getter(name="splunkDestinationConfiguration")
    def splunk_destination_configuration(self) -> Optional[pulumi.Input['DeliveryStreamSplunkDestinationConfigurationArgs']]:
        """
        The configuration of a destination in Splunk for the delivery stream.
        """
        return pulumi.get(self, "splunk_destination_configuration")

    @splunk_destination_configuration.setter
    def splunk_destination_configuration(self, value: Optional[pulumi.Input['DeliveryStreamSplunkDestinationConfigurationArgs']]):
        pulumi.set(self, "splunk_destination_configuration", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        A set of tags to assign to the delivery stream. A tag is a key-value pair that you can define and assign to AWS resources. Tags are metadata. For example, you can add friendly names and descriptions or other types of information that can help you distinguish the delivery stream. For more information about tags, see [Using Cost Allocation Tags](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html) in the AWS Billing and Cost Management User Guide.

        You can specify up to 50 tags when creating a delivery stream.

        If you specify tags in the `CreateDeliveryStream` action, Amazon Data Firehose performs an additional authorization on the `firehose:TagDeliveryStream` action to verify if users have permissions to create tags. If you do not provide this permission, requests to create new Firehose delivery streams with IAM resource tags will fail with an `AccessDeniedException` such as following.

        *AccessDeniedException*

        User: arn:aws:sts::x:assumed-role/x/x is not authorized to perform: firehose:TagDeliveryStream on resource: arn:aws:firehose:us-east-1:x:deliverystream/x with an explicit deny in an identity-based policy.

        For an example IAM policy, see [Tag example.](https://docs.aws.amazon.com/firehose/latest/APIReference/API_CreateDeliveryStream.html#API_CreateDeliveryStream_Examples)
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


class DeliveryStream(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 amazon_open_search_serverless_destination_configuration: Optional[pulumi.Input[Union['DeliveryStreamAmazonOpenSearchServerlessDestinationConfigurationArgs', 'DeliveryStreamAmazonOpenSearchServerlessDestinationConfigurationArgsDict']]] = None,
                 amazonopensearchservice_destination_configuration: Optional[pulumi.Input[Union['DeliveryStreamAmazonopensearchserviceDestinationConfigurationArgs', 'DeliveryStreamAmazonopensearchserviceDestinationConfigurationArgsDict']]] = None,
                 delivery_stream_encryption_configuration_input: Optional[pulumi.Input[Union['DeliveryStreamEncryptionConfigurationInputArgs', 'DeliveryStreamEncryptionConfigurationInputArgsDict']]] = None,
                 delivery_stream_name: Optional[pulumi.Input[str]] = None,
                 delivery_stream_type: Optional[pulumi.Input['DeliveryStreamType']] = None,
                 elasticsearch_destination_configuration: Optional[pulumi.Input[Union['DeliveryStreamElasticsearchDestinationConfigurationArgs', 'DeliveryStreamElasticsearchDestinationConfigurationArgsDict']]] = None,
                 extended_s3_destination_configuration: Optional[pulumi.Input[Union['DeliveryStreamExtendedS3DestinationConfigurationArgs', 'DeliveryStreamExtendedS3DestinationConfigurationArgsDict']]] = None,
                 http_endpoint_destination_configuration: Optional[pulumi.Input[Union['DeliveryStreamHttpEndpointDestinationConfigurationArgs', 'DeliveryStreamHttpEndpointDestinationConfigurationArgsDict']]] = None,
                 iceberg_destination_configuration: Optional[pulumi.Input[Union['DeliveryStreamIcebergDestinationConfigurationArgs', 'DeliveryStreamIcebergDestinationConfigurationArgsDict']]] = None,
                 kinesis_stream_source_configuration: Optional[pulumi.Input[Union['DeliveryStreamKinesisStreamSourceConfigurationArgs', 'DeliveryStreamKinesisStreamSourceConfigurationArgsDict']]] = None,
                 msk_source_configuration: Optional[pulumi.Input[Union['DeliveryStreamMskSourceConfigurationArgs', 'DeliveryStreamMskSourceConfigurationArgsDict']]] = None,
                 redshift_destination_configuration: Optional[pulumi.Input[Union['DeliveryStreamRedshiftDestinationConfigurationArgs', 'DeliveryStreamRedshiftDestinationConfigurationArgsDict']]] = None,
                 s3_destination_configuration: Optional[pulumi.Input[Union['DeliveryStreamS3DestinationConfigurationArgs', 'DeliveryStreamS3DestinationConfigurationArgsDict']]] = None,
                 snowflake_destination_configuration: Optional[pulumi.Input[Union['DeliveryStreamSnowflakeDestinationConfigurationArgs', 'DeliveryStreamSnowflakeDestinationConfigurationArgsDict']]] = None,
                 splunk_destination_configuration: Optional[pulumi.Input[Union['DeliveryStreamSplunkDestinationConfigurationArgs', 'DeliveryStreamSplunkDestinationConfigurationArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::KinesisFirehose::DeliveryStream

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['DeliveryStreamAmazonOpenSearchServerlessDestinationConfigurationArgs', 'DeliveryStreamAmazonOpenSearchServerlessDestinationConfigurationArgsDict']] amazon_open_search_serverless_destination_configuration: Describes the configuration of a destination in the Serverless offering for Amazon OpenSearch Service.
        :param pulumi.Input[Union['DeliveryStreamAmazonopensearchserviceDestinationConfigurationArgs', 'DeliveryStreamAmazonopensearchserviceDestinationConfigurationArgsDict']] amazonopensearchservice_destination_configuration: The destination in Amazon OpenSearch Service. You can specify only one destination.
        :param pulumi.Input[Union['DeliveryStreamEncryptionConfigurationInputArgs', 'DeliveryStreamEncryptionConfigurationInputArgsDict']] delivery_stream_encryption_configuration_input: Specifies the type and Amazon Resource Name (ARN) of the CMK to use for Server-Side Encryption (SSE).
        :param pulumi.Input[str] delivery_stream_name: The name of the delivery stream.
        :param pulumi.Input['DeliveryStreamType'] delivery_stream_type: The delivery stream type. This can be one of the following values:
               
               - `DirectPut` : Provider applications access the delivery stream directly.
               - `KinesisStreamAsSource` : The delivery stream uses a Kinesis data stream as a source.
        :param pulumi.Input[Union['DeliveryStreamElasticsearchDestinationConfigurationArgs', 'DeliveryStreamElasticsearchDestinationConfigurationArgsDict']] elasticsearch_destination_configuration: An Amazon ES destination for the delivery stream.
               
               Conditional. You must specify only one destination configuration.
               
               If you change the delivery stream destination from an Amazon ES destination to an Amazon S3 or Amazon Redshift destination, update requires [some interruptions](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-some-interrupt) .
        :param pulumi.Input[Union['DeliveryStreamExtendedS3DestinationConfigurationArgs', 'DeliveryStreamExtendedS3DestinationConfigurationArgsDict']] extended_s3_destination_configuration: An Amazon S3 destination for the delivery stream.
               
               Conditional. You must specify only one destination configuration.
               
               If you change the delivery stream destination from an Amazon Extended S3 destination to an Amazon ES destination, update requires [some interruptions](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-some-interrupt) .
        :param pulumi.Input[Union['DeliveryStreamHttpEndpointDestinationConfigurationArgs', 'DeliveryStreamHttpEndpointDestinationConfigurationArgsDict']] http_endpoint_destination_configuration: Enables configuring Kinesis Firehose to deliver data to any HTTP endpoint destination. You can specify only one destination.
        :param pulumi.Input[Union['DeliveryStreamIcebergDestinationConfigurationArgs', 'DeliveryStreamIcebergDestinationConfigurationArgsDict']] iceberg_destination_configuration: Specifies the destination configure settings for Apache Iceberg Table.
               
               Amazon Data Firehose is in preview release and is subject to change.
        :param pulumi.Input[Union['DeliveryStreamKinesisStreamSourceConfigurationArgs', 'DeliveryStreamKinesisStreamSourceConfigurationArgsDict']] kinesis_stream_source_configuration: When a Kinesis stream is used as the source for the delivery stream, a [KinesisStreamSourceConfiguration](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-kinesisstreamsourceconfiguration.html) containing the Kinesis stream ARN and the role ARN for the source stream.
        :param pulumi.Input[Union['DeliveryStreamMskSourceConfigurationArgs', 'DeliveryStreamMskSourceConfigurationArgsDict']] msk_source_configuration: The configuration for the Amazon MSK cluster to be used as the source for a delivery stream.
        :param pulumi.Input[Union['DeliveryStreamRedshiftDestinationConfigurationArgs', 'DeliveryStreamRedshiftDestinationConfigurationArgsDict']] redshift_destination_configuration: An Amazon Redshift destination for the delivery stream.
               
               Conditional. You must specify only one destination configuration.
               
               If you change the delivery stream destination from an Amazon Redshift destination to an Amazon ES destination, update requires [some interruptions](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-some-interrupt) .
        :param pulumi.Input[Union['DeliveryStreamS3DestinationConfigurationArgs', 'DeliveryStreamS3DestinationConfigurationArgsDict']] s3_destination_configuration: The `S3DestinationConfiguration` property type specifies an Amazon Simple Storage Service (Amazon S3) destination to which Amazon Kinesis Data Firehose (Kinesis Data Firehose) delivers data.
               
               Conditional. You must specify only one destination configuration.
               
               If you change the delivery stream destination from an Amazon S3 destination to an Amazon ES destination, update requires [some interruptions](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-some-interrupt) .
        :param pulumi.Input[Union['DeliveryStreamSnowflakeDestinationConfigurationArgs', 'DeliveryStreamSnowflakeDestinationConfigurationArgsDict']] snowflake_destination_configuration: Configure Snowflake destination
        :param pulumi.Input[Union['DeliveryStreamSplunkDestinationConfigurationArgs', 'DeliveryStreamSplunkDestinationConfigurationArgsDict']] splunk_destination_configuration: The configuration of a destination in Splunk for the delivery stream.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: A set of tags to assign to the delivery stream. A tag is a key-value pair that you can define and assign to AWS resources. Tags are metadata. For example, you can add friendly names and descriptions or other types of information that can help you distinguish the delivery stream. For more information about tags, see [Using Cost Allocation Tags](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html) in the AWS Billing and Cost Management User Guide.
               
               You can specify up to 50 tags when creating a delivery stream.
               
               If you specify tags in the `CreateDeliveryStream` action, Amazon Data Firehose performs an additional authorization on the `firehose:TagDeliveryStream` action to verify if users have permissions to create tags. If you do not provide this permission, requests to create new Firehose delivery streams with IAM resource tags will fail with an `AccessDeniedException` such as following.
               
               *AccessDeniedException*
               
               User: arn:aws:sts::x:assumed-role/x/x is not authorized to perform: firehose:TagDeliveryStream on resource: arn:aws:firehose:us-east-1:x:deliverystream/x with an explicit deny in an identity-based policy.
               
               For an example IAM policy, see [Tag example.](https://docs.aws.amazon.com/firehose/latest/APIReference/API_CreateDeliveryStream.html#API_CreateDeliveryStream_Examples)
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[DeliveryStreamArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::KinesisFirehose::DeliveryStream

        :param str resource_name: The name of the resource.
        :param DeliveryStreamArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DeliveryStreamArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 amazon_open_search_serverless_destination_configuration: Optional[pulumi.Input[Union['DeliveryStreamAmazonOpenSearchServerlessDestinationConfigurationArgs', 'DeliveryStreamAmazonOpenSearchServerlessDestinationConfigurationArgsDict']]] = None,
                 amazonopensearchservice_destination_configuration: Optional[pulumi.Input[Union['DeliveryStreamAmazonopensearchserviceDestinationConfigurationArgs', 'DeliveryStreamAmazonopensearchserviceDestinationConfigurationArgsDict']]] = None,
                 delivery_stream_encryption_configuration_input: Optional[pulumi.Input[Union['DeliveryStreamEncryptionConfigurationInputArgs', 'DeliveryStreamEncryptionConfigurationInputArgsDict']]] = None,
                 delivery_stream_name: Optional[pulumi.Input[str]] = None,
                 delivery_stream_type: Optional[pulumi.Input['DeliveryStreamType']] = None,
                 elasticsearch_destination_configuration: Optional[pulumi.Input[Union['DeliveryStreamElasticsearchDestinationConfigurationArgs', 'DeliveryStreamElasticsearchDestinationConfigurationArgsDict']]] = None,
                 extended_s3_destination_configuration: Optional[pulumi.Input[Union['DeliveryStreamExtendedS3DestinationConfigurationArgs', 'DeliveryStreamExtendedS3DestinationConfigurationArgsDict']]] = None,
                 http_endpoint_destination_configuration: Optional[pulumi.Input[Union['DeliveryStreamHttpEndpointDestinationConfigurationArgs', 'DeliveryStreamHttpEndpointDestinationConfigurationArgsDict']]] = None,
                 iceberg_destination_configuration: Optional[pulumi.Input[Union['DeliveryStreamIcebergDestinationConfigurationArgs', 'DeliveryStreamIcebergDestinationConfigurationArgsDict']]] = None,
                 kinesis_stream_source_configuration: Optional[pulumi.Input[Union['DeliveryStreamKinesisStreamSourceConfigurationArgs', 'DeliveryStreamKinesisStreamSourceConfigurationArgsDict']]] = None,
                 msk_source_configuration: Optional[pulumi.Input[Union['DeliveryStreamMskSourceConfigurationArgs', 'DeliveryStreamMskSourceConfigurationArgsDict']]] = None,
                 redshift_destination_configuration: Optional[pulumi.Input[Union['DeliveryStreamRedshiftDestinationConfigurationArgs', 'DeliveryStreamRedshiftDestinationConfigurationArgsDict']]] = None,
                 s3_destination_configuration: Optional[pulumi.Input[Union['DeliveryStreamS3DestinationConfigurationArgs', 'DeliveryStreamS3DestinationConfigurationArgsDict']]] = None,
                 snowflake_destination_configuration: Optional[pulumi.Input[Union['DeliveryStreamSnowflakeDestinationConfigurationArgs', 'DeliveryStreamSnowflakeDestinationConfigurationArgsDict']]] = None,
                 splunk_destination_configuration: Optional[pulumi.Input[Union['DeliveryStreamSplunkDestinationConfigurationArgs', 'DeliveryStreamSplunkDestinationConfigurationArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DeliveryStreamArgs.__new__(DeliveryStreamArgs)

            __props__.__dict__["amazon_open_search_serverless_destination_configuration"] = amazon_open_search_serverless_destination_configuration
            __props__.__dict__["amazonopensearchservice_destination_configuration"] = amazonopensearchservice_destination_configuration
            __props__.__dict__["delivery_stream_encryption_configuration_input"] = delivery_stream_encryption_configuration_input
            __props__.__dict__["delivery_stream_name"] = delivery_stream_name
            __props__.__dict__["delivery_stream_type"] = delivery_stream_type
            __props__.__dict__["elasticsearch_destination_configuration"] = elasticsearch_destination_configuration
            __props__.__dict__["extended_s3_destination_configuration"] = extended_s3_destination_configuration
            __props__.__dict__["http_endpoint_destination_configuration"] = http_endpoint_destination_configuration
            __props__.__dict__["iceberg_destination_configuration"] = iceberg_destination_configuration
            __props__.__dict__["kinesis_stream_source_configuration"] = kinesis_stream_source_configuration
            __props__.__dict__["msk_source_configuration"] = msk_source_configuration
            __props__.__dict__["redshift_destination_configuration"] = redshift_destination_configuration
            __props__.__dict__["s3_destination_configuration"] = s3_destination_configuration
            __props__.__dict__["snowflake_destination_configuration"] = snowflake_destination_configuration
            __props__.__dict__["splunk_destination_configuration"] = splunk_destination_configuration
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["amazonOpenSearchServerlessDestinationConfiguration.vpcConfiguration", "amazonopensearchserviceDestinationConfiguration.vpcConfiguration", "deliveryStreamName", "deliveryStreamType", "elasticsearchDestinationConfiguration.vpcConfiguration", "icebergDestinationConfiguration", "kinesisStreamSourceConfiguration", "mskSourceConfiguration", "snowflakeDestinationConfiguration.snowflakeVpcConfiguration"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(DeliveryStream, __self__).__init__(
            'aws-native:kinesisfirehose:DeliveryStream',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'DeliveryStream':
        """
        Get an existing DeliveryStream resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = DeliveryStreamArgs.__new__(DeliveryStreamArgs)

        __props__.__dict__["amazon_open_search_serverless_destination_configuration"] = None
        __props__.__dict__["amazonopensearchservice_destination_configuration"] = None
        __props__.__dict__["arn"] = None
        __props__.__dict__["delivery_stream_encryption_configuration_input"] = None
        __props__.__dict__["delivery_stream_name"] = None
        __props__.__dict__["delivery_stream_type"] = None
        __props__.__dict__["elasticsearch_destination_configuration"] = None
        __props__.__dict__["extended_s3_destination_configuration"] = None
        __props__.__dict__["http_endpoint_destination_configuration"] = None
        __props__.__dict__["iceberg_destination_configuration"] = None
        __props__.__dict__["kinesis_stream_source_configuration"] = None
        __props__.__dict__["msk_source_configuration"] = None
        __props__.__dict__["redshift_destination_configuration"] = None
        __props__.__dict__["s3_destination_configuration"] = None
        __props__.__dict__["snowflake_destination_configuration"] = None
        __props__.__dict__["splunk_destination_configuration"] = None
        __props__.__dict__["tags"] = None
        return DeliveryStream(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="amazonOpenSearchServerlessDestinationConfiguration")
    def amazon_open_search_serverless_destination_configuration(self) -> pulumi.Output[Optional['outputs.DeliveryStreamAmazonOpenSearchServerlessDestinationConfiguration']]:
        """
        Describes the configuration of a destination in the Serverless offering for Amazon OpenSearch Service.
        """
        return pulumi.get(self, "amazon_open_search_serverless_destination_configuration")

    @property
    @pulumi.getter(name="amazonopensearchserviceDestinationConfiguration")
    def amazonopensearchservice_destination_configuration(self) -> pulumi.Output[Optional['outputs.DeliveryStreamAmazonopensearchserviceDestinationConfiguration']]:
        """
        The destination in Amazon OpenSearch Service. You can specify only one destination.
        """
        return pulumi.get(self, "amazonopensearchservice_destination_configuration")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN) of the delivery stream, such as `arn:aws:firehose:us-east-2:123456789012:deliverystream/delivery-stream-name` .
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="deliveryStreamEncryptionConfigurationInput")
    def delivery_stream_encryption_configuration_input(self) -> pulumi.Output[Optional['outputs.DeliveryStreamEncryptionConfigurationInput']]:
        """
        Specifies the type and Amazon Resource Name (ARN) of the CMK to use for Server-Side Encryption (SSE).
        """
        return pulumi.get(self, "delivery_stream_encryption_configuration_input")

    @property
    @pulumi.getter(name="deliveryStreamName")
    def delivery_stream_name(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the delivery stream.
        """
        return pulumi.get(self, "delivery_stream_name")

    @property
    @pulumi.getter(name="deliveryStreamType")
    def delivery_stream_type(self) -> pulumi.Output[Optional['DeliveryStreamType']]:
        """
        The delivery stream type. This can be one of the following values:

        - `DirectPut` : Provider applications access the delivery stream directly.
        - `KinesisStreamAsSource` : The delivery stream uses a Kinesis data stream as a source.
        """
        return pulumi.get(self, "delivery_stream_type")

    @property
    @pulumi.getter(name="elasticsearchDestinationConfiguration")
    def elasticsearch_destination_configuration(self) -> pulumi.Output[Optional['outputs.DeliveryStreamElasticsearchDestinationConfiguration']]:
        """
        An Amazon ES destination for the delivery stream.

        Conditional. You must specify only one destination configuration.

        If you change the delivery stream destination from an Amazon ES destination to an Amazon S3 or Amazon Redshift destination, update requires [some interruptions](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-some-interrupt) .
        """
        return pulumi.get(self, "elasticsearch_destination_configuration")

    @property
    @pulumi.getter(name="extendedS3DestinationConfiguration")
    def extended_s3_destination_configuration(self) -> pulumi.Output[Optional['outputs.DeliveryStreamExtendedS3DestinationConfiguration']]:
        """
        An Amazon S3 destination for the delivery stream.

        Conditional. You must specify only one destination configuration.

        If you change the delivery stream destination from an Amazon Extended S3 destination to an Amazon ES destination, update requires [some interruptions](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-some-interrupt) .
        """
        return pulumi.get(self, "extended_s3_destination_configuration")

    @property
    @pulumi.getter(name="httpEndpointDestinationConfiguration")
    def http_endpoint_destination_configuration(self) -> pulumi.Output[Optional['outputs.DeliveryStreamHttpEndpointDestinationConfiguration']]:
        """
        Enables configuring Kinesis Firehose to deliver data to any HTTP endpoint destination. You can specify only one destination.
        """
        return pulumi.get(self, "http_endpoint_destination_configuration")

    @property
    @pulumi.getter(name="icebergDestinationConfiguration")
    def iceberg_destination_configuration(self) -> pulumi.Output[Optional['outputs.DeliveryStreamIcebergDestinationConfiguration']]:
        """
        Specifies the destination configure settings for Apache Iceberg Table.

        Amazon Data Firehose is in preview release and is subject to change.
        """
        return pulumi.get(self, "iceberg_destination_configuration")

    @property
    @pulumi.getter(name="kinesisStreamSourceConfiguration")
    def kinesis_stream_source_configuration(self) -> pulumi.Output[Optional['outputs.DeliveryStreamKinesisStreamSourceConfiguration']]:
        """
        When a Kinesis stream is used as the source for the delivery stream, a [KinesisStreamSourceConfiguration](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-kinesisstreamsourceconfiguration.html) containing the Kinesis stream ARN and the role ARN for the source stream.
        """
        return pulumi.get(self, "kinesis_stream_source_configuration")

    @property
    @pulumi.getter(name="mskSourceConfiguration")
    def msk_source_configuration(self) -> pulumi.Output[Optional['outputs.DeliveryStreamMskSourceConfiguration']]:
        """
        The configuration for the Amazon MSK cluster to be used as the source for a delivery stream.
        """
        return pulumi.get(self, "msk_source_configuration")

    @property
    @pulumi.getter(name="redshiftDestinationConfiguration")
    def redshift_destination_configuration(self) -> pulumi.Output[Optional['outputs.DeliveryStreamRedshiftDestinationConfiguration']]:
        """
        An Amazon Redshift destination for the delivery stream.

        Conditional. You must specify only one destination configuration.

        If you change the delivery stream destination from an Amazon Redshift destination to an Amazon ES destination, update requires [some interruptions](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-some-interrupt) .
        """
        return pulumi.get(self, "redshift_destination_configuration")

    @property
    @pulumi.getter(name="s3DestinationConfiguration")
    def s3_destination_configuration(self) -> pulumi.Output[Optional['outputs.DeliveryStreamS3DestinationConfiguration']]:
        """
        The `S3DestinationConfiguration` property type specifies an Amazon Simple Storage Service (Amazon S3) destination to which Amazon Kinesis Data Firehose (Kinesis Data Firehose) delivers data.

        Conditional. You must specify only one destination configuration.

        If you change the delivery stream destination from an Amazon S3 destination to an Amazon ES destination, update requires [some interruptions](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-some-interrupt) .
        """
        return pulumi.get(self, "s3_destination_configuration")

    @property
    @pulumi.getter(name="snowflakeDestinationConfiguration")
    def snowflake_destination_configuration(self) -> pulumi.Output[Optional['outputs.DeliveryStreamSnowflakeDestinationConfiguration']]:
        """
        Configure Snowflake destination
        """
        return pulumi.get(self, "snowflake_destination_configuration")

    @property
    @pulumi.getter(name="splunkDestinationConfiguration")
    def splunk_destination_configuration(self) -> pulumi.Output[Optional['outputs.DeliveryStreamSplunkDestinationConfiguration']]:
        """
        The configuration of a destination in Splunk for the delivery stream.
        """
        return pulumi.get(self, "splunk_destination_configuration")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        A set of tags to assign to the delivery stream. A tag is a key-value pair that you can define and assign to AWS resources. Tags are metadata. For example, you can add friendly names and descriptions or other types of information that can help you distinguish the delivery stream. For more information about tags, see [Using Cost Allocation Tags](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html) in the AWS Billing and Cost Management User Guide.

        You can specify up to 50 tags when creating a delivery stream.

        If you specify tags in the `CreateDeliveryStream` action, Amazon Data Firehose performs an additional authorization on the `firehose:TagDeliveryStream` action to verify if users have permissions to create tags. If you do not provide this permission, requests to create new Firehose delivery streams with IAM resource tags will fail with an `AccessDeniedException` such as following.

        *AccessDeniedException*

        User: arn:aws:sts::x:assumed-role/x/x is not authorized to perform: firehose:TagDeliveryStream on resource: arn:aws:firehose:us-east-1:x:deliverystream/x with an explicit deny in an identity-based policy.

        For an example IAM policy, see [Tag example.](https://docs.aws.amazon.com/firehose/latest/APIReference/API_CreateDeliveryStream.html#API_CreateDeliveryStream_Examples)
        """
        return pulumi.get(self, "tags")

