# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs

__all__ = [
    'GetCustomPluginResult',
    'AwaitableGetCustomPluginResult',
    'get_custom_plugin',
    'get_custom_plugin_output',
]

@pulumi.output_type
class GetCustomPluginResult:
    def __init__(__self__, custom_plugin_arn=None, file_description=None, revision=None, tags=None):
        if custom_plugin_arn and not isinstance(custom_plugin_arn, str):
            raise TypeError("Expected argument 'custom_plugin_arn' to be a str")
        pulumi.set(__self__, "custom_plugin_arn", custom_plugin_arn)
        if file_description and not isinstance(file_description, dict):
            raise TypeError("Expected argument 'file_description' to be a dict")
        pulumi.set(__self__, "file_description", file_description)
        if revision and not isinstance(revision, int):
            raise TypeError("Expected argument 'revision' to be a int")
        pulumi.set(__self__, "revision", revision)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="customPluginArn")
    def custom_plugin_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the custom plugin to use.
        """
        return pulumi.get(self, "custom_plugin_arn")

    @property
    @pulumi.getter(name="fileDescription")
    def file_description(self) -> Optional['outputs.CustomPluginFileDescription']:
        return pulumi.get(self, "file_description")

    @property
    @pulumi.getter
    def revision(self) -> Optional[int]:
        """
        The revision of the custom plugin.
        """
        return pulumi.get(self, "revision")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")


class AwaitableGetCustomPluginResult(GetCustomPluginResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCustomPluginResult(
            custom_plugin_arn=self.custom_plugin_arn,
            file_description=self.file_description,
            revision=self.revision,
            tags=self.tags)


def get_custom_plugin(custom_plugin_arn: Optional[str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCustomPluginResult:
    """
    An example resource schema demonstrating some basic constructs and validation rules.


    :param str custom_plugin_arn: The Amazon Resource Name (ARN) of the custom plugin to use.
    """
    __args__ = dict()
    __args__['customPluginArn'] = custom_plugin_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:kafkaconnect:getCustomPlugin', __args__, opts=opts, typ=GetCustomPluginResult).value

    return AwaitableGetCustomPluginResult(
        custom_plugin_arn=pulumi.get(__ret__, 'custom_plugin_arn'),
        file_description=pulumi.get(__ret__, 'file_description'),
        revision=pulumi.get(__ret__, 'revision'),
        tags=pulumi.get(__ret__, 'tags'))
def get_custom_plugin_output(custom_plugin_arn: Optional[pulumi.Input[str]] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetCustomPluginResult]:
    """
    An example resource schema demonstrating some basic constructs and validation rules.


    :param str custom_plugin_arn: The Amazon Resource Name (ARN) of the custom plugin to use.
    """
    __args__ = dict()
    __args__['customPluginArn'] = custom_plugin_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:kafkaconnect:getCustomPlugin', __args__, opts=opts, typ=GetCustomPluginResult)
    return __ret__.apply(lambda __response__: GetCustomPluginResult(
        custom_plugin_arn=pulumi.get(__response__, 'custom_plugin_arn'),
        file_description=pulumi.get(__response__, 'file_description'),
        revision=pulumi.get(__response__, 'revision'),
        tags=pulumi.get(__response__, 'tags')))
