# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['RoomArgs', 'Room']

@pulumi.input_type
class RoomArgs:
    def __init__(__self__, *,
                 logging_configuration_identifiers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 maximum_message_length: Optional[pulumi.Input[int]] = None,
                 maximum_message_rate_per_second: Optional[pulumi.Input[int]] = None,
                 message_review_handler: Optional[pulumi.Input['RoomMessageReviewHandlerArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a Room resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] logging_configuration_identifiers: Array of logging configuration identifiers attached to the room.
        :param pulumi.Input[int] maximum_message_length: The maximum number of characters in a single message.
        :param pulumi.Input[int] maximum_message_rate_per_second: The maximum number of messages per second that can be sent to the room.
        :param pulumi.Input['RoomMessageReviewHandlerArgs'] message_review_handler: Configuration information for optional review of messages.
        :param pulumi.Input[str] name: The name of the room. The value does not need to be unique.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: An array of key-value pairs to apply to this resource.
        """
        if logging_configuration_identifiers is not None:
            pulumi.set(__self__, "logging_configuration_identifiers", logging_configuration_identifiers)
        if maximum_message_length is not None:
            pulumi.set(__self__, "maximum_message_length", maximum_message_length)
        if maximum_message_rate_per_second is not None:
            pulumi.set(__self__, "maximum_message_rate_per_second", maximum_message_rate_per_second)
        if message_review_handler is not None:
            pulumi.set(__self__, "message_review_handler", message_review_handler)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="loggingConfigurationIdentifiers")
    def logging_configuration_identifiers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Array of logging configuration identifiers attached to the room.
        """
        return pulumi.get(self, "logging_configuration_identifiers")

    @logging_configuration_identifiers.setter
    def logging_configuration_identifiers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "logging_configuration_identifiers", value)

    @property
    @pulumi.getter(name="maximumMessageLength")
    def maximum_message_length(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of characters in a single message.
        """
        return pulumi.get(self, "maximum_message_length")

    @maximum_message_length.setter
    def maximum_message_length(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "maximum_message_length", value)

    @property
    @pulumi.getter(name="maximumMessageRatePerSecond")
    def maximum_message_rate_per_second(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of messages per second that can be sent to the room.
        """
        return pulumi.get(self, "maximum_message_rate_per_second")

    @maximum_message_rate_per_second.setter
    def maximum_message_rate_per_second(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "maximum_message_rate_per_second", value)

    @property
    @pulumi.getter(name="messageReviewHandler")
    def message_review_handler(self) -> Optional[pulumi.Input['RoomMessageReviewHandlerArgs']]:
        """
        Configuration information for optional review of messages.
        """
        return pulumi.get(self, "message_review_handler")

    @message_review_handler.setter
    def message_review_handler(self, value: Optional[pulumi.Input['RoomMessageReviewHandlerArgs']]):
        pulumi.set(self, "message_review_handler", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the room. The value does not need to be unique.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


class Room(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 logging_configuration_identifiers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 maximum_message_length: Optional[pulumi.Input[int]] = None,
                 maximum_message_rate_per_second: Optional[pulumi.Input[int]] = None,
                 message_review_handler: Optional[pulumi.Input[Union['RoomMessageReviewHandlerArgs', 'RoomMessageReviewHandlerArgsDict']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        Resource type definition for AWS::IVSChat::Room.

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        room = aws_native.ivschat.Room("room",
            name="MyRoom",
            tags=[{
                "key": "MyKey",
                "value": "MyValue",
            }])
        pulumi.export("roomArn", room.id)
        pulumi.export("roomId", room.id)

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        room = aws_native.ivschat.Room("room",
            name="MyRoom",
            tags=[{
                "key": "MyKey",
                "value": "MyValue",
            }])
        pulumi.export("roomArn", room.id)
        pulumi.export("roomId", room.id)

        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] logging_configuration_identifiers: Array of logging configuration identifiers attached to the room.
        :param pulumi.Input[int] maximum_message_length: The maximum number of characters in a single message.
        :param pulumi.Input[int] maximum_message_rate_per_second: The maximum number of messages per second that can be sent to the room.
        :param pulumi.Input[Union['RoomMessageReviewHandlerArgs', 'RoomMessageReviewHandlerArgsDict']] message_review_handler: Configuration information for optional review of messages.
        :param pulumi.Input[str] name: The name of the room. The value does not need to be unique.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: An array of key-value pairs to apply to this resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[RoomArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource type definition for AWS::IVSChat::Room.

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        room = aws_native.ivschat.Room("room",
            name="MyRoom",
            tags=[{
                "key": "MyKey",
                "value": "MyValue",
            }])
        pulumi.export("roomArn", room.id)
        pulumi.export("roomId", room.id)

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        room = aws_native.ivschat.Room("room",
            name="MyRoom",
            tags=[{
                "key": "MyKey",
                "value": "MyValue",
            }])
        pulumi.export("roomArn", room.id)
        pulumi.export("roomId", room.id)

        ```

        :param str resource_name: The name of the resource.
        :param RoomArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RoomArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 logging_configuration_identifiers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 maximum_message_length: Optional[pulumi.Input[int]] = None,
                 maximum_message_rate_per_second: Optional[pulumi.Input[int]] = None,
                 message_review_handler: Optional[pulumi.Input[Union['RoomMessageReviewHandlerArgs', 'RoomMessageReviewHandlerArgsDict']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RoomArgs.__new__(RoomArgs)

            __props__.__dict__["logging_configuration_identifiers"] = logging_configuration_identifiers
            __props__.__dict__["maximum_message_length"] = maximum_message_length
            __props__.__dict__["maximum_message_rate_per_second"] = maximum_message_rate_per_second
            __props__.__dict__["message_review_handler"] = message_review_handler
            __props__.__dict__["name"] = name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["aws_id"] = None
        super(Room, __self__).__init__(
            'aws-native:ivschat:Room',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Room':
        """
        Get an existing Room resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = RoomArgs.__new__(RoomArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["aws_id"] = None
        __props__.__dict__["logging_configuration_identifiers"] = None
        __props__.__dict__["maximum_message_length"] = None
        __props__.__dict__["maximum_message_rate_per_second"] = None
        __props__.__dict__["message_review_handler"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["tags"] = None
        return Room(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        Room ARN is automatically generated on creation and assigned as the unique identifier.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="awsId")
    def aws_id(self) -> pulumi.Output[str]:
        """
        The system-generated ID of the room.
        """
        return pulumi.get(self, "aws_id")

    @property
    @pulumi.getter(name="loggingConfigurationIdentifiers")
    def logging_configuration_identifiers(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Array of logging configuration identifiers attached to the room.
        """
        return pulumi.get(self, "logging_configuration_identifiers")

    @property
    @pulumi.getter(name="maximumMessageLength")
    def maximum_message_length(self) -> pulumi.Output[Optional[int]]:
        """
        The maximum number of characters in a single message.
        """
        return pulumi.get(self, "maximum_message_length")

    @property
    @pulumi.getter(name="maximumMessageRatePerSecond")
    def maximum_message_rate_per_second(self) -> pulumi.Output[Optional[int]]:
        """
        The maximum number of messages per second that can be sent to the room.
        """
        return pulumi.get(self, "maximum_message_rate_per_second")

    @property
    @pulumi.getter(name="messageReviewHandler")
    def message_review_handler(self) -> pulumi.Output[Optional['outputs.RoomMessageReviewHandler']]:
        """
        Configuration information for optional review of messages.
        """
        return pulumi.get(self, "message_review_handler")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the room. The value does not need to be unique.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

