# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'LoggingConfigurationCloudWatchLogsDestinationConfigurationArgs',
    'LoggingConfigurationCloudWatchLogsDestinationConfigurationArgsDict',
    'LoggingConfigurationDestinationConfigurationArgs',
    'LoggingConfigurationDestinationConfigurationArgsDict',
    'LoggingConfigurationFirehoseDestinationConfigurationArgs',
    'LoggingConfigurationFirehoseDestinationConfigurationArgsDict',
    'LoggingConfigurationS3DestinationConfigurationArgs',
    'LoggingConfigurationS3DestinationConfigurationArgsDict',
    'RoomMessageReviewHandlerArgs',
    'RoomMessageReviewHandlerArgsDict',
]

MYPY = False

if not MYPY:
    class LoggingConfigurationCloudWatchLogsDestinationConfigurationArgsDict(TypedDict):
        """
        CloudWatch destination configuration for IVS Chat logging.
        """
        log_group_name: pulumi.Input[str]
        """
        Name of the Amazon CloudWatch Logs log group where chat activity will be logged.
        """
elif False:
    LoggingConfigurationCloudWatchLogsDestinationConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class LoggingConfigurationCloudWatchLogsDestinationConfigurationArgs:
    def __init__(__self__, *,
                 log_group_name: pulumi.Input[str]):
        """
        CloudWatch destination configuration for IVS Chat logging.
        :param pulumi.Input[str] log_group_name: Name of the Amazon CloudWatch Logs log group where chat activity will be logged.
        """
        pulumi.set(__self__, "log_group_name", log_group_name)

    @property
    @pulumi.getter(name="logGroupName")
    def log_group_name(self) -> pulumi.Input[str]:
        """
        Name of the Amazon CloudWatch Logs log group where chat activity will be logged.
        """
        return pulumi.get(self, "log_group_name")

    @log_group_name.setter
    def log_group_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "log_group_name", value)


if not MYPY:
    class LoggingConfigurationDestinationConfigurationArgsDict(TypedDict):
        """
        Destination configuration for IVS Chat logging.
        """
        cloud_watch_logs: NotRequired[pulumi.Input['LoggingConfigurationCloudWatchLogsDestinationConfigurationArgsDict']]
        """
        An Amazon CloudWatch Logs destination configuration where chat activity will be logged.
        """
        firehose: NotRequired[pulumi.Input['LoggingConfigurationFirehoseDestinationConfigurationArgsDict']]
        """
        An Amazon Kinesis Data Firehose destination configuration where chat activity will be logged.
        """
        s3: NotRequired[pulumi.Input['LoggingConfigurationS3DestinationConfigurationArgsDict']]
        """
        An Amazon S3 destination configuration where chat activity will be logged.
        """
elif False:
    LoggingConfigurationDestinationConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class LoggingConfigurationDestinationConfigurationArgs:
    def __init__(__self__, *,
                 cloud_watch_logs: Optional[pulumi.Input['LoggingConfigurationCloudWatchLogsDestinationConfigurationArgs']] = None,
                 firehose: Optional[pulumi.Input['LoggingConfigurationFirehoseDestinationConfigurationArgs']] = None,
                 s3: Optional[pulumi.Input['LoggingConfigurationS3DestinationConfigurationArgs']] = None):
        """
        Destination configuration for IVS Chat logging.
        :param pulumi.Input['LoggingConfigurationCloudWatchLogsDestinationConfigurationArgs'] cloud_watch_logs: An Amazon CloudWatch Logs destination configuration where chat activity will be logged.
        :param pulumi.Input['LoggingConfigurationFirehoseDestinationConfigurationArgs'] firehose: An Amazon Kinesis Data Firehose destination configuration where chat activity will be logged.
        :param pulumi.Input['LoggingConfigurationS3DestinationConfigurationArgs'] s3: An Amazon S3 destination configuration where chat activity will be logged.
        """
        if cloud_watch_logs is not None:
            pulumi.set(__self__, "cloud_watch_logs", cloud_watch_logs)
        if firehose is not None:
            pulumi.set(__self__, "firehose", firehose)
        if s3 is not None:
            pulumi.set(__self__, "s3", s3)

    @property
    @pulumi.getter(name="cloudWatchLogs")
    def cloud_watch_logs(self) -> Optional[pulumi.Input['LoggingConfigurationCloudWatchLogsDestinationConfigurationArgs']]:
        """
        An Amazon CloudWatch Logs destination configuration where chat activity will be logged.
        """
        return pulumi.get(self, "cloud_watch_logs")

    @cloud_watch_logs.setter
    def cloud_watch_logs(self, value: Optional[pulumi.Input['LoggingConfigurationCloudWatchLogsDestinationConfigurationArgs']]):
        pulumi.set(self, "cloud_watch_logs", value)

    @property
    @pulumi.getter
    def firehose(self) -> Optional[pulumi.Input['LoggingConfigurationFirehoseDestinationConfigurationArgs']]:
        """
        An Amazon Kinesis Data Firehose destination configuration where chat activity will be logged.
        """
        return pulumi.get(self, "firehose")

    @firehose.setter
    def firehose(self, value: Optional[pulumi.Input['LoggingConfigurationFirehoseDestinationConfigurationArgs']]):
        pulumi.set(self, "firehose", value)

    @property
    @pulumi.getter
    def s3(self) -> Optional[pulumi.Input['LoggingConfigurationS3DestinationConfigurationArgs']]:
        """
        An Amazon S3 destination configuration where chat activity will be logged.
        """
        return pulumi.get(self, "s3")

    @s3.setter
    def s3(self, value: Optional[pulumi.Input['LoggingConfigurationS3DestinationConfigurationArgs']]):
        pulumi.set(self, "s3", value)


if not MYPY:
    class LoggingConfigurationFirehoseDestinationConfigurationArgsDict(TypedDict):
        """
        Kinesis Firehose destination configuration for IVS Chat logging.
        """
        delivery_stream_name: pulumi.Input[str]
        """
        Name of the Amazon Kinesis Firehose delivery stream where chat activity will be logged.
        """
elif False:
    LoggingConfigurationFirehoseDestinationConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class LoggingConfigurationFirehoseDestinationConfigurationArgs:
    def __init__(__self__, *,
                 delivery_stream_name: pulumi.Input[str]):
        """
        Kinesis Firehose destination configuration for IVS Chat logging.
        :param pulumi.Input[str] delivery_stream_name: Name of the Amazon Kinesis Firehose delivery stream where chat activity will be logged.
        """
        pulumi.set(__self__, "delivery_stream_name", delivery_stream_name)

    @property
    @pulumi.getter(name="deliveryStreamName")
    def delivery_stream_name(self) -> pulumi.Input[str]:
        """
        Name of the Amazon Kinesis Firehose delivery stream where chat activity will be logged.
        """
        return pulumi.get(self, "delivery_stream_name")

    @delivery_stream_name.setter
    def delivery_stream_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "delivery_stream_name", value)


if not MYPY:
    class LoggingConfigurationS3DestinationConfigurationArgsDict(TypedDict):
        """
        S3 destination configuration for IVS Chat logging.
        """
        bucket_name: pulumi.Input[str]
        """
        Name of the Amazon S3 bucket where chat activity will be logged.
        """
elif False:
    LoggingConfigurationS3DestinationConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class LoggingConfigurationS3DestinationConfigurationArgs:
    def __init__(__self__, *,
                 bucket_name: pulumi.Input[str]):
        """
        S3 destination configuration for IVS Chat logging.
        :param pulumi.Input[str] bucket_name: Name of the Amazon S3 bucket where chat activity will be logged.
        """
        pulumi.set(__self__, "bucket_name", bucket_name)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> pulumi.Input[str]:
        """
        Name of the Amazon S3 bucket where chat activity will be logged.
        """
        return pulumi.get(self, "bucket_name")

    @bucket_name.setter
    def bucket_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "bucket_name", value)


if not MYPY:
    class RoomMessageReviewHandlerArgsDict(TypedDict):
        """
        Configuration information for optional review of messages.
        """
        fallback_result: NotRequired[pulumi.Input['RoomMessageReviewHandlerFallbackResult']]
        """
        Specifies the fallback behavior if the handler does not return a valid response, encounters an error, or times out.
        """
        uri: NotRequired[pulumi.Input[str]]
        """
        Identifier of the message review handler.
        """
elif False:
    RoomMessageReviewHandlerArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RoomMessageReviewHandlerArgs:
    def __init__(__self__, *,
                 fallback_result: Optional[pulumi.Input['RoomMessageReviewHandlerFallbackResult']] = None,
                 uri: Optional[pulumi.Input[str]] = None):
        """
        Configuration information for optional review of messages.
        :param pulumi.Input['RoomMessageReviewHandlerFallbackResult'] fallback_result: Specifies the fallback behavior if the handler does not return a valid response, encounters an error, or times out.
        :param pulumi.Input[str] uri: Identifier of the message review handler.
        """
        if fallback_result is not None:
            pulumi.set(__self__, "fallback_result", fallback_result)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter(name="fallbackResult")
    def fallback_result(self) -> Optional[pulumi.Input['RoomMessageReviewHandlerFallbackResult']]:
        """
        Specifies the fallback behavior if the handler does not return a valid response, encounters an error, or times out.
        """
        return pulumi.get(self, "fallback_result")

    @fallback_result.setter
    def fallback_result(self, value: Optional[pulumi.Input['RoomMessageReviewHandlerFallbackResult']]):
        pulumi.set(self, "fallback_result", value)

    @property
    @pulumi.getter
    def uri(self) -> Optional[pulumi.Input[str]]:
        """
        Identifier of the message review handler.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uri", value)


