# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'DeviceProfileLoRaWanDeviceProfile',
    'FuotaTaskLoRaWan',
    'MulticastGroupLoRaWan',
    'ServiceProfileLoRaWanServiceProfile',
    'TaskDefinitionLoRaWanGatewayVersion',
    'TaskDefinitionLoRaWanUpdateGatewayTaskCreate',
    'TaskDefinitionLoRaWanUpdateGatewayTaskEntry',
    'TaskDefinitionUpdateWirelessGatewayTaskCreate',
    'TraceContentProperties',
    'WirelessDeviceAbpV10x',
    'WirelessDeviceAbpV11',
    'WirelessDeviceLoRaWanDevice',
    'WirelessDeviceOtaaV10x',
    'WirelessDeviceOtaaV11',
    'WirelessDeviceSessionKeysAbpV10x',
    'WirelessDeviceSessionKeysAbpV11',
    'WirelessGatewayLoRaWanGateway',
]

@pulumi.output_type
class DeviceProfileLoRaWanDeviceProfile(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "classBTimeout":
            suggest = "class_b_timeout"
        elif key == "classCTimeout":
            suggest = "class_c_timeout"
        elif key == "factoryPresetFreqsList":
            suggest = "factory_preset_freqs_list"
        elif key == "macVersion":
            suggest = "mac_version"
        elif key == "maxDutyCycle":
            suggest = "max_duty_cycle"
        elif key == "maxEirp":
            suggest = "max_eirp"
        elif key == "pingSlotDr":
            suggest = "ping_slot_dr"
        elif key == "pingSlotFreq":
            suggest = "ping_slot_freq"
        elif key == "pingSlotPeriod":
            suggest = "ping_slot_period"
        elif key == "regParamsRevision":
            suggest = "reg_params_revision"
        elif key == "rfRegion":
            suggest = "rf_region"
        elif key == "rxDataRate2":
            suggest = "rx_data_rate2"
        elif key == "rxDelay1":
            suggest = "rx_delay1"
        elif key == "rxDrOffset1":
            suggest = "rx_dr_offset1"
        elif key == "rxFreq2":
            suggest = "rx_freq2"
        elif key == "supports32BitFCnt":
            suggest = "supports32_bit_f_cnt"
        elif key == "supportsClassB":
            suggest = "supports_class_b"
        elif key == "supportsClassC":
            suggest = "supports_class_c"
        elif key == "supportsJoin":
            suggest = "supports_join"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeviceProfileLoRaWanDeviceProfile. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeviceProfileLoRaWanDeviceProfile.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeviceProfileLoRaWanDeviceProfile.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 class_b_timeout: Optional[int] = None,
                 class_c_timeout: Optional[int] = None,
                 factory_preset_freqs_list: Optional[Sequence[int]] = None,
                 mac_version: Optional[str] = None,
                 max_duty_cycle: Optional[int] = None,
                 max_eirp: Optional[int] = None,
                 ping_slot_dr: Optional[int] = None,
                 ping_slot_freq: Optional[int] = None,
                 ping_slot_period: Optional[int] = None,
                 reg_params_revision: Optional[str] = None,
                 rf_region: Optional[str] = None,
                 rx_data_rate2: Optional[int] = None,
                 rx_delay1: Optional[int] = None,
                 rx_dr_offset1: Optional[int] = None,
                 rx_freq2: Optional[int] = None,
                 supports32_bit_f_cnt: Optional[bool] = None,
                 supports_class_b: Optional[bool] = None,
                 supports_class_c: Optional[bool] = None,
                 supports_join: Optional[bool] = None):
        """
        :param int class_b_timeout: The ClassBTimeout value.
        :param int class_c_timeout: The ClassCTimeout value.
        :param Sequence[int] factory_preset_freqs_list: The list of values that make up the FactoryPresetFreqs value. Valid range of values include a minimum value of 1000000 and a maximum value of 16700000.
        :param str mac_version: The MAC version (such as OTAA 1.1 or OTAA 1.0.3) to use with this device profile.
        :param int max_duty_cycle: The MaxDutyCycle value.
        :param int max_eirp: The MaxEIRP value.
        :param int ping_slot_dr: The PingSlotDR value.
        :param int ping_slot_freq: The PingSlotFreq value.
        :param int ping_slot_period: The PingSlotPeriod value.
        :param str reg_params_revision: The version of regional parameters.
        :param str rf_region: The frequency band (RFRegion) value.
        :param int rx_data_rate2: The RXDataRate2 value.
        :param int rx_delay1: The RXDelay1 value.
        :param int rx_dr_offset1: The RXDROffset1 value.
        :param int rx_freq2: The RXFreq2 value.
        :param bool supports32_bit_f_cnt: The Supports32BitFCnt value.
        :param bool supports_class_b: The SupportsClassB value.
        :param bool supports_class_c: The SupportsClassC value.
        :param bool supports_join: The SupportsJoin value.
        """
        if class_b_timeout is not None:
            pulumi.set(__self__, "class_b_timeout", class_b_timeout)
        if class_c_timeout is not None:
            pulumi.set(__self__, "class_c_timeout", class_c_timeout)
        if factory_preset_freqs_list is not None:
            pulumi.set(__self__, "factory_preset_freqs_list", factory_preset_freqs_list)
        if mac_version is not None:
            pulumi.set(__self__, "mac_version", mac_version)
        if max_duty_cycle is not None:
            pulumi.set(__self__, "max_duty_cycle", max_duty_cycle)
        if max_eirp is not None:
            pulumi.set(__self__, "max_eirp", max_eirp)
        if ping_slot_dr is not None:
            pulumi.set(__self__, "ping_slot_dr", ping_slot_dr)
        if ping_slot_freq is not None:
            pulumi.set(__self__, "ping_slot_freq", ping_slot_freq)
        if ping_slot_period is not None:
            pulumi.set(__self__, "ping_slot_period", ping_slot_period)
        if reg_params_revision is not None:
            pulumi.set(__self__, "reg_params_revision", reg_params_revision)
        if rf_region is not None:
            pulumi.set(__self__, "rf_region", rf_region)
        if rx_data_rate2 is not None:
            pulumi.set(__self__, "rx_data_rate2", rx_data_rate2)
        if rx_delay1 is not None:
            pulumi.set(__self__, "rx_delay1", rx_delay1)
        if rx_dr_offset1 is not None:
            pulumi.set(__self__, "rx_dr_offset1", rx_dr_offset1)
        if rx_freq2 is not None:
            pulumi.set(__self__, "rx_freq2", rx_freq2)
        if supports32_bit_f_cnt is not None:
            pulumi.set(__self__, "supports32_bit_f_cnt", supports32_bit_f_cnt)
        if supports_class_b is not None:
            pulumi.set(__self__, "supports_class_b", supports_class_b)
        if supports_class_c is not None:
            pulumi.set(__self__, "supports_class_c", supports_class_c)
        if supports_join is not None:
            pulumi.set(__self__, "supports_join", supports_join)

    @property
    @pulumi.getter(name="classBTimeout")
    def class_b_timeout(self) -> Optional[int]:
        """
        The ClassBTimeout value.
        """
        return pulumi.get(self, "class_b_timeout")

    @property
    @pulumi.getter(name="classCTimeout")
    def class_c_timeout(self) -> Optional[int]:
        """
        The ClassCTimeout value.
        """
        return pulumi.get(self, "class_c_timeout")

    @property
    @pulumi.getter(name="factoryPresetFreqsList")
    def factory_preset_freqs_list(self) -> Optional[Sequence[int]]:
        """
        The list of values that make up the FactoryPresetFreqs value. Valid range of values include a minimum value of 1000000 and a maximum value of 16700000.
        """
        return pulumi.get(self, "factory_preset_freqs_list")

    @property
    @pulumi.getter(name="macVersion")
    def mac_version(self) -> Optional[str]:
        """
        The MAC version (such as OTAA 1.1 or OTAA 1.0.3) to use with this device profile.
        """
        return pulumi.get(self, "mac_version")

    @property
    @pulumi.getter(name="maxDutyCycle")
    def max_duty_cycle(self) -> Optional[int]:
        """
        The MaxDutyCycle value.
        """
        return pulumi.get(self, "max_duty_cycle")

    @property
    @pulumi.getter(name="maxEirp")
    def max_eirp(self) -> Optional[int]:
        """
        The MaxEIRP value.
        """
        return pulumi.get(self, "max_eirp")

    @property
    @pulumi.getter(name="pingSlotDr")
    def ping_slot_dr(self) -> Optional[int]:
        """
        The PingSlotDR value.
        """
        return pulumi.get(self, "ping_slot_dr")

    @property
    @pulumi.getter(name="pingSlotFreq")
    def ping_slot_freq(self) -> Optional[int]:
        """
        The PingSlotFreq value.
        """
        return pulumi.get(self, "ping_slot_freq")

    @property
    @pulumi.getter(name="pingSlotPeriod")
    def ping_slot_period(self) -> Optional[int]:
        """
        The PingSlotPeriod value.
        """
        return pulumi.get(self, "ping_slot_period")

    @property
    @pulumi.getter(name="regParamsRevision")
    def reg_params_revision(self) -> Optional[str]:
        """
        The version of regional parameters.
        """
        return pulumi.get(self, "reg_params_revision")

    @property
    @pulumi.getter(name="rfRegion")
    def rf_region(self) -> Optional[str]:
        """
        The frequency band (RFRegion) value.
        """
        return pulumi.get(self, "rf_region")

    @property
    @pulumi.getter(name="rxDataRate2")
    def rx_data_rate2(self) -> Optional[int]:
        """
        The RXDataRate2 value.
        """
        return pulumi.get(self, "rx_data_rate2")

    @property
    @pulumi.getter(name="rxDelay1")
    def rx_delay1(self) -> Optional[int]:
        """
        The RXDelay1 value.
        """
        return pulumi.get(self, "rx_delay1")

    @property
    @pulumi.getter(name="rxDrOffset1")
    def rx_dr_offset1(self) -> Optional[int]:
        """
        The RXDROffset1 value.
        """
        return pulumi.get(self, "rx_dr_offset1")

    @property
    @pulumi.getter(name="rxFreq2")
    def rx_freq2(self) -> Optional[int]:
        """
        The RXFreq2 value.
        """
        return pulumi.get(self, "rx_freq2")

    @property
    @pulumi.getter(name="supports32BitFCnt")
    def supports32_bit_f_cnt(self) -> Optional[bool]:
        """
        The Supports32BitFCnt value.
        """
        return pulumi.get(self, "supports32_bit_f_cnt")

    @property
    @pulumi.getter(name="supportsClassB")
    def supports_class_b(self) -> Optional[bool]:
        """
        The SupportsClassB value.
        """
        return pulumi.get(self, "supports_class_b")

    @property
    @pulumi.getter(name="supportsClassC")
    def supports_class_c(self) -> Optional[bool]:
        """
        The SupportsClassC value.
        """
        return pulumi.get(self, "supports_class_c")

    @property
    @pulumi.getter(name="supportsJoin")
    def supports_join(self) -> Optional[bool]:
        """
        The SupportsJoin value.
        """
        return pulumi.get(self, "supports_join")


@pulumi.output_type
class FuotaTaskLoRaWan(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "rfRegion":
            suggest = "rf_region"
        elif key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FuotaTaskLoRaWan. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FuotaTaskLoRaWan.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FuotaTaskLoRaWan.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 rf_region: str,
                 start_time: Optional[str] = None):
        """
        :param str rf_region: FUOTA task LoRaWAN RF region
        :param str start_time: FUOTA task LoRaWAN start time
        """
        pulumi.set(__self__, "rf_region", rf_region)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="rfRegion")
    def rf_region(self) -> str:
        """
        FUOTA task LoRaWAN RF region
        """
        return pulumi.get(self, "rf_region")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[str]:
        """
        FUOTA task LoRaWAN start time
        """
        return pulumi.get(self, "start_time")


@pulumi.output_type
class MulticastGroupLoRaWan(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dlClass":
            suggest = "dl_class"
        elif key == "rfRegion":
            suggest = "rf_region"
        elif key == "numberOfDevicesInGroup":
            suggest = "number_of_devices_in_group"
        elif key == "numberOfDevicesRequested":
            suggest = "number_of_devices_requested"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MulticastGroupLoRaWan. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MulticastGroupLoRaWan.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MulticastGroupLoRaWan.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dl_class: str,
                 rf_region: str,
                 number_of_devices_in_group: Optional[int] = None,
                 number_of_devices_requested: Optional[int] = None):
        """
        :param str dl_class: Multicast group LoRaWAN DL Class
        :param str rf_region: Multicast group LoRaWAN RF region
        :param int number_of_devices_in_group: Multicast group number of devices in group. Returned after successful read.
        :param int number_of_devices_requested: Multicast group number of devices requested. Returned after successful read.
        """
        pulumi.set(__self__, "dl_class", dl_class)
        pulumi.set(__self__, "rf_region", rf_region)
        if number_of_devices_in_group is not None:
            pulumi.set(__self__, "number_of_devices_in_group", number_of_devices_in_group)
        if number_of_devices_requested is not None:
            pulumi.set(__self__, "number_of_devices_requested", number_of_devices_requested)

    @property
    @pulumi.getter(name="dlClass")
    def dl_class(self) -> str:
        """
        Multicast group LoRaWAN DL Class
        """
        return pulumi.get(self, "dl_class")

    @property
    @pulumi.getter(name="rfRegion")
    def rf_region(self) -> str:
        """
        Multicast group LoRaWAN RF region
        """
        return pulumi.get(self, "rf_region")

    @property
    @pulumi.getter(name="numberOfDevicesInGroup")
    def number_of_devices_in_group(self) -> Optional[int]:
        """
        Multicast group number of devices in group. Returned after successful read.
        """
        return pulumi.get(self, "number_of_devices_in_group")

    @property
    @pulumi.getter(name="numberOfDevicesRequested")
    def number_of_devices_requested(self) -> Optional[int]:
        """
        Multicast group number of devices requested. Returned after successful read.
        """
        return pulumi.get(self, "number_of_devices_requested")


@pulumi.output_type
class ServiceProfileLoRaWanServiceProfile(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "addGwMetadata":
            suggest = "add_gw_metadata"
        elif key == "channelMask":
            suggest = "channel_mask"
        elif key == "devStatusReqFreq":
            suggest = "dev_status_req_freq"
        elif key == "dlBucketSize":
            suggest = "dl_bucket_size"
        elif key == "dlRate":
            suggest = "dl_rate"
        elif key == "dlRatePolicy":
            suggest = "dl_rate_policy"
        elif key == "drMax":
            suggest = "dr_max"
        elif key == "drMin":
            suggest = "dr_min"
        elif key == "hrAllowed":
            suggest = "hr_allowed"
        elif key == "minGwDiversity":
            suggest = "min_gw_diversity"
        elif key == "nwkGeoLoc":
            suggest = "nwk_geo_loc"
        elif key == "prAllowed":
            suggest = "pr_allowed"
        elif key == "raAllowed":
            suggest = "ra_allowed"
        elif key == "reportDevStatusBattery":
            suggest = "report_dev_status_battery"
        elif key == "reportDevStatusMargin":
            suggest = "report_dev_status_margin"
        elif key == "targetPer":
            suggest = "target_per"
        elif key == "ulBucketSize":
            suggest = "ul_bucket_size"
        elif key == "ulRate":
            suggest = "ul_rate"
        elif key == "ulRatePolicy":
            suggest = "ul_rate_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceProfileLoRaWanServiceProfile. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceProfileLoRaWanServiceProfile.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceProfileLoRaWanServiceProfile.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 add_gw_metadata: Optional[bool] = None,
                 channel_mask: Optional[str] = None,
                 dev_status_req_freq: Optional[int] = None,
                 dl_bucket_size: Optional[int] = None,
                 dl_rate: Optional[int] = None,
                 dl_rate_policy: Optional[str] = None,
                 dr_max: Optional[int] = None,
                 dr_min: Optional[int] = None,
                 hr_allowed: Optional[bool] = None,
                 min_gw_diversity: Optional[int] = None,
                 nwk_geo_loc: Optional[bool] = None,
                 pr_allowed: Optional[bool] = None,
                 ra_allowed: Optional[bool] = None,
                 report_dev_status_battery: Optional[bool] = None,
                 report_dev_status_margin: Optional[bool] = None,
                 target_per: Optional[int] = None,
                 ul_bucket_size: Optional[int] = None,
                 ul_rate: Optional[int] = None,
                 ul_rate_policy: Optional[str] = None):
        """
        :param bool add_gw_metadata: The AddGWMetaData value.
        :param str channel_mask: The ChannelMask value.
               
               This property is `ReadOnly` and can't be inputted for create. It's returned with `Fn::GetAtt`
        :param int dev_status_req_freq: The DevStatusReqFreq value.
               
               This property is `ReadOnly` and can't be inputted for create. It's returned with `Fn::GetAtt`
        :param int dl_bucket_size: The DLBucketSize value.
               
               This property is `ReadOnly` and can't be inputted for create. It's returned with `Fn::GetAtt`
        :param int dl_rate: The DLRate value.
               
               This property is `ReadOnly` and can't be inputted for create. It's returned with `Fn::GetAtt`
        :param str dl_rate_policy: The DLRatePolicy value.
               
               This property is `ReadOnly` and can't be inputted for create. It's returned with `Fn::GetAtt`
        :param int dr_max: The DRMax value.
               
               This property is `ReadOnly` and can't be inputted for create. It's returned with `Fn::GetAtt`
        :param int dr_min: The DRMin value.
               
               This property is `ReadOnly` and can't be inputted for create. It's returned with `Fn::GetAtt`
        :param bool hr_allowed: The HRAllowed value that describes whether handover roaming is allowed.
               
               This property is `ReadOnly` and can't be inputted for create. It's returned with `Fn::GetAtt`
        :param int min_gw_diversity: The MinGwDiversity value.
               
               This property is `ReadOnly` and can't be inputted for create. It's returned with `Fn::GetAtt`
        :param bool nwk_geo_loc: The NwkGeoLoc value.
               
               This property is `ReadOnly` and can't be inputted for create. It's returned with `Fn::GetAtt`
        :param bool pr_allowed: The PRAllowed value that describes whether passive roaming is allowed.
               
               This property is `ReadOnly` and can't be inputted for create. It's returned with `Fn::GetAtt`
        :param bool ra_allowed: The RAAllowed value that describes whether roaming activation is allowed.
        :param bool report_dev_status_battery: The ReportDevStatusBattery value.
               
               This property is `ReadOnly` and can't be inputted for create. It's returned with `Fn::GetAtt`
        :param bool report_dev_status_margin: The ReportDevStatusMargin value.
               
               This property is `ReadOnly` and can't be inputted for create. It's returned with `Fn::GetAtt`
        :param int target_per: The TargetPer value.
               
               This property is `ReadOnly` and can't be inputted for create. It's returned with `Fn::GetAtt`
        :param int ul_bucket_size: The UlBucketSize value.
               
               This property is `ReadOnly` and can't be inputted for create. It's returned with `Fn::GetAtt`
        :param int ul_rate: The ULRate value.
               
               This property is `ReadOnly` and can't be inputted for create. It's returned with `Fn::GetAtt`
        :param str ul_rate_policy: The ULRatePolicy value.
               
               This property is `ReadOnly` and can't be inputted for create. It's returned with `Fn::GetAtt`
        """
        if add_gw_metadata is not None:
            pulumi.set(__self__, "add_gw_metadata", add_gw_metadata)
        if channel_mask is not None:
            pulumi.set(__self__, "channel_mask", channel_mask)
        if dev_status_req_freq is not None:
            pulumi.set(__self__, "dev_status_req_freq", dev_status_req_freq)
        if dl_bucket_size is not None:
            pulumi.set(__self__, "dl_bucket_size", dl_bucket_size)
        if dl_rate is not None:
            pulumi.set(__self__, "dl_rate", dl_rate)
        if dl_rate_policy is not None:
            pulumi.set(__self__, "dl_rate_policy", dl_rate_policy)
        if dr_max is not None:
            pulumi.set(__self__, "dr_max", dr_max)
        if dr_min is not None:
            pulumi.set(__self__, "dr_min", dr_min)
        if hr_allowed is not None:
            pulumi.set(__self__, "hr_allowed", hr_allowed)
        if min_gw_diversity is not None:
            pulumi.set(__self__, "min_gw_diversity", min_gw_diversity)
        if nwk_geo_loc is not None:
            pulumi.set(__self__, "nwk_geo_loc", nwk_geo_loc)
        if pr_allowed is not None:
            pulumi.set(__self__, "pr_allowed", pr_allowed)
        if ra_allowed is not None:
            pulumi.set(__self__, "ra_allowed", ra_allowed)
        if report_dev_status_battery is not None:
            pulumi.set(__self__, "report_dev_status_battery", report_dev_status_battery)
        if report_dev_status_margin is not None:
            pulumi.set(__self__, "report_dev_status_margin", report_dev_status_margin)
        if target_per is not None:
            pulumi.set(__self__, "target_per", target_per)
        if ul_bucket_size is not None:
            pulumi.set(__self__, "ul_bucket_size", ul_bucket_size)
        if ul_rate is not None:
            pulumi.set(__self__, "ul_rate", ul_rate)
        if ul_rate_policy is not None:
            pulumi.set(__self__, "ul_rate_policy", ul_rate_policy)

    @property
    @pulumi.getter(name="addGwMetadata")
    def add_gw_metadata(self) -> Optional[bool]:
        """
        The AddGWMetaData value.
        """
        return pulumi.get(self, "add_gw_metadata")

    @property
    @pulumi.getter(name="channelMask")
    def channel_mask(self) -> Optional[str]:
        """
        The ChannelMask value.

        This property is `ReadOnly` and can't be inputted for create. It's returned with `Fn::GetAtt`
        """
        return pulumi.get(self, "channel_mask")

    @property
    @pulumi.getter(name="devStatusReqFreq")
    def dev_status_req_freq(self) -> Optional[int]:
        """
        The DevStatusReqFreq value.

        This property is `ReadOnly` and can't be inputted for create. It's returned with `Fn::GetAtt`
        """
        return pulumi.get(self, "dev_status_req_freq")

    @property
    @pulumi.getter(name="dlBucketSize")
    def dl_bucket_size(self) -> Optional[int]:
        """
        The DLBucketSize value.

        This property is `ReadOnly` and can't be inputted for create. It's returned with `Fn::GetAtt`
        """
        return pulumi.get(self, "dl_bucket_size")

    @property
    @pulumi.getter(name="dlRate")
    def dl_rate(self) -> Optional[int]:
        """
        The DLRate value.

        This property is `ReadOnly` and can't be inputted for create. It's returned with `Fn::GetAtt`
        """
        return pulumi.get(self, "dl_rate")

    @property
    @pulumi.getter(name="dlRatePolicy")
    def dl_rate_policy(self) -> Optional[str]:
        """
        The DLRatePolicy value.

        This property is `ReadOnly` and can't be inputted for create. It's returned with `Fn::GetAtt`
        """
        return pulumi.get(self, "dl_rate_policy")

    @property
    @pulumi.getter(name="drMax")
    def dr_max(self) -> Optional[int]:
        """
        The DRMax value.

        This property is `ReadOnly` and can't be inputted for create. It's returned with `Fn::GetAtt`
        """
        return pulumi.get(self, "dr_max")

    @property
    @pulumi.getter(name="drMin")
    def dr_min(self) -> Optional[int]:
        """
        The DRMin value.

        This property is `ReadOnly` and can't be inputted for create. It's returned with `Fn::GetAtt`
        """
        return pulumi.get(self, "dr_min")

    @property
    @pulumi.getter(name="hrAllowed")
    def hr_allowed(self) -> Optional[bool]:
        """
        The HRAllowed value that describes whether handover roaming is allowed.

        This property is `ReadOnly` and can't be inputted for create. It's returned with `Fn::GetAtt`
        """
        return pulumi.get(self, "hr_allowed")

    @property
    @pulumi.getter(name="minGwDiversity")
    def min_gw_diversity(self) -> Optional[int]:
        """
        The MinGwDiversity value.

        This property is `ReadOnly` and can't be inputted for create. It's returned with `Fn::GetAtt`
        """
        return pulumi.get(self, "min_gw_diversity")

    @property
    @pulumi.getter(name="nwkGeoLoc")
    def nwk_geo_loc(self) -> Optional[bool]:
        """
        The NwkGeoLoc value.

        This property is `ReadOnly` and can't be inputted for create. It's returned with `Fn::GetAtt`
        """
        return pulumi.get(self, "nwk_geo_loc")

    @property
    @pulumi.getter(name="prAllowed")
    def pr_allowed(self) -> Optional[bool]:
        """
        The PRAllowed value that describes whether passive roaming is allowed.

        This property is `ReadOnly` and can't be inputted for create. It's returned with `Fn::GetAtt`
        """
        return pulumi.get(self, "pr_allowed")

    @property
    @pulumi.getter(name="raAllowed")
    def ra_allowed(self) -> Optional[bool]:
        """
        The RAAllowed value that describes whether roaming activation is allowed.
        """
        return pulumi.get(self, "ra_allowed")

    @property
    @pulumi.getter(name="reportDevStatusBattery")
    def report_dev_status_battery(self) -> Optional[bool]:
        """
        The ReportDevStatusBattery value.

        This property is `ReadOnly` and can't be inputted for create. It's returned with `Fn::GetAtt`
        """
        return pulumi.get(self, "report_dev_status_battery")

    @property
    @pulumi.getter(name="reportDevStatusMargin")
    def report_dev_status_margin(self) -> Optional[bool]:
        """
        The ReportDevStatusMargin value.

        This property is `ReadOnly` and can't be inputted for create. It's returned with `Fn::GetAtt`
        """
        return pulumi.get(self, "report_dev_status_margin")

    @property
    @pulumi.getter(name="targetPer")
    def target_per(self) -> Optional[int]:
        """
        The TargetPer value.

        This property is `ReadOnly` and can't be inputted for create. It's returned with `Fn::GetAtt`
        """
        return pulumi.get(self, "target_per")

    @property
    @pulumi.getter(name="ulBucketSize")
    def ul_bucket_size(self) -> Optional[int]:
        """
        The UlBucketSize value.

        This property is `ReadOnly` and can't be inputted for create. It's returned with `Fn::GetAtt`
        """
        return pulumi.get(self, "ul_bucket_size")

    @property
    @pulumi.getter(name="ulRate")
    def ul_rate(self) -> Optional[int]:
        """
        The ULRate value.

        This property is `ReadOnly` and can't be inputted for create. It's returned with `Fn::GetAtt`
        """
        return pulumi.get(self, "ul_rate")

    @property
    @pulumi.getter(name="ulRatePolicy")
    def ul_rate_policy(self) -> Optional[str]:
        """
        The ULRatePolicy value.

        This property is `ReadOnly` and can't be inputted for create. It's returned with `Fn::GetAtt`
        """
        return pulumi.get(self, "ul_rate_policy")


@pulumi.output_type
class TaskDefinitionLoRaWanGatewayVersion(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "packageVersion":
            suggest = "package_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskDefinitionLoRaWanGatewayVersion. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskDefinitionLoRaWanGatewayVersion.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskDefinitionLoRaWanGatewayVersion.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 model: Optional[str] = None,
                 package_version: Optional[str] = None,
                 station: Optional[str] = None):
        """
        :param str model: The model number of the wireless gateway.
        :param str package_version: The version of the wireless gateway firmware.
        :param str station: The basic station version of the wireless gateway.
        """
        if model is not None:
            pulumi.set(__self__, "model", model)
        if package_version is not None:
            pulumi.set(__self__, "package_version", package_version)
        if station is not None:
            pulumi.set(__self__, "station", station)

    @property
    @pulumi.getter
    def model(self) -> Optional[str]:
        """
        The model number of the wireless gateway.
        """
        return pulumi.get(self, "model")

    @property
    @pulumi.getter(name="packageVersion")
    def package_version(self) -> Optional[str]:
        """
        The version of the wireless gateway firmware.
        """
        return pulumi.get(self, "package_version")

    @property
    @pulumi.getter
    def station(self) -> Optional[str]:
        """
        The basic station version of the wireless gateway.
        """
        return pulumi.get(self, "station")


@pulumi.output_type
class TaskDefinitionLoRaWanUpdateGatewayTaskCreate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "currentVersion":
            suggest = "current_version"
        elif key == "sigKeyCrc":
            suggest = "sig_key_crc"
        elif key == "updateSignature":
            suggest = "update_signature"
        elif key == "updateVersion":
            suggest = "update_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskDefinitionLoRaWanUpdateGatewayTaskCreate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskDefinitionLoRaWanUpdateGatewayTaskCreate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskDefinitionLoRaWanUpdateGatewayTaskCreate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 current_version: Optional['outputs.TaskDefinitionLoRaWanGatewayVersion'] = None,
                 sig_key_crc: Optional[int] = None,
                 update_signature: Optional[str] = None,
                 update_version: Optional['outputs.TaskDefinitionLoRaWanGatewayVersion'] = None):
        """
        :param 'TaskDefinitionLoRaWanGatewayVersion' current_version: The version of the gateways that should receive the update.
        :param int sig_key_crc: The CRC of the signature private key to check.
        :param str update_signature: The signature used to verify the update firmware.
        :param 'TaskDefinitionLoRaWanGatewayVersion' update_version: The firmware version to update the gateway to.
        """
        if current_version is not None:
            pulumi.set(__self__, "current_version", current_version)
        if sig_key_crc is not None:
            pulumi.set(__self__, "sig_key_crc", sig_key_crc)
        if update_signature is not None:
            pulumi.set(__self__, "update_signature", update_signature)
        if update_version is not None:
            pulumi.set(__self__, "update_version", update_version)

    @property
    @pulumi.getter(name="currentVersion")
    def current_version(self) -> Optional['outputs.TaskDefinitionLoRaWanGatewayVersion']:
        """
        The version of the gateways that should receive the update.
        """
        return pulumi.get(self, "current_version")

    @property
    @pulumi.getter(name="sigKeyCrc")
    def sig_key_crc(self) -> Optional[int]:
        """
        The CRC of the signature private key to check.
        """
        return pulumi.get(self, "sig_key_crc")

    @property
    @pulumi.getter(name="updateSignature")
    def update_signature(self) -> Optional[str]:
        """
        The signature used to verify the update firmware.
        """
        return pulumi.get(self, "update_signature")

    @property
    @pulumi.getter(name="updateVersion")
    def update_version(self) -> Optional['outputs.TaskDefinitionLoRaWanGatewayVersion']:
        """
        The firmware version to update the gateway to.
        """
        return pulumi.get(self, "update_version")


@pulumi.output_type
class TaskDefinitionLoRaWanUpdateGatewayTaskEntry(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "currentVersion":
            suggest = "current_version"
        elif key == "updateVersion":
            suggest = "update_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskDefinitionLoRaWanUpdateGatewayTaskEntry. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskDefinitionLoRaWanUpdateGatewayTaskEntry.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskDefinitionLoRaWanUpdateGatewayTaskEntry.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 current_version: Optional['outputs.TaskDefinitionLoRaWanGatewayVersion'] = None,
                 update_version: Optional['outputs.TaskDefinitionLoRaWanGatewayVersion'] = None):
        """
        :param 'TaskDefinitionLoRaWanGatewayVersion' current_version: The version of the gateways that should receive the update.
        :param 'TaskDefinitionLoRaWanGatewayVersion' update_version: The firmware version to update the gateway to.
        """
        if current_version is not None:
            pulumi.set(__self__, "current_version", current_version)
        if update_version is not None:
            pulumi.set(__self__, "update_version", update_version)

    @property
    @pulumi.getter(name="currentVersion")
    def current_version(self) -> Optional['outputs.TaskDefinitionLoRaWanGatewayVersion']:
        """
        The version of the gateways that should receive the update.
        """
        return pulumi.get(self, "current_version")

    @property
    @pulumi.getter(name="updateVersion")
    def update_version(self) -> Optional['outputs.TaskDefinitionLoRaWanGatewayVersion']:
        """
        The firmware version to update the gateway to.
        """
        return pulumi.get(self, "update_version")


@pulumi.output_type
class TaskDefinitionUpdateWirelessGatewayTaskCreate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "loRaWan":
            suggest = "lo_ra_wan"
        elif key == "updateDataRole":
            suggest = "update_data_role"
        elif key == "updateDataSource":
            suggest = "update_data_source"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskDefinitionUpdateWirelessGatewayTaskCreate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskDefinitionUpdateWirelessGatewayTaskCreate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskDefinitionUpdateWirelessGatewayTaskCreate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 lo_ra_wan: Optional['outputs.TaskDefinitionLoRaWanUpdateGatewayTaskCreate'] = None,
                 update_data_role: Optional[str] = None,
                 update_data_source: Optional[str] = None):
        """
        :param 'TaskDefinitionLoRaWanUpdateGatewayTaskCreate' lo_ra_wan: The properties that relate to the LoRaWAN wireless gateway.
        :param str update_data_role: The IAM role used to read data from the S3 bucket.
        :param str update_data_source: The link to the S3 bucket.
        """
        if lo_ra_wan is not None:
            pulumi.set(__self__, "lo_ra_wan", lo_ra_wan)
        if update_data_role is not None:
            pulumi.set(__self__, "update_data_role", update_data_role)
        if update_data_source is not None:
            pulumi.set(__self__, "update_data_source", update_data_source)

    @property
    @pulumi.getter(name="loRaWan")
    def lo_ra_wan(self) -> Optional['outputs.TaskDefinitionLoRaWanUpdateGatewayTaskCreate']:
        """
        The properties that relate to the LoRaWAN wireless gateway.
        """
        return pulumi.get(self, "lo_ra_wan")

    @property
    @pulumi.getter(name="updateDataRole")
    def update_data_role(self) -> Optional[str]:
        """
        The IAM role used to read data from the S3 bucket.
        """
        return pulumi.get(self, "update_data_role")

    @property
    @pulumi.getter(name="updateDataSource")
    def update_data_source(self) -> Optional[str]:
        """
        The link to the S3 bucket.
        """
        return pulumi.get(self, "update_data_source")


@pulumi.output_type
class TraceContentProperties(dict):
    """
    Trace content for your wireless gateway and wireless device resources
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logLevel":
            suggest = "log_level"
        elif key == "wirelessDeviceFrameInfo":
            suggest = "wireless_device_frame_info"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TraceContentProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TraceContentProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TraceContentProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 log_level: Optional['NetworkAnalyzerConfigurationLogLevel'] = None,
                 wireless_device_frame_info: Optional['NetworkAnalyzerConfigurationWirelessDeviceFrameInfo'] = None):
        """
        Trace content for your wireless gateway and wireless device resources
        :param 'NetworkAnalyzerConfigurationLogLevel' log_level: The log level for a log message. The log levels can be disabled, or set to `ERROR` to display less verbose logs containing only error information, or to `INFO` for more detailed logs
        :param 'NetworkAnalyzerConfigurationWirelessDeviceFrameInfo' wireless_device_frame_info: `FrameInfo` of your wireless device resources for the trace content. Use FrameInfo to debug the communication between your LoRaWAN end devices and the network server.
        """
        if log_level is not None:
            pulumi.set(__self__, "log_level", log_level)
        if wireless_device_frame_info is not None:
            pulumi.set(__self__, "wireless_device_frame_info", wireless_device_frame_info)

    @property
    @pulumi.getter(name="logLevel")
    def log_level(self) -> Optional['NetworkAnalyzerConfigurationLogLevel']:
        """
        The log level for a log message. The log levels can be disabled, or set to `ERROR` to display less verbose logs containing only error information, or to `INFO` for more detailed logs
        """
        return pulumi.get(self, "log_level")

    @property
    @pulumi.getter(name="wirelessDeviceFrameInfo")
    def wireless_device_frame_info(self) -> Optional['NetworkAnalyzerConfigurationWirelessDeviceFrameInfo']:
        """
        `FrameInfo` of your wireless device resources for the trace content. Use FrameInfo to debug the communication between your LoRaWAN end devices and the network server.
        """
        return pulumi.get(self, "wireless_device_frame_info")


@pulumi.output_type
class WirelessDeviceAbpV10x(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "devAddr":
            suggest = "dev_addr"
        elif key == "sessionKeys":
            suggest = "session_keys"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WirelessDeviceAbpV10x. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WirelessDeviceAbpV10x.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WirelessDeviceAbpV10x.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dev_addr: str,
                 session_keys: 'outputs.WirelessDeviceSessionKeysAbpV10x'):
        """
        :param str dev_addr: The DevAddr value.
        :param 'WirelessDeviceSessionKeysAbpV10x' session_keys: Session keys for ABP v1.0.x.
        """
        pulumi.set(__self__, "dev_addr", dev_addr)
        pulumi.set(__self__, "session_keys", session_keys)

    @property
    @pulumi.getter(name="devAddr")
    def dev_addr(self) -> str:
        """
        The DevAddr value.
        """
        return pulumi.get(self, "dev_addr")

    @property
    @pulumi.getter(name="sessionKeys")
    def session_keys(self) -> 'outputs.WirelessDeviceSessionKeysAbpV10x':
        """
        Session keys for ABP v1.0.x.
        """
        return pulumi.get(self, "session_keys")


@pulumi.output_type
class WirelessDeviceAbpV11(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "devAddr":
            suggest = "dev_addr"
        elif key == "sessionKeys":
            suggest = "session_keys"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WirelessDeviceAbpV11. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WirelessDeviceAbpV11.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WirelessDeviceAbpV11.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dev_addr: str,
                 session_keys: 'outputs.WirelessDeviceSessionKeysAbpV11'):
        """
        :param str dev_addr: The DevAddr value.
        :param 'WirelessDeviceSessionKeysAbpV11' session_keys: Session keys for ABP v1.1.
        """
        pulumi.set(__self__, "dev_addr", dev_addr)
        pulumi.set(__self__, "session_keys", session_keys)

    @property
    @pulumi.getter(name="devAddr")
    def dev_addr(self) -> str:
        """
        The DevAddr value.
        """
        return pulumi.get(self, "dev_addr")

    @property
    @pulumi.getter(name="sessionKeys")
    def session_keys(self) -> 'outputs.WirelessDeviceSessionKeysAbpV11':
        """
        Session keys for ABP v1.1.
        """
        return pulumi.get(self, "session_keys")


@pulumi.output_type
class WirelessDeviceLoRaWanDevice(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "abpV10x":
            suggest = "abp_v10x"
        elif key == "abpV11":
            suggest = "abp_v11"
        elif key == "devEui":
            suggest = "dev_eui"
        elif key == "deviceProfileId":
            suggest = "device_profile_id"
        elif key == "otaaV10x":
            suggest = "otaa_v10x"
        elif key == "otaaV11":
            suggest = "otaa_v11"
        elif key == "serviceProfileId":
            suggest = "service_profile_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WirelessDeviceLoRaWanDevice. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WirelessDeviceLoRaWanDevice.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WirelessDeviceLoRaWanDevice.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 abp_v10x: Optional['outputs.WirelessDeviceAbpV10x'] = None,
                 abp_v11: Optional['outputs.WirelessDeviceAbpV11'] = None,
                 dev_eui: Optional[str] = None,
                 device_profile_id: Optional[str] = None,
                 otaa_v10x: Optional['outputs.WirelessDeviceOtaaV10x'] = None,
                 otaa_v11: Optional['outputs.WirelessDeviceOtaaV11'] = None,
                 service_profile_id: Optional[str] = None):
        """
        :param 'WirelessDeviceAbpV10x' abp_v10x: ABP device object for LoRaWAN specification v1.0.x.
        :param 'WirelessDeviceAbpV11' abp_v11: ABP device object for create APIs for v1.1.
        :param str dev_eui: The DevEUI value.
        :param str device_profile_id: The ID of the device profile for the new wireless device.
        :param 'WirelessDeviceOtaaV10x' otaa_v10x: OTAA device object for create APIs for v1.0.x
        :param 'WirelessDeviceOtaaV11' otaa_v11: OTAA device object for v1.1 for create APIs.
        :param str service_profile_id: The ID of the service profile.
        """
        if abp_v10x is not None:
            pulumi.set(__self__, "abp_v10x", abp_v10x)
        if abp_v11 is not None:
            pulumi.set(__self__, "abp_v11", abp_v11)
        if dev_eui is not None:
            pulumi.set(__self__, "dev_eui", dev_eui)
        if device_profile_id is not None:
            pulumi.set(__self__, "device_profile_id", device_profile_id)
        if otaa_v10x is not None:
            pulumi.set(__self__, "otaa_v10x", otaa_v10x)
        if otaa_v11 is not None:
            pulumi.set(__self__, "otaa_v11", otaa_v11)
        if service_profile_id is not None:
            pulumi.set(__self__, "service_profile_id", service_profile_id)

    @property
    @pulumi.getter(name="abpV10x")
    def abp_v10x(self) -> Optional['outputs.WirelessDeviceAbpV10x']:
        """
        ABP device object for LoRaWAN specification v1.0.x.
        """
        return pulumi.get(self, "abp_v10x")

    @property
    @pulumi.getter(name="abpV11")
    def abp_v11(self) -> Optional['outputs.WirelessDeviceAbpV11']:
        """
        ABP device object for create APIs for v1.1.
        """
        return pulumi.get(self, "abp_v11")

    @property
    @pulumi.getter(name="devEui")
    def dev_eui(self) -> Optional[str]:
        """
        The DevEUI value.
        """
        return pulumi.get(self, "dev_eui")

    @property
    @pulumi.getter(name="deviceProfileId")
    def device_profile_id(self) -> Optional[str]:
        """
        The ID of the device profile for the new wireless device.
        """
        return pulumi.get(self, "device_profile_id")

    @property
    @pulumi.getter(name="otaaV10x")
    def otaa_v10x(self) -> Optional['outputs.WirelessDeviceOtaaV10x']:
        """
        OTAA device object for create APIs for v1.0.x
        """
        return pulumi.get(self, "otaa_v10x")

    @property
    @pulumi.getter(name="otaaV11")
    def otaa_v11(self) -> Optional['outputs.WirelessDeviceOtaaV11']:
        """
        OTAA device object for v1.1 for create APIs.
        """
        return pulumi.get(self, "otaa_v11")

    @property
    @pulumi.getter(name="serviceProfileId")
    def service_profile_id(self) -> Optional[str]:
        """
        The ID of the service profile.
        """
        return pulumi.get(self, "service_profile_id")


@pulumi.output_type
class WirelessDeviceOtaaV10x(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appEui":
            suggest = "app_eui"
        elif key == "appKey":
            suggest = "app_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WirelessDeviceOtaaV10x. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WirelessDeviceOtaaV10x.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WirelessDeviceOtaaV10x.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 app_eui: str,
                 app_key: str):
        """
        :param str app_eui: The AppEUI value. You specify this value when using LoRaWAN versions v1.0.2 or v1.0.3.
        :param str app_key: The AppKey value.
        """
        pulumi.set(__self__, "app_eui", app_eui)
        pulumi.set(__self__, "app_key", app_key)

    @property
    @pulumi.getter(name="appEui")
    def app_eui(self) -> str:
        """
        The AppEUI value. You specify this value when using LoRaWAN versions v1.0.2 or v1.0.3.
        """
        return pulumi.get(self, "app_eui")

    @property
    @pulumi.getter(name="appKey")
    def app_key(self) -> str:
        """
        The AppKey value.
        """
        return pulumi.get(self, "app_key")


@pulumi.output_type
class WirelessDeviceOtaaV11(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appKey":
            suggest = "app_key"
        elif key == "joinEui":
            suggest = "join_eui"
        elif key == "nwkKey":
            suggest = "nwk_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WirelessDeviceOtaaV11. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WirelessDeviceOtaaV11.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WirelessDeviceOtaaV11.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 app_key: str,
                 join_eui: str,
                 nwk_key: str):
        """
        :param str app_key: The AppKey is a secret key, which you should handle in a similar way as you would an application password. You can protect the AppKey value by storing it in the AWS Secrets Manager and use the [secretsmanager](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/dynamic-references.html#dynamic-references-secretsmanager) to reference this value.
        :param str join_eui: The JoinEUI value.
        :param str nwk_key: The NwkKey is a secret key, which you should handle in a similar way as you would an application password. You can protect the NwkKey value by storing it in the AWS Secrets Manager and use the [secretsmanager](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/dynamic-references.html#dynamic-references-secretsmanager) to reference this value.
        """
        pulumi.set(__self__, "app_key", app_key)
        pulumi.set(__self__, "join_eui", join_eui)
        pulumi.set(__self__, "nwk_key", nwk_key)

    @property
    @pulumi.getter(name="appKey")
    def app_key(self) -> str:
        """
        The AppKey is a secret key, which you should handle in a similar way as you would an application password. You can protect the AppKey value by storing it in the AWS Secrets Manager and use the [secretsmanager](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/dynamic-references.html#dynamic-references-secretsmanager) to reference this value.
        """
        return pulumi.get(self, "app_key")

    @property
    @pulumi.getter(name="joinEui")
    def join_eui(self) -> str:
        """
        The JoinEUI value.
        """
        return pulumi.get(self, "join_eui")

    @property
    @pulumi.getter(name="nwkKey")
    def nwk_key(self) -> str:
        """
        The NwkKey is a secret key, which you should handle in a similar way as you would an application password. You can protect the NwkKey value by storing it in the AWS Secrets Manager and use the [secretsmanager](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/dynamic-references.html#dynamic-references-secretsmanager) to reference this value.
        """
        return pulumi.get(self, "nwk_key")


@pulumi.output_type
class WirelessDeviceSessionKeysAbpV10x(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appSKey":
            suggest = "app_s_key"
        elif key == "nwkSKey":
            suggest = "nwk_s_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WirelessDeviceSessionKeysAbpV10x. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WirelessDeviceSessionKeysAbpV10x.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WirelessDeviceSessionKeysAbpV10x.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 app_s_key: str,
                 nwk_s_key: str):
        """
        :param str app_s_key: The AppSKey value.
        :param str nwk_s_key: The NwkKey value.
        """
        pulumi.set(__self__, "app_s_key", app_s_key)
        pulumi.set(__self__, "nwk_s_key", nwk_s_key)

    @property
    @pulumi.getter(name="appSKey")
    def app_s_key(self) -> str:
        """
        The AppSKey value.
        """
        return pulumi.get(self, "app_s_key")

    @property
    @pulumi.getter(name="nwkSKey")
    def nwk_s_key(self) -> str:
        """
        The NwkKey value.
        """
        return pulumi.get(self, "nwk_s_key")


@pulumi.output_type
class WirelessDeviceSessionKeysAbpV11(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appSKey":
            suggest = "app_s_key"
        elif key == "fNwkSIntKey":
            suggest = "f_nwk_s_int_key"
        elif key == "nwkSEncKey":
            suggest = "nwk_s_enc_key"
        elif key == "sNwkSIntKey":
            suggest = "s_nwk_s_int_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WirelessDeviceSessionKeysAbpV11. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WirelessDeviceSessionKeysAbpV11.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WirelessDeviceSessionKeysAbpV11.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 app_s_key: str,
                 f_nwk_s_int_key: str,
                 nwk_s_enc_key: str,
                 s_nwk_s_int_key: str):
        """
        :param str app_s_key: The AppSKey is a secret key, which you should handle in a similar way as you would an application password. You can protect the AppSKey value by storing it in the AWS Secrets Manager and use the [secretsmanager](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/dynamic-references.html#dynamic-references-secretsmanager) to reference this value.
        :param str f_nwk_s_int_key: The FNwkSIntKey is a secret key, which you should handle in a similar way as you would an application password. You can protect the FNwkSIntKey value by storing it in the AWS Secrets Manager and use the [secretsmanager](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/dynamic-references.html#dynamic-references-secretsmanager) to reference this value.
        :param str nwk_s_enc_key: The NwkSEncKey is a secret key, which you should handle in a similar way as you would an application password. You can protect the NwkSEncKey value by storing it in the AWS Secrets Manager and use the [secretsmanager](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/dynamic-references.html#dynamic-references-secretsmanager) to reference this value.
        :param str s_nwk_s_int_key: The SNwkSIntKey is a secret key, which you should handle in a similar way as you would an application password. You can protect the SNwkSIntKey value by storing it in the AWS Secrets Manager and use the [secretsmanager](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/dynamic-references.html#dynamic-references-secretsmanager) to reference this value.
        """
        pulumi.set(__self__, "app_s_key", app_s_key)
        pulumi.set(__self__, "f_nwk_s_int_key", f_nwk_s_int_key)
        pulumi.set(__self__, "nwk_s_enc_key", nwk_s_enc_key)
        pulumi.set(__self__, "s_nwk_s_int_key", s_nwk_s_int_key)

    @property
    @pulumi.getter(name="appSKey")
    def app_s_key(self) -> str:
        """
        The AppSKey is a secret key, which you should handle in a similar way as you would an application password. You can protect the AppSKey value by storing it in the AWS Secrets Manager and use the [secretsmanager](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/dynamic-references.html#dynamic-references-secretsmanager) to reference this value.
        """
        return pulumi.get(self, "app_s_key")

    @property
    @pulumi.getter(name="fNwkSIntKey")
    def f_nwk_s_int_key(self) -> str:
        """
        The FNwkSIntKey is a secret key, which you should handle in a similar way as you would an application password. You can protect the FNwkSIntKey value by storing it in the AWS Secrets Manager and use the [secretsmanager](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/dynamic-references.html#dynamic-references-secretsmanager) to reference this value.
        """
        return pulumi.get(self, "f_nwk_s_int_key")

    @property
    @pulumi.getter(name="nwkSEncKey")
    def nwk_s_enc_key(self) -> str:
        """
        The NwkSEncKey is a secret key, which you should handle in a similar way as you would an application password. You can protect the NwkSEncKey value by storing it in the AWS Secrets Manager and use the [secretsmanager](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/dynamic-references.html#dynamic-references-secretsmanager) to reference this value.
        """
        return pulumi.get(self, "nwk_s_enc_key")

    @property
    @pulumi.getter(name="sNwkSIntKey")
    def s_nwk_s_int_key(self) -> str:
        """
        The SNwkSIntKey is a secret key, which you should handle in a similar way as you would an application password. You can protect the SNwkSIntKey value by storing it in the AWS Secrets Manager and use the [secretsmanager](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/dynamic-references.html#dynamic-references-secretsmanager) to reference this value.
        """
        return pulumi.get(self, "s_nwk_s_int_key")


@pulumi.output_type
class WirelessGatewayLoRaWanGateway(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "gatewayEui":
            suggest = "gateway_eui"
        elif key == "rfRegion":
            suggest = "rf_region"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WirelessGatewayLoRaWanGateway. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WirelessGatewayLoRaWanGateway.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WirelessGatewayLoRaWanGateway.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 gateway_eui: str,
                 rf_region: str):
        """
        :param str gateway_eui: The gateway's EUI value.
        :param str rf_region: The frequency band (RFRegion) value.
        """
        pulumi.set(__self__, "gateway_eui", gateway_eui)
        pulumi.set(__self__, "rf_region", rf_region)

    @property
    @pulumi.getter(name="gatewayEui")
    def gateway_eui(self) -> str:
        """
        The gateway's EUI value.
        """
        return pulumi.get(self, "gateway_eui")

    @property
    @pulumi.getter(name="rfRegion")
    def rf_region(self) -> str:
        """
        The frequency band (RFRegion) value.
        """
        return pulumi.get(self, "rf_region")


