# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetAlarmModelResult',
    'AwaitableGetAlarmModelResult',
    'get_alarm_model',
    'get_alarm_model_output',
]

@pulumi.output_type
class GetAlarmModelResult:
    def __init__(__self__, alarm_capabilities=None, alarm_event_actions=None, alarm_model_description=None, alarm_rule=None, role_arn=None, severity=None, tags=None):
        if alarm_capabilities and not isinstance(alarm_capabilities, dict):
            raise TypeError("Expected argument 'alarm_capabilities' to be a dict")
        pulumi.set(__self__, "alarm_capabilities", alarm_capabilities)
        if alarm_event_actions and not isinstance(alarm_event_actions, dict):
            raise TypeError("Expected argument 'alarm_event_actions' to be a dict")
        pulumi.set(__self__, "alarm_event_actions", alarm_event_actions)
        if alarm_model_description and not isinstance(alarm_model_description, str):
            raise TypeError("Expected argument 'alarm_model_description' to be a str")
        pulumi.set(__self__, "alarm_model_description", alarm_model_description)
        if alarm_rule and not isinstance(alarm_rule, dict):
            raise TypeError("Expected argument 'alarm_rule' to be a dict")
        pulumi.set(__self__, "alarm_rule", alarm_rule)
        if role_arn and not isinstance(role_arn, str):
            raise TypeError("Expected argument 'role_arn' to be a str")
        pulumi.set(__self__, "role_arn", role_arn)
        if severity and not isinstance(severity, int):
            raise TypeError("Expected argument 'severity' to be a int")
        pulumi.set(__self__, "severity", severity)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="alarmCapabilities")
    def alarm_capabilities(self) -> Optional['outputs.AlarmModelAlarmCapabilities']:
        """
        Contains the configuration information of alarm state changes.
        """
        return pulumi.get(self, "alarm_capabilities")

    @property
    @pulumi.getter(name="alarmEventActions")
    def alarm_event_actions(self) -> Optional['outputs.AlarmModelAlarmEventActions']:
        """
        Contains information about one or more alarm actions.
        """
        return pulumi.get(self, "alarm_event_actions")

    @property
    @pulumi.getter(name="alarmModelDescription")
    def alarm_model_description(self) -> Optional[str]:
        """
        The description of the alarm model.
        """
        return pulumi.get(self, "alarm_model_description")

    @property
    @pulumi.getter(name="alarmRule")
    def alarm_rule(self) -> Optional['outputs.AlarmModelAlarmRule']:
        """
        Defines when your alarm is invoked.
        """
        return pulumi.get(self, "alarm_rule")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[str]:
        """
        The ARN of the IAM role that allows the alarm to perform actions and access AWS resources. For more information, see [Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *General Reference*.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter
    def severity(self) -> Optional[int]:
        """
        A non-negative integer that reflects the severity level of the alarm.
        """
        return pulumi.get(self, "severity")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        A list of key-value pairs that contain metadata for the alarm model. The tags help you manage the alarm model. For more information, see [Tagging your resources](https://docs.aws.amazon.com/iotevents/latest/developerguide/tagging-iotevents.html) in the *Developer Guide*.
         You can create up to 50 tags for one alarm model.
        """
        return pulumi.get(self, "tags")


class AwaitableGetAlarmModelResult(GetAlarmModelResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAlarmModelResult(
            alarm_capabilities=self.alarm_capabilities,
            alarm_event_actions=self.alarm_event_actions,
            alarm_model_description=self.alarm_model_description,
            alarm_rule=self.alarm_rule,
            role_arn=self.role_arn,
            severity=self.severity,
            tags=self.tags)


def get_alarm_model(alarm_model_name: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAlarmModelResult:
    """
    Represents an alarm model to monitor an ITE input attribute. You can use the alarm to get notified when the value is outside a specified range. For more information, see [Create an alarm model](https://docs.aws.amazon.com/iotevents/latest/developerguide/create-alarms.html) in the *Developer Guide*.


    :param str alarm_model_name: The name of the alarm model.
    """
    __args__ = dict()
    __args__['alarmModelName'] = alarm_model_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:iotevents:getAlarmModel', __args__, opts=opts, typ=GetAlarmModelResult).value

    return AwaitableGetAlarmModelResult(
        alarm_capabilities=pulumi.get(__ret__, 'alarm_capabilities'),
        alarm_event_actions=pulumi.get(__ret__, 'alarm_event_actions'),
        alarm_model_description=pulumi.get(__ret__, 'alarm_model_description'),
        alarm_rule=pulumi.get(__ret__, 'alarm_rule'),
        role_arn=pulumi.get(__ret__, 'role_arn'),
        severity=pulumi.get(__ret__, 'severity'),
        tags=pulumi.get(__ret__, 'tags'))
def get_alarm_model_output(alarm_model_name: Optional[pulumi.Input[str]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAlarmModelResult]:
    """
    Represents an alarm model to monitor an ITE input attribute. You can use the alarm to get notified when the value is outside a specified range. For more information, see [Create an alarm model](https://docs.aws.amazon.com/iotevents/latest/developerguide/create-alarms.html) in the *Developer Guide*.


    :param str alarm_model_name: The name of the alarm model.
    """
    __args__ = dict()
    __args__['alarmModelName'] = alarm_model_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:iotevents:getAlarmModel', __args__, opts=opts, typ=GetAlarmModelResult)
    return __ret__.apply(lambda __response__: GetAlarmModelResult(
        alarm_capabilities=pulumi.get(__response__, 'alarm_capabilities'),
        alarm_event_actions=pulumi.get(__response__, 'alarm_event_actions'),
        alarm_model_description=pulumi.get(__response__, 'alarm_model_description'),
        alarm_rule=pulumi.get(__response__, 'alarm_rule'),
        role_arn=pulumi.get(__response__, 'role_arn'),
        severity=pulumi.get(__response__, 'severity'),
        tags=pulumi.get(__response__, 'tags')))
