# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'AlarmModelAcknowledgeFlowArgs',
    'AlarmModelAcknowledgeFlowArgsDict',
    'AlarmModelAlarmActionArgs',
    'AlarmModelAlarmActionArgsDict',
    'AlarmModelAlarmCapabilitiesArgs',
    'AlarmModelAlarmCapabilitiesArgsDict',
    'AlarmModelAlarmEventActionsArgs',
    'AlarmModelAlarmEventActionsArgsDict',
    'AlarmModelAlarmRuleArgs',
    'AlarmModelAlarmRuleArgsDict',
    'AlarmModelAssetPropertyTimestampArgs',
    'AlarmModelAssetPropertyTimestampArgsDict',
    'AlarmModelAssetPropertyValueArgs',
    'AlarmModelAssetPropertyValueArgsDict',
    'AlarmModelAssetPropertyVariantArgs',
    'AlarmModelAssetPropertyVariantArgsDict',
    'AlarmModelDynamoDBv2Args',
    'AlarmModelDynamoDBv2ArgsDict',
    'AlarmModelDynamoDbArgs',
    'AlarmModelDynamoDbArgsDict',
    'AlarmModelFirehoseArgs',
    'AlarmModelFirehoseArgsDict',
    'AlarmModelInitializationConfigurationArgs',
    'AlarmModelInitializationConfigurationArgsDict',
    'AlarmModelIotEventsArgs',
    'AlarmModelIotEventsArgsDict',
    'AlarmModelIotSiteWiseArgs',
    'AlarmModelIotSiteWiseArgsDict',
    'AlarmModelIotTopicPublishArgs',
    'AlarmModelIotTopicPublishArgsDict',
    'AlarmModelLambdaArgs',
    'AlarmModelLambdaArgsDict',
    'AlarmModelPayloadArgs',
    'AlarmModelPayloadArgsDict',
    'AlarmModelSimpleRuleArgs',
    'AlarmModelSimpleRuleArgsDict',
    'AlarmModelSnsArgs',
    'AlarmModelSnsArgsDict',
    'AlarmModelSqsArgs',
    'AlarmModelSqsArgsDict',
    'DetectorModelActionArgs',
    'DetectorModelActionArgsDict',
    'DetectorModelAssetPropertyTimestampArgs',
    'DetectorModelAssetPropertyTimestampArgsDict',
    'DetectorModelAssetPropertyValueArgs',
    'DetectorModelAssetPropertyValueArgsDict',
    'DetectorModelAssetPropertyVariantArgs',
    'DetectorModelAssetPropertyVariantArgsDict',
    'DetectorModelClearTimerArgs',
    'DetectorModelClearTimerArgsDict',
    'DetectorModelDefinitionArgs',
    'DetectorModelDefinitionArgsDict',
    'DetectorModelDynamoDBv2Args',
    'DetectorModelDynamoDBv2ArgsDict',
    'DetectorModelDynamoDbArgs',
    'DetectorModelDynamoDbArgsDict',
    'DetectorModelEventArgs',
    'DetectorModelEventArgsDict',
    'DetectorModelFirehoseArgs',
    'DetectorModelFirehoseArgsDict',
    'DetectorModelIotEventsArgs',
    'DetectorModelIotEventsArgsDict',
    'DetectorModelIotSiteWiseArgs',
    'DetectorModelIotSiteWiseArgsDict',
    'DetectorModelIotTopicPublishArgs',
    'DetectorModelIotTopicPublishArgsDict',
    'DetectorModelLambdaArgs',
    'DetectorModelLambdaArgsDict',
    'DetectorModelOnEnterArgs',
    'DetectorModelOnEnterArgsDict',
    'DetectorModelOnExitArgs',
    'DetectorModelOnExitArgsDict',
    'DetectorModelOnInputArgs',
    'DetectorModelOnInputArgsDict',
    'DetectorModelPayloadArgs',
    'DetectorModelPayloadArgsDict',
    'DetectorModelResetTimerArgs',
    'DetectorModelResetTimerArgsDict',
    'DetectorModelSetTimerArgs',
    'DetectorModelSetTimerArgsDict',
    'DetectorModelSetVariableArgs',
    'DetectorModelSetVariableArgsDict',
    'DetectorModelSnsArgs',
    'DetectorModelSnsArgsDict',
    'DetectorModelSqsArgs',
    'DetectorModelSqsArgsDict',
    'DetectorModelStateArgs',
    'DetectorModelStateArgsDict',
    'DetectorModelTransitionEventArgs',
    'DetectorModelTransitionEventArgsDict',
    'InputAttributeArgs',
    'InputAttributeArgsDict',
    'InputDefinitionArgs',
    'InputDefinitionArgsDict',
]

MYPY = False

if not MYPY:
    class AlarmModelAcknowledgeFlowArgsDict(TypedDict):
        """
        Specifies whether to get notified for alarm state changes.
        """
        enabled: NotRequired[pulumi.Input[bool]]
        """
        The value must be ``TRUE`` or ``FALSE``. If ``TRUE``, you receive a notification when the alarm state changes. You must choose to acknowledge the notification before the alarm state can return to ``NORMAL``. If ``FALSE``, you won't receive notifications. The alarm automatically changes to the ``NORMAL`` state when the input property value returns to the specified range.
        """
elif False:
    AlarmModelAcknowledgeFlowArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AlarmModelAcknowledgeFlowArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None):
        """
        Specifies whether to get notified for alarm state changes.
        :param pulumi.Input[bool] enabled: The value must be ``TRUE`` or ``FALSE``. If ``TRUE``, you receive a notification when the alarm state changes. You must choose to acknowledge the notification before the alarm state can return to ``NORMAL``. If ``FALSE``, you won't receive notifications. The alarm automatically changes to the ``NORMAL`` state when the input property value returns to the specified range.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        The value must be ``TRUE`` or ``FALSE``. If ``TRUE``, you receive a notification when the alarm state changes. You must choose to acknowledge the notification before the alarm state can return to ``NORMAL``. If ``FALSE``, you won't receive notifications. The alarm automatically changes to the ``NORMAL`` state when the input property value returns to the specified range.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)


if not MYPY:
    class AlarmModelAlarmActionArgsDict(TypedDict):
        """
        Specifies one of the following actions to receive notifications when the alarm state changes.
        """
        dynamo_d_bv2: NotRequired[pulumi.Input['AlarmModelDynamoDBv2ArgsDict']]
        """
        Defines an action to write to the Amazon DynamoDB table that you created. The default action payload contains all the information about the detector model instance and the event that triggered the action. You can customize the [payload](https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html). A separate column of the DynamoDB table receives one attribute-value pair in the payload that you specify.
         You must use expressions for all parameters in ``DynamoDBv2Action``. The expressions accept literals, operators, functions, references, and substitution templates.
          **Examples**
         +  For literal values, the expressions must contain single quotes. For example, the value for the ``tableName`` parameter can be ``'GreenhouseTemperatureTable'``.
          +  For references, you must specify either variables or input values. For example, the value for the ``tableName`` parameter can be ``$variable.ddbtableName``.
          +  For a substitution template, you must use ``${}``, and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.
         In the following example, the value for the ``contentExpression`` parameter in ``Payload`` uses a substitution template. 
          ``'{\\"sensorID\\": \\"${$input.GreenhouseInput.sensor_id}\\", \\"temperature\\": \\"${$input.GreenhouseInput.temperature * 9 / 5 + 32}\\"}'`` 
          +  For a string concatenation, you must use ``+``. A string concatenation can also contain a combination of literals, operators, functions, references, and substitution templates.
         In the following example, the value for the ``tableName`` parameter uses a string concatenation. 
          ``'GreenhouseTemperatureTable ' + $input.GreenhouseInput.date`` 
          
         For more information, see [Expressions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html) in the *Developer Guide*.
         The value for the ``type`` parameter in ``Payload`` must be ``JSON``.
        """
        dynamo_db: NotRequired[pulumi.Input['AlarmModelDynamoDbArgsDict']]
        """
        Defines an action to write to the Amazon DynamoDB table that you created. The standard action payload contains all the information about the detector model instance and the event that triggered the action. You can customize the [payload](https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html). One column of the DynamoDB table receives all attribute-value pairs in the payload that you specify.
         You must use expressions for all parameters in ``DynamoDBAction``. The expressions accept literals, operators, functions, references, and substitution templates.
          **Examples**
         +  For literal values, the expressions must contain single quotes. For example, the value for the ``hashKeyType`` parameter can be ``'STRING'``.
          +  For references, you must specify either variables or input values. For example, the value for the ``hashKeyField`` parameter can be ``$input.GreenhouseInput.name``.
          +  For a substitution template, you must use ``${}``, and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.
         In the following example, the value for the ``hashKeyValue`` parameter uses a substitution template. 
          ``'${$input.GreenhouseInput.temperature * 6 / 5 + 32} in Fahrenheit'`` 
          +  For a string concatenation, you must use ``+``. A string concatenation can also contain a combination of literals, operators, functions, references, and substitution templates.
         In the following example, the value for the ``tableName`` parameter uses a string concatenation. 
          ``'GreenhouseTemperatureTable ' + $input.GreenhouseInput.date`` 
          
         For more information, see [Expressions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html) in the *Developer Guide*.
         If the defined payload type is a string, ``DynamoDBAction`` writes non-JSON data to the DynamoDB table as binary data. The DynamoDB console displays the data as Base64-encoded text. The value for the ``payloadField`` parameter is ``<payload-field>_raw``.
        """
        firehose: NotRequired[pulumi.Input['AlarmModelFirehoseArgsDict']]
        """
        Sends information about the detector model instance and the event that triggered the action to an Amazon Kinesis Data Firehose delivery stream.
        """
        iot_events: NotRequired[pulumi.Input['AlarmModelIotEventsArgsDict']]
        """
        Sends an ITE input, passing in information about the detector model instance and the event that triggered the action.
        """
        iot_site_wise: NotRequired[pulumi.Input['AlarmModelIotSiteWiseArgsDict']]
        """
        Sends information about the detector model instance and the event that triggered the action to a specified asset property in ITSW.
         You must use expressions for all parameters in ``IotSiteWiseAction``. The expressions accept literals, operators, functions, references, and substitutions templates.
          **Examples**
         +  For literal values, the expressions must contain single quotes. For example, the value for the ``propertyAlias`` parameter can be ``'/company/windfarm/3/turbine/7/temperature'``.
          +  For references, you must specify either variables or input values. For example, the value for the ``assetId`` parameter can be ``$input.TurbineInput.assetId1``.
          +  For a substitution template, you must use ``${}``, and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.
         In the following example, the value for the ``propertyAlias`` parameter uses a substitution template. 
          ``'company/windfarm/${$input.TemperatureInput.sensorData.windfarmID}/turbine/ ${$input.TemperatureInput.sensorData.turbineID}/temperature'`` 
          
         You must specify either ``propertyAlias`` or both ``assetId`` and ``propertyId`` to identify the target asset property in ITSW.
         For more information, see [Expressions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html) in the *Developer Guide*.
        """
        iot_topic_publish: NotRequired[pulumi.Input['AlarmModelIotTopicPublishArgsDict']]
        """
        Information required to publish the MQTT message through the IoT message broker.
        """
        lambda_: NotRequired[pulumi.Input['AlarmModelLambdaArgsDict']]
        """
        Calls a Lambda function, passing in information about the detector model instance and the event that triggered the action.
        """
        sns: NotRequired[pulumi.Input['AlarmModelSnsArgsDict']]
        """
        Information required to publish the Amazon SNS message.
        """
        sqs: NotRequired[pulumi.Input['AlarmModelSqsArgsDict']]
        """
        Sends information about the detector model instance and the event that triggered the action to an Amazon SQS queue.
        """
elif False:
    AlarmModelAlarmActionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AlarmModelAlarmActionArgs:
    def __init__(__self__, *,
                 dynamo_d_bv2: Optional[pulumi.Input['AlarmModelDynamoDBv2Args']] = None,
                 dynamo_db: Optional[pulumi.Input['AlarmModelDynamoDbArgs']] = None,
                 firehose: Optional[pulumi.Input['AlarmModelFirehoseArgs']] = None,
                 iot_events: Optional[pulumi.Input['AlarmModelIotEventsArgs']] = None,
                 iot_site_wise: Optional[pulumi.Input['AlarmModelIotSiteWiseArgs']] = None,
                 iot_topic_publish: Optional[pulumi.Input['AlarmModelIotTopicPublishArgs']] = None,
                 lambda_: Optional[pulumi.Input['AlarmModelLambdaArgs']] = None,
                 sns: Optional[pulumi.Input['AlarmModelSnsArgs']] = None,
                 sqs: Optional[pulumi.Input['AlarmModelSqsArgs']] = None):
        """
        Specifies one of the following actions to receive notifications when the alarm state changes.
        :param pulumi.Input['AlarmModelDynamoDBv2Args'] dynamo_d_bv2: Defines an action to write to the Amazon DynamoDB table that you created. The default action payload contains all the information about the detector model instance and the event that triggered the action. You can customize the [payload](https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html). A separate column of the DynamoDB table receives one attribute-value pair in the payload that you specify.
                You must use expressions for all parameters in ``DynamoDBv2Action``. The expressions accept literals, operators, functions, references, and substitution templates.
                 **Examples**
                +  For literal values, the expressions must contain single quotes. For example, the value for the ``tableName`` parameter can be ``'GreenhouseTemperatureTable'``.
                 +  For references, you must specify either variables or input values. For example, the value for the ``tableName`` parameter can be ``$variable.ddbtableName``.
                 +  For a substitution template, you must use ``${}``, and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.
                In the following example, the value for the ``contentExpression`` parameter in ``Payload`` uses a substitution template. 
                 ``'{\\"sensorID\\": \\"${$input.GreenhouseInput.sensor_id}\\", \\"temperature\\": \\"${$input.GreenhouseInput.temperature * 9 / 5 + 32}\\"}'`` 
                 +  For a string concatenation, you must use ``+``. A string concatenation can also contain a combination of literals, operators, functions, references, and substitution templates.
                In the following example, the value for the ``tableName`` parameter uses a string concatenation. 
                 ``'GreenhouseTemperatureTable ' + $input.GreenhouseInput.date`` 
                 
                For more information, see [Expressions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html) in the *Developer Guide*.
                The value for the ``type`` parameter in ``Payload`` must be ``JSON``.
        :param pulumi.Input['AlarmModelDynamoDbArgs'] dynamo_db: Defines an action to write to the Amazon DynamoDB table that you created. The standard action payload contains all the information about the detector model instance and the event that triggered the action. You can customize the [payload](https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html). One column of the DynamoDB table receives all attribute-value pairs in the payload that you specify.
                You must use expressions for all parameters in ``DynamoDBAction``. The expressions accept literals, operators, functions, references, and substitution templates.
                 **Examples**
                +  For literal values, the expressions must contain single quotes. For example, the value for the ``hashKeyType`` parameter can be ``'STRING'``.
                 +  For references, you must specify either variables or input values. For example, the value for the ``hashKeyField`` parameter can be ``$input.GreenhouseInput.name``.
                 +  For a substitution template, you must use ``${}``, and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.
                In the following example, the value for the ``hashKeyValue`` parameter uses a substitution template. 
                 ``'${$input.GreenhouseInput.temperature * 6 / 5 + 32} in Fahrenheit'`` 
                 +  For a string concatenation, you must use ``+``. A string concatenation can also contain a combination of literals, operators, functions, references, and substitution templates.
                In the following example, the value for the ``tableName`` parameter uses a string concatenation. 
                 ``'GreenhouseTemperatureTable ' + $input.GreenhouseInput.date`` 
                 
                For more information, see [Expressions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html) in the *Developer Guide*.
                If the defined payload type is a string, ``DynamoDBAction`` writes non-JSON data to the DynamoDB table as binary data. The DynamoDB console displays the data as Base64-encoded text. The value for the ``payloadField`` parameter is ``<payload-field>_raw``.
        :param pulumi.Input['AlarmModelFirehoseArgs'] firehose: Sends information about the detector model instance and the event that triggered the action to an Amazon Kinesis Data Firehose delivery stream.
        :param pulumi.Input['AlarmModelIotEventsArgs'] iot_events: Sends an ITE input, passing in information about the detector model instance and the event that triggered the action.
        :param pulumi.Input['AlarmModelIotSiteWiseArgs'] iot_site_wise: Sends information about the detector model instance and the event that triggered the action to a specified asset property in ITSW.
                You must use expressions for all parameters in ``IotSiteWiseAction``. The expressions accept literals, operators, functions, references, and substitutions templates.
                 **Examples**
                +  For literal values, the expressions must contain single quotes. For example, the value for the ``propertyAlias`` parameter can be ``'/company/windfarm/3/turbine/7/temperature'``.
                 +  For references, you must specify either variables or input values. For example, the value for the ``assetId`` parameter can be ``$input.TurbineInput.assetId1``.
                 +  For a substitution template, you must use ``${}``, and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.
                In the following example, the value for the ``propertyAlias`` parameter uses a substitution template. 
                 ``'company/windfarm/${$input.TemperatureInput.sensorData.windfarmID}/turbine/ ${$input.TemperatureInput.sensorData.turbineID}/temperature'`` 
                 
                You must specify either ``propertyAlias`` or both ``assetId`` and ``propertyId`` to identify the target asset property in ITSW.
                For more information, see [Expressions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html) in the *Developer Guide*.
        :param pulumi.Input['AlarmModelIotTopicPublishArgs'] iot_topic_publish: Information required to publish the MQTT message through the IoT message broker.
        :param pulumi.Input['AlarmModelLambdaArgs'] lambda_: Calls a Lambda function, passing in information about the detector model instance and the event that triggered the action.
        :param pulumi.Input['AlarmModelSnsArgs'] sns: Information required to publish the Amazon SNS message.
        :param pulumi.Input['AlarmModelSqsArgs'] sqs: Sends information about the detector model instance and the event that triggered the action to an Amazon SQS queue.
        """
        if dynamo_d_bv2 is not None:
            pulumi.set(__self__, "dynamo_d_bv2", dynamo_d_bv2)
        if dynamo_db is not None:
            pulumi.set(__self__, "dynamo_db", dynamo_db)
        if firehose is not None:
            pulumi.set(__self__, "firehose", firehose)
        if iot_events is not None:
            pulumi.set(__self__, "iot_events", iot_events)
        if iot_site_wise is not None:
            pulumi.set(__self__, "iot_site_wise", iot_site_wise)
        if iot_topic_publish is not None:
            pulumi.set(__self__, "iot_topic_publish", iot_topic_publish)
        if lambda_ is not None:
            pulumi.set(__self__, "lambda_", lambda_)
        if sns is not None:
            pulumi.set(__self__, "sns", sns)
        if sqs is not None:
            pulumi.set(__self__, "sqs", sqs)

    @property
    @pulumi.getter(name="dynamoDBv2")
    def dynamo_d_bv2(self) -> Optional[pulumi.Input['AlarmModelDynamoDBv2Args']]:
        """
        Defines an action to write to the Amazon DynamoDB table that you created. The default action payload contains all the information about the detector model instance and the event that triggered the action. You can customize the [payload](https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html). A separate column of the DynamoDB table receives one attribute-value pair in the payload that you specify.
         You must use expressions for all parameters in ``DynamoDBv2Action``. The expressions accept literals, operators, functions, references, and substitution templates.
          **Examples**
         +  For literal values, the expressions must contain single quotes. For example, the value for the ``tableName`` parameter can be ``'GreenhouseTemperatureTable'``.
          +  For references, you must specify either variables or input values. For example, the value for the ``tableName`` parameter can be ``$variable.ddbtableName``.
          +  For a substitution template, you must use ``${}``, and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.
         In the following example, the value for the ``contentExpression`` parameter in ``Payload`` uses a substitution template. 
          ``'{\\"sensorID\\": \\"${$input.GreenhouseInput.sensor_id}\\", \\"temperature\\": \\"${$input.GreenhouseInput.temperature * 9 / 5 + 32}\\"}'`` 
          +  For a string concatenation, you must use ``+``. A string concatenation can also contain a combination of literals, operators, functions, references, and substitution templates.
         In the following example, the value for the ``tableName`` parameter uses a string concatenation. 
          ``'GreenhouseTemperatureTable ' + $input.GreenhouseInput.date`` 
          
         For more information, see [Expressions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html) in the *Developer Guide*.
         The value for the ``type`` parameter in ``Payload`` must be ``JSON``.
        """
        return pulumi.get(self, "dynamo_d_bv2")

    @dynamo_d_bv2.setter
    def dynamo_d_bv2(self, value: Optional[pulumi.Input['AlarmModelDynamoDBv2Args']]):
        pulumi.set(self, "dynamo_d_bv2", value)

    @property
    @pulumi.getter(name="dynamoDb")
    def dynamo_db(self) -> Optional[pulumi.Input['AlarmModelDynamoDbArgs']]:
        """
        Defines an action to write to the Amazon DynamoDB table that you created. The standard action payload contains all the information about the detector model instance and the event that triggered the action. You can customize the [payload](https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html). One column of the DynamoDB table receives all attribute-value pairs in the payload that you specify.
         You must use expressions for all parameters in ``DynamoDBAction``. The expressions accept literals, operators, functions, references, and substitution templates.
          **Examples**
         +  For literal values, the expressions must contain single quotes. For example, the value for the ``hashKeyType`` parameter can be ``'STRING'``.
          +  For references, you must specify either variables or input values. For example, the value for the ``hashKeyField`` parameter can be ``$input.GreenhouseInput.name``.
          +  For a substitution template, you must use ``${}``, and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.
         In the following example, the value for the ``hashKeyValue`` parameter uses a substitution template. 
          ``'${$input.GreenhouseInput.temperature * 6 / 5 + 32} in Fahrenheit'`` 
          +  For a string concatenation, you must use ``+``. A string concatenation can also contain a combination of literals, operators, functions, references, and substitution templates.
         In the following example, the value for the ``tableName`` parameter uses a string concatenation. 
          ``'GreenhouseTemperatureTable ' + $input.GreenhouseInput.date`` 
          
         For more information, see [Expressions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html) in the *Developer Guide*.
         If the defined payload type is a string, ``DynamoDBAction`` writes non-JSON data to the DynamoDB table as binary data. The DynamoDB console displays the data as Base64-encoded text. The value for the ``payloadField`` parameter is ``<payload-field>_raw``.
        """
        return pulumi.get(self, "dynamo_db")

    @dynamo_db.setter
    def dynamo_db(self, value: Optional[pulumi.Input['AlarmModelDynamoDbArgs']]):
        pulumi.set(self, "dynamo_db", value)

    @property
    @pulumi.getter
    def firehose(self) -> Optional[pulumi.Input['AlarmModelFirehoseArgs']]:
        """
        Sends information about the detector model instance and the event that triggered the action to an Amazon Kinesis Data Firehose delivery stream.
        """
        return pulumi.get(self, "firehose")

    @firehose.setter
    def firehose(self, value: Optional[pulumi.Input['AlarmModelFirehoseArgs']]):
        pulumi.set(self, "firehose", value)

    @property
    @pulumi.getter(name="iotEvents")
    def iot_events(self) -> Optional[pulumi.Input['AlarmModelIotEventsArgs']]:
        """
        Sends an ITE input, passing in information about the detector model instance and the event that triggered the action.
        """
        return pulumi.get(self, "iot_events")

    @iot_events.setter
    def iot_events(self, value: Optional[pulumi.Input['AlarmModelIotEventsArgs']]):
        pulumi.set(self, "iot_events", value)

    @property
    @pulumi.getter(name="iotSiteWise")
    def iot_site_wise(self) -> Optional[pulumi.Input['AlarmModelIotSiteWiseArgs']]:
        """
        Sends information about the detector model instance and the event that triggered the action to a specified asset property in ITSW.
         You must use expressions for all parameters in ``IotSiteWiseAction``. The expressions accept literals, operators, functions, references, and substitutions templates.
          **Examples**
         +  For literal values, the expressions must contain single quotes. For example, the value for the ``propertyAlias`` parameter can be ``'/company/windfarm/3/turbine/7/temperature'``.
          +  For references, you must specify either variables or input values. For example, the value for the ``assetId`` parameter can be ``$input.TurbineInput.assetId1``.
          +  For a substitution template, you must use ``${}``, and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.
         In the following example, the value for the ``propertyAlias`` parameter uses a substitution template. 
          ``'company/windfarm/${$input.TemperatureInput.sensorData.windfarmID}/turbine/ ${$input.TemperatureInput.sensorData.turbineID}/temperature'`` 
          
         You must specify either ``propertyAlias`` or both ``assetId`` and ``propertyId`` to identify the target asset property in ITSW.
         For more information, see [Expressions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html) in the *Developer Guide*.
        """
        return pulumi.get(self, "iot_site_wise")

    @iot_site_wise.setter
    def iot_site_wise(self, value: Optional[pulumi.Input['AlarmModelIotSiteWiseArgs']]):
        pulumi.set(self, "iot_site_wise", value)

    @property
    @pulumi.getter(name="iotTopicPublish")
    def iot_topic_publish(self) -> Optional[pulumi.Input['AlarmModelIotTopicPublishArgs']]:
        """
        Information required to publish the MQTT message through the IoT message broker.
        """
        return pulumi.get(self, "iot_topic_publish")

    @iot_topic_publish.setter
    def iot_topic_publish(self, value: Optional[pulumi.Input['AlarmModelIotTopicPublishArgs']]):
        pulumi.set(self, "iot_topic_publish", value)

    @property
    @pulumi.getter(name="lambda")
    def lambda_(self) -> Optional[pulumi.Input['AlarmModelLambdaArgs']]:
        """
        Calls a Lambda function, passing in information about the detector model instance and the event that triggered the action.
        """
        return pulumi.get(self, "lambda_")

    @lambda_.setter
    def lambda_(self, value: Optional[pulumi.Input['AlarmModelLambdaArgs']]):
        pulumi.set(self, "lambda_", value)

    @property
    @pulumi.getter
    def sns(self) -> Optional[pulumi.Input['AlarmModelSnsArgs']]:
        """
        Information required to publish the Amazon SNS message.
        """
        return pulumi.get(self, "sns")

    @sns.setter
    def sns(self, value: Optional[pulumi.Input['AlarmModelSnsArgs']]):
        pulumi.set(self, "sns", value)

    @property
    @pulumi.getter
    def sqs(self) -> Optional[pulumi.Input['AlarmModelSqsArgs']]:
        """
        Sends information about the detector model instance and the event that triggered the action to an Amazon SQS queue.
        """
        return pulumi.get(self, "sqs")

    @sqs.setter
    def sqs(self, value: Optional[pulumi.Input['AlarmModelSqsArgs']]):
        pulumi.set(self, "sqs", value)


if not MYPY:
    class AlarmModelAlarmCapabilitiesArgsDict(TypedDict):
        """
        Contains the configuration information of alarm state changes.
        """
        acknowledge_flow: NotRequired[pulumi.Input['AlarmModelAcknowledgeFlowArgsDict']]
        """
        Specifies whether to get notified for alarm state changes.
        """
        initialization_configuration: NotRequired[pulumi.Input['AlarmModelInitializationConfigurationArgsDict']]
        """
        Specifies the default alarm state. The configuration applies to all alarms that were created based on this alarm model.
        """
elif False:
    AlarmModelAlarmCapabilitiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AlarmModelAlarmCapabilitiesArgs:
    def __init__(__self__, *,
                 acknowledge_flow: Optional[pulumi.Input['AlarmModelAcknowledgeFlowArgs']] = None,
                 initialization_configuration: Optional[pulumi.Input['AlarmModelInitializationConfigurationArgs']] = None):
        """
        Contains the configuration information of alarm state changes.
        :param pulumi.Input['AlarmModelAcknowledgeFlowArgs'] acknowledge_flow: Specifies whether to get notified for alarm state changes.
        :param pulumi.Input['AlarmModelInitializationConfigurationArgs'] initialization_configuration: Specifies the default alarm state. The configuration applies to all alarms that were created based on this alarm model.
        """
        if acknowledge_flow is not None:
            pulumi.set(__self__, "acknowledge_flow", acknowledge_flow)
        if initialization_configuration is not None:
            pulumi.set(__self__, "initialization_configuration", initialization_configuration)

    @property
    @pulumi.getter(name="acknowledgeFlow")
    def acknowledge_flow(self) -> Optional[pulumi.Input['AlarmModelAcknowledgeFlowArgs']]:
        """
        Specifies whether to get notified for alarm state changes.
        """
        return pulumi.get(self, "acknowledge_flow")

    @acknowledge_flow.setter
    def acknowledge_flow(self, value: Optional[pulumi.Input['AlarmModelAcknowledgeFlowArgs']]):
        pulumi.set(self, "acknowledge_flow", value)

    @property
    @pulumi.getter(name="initializationConfiguration")
    def initialization_configuration(self) -> Optional[pulumi.Input['AlarmModelInitializationConfigurationArgs']]:
        """
        Specifies the default alarm state. The configuration applies to all alarms that were created based on this alarm model.
        """
        return pulumi.get(self, "initialization_configuration")

    @initialization_configuration.setter
    def initialization_configuration(self, value: Optional[pulumi.Input['AlarmModelInitializationConfigurationArgs']]):
        pulumi.set(self, "initialization_configuration", value)


if not MYPY:
    class AlarmModelAlarmEventActionsArgsDict(TypedDict):
        """
        Contains information about one or more alarm actions.
        """
        alarm_actions: NotRequired[pulumi.Input[Sequence[pulumi.Input['AlarmModelAlarmActionArgsDict']]]]
        """
        Specifies one or more supported actions to receive notifications when the alarm state changes.
        """
elif False:
    AlarmModelAlarmEventActionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AlarmModelAlarmEventActionsArgs:
    def __init__(__self__, *,
                 alarm_actions: Optional[pulumi.Input[Sequence[pulumi.Input['AlarmModelAlarmActionArgs']]]] = None):
        """
        Contains information about one or more alarm actions.
        :param pulumi.Input[Sequence[pulumi.Input['AlarmModelAlarmActionArgs']]] alarm_actions: Specifies one or more supported actions to receive notifications when the alarm state changes.
        """
        if alarm_actions is not None:
            pulumi.set(__self__, "alarm_actions", alarm_actions)

    @property
    @pulumi.getter(name="alarmActions")
    def alarm_actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlarmModelAlarmActionArgs']]]]:
        """
        Specifies one or more supported actions to receive notifications when the alarm state changes.
        """
        return pulumi.get(self, "alarm_actions")

    @alarm_actions.setter
    def alarm_actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlarmModelAlarmActionArgs']]]]):
        pulumi.set(self, "alarm_actions", value)


if not MYPY:
    class AlarmModelAlarmRuleArgsDict(TypedDict):
        """
        Defines when your alarm is invoked.
        """
        simple_rule: NotRequired[pulumi.Input['AlarmModelSimpleRuleArgsDict']]
        """
        A rule that compares an input property value to a threshold value with a comparison operator.
        """
elif False:
    AlarmModelAlarmRuleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AlarmModelAlarmRuleArgs:
    def __init__(__self__, *,
                 simple_rule: Optional[pulumi.Input['AlarmModelSimpleRuleArgs']] = None):
        """
        Defines when your alarm is invoked.
        :param pulumi.Input['AlarmModelSimpleRuleArgs'] simple_rule: A rule that compares an input property value to a threshold value with a comparison operator.
        """
        if simple_rule is not None:
            pulumi.set(__self__, "simple_rule", simple_rule)

    @property
    @pulumi.getter(name="simpleRule")
    def simple_rule(self) -> Optional[pulumi.Input['AlarmModelSimpleRuleArgs']]:
        """
        A rule that compares an input property value to a threshold value with a comparison operator.
        """
        return pulumi.get(self, "simple_rule")

    @simple_rule.setter
    def simple_rule(self, value: Optional[pulumi.Input['AlarmModelSimpleRuleArgs']]):
        pulumi.set(self, "simple_rule", value)


if not MYPY:
    class AlarmModelAssetPropertyTimestampArgsDict(TypedDict):
        """
        A structure that contains timestamp information. For more information, see [TimeInNanos](https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_TimeInNanos.html) in the *API Reference*.
         You must use expressions for all parameters in ``AssetPropertyTimestamp``. The expressions accept literals, operators, functions, references, and substitution templates.
          **Examples**
         +  For literal values, the expressions must contain single quotes. For example, the value for the ``timeInSeconds`` parameter can be ``'1586400675'``.
          +  For references, you must specify either variables or input values. For example, the value for the ``offsetInNanos`` parameter can be ``$variable.time``.
          +  For a substitution template, you must use ``${}``, and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.
         In the following example, the value for the ``timeInSeconds`` parameter uses a substitution template.
          ``'${$input.TemperatureInput.sensorData.timestamp / 1000}'`` 
          
         For more information, see [Expressions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html) in the *Developer Guide*.
        """
        time_in_seconds: pulumi.Input[str]
        """
        The timestamp, in seconds, in the Unix epoch format. The valid range is between 1-31556889864403199.
        """
        offset_in_nanos: NotRequired[pulumi.Input[str]]
        """
        The nanosecond offset converted from ``timeInSeconds``. The valid range is between 0-999999999.
        """
elif False:
    AlarmModelAssetPropertyTimestampArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AlarmModelAssetPropertyTimestampArgs:
    def __init__(__self__, *,
                 time_in_seconds: pulumi.Input[str],
                 offset_in_nanos: Optional[pulumi.Input[str]] = None):
        """
        A structure that contains timestamp information. For more information, see [TimeInNanos](https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_TimeInNanos.html) in the *API Reference*.
         You must use expressions for all parameters in ``AssetPropertyTimestamp``. The expressions accept literals, operators, functions, references, and substitution templates.
          **Examples**
         +  For literal values, the expressions must contain single quotes. For example, the value for the ``timeInSeconds`` parameter can be ``'1586400675'``.
          +  For references, you must specify either variables or input values. For example, the value for the ``offsetInNanos`` parameter can be ``$variable.time``.
          +  For a substitution template, you must use ``${}``, and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.
         In the following example, the value for the ``timeInSeconds`` parameter uses a substitution template.
          ``'${$input.TemperatureInput.sensorData.timestamp / 1000}'`` 
          
         For more information, see [Expressions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html) in the *Developer Guide*.
        :param pulumi.Input[str] time_in_seconds: The timestamp, in seconds, in the Unix epoch format. The valid range is between 1-31556889864403199.
        :param pulumi.Input[str] offset_in_nanos: The nanosecond offset converted from ``timeInSeconds``. The valid range is between 0-999999999.
        """
        pulumi.set(__self__, "time_in_seconds", time_in_seconds)
        if offset_in_nanos is not None:
            pulumi.set(__self__, "offset_in_nanos", offset_in_nanos)

    @property
    @pulumi.getter(name="timeInSeconds")
    def time_in_seconds(self) -> pulumi.Input[str]:
        """
        The timestamp, in seconds, in the Unix epoch format. The valid range is between 1-31556889864403199.
        """
        return pulumi.get(self, "time_in_seconds")

    @time_in_seconds.setter
    def time_in_seconds(self, value: pulumi.Input[str]):
        pulumi.set(self, "time_in_seconds", value)

    @property
    @pulumi.getter(name="offsetInNanos")
    def offset_in_nanos(self) -> Optional[pulumi.Input[str]]:
        """
        The nanosecond offset converted from ``timeInSeconds``. The valid range is between 0-999999999.
        """
        return pulumi.get(self, "offset_in_nanos")

    @offset_in_nanos.setter
    def offset_in_nanos(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "offset_in_nanos", value)


if not MYPY:
    class AlarmModelAssetPropertyValueArgsDict(TypedDict):
        """
        A structure that contains value information. For more information, see [AssetPropertyValue](https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_AssetPropertyValue.html) in the *API Reference*.
         You must use expressions for all parameters in ``AssetPropertyValue``. The expressions accept literals, operators, functions, references, and substitution templates.
          **Examples**
         +  For literal values, the expressions must contain single quotes. For example, the value for the ``quality`` parameter can be ``'GOOD'``.
          +  For references, you must specify either variables or input values. For example, the value for the ``quality`` parameter can be ``$input.TemperatureInput.sensorData.quality``.
          
         For more information, see [Expressions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html) in the *Developer Guide*.
        """
        value: pulumi.Input['AlarmModelAssetPropertyVariantArgsDict']
        """
        The value to send to an asset property.
        """
        quality: NotRequired[pulumi.Input[str]]
        """
        The quality of the asset property value. The value must be ``'GOOD'``, ``'BAD'``, or ``'UNCERTAIN'``.
        """
        timestamp: NotRequired[pulumi.Input['AlarmModelAssetPropertyTimestampArgsDict']]
        """
        The timestamp associated with the asset property value. The default is the current event time.
        """
elif False:
    AlarmModelAssetPropertyValueArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AlarmModelAssetPropertyValueArgs:
    def __init__(__self__, *,
                 value: pulumi.Input['AlarmModelAssetPropertyVariantArgs'],
                 quality: Optional[pulumi.Input[str]] = None,
                 timestamp: Optional[pulumi.Input['AlarmModelAssetPropertyTimestampArgs']] = None):
        """
        A structure that contains value information. For more information, see [AssetPropertyValue](https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_AssetPropertyValue.html) in the *API Reference*.
         You must use expressions for all parameters in ``AssetPropertyValue``. The expressions accept literals, operators, functions, references, and substitution templates.
          **Examples**
         +  For literal values, the expressions must contain single quotes. For example, the value for the ``quality`` parameter can be ``'GOOD'``.
          +  For references, you must specify either variables or input values. For example, the value for the ``quality`` parameter can be ``$input.TemperatureInput.sensorData.quality``.
          
         For more information, see [Expressions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html) in the *Developer Guide*.
        :param pulumi.Input['AlarmModelAssetPropertyVariantArgs'] value: The value to send to an asset property.
        :param pulumi.Input[str] quality: The quality of the asset property value. The value must be ``'GOOD'``, ``'BAD'``, or ``'UNCERTAIN'``.
        :param pulumi.Input['AlarmModelAssetPropertyTimestampArgs'] timestamp: The timestamp associated with the asset property value. The default is the current event time.
        """
        pulumi.set(__self__, "value", value)
        if quality is not None:
            pulumi.set(__self__, "quality", quality)
        if timestamp is not None:
            pulumi.set(__self__, "timestamp", timestamp)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input['AlarmModelAssetPropertyVariantArgs']:
        """
        The value to send to an asset property.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input['AlarmModelAssetPropertyVariantArgs']):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter
    def quality(self) -> Optional[pulumi.Input[str]]:
        """
        The quality of the asset property value. The value must be ``'GOOD'``, ``'BAD'``, or ``'UNCERTAIN'``.
        """
        return pulumi.get(self, "quality")

    @quality.setter
    def quality(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "quality", value)

    @property
    @pulumi.getter
    def timestamp(self) -> Optional[pulumi.Input['AlarmModelAssetPropertyTimestampArgs']]:
        """
        The timestamp associated with the asset property value. The default is the current event time.
        """
        return pulumi.get(self, "timestamp")

    @timestamp.setter
    def timestamp(self, value: Optional[pulumi.Input['AlarmModelAssetPropertyTimestampArgs']]):
        pulumi.set(self, "timestamp", value)


if not MYPY:
    class AlarmModelAssetPropertyVariantArgsDict(TypedDict):
        """
        A structure that contains an asset property value. For more information, see [Variant](https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_Variant.html) in the *API Reference*.
         You must use expressions for all parameters in ``AssetPropertyVariant``. The expressions accept literals, operators, functions, references, and substitution templates.
          **Examples**
         +  For literal values, the expressions must contain single quotes. For example, the value for the ``integerValue`` parameter can be ``'100'``.
          +  For references, you must specify either variables or parameters. For example, the value for the ``booleanValue`` parameter can be ``$variable.offline``.
          +  For a substitution template, you must use ``${}``, and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates. 
         In the following example, the value for the ``doubleValue`` parameter uses a substitution template. 
          ``'${$input.TemperatureInput.sensorData.temperature * 6 / 5 + 32}'`` 
          
         For more information, see [Expressions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html) in the *Developer Guide*.
         You must specify one of the following value types, depending on the ``dataType`` of the specified asset property. For more information, see [AssetProperty](https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_AssetProperty.html) in the *API Reference*.
        """
        boolean_value: NotRequired[pulumi.Input[str]]
        """
        The asset property value is a Boolean value that must be ``'TRUE'`` or ``'FALSE'``. You must use an expression, and the evaluated result should be a Boolean value.
        """
        double_value: NotRequired[pulumi.Input[str]]
        """
        The asset property value is a double. You must use an expression, and the evaluated result should be a double.
        """
        integer_value: NotRequired[pulumi.Input[str]]
        """
        The asset property value is an integer. You must use an expression, and the evaluated result should be an integer.
        """
        string_value: NotRequired[pulumi.Input[str]]
        """
        The asset property value is a string. You must use an expression, and the evaluated result should be a string.
        """
elif False:
    AlarmModelAssetPropertyVariantArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AlarmModelAssetPropertyVariantArgs:
    def __init__(__self__, *,
                 boolean_value: Optional[pulumi.Input[str]] = None,
                 double_value: Optional[pulumi.Input[str]] = None,
                 integer_value: Optional[pulumi.Input[str]] = None,
                 string_value: Optional[pulumi.Input[str]] = None):
        """
        A structure that contains an asset property value. For more information, see [Variant](https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_Variant.html) in the *API Reference*.
         You must use expressions for all parameters in ``AssetPropertyVariant``. The expressions accept literals, operators, functions, references, and substitution templates.
          **Examples**
         +  For literal values, the expressions must contain single quotes. For example, the value for the ``integerValue`` parameter can be ``'100'``.
          +  For references, you must specify either variables or parameters. For example, the value for the ``booleanValue`` parameter can be ``$variable.offline``.
          +  For a substitution template, you must use ``${}``, and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates. 
         In the following example, the value for the ``doubleValue`` parameter uses a substitution template. 
          ``'${$input.TemperatureInput.sensorData.temperature * 6 / 5 + 32}'`` 
          
         For more information, see [Expressions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html) in the *Developer Guide*.
         You must specify one of the following value types, depending on the ``dataType`` of the specified asset property. For more information, see [AssetProperty](https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_AssetProperty.html) in the *API Reference*.
        :param pulumi.Input[str] boolean_value: The asset property value is a Boolean value that must be ``'TRUE'`` or ``'FALSE'``. You must use an expression, and the evaluated result should be a Boolean value.
        :param pulumi.Input[str] double_value: The asset property value is a double. You must use an expression, and the evaluated result should be a double.
        :param pulumi.Input[str] integer_value: The asset property value is an integer. You must use an expression, and the evaluated result should be an integer.
        :param pulumi.Input[str] string_value: The asset property value is a string. You must use an expression, and the evaluated result should be a string.
        """
        if boolean_value is not None:
            pulumi.set(__self__, "boolean_value", boolean_value)
        if double_value is not None:
            pulumi.set(__self__, "double_value", double_value)
        if integer_value is not None:
            pulumi.set(__self__, "integer_value", integer_value)
        if string_value is not None:
            pulumi.set(__self__, "string_value", string_value)

    @property
    @pulumi.getter(name="booleanValue")
    def boolean_value(self) -> Optional[pulumi.Input[str]]:
        """
        The asset property value is a Boolean value that must be ``'TRUE'`` or ``'FALSE'``. You must use an expression, and the evaluated result should be a Boolean value.
        """
        return pulumi.get(self, "boolean_value")

    @boolean_value.setter
    def boolean_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "boolean_value", value)

    @property
    @pulumi.getter(name="doubleValue")
    def double_value(self) -> Optional[pulumi.Input[str]]:
        """
        The asset property value is a double. You must use an expression, and the evaluated result should be a double.
        """
        return pulumi.get(self, "double_value")

    @double_value.setter
    def double_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "double_value", value)

    @property
    @pulumi.getter(name="integerValue")
    def integer_value(self) -> Optional[pulumi.Input[str]]:
        """
        The asset property value is an integer. You must use an expression, and the evaluated result should be an integer.
        """
        return pulumi.get(self, "integer_value")

    @integer_value.setter
    def integer_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "integer_value", value)

    @property
    @pulumi.getter(name="stringValue")
    def string_value(self) -> Optional[pulumi.Input[str]]:
        """
        The asset property value is a string. You must use an expression, and the evaluated result should be a string.
        """
        return pulumi.get(self, "string_value")

    @string_value.setter
    def string_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "string_value", value)


if not MYPY:
    class AlarmModelDynamoDBv2ArgsDict(TypedDict):
        """
        Defines an action to write to the Amazon DynamoDB table that you created. The default action payload contains all the information about the detector model instance and the event that triggered the action. You can customize the [payload](https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html). A separate column of the DynamoDB table receives one attribute-value pair in the payload that you specify.
         You must use expressions for all parameters in ``DynamoDBv2Action``. The expressions accept literals, operators, functions, references, and substitution templates.
          **Examples**
         +  For literal values, the expressions must contain single quotes. For example, the value for the ``tableName`` parameter can be ``'GreenhouseTemperatureTable'``.
          +  For references, you must specify either variables or input values. For example, the value for the ``tableName`` parameter can be ``$variable.ddbtableName``.
          +  For a substitution template, you must use ``${}``, and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.
         In the following example, the value for the ``contentExpression`` parameter in ``Payload`` uses a substitution template. 
          ``'{\\"sensorID\\": \\"${$input.GreenhouseInput.sensor_id}\\", \\"temperature\\": \\"${$input.GreenhouseInput.temperature * 9 / 5 + 32}\\"}'`` 
          +  For a string concatenation, you must use ``+``. A string concatenation can also contain a combination of literals, operators, functions, references, and substitution templates.
         In the following example, the value for the ``tableName`` parameter uses a string concatenation. 
          ``'GreenhouseTemperatureTable ' + $input.GreenhouseInput.date`` 
          
         For more information, see [Expressions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html) in the *Developer Guide*.
         The value for the ``type`` parameter in ``Payload`` must be ``JSON``.
        """
        table_name: pulumi.Input[str]
        """
        The name of the DynamoDB table.
        """
        payload: NotRequired[pulumi.Input['AlarmModelPayloadArgsDict']]
        """
        Information needed to configure the payload.
         By default, ITE generates a standard payload in JSON for any action. This action payload contains all attribute-value pairs that have the information about the detector model instance and the event triggered the action. To configure the action payload, you can use ``contentExpression``.
        """
elif False:
    AlarmModelDynamoDBv2ArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AlarmModelDynamoDBv2Args:
    def __init__(__self__, *,
                 table_name: pulumi.Input[str],
                 payload: Optional[pulumi.Input['AlarmModelPayloadArgs']] = None):
        """
        Defines an action to write to the Amazon DynamoDB table that you created. The default action payload contains all the information about the detector model instance and the event that triggered the action. You can customize the [payload](https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html). A separate column of the DynamoDB table receives one attribute-value pair in the payload that you specify.
         You must use expressions for all parameters in ``DynamoDBv2Action``. The expressions accept literals, operators, functions, references, and substitution templates.
          **Examples**
         +  For literal values, the expressions must contain single quotes. For example, the value for the ``tableName`` parameter can be ``'GreenhouseTemperatureTable'``.
          +  For references, you must specify either variables or input values. For example, the value for the ``tableName`` parameter can be ``$variable.ddbtableName``.
          +  For a substitution template, you must use ``${}``, and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.
         In the following example, the value for the ``contentExpression`` parameter in ``Payload`` uses a substitution template. 
          ``'{\\"sensorID\\": \\"${$input.GreenhouseInput.sensor_id}\\", \\"temperature\\": \\"${$input.GreenhouseInput.temperature * 9 / 5 + 32}\\"}'`` 
          +  For a string concatenation, you must use ``+``. A string concatenation can also contain a combination of literals, operators, functions, references, and substitution templates.
         In the following example, the value for the ``tableName`` parameter uses a string concatenation. 
          ``'GreenhouseTemperatureTable ' + $input.GreenhouseInput.date`` 
          
         For more information, see [Expressions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html) in the *Developer Guide*.
         The value for the ``type`` parameter in ``Payload`` must be ``JSON``.
        :param pulumi.Input[str] table_name: The name of the DynamoDB table.
        :param pulumi.Input['AlarmModelPayloadArgs'] payload: Information needed to configure the payload.
                By default, ITE generates a standard payload in JSON for any action. This action payload contains all attribute-value pairs that have the information about the detector model instance and the event triggered the action. To configure the action payload, you can use ``contentExpression``.
        """
        pulumi.set(__self__, "table_name", table_name)
        if payload is not None:
            pulumi.set(__self__, "payload", payload)

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> pulumi.Input[str]:
        """
        The name of the DynamoDB table.
        """
        return pulumi.get(self, "table_name")

    @table_name.setter
    def table_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "table_name", value)

    @property
    @pulumi.getter
    def payload(self) -> Optional[pulumi.Input['AlarmModelPayloadArgs']]:
        """
        Information needed to configure the payload.
         By default, ITE generates a standard payload in JSON for any action. This action payload contains all attribute-value pairs that have the information about the detector model instance and the event triggered the action. To configure the action payload, you can use ``contentExpression``.
        """
        return pulumi.get(self, "payload")

    @payload.setter
    def payload(self, value: Optional[pulumi.Input['AlarmModelPayloadArgs']]):
        pulumi.set(self, "payload", value)


if not MYPY:
    class AlarmModelDynamoDbArgsDict(TypedDict):
        """
        Defines an action to write to the Amazon DynamoDB table that you created. The standard action payload contains all the information about the detector model instance and the event that triggered the action. You can customize the [payload](https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html). One column of the DynamoDB table receives all attribute-value pairs in the payload that you specify.
         You must use expressions for all parameters in ``DynamoDBAction``. The expressions accept literals, operators, functions, references, and substitution templates.
          **Examples**
         +  For literal values, the expressions must contain single quotes. For example, the value for the ``hashKeyType`` parameter can be ``'STRING'``.
          +  For references, you must specify either variables or input values. For example, the value for the ``hashKeyField`` parameter can be ``$input.GreenhouseInput.name``.
          +  For a substitution template, you must use ``${}``, and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.
         In the following example, the value for the ``hashKeyValue`` parameter uses a substitution template. 
          ``'${$input.GreenhouseInput.temperature * 6 / 5 + 32} in Fahrenheit'`` 
          +  For a string concatenation, you must use ``+``. A string concatenation can also contain a combination of literals, operators, functions, references, and substitution templates.
         In the following example, the value for the ``tableName`` parameter uses a string concatenation. 
          ``'GreenhouseTemperatureTable ' + $input.GreenhouseInput.date`` 
          
         For more information, see [Expressions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html) in the *Developer Guide*.
         If the defined payload type is a string, ``DynamoDBAction`` writes non-JSON data to the DynamoDB table as binary data. The DynamoDB console displays the data as Base64-encoded text. The value for the ``payloadField`` parameter is ``<payload-field>_raw``.
        """
        hash_key_field: pulumi.Input[str]
        """
        The name of the hash key (also called the partition key). The ``hashKeyField`` value must match the partition key of the target DynamoDB table.
        """
        hash_key_value: pulumi.Input[str]
        """
        The value of the hash key (also called the partition key).
        """
        table_name: pulumi.Input[str]
        """
        The name of the DynamoDB table. The ``tableName`` value must match the table name of the target DynamoDB table.
        """
        hash_key_type: NotRequired[pulumi.Input[str]]
        """
        The data type for the hash key (also called the partition key). You can specify the following values:
          +   ``'STRING'`` - The hash key is a string.
          +   ``'NUMBER'`` - The hash key is a number.
          
         If you don't specify ``hashKeyType``, the default value is ``'STRING'``.
        """
        operation: NotRequired[pulumi.Input[str]]
        """
        The type of operation to perform. You can specify the following values: 
          +   ``'INSERT'`` - Insert data as a new item into the DynamoDB table. This item uses the specified hash key as a partition key. If you specified a range key, the item uses the range key as a sort key.
          +   ``'UPDATE'`` - Update an existing item of the DynamoDB table with new data. This item's partition key must match the specified hash key. If you specified a range key, the range key must match the item's sort key.
          +   ``'DELETE'`` - Delete an existing item of the DynamoDB table. This item's partition key must match the specified hash key. If you specified a range key, the range key must match the item's sort key.
          
         If you don't specify this parameter, ITE triggers the ``'INSERT'`` operation.
        """
        payload: NotRequired[pulumi.Input['AlarmModelPayloadArgsDict']]
        """
        Information needed to configure the payload.
         By default, ITE generates a standard payload in JSON for any action. This action payload contains all attribute-value pairs that have the information about the detector model instance and the event triggered the action. To configure the action payload, you can use ``contentExpression``.
        """
        payload_field: NotRequired[pulumi.Input[str]]
        """
        The name of the DynamoDB column that receives the action payload.
         If you don't specify this parameter, the name of the DynamoDB column is ``payload``.
        """
        range_key_field: NotRequired[pulumi.Input[str]]
        """
        The name of the range key (also called the sort key). The ``rangeKeyField`` value must match the sort key of the target DynamoDB table.
        """
        range_key_type: NotRequired[pulumi.Input[str]]
        """
        The data type for the range key (also called the sort key), You can specify the following values:
          +   ``'STRING'`` - The range key is a string.
          +   ``'NUMBER'`` - The range key is number.
          
         If you don't specify ``rangeKeyField``, the default value is ``'STRING'``.
        """
        range_key_value: NotRequired[pulumi.Input[str]]
        """
        The value of the range key (also called the sort key).
        """
elif False:
    AlarmModelDynamoDbArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AlarmModelDynamoDbArgs:
    def __init__(__self__, *,
                 hash_key_field: pulumi.Input[str],
                 hash_key_value: pulumi.Input[str],
                 table_name: pulumi.Input[str],
                 hash_key_type: Optional[pulumi.Input[str]] = None,
                 operation: Optional[pulumi.Input[str]] = None,
                 payload: Optional[pulumi.Input['AlarmModelPayloadArgs']] = None,
                 payload_field: Optional[pulumi.Input[str]] = None,
                 range_key_field: Optional[pulumi.Input[str]] = None,
                 range_key_type: Optional[pulumi.Input[str]] = None,
                 range_key_value: Optional[pulumi.Input[str]] = None):
        """
        Defines an action to write to the Amazon DynamoDB table that you created. The standard action payload contains all the information about the detector model instance and the event that triggered the action. You can customize the [payload](https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html). One column of the DynamoDB table receives all attribute-value pairs in the payload that you specify.
         You must use expressions for all parameters in ``DynamoDBAction``. The expressions accept literals, operators, functions, references, and substitution templates.
          **Examples**
         +  For literal values, the expressions must contain single quotes. For example, the value for the ``hashKeyType`` parameter can be ``'STRING'``.
          +  For references, you must specify either variables or input values. For example, the value for the ``hashKeyField`` parameter can be ``$input.GreenhouseInput.name``.
          +  For a substitution template, you must use ``${}``, and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.
         In the following example, the value for the ``hashKeyValue`` parameter uses a substitution template. 
          ``'${$input.GreenhouseInput.temperature * 6 / 5 + 32} in Fahrenheit'`` 
          +  For a string concatenation, you must use ``+``. A string concatenation can also contain a combination of literals, operators, functions, references, and substitution templates.
         In the following example, the value for the ``tableName`` parameter uses a string concatenation. 
          ``'GreenhouseTemperatureTable ' + $input.GreenhouseInput.date`` 
          
         For more information, see [Expressions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html) in the *Developer Guide*.
         If the defined payload type is a string, ``DynamoDBAction`` writes non-JSON data to the DynamoDB table as binary data. The DynamoDB console displays the data as Base64-encoded text. The value for the ``payloadField`` parameter is ``<payload-field>_raw``.
        :param pulumi.Input[str] hash_key_field: The name of the hash key (also called the partition key). The ``hashKeyField`` value must match the partition key of the target DynamoDB table.
        :param pulumi.Input[str] hash_key_value: The value of the hash key (also called the partition key).
        :param pulumi.Input[str] table_name: The name of the DynamoDB table. The ``tableName`` value must match the table name of the target DynamoDB table.
        :param pulumi.Input[str] hash_key_type: The data type for the hash key (also called the partition key). You can specify the following values:
                 +   ``'STRING'`` - The hash key is a string.
                 +   ``'NUMBER'`` - The hash key is a number.
                 
                If you don't specify ``hashKeyType``, the default value is ``'STRING'``.
        :param pulumi.Input[str] operation: The type of operation to perform. You can specify the following values: 
                 +   ``'INSERT'`` - Insert data as a new item into the DynamoDB table. This item uses the specified hash key as a partition key. If you specified a range key, the item uses the range key as a sort key.
                 +   ``'UPDATE'`` - Update an existing item of the DynamoDB table with new data. This item's partition key must match the specified hash key. If you specified a range key, the range key must match the item's sort key.
                 +   ``'DELETE'`` - Delete an existing item of the DynamoDB table. This item's partition key must match the specified hash key. If you specified a range key, the range key must match the item's sort key.
                 
                If you don't specify this parameter, ITE triggers the ``'INSERT'`` operation.
        :param pulumi.Input['AlarmModelPayloadArgs'] payload: Information needed to configure the payload.
                By default, ITE generates a standard payload in JSON for any action. This action payload contains all attribute-value pairs that have the information about the detector model instance and the event triggered the action. To configure the action payload, you can use ``contentExpression``.
        :param pulumi.Input[str] payload_field: The name of the DynamoDB column that receives the action payload.
                If you don't specify this parameter, the name of the DynamoDB column is ``payload``.
        :param pulumi.Input[str] range_key_field: The name of the range key (also called the sort key). The ``rangeKeyField`` value must match the sort key of the target DynamoDB table.
        :param pulumi.Input[str] range_key_type: The data type for the range key (also called the sort key), You can specify the following values:
                 +   ``'STRING'`` - The range key is a string.
                 +   ``'NUMBER'`` - The range key is number.
                 
                If you don't specify ``rangeKeyField``, the default value is ``'STRING'``.
        :param pulumi.Input[str] range_key_value: The value of the range key (also called the sort key).
        """
        pulumi.set(__self__, "hash_key_field", hash_key_field)
        pulumi.set(__self__, "hash_key_value", hash_key_value)
        pulumi.set(__self__, "table_name", table_name)
        if hash_key_type is not None:
            pulumi.set(__self__, "hash_key_type", hash_key_type)
        if operation is not None:
            pulumi.set(__self__, "operation", operation)
        if payload is not None:
            pulumi.set(__self__, "payload", payload)
        if payload_field is not None:
            pulumi.set(__self__, "payload_field", payload_field)
        if range_key_field is not None:
            pulumi.set(__self__, "range_key_field", range_key_field)
        if range_key_type is not None:
            pulumi.set(__self__, "range_key_type", range_key_type)
        if range_key_value is not None:
            pulumi.set(__self__, "range_key_value", range_key_value)

    @property
    @pulumi.getter(name="hashKeyField")
    def hash_key_field(self) -> pulumi.Input[str]:
        """
        The name of the hash key (also called the partition key). The ``hashKeyField`` value must match the partition key of the target DynamoDB table.
        """
        return pulumi.get(self, "hash_key_field")

    @hash_key_field.setter
    def hash_key_field(self, value: pulumi.Input[str]):
        pulumi.set(self, "hash_key_field", value)

    @property
    @pulumi.getter(name="hashKeyValue")
    def hash_key_value(self) -> pulumi.Input[str]:
        """
        The value of the hash key (also called the partition key).
        """
        return pulumi.get(self, "hash_key_value")

    @hash_key_value.setter
    def hash_key_value(self, value: pulumi.Input[str]):
        pulumi.set(self, "hash_key_value", value)

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> pulumi.Input[str]:
        """
        The name of the DynamoDB table. The ``tableName`` value must match the table name of the target DynamoDB table.
        """
        return pulumi.get(self, "table_name")

    @table_name.setter
    def table_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "table_name", value)

    @property
    @pulumi.getter(name="hashKeyType")
    def hash_key_type(self) -> Optional[pulumi.Input[str]]:
        """
        The data type for the hash key (also called the partition key). You can specify the following values:
          +   ``'STRING'`` - The hash key is a string.
          +   ``'NUMBER'`` - The hash key is a number.
          
         If you don't specify ``hashKeyType``, the default value is ``'STRING'``.
        """
        return pulumi.get(self, "hash_key_type")

    @hash_key_type.setter
    def hash_key_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hash_key_type", value)

    @property
    @pulumi.getter
    def operation(self) -> Optional[pulumi.Input[str]]:
        """
        The type of operation to perform. You can specify the following values: 
          +   ``'INSERT'`` - Insert data as a new item into the DynamoDB table. This item uses the specified hash key as a partition key. If you specified a range key, the item uses the range key as a sort key.
          +   ``'UPDATE'`` - Update an existing item of the DynamoDB table with new data. This item's partition key must match the specified hash key. If you specified a range key, the range key must match the item's sort key.
          +   ``'DELETE'`` - Delete an existing item of the DynamoDB table. This item's partition key must match the specified hash key. If you specified a range key, the range key must match the item's sort key.
          
         If you don't specify this parameter, ITE triggers the ``'INSERT'`` operation.
        """
        return pulumi.get(self, "operation")

    @operation.setter
    def operation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "operation", value)

    @property
    @pulumi.getter
    def payload(self) -> Optional[pulumi.Input['AlarmModelPayloadArgs']]:
        """
        Information needed to configure the payload.
         By default, ITE generates a standard payload in JSON for any action. This action payload contains all attribute-value pairs that have the information about the detector model instance and the event triggered the action. To configure the action payload, you can use ``contentExpression``.
        """
        return pulumi.get(self, "payload")

    @payload.setter
    def payload(self, value: Optional[pulumi.Input['AlarmModelPayloadArgs']]):
        pulumi.set(self, "payload", value)

    @property
    @pulumi.getter(name="payloadField")
    def payload_field(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the DynamoDB column that receives the action payload.
         If you don't specify this parameter, the name of the DynamoDB column is ``payload``.
        """
        return pulumi.get(self, "payload_field")

    @payload_field.setter
    def payload_field(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "payload_field", value)

    @property
    @pulumi.getter(name="rangeKeyField")
    def range_key_field(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the range key (also called the sort key). The ``rangeKeyField`` value must match the sort key of the target DynamoDB table.
        """
        return pulumi.get(self, "range_key_field")

    @range_key_field.setter
    def range_key_field(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "range_key_field", value)

    @property
    @pulumi.getter(name="rangeKeyType")
    def range_key_type(self) -> Optional[pulumi.Input[str]]:
        """
        The data type for the range key (also called the sort key), You can specify the following values:
          +   ``'STRING'`` - The range key is a string.
          +   ``'NUMBER'`` - The range key is number.
          
         If you don't specify ``rangeKeyField``, the default value is ``'STRING'``.
        """
        return pulumi.get(self, "range_key_type")

    @range_key_type.setter
    def range_key_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "range_key_type", value)

    @property
    @pulumi.getter(name="rangeKeyValue")
    def range_key_value(self) -> Optional[pulumi.Input[str]]:
        """
        The value of the range key (also called the sort key).
        """
        return pulumi.get(self, "range_key_value")

    @range_key_value.setter
    def range_key_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "range_key_value", value)


if not MYPY:
    class AlarmModelFirehoseArgsDict(TypedDict):
        """
        Sends information about the detector model instance and the event that triggered the action to an Amazon Kinesis Data Firehose delivery stream.
        """
        delivery_stream_name: pulumi.Input[str]
        """
        The name of the Kinesis Data Firehose delivery stream where the data is written.
        """
        payload: NotRequired[pulumi.Input['AlarmModelPayloadArgsDict']]
        """
        You can configure the action payload when you send a message to an Amazon Data Firehose delivery stream.
        """
        separator: NotRequired[pulumi.Input[str]]
        """
        A character separator that is used to separate records written to the Kinesis Data Firehose delivery stream. Valid values are: '\\n' (newline), '\\t' (tab), '\\r\\n' (Windows newline), ',' (comma).
        """
elif False:
    AlarmModelFirehoseArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AlarmModelFirehoseArgs:
    def __init__(__self__, *,
                 delivery_stream_name: pulumi.Input[str],
                 payload: Optional[pulumi.Input['AlarmModelPayloadArgs']] = None,
                 separator: Optional[pulumi.Input[str]] = None):
        """
        Sends information about the detector model instance and the event that triggered the action to an Amazon Kinesis Data Firehose delivery stream.
        :param pulumi.Input[str] delivery_stream_name: The name of the Kinesis Data Firehose delivery stream where the data is written.
        :param pulumi.Input['AlarmModelPayloadArgs'] payload: You can configure the action payload when you send a message to an Amazon Data Firehose delivery stream.
        :param pulumi.Input[str] separator: A character separator that is used to separate records written to the Kinesis Data Firehose delivery stream. Valid values are: '\\n' (newline), '\\t' (tab), '\\r\\n' (Windows newline), ',' (comma).
        """
        pulumi.set(__self__, "delivery_stream_name", delivery_stream_name)
        if payload is not None:
            pulumi.set(__self__, "payload", payload)
        if separator is not None:
            pulumi.set(__self__, "separator", separator)

    @property
    @pulumi.getter(name="deliveryStreamName")
    def delivery_stream_name(self) -> pulumi.Input[str]:
        """
        The name of the Kinesis Data Firehose delivery stream where the data is written.
        """
        return pulumi.get(self, "delivery_stream_name")

    @delivery_stream_name.setter
    def delivery_stream_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "delivery_stream_name", value)

    @property
    @pulumi.getter
    def payload(self) -> Optional[pulumi.Input['AlarmModelPayloadArgs']]:
        """
        You can configure the action payload when you send a message to an Amazon Data Firehose delivery stream.
        """
        return pulumi.get(self, "payload")

    @payload.setter
    def payload(self, value: Optional[pulumi.Input['AlarmModelPayloadArgs']]):
        pulumi.set(self, "payload", value)

    @property
    @pulumi.getter
    def separator(self) -> Optional[pulumi.Input[str]]:
        """
        A character separator that is used to separate records written to the Kinesis Data Firehose delivery stream. Valid values are: '\\n' (newline), '\\t' (tab), '\\r\\n' (Windows newline), ',' (comma).
        """
        return pulumi.get(self, "separator")

    @separator.setter
    def separator(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "separator", value)


if not MYPY:
    class AlarmModelInitializationConfigurationArgsDict(TypedDict):
        """
        Specifies the default alarm state. The configuration applies to all alarms that were created based on this alarm model.
        """
        disabled_on_initialization: pulumi.Input[bool]
        """
        The value must be ``TRUE`` or ``FALSE``. If ``FALSE``, all alarm instances created based on the alarm model are activated. The default value is ``TRUE``.
        """
elif False:
    AlarmModelInitializationConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AlarmModelInitializationConfigurationArgs:
    def __init__(__self__, *,
                 disabled_on_initialization: pulumi.Input[bool]):
        """
        Specifies the default alarm state. The configuration applies to all alarms that were created based on this alarm model.
        :param pulumi.Input[bool] disabled_on_initialization: The value must be ``TRUE`` or ``FALSE``. If ``FALSE``, all alarm instances created based on the alarm model are activated. The default value is ``TRUE``.
        """
        pulumi.set(__self__, "disabled_on_initialization", disabled_on_initialization)

    @property
    @pulumi.getter(name="disabledOnInitialization")
    def disabled_on_initialization(self) -> pulumi.Input[bool]:
        """
        The value must be ``TRUE`` or ``FALSE``. If ``FALSE``, all alarm instances created based on the alarm model are activated. The default value is ``TRUE``.
        """
        return pulumi.get(self, "disabled_on_initialization")

    @disabled_on_initialization.setter
    def disabled_on_initialization(self, value: pulumi.Input[bool]):
        pulumi.set(self, "disabled_on_initialization", value)


if not MYPY:
    class AlarmModelIotEventsArgsDict(TypedDict):
        """
        Sends an ITE input, passing in information about the detector model instance and the event that triggered the action.
        """
        input_name: pulumi.Input[str]
        """
        The name of the ITE input where the data is sent.
        """
        payload: NotRequired[pulumi.Input['AlarmModelPayloadArgsDict']]
        """
        You can configure the action payload when you send a message to an ITE input.
        """
elif False:
    AlarmModelIotEventsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AlarmModelIotEventsArgs:
    def __init__(__self__, *,
                 input_name: pulumi.Input[str],
                 payload: Optional[pulumi.Input['AlarmModelPayloadArgs']] = None):
        """
        Sends an ITE input, passing in information about the detector model instance and the event that triggered the action.
        :param pulumi.Input[str] input_name: The name of the ITE input where the data is sent.
        :param pulumi.Input['AlarmModelPayloadArgs'] payload: You can configure the action payload when you send a message to an ITE input.
        """
        pulumi.set(__self__, "input_name", input_name)
        if payload is not None:
            pulumi.set(__self__, "payload", payload)

    @property
    @pulumi.getter(name="inputName")
    def input_name(self) -> pulumi.Input[str]:
        """
        The name of the ITE input where the data is sent.
        """
        return pulumi.get(self, "input_name")

    @input_name.setter
    def input_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "input_name", value)

    @property
    @pulumi.getter
    def payload(self) -> Optional[pulumi.Input['AlarmModelPayloadArgs']]:
        """
        You can configure the action payload when you send a message to an ITE input.
        """
        return pulumi.get(self, "payload")

    @payload.setter
    def payload(self, value: Optional[pulumi.Input['AlarmModelPayloadArgs']]):
        pulumi.set(self, "payload", value)


if not MYPY:
    class AlarmModelIotSiteWiseArgsDict(TypedDict):
        """
        Sends information about the detector model instance and the event that triggered the action to a specified asset property in ITSW.
         You must use expressions for all parameters in ``IotSiteWiseAction``. The expressions accept literals, operators, functions, references, and substitutions templates.
          **Examples**
         +  For literal values, the expressions must contain single quotes. For example, the value for the ``propertyAlias`` parameter can be ``'/company/windfarm/3/turbine/7/temperature'``.
          +  For references, you must specify either variables or input values. For example, the value for the ``assetId`` parameter can be ``$input.TurbineInput.assetId1``.
          +  For a substitution template, you must use ``${}``, and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.
         In the following example, the value for the ``propertyAlias`` parameter uses a substitution template. 
          ``'company/windfarm/${$input.TemperatureInput.sensorData.windfarmID}/turbine/ ${$input.TemperatureInput.sensorData.turbineID}/temperature'`` 
          
         You must specify either ``propertyAlias`` or both ``assetId`` and ``propertyId`` to identify the target asset property in ITSW.
         For more information, see [Expressions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html) in the *Developer Guide*.
        """
        asset_id: NotRequired[pulumi.Input[str]]
        """
        The ID of the asset that has the specified property.
        """
        entry_id: NotRequired[pulumi.Input[str]]
        """
        A unique identifier for this entry. You can use the entry ID to track which data entry causes an error in case of failure. The default is a new unique identifier.
        """
        property_alias: NotRequired[pulumi.Input[str]]
        """
        The alias of the asset property.
        """
        property_id: NotRequired[pulumi.Input[str]]
        """
        The ID of the asset property.
        """
        property_value: NotRequired[pulumi.Input['AlarmModelAssetPropertyValueArgsDict']]
        """
        The value to send to the asset property. This value contains timestamp, quality, and value (TQV) information.
        """
elif False:
    AlarmModelIotSiteWiseArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AlarmModelIotSiteWiseArgs:
    def __init__(__self__, *,
                 asset_id: Optional[pulumi.Input[str]] = None,
                 entry_id: Optional[pulumi.Input[str]] = None,
                 property_alias: Optional[pulumi.Input[str]] = None,
                 property_id: Optional[pulumi.Input[str]] = None,
                 property_value: Optional[pulumi.Input['AlarmModelAssetPropertyValueArgs']] = None):
        """
        Sends information about the detector model instance and the event that triggered the action to a specified asset property in ITSW.
         You must use expressions for all parameters in ``IotSiteWiseAction``. The expressions accept literals, operators, functions, references, and substitutions templates.
          **Examples**
         +  For literal values, the expressions must contain single quotes. For example, the value for the ``propertyAlias`` parameter can be ``'/company/windfarm/3/turbine/7/temperature'``.
          +  For references, you must specify either variables or input values. For example, the value for the ``assetId`` parameter can be ``$input.TurbineInput.assetId1``.
          +  For a substitution template, you must use ``${}``, and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.
         In the following example, the value for the ``propertyAlias`` parameter uses a substitution template. 
          ``'company/windfarm/${$input.TemperatureInput.sensorData.windfarmID}/turbine/ ${$input.TemperatureInput.sensorData.turbineID}/temperature'`` 
          
         You must specify either ``propertyAlias`` or both ``assetId`` and ``propertyId`` to identify the target asset property in ITSW.
         For more information, see [Expressions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html) in the *Developer Guide*.
        :param pulumi.Input[str] asset_id: The ID of the asset that has the specified property.
        :param pulumi.Input[str] entry_id: A unique identifier for this entry. You can use the entry ID to track which data entry causes an error in case of failure. The default is a new unique identifier.
        :param pulumi.Input[str] property_alias: The alias of the asset property.
        :param pulumi.Input[str] property_id: The ID of the asset property.
        :param pulumi.Input['AlarmModelAssetPropertyValueArgs'] property_value: The value to send to the asset property. This value contains timestamp, quality, and value (TQV) information.
        """
        if asset_id is not None:
            pulumi.set(__self__, "asset_id", asset_id)
        if entry_id is not None:
            pulumi.set(__self__, "entry_id", entry_id)
        if property_alias is not None:
            pulumi.set(__self__, "property_alias", property_alias)
        if property_id is not None:
            pulumi.set(__self__, "property_id", property_id)
        if property_value is not None:
            pulumi.set(__self__, "property_value", property_value)

    @property
    @pulumi.getter(name="assetId")
    def asset_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the asset that has the specified property.
        """
        return pulumi.get(self, "asset_id")

    @asset_id.setter
    def asset_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "asset_id", value)

    @property
    @pulumi.getter(name="entryId")
    def entry_id(self) -> Optional[pulumi.Input[str]]:
        """
        A unique identifier for this entry. You can use the entry ID to track which data entry causes an error in case of failure. The default is a new unique identifier.
        """
        return pulumi.get(self, "entry_id")

    @entry_id.setter
    def entry_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "entry_id", value)

    @property
    @pulumi.getter(name="propertyAlias")
    def property_alias(self) -> Optional[pulumi.Input[str]]:
        """
        The alias of the asset property.
        """
        return pulumi.get(self, "property_alias")

    @property_alias.setter
    def property_alias(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "property_alias", value)

    @property
    @pulumi.getter(name="propertyId")
    def property_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the asset property.
        """
        return pulumi.get(self, "property_id")

    @property_id.setter
    def property_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "property_id", value)

    @property
    @pulumi.getter(name="propertyValue")
    def property_value(self) -> Optional[pulumi.Input['AlarmModelAssetPropertyValueArgs']]:
        """
        The value to send to the asset property. This value contains timestamp, quality, and value (TQV) information.
        """
        return pulumi.get(self, "property_value")

    @property_value.setter
    def property_value(self, value: Optional[pulumi.Input['AlarmModelAssetPropertyValueArgs']]):
        pulumi.set(self, "property_value", value)


if not MYPY:
    class AlarmModelIotTopicPublishArgsDict(TypedDict):
        """
        Information required to publish the MQTT message through the IoT message broker.
        """
        mqtt_topic: pulumi.Input[str]
        """
        The MQTT topic of the message. You can use a string expression that includes variables (``$variable.<variable-name>``) and input values (``$input.<input-name>.<path-to-datum>``) as the topic string.
        """
        payload: NotRequired[pulumi.Input['AlarmModelPayloadArgsDict']]
        """
        You can configure the action payload when you publish a message to an IoTCore topic.
        """
elif False:
    AlarmModelIotTopicPublishArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AlarmModelIotTopicPublishArgs:
    def __init__(__self__, *,
                 mqtt_topic: pulumi.Input[str],
                 payload: Optional[pulumi.Input['AlarmModelPayloadArgs']] = None):
        """
        Information required to publish the MQTT message through the IoT message broker.
        :param pulumi.Input[str] mqtt_topic: The MQTT topic of the message. You can use a string expression that includes variables (``$variable.<variable-name>``) and input values (``$input.<input-name>.<path-to-datum>``) as the topic string.
        :param pulumi.Input['AlarmModelPayloadArgs'] payload: You can configure the action payload when you publish a message to an IoTCore topic.
        """
        pulumi.set(__self__, "mqtt_topic", mqtt_topic)
        if payload is not None:
            pulumi.set(__self__, "payload", payload)

    @property
    @pulumi.getter(name="mqttTopic")
    def mqtt_topic(self) -> pulumi.Input[str]:
        """
        The MQTT topic of the message. You can use a string expression that includes variables (``$variable.<variable-name>``) and input values (``$input.<input-name>.<path-to-datum>``) as the topic string.
        """
        return pulumi.get(self, "mqtt_topic")

    @mqtt_topic.setter
    def mqtt_topic(self, value: pulumi.Input[str]):
        pulumi.set(self, "mqtt_topic", value)

    @property
    @pulumi.getter
    def payload(self) -> Optional[pulumi.Input['AlarmModelPayloadArgs']]:
        """
        You can configure the action payload when you publish a message to an IoTCore topic.
        """
        return pulumi.get(self, "payload")

    @payload.setter
    def payload(self, value: Optional[pulumi.Input['AlarmModelPayloadArgs']]):
        pulumi.set(self, "payload", value)


if not MYPY:
    class AlarmModelLambdaArgsDict(TypedDict):
        """
        Calls a Lambda function, passing in information about the detector model instance and the event that triggered the action.
        """
        function_arn: pulumi.Input[str]
        """
        The ARN of the Lambda function that is executed.
        """
        payload: NotRequired[pulumi.Input['AlarmModelPayloadArgsDict']]
        """
        You can configure the action payload when you send a message to a Lambda function.
        """
elif False:
    AlarmModelLambdaArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AlarmModelLambdaArgs:
    def __init__(__self__, *,
                 function_arn: pulumi.Input[str],
                 payload: Optional[pulumi.Input['AlarmModelPayloadArgs']] = None):
        """
        Calls a Lambda function, passing in information about the detector model instance and the event that triggered the action.
        :param pulumi.Input[str] function_arn: The ARN of the Lambda function that is executed.
        :param pulumi.Input['AlarmModelPayloadArgs'] payload: You can configure the action payload when you send a message to a Lambda function.
        """
        pulumi.set(__self__, "function_arn", function_arn)
        if payload is not None:
            pulumi.set(__self__, "payload", payload)

    @property
    @pulumi.getter(name="functionArn")
    def function_arn(self) -> pulumi.Input[str]:
        """
        The ARN of the Lambda function that is executed.
        """
        return pulumi.get(self, "function_arn")

    @function_arn.setter
    def function_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "function_arn", value)

    @property
    @pulumi.getter
    def payload(self) -> Optional[pulumi.Input['AlarmModelPayloadArgs']]:
        """
        You can configure the action payload when you send a message to a Lambda function.
        """
        return pulumi.get(self, "payload")

    @payload.setter
    def payload(self, value: Optional[pulumi.Input['AlarmModelPayloadArgs']]):
        pulumi.set(self, "payload", value)


if not MYPY:
    class AlarmModelPayloadArgsDict(TypedDict):
        """
        Information needed to configure the payload.
         By default, ITE generates a standard payload in JSON for any action. This action payload contains all attribute-value pairs that have the information about the detector model instance and the event triggered the action. To configure the action payload, you can use ``contentExpression``.
        """
        content_expression: pulumi.Input[str]
        """
        The content of the payload. You can use a string expression that includes quoted strings (``'<string>'``), variables (``$variable.<variable-name>``), input values (``$input.<input-name>.<path-to-datum>``), string concatenations, and quoted strings that contain ``${}`` as the content. The recommended maximum size of a content expression is 1 KB.
        """
        type: pulumi.Input[str]
        """
        The value of the payload type can be either ``STRING`` or ``JSON``.
        """
elif False:
    AlarmModelPayloadArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AlarmModelPayloadArgs:
    def __init__(__self__, *,
                 content_expression: pulumi.Input[str],
                 type: pulumi.Input[str]):
        """
        Information needed to configure the payload.
         By default, ITE generates a standard payload in JSON for any action. This action payload contains all attribute-value pairs that have the information about the detector model instance and the event triggered the action. To configure the action payload, you can use ``contentExpression``.
        :param pulumi.Input[str] content_expression: The content of the payload. You can use a string expression that includes quoted strings (``'<string>'``), variables (``$variable.<variable-name>``), input values (``$input.<input-name>.<path-to-datum>``), string concatenations, and quoted strings that contain ``${}`` as the content. The recommended maximum size of a content expression is 1 KB.
        :param pulumi.Input[str] type: The value of the payload type can be either ``STRING`` or ``JSON``.
        """
        pulumi.set(__self__, "content_expression", content_expression)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="contentExpression")
    def content_expression(self) -> pulumi.Input[str]:
        """
        The content of the payload. You can use a string expression that includes quoted strings (``'<string>'``), variables (``$variable.<variable-name>``), input values (``$input.<input-name>.<path-to-datum>``), string concatenations, and quoted strings that contain ``${}`` as the content. The recommended maximum size of a content expression is 1 KB.
        """
        return pulumi.get(self, "content_expression")

    @content_expression.setter
    def content_expression(self, value: pulumi.Input[str]):
        pulumi.set(self, "content_expression", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The value of the payload type can be either ``STRING`` or ``JSON``.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)


if not MYPY:
    class AlarmModelSimpleRuleArgsDict(TypedDict):
        """
        A rule that compares an input property value to a threshold value with a comparison operator.
        """
        comparison_operator: pulumi.Input['AlarmModelSimpleRuleComparisonOperator']
        """
        The comparison operator.
        """
        input_property: pulumi.Input[str]
        """
        The value on the left side of the comparison operator. You can specify an ITE input attribute as an input property.
        """
        threshold: pulumi.Input[str]
        """
        The value on the right side of the comparison operator. You can enter a number or specify an ITE input attribute.
        """
elif False:
    AlarmModelSimpleRuleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AlarmModelSimpleRuleArgs:
    def __init__(__self__, *,
                 comparison_operator: pulumi.Input['AlarmModelSimpleRuleComparisonOperator'],
                 input_property: pulumi.Input[str],
                 threshold: pulumi.Input[str]):
        """
        A rule that compares an input property value to a threshold value with a comparison operator.
        :param pulumi.Input['AlarmModelSimpleRuleComparisonOperator'] comparison_operator: The comparison operator.
        :param pulumi.Input[str] input_property: The value on the left side of the comparison operator. You can specify an ITE input attribute as an input property.
        :param pulumi.Input[str] threshold: The value on the right side of the comparison operator. You can enter a number or specify an ITE input attribute.
        """
        pulumi.set(__self__, "comparison_operator", comparison_operator)
        pulumi.set(__self__, "input_property", input_property)
        pulumi.set(__self__, "threshold", threshold)

    @property
    @pulumi.getter(name="comparisonOperator")
    def comparison_operator(self) -> pulumi.Input['AlarmModelSimpleRuleComparisonOperator']:
        """
        The comparison operator.
        """
        return pulumi.get(self, "comparison_operator")

    @comparison_operator.setter
    def comparison_operator(self, value: pulumi.Input['AlarmModelSimpleRuleComparisonOperator']):
        pulumi.set(self, "comparison_operator", value)

    @property
    @pulumi.getter(name="inputProperty")
    def input_property(self) -> pulumi.Input[str]:
        """
        The value on the left side of the comparison operator. You can specify an ITE input attribute as an input property.
        """
        return pulumi.get(self, "input_property")

    @input_property.setter
    def input_property(self, value: pulumi.Input[str]):
        pulumi.set(self, "input_property", value)

    @property
    @pulumi.getter
    def threshold(self) -> pulumi.Input[str]:
        """
        The value on the right side of the comparison operator. You can enter a number or specify an ITE input attribute.
        """
        return pulumi.get(self, "threshold")

    @threshold.setter
    def threshold(self, value: pulumi.Input[str]):
        pulumi.set(self, "threshold", value)


if not MYPY:
    class AlarmModelSnsArgsDict(TypedDict):
        """
        Information required to publish the Amazon SNS message.
        """
        target_arn: pulumi.Input[str]
        """
        The ARN of the Amazon SNS target where the message is sent.
        """
        payload: NotRequired[pulumi.Input['AlarmModelPayloadArgsDict']]
        """
        You can configure the action payload when you send a message as an Amazon SNS push notification.
        """
elif False:
    AlarmModelSnsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AlarmModelSnsArgs:
    def __init__(__self__, *,
                 target_arn: pulumi.Input[str],
                 payload: Optional[pulumi.Input['AlarmModelPayloadArgs']] = None):
        """
        Information required to publish the Amazon SNS message.
        :param pulumi.Input[str] target_arn: The ARN of the Amazon SNS target where the message is sent.
        :param pulumi.Input['AlarmModelPayloadArgs'] payload: You can configure the action payload when you send a message as an Amazon SNS push notification.
        """
        pulumi.set(__self__, "target_arn", target_arn)
        if payload is not None:
            pulumi.set(__self__, "payload", payload)

    @property
    @pulumi.getter(name="targetArn")
    def target_arn(self) -> pulumi.Input[str]:
        """
        The ARN of the Amazon SNS target where the message is sent.
        """
        return pulumi.get(self, "target_arn")

    @target_arn.setter
    def target_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "target_arn", value)

    @property
    @pulumi.getter
    def payload(self) -> Optional[pulumi.Input['AlarmModelPayloadArgs']]:
        """
        You can configure the action payload when you send a message as an Amazon SNS push notification.
        """
        return pulumi.get(self, "payload")

    @payload.setter
    def payload(self, value: Optional[pulumi.Input['AlarmModelPayloadArgs']]):
        pulumi.set(self, "payload", value)


if not MYPY:
    class AlarmModelSqsArgsDict(TypedDict):
        """
        Sends information about the detector model instance and the event that triggered the action to an Amazon SQS queue.
        """
        queue_url: pulumi.Input[str]
        """
        The URL of the SQS queue where the data is written.
        """
        payload: NotRequired[pulumi.Input['AlarmModelPayloadArgsDict']]
        """
        You can configure the action payload when you send a message to an Amazon SQS queue.
        """
        use_base64: NotRequired[pulumi.Input[bool]]
        """
        Set this to TRUE if you want the data to be base-64 encoded before it is written to the queue. Otherwise, set this to FALSE.
        """
elif False:
    AlarmModelSqsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AlarmModelSqsArgs:
    def __init__(__self__, *,
                 queue_url: pulumi.Input[str],
                 payload: Optional[pulumi.Input['AlarmModelPayloadArgs']] = None,
                 use_base64: Optional[pulumi.Input[bool]] = None):
        """
        Sends information about the detector model instance and the event that triggered the action to an Amazon SQS queue.
        :param pulumi.Input[str] queue_url: The URL of the SQS queue where the data is written.
        :param pulumi.Input['AlarmModelPayloadArgs'] payload: You can configure the action payload when you send a message to an Amazon SQS queue.
        :param pulumi.Input[bool] use_base64: Set this to TRUE if you want the data to be base-64 encoded before it is written to the queue. Otherwise, set this to FALSE.
        """
        pulumi.set(__self__, "queue_url", queue_url)
        if payload is not None:
            pulumi.set(__self__, "payload", payload)
        if use_base64 is not None:
            pulumi.set(__self__, "use_base64", use_base64)

    @property
    @pulumi.getter(name="queueUrl")
    def queue_url(self) -> pulumi.Input[str]:
        """
        The URL of the SQS queue where the data is written.
        """
        return pulumi.get(self, "queue_url")

    @queue_url.setter
    def queue_url(self, value: pulumi.Input[str]):
        pulumi.set(self, "queue_url", value)

    @property
    @pulumi.getter
    def payload(self) -> Optional[pulumi.Input['AlarmModelPayloadArgs']]:
        """
        You can configure the action payload when you send a message to an Amazon SQS queue.
        """
        return pulumi.get(self, "payload")

    @payload.setter
    def payload(self, value: Optional[pulumi.Input['AlarmModelPayloadArgs']]):
        pulumi.set(self, "payload", value)

    @property
    @pulumi.getter(name="useBase64")
    def use_base64(self) -> Optional[pulumi.Input[bool]]:
        """
        Set this to TRUE if you want the data to be base-64 encoded before it is written to the queue. Otherwise, set this to FALSE.
        """
        return pulumi.get(self, "use_base64")

    @use_base64.setter
    def use_base64(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_base64", value)


if not MYPY:
    class DetectorModelActionArgsDict(TypedDict):
        """
        An action to be performed when the ``condition`` is TRUE.
        """
        clear_timer: NotRequired[pulumi.Input['DetectorModelClearTimerArgsDict']]
        """
        Information needed to clear the timer.
        """
        dynamo_d_bv2: NotRequired[pulumi.Input['DetectorModelDynamoDBv2ArgsDict']]
        """
        Writes to the DynamoDB table that you created. The default action payload contains all attribute-value pairs that have the information about the detector model instance and the event that triggered the action. You can customize the [payload](https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html). A separate column of the DynamoDB table receives one attribute-value pair in the payload that you specify. For more information, see [Actions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-event-actions.html) in *Developer Guide*.
        """
        dynamo_db: NotRequired[pulumi.Input['DetectorModelDynamoDbArgsDict']]
        """
        Writes to the DynamoDB table that you created. The default action payload contains all attribute-value pairs that have the information about the detector model instance and the event that triggered the action. You can customize the [payload](https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html). One column of the DynamoDB table receives all attribute-value pairs in the payload that you specify. For more information, see [Actions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-event-actions.html) in *Developer Guide*.
        """
        firehose: NotRequired[pulumi.Input['DetectorModelFirehoseArgsDict']]
        """
        Sends information about the detector model instance and the event that triggered the action to an Amazon Kinesis Data Firehose delivery stream.
        """
        iot_events: NotRequired[pulumi.Input['DetectorModelIotEventsArgsDict']]
        """
        Sends ITE input, which passes information about the detector model instance and the event that triggered the action.
        """
        iot_site_wise: NotRequired[pulumi.Input['DetectorModelIotSiteWiseArgsDict']]
        """
        Sends information about the detector model instance and the event that triggered the action to an asset property in ITSW .
        """
        iot_topic_publish: NotRequired[pulumi.Input['DetectorModelIotTopicPublishArgsDict']]
        """
        Publishes an MQTT message with the given topic to the IoT message broker.
        """
        lambda_: NotRequired[pulumi.Input['DetectorModelLambdaArgsDict']]
        """
        Calls a Lambda function, passing in information about the detector model instance and the event that triggered the action.
        """
        reset_timer: NotRequired[pulumi.Input['DetectorModelResetTimerArgsDict']]
        """
        Information needed to reset the timer.
        """
        set_timer: NotRequired[pulumi.Input['DetectorModelSetTimerArgsDict']]
        """
        Information needed to set the timer.
        """
        set_variable: NotRequired[pulumi.Input['DetectorModelSetVariableArgsDict']]
        """
        Sets a variable to a specified value.
        """
        sns: NotRequired[pulumi.Input['DetectorModelSnsArgsDict']]
        """
        Sends an Amazon SNS message.
        """
        sqs: NotRequired[pulumi.Input['DetectorModelSqsArgsDict']]
        """
        Sends an Amazon SNS message.
        """
elif False:
    DetectorModelActionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DetectorModelActionArgs:
    def __init__(__self__, *,
                 clear_timer: Optional[pulumi.Input['DetectorModelClearTimerArgs']] = None,
                 dynamo_d_bv2: Optional[pulumi.Input['DetectorModelDynamoDBv2Args']] = None,
                 dynamo_db: Optional[pulumi.Input['DetectorModelDynamoDbArgs']] = None,
                 firehose: Optional[pulumi.Input['DetectorModelFirehoseArgs']] = None,
                 iot_events: Optional[pulumi.Input['DetectorModelIotEventsArgs']] = None,
                 iot_site_wise: Optional[pulumi.Input['DetectorModelIotSiteWiseArgs']] = None,
                 iot_topic_publish: Optional[pulumi.Input['DetectorModelIotTopicPublishArgs']] = None,
                 lambda_: Optional[pulumi.Input['DetectorModelLambdaArgs']] = None,
                 reset_timer: Optional[pulumi.Input['DetectorModelResetTimerArgs']] = None,
                 set_timer: Optional[pulumi.Input['DetectorModelSetTimerArgs']] = None,
                 set_variable: Optional[pulumi.Input['DetectorModelSetVariableArgs']] = None,
                 sns: Optional[pulumi.Input['DetectorModelSnsArgs']] = None,
                 sqs: Optional[pulumi.Input['DetectorModelSqsArgs']] = None):
        """
        An action to be performed when the ``condition`` is TRUE.
        :param pulumi.Input['DetectorModelClearTimerArgs'] clear_timer: Information needed to clear the timer.
        :param pulumi.Input['DetectorModelDynamoDBv2Args'] dynamo_d_bv2: Writes to the DynamoDB table that you created. The default action payload contains all attribute-value pairs that have the information about the detector model instance and the event that triggered the action. You can customize the [payload](https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html). A separate column of the DynamoDB table receives one attribute-value pair in the payload that you specify. For more information, see [Actions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-event-actions.html) in *Developer Guide*.
        :param pulumi.Input['DetectorModelDynamoDbArgs'] dynamo_db: Writes to the DynamoDB table that you created. The default action payload contains all attribute-value pairs that have the information about the detector model instance and the event that triggered the action. You can customize the [payload](https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html). One column of the DynamoDB table receives all attribute-value pairs in the payload that you specify. For more information, see [Actions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-event-actions.html) in *Developer Guide*.
        :param pulumi.Input['DetectorModelFirehoseArgs'] firehose: Sends information about the detector model instance and the event that triggered the action to an Amazon Kinesis Data Firehose delivery stream.
        :param pulumi.Input['DetectorModelIotEventsArgs'] iot_events: Sends ITE input, which passes information about the detector model instance and the event that triggered the action.
        :param pulumi.Input['DetectorModelIotSiteWiseArgs'] iot_site_wise: Sends information about the detector model instance and the event that triggered the action to an asset property in ITSW .
        :param pulumi.Input['DetectorModelIotTopicPublishArgs'] iot_topic_publish: Publishes an MQTT message with the given topic to the IoT message broker.
        :param pulumi.Input['DetectorModelLambdaArgs'] lambda_: Calls a Lambda function, passing in information about the detector model instance and the event that triggered the action.
        :param pulumi.Input['DetectorModelResetTimerArgs'] reset_timer: Information needed to reset the timer.
        :param pulumi.Input['DetectorModelSetTimerArgs'] set_timer: Information needed to set the timer.
        :param pulumi.Input['DetectorModelSetVariableArgs'] set_variable: Sets a variable to a specified value.
        :param pulumi.Input['DetectorModelSnsArgs'] sns: Sends an Amazon SNS message.
        :param pulumi.Input['DetectorModelSqsArgs'] sqs: Sends an Amazon SNS message.
        """
        if clear_timer is not None:
            pulumi.set(__self__, "clear_timer", clear_timer)
        if dynamo_d_bv2 is not None:
            pulumi.set(__self__, "dynamo_d_bv2", dynamo_d_bv2)
        if dynamo_db is not None:
            pulumi.set(__self__, "dynamo_db", dynamo_db)
        if firehose is not None:
            pulumi.set(__self__, "firehose", firehose)
        if iot_events is not None:
            pulumi.set(__self__, "iot_events", iot_events)
        if iot_site_wise is not None:
            pulumi.set(__self__, "iot_site_wise", iot_site_wise)
        if iot_topic_publish is not None:
            pulumi.set(__self__, "iot_topic_publish", iot_topic_publish)
        if lambda_ is not None:
            pulumi.set(__self__, "lambda_", lambda_)
        if reset_timer is not None:
            pulumi.set(__self__, "reset_timer", reset_timer)
        if set_timer is not None:
            pulumi.set(__self__, "set_timer", set_timer)
        if set_variable is not None:
            pulumi.set(__self__, "set_variable", set_variable)
        if sns is not None:
            pulumi.set(__self__, "sns", sns)
        if sqs is not None:
            pulumi.set(__self__, "sqs", sqs)

    @property
    @pulumi.getter(name="clearTimer")
    def clear_timer(self) -> Optional[pulumi.Input['DetectorModelClearTimerArgs']]:
        """
        Information needed to clear the timer.
        """
        return pulumi.get(self, "clear_timer")

    @clear_timer.setter
    def clear_timer(self, value: Optional[pulumi.Input['DetectorModelClearTimerArgs']]):
        pulumi.set(self, "clear_timer", value)

    @property
    @pulumi.getter(name="dynamoDBv2")
    def dynamo_d_bv2(self) -> Optional[pulumi.Input['DetectorModelDynamoDBv2Args']]:
        """
        Writes to the DynamoDB table that you created. The default action payload contains all attribute-value pairs that have the information about the detector model instance and the event that triggered the action. You can customize the [payload](https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html). A separate column of the DynamoDB table receives one attribute-value pair in the payload that you specify. For more information, see [Actions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-event-actions.html) in *Developer Guide*.
        """
        return pulumi.get(self, "dynamo_d_bv2")

    @dynamo_d_bv2.setter
    def dynamo_d_bv2(self, value: Optional[pulumi.Input['DetectorModelDynamoDBv2Args']]):
        pulumi.set(self, "dynamo_d_bv2", value)

    @property
    @pulumi.getter(name="dynamoDb")
    def dynamo_db(self) -> Optional[pulumi.Input['DetectorModelDynamoDbArgs']]:
        """
        Writes to the DynamoDB table that you created. The default action payload contains all attribute-value pairs that have the information about the detector model instance and the event that triggered the action. You can customize the [payload](https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html). One column of the DynamoDB table receives all attribute-value pairs in the payload that you specify. For more information, see [Actions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-event-actions.html) in *Developer Guide*.
        """
        return pulumi.get(self, "dynamo_db")

    @dynamo_db.setter
    def dynamo_db(self, value: Optional[pulumi.Input['DetectorModelDynamoDbArgs']]):
        pulumi.set(self, "dynamo_db", value)

    @property
    @pulumi.getter
    def firehose(self) -> Optional[pulumi.Input['DetectorModelFirehoseArgs']]:
        """
        Sends information about the detector model instance and the event that triggered the action to an Amazon Kinesis Data Firehose delivery stream.
        """
        return pulumi.get(self, "firehose")

    @firehose.setter
    def firehose(self, value: Optional[pulumi.Input['DetectorModelFirehoseArgs']]):
        pulumi.set(self, "firehose", value)

    @property
    @pulumi.getter(name="iotEvents")
    def iot_events(self) -> Optional[pulumi.Input['DetectorModelIotEventsArgs']]:
        """
        Sends ITE input, which passes information about the detector model instance and the event that triggered the action.
        """
        return pulumi.get(self, "iot_events")

    @iot_events.setter
    def iot_events(self, value: Optional[pulumi.Input['DetectorModelIotEventsArgs']]):
        pulumi.set(self, "iot_events", value)

    @property
    @pulumi.getter(name="iotSiteWise")
    def iot_site_wise(self) -> Optional[pulumi.Input['DetectorModelIotSiteWiseArgs']]:
        """
        Sends information about the detector model instance and the event that triggered the action to an asset property in ITSW .
        """
        return pulumi.get(self, "iot_site_wise")

    @iot_site_wise.setter
    def iot_site_wise(self, value: Optional[pulumi.Input['DetectorModelIotSiteWiseArgs']]):
        pulumi.set(self, "iot_site_wise", value)

    @property
    @pulumi.getter(name="iotTopicPublish")
    def iot_topic_publish(self) -> Optional[pulumi.Input['DetectorModelIotTopicPublishArgs']]:
        """
        Publishes an MQTT message with the given topic to the IoT message broker.
        """
        return pulumi.get(self, "iot_topic_publish")

    @iot_topic_publish.setter
    def iot_topic_publish(self, value: Optional[pulumi.Input['DetectorModelIotTopicPublishArgs']]):
        pulumi.set(self, "iot_topic_publish", value)

    @property
    @pulumi.getter(name="lambda")
    def lambda_(self) -> Optional[pulumi.Input['DetectorModelLambdaArgs']]:
        """
        Calls a Lambda function, passing in information about the detector model instance and the event that triggered the action.
        """
        return pulumi.get(self, "lambda_")

    @lambda_.setter
    def lambda_(self, value: Optional[pulumi.Input['DetectorModelLambdaArgs']]):
        pulumi.set(self, "lambda_", value)

    @property
    @pulumi.getter(name="resetTimer")
    def reset_timer(self) -> Optional[pulumi.Input['DetectorModelResetTimerArgs']]:
        """
        Information needed to reset the timer.
        """
        return pulumi.get(self, "reset_timer")

    @reset_timer.setter
    def reset_timer(self, value: Optional[pulumi.Input['DetectorModelResetTimerArgs']]):
        pulumi.set(self, "reset_timer", value)

    @property
    @pulumi.getter(name="setTimer")
    def set_timer(self) -> Optional[pulumi.Input['DetectorModelSetTimerArgs']]:
        """
        Information needed to set the timer.
        """
        return pulumi.get(self, "set_timer")

    @set_timer.setter
    def set_timer(self, value: Optional[pulumi.Input['DetectorModelSetTimerArgs']]):
        pulumi.set(self, "set_timer", value)

    @property
    @pulumi.getter(name="setVariable")
    def set_variable(self) -> Optional[pulumi.Input['DetectorModelSetVariableArgs']]:
        """
        Sets a variable to a specified value.
        """
        return pulumi.get(self, "set_variable")

    @set_variable.setter
    def set_variable(self, value: Optional[pulumi.Input['DetectorModelSetVariableArgs']]):
        pulumi.set(self, "set_variable", value)

    @property
    @pulumi.getter
    def sns(self) -> Optional[pulumi.Input['DetectorModelSnsArgs']]:
        """
        Sends an Amazon SNS message.
        """
        return pulumi.get(self, "sns")

    @sns.setter
    def sns(self, value: Optional[pulumi.Input['DetectorModelSnsArgs']]):
        pulumi.set(self, "sns", value)

    @property
    @pulumi.getter
    def sqs(self) -> Optional[pulumi.Input['DetectorModelSqsArgs']]:
        """
        Sends an Amazon SNS message.
        """
        return pulumi.get(self, "sqs")

    @sqs.setter
    def sqs(self, value: Optional[pulumi.Input['DetectorModelSqsArgs']]):
        pulumi.set(self, "sqs", value)


if not MYPY:
    class DetectorModelAssetPropertyTimestampArgsDict(TypedDict):
        """
        A structure that contains timestamp information. For more information, see [TimeInNanos](https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_TimeInNanos.html) in the *API Reference*.
         You must use expressions for all parameters in ``AssetPropertyTimestamp``. The expressions accept literals, operators, functions, references, and substitution templates.
          **Examples**
         +  For literal values, the expressions must contain single quotes. For example, the value for the ``timeInSeconds`` parameter can be ``'1586400675'``.
          +  For references, you must specify either variables or input values. For example, the value for the ``offsetInNanos`` parameter can be ``$variable.time``.
          +  For a substitution template, you must use ``${}``, and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.
         In the following example, the value for the ``timeInSeconds`` parameter uses a substitution template.
          ``'${$input.TemperatureInput.sensorData.timestamp / 1000}'`` 
          
         For more information, see [Expressions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html) in the *Developer Guide*.
        """
        time_in_seconds: pulumi.Input[str]
        """
        The timestamp, in seconds, in the Unix epoch format. The valid range is between 1-31556889864403199.
        """
        offset_in_nanos: NotRequired[pulumi.Input[str]]
        """
        The nanosecond offset converted from ``timeInSeconds``. The valid range is between 0-999999999.
        """
elif False:
    DetectorModelAssetPropertyTimestampArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DetectorModelAssetPropertyTimestampArgs:
    def __init__(__self__, *,
                 time_in_seconds: pulumi.Input[str],
                 offset_in_nanos: Optional[pulumi.Input[str]] = None):
        """
        A structure that contains timestamp information. For more information, see [TimeInNanos](https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_TimeInNanos.html) in the *API Reference*.
         You must use expressions for all parameters in ``AssetPropertyTimestamp``. The expressions accept literals, operators, functions, references, and substitution templates.
          **Examples**
         +  For literal values, the expressions must contain single quotes. For example, the value for the ``timeInSeconds`` parameter can be ``'1586400675'``.
          +  For references, you must specify either variables or input values. For example, the value for the ``offsetInNanos`` parameter can be ``$variable.time``.
          +  For a substitution template, you must use ``${}``, and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.
         In the following example, the value for the ``timeInSeconds`` parameter uses a substitution template.
          ``'${$input.TemperatureInput.sensorData.timestamp / 1000}'`` 
          
         For more information, see [Expressions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html) in the *Developer Guide*.
        :param pulumi.Input[str] time_in_seconds: The timestamp, in seconds, in the Unix epoch format. The valid range is between 1-31556889864403199.
        :param pulumi.Input[str] offset_in_nanos: The nanosecond offset converted from ``timeInSeconds``. The valid range is between 0-999999999.
        """
        pulumi.set(__self__, "time_in_seconds", time_in_seconds)
        if offset_in_nanos is not None:
            pulumi.set(__self__, "offset_in_nanos", offset_in_nanos)

    @property
    @pulumi.getter(name="timeInSeconds")
    def time_in_seconds(self) -> pulumi.Input[str]:
        """
        The timestamp, in seconds, in the Unix epoch format. The valid range is between 1-31556889864403199.
        """
        return pulumi.get(self, "time_in_seconds")

    @time_in_seconds.setter
    def time_in_seconds(self, value: pulumi.Input[str]):
        pulumi.set(self, "time_in_seconds", value)

    @property
    @pulumi.getter(name="offsetInNanos")
    def offset_in_nanos(self) -> Optional[pulumi.Input[str]]:
        """
        The nanosecond offset converted from ``timeInSeconds``. The valid range is between 0-999999999.
        """
        return pulumi.get(self, "offset_in_nanos")

    @offset_in_nanos.setter
    def offset_in_nanos(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "offset_in_nanos", value)


if not MYPY:
    class DetectorModelAssetPropertyValueArgsDict(TypedDict):
        """
        A structure that contains value information. For more information, see [AssetPropertyValue](https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_AssetPropertyValue.html) in the *API Reference*.
         You must use expressions for all parameters in ``AssetPropertyValue``. The expressions accept literals, operators, functions, references, and substitution templates.
          **Examples**
         +  For literal values, the expressions must contain single quotes. For example, the value for the ``quality`` parameter can be ``'GOOD'``.
          +  For references, you must specify either variables or input values. For example, the value for the ``quality`` parameter can be ``$input.TemperatureInput.sensorData.quality``.
          
         For more information, see [Expressions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html) in the *Developer Guide*.
        """
        value: pulumi.Input['DetectorModelAssetPropertyVariantArgsDict']
        """
        The value to send to an asset property.
        """
        quality: NotRequired[pulumi.Input[str]]
        """
        The quality of the asset property value. The value must be ``'GOOD'``, ``'BAD'``, or ``'UNCERTAIN'``.
        """
        timestamp: NotRequired[pulumi.Input['DetectorModelAssetPropertyTimestampArgsDict']]
        """
        The timestamp associated with the asset property value. The default is the current event time.
        """
elif False:
    DetectorModelAssetPropertyValueArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DetectorModelAssetPropertyValueArgs:
    def __init__(__self__, *,
                 value: pulumi.Input['DetectorModelAssetPropertyVariantArgs'],
                 quality: Optional[pulumi.Input[str]] = None,
                 timestamp: Optional[pulumi.Input['DetectorModelAssetPropertyTimestampArgs']] = None):
        """
        A structure that contains value information. For more information, see [AssetPropertyValue](https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_AssetPropertyValue.html) in the *API Reference*.
         You must use expressions for all parameters in ``AssetPropertyValue``. The expressions accept literals, operators, functions, references, and substitution templates.
          **Examples**
         +  For literal values, the expressions must contain single quotes. For example, the value for the ``quality`` parameter can be ``'GOOD'``.
          +  For references, you must specify either variables or input values. For example, the value for the ``quality`` parameter can be ``$input.TemperatureInput.sensorData.quality``.
          
         For more information, see [Expressions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html) in the *Developer Guide*.
        :param pulumi.Input['DetectorModelAssetPropertyVariantArgs'] value: The value to send to an asset property.
        :param pulumi.Input[str] quality: The quality of the asset property value. The value must be ``'GOOD'``, ``'BAD'``, or ``'UNCERTAIN'``.
        :param pulumi.Input['DetectorModelAssetPropertyTimestampArgs'] timestamp: The timestamp associated with the asset property value. The default is the current event time.
        """
        pulumi.set(__self__, "value", value)
        if quality is not None:
            pulumi.set(__self__, "quality", quality)
        if timestamp is not None:
            pulumi.set(__self__, "timestamp", timestamp)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input['DetectorModelAssetPropertyVariantArgs']:
        """
        The value to send to an asset property.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input['DetectorModelAssetPropertyVariantArgs']):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter
    def quality(self) -> Optional[pulumi.Input[str]]:
        """
        The quality of the asset property value. The value must be ``'GOOD'``, ``'BAD'``, or ``'UNCERTAIN'``.
        """
        return pulumi.get(self, "quality")

    @quality.setter
    def quality(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "quality", value)

    @property
    @pulumi.getter
    def timestamp(self) -> Optional[pulumi.Input['DetectorModelAssetPropertyTimestampArgs']]:
        """
        The timestamp associated with the asset property value. The default is the current event time.
        """
        return pulumi.get(self, "timestamp")

    @timestamp.setter
    def timestamp(self, value: Optional[pulumi.Input['DetectorModelAssetPropertyTimestampArgs']]):
        pulumi.set(self, "timestamp", value)


if not MYPY:
    class DetectorModelAssetPropertyVariantArgsDict(TypedDict):
        """
        A structure that contains an asset property value. For more information, see [Variant](https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_Variant.html) in the *API Reference*.
         You must use expressions for all parameters in ``AssetPropertyVariant``. The expressions accept literals, operators, functions, references, and substitution templates.
          **Examples**
         +  For literal values, the expressions must contain single quotes. For example, the value for the ``integerValue`` parameter can be ``'100'``.
          +  For references, you must specify either variables or parameters. For example, the value for the ``booleanValue`` parameter can be ``$variable.offline``.
          +  For a substitution template, you must use ``${}``, and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates. 
         In the following example, the value for the ``doubleValue`` parameter uses a substitution template. 
          ``'${$input.TemperatureInput.sensorData.temperature * 6 / 5 + 32}'`` 
          
         For more information, see [Expressions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html) in the *Developer Guide*.
         You must specify one of the following value types, depending on the ``dataType`` of the specified asset property. For more information, see [AssetProperty](https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_AssetProperty.html) in the *API Reference*.
        """
        boolean_value: NotRequired[pulumi.Input[str]]
        """
        The asset property value is a Boolean value that must be ``'TRUE'`` or ``'FALSE'``. You must use an expression, and the evaluated result should be a Boolean value.
        """
        double_value: NotRequired[pulumi.Input[str]]
        """
        The asset property value is a double. You must use an expression, and the evaluated result should be a double.
        """
        integer_value: NotRequired[pulumi.Input[str]]
        """
        The asset property value is an integer. You must use an expression, and the evaluated result should be an integer.
        """
        string_value: NotRequired[pulumi.Input[str]]
        """
        The asset property value is a string. You must use an expression, and the evaluated result should be a string.
        """
elif False:
    DetectorModelAssetPropertyVariantArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DetectorModelAssetPropertyVariantArgs:
    def __init__(__self__, *,
                 boolean_value: Optional[pulumi.Input[str]] = None,
                 double_value: Optional[pulumi.Input[str]] = None,
                 integer_value: Optional[pulumi.Input[str]] = None,
                 string_value: Optional[pulumi.Input[str]] = None):
        """
        A structure that contains an asset property value. For more information, see [Variant](https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_Variant.html) in the *API Reference*.
         You must use expressions for all parameters in ``AssetPropertyVariant``. The expressions accept literals, operators, functions, references, and substitution templates.
          **Examples**
         +  For literal values, the expressions must contain single quotes. For example, the value for the ``integerValue`` parameter can be ``'100'``.
          +  For references, you must specify either variables or parameters. For example, the value for the ``booleanValue`` parameter can be ``$variable.offline``.
          +  For a substitution template, you must use ``${}``, and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates. 
         In the following example, the value for the ``doubleValue`` parameter uses a substitution template. 
          ``'${$input.TemperatureInput.sensorData.temperature * 6 / 5 + 32}'`` 
          
         For more information, see [Expressions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html) in the *Developer Guide*.
         You must specify one of the following value types, depending on the ``dataType`` of the specified asset property. For more information, see [AssetProperty](https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_AssetProperty.html) in the *API Reference*.
        :param pulumi.Input[str] boolean_value: The asset property value is a Boolean value that must be ``'TRUE'`` or ``'FALSE'``. You must use an expression, and the evaluated result should be a Boolean value.
        :param pulumi.Input[str] double_value: The asset property value is a double. You must use an expression, and the evaluated result should be a double.
        :param pulumi.Input[str] integer_value: The asset property value is an integer. You must use an expression, and the evaluated result should be an integer.
        :param pulumi.Input[str] string_value: The asset property value is a string. You must use an expression, and the evaluated result should be a string.
        """
        if boolean_value is not None:
            pulumi.set(__self__, "boolean_value", boolean_value)
        if double_value is not None:
            pulumi.set(__self__, "double_value", double_value)
        if integer_value is not None:
            pulumi.set(__self__, "integer_value", integer_value)
        if string_value is not None:
            pulumi.set(__self__, "string_value", string_value)

    @property
    @pulumi.getter(name="booleanValue")
    def boolean_value(self) -> Optional[pulumi.Input[str]]:
        """
        The asset property value is a Boolean value that must be ``'TRUE'`` or ``'FALSE'``. You must use an expression, and the evaluated result should be a Boolean value.
        """
        return pulumi.get(self, "boolean_value")

    @boolean_value.setter
    def boolean_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "boolean_value", value)

    @property
    @pulumi.getter(name="doubleValue")
    def double_value(self) -> Optional[pulumi.Input[str]]:
        """
        The asset property value is a double. You must use an expression, and the evaluated result should be a double.
        """
        return pulumi.get(self, "double_value")

    @double_value.setter
    def double_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "double_value", value)

    @property
    @pulumi.getter(name="integerValue")
    def integer_value(self) -> Optional[pulumi.Input[str]]:
        """
        The asset property value is an integer. You must use an expression, and the evaluated result should be an integer.
        """
        return pulumi.get(self, "integer_value")

    @integer_value.setter
    def integer_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "integer_value", value)

    @property
    @pulumi.getter(name="stringValue")
    def string_value(self) -> Optional[pulumi.Input[str]]:
        """
        The asset property value is a string. You must use an expression, and the evaluated result should be a string.
        """
        return pulumi.get(self, "string_value")

    @string_value.setter
    def string_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "string_value", value)


if not MYPY:
    class DetectorModelClearTimerArgsDict(TypedDict):
        """
        Information needed to clear the timer.
        """
        timer_name: pulumi.Input[str]
        """
        The name of the timer to clear.
        """
elif False:
    DetectorModelClearTimerArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DetectorModelClearTimerArgs:
    def __init__(__self__, *,
                 timer_name: pulumi.Input[str]):
        """
        Information needed to clear the timer.
        :param pulumi.Input[str] timer_name: The name of the timer to clear.
        """
        pulumi.set(__self__, "timer_name", timer_name)

    @property
    @pulumi.getter(name="timerName")
    def timer_name(self) -> pulumi.Input[str]:
        """
        The name of the timer to clear.
        """
        return pulumi.get(self, "timer_name")

    @timer_name.setter
    def timer_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "timer_name", value)


if not MYPY:
    class DetectorModelDefinitionArgsDict(TypedDict):
        """
        Information that defines how a detector operates.
        """
        initial_state_name: pulumi.Input[str]
        """
        The state that is entered at the creation of each detector (instance).
        """
        states: pulumi.Input[Sequence[pulumi.Input['DetectorModelStateArgsDict']]]
        """
        Information about the states of the detector.
        """
elif False:
    DetectorModelDefinitionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DetectorModelDefinitionArgs:
    def __init__(__self__, *,
                 initial_state_name: pulumi.Input[str],
                 states: pulumi.Input[Sequence[pulumi.Input['DetectorModelStateArgs']]]):
        """
        Information that defines how a detector operates.
        :param pulumi.Input[str] initial_state_name: The state that is entered at the creation of each detector (instance).
        :param pulumi.Input[Sequence[pulumi.Input['DetectorModelStateArgs']]] states: Information about the states of the detector.
        """
        pulumi.set(__self__, "initial_state_name", initial_state_name)
        pulumi.set(__self__, "states", states)

    @property
    @pulumi.getter(name="initialStateName")
    def initial_state_name(self) -> pulumi.Input[str]:
        """
        The state that is entered at the creation of each detector (instance).
        """
        return pulumi.get(self, "initial_state_name")

    @initial_state_name.setter
    def initial_state_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "initial_state_name", value)

    @property
    @pulumi.getter
    def states(self) -> pulumi.Input[Sequence[pulumi.Input['DetectorModelStateArgs']]]:
        """
        Information about the states of the detector.
        """
        return pulumi.get(self, "states")

    @states.setter
    def states(self, value: pulumi.Input[Sequence[pulumi.Input['DetectorModelStateArgs']]]):
        pulumi.set(self, "states", value)


if not MYPY:
    class DetectorModelDynamoDBv2ArgsDict(TypedDict):
        """
        Defines an action to write to the Amazon DynamoDB table that you created. The default action payload contains all the information about the detector model instance and the event that triggered the action. You can customize the [payload](https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html). A separate column of the DynamoDB table receives one attribute-value pair in the payload that you specify.
         You must use expressions for all parameters in ``DynamoDBv2Action``. The expressions accept literals, operators, functions, references, and substitution templates.
          **Examples**
         +  For literal values, the expressions must contain single quotes. For example, the value for the ``tableName`` parameter can be ``'GreenhouseTemperatureTable'``.
          +  For references, you must specify either variables or input values. For example, the value for the ``tableName`` parameter can be ``$variable.ddbtableName``.
          +  For a substitution template, you must use ``${}``, and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.
         In the following example, the value for the ``contentExpression`` parameter in ``Payload`` uses a substitution template. 
          ``'{\\"sensorID\\": \\"${$input.GreenhouseInput.sensor_id}\\", \\"temperature\\": \\"${$input.GreenhouseInput.temperature * 9 / 5 + 32}\\"}'`` 
          +  For a string concatenation, you must use ``+``. A string concatenation can also contain a combination of literals, operators, functions, references, and substitution templates.
         In the following example, the value for the ``tableName`` parameter uses a string concatenation. 
          ``'GreenhouseTemperatureTable ' + $input.GreenhouseInput.date`` 
          
         For more information, see [Expressions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html) in the *Developer Guide*.
         The value for the ``type`` parameter in ``Payload`` must be ``JSON``.
        """
        table_name: pulumi.Input[str]
        """
        The name of the DynamoDB table.
        """
        payload: NotRequired[pulumi.Input['DetectorModelPayloadArgsDict']]
        """
        Information needed to configure the payload.
         By default, ITE generates a standard payload in JSON for any action. This action payload contains all attribute-value pairs that have the information about the detector model instance and the event triggered the action. To configure the action payload, you can use ``contentExpression``.
        """
elif False:
    DetectorModelDynamoDBv2ArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DetectorModelDynamoDBv2Args:
    def __init__(__self__, *,
                 table_name: pulumi.Input[str],
                 payload: Optional[pulumi.Input['DetectorModelPayloadArgs']] = None):
        """
        Defines an action to write to the Amazon DynamoDB table that you created. The default action payload contains all the information about the detector model instance and the event that triggered the action. You can customize the [payload](https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html). A separate column of the DynamoDB table receives one attribute-value pair in the payload that you specify.
         You must use expressions for all parameters in ``DynamoDBv2Action``. The expressions accept literals, operators, functions, references, and substitution templates.
          **Examples**
         +  For literal values, the expressions must contain single quotes. For example, the value for the ``tableName`` parameter can be ``'GreenhouseTemperatureTable'``.
          +  For references, you must specify either variables or input values. For example, the value for the ``tableName`` parameter can be ``$variable.ddbtableName``.
          +  For a substitution template, you must use ``${}``, and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.
         In the following example, the value for the ``contentExpression`` parameter in ``Payload`` uses a substitution template. 
          ``'{\\"sensorID\\": \\"${$input.GreenhouseInput.sensor_id}\\", \\"temperature\\": \\"${$input.GreenhouseInput.temperature * 9 / 5 + 32}\\"}'`` 
          +  For a string concatenation, you must use ``+``. A string concatenation can also contain a combination of literals, operators, functions, references, and substitution templates.
         In the following example, the value for the ``tableName`` parameter uses a string concatenation. 
          ``'GreenhouseTemperatureTable ' + $input.GreenhouseInput.date`` 
          
         For more information, see [Expressions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html) in the *Developer Guide*.
         The value for the ``type`` parameter in ``Payload`` must be ``JSON``.
        :param pulumi.Input[str] table_name: The name of the DynamoDB table.
        :param pulumi.Input['DetectorModelPayloadArgs'] payload: Information needed to configure the payload.
                By default, ITE generates a standard payload in JSON for any action. This action payload contains all attribute-value pairs that have the information about the detector model instance and the event triggered the action. To configure the action payload, you can use ``contentExpression``.
        """
        pulumi.set(__self__, "table_name", table_name)
        if payload is not None:
            pulumi.set(__self__, "payload", payload)

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> pulumi.Input[str]:
        """
        The name of the DynamoDB table.
        """
        return pulumi.get(self, "table_name")

    @table_name.setter
    def table_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "table_name", value)

    @property
    @pulumi.getter
    def payload(self) -> Optional[pulumi.Input['DetectorModelPayloadArgs']]:
        """
        Information needed to configure the payload.
         By default, ITE generates a standard payload in JSON for any action. This action payload contains all attribute-value pairs that have the information about the detector model instance and the event triggered the action. To configure the action payload, you can use ``contentExpression``.
        """
        return pulumi.get(self, "payload")

    @payload.setter
    def payload(self, value: Optional[pulumi.Input['DetectorModelPayloadArgs']]):
        pulumi.set(self, "payload", value)


if not MYPY:
    class DetectorModelDynamoDbArgsDict(TypedDict):
        """
        Defines an action to write to the Amazon DynamoDB table that you created. The standard action payload contains all the information about the detector model instance and the event that triggered the action. You can customize the [payload](https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html). One column of the DynamoDB table receives all attribute-value pairs in the payload that you specify.
         You must use expressions for all parameters in ``DynamoDBAction``. The expressions accept literals, operators, functions, references, and substitution templates.
          **Examples**
         +  For literal values, the expressions must contain single quotes. For example, the value for the ``hashKeyType`` parameter can be ``'STRING'``.
          +  For references, you must specify either variables or input values. For example, the value for the ``hashKeyField`` parameter can be ``$input.GreenhouseInput.name``.
          +  For a substitution template, you must use ``${}``, and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.
         In the following example, the value for the ``hashKeyValue`` parameter uses a substitution template. 
          ``'${$input.GreenhouseInput.temperature * 6 / 5 + 32} in Fahrenheit'`` 
          +  For a string concatenation, you must use ``+``. A string concatenation can also contain a combination of literals, operators, functions, references, and substitution templates.
         In the following example, the value for the ``tableName`` parameter uses a string concatenation. 
          ``'GreenhouseTemperatureTable ' + $input.GreenhouseInput.date`` 
          
         For more information, see [Expressions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html) in the *Developer Guide*.
         If the defined payload type is a string, ``DynamoDBAction`` writes non-JSON data to the DynamoDB table as binary data. The DynamoDB console displays the data as Base64-encoded text. The value for the ``payloadField`` parameter is ``<payload-field>_raw``.
        """
        hash_key_field: pulumi.Input[str]
        """
        The name of the hash key (also called the partition key). The ``hashKeyField`` value must match the partition key of the target DynamoDB table.
        """
        hash_key_value: pulumi.Input[str]
        """
        The value of the hash key (also called the partition key).
        """
        table_name: pulumi.Input[str]
        """
        The name of the DynamoDB table. The ``tableName`` value must match the table name of the target DynamoDB table.
        """
        hash_key_type: NotRequired[pulumi.Input[str]]
        """
        The data type for the hash key (also called the partition key). You can specify the following values:
          +   ``'STRING'`` - The hash key is a string.
          +   ``'NUMBER'`` - The hash key is a number.
          
         If you don't specify ``hashKeyType``, the default value is ``'STRING'``.
        """
        operation: NotRequired[pulumi.Input[str]]
        """
        The type of operation to perform. You can specify the following values: 
          +   ``'INSERT'`` - Insert data as a new item into the DynamoDB table. This item uses the specified hash key as a partition key. If you specified a range key, the item uses the range key as a sort key.
          +   ``'UPDATE'`` - Update an existing item of the DynamoDB table with new data. This item's partition key must match the specified hash key. If you specified a range key, the range key must match the item's sort key.
          +   ``'DELETE'`` - Delete an existing item of the DynamoDB table. This item's partition key must match the specified hash key. If you specified a range key, the range key must match the item's sort key.
          
         If you don't specify this parameter, ITE triggers the ``'INSERT'`` operation.
        """
        payload: NotRequired[pulumi.Input['DetectorModelPayloadArgsDict']]
        """
        Information needed to configure the payload.
         By default, ITE generates a standard payload in JSON for any action. This action payload contains all attribute-value pairs that have the information about the detector model instance and the event triggered the action. To configure the action payload, you can use ``contentExpression``.
        """
        payload_field: NotRequired[pulumi.Input[str]]
        """
        The name of the DynamoDB column that receives the action payload.
         If you don't specify this parameter, the name of the DynamoDB column is ``payload``.
        """
        range_key_field: NotRequired[pulumi.Input[str]]
        """
        The name of the range key (also called the sort key). The ``rangeKeyField`` value must match the sort key of the target DynamoDB table.
        """
        range_key_type: NotRequired[pulumi.Input[str]]
        """
        The data type for the range key (also called the sort key), You can specify the following values:
          +   ``'STRING'`` - The range key is a string.
          +   ``'NUMBER'`` - The range key is number.
          
         If you don't specify ``rangeKeyField``, the default value is ``'STRING'``.
        """
        range_key_value: NotRequired[pulumi.Input[str]]
        """
        The value of the range key (also called the sort key).
        """
elif False:
    DetectorModelDynamoDbArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DetectorModelDynamoDbArgs:
    def __init__(__self__, *,
                 hash_key_field: pulumi.Input[str],
                 hash_key_value: pulumi.Input[str],
                 table_name: pulumi.Input[str],
                 hash_key_type: Optional[pulumi.Input[str]] = None,
                 operation: Optional[pulumi.Input[str]] = None,
                 payload: Optional[pulumi.Input['DetectorModelPayloadArgs']] = None,
                 payload_field: Optional[pulumi.Input[str]] = None,
                 range_key_field: Optional[pulumi.Input[str]] = None,
                 range_key_type: Optional[pulumi.Input[str]] = None,
                 range_key_value: Optional[pulumi.Input[str]] = None):
        """
        Defines an action to write to the Amazon DynamoDB table that you created. The standard action payload contains all the information about the detector model instance and the event that triggered the action. You can customize the [payload](https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html). One column of the DynamoDB table receives all attribute-value pairs in the payload that you specify.
         You must use expressions for all parameters in ``DynamoDBAction``. The expressions accept literals, operators, functions, references, and substitution templates.
          **Examples**
         +  For literal values, the expressions must contain single quotes. For example, the value for the ``hashKeyType`` parameter can be ``'STRING'``.
          +  For references, you must specify either variables or input values. For example, the value for the ``hashKeyField`` parameter can be ``$input.GreenhouseInput.name``.
          +  For a substitution template, you must use ``${}``, and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.
         In the following example, the value for the ``hashKeyValue`` parameter uses a substitution template. 
          ``'${$input.GreenhouseInput.temperature * 6 / 5 + 32} in Fahrenheit'`` 
          +  For a string concatenation, you must use ``+``. A string concatenation can also contain a combination of literals, operators, functions, references, and substitution templates.
         In the following example, the value for the ``tableName`` parameter uses a string concatenation. 
          ``'GreenhouseTemperatureTable ' + $input.GreenhouseInput.date`` 
          
         For more information, see [Expressions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html) in the *Developer Guide*.
         If the defined payload type is a string, ``DynamoDBAction`` writes non-JSON data to the DynamoDB table as binary data. The DynamoDB console displays the data as Base64-encoded text. The value for the ``payloadField`` parameter is ``<payload-field>_raw``.
        :param pulumi.Input[str] hash_key_field: The name of the hash key (also called the partition key). The ``hashKeyField`` value must match the partition key of the target DynamoDB table.
        :param pulumi.Input[str] hash_key_value: The value of the hash key (also called the partition key).
        :param pulumi.Input[str] table_name: The name of the DynamoDB table. The ``tableName`` value must match the table name of the target DynamoDB table.
        :param pulumi.Input[str] hash_key_type: The data type for the hash key (also called the partition key). You can specify the following values:
                 +   ``'STRING'`` - The hash key is a string.
                 +   ``'NUMBER'`` - The hash key is a number.
                 
                If you don't specify ``hashKeyType``, the default value is ``'STRING'``.
        :param pulumi.Input[str] operation: The type of operation to perform. You can specify the following values: 
                 +   ``'INSERT'`` - Insert data as a new item into the DynamoDB table. This item uses the specified hash key as a partition key. If you specified a range key, the item uses the range key as a sort key.
                 +   ``'UPDATE'`` - Update an existing item of the DynamoDB table with new data. This item's partition key must match the specified hash key. If you specified a range key, the range key must match the item's sort key.
                 +   ``'DELETE'`` - Delete an existing item of the DynamoDB table. This item's partition key must match the specified hash key. If you specified a range key, the range key must match the item's sort key.
                 
                If you don't specify this parameter, ITE triggers the ``'INSERT'`` operation.
        :param pulumi.Input['DetectorModelPayloadArgs'] payload: Information needed to configure the payload.
                By default, ITE generates a standard payload in JSON for any action. This action payload contains all attribute-value pairs that have the information about the detector model instance and the event triggered the action. To configure the action payload, you can use ``contentExpression``.
        :param pulumi.Input[str] payload_field: The name of the DynamoDB column that receives the action payload.
                If you don't specify this parameter, the name of the DynamoDB column is ``payload``.
        :param pulumi.Input[str] range_key_field: The name of the range key (also called the sort key). The ``rangeKeyField`` value must match the sort key of the target DynamoDB table.
        :param pulumi.Input[str] range_key_type: The data type for the range key (also called the sort key), You can specify the following values:
                 +   ``'STRING'`` - The range key is a string.
                 +   ``'NUMBER'`` - The range key is number.
                 
                If you don't specify ``rangeKeyField``, the default value is ``'STRING'``.
        :param pulumi.Input[str] range_key_value: The value of the range key (also called the sort key).
        """
        pulumi.set(__self__, "hash_key_field", hash_key_field)
        pulumi.set(__self__, "hash_key_value", hash_key_value)
        pulumi.set(__self__, "table_name", table_name)
        if hash_key_type is not None:
            pulumi.set(__self__, "hash_key_type", hash_key_type)
        if operation is not None:
            pulumi.set(__self__, "operation", operation)
        if payload is not None:
            pulumi.set(__self__, "payload", payload)
        if payload_field is not None:
            pulumi.set(__self__, "payload_field", payload_field)
        if range_key_field is not None:
            pulumi.set(__self__, "range_key_field", range_key_field)
        if range_key_type is not None:
            pulumi.set(__self__, "range_key_type", range_key_type)
        if range_key_value is not None:
            pulumi.set(__self__, "range_key_value", range_key_value)

    @property
    @pulumi.getter(name="hashKeyField")
    def hash_key_field(self) -> pulumi.Input[str]:
        """
        The name of the hash key (also called the partition key). The ``hashKeyField`` value must match the partition key of the target DynamoDB table.
        """
        return pulumi.get(self, "hash_key_field")

    @hash_key_field.setter
    def hash_key_field(self, value: pulumi.Input[str]):
        pulumi.set(self, "hash_key_field", value)

    @property
    @pulumi.getter(name="hashKeyValue")
    def hash_key_value(self) -> pulumi.Input[str]:
        """
        The value of the hash key (also called the partition key).
        """
        return pulumi.get(self, "hash_key_value")

    @hash_key_value.setter
    def hash_key_value(self, value: pulumi.Input[str]):
        pulumi.set(self, "hash_key_value", value)

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> pulumi.Input[str]:
        """
        The name of the DynamoDB table. The ``tableName`` value must match the table name of the target DynamoDB table.
        """
        return pulumi.get(self, "table_name")

    @table_name.setter
    def table_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "table_name", value)

    @property
    @pulumi.getter(name="hashKeyType")
    def hash_key_type(self) -> Optional[pulumi.Input[str]]:
        """
        The data type for the hash key (also called the partition key). You can specify the following values:
          +   ``'STRING'`` - The hash key is a string.
          +   ``'NUMBER'`` - The hash key is a number.
          
         If you don't specify ``hashKeyType``, the default value is ``'STRING'``.
        """
        return pulumi.get(self, "hash_key_type")

    @hash_key_type.setter
    def hash_key_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hash_key_type", value)

    @property
    @pulumi.getter
    def operation(self) -> Optional[pulumi.Input[str]]:
        """
        The type of operation to perform. You can specify the following values: 
          +   ``'INSERT'`` - Insert data as a new item into the DynamoDB table. This item uses the specified hash key as a partition key. If you specified a range key, the item uses the range key as a sort key.
          +   ``'UPDATE'`` - Update an existing item of the DynamoDB table with new data. This item's partition key must match the specified hash key. If you specified a range key, the range key must match the item's sort key.
          +   ``'DELETE'`` - Delete an existing item of the DynamoDB table. This item's partition key must match the specified hash key. If you specified a range key, the range key must match the item's sort key.
          
         If you don't specify this parameter, ITE triggers the ``'INSERT'`` operation.
        """
        return pulumi.get(self, "operation")

    @operation.setter
    def operation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "operation", value)

    @property
    @pulumi.getter
    def payload(self) -> Optional[pulumi.Input['DetectorModelPayloadArgs']]:
        """
        Information needed to configure the payload.
         By default, ITE generates a standard payload in JSON for any action. This action payload contains all attribute-value pairs that have the information about the detector model instance and the event triggered the action. To configure the action payload, you can use ``contentExpression``.
        """
        return pulumi.get(self, "payload")

    @payload.setter
    def payload(self, value: Optional[pulumi.Input['DetectorModelPayloadArgs']]):
        pulumi.set(self, "payload", value)

    @property
    @pulumi.getter(name="payloadField")
    def payload_field(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the DynamoDB column that receives the action payload.
         If you don't specify this parameter, the name of the DynamoDB column is ``payload``.
        """
        return pulumi.get(self, "payload_field")

    @payload_field.setter
    def payload_field(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "payload_field", value)

    @property
    @pulumi.getter(name="rangeKeyField")
    def range_key_field(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the range key (also called the sort key). The ``rangeKeyField`` value must match the sort key of the target DynamoDB table.
        """
        return pulumi.get(self, "range_key_field")

    @range_key_field.setter
    def range_key_field(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "range_key_field", value)

    @property
    @pulumi.getter(name="rangeKeyType")
    def range_key_type(self) -> Optional[pulumi.Input[str]]:
        """
        The data type for the range key (also called the sort key), You can specify the following values:
          +   ``'STRING'`` - The range key is a string.
          +   ``'NUMBER'`` - The range key is number.
          
         If you don't specify ``rangeKeyField``, the default value is ``'STRING'``.
        """
        return pulumi.get(self, "range_key_type")

    @range_key_type.setter
    def range_key_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "range_key_type", value)

    @property
    @pulumi.getter(name="rangeKeyValue")
    def range_key_value(self) -> Optional[pulumi.Input[str]]:
        """
        The value of the range key (also called the sort key).
        """
        return pulumi.get(self, "range_key_value")

    @range_key_value.setter
    def range_key_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "range_key_value", value)


if not MYPY:
    class DetectorModelEventArgsDict(TypedDict):
        """
        Specifies the ``actions`` to be performed when the ``condition`` evaluates to TRUE.
        """
        event_name: pulumi.Input[str]
        """
        The name of the event.
        """
        actions: NotRequired[pulumi.Input[Sequence[pulumi.Input['DetectorModelActionArgsDict']]]]
        """
        The actions to be performed.
        """
        condition: NotRequired[pulumi.Input[str]]
        """
        Optional. The Boolean expression that, when TRUE, causes the ``actions`` to be performed. If not present, the actions are performed (=TRUE). If the expression result is not a Boolean value, the actions are not performed (=FALSE).
        """
elif False:
    DetectorModelEventArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DetectorModelEventArgs:
    def __init__(__self__, *,
                 event_name: pulumi.Input[str],
                 actions: Optional[pulumi.Input[Sequence[pulumi.Input['DetectorModelActionArgs']]]] = None,
                 condition: Optional[pulumi.Input[str]] = None):
        """
        Specifies the ``actions`` to be performed when the ``condition`` evaluates to TRUE.
        :param pulumi.Input[str] event_name: The name of the event.
        :param pulumi.Input[Sequence[pulumi.Input['DetectorModelActionArgs']]] actions: The actions to be performed.
        :param pulumi.Input[str] condition: Optional. The Boolean expression that, when TRUE, causes the ``actions`` to be performed. If not present, the actions are performed (=TRUE). If the expression result is not a Boolean value, the actions are not performed (=FALSE).
        """
        pulumi.set(__self__, "event_name", event_name)
        if actions is not None:
            pulumi.set(__self__, "actions", actions)
        if condition is not None:
            pulumi.set(__self__, "condition", condition)

    @property
    @pulumi.getter(name="eventName")
    def event_name(self) -> pulumi.Input[str]:
        """
        The name of the event.
        """
        return pulumi.get(self, "event_name")

    @event_name.setter
    def event_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "event_name", value)

    @property
    @pulumi.getter
    def actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DetectorModelActionArgs']]]]:
        """
        The actions to be performed.
        """
        return pulumi.get(self, "actions")

    @actions.setter
    def actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DetectorModelActionArgs']]]]):
        pulumi.set(self, "actions", value)

    @property
    @pulumi.getter
    def condition(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The Boolean expression that, when TRUE, causes the ``actions`` to be performed. If not present, the actions are performed (=TRUE). If the expression result is not a Boolean value, the actions are not performed (=FALSE).
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "condition", value)


if not MYPY:
    class DetectorModelFirehoseArgsDict(TypedDict):
        """
        Sends information about the detector model instance and the event that triggered the action to an Amazon Kinesis Data Firehose delivery stream.
        """
        delivery_stream_name: pulumi.Input[str]
        """
        The name of the Kinesis Data Firehose delivery stream where the data is written.
        """
        payload: NotRequired[pulumi.Input['DetectorModelPayloadArgsDict']]
        """
        You can configure the action payload when you send a message to an Amazon Data Firehose delivery stream.
        """
        separator: NotRequired[pulumi.Input[str]]
        """
        A character separator that is used to separate records written to the Kinesis Data Firehose delivery stream. Valid values are: '\\n' (newline), '\\t' (tab), '\\r\\n' (Windows newline), ',' (comma).
        """
elif False:
    DetectorModelFirehoseArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DetectorModelFirehoseArgs:
    def __init__(__self__, *,
                 delivery_stream_name: pulumi.Input[str],
                 payload: Optional[pulumi.Input['DetectorModelPayloadArgs']] = None,
                 separator: Optional[pulumi.Input[str]] = None):
        """
        Sends information about the detector model instance and the event that triggered the action to an Amazon Kinesis Data Firehose delivery stream.
        :param pulumi.Input[str] delivery_stream_name: The name of the Kinesis Data Firehose delivery stream where the data is written.
        :param pulumi.Input['DetectorModelPayloadArgs'] payload: You can configure the action payload when you send a message to an Amazon Data Firehose delivery stream.
        :param pulumi.Input[str] separator: A character separator that is used to separate records written to the Kinesis Data Firehose delivery stream. Valid values are: '\\n' (newline), '\\t' (tab), '\\r\\n' (Windows newline), ',' (comma).
        """
        pulumi.set(__self__, "delivery_stream_name", delivery_stream_name)
        if payload is not None:
            pulumi.set(__self__, "payload", payload)
        if separator is not None:
            pulumi.set(__self__, "separator", separator)

    @property
    @pulumi.getter(name="deliveryStreamName")
    def delivery_stream_name(self) -> pulumi.Input[str]:
        """
        The name of the Kinesis Data Firehose delivery stream where the data is written.
        """
        return pulumi.get(self, "delivery_stream_name")

    @delivery_stream_name.setter
    def delivery_stream_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "delivery_stream_name", value)

    @property
    @pulumi.getter
    def payload(self) -> Optional[pulumi.Input['DetectorModelPayloadArgs']]:
        """
        You can configure the action payload when you send a message to an Amazon Data Firehose delivery stream.
        """
        return pulumi.get(self, "payload")

    @payload.setter
    def payload(self, value: Optional[pulumi.Input['DetectorModelPayloadArgs']]):
        pulumi.set(self, "payload", value)

    @property
    @pulumi.getter
    def separator(self) -> Optional[pulumi.Input[str]]:
        """
        A character separator that is used to separate records written to the Kinesis Data Firehose delivery stream. Valid values are: '\\n' (newline), '\\t' (tab), '\\r\\n' (Windows newline), ',' (comma).
        """
        return pulumi.get(self, "separator")

    @separator.setter
    def separator(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "separator", value)


if not MYPY:
    class DetectorModelIotEventsArgsDict(TypedDict):
        """
        Sends an ITE input, passing in information about the detector model instance and the event that triggered the action.
        """
        input_name: pulumi.Input[str]
        """
        The name of the ITE input where the data is sent.
        """
        payload: NotRequired[pulumi.Input['DetectorModelPayloadArgsDict']]
        """
        You can configure the action payload when you send a message to an ITE input.
        """
elif False:
    DetectorModelIotEventsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DetectorModelIotEventsArgs:
    def __init__(__self__, *,
                 input_name: pulumi.Input[str],
                 payload: Optional[pulumi.Input['DetectorModelPayloadArgs']] = None):
        """
        Sends an ITE input, passing in information about the detector model instance and the event that triggered the action.
        :param pulumi.Input[str] input_name: The name of the ITE input where the data is sent.
        :param pulumi.Input['DetectorModelPayloadArgs'] payload: You can configure the action payload when you send a message to an ITE input.
        """
        pulumi.set(__self__, "input_name", input_name)
        if payload is not None:
            pulumi.set(__self__, "payload", payload)

    @property
    @pulumi.getter(name="inputName")
    def input_name(self) -> pulumi.Input[str]:
        """
        The name of the ITE input where the data is sent.
        """
        return pulumi.get(self, "input_name")

    @input_name.setter
    def input_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "input_name", value)

    @property
    @pulumi.getter
    def payload(self) -> Optional[pulumi.Input['DetectorModelPayloadArgs']]:
        """
        You can configure the action payload when you send a message to an ITE input.
        """
        return pulumi.get(self, "payload")

    @payload.setter
    def payload(self, value: Optional[pulumi.Input['DetectorModelPayloadArgs']]):
        pulumi.set(self, "payload", value)


if not MYPY:
    class DetectorModelIotSiteWiseArgsDict(TypedDict):
        """
        Sends information about the detector model instance and the event that triggered the action to a specified asset property in ITSW.
         You must use expressions for all parameters in ``IotSiteWiseAction``. The expressions accept literals, operators, functions, references, and substitutions templates.
          **Examples**
         +  For literal values, the expressions must contain single quotes. For example, the value for the ``propertyAlias`` parameter can be ``'/company/windfarm/3/turbine/7/temperature'``.
          +  For references, you must specify either variables or input values. For example, the value for the ``assetId`` parameter can be ``$input.TurbineInput.assetId1``.
          +  For a substitution template, you must use ``${}``, and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.
         In the following example, the value for the ``propertyAlias`` parameter uses a substitution template. 
          ``'company/windfarm/${$input.TemperatureInput.sensorData.windfarmID}/turbine/ ${$input.TemperatureInput.sensorData.turbineID}/temperature'`` 
          
         You must specify either ``propertyAlias`` or both ``assetId`` and ``propertyId`` to identify the target asset property in ITSW.
         For more information, see [Expressions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html) in the *Developer Guide*.
        """
        property_value: pulumi.Input['DetectorModelAssetPropertyValueArgsDict']
        """
        The value to send to the asset property. This value contains timestamp, quality, and value (TQV) information.
        """
        asset_id: NotRequired[pulumi.Input[str]]
        """
        The ID of the asset that has the specified property.
        """
        entry_id: NotRequired[pulumi.Input[str]]
        """
        A unique identifier for this entry. You can use the entry ID to track which data entry causes an error in case of failure. The default is a new unique identifier.
        """
        property_alias: NotRequired[pulumi.Input[str]]
        """
        The alias of the asset property.
        """
        property_id: NotRequired[pulumi.Input[str]]
        """
        The ID of the asset property.
        """
elif False:
    DetectorModelIotSiteWiseArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DetectorModelIotSiteWiseArgs:
    def __init__(__self__, *,
                 property_value: pulumi.Input['DetectorModelAssetPropertyValueArgs'],
                 asset_id: Optional[pulumi.Input[str]] = None,
                 entry_id: Optional[pulumi.Input[str]] = None,
                 property_alias: Optional[pulumi.Input[str]] = None,
                 property_id: Optional[pulumi.Input[str]] = None):
        """
        Sends information about the detector model instance and the event that triggered the action to a specified asset property in ITSW.
         You must use expressions for all parameters in ``IotSiteWiseAction``. The expressions accept literals, operators, functions, references, and substitutions templates.
          **Examples**
         +  For literal values, the expressions must contain single quotes. For example, the value for the ``propertyAlias`` parameter can be ``'/company/windfarm/3/turbine/7/temperature'``.
          +  For references, you must specify either variables or input values. For example, the value for the ``assetId`` parameter can be ``$input.TurbineInput.assetId1``.
          +  For a substitution template, you must use ``${}``, and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.
         In the following example, the value for the ``propertyAlias`` parameter uses a substitution template. 
          ``'company/windfarm/${$input.TemperatureInput.sensorData.windfarmID}/turbine/ ${$input.TemperatureInput.sensorData.turbineID}/temperature'`` 
          
         You must specify either ``propertyAlias`` or both ``assetId`` and ``propertyId`` to identify the target asset property in ITSW.
         For more information, see [Expressions](https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html) in the *Developer Guide*.
        :param pulumi.Input['DetectorModelAssetPropertyValueArgs'] property_value: The value to send to the asset property. This value contains timestamp, quality, and value (TQV) information.
        :param pulumi.Input[str] asset_id: The ID of the asset that has the specified property.
        :param pulumi.Input[str] entry_id: A unique identifier for this entry. You can use the entry ID to track which data entry causes an error in case of failure. The default is a new unique identifier.
        :param pulumi.Input[str] property_alias: The alias of the asset property.
        :param pulumi.Input[str] property_id: The ID of the asset property.
        """
        pulumi.set(__self__, "property_value", property_value)
        if asset_id is not None:
            pulumi.set(__self__, "asset_id", asset_id)
        if entry_id is not None:
            pulumi.set(__self__, "entry_id", entry_id)
        if property_alias is not None:
            pulumi.set(__self__, "property_alias", property_alias)
        if property_id is not None:
            pulumi.set(__self__, "property_id", property_id)

    @property
    @pulumi.getter(name="propertyValue")
    def property_value(self) -> pulumi.Input['DetectorModelAssetPropertyValueArgs']:
        """
        The value to send to the asset property. This value contains timestamp, quality, and value (TQV) information.
        """
        return pulumi.get(self, "property_value")

    @property_value.setter
    def property_value(self, value: pulumi.Input['DetectorModelAssetPropertyValueArgs']):
        pulumi.set(self, "property_value", value)

    @property
    @pulumi.getter(name="assetId")
    def asset_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the asset that has the specified property.
        """
        return pulumi.get(self, "asset_id")

    @asset_id.setter
    def asset_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "asset_id", value)

    @property
    @pulumi.getter(name="entryId")
    def entry_id(self) -> Optional[pulumi.Input[str]]:
        """
        A unique identifier for this entry. You can use the entry ID to track which data entry causes an error in case of failure. The default is a new unique identifier.
        """
        return pulumi.get(self, "entry_id")

    @entry_id.setter
    def entry_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "entry_id", value)

    @property
    @pulumi.getter(name="propertyAlias")
    def property_alias(self) -> Optional[pulumi.Input[str]]:
        """
        The alias of the asset property.
        """
        return pulumi.get(self, "property_alias")

    @property_alias.setter
    def property_alias(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "property_alias", value)

    @property
    @pulumi.getter(name="propertyId")
    def property_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the asset property.
        """
        return pulumi.get(self, "property_id")

    @property_id.setter
    def property_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "property_id", value)


if not MYPY:
    class DetectorModelIotTopicPublishArgsDict(TypedDict):
        """
        Information required to publish the MQTT message through the IoT message broker.
        """
        mqtt_topic: pulumi.Input[str]
        """
        The MQTT topic of the message. You can use a string expression that includes variables (``$variable.<variable-name>``) and input values (``$input.<input-name>.<path-to-datum>``) as the topic string.
        """
        payload: NotRequired[pulumi.Input['DetectorModelPayloadArgsDict']]
        """
        You can configure the action payload when you publish a message to an IoTCore topic.
        """
elif False:
    DetectorModelIotTopicPublishArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DetectorModelIotTopicPublishArgs:
    def __init__(__self__, *,
                 mqtt_topic: pulumi.Input[str],
                 payload: Optional[pulumi.Input['DetectorModelPayloadArgs']] = None):
        """
        Information required to publish the MQTT message through the IoT message broker.
        :param pulumi.Input[str] mqtt_topic: The MQTT topic of the message. You can use a string expression that includes variables (``$variable.<variable-name>``) and input values (``$input.<input-name>.<path-to-datum>``) as the topic string.
        :param pulumi.Input['DetectorModelPayloadArgs'] payload: You can configure the action payload when you publish a message to an IoTCore topic.
        """
        pulumi.set(__self__, "mqtt_topic", mqtt_topic)
        if payload is not None:
            pulumi.set(__self__, "payload", payload)

    @property
    @pulumi.getter(name="mqttTopic")
    def mqtt_topic(self) -> pulumi.Input[str]:
        """
        The MQTT topic of the message. You can use a string expression that includes variables (``$variable.<variable-name>``) and input values (``$input.<input-name>.<path-to-datum>``) as the topic string.
        """
        return pulumi.get(self, "mqtt_topic")

    @mqtt_topic.setter
    def mqtt_topic(self, value: pulumi.Input[str]):
        pulumi.set(self, "mqtt_topic", value)

    @property
    @pulumi.getter
    def payload(self) -> Optional[pulumi.Input['DetectorModelPayloadArgs']]:
        """
        You can configure the action payload when you publish a message to an IoTCore topic.
        """
        return pulumi.get(self, "payload")

    @payload.setter
    def payload(self, value: Optional[pulumi.Input['DetectorModelPayloadArgs']]):
        pulumi.set(self, "payload", value)


if not MYPY:
    class DetectorModelLambdaArgsDict(TypedDict):
        """
        Calls a Lambda function, passing in information about the detector model instance and the event that triggered the action.
        """
        function_arn: pulumi.Input[str]
        """
        The ARN of the Lambda function that is executed.
        """
        payload: NotRequired[pulumi.Input['DetectorModelPayloadArgsDict']]
        """
        You can configure the action payload when you send a message to a Lambda function.
        """
elif False:
    DetectorModelLambdaArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DetectorModelLambdaArgs:
    def __init__(__self__, *,
                 function_arn: pulumi.Input[str],
                 payload: Optional[pulumi.Input['DetectorModelPayloadArgs']] = None):
        """
        Calls a Lambda function, passing in information about the detector model instance and the event that triggered the action.
        :param pulumi.Input[str] function_arn: The ARN of the Lambda function that is executed.
        :param pulumi.Input['DetectorModelPayloadArgs'] payload: You can configure the action payload when you send a message to a Lambda function.
        """
        pulumi.set(__self__, "function_arn", function_arn)
        if payload is not None:
            pulumi.set(__self__, "payload", payload)

    @property
    @pulumi.getter(name="functionArn")
    def function_arn(self) -> pulumi.Input[str]:
        """
        The ARN of the Lambda function that is executed.
        """
        return pulumi.get(self, "function_arn")

    @function_arn.setter
    def function_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "function_arn", value)

    @property
    @pulumi.getter
    def payload(self) -> Optional[pulumi.Input['DetectorModelPayloadArgs']]:
        """
        You can configure the action payload when you send a message to a Lambda function.
        """
        return pulumi.get(self, "payload")

    @payload.setter
    def payload(self, value: Optional[pulumi.Input['DetectorModelPayloadArgs']]):
        pulumi.set(self, "payload", value)


if not MYPY:
    class DetectorModelOnEnterArgsDict(TypedDict):
        """
        When entering this state, perform these ``actions`` if the ``condition`` is TRUE.
        """
        events: NotRequired[pulumi.Input[Sequence[pulumi.Input['DetectorModelEventArgsDict']]]]
        """
        Specifies the actions that are performed when the state is entered and the ``condition`` is ``TRUE``.
        """
elif False:
    DetectorModelOnEnterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DetectorModelOnEnterArgs:
    def __init__(__self__, *,
                 events: Optional[pulumi.Input[Sequence[pulumi.Input['DetectorModelEventArgs']]]] = None):
        """
        When entering this state, perform these ``actions`` if the ``condition`` is TRUE.
        :param pulumi.Input[Sequence[pulumi.Input['DetectorModelEventArgs']]] events: Specifies the actions that are performed when the state is entered and the ``condition`` is ``TRUE``.
        """
        if events is not None:
            pulumi.set(__self__, "events", events)

    @property
    @pulumi.getter
    def events(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DetectorModelEventArgs']]]]:
        """
        Specifies the actions that are performed when the state is entered and the ``condition`` is ``TRUE``.
        """
        return pulumi.get(self, "events")

    @events.setter
    def events(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DetectorModelEventArgs']]]]):
        pulumi.set(self, "events", value)


if not MYPY:
    class DetectorModelOnExitArgsDict(TypedDict):
        """
        When exiting this state, perform these ``actions`` if the specified ``condition`` is ``TRUE``.
        """
        events: NotRequired[pulumi.Input[Sequence[pulumi.Input['DetectorModelEventArgsDict']]]]
        """
        Specifies the ``actions`` that are performed when the state is exited and the ``condition`` is ``TRUE``.
        """
elif False:
    DetectorModelOnExitArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DetectorModelOnExitArgs:
    def __init__(__self__, *,
                 events: Optional[pulumi.Input[Sequence[pulumi.Input['DetectorModelEventArgs']]]] = None):
        """
        When exiting this state, perform these ``actions`` if the specified ``condition`` is ``TRUE``.
        :param pulumi.Input[Sequence[pulumi.Input['DetectorModelEventArgs']]] events: Specifies the ``actions`` that are performed when the state is exited and the ``condition`` is ``TRUE``.
        """
        if events is not None:
            pulumi.set(__self__, "events", events)

    @property
    @pulumi.getter
    def events(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DetectorModelEventArgs']]]]:
        """
        Specifies the ``actions`` that are performed when the state is exited and the ``condition`` is ``TRUE``.
        """
        return pulumi.get(self, "events")

    @events.setter
    def events(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DetectorModelEventArgs']]]]):
        pulumi.set(self, "events", value)


if not MYPY:
    class DetectorModelOnInputArgsDict(TypedDict):
        """
        Specifies the actions performed when the ``condition`` evaluates to TRUE.
        """
        events: NotRequired[pulumi.Input[Sequence[pulumi.Input['DetectorModelEventArgsDict']]]]
        """
        Specifies the actions performed when the ``condition`` evaluates to TRUE.
        """
        transition_events: NotRequired[pulumi.Input[Sequence[pulumi.Input['DetectorModelTransitionEventArgsDict']]]]
        """
        Specifies the actions performed, and the next state entered, when a ``condition`` evaluates to TRUE.
        """
elif False:
    DetectorModelOnInputArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DetectorModelOnInputArgs:
    def __init__(__self__, *,
                 events: Optional[pulumi.Input[Sequence[pulumi.Input['DetectorModelEventArgs']]]] = None,
                 transition_events: Optional[pulumi.Input[Sequence[pulumi.Input['DetectorModelTransitionEventArgs']]]] = None):
        """
        Specifies the actions performed when the ``condition`` evaluates to TRUE.
        :param pulumi.Input[Sequence[pulumi.Input['DetectorModelEventArgs']]] events: Specifies the actions performed when the ``condition`` evaluates to TRUE.
        :param pulumi.Input[Sequence[pulumi.Input['DetectorModelTransitionEventArgs']]] transition_events: Specifies the actions performed, and the next state entered, when a ``condition`` evaluates to TRUE.
        """
        if events is not None:
            pulumi.set(__self__, "events", events)
        if transition_events is not None:
            pulumi.set(__self__, "transition_events", transition_events)

    @property
    @pulumi.getter
    def events(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DetectorModelEventArgs']]]]:
        """
        Specifies the actions performed when the ``condition`` evaluates to TRUE.
        """
        return pulumi.get(self, "events")

    @events.setter
    def events(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DetectorModelEventArgs']]]]):
        pulumi.set(self, "events", value)

    @property
    @pulumi.getter(name="transitionEvents")
    def transition_events(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DetectorModelTransitionEventArgs']]]]:
        """
        Specifies the actions performed, and the next state entered, when a ``condition`` evaluates to TRUE.
        """
        return pulumi.get(self, "transition_events")

    @transition_events.setter
    def transition_events(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DetectorModelTransitionEventArgs']]]]):
        pulumi.set(self, "transition_events", value)


if not MYPY:
    class DetectorModelPayloadArgsDict(TypedDict):
        """
        Information needed to configure the payload.
         By default, ITE generates a standard payload in JSON for any action. This action payload contains all attribute-value pairs that have the information about the detector model instance and the event triggered the action. To configure the action payload, you can use ``contentExpression``.
        """
        content_expression: pulumi.Input[str]
        """
        The content of the payload. You can use a string expression that includes quoted strings (``'<string>'``), variables (``$variable.<variable-name>``), input values (``$input.<input-name>.<path-to-datum>``), string concatenations, and quoted strings that contain ``${}`` as the content. The recommended maximum size of a content expression is 1 KB.
        """
        type: pulumi.Input[str]
        """
        The value of the payload type can be either ``STRING`` or ``JSON``.
        """
elif False:
    DetectorModelPayloadArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DetectorModelPayloadArgs:
    def __init__(__self__, *,
                 content_expression: pulumi.Input[str],
                 type: pulumi.Input[str]):
        """
        Information needed to configure the payload.
         By default, ITE generates a standard payload in JSON for any action. This action payload contains all attribute-value pairs that have the information about the detector model instance and the event triggered the action. To configure the action payload, you can use ``contentExpression``.
        :param pulumi.Input[str] content_expression: The content of the payload. You can use a string expression that includes quoted strings (``'<string>'``), variables (``$variable.<variable-name>``), input values (``$input.<input-name>.<path-to-datum>``), string concatenations, and quoted strings that contain ``${}`` as the content. The recommended maximum size of a content expression is 1 KB.
        :param pulumi.Input[str] type: The value of the payload type can be either ``STRING`` or ``JSON``.
        """
        pulumi.set(__self__, "content_expression", content_expression)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="contentExpression")
    def content_expression(self) -> pulumi.Input[str]:
        """
        The content of the payload. You can use a string expression that includes quoted strings (``'<string>'``), variables (``$variable.<variable-name>``), input values (``$input.<input-name>.<path-to-datum>``), string concatenations, and quoted strings that contain ``${}`` as the content. The recommended maximum size of a content expression is 1 KB.
        """
        return pulumi.get(self, "content_expression")

    @content_expression.setter
    def content_expression(self, value: pulumi.Input[str]):
        pulumi.set(self, "content_expression", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The value of the payload type can be either ``STRING`` or ``JSON``.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)


if not MYPY:
    class DetectorModelResetTimerArgsDict(TypedDict):
        """
        Information required to reset the timer. The timer is reset to the previously evaluated result of the duration. The duration expression isn't reevaluated when you reset the timer.
        """
        timer_name: pulumi.Input[str]
        """
        The name of the timer to reset.
        """
elif False:
    DetectorModelResetTimerArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DetectorModelResetTimerArgs:
    def __init__(__self__, *,
                 timer_name: pulumi.Input[str]):
        """
        Information required to reset the timer. The timer is reset to the previously evaluated result of the duration. The duration expression isn't reevaluated when you reset the timer.
        :param pulumi.Input[str] timer_name: The name of the timer to reset.
        """
        pulumi.set(__self__, "timer_name", timer_name)

    @property
    @pulumi.getter(name="timerName")
    def timer_name(self) -> pulumi.Input[str]:
        """
        The name of the timer to reset.
        """
        return pulumi.get(self, "timer_name")

    @timer_name.setter
    def timer_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "timer_name", value)


if not MYPY:
    class DetectorModelSetTimerArgsDict(TypedDict):
        """
        Information needed to set the timer.
        """
        timer_name: pulumi.Input[str]
        """
        The name of the timer.
        """
        duration_expression: NotRequired[pulumi.Input[str]]
        """
        The duration of the timer, in seconds. You can use a string expression that includes numbers, variables (``$variable.<variable-name>``), and input values (``$input.<input-name>.<path-to-datum>``) as the duration. The range of the duration is 1-31622400 seconds. To ensure accuracy, the minimum duration is 60 seconds. The evaluated result of the duration is rounded down to the nearest whole number.
        """
        seconds: NotRequired[pulumi.Input[int]]
        """
        The number of seconds until the timer expires. The minimum value is 60 seconds to ensure accuracy. The maximum value is 31622400 seconds.
        """
elif False:
    DetectorModelSetTimerArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DetectorModelSetTimerArgs:
    def __init__(__self__, *,
                 timer_name: pulumi.Input[str],
                 duration_expression: Optional[pulumi.Input[str]] = None,
                 seconds: Optional[pulumi.Input[int]] = None):
        """
        Information needed to set the timer.
        :param pulumi.Input[str] timer_name: The name of the timer.
        :param pulumi.Input[str] duration_expression: The duration of the timer, in seconds. You can use a string expression that includes numbers, variables (``$variable.<variable-name>``), and input values (``$input.<input-name>.<path-to-datum>``) as the duration. The range of the duration is 1-31622400 seconds. To ensure accuracy, the minimum duration is 60 seconds. The evaluated result of the duration is rounded down to the nearest whole number.
        :param pulumi.Input[int] seconds: The number of seconds until the timer expires. The minimum value is 60 seconds to ensure accuracy. The maximum value is 31622400 seconds.
        """
        pulumi.set(__self__, "timer_name", timer_name)
        if duration_expression is not None:
            pulumi.set(__self__, "duration_expression", duration_expression)
        if seconds is not None:
            pulumi.set(__self__, "seconds", seconds)

    @property
    @pulumi.getter(name="timerName")
    def timer_name(self) -> pulumi.Input[str]:
        """
        The name of the timer.
        """
        return pulumi.get(self, "timer_name")

    @timer_name.setter
    def timer_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "timer_name", value)

    @property
    @pulumi.getter(name="durationExpression")
    def duration_expression(self) -> Optional[pulumi.Input[str]]:
        """
        The duration of the timer, in seconds. You can use a string expression that includes numbers, variables (``$variable.<variable-name>``), and input values (``$input.<input-name>.<path-to-datum>``) as the duration. The range of the duration is 1-31622400 seconds. To ensure accuracy, the minimum duration is 60 seconds. The evaluated result of the duration is rounded down to the nearest whole number.
        """
        return pulumi.get(self, "duration_expression")

    @duration_expression.setter
    def duration_expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "duration_expression", value)

    @property
    @pulumi.getter
    def seconds(self) -> Optional[pulumi.Input[int]]:
        """
        The number of seconds until the timer expires. The minimum value is 60 seconds to ensure accuracy. The maximum value is 31622400 seconds.
        """
        return pulumi.get(self, "seconds")

    @seconds.setter
    def seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "seconds", value)


if not MYPY:
    class DetectorModelSetVariableArgsDict(TypedDict):
        """
        Information about the variable and its new value.
        """
        value: pulumi.Input[str]
        """
        The new value of the variable.
        """
        variable_name: pulumi.Input[str]
        """
        The name of the variable.
        """
elif False:
    DetectorModelSetVariableArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DetectorModelSetVariableArgs:
    def __init__(__self__, *,
                 value: pulumi.Input[str],
                 variable_name: pulumi.Input[str]):
        """
        Information about the variable and its new value.
        :param pulumi.Input[str] value: The new value of the variable.
        :param pulumi.Input[str] variable_name: The name of the variable.
        """
        pulumi.set(__self__, "value", value)
        pulumi.set(__self__, "variable_name", variable_name)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The new value of the variable.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter(name="variableName")
    def variable_name(self) -> pulumi.Input[str]:
        """
        The name of the variable.
        """
        return pulumi.get(self, "variable_name")

    @variable_name.setter
    def variable_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "variable_name", value)


if not MYPY:
    class DetectorModelSnsArgsDict(TypedDict):
        """
        Information required to publish the Amazon SNS message.
        """
        target_arn: pulumi.Input[str]
        """
        The ARN of the Amazon SNS target where the message is sent.
        """
        payload: NotRequired[pulumi.Input['DetectorModelPayloadArgsDict']]
        """
        You can configure the action payload when you send a message as an Amazon SNS push notification.
        """
elif False:
    DetectorModelSnsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DetectorModelSnsArgs:
    def __init__(__self__, *,
                 target_arn: pulumi.Input[str],
                 payload: Optional[pulumi.Input['DetectorModelPayloadArgs']] = None):
        """
        Information required to publish the Amazon SNS message.
        :param pulumi.Input[str] target_arn: The ARN of the Amazon SNS target where the message is sent.
        :param pulumi.Input['DetectorModelPayloadArgs'] payload: You can configure the action payload when you send a message as an Amazon SNS push notification.
        """
        pulumi.set(__self__, "target_arn", target_arn)
        if payload is not None:
            pulumi.set(__self__, "payload", payload)

    @property
    @pulumi.getter(name="targetArn")
    def target_arn(self) -> pulumi.Input[str]:
        """
        The ARN of the Amazon SNS target where the message is sent.
        """
        return pulumi.get(self, "target_arn")

    @target_arn.setter
    def target_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "target_arn", value)

    @property
    @pulumi.getter
    def payload(self) -> Optional[pulumi.Input['DetectorModelPayloadArgs']]:
        """
        You can configure the action payload when you send a message as an Amazon SNS push notification.
        """
        return pulumi.get(self, "payload")

    @payload.setter
    def payload(self, value: Optional[pulumi.Input['DetectorModelPayloadArgs']]):
        pulumi.set(self, "payload", value)


if not MYPY:
    class DetectorModelSqsArgsDict(TypedDict):
        """
        Sends information about the detector model instance and the event that triggered the action to an Amazon SQS queue.
        """
        queue_url: pulumi.Input[str]
        """
        The URL of the SQS queue where the data is written.
        """
        payload: NotRequired[pulumi.Input['DetectorModelPayloadArgsDict']]
        """
        You can configure the action payload when you send a message to an Amazon SQS queue.
        """
        use_base64: NotRequired[pulumi.Input[bool]]
        """
        Set this to TRUE if you want the data to be base-64 encoded before it is written to the queue. Otherwise, set this to FALSE.
        """
elif False:
    DetectorModelSqsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DetectorModelSqsArgs:
    def __init__(__self__, *,
                 queue_url: pulumi.Input[str],
                 payload: Optional[pulumi.Input['DetectorModelPayloadArgs']] = None,
                 use_base64: Optional[pulumi.Input[bool]] = None):
        """
        Sends information about the detector model instance and the event that triggered the action to an Amazon SQS queue.
        :param pulumi.Input[str] queue_url: The URL of the SQS queue where the data is written.
        :param pulumi.Input['DetectorModelPayloadArgs'] payload: You can configure the action payload when you send a message to an Amazon SQS queue.
        :param pulumi.Input[bool] use_base64: Set this to TRUE if you want the data to be base-64 encoded before it is written to the queue. Otherwise, set this to FALSE.
        """
        pulumi.set(__self__, "queue_url", queue_url)
        if payload is not None:
            pulumi.set(__self__, "payload", payload)
        if use_base64 is not None:
            pulumi.set(__self__, "use_base64", use_base64)

    @property
    @pulumi.getter(name="queueUrl")
    def queue_url(self) -> pulumi.Input[str]:
        """
        The URL of the SQS queue where the data is written.
        """
        return pulumi.get(self, "queue_url")

    @queue_url.setter
    def queue_url(self, value: pulumi.Input[str]):
        pulumi.set(self, "queue_url", value)

    @property
    @pulumi.getter
    def payload(self) -> Optional[pulumi.Input['DetectorModelPayloadArgs']]:
        """
        You can configure the action payload when you send a message to an Amazon SQS queue.
        """
        return pulumi.get(self, "payload")

    @payload.setter
    def payload(self, value: Optional[pulumi.Input['DetectorModelPayloadArgs']]):
        pulumi.set(self, "payload", value)

    @property
    @pulumi.getter(name="useBase64")
    def use_base64(self) -> Optional[pulumi.Input[bool]]:
        """
        Set this to TRUE if you want the data to be base-64 encoded before it is written to the queue. Otherwise, set this to FALSE.
        """
        return pulumi.get(self, "use_base64")

    @use_base64.setter
    def use_base64(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_base64", value)


if not MYPY:
    class DetectorModelStateArgsDict(TypedDict):
        """
        Information that defines a state of a detector.
        """
        state_name: pulumi.Input[str]
        """
        The name of the state.
        """
        on_enter: NotRequired[pulumi.Input['DetectorModelOnEnterArgsDict']]
        """
        When entering this state, perform these ``actions`` if the ``condition`` is TRUE.
        """
        on_exit: NotRequired[pulumi.Input['DetectorModelOnExitArgsDict']]
        """
        When exiting this state, perform these ``actions`` if the specified ``condition`` is ``TRUE``.
        """
        on_input: NotRequired[pulumi.Input['DetectorModelOnInputArgsDict']]
        """
        When an input is received and the ``condition`` is TRUE, perform the specified ``actions``.
        """
elif False:
    DetectorModelStateArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DetectorModelStateArgs:
    def __init__(__self__, *,
                 state_name: pulumi.Input[str],
                 on_enter: Optional[pulumi.Input['DetectorModelOnEnterArgs']] = None,
                 on_exit: Optional[pulumi.Input['DetectorModelOnExitArgs']] = None,
                 on_input: Optional[pulumi.Input['DetectorModelOnInputArgs']] = None):
        """
        Information that defines a state of a detector.
        :param pulumi.Input[str] state_name: The name of the state.
        :param pulumi.Input['DetectorModelOnEnterArgs'] on_enter: When entering this state, perform these ``actions`` if the ``condition`` is TRUE.
        :param pulumi.Input['DetectorModelOnExitArgs'] on_exit: When exiting this state, perform these ``actions`` if the specified ``condition`` is ``TRUE``.
        :param pulumi.Input['DetectorModelOnInputArgs'] on_input: When an input is received and the ``condition`` is TRUE, perform the specified ``actions``.
        """
        pulumi.set(__self__, "state_name", state_name)
        if on_enter is not None:
            pulumi.set(__self__, "on_enter", on_enter)
        if on_exit is not None:
            pulumi.set(__self__, "on_exit", on_exit)
        if on_input is not None:
            pulumi.set(__self__, "on_input", on_input)

    @property
    @pulumi.getter(name="stateName")
    def state_name(self) -> pulumi.Input[str]:
        """
        The name of the state.
        """
        return pulumi.get(self, "state_name")

    @state_name.setter
    def state_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "state_name", value)

    @property
    @pulumi.getter(name="onEnter")
    def on_enter(self) -> Optional[pulumi.Input['DetectorModelOnEnterArgs']]:
        """
        When entering this state, perform these ``actions`` if the ``condition`` is TRUE.
        """
        return pulumi.get(self, "on_enter")

    @on_enter.setter
    def on_enter(self, value: Optional[pulumi.Input['DetectorModelOnEnterArgs']]):
        pulumi.set(self, "on_enter", value)

    @property
    @pulumi.getter(name="onExit")
    def on_exit(self) -> Optional[pulumi.Input['DetectorModelOnExitArgs']]:
        """
        When exiting this state, perform these ``actions`` if the specified ``condition`` is ``TRUE``.
        """
        return pulumi.get(self, "on_exit")

    @on_exit.setter
    def on_exit(self, value: Optional[pulumi.Input['DetectorModelOnExitArgs']]):
        pulumi.set(self, "on_exit", value)

    @property
    @pulumi.getter(name="onInput")
    def on_input(self) -> Optional[pulumi.Input['DetectorModelOnInputArgs']]:
        """
        When an input is received and the ``condition`` is TRUE, perform the specified ``actions``.
        """
        return pulumi.get(self, "on_input")

    @on_input.setter
    def on_input(self, value: Optional[pulumi.Input['DetectorModelOnInputArgs']]):
        pulumi.set(self, "on_input", value)


if not MYPY:
    class DetectorModelTransitionEventArgsDict(TypedDict):
        """
        Specifies the actions performed and the next state entered when a ``condition`` evaluates to TRUE.
        """
        condition: pulumi.Input[str]
        """
        Required. A Boolean expression that when TRUE causes the actions to be performed and the ``nextState`` to be entered.
        """
        event_name: pulumi.Input[str]
        """
        The name of the transition event.
        """
        next_state: pulumi.Input[str]
        """
        The next state to enter.
        """
        actions: NotRequired[pulumi.Input[Sequence[pulumi.Input['DetectorModelActionArgsDict']]]]
        """
        The actions to be performed.
        """
elif False:
    DetectorModelTransitionEventArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DetectorModelTransitionEventArgs:
    def __init__(__self__, *,
                 condition: pulumi.Input[str],
                 event_name: pulumi.Input[str],
                 next_state: pulumi.Input[str],
                 actions: Optional[pulumi.Input[Sequence[pulumi.Input['DetectorModelActionArgs']]]] = None):
        """
        Specifies the actions performed and the next state entered when a ``condition`` evaluates to TRUE.
        :param pulumi.Input[str] condition: Required. A Boolean expression that when TRUE causes the actions to be performed and the ``nextState`` to be entered.
        :param pulumi.Input[str] event_name: The name of the transition event.
        :param pulumi.Input[str] next_state: The next state to enter.
        :param pulumi.Input[Sequence[pulumi.Input['DetectorModelActionArgs']]] actions: The actions to be performed.
        """
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "event_name", event_name)
        pulumi.set(__self__, "next_state", next_state)
        if actions is not None:
            pulumi.set(__self__, "actions", actions)

    @property
    @pulumi.getter
    def condition(self) -> pulumi.Input[str]:
        """
        Required. A Boolean expression that when TRUE causes the actions to be performed and the ``nextState`` to be entered.
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: pulumi.Input[str]):
        pulumi.set(self, "condition", value)

    @property
    @pulumi.getter(name="eventName")
    def event_name(self) -> pulumi.Input[str]:
        """
        The name of the transition event.
        """
        return pulumi.get(self, "event_name")

    @event_name.setter
    def event_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "event_name", value)

    @property
    @pulumi.getter(name="nextState")
    def next_state(self) -> pulumi.Input[str]:
        """
        The next state to enter.
        """
        return pulumi.get(self, "next_state")

    @next_state.setter
    def next_state(self, value: pulumi.Input[str]):
        pulumi.set(self, "next_state", value)

    @property
    @pulumi.getter
    def actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DetectorModelActionArgs']]]]:
        """
        The actions to be performed.
        """
        return pulumi.get(self, "actions")

    @actions.setter
    def actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DetectorModelActionArgs']]]]):
        pulumi.set(self, "actions", value)


if not MYPY:
    class InputAttributeArgsDict(TypedDict):
        """
        The attributes from the JSON payload that are made available by the input. Inputs are derived from messages sent to the ITE system using ``BatchPutMessage``. Each such message contains a JSON payload. Those attributes (and their paired values) specified here are available for use in the ``condition`` expressions used by detectors.
        """
        json_path: pulumi.Input[str]
        """
        An expression that specifies an attribute-value pair in a JSON structure. Use this to specify an attribute from the JSON payload that is made available by the input. Inputs are derived from messages sent to ITE (``BatchPutMessage``). Each such message contains a JSON payload. The attribute (and its paired value) specified here are available for use in the ``condition`` expressions used by detectors. 
         Syntax: ``<field-name>.<field-name>...``
        """
elif False:
    InputAttributeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InputAttributeArgs:
    def __init__(__self__, *,
                 json_path: pulumi.Input[str]):
        """
        The attributes from the JSON payload that are made available by the input. Inputs are derived from messages sent to the ITE system using ``BatchPutMessage``. Each such message contains a JSON payload. Those attributes (and their paired values) specified here are available for use in the ``condition`` expressions used by detectors.
        :param pulumi.Input[str] json_path: An expression that specifies an attribute-value pair in a JSON structure. Use this to specify an attribute from the JSON payload that is made available by the input. Inputs are derived from messages sent to ITE (``BatchPutMessage``). Each such message contains a JSON payload. The attribute (and its paired value) specified here are available for use in the ``condition`` expressions used by detectors. 
                Syntax: ``<field-name>.<field-name>...``
        """
        pulumi.set(__self__, "json_path", json_path)

    @property
    @pulumi.getter(name="jsonPath")
    def json_path(self) -> pulumi.Input[str]:
        """
        An expression that specifies an attribute-value pair in a JSON structure. Use this to specify an attribute from the JSON payload that is made available by the input. Inputs are derived from messages sent to ITE (``BatchPutMessage``). Each such message contains a JSON payload. The attribute (and its paired value) specified here are available for use in the ``condition`` expressions used by detectors. 
         Syntax: ``<field-name>.<field-name>...``
        """
        return pulumi.get(self, "json_path")

    @json_path.setter
    def json_path(self, value: pulumi.Input[str]):
        pulumi.set(self, "json_path", value)


if not MYPY:
    class InputDefinitionArgsDict(TypedDict):
        """
        The definition of the input.
        """
        attributes: pulumi.Input[Sequence[pulumi.Input['InputAttributeArgsDict']]]
        """
        The attributes from the JSON payload that are made available by the input. Inputs are derived from messages sent to the ITE system using ``BatchPutMessage``. Each such message contains a JSON payload, and those attributes (and their paired values) specified here are available for use in the ``condition`` expressions used by detectors that monitor this input.
        """
elif False:
    InputDefinitionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InputDefinitionArgs:
    def __init__(__self__, *,
                 attributes: pulumi.Input[Sequence[pulumi.Input['InputAttributeArgs']]]):
        """
        The definition of the input.
        :param pulumi.Input[Sequence[pulumi.Input['InputAttributeArgs']]] attributes: The attributes from the JSON payload that are made available by the input. Inputs are derived from messages sent to the ITE system using ``BatchPutMessage``. Each such message contains a JSON payload, and those attributes (and their paired values) specified here are available for use in the ``condition`` expressions used by detectors that monitor this input.
        """
        pulumi.set(__self__, "attributes", attributes)

    @property
    @pulumi.getter
    def attributes(self) -> pulumi.Input[Sequence[pulumi.Input['InputAttributeArgs']]]:
        """
        The attributes from the JSON payload that are made available by the input. Inputs are derived from messages sent to the ITE system using ``BatchPutMessage``. Each such message contains a JSON payload, and those attributes (and their paired values) specified here are available for use in the ``condition`` expressions used by detectors that monitor this input.
        """
        return pulumi.get(self, "attributes")

    @attributes.setter
    def attributes(self, value: pulumi.Input[Sequence[pulumi.Input['InputAttributeArgs']]]):
        pulumi.set(self, "attributes", value)


