# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._inputs import *

__all__ = ['PipelineArgs', 'Pipeline']

@pulumi.input_type
class PipelineArgs:
    def __init__(__self__, *,
                 pipeline_activities: pulumi.Input[Sequence[pulumi.Input['PipelineActivityArgs']]],
                 pipeline_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a Pipeline resource.
        :param pulumi.Input[Sequence[pulumi.Input['PipelineActivityArgs']]] pipeline_activities: A list of "PipelineActivity" objects. Activities perform transformations on your messages, such as removing, renaming or adding message attributes; filtering messages based on attribute values; invoking your Lambda functions on messages for advanced processing; or performing mathematical transformations to normalize device data.
               
               The list can be 2-25 *PipelineActivity* objects and must contain both a `channel` and a `datastore` activity. Each entry in the list must contain only one activity, for example:
               
               `pipelineActivities = [ { "channel": { ... } }, { "lambda": { ... } }, ... ]`
        :param pulumi.Input[str] pipeline_name: The name of the pipeline.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: Metadata which can be used to manage the pipeline.
               
               For more information, see [Tag](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html) .
        """
        pulumi.set(__self__, "pipeline_activities", pipeline_activities)
        if pipeline_name is not None:
            pulumi.set(__self__, "pipeline_name", pipeline_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="pipelineActivities")
    def pipeline_activities(self) -> pulumi.Input[Sequence[pulumi.Input['PipelineActivityArgs']]]:
        """
        A list of "PipelineActivity" objects. Activities perform transformations on your messages, such as removing, renaming or adding message attributes; filtering messages based on attribute values; invoking your Lambda functions on messages for advanced processing; or performing mathematical transformations to normalize device data.

        The list can be 2-25 *PipelineActivity* objects and must contain both a `channel` and a `datastore` activity. Each entry in the list must contain only one activity, for example:

        `pipelineActivities = [ { "channel": { ... } }, { "lambda": { ... } }, ... ]`
        """
        return pulumi.get(self, "pipeline_activities")

    @pipeline_activities.setter
    def pipeline_activities(self, value: pulumi.Input[Sequence[pulumi.Input['PipelineActivityArgs']]]):
        pulumi.set(self, "pipeline_activities", value)

    @property
    @pulumi.getter(name="pipelineName")
    def pipeline_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the pipeline.
        """
        return pulumi.get(self, "pipeline_name")

    @pipeline_name.setter
    def pipeline_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pipeline_name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        Metadata which can be used to manage the pipeline.

        For more information, see [Tag](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html) .
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


class Pipeline(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 pipeline_activities: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PipelineActivityArgs', 'PipelineActivityArgsDict']]]]] = None,
                 pipeline_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::IoTAnalytics::Pipeline

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        pipeline = aws_native.iotanalytics.Pipeline("pipeline",
            pipeline_name="SimplePipeline",
            pipeline_activities=[{
                "channel": {
                    "name": "ChannelActivity",
                    "channel_name": "SimpleChannel",
                    "next": "DatastoreActivity",
                },
                "datastore": {
                    "name": "DatastoreActivity",
                    "datastore_name": "SimpleDatastore",
                },
            }])

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        pipeline = aws_native.iotanalytics.Pipeline("pipeline",
            pipeline_name="SimplePipeline",
            pipeline_activities=[{
                "channel": {
                    "name": "ChannelActivity",
                    "channel_name": "SimpleChannel",
                    "next": "DatastoreActivity",
                },
                "datastore": {
                    "name": "DatastoreActivity",
                    "datastore_name": "SimpleDatastore",
                },
            }])

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        pipeline = aws_native.iotanalytics.Pipeline("pipeline",
            pipeline_name="ComplexPipeline",
            pipeline_activities=[{
                "channel": {
                    "name": "ChannelActivity",
                    "channel_name": "Channel",
                    "next": "LambdaActivity",
                },
                "lambda_": {
                    "name": "LambdaActivity",
                    "lambda_name": "Lambda",
                    "batch_size": 1,
                    "next": "AddAttributesActivity",
                },
                "add_attributes": {
                    "name": "AddAttributesActivity",
                    "attributes": {
                        "key1": "attribute1",
                        "key2": "attribute2",
                    },
                    "next": "RemoveAttributesActivity",
                },
                "remove_attributes": {
                    "name": "RemoveAttributesActivity",
                    "attributes": [
                        "attribute1",
                        "attribute2",
                    ],
                    "next": "SelectAttributesActivity",
                },
                "select_attributes": {
                    "name": "SelectAttributesActivity",
                    "attributes": [
                        "attribute1",
                        "attribute2",
                    ],
                    "next": "FilterActivity",
                },
                "filter": {
                    "name": "FilterActivity",
                    "filter": "attribute1 > 40 AND attribute2 < 20",
                    "next": "MathActivity",
                },
                "math": {
                    "name": "MathActivity",
                    "attribute": "attribute",
                    "math": "attribute - 10",
                    "next": "DeviceRegistryEnrichActivity",
                },
                "device_registry_enrich": {
                    "name": "DeviceRegistryEnrichActivity",
                    "attribute": "attribute",
                    "thing_name": "thingName",
                    "role_arn": "arn:aws:iam::<your_Account_Id>:role/Enrich",
                    "next": "DeviceShadowEnrichActivity",
                },
                "device_shadow_enrich": {
                    "name": "DeviceShadowEnrichActivity",
                    "attribute": "attribute",
                    "thing_name": "thingName",
                    "role_arn": "arn:aws:iam::<your_Account_Id>:role/Enrich",
                    "next": "DatastoreActivity",
                },
                "datastore": {
                    "name": "DatastoreActivity",
                    "datastore_name": "Datastore",
                },
            }])

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        pipeline = aws_native.iotanalytics.Pipeline("pipeline",
            pipeline_name="ComplexPipeline",
            pipeline_activities=[{
                "channel": {
                    "name": "ChannelActivity",
                    "channel_name": "Channel",
                    "next": "LambdaActivity",
                },
                "lambda_": {
                    "name": "LambdaActivity",
                    "lambda_name": "Lambda",
                    "batch_size": 1,
                    "next": "AddAttributesActivity",
                },
                "add_attributes": {
                    "name": "AddAttributesActivity",
                    "attributes": {
                        "key1": "attribute1",
                        "key2": "attribute2",
                    },
                    "next": "RemoveAttributesActivity",
                },
                "remove_attributes": {
                    "name": "RemoveAttributesActivity",
                    "attributes": [
                        "attribute1",
                        "attribute2",
                    ],
                    "next": "SelectAttributesActivity",
                },
                "select_attributes": {
                    "name": "SelectAttributesActivity",
                    "attributes": [
                        "attribute1",
                        "attribute2",
                    ],
                    "next": "FilterActivity",
                },
                "filter": {
                    "name": "FilterActivity",
                    "filter": "attribute1 > 40 AND attribute2 < 20",
                    "next": "MathActivity",
                },
                "math": {
                    "name": "MathActivity",
                    "attribute": "attribute",
                    "math": "attribute - 10",
                    "next": "DeviceRegistryEnrichActivity",
                },
                "device_registry_enrich": {
                    "name": "DeviceRegistryEnrichActivity",
                    "attribute": "attribute",
                    "thing_name": "thingName",
                    "role_arn": "arn:aws:iam::<your_Account_Id>:role/Enrich",
                    "next": "DeviceShadowEnrichActivity",
                },
                "device_shadow_enrich": {
                    "name": "DeviceShadowEnrichActivity",
                    "attribute": "attribute",
                    "thing_name": "thingName",
                    "role_arn": "arn:aws:iam::<your_Account_Id>:role/Enrich",
                    "next": "DatastoreActivity",
                },
                "datastore": {
                    "name": "DatastoreActivity",
                    "datastore_name": "Datastore",
                },
            }])

        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PipelineActivityArgs', 'PipelineActivityArgsDict']]]] pipeline_activities: A list of "PipelineActivity" objects. Activities perform transformations on your messages, such as removing, renaming or adding message attributes; filtering messages based on attribute values; invoking your Lambda functions on messages for advanced processing; or performing mathematical transformations to normalize device data.
               
               The list can be 2-25 *PipelineActivity* objects and must contain both a `channel` and a `datastore` activity. Each entry in the list must contain only one activity, for example:
               
               `pipelineActivities = [ { "channel": { ... } }, { "lambda": { ... } }, ... ]`
        :param pulumi.Input[str] pipeline_name: The name of the pipeline.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: Metadata which can be used to manage the pipeline.
               
               For more information, see [Tag](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html) .
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PipelineArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::IoTAnalytics::Pipeline

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        pipeline = aws_native.iotanalytics.Pipeline("pipeline",
            pipeline_name="SimplePipeline",
            pipeline_activities=[{
                "channel": {
                    "name": "ChannelActivity",
                    "channel_name": "SimpleChannel",
                    "next": "DatastoreActivity",
                },
                "datastore": {
                    "name": "DatastoreActivity",
                    "datastore_name": "SimpleDatastore",
                },
            }])

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        pipeline = aws_native.iotanalytics.Pipeline("pipeline",
            pipeline_name="SimplePipeline",
            pipeline_activities=[{
                "channel": {
                    "name": "ChannelActivity",
                    "channel_name": "SimpleChannel",
                    "next": "DatastoreActivity",
                },
                "datastore": {
                    "name": "DatastoreActivity",
                    "datastore_name": "SimpleDatastore",
                },
            }])

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        pipeline = aws_native.iotanalytics.Pipeline("pipeline",
            pipeline_name="ComplexPipeline",
            pipeline_activities=[{
                "channel": {
                    "name": "ChannelActivity",
                    "channel_name": "Channel",
                    "next": "LambdaActivity",
                },
                "lambda_": {
                    "name": "LambdaActivity",
                    "lambda_name": "Lambda",
                    "batch_size": 1,
                    "next": "AddAttributesActivity",
                },
                "add_attributes": {
                    "name": "AddAttributesActivity",
                    "attributes": {
                        "key1": "attribute1",
                        "key2": "attribute2",
                    },
                    "next": "RemoveAttributesActivity",
                },
                "remove_attributes": {
                    "name": "RemoveAttributesActivity",
                    "attributes": [
                        "attribute1",
                        "attribute2",
                    ],
                    "next": "SelectAttributesActivity",
                },
                "select_attributes": {
                    "name": "SelectAttributesActivity",
                    "attributes": [
                        "attribute1",
                        "attribute2",
                    ],
                    "next": "FilterActivity",
                },
                "filter": {
                    "name": "FilterActivity",
                    "filter": "attribute1 > 40 AND attribute2 < 20",
                    "next": "MathActivity",
                },
                "math": {
                    "name": "MathActivity",
                    "attribute": "attribute",
                    "math": "attribute - 10",
                    "next": "DeviceRegistryEnrichActivity",
                },
                "device_registry_enrich": {
                    "name": "DeviceRegistryEnrichActivity",
                    "attribute": "attribute",
                    "thing_name": "thingName",
                    "role_arn": "arn:aws:iam::<your_Account_Id>:role/Enrich",
                    "next": "DeviceShadowEnrichActivity",
                },
                "device_shadow_enrich": {
                    "name": "DeviceShadowEnrichActivity",
                    "attribute": "attribute",
                    "thing_name": "thingName",
                    "role_arn": "arn:aws:iam::<your_Account_Id>:role/Enrich",
                    "next": "DatastoreActivity",
                },
                "datastore": {
                    "name": "DatastoreActivity",
                    "datastore_name": "Datastore",
                },
            }])

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        pipeline = aws_native.iotanalytics.Pipeline("pipeline",
            pipeline_name="ComplexPipeline",
            pipeline_activities=[{
                "channel": {
                    "name": "ChannelActivity",
                    "channel_name": "Channel",
                    "next": "LambdaActivity",
                },
                "lambda_": {
                    "name": "LambdaActivity",
                    "lambda_name": "Lambda",
                    "batch_size": 1,
                    "next": "AddAttributesActivity",
                },
                "add_attributes": {
                    "name": "AddAttributesActivity",
                    "attributes": {
                        "key1": "attribute1",
                        "key2": "attribute2",
                    },
                    "next": "RemoveAttributesActivity",
                },
                "remove_attributes": {
                    "name": "RemoveAttributesActivity",
                    "attributes": [
                        "attribute1",
                        "attribute2",
                    ],
                    "next": "SelectAttributesActivity",
                },
                "select_attributes": {
                    "name": "SelectAttributesActivity",
                    "attributes": [
                        "attribute1",
                        "attribute2",
                    ],
                    "next": "FilterActivity",
                },
                "filter": {
                    "name": "FilterActivity",
                    "filter": "attribute1 > 40 AND attribute2 < 20",
                    "next": "MathActivity",
                },
                "math": {
                    "name": "MathActivity",
                    "attribute": "attribute",
                    "math": "attribute - 10",
                    "next": "DeviceRegistryEnrichActivity",
                },
                "device_registry_enrich": {
                    "name": "DeviceRegistryEnrichActivity",
                    "attribute": "attribute",
                    "thing_name": "thingName",
                    "role_arn": "arn:aws:iam::<your_Account_Id>:role/Enrich",
                    "next": "DeviceShadowEnrichActivity",
                },
                "device_shadow_enrich": {
                    "name": "DeviceShadowEnrichActivity",
                    "attribute": "attribute",
                    "thing_name": "thingName",
                    "role_arn": "arn:aws:iam::<your_Account_Id>:role/Enrich",
                    "next": "DatastoreActivity",
                },
                "datastore": {
                    "name": "DatastoreActivity",
                    "datastore_name": "Datastore",
                },
            }])

        ```

        :param str resource_name: The name of the resource.
        :param PipelineArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PipelineArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 pipeline_activities: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PipelineActivityArgs', 'PipelineActivityArgsDict']]]]] = None,
                 pipeline_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PipelineArgs.__new__(PipelineArgs)

            if pipeline_activities is None and not opts.urn:
                raise TypeError("Missing required property 'pipeline_activities'")
            __props__.__dict__["pipeline_activities"] = pipeline_activities
            __props__.__dict__["pipeline_name"] = pipeline_name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["aws_id"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["pipelineName"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Pipeline, __self__).__init__(
            'aws-native:iotanalytics:Pipeline',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Pipeline':
        """
        Get an existing Pipeline resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = PipelineArgs.__new__(PipelineArgs)

        __props__.__dict__["aws_id"] = None
        __props__.__dict__["pipeline_activities"] = None
        __props__.__dict__["pipeline_name"] = None
        __props__.__dict__["tags"] = None
        return Pipeline(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="awsId")
    def aws_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "aws_id")

    @property
    @pulumi.getter(name="pipelineActivities")
    def pipeline_activities(self) -> pulumi.Output[Sequence['outputs.PipelineActivity']]:
        """
        A list of "PipelineActivity" objects. Activities perform transformations on your messages, such as removing, renaming or adding message attributes; filtering messages based on attribute values; invoking your Lambda functions on messages for advanced processing; or performing mathematical transformations to normalize device data.

        The list can be 2-25 *PipelineActivity* objects and must contain both a `channel` and a `datastore` activity. Each entry in the list must contain only one activity, for example:

        `pipelineActivities = [ { "channel": { ... } }, { "lambda": { ... } }, ... ]`
        """
        return pulumi.get(self, "pipeline_activities")

    @property
    @pulumi.getter(name="pipelineName")
    def pipeline_name(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the pipeline.
        """
        return pulumi.get(self, "pipeline_name")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        Metadata which can be used to manage the pipeline.

        For more information, see [Tag](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html) .
        """
        return pulumi.get(self, "tags")

