# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetTopicRuleResult',
    'AwaitableGetTopicRuleResult',
    'get_topic_rule',
    'get_topic_rule_output',
]

@pulumi.output_type
class GetTopicRuleResult:
    def __init__(__self__, arn=None, tags=None, topic_rule_payload=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if topic_rule_payload and not isinstance(topic_rule_payload, dict):
            raise TypeError("Expected argument 'topic_rule_payload' to be a dict")
        pulumi.set(__self__, "topic_rule_payload", topic_rule_payload)

    @property
    @pulumi.getter
    def arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the AWS IoT rule, such as `arn:aws:iot:us-east-2:123456789012:rule/MyIoTRule` .
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        Metadata which can be used to manage the topic rule.

        > For URI Request parameters use format: ...key1=value1&key2=value2...
        > 
        > For the CLI command-line parameter use format: --tags "key1=value1&key2=value2..."
        > 
        > For the cli-input-json file use format: "tags": "key1=value1&key2=value2..."
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="topicRulePayload")
    def topic_rule_payload(self) -> Optional['outputs.TopicRulePayload']:
        """
        The rule payload.
        """
        return pulumi.get(self, "topic_rule_payload")


class AwaitableGetTopicRuleResult(GetTopicRuleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTopicRuleResult(
            arn=self.arn,
            tags=self.tags,
            topic_rule_payload=self.topic_rule_payload)


def get_topic_rule(rule_name: Optional[str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTopicRuleResult:
    """
    Resource Type definition for AWS::IoT::TopicRule


    :param str rule_name: The name of the rule.
           
           *Pattern* : `^[a-zA-Z0-9_]+$`
    """
    __args__ = dict()
    __args__['ruleName'] = rule_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:iot:getTopicRule', __args__, opts=opts, typ=GetTopicRuleResult).value

    return AwaitableGetTopicRuleResult(
        arn=pulumi.get(__ret__, 'arn'),
        tags=pulumi.get(__ret__, 'tags'),
        topic_rule_payload=pulumi.get(__ret__, 'topic_rule_payload'))
def get_topic_rule_output(rule_name: Optional[pulumi.Input[str]] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetTopicRuleResult]:
    """
    Resource Type definition for AWS::IoT::TopicRule


    :param str rule_name: The name of the rule.
           
           *Pattern* : `^[a-zA-Z0-9_]+$`
    """
    __args__ = dict()
    __args__['ruleName'] = rule_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:iot:getTopicRule', __args__, opts=opts, typ=GetTopicRuleResult)
    return __ret__.apply(lambda __response__: GetTopicRuleResult(
        arn=pulumi.get(__response__, 'arn'),
        tags=pulumi.get(__response__, 'tags'),
        topic_rule_payload=pulumi.get(__response__, 'topic_rule_payload')))
