# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetSoftwarePackageVersionResult',
    'AwaitableGetSoftwarePackageVersionResult',
    'get_software_package_version',
    'get_software_package_version_output',
]

@pulumi.output_type
class GetSoftwarePackageVersionResult:
    def __init__(__self__, attributes=None, description=None, error_reason=None, package_version_arn=None, status=None, tags=None):
        if attributes and not isinstance(attributes, dict):
            raise TypeError("Expected argument 'attributes' to be a dict")
        pulumi.set(__self__, "attributes", attributes)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if error_reason and not isinstance(error_reason, str):
            raise TypeError("Expected argument 'error_reason' to be a str")
        pulumi.set(__self__, "error_reason", error_reason)
        if package_version_arn and not isinstance(package_version_arn, str):
            raise TypeError("Expected argument 'package_version_arn' to be a str")
        pulumi.set(__self__, "package_version_arn", package_version_arn)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def attributes(self) -> Optional[Mapping[str, str]]:
        return pulumi.get(self, "attributes")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="errorReason")
    def error_reason(self) -> Optional[str]:
        """
        Error reason for a package version failure during creation or update.
        """
        return pulumi.get(self, "error_reason")

    @property
    @pulumi.getter(name="packageVersionArn")
    def package_version_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) for the package.
        """
        return pulumi.get(self, "package_version_arn")

    @property
    @pulumi.getter
    def status(self) -> Optional['SoftwarePackageVersionPackageVersionStatus']:
        """
        The status of the package version. For more information, see [Package version lifecycle](https://docs.aws.amazon.com/iot/latest/developerguide/preparing-to-use-software-package-catalog.html#package-version-lifecycle) .
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")


class AwaitableGetSoftwarePackageVersionResult(GetSoftwarePackageVersionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSoftwarePackageVersionResult(
            attributes=self.attributes,
            description=self.description,
            error_reason=self.error_reason,
            package_version_arn=self.package_version_arn,
            status=self.status,
            tags=self.tags)


def get_software_package_version(package_name: Optional[str] = None,
                                 version_name: Optional[str] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSoftwarePackageVersionResult:
    """
    resource definition
    """
    __args__ = dict()
    __args__['packageName'] = package_name
    __args__['versionName'] = version_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:iot:getSoftwarePackageVersion', __args__, opts=opts, typ=GetSoftwarePackageVersionResult).value

    return AwaitableGetSoftwarePackageVersionResult(
        attributes=pulumi.get(__ret__, 'attributes'),
        description=pulumi.get(__ret__, 'description'),
        error_reason=pulumi.get(__ret__, 'error_reason'),
        package_version_arn=pulumi.get(__ret__, 'package_version_arn'),
        status=pulumi.get(__ret__, 'status'),
        tags=pulumi.get(__ret__, 'tags'))
def get_software_package_version_output(package_name: Optional[pulumi.Input[str]] = None,
                                        version_name: Optional[pulumi.Input[str]] = None,
                                        opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetSoftwarePackageVersionResult]:
    """
    resource definition
    """
    __args__ = dict()
    __args__['packageName'] = package_name
    __args__['versionName'] = version_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:iot:getSoftwarePackageVersion', __args__, opts=opts, typ=GetSoftwarePackageVersionResult)
    return __ret__.apply(lambda __response__: GetSoftwarePackageVersionResult(
        attributes=pulumi.get(__response__, 'attributes'),
        description=pulumi.get(__response__, 'description'),
        error_reason=pulumi.get(__response__, 'error_reason'),
        package_version_arn=pulumi.get(__response__, 'package_version_arn'),
        status=pulumi.get(__response__, 'status'),
        tags=pulumi.get(__response__, 'tags')))
