# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AccountAuditConfigurationArgs', 'AccountAuditConfiguration']

@pulumi.input_type
class AccountAuditConfigurationArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[str],
                 audit_check_configurations: pulumi.Input['AccountAuditConfigurationAuditCheckConfigurationsArgs'],
                 role_arn: pulumi.Input[str],
                 audit_notification_target_configurations: Optional[pulumi.Input['AccountAuditConfigurationAuditNotificationTargetConfigurationsArgs']] = None):
        """
        The set of arguments for constructing a AccountAuditConfiguration resource.
        :param pulumi.Input[str] account_id: Your 12-digit account ID (used as the primary identifier for the CloudFormation resource).
        :param pulumi.Input['AccountAuditConfigurationAuditCheckConfigurationsArgs'] audit_check_configurations: Specifies which audit checks are enabled and disabled for this account.
               
               Some data collection might start immediately when certain checks are enabled. When a check is disabled, any data collected so far in relation to the check is deleted. To disable a check, set the value of the `Enabled:` key to `false` .
               
               If an enabled check is removed from the template, it will also be disabled.
               
               You can't disable a check if it's used by any scheduled audit. You must delete the check from the scheduled audit or delete the scheduled audit itself to disable the check.
               
               For more information on avialbe auidt checks see [AWS::IoT::AccountAuditConfiguration AuditCheckConfigurations](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-accountauditconfiguration-auditcheckconfigurations.html)
        :param pulumi.Input[str] role_arn: The ARN of the role that grants permission to AWS IoT to access information about your devices, policies, certificates and other items as required when performing an audit.
        :param pulumi.Input['AccountAuditConfigurationAuditNotificationTargetConfigurationsArgs'] audit_notification_target_configurations: Information about the targets to which audit notifications are sent.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "audit_check_configurations", audit_check_configurations)
        pulumi.set(__self__, "role_arn", role_arn)
        if audit_notification_target_configurations is not None:
            pulumi.set(__self__, "audit_notification_target_configurations", audit_notification_target_configurations)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[str]:
        """
        Your 12-digit account ID (used as the primary identifier for the CloudFormation resource).
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="auditCheckConfigurations")
    def audit_check_configurations(self) -> pulumi.Input['AccountAuditConfigurationAuditCheckConfigurationsArgs']:
        """
        Specifies which audit checks are enabled and disabled for this account.

        Some data collection might start immediately when certain checks are enabled. When a check is disabled, any data collected so far in relation to the check is deleted. To disable a check, set the value of the `Enabled:` key to `false` .

        If an enabled check is removed from the template, it will also be disabled.

        You can't disable a check if it's used by any scheduled audit. You must delete the check from the scheduled audit or delete the scheduled audit itself to disable the check.

        For more information on avialbe auidt checks see [AWS::IoT::AccountAuditConfiguration AuditCheckConfigurations](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-accountauditconfiguration-auditcheckconfigurations.html)
        """
        return pulumi.get(self, "audit_check_configurations")

    @audit_check_configurations.setter
    def audit_check_configurations(self, value: pulumi.Input['AccountAuditConfigurationAuditCheckConfigurationsArgs']):
        pulumi.set(self, "audit_check_configurations", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Input[str]:
        """
        The ARN of the role that grants permission to AWS IoT to access information about your devices, policies, certificates and other items as required when performing an audit.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter(name="auditNotificationTargetConfigurations")
    def audit_notification_target_configurations(self) -> Optional[pulumi.Input['AccountAuditConfigurationAuditNotificationTargetConfigurationsArgs']]:
        """
        Information about the targets to which audit notifications are sent.
        """
        return pulumi.get(self, "audit_notification_target_configurations")

    @audit_notification_target_configurations.setter
    def audit_notification_target_configurations(self, value: Optional[pulumi.Input['AccountAuditConfigurationAuditNotificationTargetConfigurationsArgs']]):
        pulumi.set(self, "audit_notification_target_configurations", value)


class AccountAuditConfiguration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[str]] = None,
                 audit_check_configurations: Optional[pulumi.Input[Union['AccountAuditConfigurationAuditCheckConfigurationsArgs', 'AccountAuditConfigurationAuditCheckConfigurationsArgsDict']]] = None,
                 audit_notification_target_configurations: Optional[pulumi.Input[Union['AccountAuditConfigurationAuditNotificationTargetConfigurationsArgs', 'AccountAuditConfigurationAuditNotificationTargetConfigurationsArgsDict']]] = None,
                 role_arn: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Configures the Device Defender audit settings for this account. Settings include how audit notifications are sent and which audit checks are enabled or disabled.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_id: Your 12-digit account ID (used as the primary identifier for the CloudFormation resource).
        :param pulumi.Input[Union['AccountAuditConfigurationAuditCheckConfigurationsArgs', 'AccountAuditConfigurationAuditCheckConfigurationsArgsDict']] audit_check_configurations: Specifies which audit checks are enabled and disabled for this account.
               
               Some data collection might start immediately when certain checks are enabled. When a check is disabled, any data collected so far in relation to the check is deleted. To disable a check, set the value of the `Enabled:` key to `false` .
               
               If an enabled check is removed from the template, it will also be disabled.
               
               You can't disable a check if it's used by any scheduled audit. You must delete the check from the scheduled audit or delete the scheduled audit itself to disable the check.
               
               For more information on avialbe auidt checks see [AWS::IoT::AccountAuditConfiguration AuditCheckConfigurations](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-accountauditconfiguration-auditcheckconfigurations.html)
        :param pulumi.Input[Union['AccountAuditConfigurationAuditNotificationTargetConfigurationsArgs', 'AccountAuditConfigurationAuditNotificationTargetConfigurationsArgsDict']] audit_notification_target_configurations: Information about the targets to which audit notifications are sent.
        :param pulumi.Input[str] role_arn: The ARN of the role that grants permission to AWS IoT to access information about your devices, policies, certificates and other items as required when performing an audit.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AccountAuditConfigurationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Configures the Device Defender audit settings for this account. Settings include how audit notifications are sent and which audit checks are enabled or disabled.

        :param str resource_name: The name of the resource.
        :param AccountAuditConfigurationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AccountAuditConfigurationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[str]] = None,
                 audit_check_configurations: Optional[pulumi.Input[Union['AccountAuditConfigurationAuditCheckConfigurationsArgs', 'AccountAuditConfigurationAuditCheckConfigurationsArgsDict']]] = None,
                 audit_notification_target_configurations: Optional[pulumi.Input[Union['AccountAuditConfigurationAuditNotificationTargetConfigurationsArgs', 'AccountAuditConfigurationAuditNotificationTargetConfigurationsArgsDict']]] = None,
                 role_arn: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AccountAuditConfigurationArgs.__new__(AccountAuditConfigurationArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            if audit_check_configurations is None and not opts.urn:
                raise TypeError("Missing required property 'audit_check_configurations'")
            __props__.__dict__["audit_check_configurations"] = audit_check_configurations
            __props__.__dict__["audit_notification_target_configurations"] = audit_notification_target_configurations
            if role_arn is None and not opts.urn:
                raise TypeError("Missing required property 'role_arn'")
            __props__.__dict__["role_arn"] = role_arn
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["accountId"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(AccountAuditConfiguration, __self__).__init__(
            'aws-native:iot:AccountAuditConfiguration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'AccountAuditConfiguration':
        """
        Get an existing AccountAuditConfiguration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = AccountAuditConfigurationArgs.__new__(AccountAuditConfigurationArgs)

        __props__.__dict__["account_id"] = None
        __props__.__dict__["audit_check_configurations"] = None
        __props__.__dict__["audit_notification_target_configurations"] = None
        __props__.__dict__["role_arn"] = None
        return AccountAuditConfiguration(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[str]:
        """
        Your 12-digit account ID (used as the primary identifier for the CloudFormation resource).
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="auditCheckConfigurations")
    def audit_check_configurations(self) -> pulumi.Output['outputs.AccountAuditConfigurationAuditCheckConfigurations']:
        """
        Specifies which audit checks are enabled and disabled for this account.

        Some data collection might start immediately when certain checks are enabled. When a check is disabled, any data collected so far in relation to the check is deleted. To disable a check, set the value of the `Enabled:` key to `false` .

        If an enabled check is removed from the template, it will also be disabled.

        You can't disable a check if it's used by any scheduled audit. You must delete the check from the scheduled audit or delete the scheduled audit itself to disable the check.

        For more information on avialbe auidt checks see [AWS::IoT::AccountAuditConfiguration AuditCheckConfigurations](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-accountauditconfiguration-auditcheckconfigurations.html)
        """
        return pulumi.get(self, "audit_check_configurations")

    @property
    @pulumi.getter(name="auditNotificationTargetConfigurations")
    def audit_notification_target_configurations(self) -> pulumi.Output[Optional['outputs.AccountAuditConfigurationAuditNotificationTargetConfigurations']]:
        """
        Information about the targets to which audit notifications are sent.
        """
        return pulumi.get(self, "audit_notification_target_configurations")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Output[str]:
        """
        The ARN of the role that grants permission to AWS IoT to access information about your devices, policies, certificates and other items as required when performing an audit.
        """
        return pulumi.get(self, "role_arn")

