# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetMonitorResult',
    'AwaitableGetMonitorResult',
    'get_monitor',
    'get_monitor_output',
]

@pulumi.output_type
class GetMonitorResult:
    def __init__(__self__, created_at=None, health_events_config=None, internet_measurements_log_delivery=None, max_city_networks_to_monitor=None, modified_at=None, monitor_arn=None, processing_status=None, processing_status_info=None, resources=None, status=None, tags=None, traffic_percentage_to_monitor=None):
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if health_events_config and not isinstance(health_events_config, dict):
            raise TypeError("Expected argument 'health_events_config' to be a dict")
        pulumi.set(__self__, "health_events_config", health_events_config)
        if internet_measurements_log_delivery and not isinstance(internet_measurements_log_delivery, dict):
            raise TypeError("Expected argument 'internet_measurements_log_delivery' to be a dict")
        pulumi.set(__self__, "internet_measurements_log_delivery", internet_measurements_log_delivery)
        if max_city_networks_to_monitor and not isinstance(max_city_networks_to_monitor, int):
            raise TypeError("Expected argument 'max_city_networks_to_monitor' to be a int")
        pulumi.set(__self__, "max_city_networks_to_monitor", max_city_networks_to_monitor)
        if modified_at and not isinstance(modified_at, str):
            raise TypeError("Expected argument 'modified_at' to be a str")
        pulumi.set(__self__, "modified_at", modified_at)
        if monitor_arn and not isinstance(monitor_arn, str):
            raise TypeError("Expected argument 'monitor_arn' to be a str")
        pulumi.set(__self__, "monitor_arn", monitor_arn)
        if processing_status and not isinstance(processing_status, str):
            raise TypeError("Expected argument 'processing_status' to be a str")
        pulumi.set(__self__, "processing_status", processing_status)
        if processing_status_info and not isinstance(processing_status_info, str):
            raise TypeError("Expected argument 'processing_status_info' to be a str")
        pulumi.set(__self__, "processing_status_info", processing_status_info)
        if resources and not isinstance(resources, list):
            raise TypeError("Expected argument 'resources' to be a list")
        pulumi.set(__self__, "resources", resources)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if traffic_percentage_to_monitor and not isinstance(traffic_percentage_to_monitor, int):
            raise TypeError("Expected argument 'traffic_percentage_to_monitor' to be a int")
        pulumi.set(__self__, "traffic_percentage_to_monitor", traffic_percentage_to_monitor)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The time when the monitor was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="healthEventsConfig")
    def health_events_config(self) -> Optional['outputs.MonitorHealthEventsConfig']:
        """
        A complex type with the configuration information that determines the threshold and other conditions for when Internet Monitor creates a health event for an overall performance or availability issue, across an application's geographies.

        Defines the percentages, for overall performance scores and availability scores for an application, that are the thresholds for when Amazon CloudWatch Internet Monitor creates a health event. You can override the defaults to set a custom threshold for overall performance or availability scores, or both.

        You can also set thresholds for local health scores,, where Internet Monitor creates a health event when scores cross a threshold for one or more city-networks, in addition to creating an event when an overall score crosses a threshold.

        If you don't set a health event threshold, the default value is 95%.

        For local thresholds, you also set a minimum percentage of overall traffic that is impacted by an issue before Internet Monitor creates an event. In addition, you can disable local thresholds, for performance scores, availability scores, or both.

        For more information, see [Change health event thresholds](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-overview.html#IMUpdateThresholdFromOverview) in the Internet Monitor section of the *CloudWatch User Guide* .
        """
        return pulumi.get(self, "health_events_config")

    @property
    @pulumi.getter(name="internetMeasurementsLogDelivery")
    def internet_measurements_log_delivery(self) -> Optional['outputs.MonitorInternetMeasurementsLogDelivery']:
        """
        Publish internet measurements for a monitor for all city-networks (up to the 500,000 service limit) to another location, such as an Amazon S3 bucket. Measurements are also published to Amazon CloudWatch Logs for the first 500 (by traffic volume) city-networks (client locations and ASNs, typically internet service providers or ISPs).
        """
        return pulumi.get(self, "internet_measurements_log_delivery")

    @property
    @pulumi.getter(name="maxCityNetworksToMonitor")
    def max_city_networks_to_monitor(self) -> Optional[int]:
        """
        The maximum number of city-networks to monitor for your resources. A city-network is the location (city) where clients access your application resources from and the network, such as an internet service provider, that clients access the resources through.

        For more information, see [Choosing a city-network maximum value](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/IMCityNetworksMaximum.html) in *Using Amazon CloudWatch Internet Monitor* .
        """
        return pulumi.get(self, "max_city_networks_to_monitor")

    @property
    @pulumi.getter(name="modifiedAt")
    def modified_at(self) -> Optional[str]:
        """
        The last time that the monitor was modified.
        """
        return pulumi.get(self, "modified_at")

    @property
    @pulumi.getter(name="monitorArn")
    def monitor_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the monitor.
        """
        return pulumi.get(self, "monitor_arn")

    @property
    @pulumi.getter(name="processingStatus")
    def processing_status(self) -> Optional['MonitorProcessingStatusCode']:
        """
        The health of data processing for the monitor. For more information, see `ProcessingStatus` under [MonitorListMember](https://docs.aws.amazon.com/internet-monitor/latest/api/API_MonitorListMember.html) in the *Amazon CloudWatch Internet Monitor API Reference* .
        """
        return pulumi.get(self, "processing_status")

    @property
    @pulumi.getter(name="processingStatusInfo")
    def processing_status_info(self) -> Optional[str]:
        """
        Additional information about the health of the data processing for the monitor.
        """
        return pulumi.get(self, "processing_status_info")

    @property
    @pulumi.getter
    def resources(self) -> Optional[Sequence[str]]:
        """
        The resources that have been added for the monitor, listed by their Amazon Resource Names (ARNs). Use this option to add or remove resources when making an update.

        > Be aware that if you include content in the `Resources` field when you update a monitor, the `ResourcesToAdd` and `ResourcesToRemove` fields must be empty.
        """
        return pulumi.get(self, "resources")

    @property
    @pulumi.getter
    def status(self) -> Optional['MonitorConfigState']:
        """
        The status of a monitor. The accepted values that you can specify for `Status` are `ACTIVE` and `INACTIVE` .
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        The tags for a monitor, listed as a set of *key:value* pairs.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="trafficPercentageToMonitor")
    def traffic_percentage_to_monitor(self) -> Optional[int]:
        """
        The percentage of the internet-facing traffic for your application that you want to monitor. You can also, optionally, set a limit for the number of city-networks (client locations and ASNs, typically internet service providers) that Internet Monitor will monitor traffic for. The city-networks maximum limit caps the number of city-networks that Internet Monitor monitors for your application, regardless of the percentage of traffic that you choose to monitor.
        """
        return pulumi.get(self, "traffic_percentage_to_monitor")


class AwaitableGetMonitorResult(GetMonitorResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMonitorResult(
            created_at=self.created_at,
            health_events_config=self.health_events_config,
            internet_measurements_log_delivery=self.internet_measurements_log_delivery,
            max_city_networks_to_monitor=self.max_city_networks_to_monitor,
            modified_at=self.modified_at,
            monitor_arn=self.monitor_arn,
            processing_status=self.processing_status,
            processing_status_info=self.processing_status_info,
            resources=self.resources,
            status=self.status,
            tags=self.tags,
            traffic_percentage_to_monitor=self.traffic_percentage_to_monitor)


def get_monitor(monitor_name: Optional[str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMonitorResult:
    """
    Represents a monitor, which defines the monitoring boundaries for measurements that Internet Monitor publishes information about for an application


    :param str monitor_name: The name of the monitor. A monitor name can contain only alphanumeric characters, dashes (-), periods (.), and underscores (_).
    """
    __args__ = dict()
    __args__['monitorName'] = monitor_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:internetmonitor:getMonitor', __args__, opts=opts, typ=GetMonitorResult).value

    return AwaitableGetMonitorResult(
        created_at=pulumi.get(__ret__, 'created_at'),
        health_events_config=pulumi.get(__ret__, 'health_events_config'),
        internet_measurements_log_delivery=pulumi.get(__ret__, 'internet_measurements_log_delivery'),
        max_city_networks_to_monitor=pulumi.get(__ret__, 'max_city_networks_to_monitor'),
        modified_at=pulumi.get(__ret__, 'modified_at'),
        monitor_arn=pulumi.get(__ret__, 'monitor_arn'),
        processing_status=pulumi.get(__ret__, 'processing_status'),
        processing_status_info=pulumi.get(__ret__, 'processing_status_info'),
        resources=pulumi.get(__ret__, 'resources'),
        status=pulumi.get(__ret__, 'status'),
        tags=pulumi.get(__ret__, 'tags'),
        traffic_percentage_to_monitor=pulumi.get(__ret__, 'traffic_percentage_to_monitor'))
def get_monitor_output(monitor_name: Optional[pulumi.Input[str]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetMonitorResult]:
    """
    Represents a monitor, which defines the monitoring boundaries for measurements that Internet Monitor publishes information about for an application


    :param str monitor_name: The name of the monitor. A monitor name can contain only alphanumeric characters, dashes (-), periods (.), and underscores (_).
    """
    __args__ = dict()
    __args__['monitorName'] = monitor_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:internetmonitor:getMonitor', __args__, opts=opts, typ=GetMonitorResult)
    return __ret__.apply(lambda __response__: GetMonitorResult(
        created_at=pulumi.get(__response__, 'created_at'),
        health_events_config=pulumi.get(__response__, 'health_events_config'),
        internet_measurements_log_delivery=pulumi.get(__response__, 'internet_measurements_log_delivery'),
        max_city_networks_to_monitor=pulumi.get(__response__, 'max_city_networks_to_monitor'),
        modified_at=pulumi.get(__response__, 'modified_at'),
        monitor_arn=pulumi.get(__response__, 'monitor_arn'),
        processing_status=pulumi.get(__response__, 'processing_status'),
        processing_status_info=pulumi.get(__response__, 'processing_status_info'),
        resources=pulumi.get(__response__, 'resources'),
        status=pulumi.get(__response__, 'status'),
        tags=pulumi.get(__response__, 'tags'),
        traffic_percentage_to_monitor=pulumi.get(__response__, 'traffic_percentage_to_monitor')))
