# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AssessmentTemplateArgs', 'AssessmentTemplate']

@pulumi.input_type
class AssessmentTemplateArgs:
    def __init__(__self__, *,
                 assessment_target_arn: pulumi.Input[str],
                 duration_in_seconds: pulumi.Input[int],
                 rules_package_arns: pulumi.Input[Sequence[pulumi.Input[str]]],
                 assessment_template_name: Optional[pulumi.Input[str]] = None,
                 user_attributes_for_findings: Optional[pulumi.Input[Sequence[pulumi.Input['AssessmentTemplateTagArgs']]]] = None):
        """
        The set of arguments for constructing a AssessmentTemplate resource.
        :param pulumi.Input[str] assessment_target_arn: The ARN of the assessment target to be included in the assessment template.
        :param pulumi.Input[int] duration_in_seconds: The duration of the assessment run in seconds.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] rules_package_arns: The ARNs of the rules packages that you want to use in the assessment template.
        :param pulumi.Input[str] assessment_template_name: The user-defined name that identifies the assessment template that you want to create. You can create several assessment templates for the same assessment target. The names of the assessment templates that correspond to a particular assessment target must be unique.
        :param pulumi.Input[Sequence[pulumi.Input['AssessmentTemplateTagArgs']]] user_attributes_for_findings: The user-defined attributes that are assigned to every finding that is generated by the assessment run that uses this assessment template. Within an assessment template, each key must be unique.
        """
        pulumi.set(__self__, "assessment_target_arn", assessment_target_arn)
        pulumi.set(__self__, "duration_in_seconds", duration_in_seconds)
        pulumi.set(__self__, "rules_package_arns", rules_package_arns)
        if assessment_template_name is not None:
            pulumi.set(__self__, "assessment_template_name", assessment_template_name)
        if user_attributes_for_findings is not None:
            pulumi.set(__self__, "user_attributes_for_findings", user_attributes_for_findings)

    @property
    @pulumi.getter(name="assessmentTargetArn")
    def assessment_target_arn(self) -> pulumi.Input[str]:
        """
        The ARN of the assessment target to be included in the assessment template.
        """
        return pulumi.get(self, "assessment_target_arn")

    @assessment_target_arn.setter
    def assessment_target_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "assessment_target_arn", value)

    @property
    @pulumi.getter(name="durationInSeconds")
    def duration_in_seconds(self) -> pulumi.Input[int]:
        """
        The duration of the assessment run in seconds.
        """
        return pulumi.get(self, "duration_in_seconds")

    @duration_in_seconds.setter
    def duration_in_seconds(self, value: pulumi.Input[int]):
        pulumi.set(self, "duration_in_seconds", value)

    @property
    @pulumi.getter(name="rulesPackageArns")
    def rules_package_arns(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The ARNs of the rules packages that you want to use in the assessment template.
        """
        return pulumi.get(self, "rules_package_arns")

    @rules_package_arns.setter
    def rules_package_arns(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "rules_package_arns", value)

    @property
    @pulumi.getter(name="assessmentTemplateName")
    def assessment_template_name(self) -> Optional[pulumi.Input[str]]:
        """
        The user-defined name that identifies the assessment template that you want to create. You can create several assessment templates for the same assessment target. The names of the assessment templates that correspond to a particular assessment target must be unique.
        """
        return pulumi.get(self, "assessment_template_name")

    @assessment_template_name.setter
    def assessment_template_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "assessment_template_name", value)

    @property
    @pulumi.getter(name="userAttributesForFindings")
    def user_attributes_for_findings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AssessmentTemplateTagArgs']]]]:
        """
        The user-defined attributes that are assigned to every finding that is generated by the assessment run that uses this assessment template. Within an assessment template, each key must be unique.
        """
        return pulumi.get(self, "user_attributes_for_findings")

    @user_attributes_for_findings.setter
    def user_attributes_for_findings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AssessmentTemplateTagArgs']]]]):
        pulumi.set(self, "user_attributes_for_findings", value)


class AssessmentTemplate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 assessment_target_arn: Optional[pulumi.Input[str]] = None,
                 assessment_template_name: Optional[pulumi.Input[str]] = None,
                 duration_in_seconds: Optional[pulumi.Input[int]] = None,
                 rules_package_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 user_attributes_for_findings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AssessmentTemplateTagArgs', 'AssessmentTemplateTagArgsDict']]]]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::Inspector::AssessmentTemplate

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] assessment_target_arn: The ARN of the assessment target to be included in the assessment template.
        :param pulumi.Input[str] assessment_template_name: The user-defined name that identifies the assessment template that you want to create. You can create several assessment templates for the same assessment target. The names of the assessment templates that correspond to a particular assessment target must be unique.
        :param pulumi.Input[int] duration_in_seconds: The duration of the assessment run in seconds.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] rules_package_arns: The ARNs of the rules packages that you want to use in the assessment template.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AssessmentTemplateTagArgs', 'AssessmentTemplateTagArgsDict']]]] user_attributes_for_findings: The user-defined attributes that are assigned to every finding that is generated by the assessment run that uses this assessment template. Within an assessment template, each key must be unique.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AssessmentTemplateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::Inspector::AssessmentTemplate

        :param str resource_name: The name of the resource.
        :param AssessmentTemplateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AssessmentTemplateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 assessment_target_arn: Optional[pulumi.Input[str]] = None,
                 assessment_template_name: Optional[pulumi.Input[str]] = None,
                 duration_in_seconds: Optional[pulumi.Input[int]] = None,
                 rules_package_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 user_attributes_for_findings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AssessmentTemplateTagArgs', 'AssessmentTemplateTagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AssessmentTemplateArgs.__new__(AssessmentTemplateArgs)

            if assessment_target_arn is None and not opts.urn:
                raise TypeError("Missing required property 'assessment_target_arn'")
            __props__.__dict__["assessment_target_arn"] = assessment_target_arn
            __props__.__dict__["assessment_template_name"] = assessment_template_name
            if duration_in_seconds is None and not opts.urn:
                raise TypeError("Missing required property 'duration_in_seconds'")
            __props__.__dict__["duration_in_seconds"] = duration_in_seconds
            if rules_package_arns is None and not opts.urn:
                raise TypeError("Missing required property 'rules_package_arns'")
            __props__.__dict__["rules_package_arns"] = rules_package_arns
            __props__.__dict__["user_attributes_for_findings"] = user_attributes_for_findings
            __props__.__dict__["arn"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["assessmentTargetArn", "assessmentTemplateName", "durationInSeconds", "rulesPackageArns[*]", "userAttributesForFindings[*]"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(AssessmentTemplate, __self__).__init__(
            'aws-native:inspector:AssessmentTemplate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'AssessmentTemplate':
        """
        Get an existing AssessmentTemplate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = AssessmentTemplateArgs.__new__(AssessmentTemplateArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["assessment_target_arn"] = None
        __props__.__dict__["assessment_template_name"] = None
        __props__.__dict__["duration_in_seconds"] = None
        __props__.__dict__["rules_package_arns"] = None
        __props__.__dict__["user_attributes_for_findings"] = None
        return AssessmentTemplate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN) that specifies the assessment template that is created.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="assessmentTargetArn")
    def assessment_target_arn(self) -> pulumi.Output[str]:
        """
        The ARN of the assessment target to be included in the assessment template.
        """
        return pulumi.get(self, "assessment_target_arn")

    @property
    @pulumi.getter(name="assessmentTemplateName")
    def assessment_template_name(self) -> pulumi.Output[Optional[str]]:
        """
        The user-defined name that identifies the assessment template that you want to create. You can create several assessment templates for the same assessment target. The names of the assessment templates that correspond to a particular assessment target must be unique.
        """
        return pulumi.get(self, "assessment_template_name")

    @property
    @pulumi.getter(name="durationInSeconds")
    def duration_in_seconds(self) -> pulumi.Output[int]:
        """
        The duration of the assessment run in seconds.
        """
        return pulumi.get(self, "duration_in_seconds")

    @property
    @pulumi.getter(name="rulesPackageArns")
    def rules_package_arns(self) -> pulumi.Output[Sequence[str]]:
        """
        The ARNs of the rules packages that you want to use in the assessment template.
        """
        return pulumi.get(self, "rules_package_arns")

    @property
    @pulumi.getter(name="userAttributesForFindings")
    def user_attributes_for_findings(self) -> pulumi.Output[Optional[Sequence['outputs.AssessmentTemplateTag']]]:
        """
        The user-defined attributes that are assigned to every finding that is generated by the assessment run that uses this assessment template. Within an assessment template, each key must be unique.
        """
        return pulumi.get(self, "user_attributes_for_findings")

