# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GroupPolicy',
    'RolePolicy',
    'UserLoginProfile',
    'UserPolicy',
]

@pulumi.output_type
class GroupPolicy(dict):
    """
    Contains information about an attached policy.
     An attached policy is a managed policy that has been attached to a user, group, or role.
     For more information about managed policies, see [Managed Policies and Inline Policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html) in the *User Guide*.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "policyDocument":
            suggest = "policy_document"
        elif key == "policyName":
            suggest = "policy_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GroupPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GroupPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GroupPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 policy_document: Any,
                 policy_name: str):
        """
        Contains information about an attached policy.
         An attached policy is a managed policy that has been attached to a user, group, or role.
         For more information about managed policies, see [Managed Policies and Inline Policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html) in the *User Guide*.
        :param Any policy_document: The policy document.
        :param str policy_name: The friendly name (not ARN) identifying the policy.
        """
        pulumi.set(__self__, "policy_document", policy_document)
        pulumi.set(__self__, "policy_name", policy_name)

    @property
    @pulumi.getter(name="policyDocument")
    def policy_document(self) -> Any:
        """
        The policy document.
        """
        return pulumi.get(self, "policy_document")

    @property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> str:
        """
        The friendly name (not ARN) identifying the policy.
        """
        return pulumi.get(self, "policy_name")


@pulumi.output_type
class RolePolicy(dict):
    """
    Contains information about an attached policy.
     An attached policy is a managed policy that has been attached to a user, group, or role.
     For more information about managed policies, refer to [Managed Policies and Inline Policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html) in the *User Guide*.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "policyDocument":
            suggest = "policy_document"
        elif key == "policyName":
            suggest = "policy_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RolePolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RolePolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RolePolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 policy_document: Any,
                 policy_name: str):
        """
        Contains information about an attached policy.
         An attached policy is a managed policy that has been attached to a user, group, or role.
         For more information about managed policies, refer to [Managed Policies and Inline Policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html) in the *User Guide*.
        :param Any policy_document: The entire contents of the policy that defines permissions. For more information, see [Overview of JSON policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#access_policies-json).
        :param str policy_name: The friendly name (not ARN) identifying the policy.
        """
        pulumi.set(__self__, "policy_document", policy_document)
        pulumi.set(__self__, "policy_name", policy_name)

    @property
    @pulumi.getter(name="policyDocument")
    def policy_document(self) -> Any:
        """
        The entire contents of the policy that defines permissions. For more information, see [Overview of JSON policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#access_policies-json).
        """
        return pulumi.get(self, "policy_document")

    @property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> str:
        """
        The friendly name (not ARN) identifying the policy.
        """
        return pulumi.get(self, "policy_name")


@pulumi.output_type
class UserLoginProfile(dict):
    """
    Creates a password for the specified user, giving the user the ability to access AWS services through the console. For more information about managing passwords, see [Managing Passwords](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_ManagingLogins.html) in the *User Guide*.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "passwordResetRequired":
            suggest = "password_reset_required"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserLoginProfile. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserLoginProfile.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserLoginProfile.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 password: str,
                 password_reset_required: Optional[bool] = None):
        """
        Creates a password for the specified user, giving the user the ability to access AWS services through the console. For more information about managing passwords, see [Managing Passwords](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_ManagingLogins.html) in the *User Guide*.
        :param str password: The user's password.
        :param bool password_reset_required: Specifies whether the user is required to set a new password on next sign-in.
        """
        pulumi.set(__self__, "password", password)
        if password_reset_required is not None:
            pulumi.set(__self__, "password_reset_required", password_reset_required)

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        The user's password.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="passwordResetRequired")
    def password_reset_required(self) -> Optional[bool]:
        """
        Specifies whether the user is required to set a new password on next sign-in.
        """
        return pulumi.get(self, "password_reset_required")


@pulumi.output_type
class UserPolicy(dict):
    """
    Contains information about an attached policy.
     An attached policy is a managed policy that has been attached to a user, group, or role.
     For more information about managed policies, refer to [Managed Policies and Inline Policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html) in the *User Guide*.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "policyDocument":
            suggest = "policy_document"
        elif key == "policyName":
            suggest = "policy_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 policy_document: Any,
                 policy_name: str):
        """
        Contains information about an attached policy.
         An attached policy is a managed policy that has been attached to a user, group, or role.
         For more information about managed policies, refer to [Managed Policies and Inline Policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html) in the *User Guide*.
        :param Any policy_document: The entire contents of the policy that defines permissions. For more information, see [Overview of JSON policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#access_policies-json).
        :param str policy_name: The friendly name (not ARN) identifying the policy.
        """
        pulumi.set(__self__, "policy_document", policy_document)
        pulumi.set(__self__, "policy_name", policy_name)

    @property
    @pulumi.getter(name="policyDocument")
    def policy_document(self) -> Any:
        """
        The entire contents of the policy that defines permissions. For more information, see [Overview of JSON policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#access_policies-json).
        """
        return pulumi.get(self, "policy_document")

    @property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> str:
        """
        The friendly name (not ARN) identifying the policy.
        """
        return pulumi.get(self, "policy_name")


