# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import outputs as _root_outputs

__all__ = [
    'GetSamlProviderResult',
    'AwaitableGetSamlProviderResult',
    'get_saml_provider',
    'get_saml_provider_output',
]

@pulumi.output_type
class GetSamlProviderResult:
    def __init__(__self__, arn=None, saml_metadata_document=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if saml_metadata_document and not isinstance(saml_metadata_document, str):
            raise TypeError("Expected argument 'saml_metadata_document' to be a str")
        pulumi.set(__self__, "saml_metadata_document", saml_metadata_document)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def arn(self) -> Optional[str]:
        """
        Amazon Resource Name (ARN) of the SAML provider
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="samlMetadataDocument")
    def saml_metadata_document(self) -> Optional[str]:
        """
        An XML document generated by an identity provider (IdP) that supports SAML 2.0. The document includes the issuer's name, expiration information, and keys that can be used to validate the SAML authentication response (assertions) that are received from the IdP. You must generate the metadata document using the identity management software that is used as your organization's IdP.

        For more information, see [About SAML 2.0-based federation](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_saml.html) in the *IAM User Guide*
        """
        return pulumi.get(self, "saml_metadata_document")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        A list of tags that you want to attach to the new IAM SAML provider. Each tag consists of a key name and an associated value. For more information about tagging, see [Tagging IAM resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the *IAM User Guide* .

        > If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request fails and the resource is not created.
        """
        return pulumi.get(self, "tags")


class AwaitableGetSamlProviderResult(GetSamlProviderResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSamlProviderResult(
            arn=self.arn,
            saml_metadata_document=self.saml_metadata_document,
            tags=self.tags)


def get_saml_provider(arn: Optional[str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSamlProviderResult:
    """
    Resource Type definition for AWS::IAM::SAMLProvider


    :param str arn: Amazon Resource Name (ARN) of the SAML provider
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:iam:getSamlProvider', __args__, opts=opts, typ=GetSamlProviderResult).value

    return AwaitableGetSamlProviderResult(
        arn=pulumi.get(__ret__, 'arn'),
        saml_metadata_document=pulumi.get(__ret__, 'saml_metadata_document'),
        tags=pulumi.get(__ret__, 'tags'))
def get_saml_provider_output(arn: Optional[pulumi.Input[str]] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetSamlProviderResult]:
    """
    Resource Type definition for AWS::IAM::SAMLProvider


    :param str arn: Amazon Resource Name (ARN) of the SAML provider
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:iam:getSamlProvider', __args__, opts=opts, typ=GetSamlProviderResult)
    return __ret__.apply(lambda __response__: GetSamlProviderResult(
        arn=pulumi.get(__response__, 'arn'),
        saml_metadata_document=pulumi.get(__response__, 'saml_metadata_document'),
        tags=pulumi.get(__response__, 'tags')))
