# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'FhirDatastoreIdentityProviderConfigurationArgs',
    'FhirDatastoreIdentityProviderConfigurationArgsDict',
    'FhirDatastoreKmsEncryptionConfigArgs',
    'FhirDatastoreKmsEncryptionConfigArgsDict',
    'FhirDatastorePreloadDataConfigArgs',
    'FhirDatastorePreloadDataConfigArgsDict',
    'FhirDatastoreSseConfigurationArgs',
    'FhirDatastoreSseConfigurationArgsDict',
]

MYPY = False

if not MYPY:
    class FhirDatastoreIdentityProviderConfigurationArgsDict(TypedDict):
        """
        The identity provider configuration for the datastore
        """
        authorization_strategy: pulumi.Input['FhirDatastoreIdentityProviderConfigurationAuthorizationStrategy']
        """
        Type of Authorization Strategy. The two types of supported Authorization strategies are SMART_ON_FHIR_V1 and AWS_AUTH.
        """
        fine_grained_authorization_enabled: NotRequired[pulumi.Input[bool]]
        """
        Flag to indicate if fine-grained authorization will be enabled for the datastore
        """
        idp_lambda_arn: NotRequired[pulumi.Input[str]]
        """
        The Amazon Resource Name (ARN) of the Lambda function that will be used to decode the access token created by the authorization server.
        """
        metadata: NotRequired[pulumi.Input[str]]
        """
        The JSON metadata elements for identity provider configuration.
        """
elif False:
    FhirDatastoreIdentityProviderConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FhirDatastoreIdentityProviderConfigurationArgs:
    def __init__(__self__, *,
                 authorization_strategy: pulumi.Input['FhirDatastoreIdentityProviderConfigurationAuthorizationStrategy'],
                 fine_grained_authorization_enabled: Optional[pulumi.Input[bool]] = None,
                 idp_lambda_arn: Optional[pulumi.Input[str]] = None,
                 metadata: Optional[pulumi.Input[str]] = None):
        """
        The identity provider configuration for the datastore
        :param pulumi.Input['FhirDatastoreIdentityProviderConfigurationAuthorizationStrategy'] authorization_strategy: Type of Authorization Strategy. The two types of supported Authorization strategies are SMART_ON_FHIR_V1 and AWS_AUTH.
        :param pulumi.Input[bool] fine_grained_authorization_enabled: Flag to indicate if fine-grained authorization will be enabled for the datastore
        :param pulumi.Input[str] idp_lambda_arn: The Amazon Resource Name (ARN) of the Lambda function that will be used to decode the access token created by the authorization server.
        :param pulumi.Input[str] metadata: The JSON metadata elements for identity provider configuration.
        """
        pulumi.set(__self__, "authorization_strategy", authorization_strategy)
        if fine_grained_authorization_enabled is not None:
            pulumi.set(__self__, "fine_grained_authorization_enabled", fine_grained_authorization_enabled)
        if idp_lambda_arn is not None:
            pulumi.set(__self__, "idp_lambda_arn", idp_lambda_arn)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)

    @property
    @pulumi.getter(name="authorizationStrategy")
    def authorization_strategy(self) -> pulumi.Input['FhirDatastoreIdentityProviderConfigurationAuthorizationStrategy']:
        """
        Type of Authorization Strategy. The two types of supported Authorization strategies are SMART_ON_FHIR_V1 and AWS_AUTH.
        """
        return pulumi.get(self, "authorization_strategy")

    @authorization_strategy.setter
    def authorization_strategy(self, value: pulumi.Input['FhirDatastoreIdentityProviderConfigurationAuthorizationStrategy']):
        pulumi.set(self, "authorization_strategy", value)

    @property
    @pulumi.getter(name="fineGrainedAuthorizationEnabled")
    def fine_grained_authorization_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to indicate if fine-grained authorization will be enabled for the datastore
        """
        return pulumi.get(self, "fine_grained_authorization_enabled")

    @fine_grained_authorization_enabled.setter
    def fine_grained_authorization_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "fine_grained_authorization_enabled", value)

    @property
    @pulumi.getter(name="idpLambdaArn")
    def idp_lambda_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) of the Lambda function that will be used to decode the access token created by the authorization server.
        """
        return pulumi.get(self, "idp_lambda_arn")

    @idp_lambda_arn.setter
    def idp_lambda_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "idp_lambda_arn", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[str]]:
        """
        The JSON metadata elements for identity provider configuration.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metadata", value)


if not MYPY:
    class FhirDatastoreKmsEncryptionConfigArgsDict(TypedDict):
        """
        The customer-managed-key (CMK) used when creating a Data Store. If a customer owned key is not specified, an AWS owned key will be used for encryption.
        """
        cmk_type: pulumi.Input['FhirDatastoreKmsEncryptionConfigCmkType']
        """
        The type of customer-managed-key (CMK) used for encryption. The two types of supported CMKs are customer owned CMKs and AWS owned CMKs.
        """
        kms_key_id: NotRequired[pulumi.Input[str]]
        """
        The KMS encryption key id/alias used to encrypt the Data Store contents at rest.
        """
elif False:
    FhirDatastoreKmsEncryptionConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FhirDatastoreKmsEncryptionConfigArgs:
    def __init__(__self__, *,
                 cmk_type: pulumi.Input['FhirDatastoreKmsEncryptionConfigCmkType'],
                 kms_key_id: Optional[pulumi.Input[str]] = None):
        """
        The customer-managed-key (CMK) used when creating a Data Store. If a customer owned key is not specified, an AWS owned key will be used for encryption.
        :param pulumi.Input['FhirDatastoreKmsEncryptionConfigCmkType'] cmk_type: The type of customer-managed-key (CMK) used for encryption. The two types of supported CMKs are customer owned CMKs and AWS owned CMKs.
        :param pulumi.Input[str] kms_key_id: The KMS encryption key id/alias used to encrypt the Data Store contents at rest.
        """
        pulumi.set(__self__, "cmk_type", cmk_type)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)

    @property
    @pulumi.getter(name="cmkType")
    def cmk_type(self) -> pulumi.Input['FhirDatastoreKmsEncryptionConfigCmkType']:
        """
        The type of customer-managed-key (CMK) used for encryption. The two types of supported CMKs are customer owned CMKs and AWS owned CMKs.
        """
        return pulumi.get(self, "cmk_type")

    @cmk_type.setter
    def cmk_type(self, value: pulumi.Input['FhirDatastoreKmsEncryptionConfigCmkType']):
        pulumi.set(self, "cmk_type", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The KMS encryption key id/alias used to encrypt the Data Store contents at rest.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)


if not MYPY:
    class FhirDatastorePreloadDataConfigArgsDict(TypedDict):
        """
        The preloaded data configuration for the Data Store. Only data preloaded from Synthea is supported.
        """
        preload_data_type: pulumi.Input['FhirDatastorePreloadDataConfigPreloadDataType']
        """
        The type of preloaded data. Only Synthea preloaded data is supported.
        """
elif False:
    FhirDatastorePreloadDataConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FhirDatastorePreloadDataConfigArgs:
    def __init__(__self__, *,
                 preload_data_type: pulumi.Input['FhirDatastorePreloadDataConfigPreloadDataType']):
        """
        The preloaded data configuration for the Data Store. Only data preloaded from Synthea is supported.
        :param pulumi.Input['FhirDatastorePreloadDataConfigPreloadDataType'] preload_data_type: The type of preloaded data. Only Synthea preloaded data is supported.
        """
        pulumi.set(__self__, "preload_data_type", preload_data_type)

    @property
    @pulumi.getter(name="preloadDataType")
    def preload_data_type(self) -> pulumi.Input['FhirDatastorePreloadDataConfigPreloadDataType']:
        """
        The type of preloaded data. Only Synthea preloaded data is supported.
        """
        return pulumi.get(self, "preload_data_type")

    @preload_data_type.setter
    def preload_data_type(self, value: pulumi.Input['FhirDatastorePreloadDataConfigPreloadDataType']):
        pulumi.set(self, "preload_data_type", value)


if not MYPY:
    class FhirDatastoreSseConfigurationArgsDict(TypedDict):
        """
        The server-side encryption key configuration for a customer provided encryption key.
        """
        kms_encryption_config: pulumi.Input['FhirDatastoreKmsEncryptionConfigArgsDict']
        """
        The server-side encryption key configuration for a customer provided encryption key (CMK).
        """
elif False:
    FhirDatastoreSseConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FhirDatastoreSseConfigurationArgs:
    def __init__(__self__, *,
                 kms_encryption_config: pulumi.Input['FhirDatastoreKmsEncryptionConfigArgs']):
        """
        The server-side encryption key configuration for a customer provided encryption key.
        :param pulumi.Input['FhirDatastoreKmsEncryptionConfigArgs'] kms_encryption_config: The server-side encryption key configuration for a customer provided encryption key (CMK).
        """
        pulumi.set(__self__, "kms_encryption_config", kms_encryption_config)

    @property
    @pulumi.getter(name="kmsEncryptionConfig")
    def kms_encryption_config(self) -> pulumi.Input['FhirDatastoreKmsEncryptionConfigArgs']:
        """
        The server-side encryption key configuration for a customer provided encryption key (CMK).
        """
        return pulumi.get(self, "kms_encryption_config")

    @kms_encryption_config.setter
    def kms_encryption_config(self, value: pulumi.Input['FhirDatastoreKmsEncryptionConfigArgs']):
        pulumi.set(self, "kms_encryption_config", value)


