# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'DetectorCfnDataSourceConfigurations',
    'DetectorCfnFeatureAdditionalConfiguration',
    'DetectorCfnFeatureConfiguration',
    'DetectorCfnKubernetesAuditLogsConfiguration',
    'DetectorCfnKubernetesConfiguration',
    'DetectorCfnMalwareProtectionConfiguration',
    'DetectorCfnScanEc2InstanceWithFindingsConfiguration',
    'DetectorCfns3LogsConfiguration',
    'FilterCondition',
    'FilterFindingCriteria',
    'MalwareProtectionPlanCfnActions',
    'MalwareProtectionPlanCfnProtectedResource',
    'MalwareProtectionPlanCfnProtectedResourceS3BucketProperties',
    'MalwareProtectionPlanCfnStatusReasons',
    'MalwareProtectionPlanCfnTagging',
]

@pulumi.output_type
class DetectorCfnDataSourceConfigurations(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "malwareProtection":
            suggest = "malware_protection"
        elif key == "s3Logs":
            suggest = "s3_logs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DetectorCfnDataSourceConfigurations. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DetectorCfnDataSourceConfigurations.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DetectorCfnDataSourceConfigurations.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kubernetes: Optional['outputs.DetectorCfnKubernetesConfiguration'] = None,
                 malware_protection: Optional['outputs.DetectorCfnMalwareProtectionConfiguration'] = None,
                 s3_logs: Optional['outputs.DetectorCfns3LogsConfiguration'] = None):
        """
        :param 'DetectorCfnKubernetesConfiguration' kubernetes: Describes which Kubernetes data sources are enabled for a detector.
        :param 'DetectorCfnMalwareProtectionConfiguration' malware_protection: Describes whether Malware Protection will be enabled as a data source.
        :param 'DetectorCfns3LogsConfiguration' s3_logs: Describes whether S3 data event logs are enabled as a data source.
        """
        if kubernetes is not None:
            pulumi.set(__self__, "kubernetes", kubernetes)
        if malware_protection is not None:
            pulumi.set(__self__, "malware_protection", malware_protection)
        if s3_logs is not None:
            pulumi.set(__self__, "s3_logs", s3_logs)

    @property
    @pulumi.getter
    def kubernetes(self) -> Optional['outputs.DetectorCfnKubernetesConfiguration']:
        """
        Describes which Kubernetes data sources are enabled for a detector.
        """
        return pulumi.get(self, "kubernetes")

    @property
    @pulumi.getter(name="malwareProtection")
    def malware_protection(self) -> Optional['outputs.DetectorCfnMalwareProtectionConfiguration']:
        """
        Describes whether Malware Protection will be enabled as a data source.
        """
        return pulumi.get(self, "malware_protection")

    @property
    @pulumi.getter(name="s3Logs")
    def s3_logs(self) -> Optional['outputs.DetectorCfns3LogsConfiguration']:
        """
        Describes whether S3 data event logs are enabled as a data source.
        """
        return pulumi.get(self, "s3_logs")


@pulumi.output_type
class DetectorCfnFeatureAdditionalConfiguration(dict):
    def __init__(__self__, *,
                 name: Optional[str] = None,
                 status: Optional[str] = None):
        """
        :param str name: Name of the additional configuration.
        :param str status: Status of the additional configuration.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the additional configuration.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        Status of the additional configuration.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class DetectorCfnFeatureConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "additionalConfiguration":
            suggest = "additional_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DetectorCfnFeatureConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DetectorCfnFeatureConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DetectorCfnFeatureConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 status: 'DetectorCfnFeatureConfigurationStatus',
                 additional_configuration: Optional[Sequence['outputs.DetectorCfnFeatureAdditionalConfiguration']] = None):
        """
        :param str name: Name of the feature. For a list of allowed values, see [DetectorFeatureConfiguration](https://docs.aws.amazon.com/guardduty/latest/APIReference/API_DetectorFeatureConfiguration.html#guardduty-Type-DetectorFeatureConfiguration-name) in the *GuardDuty API Reference* .
        :param 'DetectorCfnFeatureConfigurationStatus' status: Status of the feature configuration.
        :param Sequence['DetectorCfnFeatureAdditionalConfiguration'] additional_configuration: Information about the additional configuration of a feature in your account.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "status", status)
        if additional_configuration is not None:
            pulumi.set(__self__, "additional_configuration", additional_configuration)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the feature. For a list of allowed values, see [DetectorFeatureConfiguration](https://docs.aws.amazon.com/guardduty/latest/APIReference/API_DetectorFeatureConfiguration.html#guardduty-Type-DetectorFeatureConfiguration-name) in the *GuardDuty API Reference* .
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def status(self) -> 'DetectorCfnFeatureConfigurationStatus':
        """
        Status of the feature configuration.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="additionalConfiguration")
    def additional_configuration(self) -> Optional[Sequence['outputs.DetectorCfnFeatureAdditionalConfiguration']]:
        """
        Information about the additional configuration of a feature in your account.
        """
        return pulumi.get(self, "additional_configuration")


@pulumi.output_type
class DetectorCfnKubernetesAuditLogsConfiguration(dict):
    def __init__(__self__, *,
                 enable: bool):
        """
        :param bool enable: Describes whether Kubernetes audit logs are enabled as a data source for the detector.
        """
        pulumi.set(__self__, "enable", enable)

    @property
    @pulumi.getter
    def enable(self) -> bool:
        """
        Describes whether Kubernetes audit logs are enabled as a data source for the detector.
        """
        return pulumi.get(self, "enable")


@pulumi.output_type
class DetectorCfnKubernetesConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "auditLogs":
            suggest = "audit_logs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DetectorCfnKubernetesConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DetectorCfnKubernetesConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DetectorCfnKubernetesConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 audit_logs: 'outputs.DetectorCfnKubernetesAuditLogsConfiguration'):
        """
        :param 'DetectorCfnKubernetesAuditLogsConfiguration' audit_logs: Describes whether Kubernetes audit logs are enabled as a data source for the detector.
        """
        pulumi.set(__self__, "audit_logs", audit_logs)

    @property
    @pulumi.getter(name="auditLogs")
    def audit_logs(self) -> 'outputs.DetectorCfnKubernetesAuditLogsConfiguration':
        """
        Describes whether Kubernetes audit logs are enabled as a data source for the detector.
        """
        return pulumi.get(self, "audit_logs")


@pulumi.output_type
class DetectorCfnMalwareProtectionConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "scanEc2InstanceWithFindings":
            suggest = "scan_ec2_instance_with_findings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DetectorCfnMalwareProtectionConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DetectorCfnMalwareProtectionConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DetectorCfnMalwareProtectionConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 scan_ec2_instance_with_findings: Optional['outputs.DetectorCfnScanEc2InstanceWithFindingsConfiguration'] = None):
        """
        :param 'DetectorCfnScanEc2InstanceWithFindingsConfiguration' scan_ec2_instance_with_findings: Describes the configuration of Malware Protection for EC2 instances with findings.
        """
        if scan_ec2_instance_with_findings is not None:
            pulumi.set(__self__, "scan_ec2_instance_with_findings", scan_ec2_instance_with_findings)

    @property
    @pulumi.getter(name="scanEc2InstanceWithFindings")
    def scan_ec2_instance_with_findings(self) -> Optional['outputs.DetectorCfnScanEc2InstanceWithFindingsConfiguration']:
        """
        Describes the configuration of Malware Protection for EC2 instances with findings.
        """
        return pulumi.get(self, "scan_ec2_instance_with_findings")


@pulumi.output_type
class DetectorCfnScanEc2InstanceWithFindingsConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ebsVolumes":
            suggest = "ebs_volumes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DetectorCfnScanEc2InstanceWithFindingsConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DetectorCfnScanEc2InstanceWithFindingsConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DetectorCfnScanEc2InstanceWithFindingsConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ebs_volumes: Optional[bool] = None):
        """
        :param bool ebs_volumes: Describes the configuration for scanning EBS volumes as data source.
        """
        if ebs_volumes is not None:
            pulumi.set(__self__, "ebs_volumes", ebs_volumes)

    @property
    @pulumi.getter(name="ebsVolumes")
    def ebs_volumes(self) -> Optional[bool]:
        """
        Describes the configuration for scanning EBS volumes as data source.
        """
        return pulumi.get(self, "ebs_volumes")


@pulumi.output_type
class DetectorCfns3LogsConfiguration(dict):
    def __init__(__self__, *,
                 enable: bool):
        """
        :param bool enable: The status of S3 data event logs as a data source.
        """
        pulumi.set(__self__, "enable", enable)

    @property
    @pulumi.getter
    def enable(self) -> bool:
        """
        The status of S3 data event logs as a data source.
        """
        return pulumi.get(self, "enable")


@pulumi.output_type
class FilterCondition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "greaterThan":
            suggest = "greater_than"
        elif key == "greaterThanOrEqual":
            suggest = "greater_than_or_equal"
        elif key == "lessThan":
            suggest = "less_than"
        elif key == "lessThanOrEqual":
            suggest = "less_than_or_equal"
        elif key == "notEquals":
            suggest = "not_equals"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FilterCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FilterCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FilterCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 eq: Optional[Sequence[str]] = None,
                 equals: Optional[Sequence[str]] = None,
                 greater_than: Optional[int] = None,
                 greater_than_or_equal: Optional[int] = None,
                 gt: Optional[int] = None,
                 gte: Optional[int] = None,
                 less_than: Optional[int] = None,
                 less_than_or_equal: Optional[int] = None,
                 lt: Optional[int] = None,
                 lte: Optional[int] = None,
                 neq: Optional[Sequence[str]] = None,
                 not_equals: Optional[Sequence[str]] = None):
        if eq is not None:
            pulumi.set(__self__, "eq", eq)
        if equals is not None:
            pulumi.set(__self__, "equals", equals)
        if greater_than is not None:
            pulumi.set(__self__, "greater_than", greater_than)
        if greater_than_or_equal is not None:
            pulumi.set(__self__, "greater_than_or_equal", greater_than_or_equal)
        if gt is not None:
            pulumi.set(__self__, "gt", gt)
        if gte is not None:
            pulumi.set(__self__, "gte", gte)
        if less_than is not None:
            pulumi.set(__self__, "less_than", less_than)
        if less_than_or_equal is not None:
            pulumi.set(__self__, "less_than_or_equal", less_than_or_equal)
        if lt is not None:
            pulumi.set(__self__, "lt", lt)
        if lte is not None:
            pulumi.set(__self__, "lte", lte)
        if neq is not None:
            pulumi.set(__self__, "neq", neq)
        if not_equals is not None:
            pulumi.set(__self__, "not_equals", not_equals)

    @property
    @pulumi.getter
    def eq(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "eq")

    @property
    @pulumi.getter
    def equals(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "equals")

    @property
    @pulumi.getter(name="greaterThan")
    def greater_than(self) -> Optional[int]:
        return pulumi.get(self, "greater_than")

    @property
    @pulumi.getter(name="greaterThanOrEqual")
    def greater_than_or_equal(self) -> Optional[int]:
        return pulumi.get(self, "greater_than_or_equal")

    @property
    @pulumi.getter
    def gt(self) -> Optional[int]:
        return pulumi.get(self, "gt")

    @property
    @pulumi.getter
    def gte(self) -> Optional[int]:
        return pulumi.get(self, "gte")

    @property
    @pulumi.getter(name="lessThan")
    def less_than(self) -> Optional[int]:
        return pulumi.get(self, "less_than")

    @property
    @pulumi.getter(name="lessThanOrEqual")
    def less_than_or_equal(self) -> Optional[int]:
        return pulumi.get(self, "less_than_or_equal")

    @property
    @pulumi.getter
    def lt(self) -> Optional[int]:
        return pulumi.get(self, "lt")

    @property
    @pulumi.getter
    def lte(self) -> Optional[int]:
        return pulumi.get(self, "lte")

    @property
    @pulumi.getter
    def neq(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "neq")

    @property
    @pulumi.getter(name="notEquals")
    def not_equals(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "not_equals")


@pulumi.output_type
class FilterFindingCriteria(dict):
    def __init__(__self__, *,
                 criterion: Optional[Mapping[str, 'outputs.FilterCondition']] = None):
        """
        :param Mapping[str, 'FilterCondition'] criterion: Represents a map of finding properties that match specified conditions and values when querying findings.
               
               For information about JSON criterion mapping to their console equivalent, see [Finding criteria](https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_filter-findings.html#filter_criteria) . The following are the available criterion:
               
               - accountId
               - id
               - region
               - severity
               
               To filter on the basis of severity, the API and AWS CLI use the following input list for the `FindingCriteria` condition:
               
               - *Low* : `["1", "2", "3"]`
               - *Medium* : `["4", "5", "6"]`
               - *High* : `["7", "8", "9"]`
               
               For more information, see [Severity levels for GuardDuty findings](https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_findings.html#guardduty_findings-severity) in the *Amazon GuardDuty User Guide* .
               - type
               - updatedAt
               
               Type: ISO 8601 string format: `YYYY-MM-DDTHH:MM:SS.SSSZ` or `YYYY-MM-DDTHH:MM:SSZ` depending on whether the value contains milliseconds.
               - resource.accessKeyDetails.accessKeyId
               - resource.accessKeyDetails.principalId
               - resource.accessKeyDetails.userName
               - resource.accessKeyDetails.userType
               - resource.instanceDetails.iamInstanceProfile.id
               - resource.instanceDetails.imageId
               - resource.instanceDetails.instanceId
               - resource.instanceDetails.tags.key
               - resource.instanceDetails.tags.value
               - resource.instanceDetails.networkInterfaces.ipv6Addresses
               - resource.instanceDetails.networkInterfaces.privateIpAddresses.privateIpAddress
               - resource.instanceDetails.networkInterfaces.publicDnsName
               - resource.instanceDetails.networkInterfaces.publicIp
               - resource.instanceDetails.networkInterfaces.securityGroups.groupId
               - resource.instanceDetails.networkInterfaces.securityGroups.groupName
               - resource.instanceDetails.networkInterfaces.subnetId
               - resource.instanceDetails.networkInterfaces.vpcId
               - resource.instanceDetails.outpostArn
               - resource.resourceType
               - resource.s3BucketDetails.publicAccess.effectivePermissions
               - resource.s3BucketDetails.name
               - resource.s3BucketDetails.tags.key
               - resource.s3BucketDetails.tags.value
               - resource.s3BucketDetails.type
               - service.action.actionType
               - service.action.awsApiCallAction.api
               - service.action.awsApiCallAction.callerType
               - service.action.awsApiCallAction.errorCode
               - service.action.awsApiCallAction.remoteIpDetails.city.cityName
               - service.action.awsApiCallAction.remoteIpDetails.country.countryName
               - service.action.awsApiCallAction.remoteIpDetails.ipAddressV4
               - service.action.awsApiCallAction.remoteIpDetails.ipAddressV6
               - service.action.awsApiCallAction.remoteIpDetails.organization.asn
               - service.action.awsApiCallAction.remoteIpDetails.organization.asnOrg
               - service.action.awsApiCallAction.serviceName
               - service.action.dnsRequestAction.domain
               - service.action.dnsRequestAction.domainWithSuffix
               - service.action.networkConnectionAction.blocked
               - service.action.networkConnectionAction.connectionDirection
               - service.action.networkConnectionAction.localPortDetails.port
               - service.action.networkConnectionAction.protocol
               - service.action.networkConnectionAction.remoteIpDetails.city.cityName
               - service.action.networkConnectionAction.remoteIpDetails.country.countryName
               - service.action.networkConnectionAction.remoteIpDetails.ipAddressV4
               - service.action.networkConnectionAction.remoteIpDetails.ipAddressV6
               - service.action.networkConnectionAction.remoteIpDetails.organization.asn
               - service.action.networkConnectionAction.remoteIpDetails.organization.asnOrg
               - service.action.networkConnectionAction.remotePortDetails.port
               - service.action.awsApiCallAction.remoteAccountDetails.affiliated
               - service.action.kubernetesApiCallAction.remoteIpDetails.ipAddressV4
               - service.action.kubernetesApiCallAction.remoteIpDetails.ipAddressV6
               - service.action.kubernetesApiCallAction.namespace
               - service.action.kubernetesApiCallAction.remoteIpDetails.organization.asn
               - service.action.kubernetesApiCallAction.requestUri
               - service.action.kubernetesApiCallAction.statusCode
               - service.action.networkConnectionAction.localIpDetails.ipAddressV4
               - service.action.networkConnectionAction.localIpDetails.ipAddressV6
               - service.action.networkConnectionAction.protocol
               - service.action.awsApiCallAction.serviceName
               - service.action.awsApiCallAction.remoteAccountDetails.accountId
               - service.additionalInfo.threatListName
               - service.resourceRole
               - resource.eksClusterDetails.name
               - resource.kubernetesDetails.kubernetesWorkloadDetails.name
               - resource.kubernetesDetails.kubernetesWorkloadDetails.namespace
               - resource.kubernetesDetails.kubernetesUserDetails.username
               - resource.kubernetesDetails.kubernetesWorkloadDetails.containers.image
               - resource.kubernetesDetails.kubernetesWorkloadDetails.containers.imagePrefix
               - service.ebsVolumeScanDetails.scanId
               - service.ebsVolumeScanDetails.scanDetections.threatDetectedByName.threatNames.name
               - service.ebsVolumeScanDetails.scanDetections.threatDetectedByName.threatNames.severity
               - service.ebsVolumeScanDetails.scanDetections.threatDetectedByName.threatNames.filePaths.hash
               - service.malwareScanDetails.threats.name
               - resource.ecsClusterDetails.name
               - resource.ecsClusterDetails.taskDetails.containers.image
               - resource.ecsClusterDetails.taskDetails.definitionArn
               - resource.containerDetails.image
               - resource.rdsDbInstanceDetails.dbInstanceIdentifier
               - resource.rdsDbInstanceDetails.dbClusterIdentifier
               - resource.rdsDbInstanceDetails.engine
               - resource.rdsDbUserDetails.user
               - resource.rdsDbInstanceDetails.tags.key
               - resource.rdsDbInstanceDetails.tags.value
               - service.runtimeDetails.process.executableSha256
               - service.runtimeDetails.process.name
               - service.runtimeDetails.process.name
               - resource.lambdaDetails.functionName
               - resource.lambdaDetails.functionArn
               - resource.lambdaDetails.tags.key
               - resource.lambdaDetails.tags.value
        """
        if criterion is not None:
            pulumi.set(__self__, "criterion", criterion)

    @property
    @pulumi.getter
    def criterion(self) -> Optional[Mapping[str, 'outputs.FilterCondition']]:
        """
        Represents a map of finding properties that match specified conditions and values when querying findings.

        For information about JSON criterion mapping to their console equivalent, see [Finding criteria](https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_filter-findings.html#filter_criteria) . The following are the available criterion:

        - accountId
        - id
        - region
        - severity

        To filter on the basis of severity, the API and AWS CLI use the following input list for the `FindingCriteria` condition:

        - *Low* : `["1", "2", "3"]`
        - *Medium* : `["4", "5", "6"]`
        - *High* : `["7", "8", "9"]`

        For more information, see [Severity levels for GuardDuty findings](https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_findings.html#guardduty_findings-severity) in the *Amazon GuardDuty User Guide* .
        - type
        - updatedAt

        Type: ISO 8601 string format: `YYYY-MM-DDTHH:MM:SS.SSSZ` or `YYYY-MM-DDTHH:MM:SSZ` depending on whether the value contains milliseconds.
        - resource.accessKeyDetails.accessKeyId
        - resource.accessKeyDetails.principalId
        - resource.accessKeyDetails.userName
        - resource.accessKeyDetails.userType
        - resource.instanceDetails.iamInstanceProfile.id
        - resource.instanceDetails.imageId
        - resource.instanceDetails.instanceId
        - resource.instanceDetails.tags.key
        - resource.instanceDetails.tags.value
        - resource.instanceDetails.networkInterfaces.ipv6Addresses
        - resource.instanceDetails.networkInterfaces.privateIpAddresses.privateIpAddress
        - resource.instanceDetails.networkInterfaces.publicDnsName
        - resource.instanceDetails.networkInterfaces.publicIp
        - resource.instanceDetails.networkInterfaces.securityGroups.groupId
        - resource.instanceDetails.networkInterfaces.securityGroups.groupName
        - resource.instanceDetails.networkInterfaces.subnetId
        - resource.instanceDetails.networkInterfaces.vpcId
        - resource.instanceDetails.outpostArn
        - resource.resourceType
        - resource.s3BucketDetails.publicAccess.effectivePermissions
        - resource.s3BucketDetails.name
        - resource.s3BucketDetails.tags.key
        - resource.s3BucketDetails.tags.value
        - resource.s3BucketDetails.type
        - service.action.actionType
        - service.action.awsApiCallAction.api
        - service.action.awsApiCallAction.callerType
        - service.action.awsApiCallAction.errorCode
        - service.action.awsApiCallAction.remoteIpDetails.city.cityName
        - service.action.awsApiCallAction.remoteIpDetails.country.countryName
        - service.action.awsApiCallAction.remoteIpDetails.ipAddressV4
        - service.action.awsApiCallAction.remoteIpDetails.ipAddressV6
        - service.action.awsApiCallAction.remoteIpDetails.organization.asn
        - service.action.awsApiCallAction.remoteIpDetails.organization.asnOrg
        - service.action.awsApiCallAction.serviceName
        - service.action.dnsRequestAction.domain
        - service.action.dnsRequestAction.domainWithSuffix
        - service.action.networkConnectionAction.blocked
        - service.action.networkConnectionAction.connectionDirection
        - service.action.networkConnectionAction.localPortDetails.port
        - service.action.networkConnectionAction.protocol
        - service.action.networkConnectionAction.remoteIpDetails.city.cityName
        - service.action.networkConnectionAction.remoteIpDetails.country.countryName
        - service.action.networkConnectionAction.remoteIpDetails.ipAddressV4
        - service.action.networkConnectionAction.remoteIpDetails.ipAddressV6
        - service.action.networkConnectionAction.remoteIpDetails.organization.asn
        - service.action.networkConnectionAction.remoteIpDetails.organization.asnOrg
        - service.action.networkConnectionAction.remotePortDetails.port
        - service.action.awsApiCallAction.remoteAccountDetails.affiliated
        - service.action.kubernetesApiCallAction.remoteIpDetails.ipAddressV4
        - service.action.kubernetesApiCallAction.remoteIpDetails.ipAddressV6
        - service.action.kubernetesApiCallAction.namespace
        - service.action.kubernetesApiCallAction.remoteIpDetails.organization.asn
        - service.action.kubernetesApiCallAction.requestUri
        - service.action.kubernetesApiCallAction.statusCode
        - service.action.networkConnectionAction.localIpDetails.ipAddressV4
        - service.action.networkConnectionAction.localIpDetails.ipAddressV6
        - service.action.networkConnectionAction.protocol
        - service.action.awsApiCallAction.serviceName
        - service.action.awsApiCallAction.remoteAccountDetails.accountId
        - service.additionalInfo.threatListName
        - service.resourceRole
        - resource.eksClusterDetails.name
        - resource.kubernetesDetails.kubernetesWorkloadDetails.name
        - resource.kubernetesDetails.kubernetesWorkloadDetails.namespace
        - resource.kubernetesDetails.kubernetesUserDetails.username
        - resource.kubernetesDetails.kubernetesWorkloadDetails.containers.image
        - resource.kubernetesDetails.kubernetesWorkloadDetails.containers.imagePrefix
        - service.ebsVolumeScanDetails.scanId
        - service.ebsVolumeScanDetails.scanDetections.threatDetectedByName.threatNames.name
        - service.ebsVolumeScanDetails.scanDetections.threatDetectedByName.threatNames.severity
        - service.ebsVolumeScanDetails.scanDetections.threatDetectedByName.threatNames.filePaths.hash
        - service.malwareScanDetails.threats.name
        - resource.ecsClusterDetails.name
        - resource.ecsClusterDetails.taskDetails.containers.image
        - resource.ecsClusterDetails.taskDetails.definitionArn
        - resource.containerDetails.image
        - resource.rdsDbInstanceDetails.dbInstanceIdentifier
        - resource.rdsDbInstanceDetails.dbClusterIdentifier
        - resource.rdsDbInstanceDetails.engine
        - resource.rdsDbUserDetails.user
        - resource.rdsDbInstanceDetails.tags.key
        - resource.rdsDbInstanceDetails.tags.value
        - service.runtimeDetails.process.executableSha256
        - service.runtimeDetails.process.name
        - service.runtimeDetails.process.name
        - resource.lambdaDetails.functionName
        - resource.lambdaDetails.functionArn
        - resource.lambdaDetails.tags.key
        - resource.lambdaDetails.tags.value
        """
        return pulumi.get(self, "criterion")


@pulumi.output_type
class MalwareProtectionPlanCfnActions(dict):
    def __init__(__self__, *,
                 tagging: Optional['outputs.MalwareProtectionPlanCfnTagging'] = None):
        """
        :param 'MalwareProtectionPlanCfnTagging' tagging: Contains information about tagging status of the Malware Protection plan resource.
        """
        if tagging is not None:
            pulumi.set(__self__, "tagging", tagging)

    @property
    @pulumi.getter
    def tagging(self) -> Optional['outputs.MalwareProtectionPlanCfnTagging']:
        """
        Contains information about tagging status of the Malware Protection plan resource.
        """
        return pulumi.get(self, "tagging")


@pulumi.output_type
class MalwareProtectionPlanCfnProtectedResource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3Bucket":
            suggest = "s3_bucket"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MalwareProtectionPlanCfnProtectedResource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MalwareProtectionPlanCfnProtectedResource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MalwareProtectionPlanCfnProtectedResource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_bucket: 'outputs.MalwareProtectionPlanCfnProtectedResourceS3BucketProperties'):
        """
        :param 'MalwareProtectionPlanCfnProtectedResourceS3BucketProperties' s3_bucket: Information about the protected S3 bucket resource.
        """
        pulumi.set(__self__, "s3_bucket", s3_bucket)

    @property
    @pulumi.getter(name="s3Bucket")
    def s3_bucket(self) -> 'outputs.MalwareProtectionPlanCfnProtectedResourceS3BucketProperties':
        """
        Information about the protected S3 bucket resource.
        """
        return pulumi.get(self, "s3_bucket")


@pulumi.output_type
class MalwareProtectionPlanCfnProtectedResourceS3BucketProperties(dict):
    """
    Information about the protected S3 bucket resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketName":
            suggest = "bucket_name"
        elif key == "objectPrefixes":
            suggest = "object_prefixes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MalwareProtectionPlanCfnProtectedResourceS3BucketProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MalwareProtectionPlanCfnProtectedResourceS3BucketProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MalwareProtectionPlanCfnProtectedResourceS3BucketProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_name: Optional[str] = None,
                 object_prefixes: Optional[Sequence[str]] = None):
        """
        Information about the protected S3 bucket resource.
        :param str bucket_name: Name of the S3 bucket.
        :param Sequence[str] object_prefixes: Information about the specified object prefixes. The S3 object will be scanned only if it belongs to any of the specified object prefixes.
        """
        if bucket_name is not None:
            pulumi.set(__self__, "bucket_name", bucket_name)
        if object_prefixes is not None:
            pulumi.set(__self__, "object_prefixes", object_prefixes)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> Optional[str]:
        """
        Name of the S3 bucket.
        """
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter(name="objectPrefixes")
    def object_prefixes(self) -> Optional[Sequence[str]]:
        """
        Information about the specified object prefixes. The S3 object will be scanned only if it belongs to any of the specified object prefixes.
        """
        return pulumi.get(self, "object_prefixes")


@pulumi.output_type
class MalwareProtectionPlanCfnStatusReasons(dict):
    def __init__(__self__, *,
                 code: Optional[str] = None,
                 message: Optional[str] = None):
        """
        :param str code: The status code of the Malware Protection plan.
        :param str message: Issue message that specifies the reason.
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if message is not None:
            pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def code(self) -> Optional[str]:
        """
        The status code of the Malware Protection plan.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        """
        Issue message that specifies the reason.
        """
        return pulumi.get(self, "message")


@pulumi.output_type
class MalwareProtectionPlanCfnTagging(dict):
    def __init__(__self__, *,
                 status: Optional[str] = None):
        """
        :param str status: Indicates whether or not you chose GuardDuty to add a predefined tag to the scanned S3 object.
        """
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        Indicates whether or not you chose GuardDuty to add a predefined tag to the scanned S3 object.
        """
        return pulumi.get(self, "status")


