# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs

__all__ = [
    'GetMalwareProtectionPlanResult',
    'AwaitableGetMalwareProtectionPlanResult',
    'get_malware_protection_plan',
    'get_malware_protection_plan_output',
]

@pulumi.output_type
class GetMalwareProtectionPlanResult:
    def __init__(__self__, actions=None, arn=None, created_at=None, malware_protection_plan_id=None, protected_resource=None, role=None, status=None, status_reasons=None, tags=None):
        if actions and not isinstance(actions, dict):
            raise TypeError("Expected argument 'actions' to be a dict")
        pulumi.set(__self__, "actions", actions)
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if malware_protection_plan_id and not isinstance(malware_protection_plan_id, str):
            raise TypeError("Expected argument 'malware_protection_plan_id' to be a str")
        pulumi.set(__self__, "malware_protection_plan_id", malware_protection_plan_id)
        if protected_resource and not isinstance(protected_resource, dict):
            raise TypeError("Expected argument 'protected_resource' to be a dict")
        pulumi.set(__self__, "protected_resource", protected_resource)
        if role and not isinstance(role, str):
            raise TypeError("Expected argument 'role' to be a str")
        pulumi.set(__self__, "role", role)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if status_reasons and not isinstance(status_reasons, list):
            raise TypeError("Expected argument 'status_reasons' to be a list")
        pulumi.set(__self__, "status_reasons", status_reasons)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def actions(self) -> Optional['outputs.MalwareProtectionPlanCfnActions']:
        """
        Specifies the action that is to be applied to the Malware Protection plan resource.
        """
        return pulumi.get(self, "actions")

    @property
    @pulumi.getter
    def arn(self) -> Optional[str]:
        """
        Amazon Resource Name (ARN) of the protected resource.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The timestamp when the Malware Protection plan resource was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="malwareProtectionPlanId")
    def malware_protection_plan_id(self) -> Optional[str]:
        """
        A unique identifier associated with Malware Protection plan resource.
        """
        return pulumi.get(self, "malware_protection_plan_id")

    @property
    @pulumi.getter(name="protectedResource")
    def protected_resource(self) -> Optional['outputs.MalwareProtectionPlanCfnProtectedResource']:
        """
        Information about the protected resource. Presently, S3Bucket is the only supported protected resource.
        """
        return pulumi.get(self, "protected_resource")

    @property
    @pulumi.getter
    def role(self) -> Optional[str]:
        """
        IAM role that includes the permissions required to scan and (optionally) add tags to the associated protected resource.
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        Status of the Malware Protection plan resource.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="statusReasons")
    def status_reasons(self) -> Optional[Sequence['outputs.MalwareProtectionPlanCfnStatusReasons']]:
        """
        Status details associated with the Malware Protection plan resource status.
        """
        return pulumi.get(self, "status_reasons")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        The tags to be added to the created Malware Protection plan resource. Each tag consists of a key and an optional value, both of which you need to specify.
        """
        return pulumi.get(self, "tags")


class AwaitableGetMalwareProtectionPlanResult(GetMalwareProtectionPlanResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMalwareProtectionPlanResult(
            actions=self.actions,
            arn=self.arn,
            created_at=self.created_at,
            malware_protection_plan_id=self.malware_protection_plan_id,
            protected_resource=self.protected_resource,
            role=self.role,
            status=self.status,
            status_reasons=self.status_reasons,
            tags=self.tags)


def get_malware_protection_plan(malware_protection_plan_id: Optional[str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMalwareProtectionPlanResult:
    """
    Resource Type definition for AWS::GuardDuty::MalwareProtectionPlan


    :param str malware_protection_plan_id: A unique identifier associated with Malware Protection plan resource.
    """
    __args__ = dict()
    __args__['malwareProtectionPlanId'] = malware_protection_plan_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:guardduty:getMalwareProtectionPlan', __args__, opts=opts, typ=GetMalwareProtectionPlanResult).value

    return AwaitableGetMalwareProtectionPlanResult(
        actions=pulumi.get(__ret__, 'actions'),
        arn=pulumi.get(__ret__, 'arn'),
        created_at=pulumi.get(__ret__, 'created_at'),
        malware_protection_plan_id=pulumi.get(__ret__, 'malware_protection_plan_id'),
        protected_resource=pulumi.get(__ret__, 'protected_resource'),
        role=pulumi.get(__ret__, 'role'),
        status=pulumi.get(__ret__, 'status'),
        status_reasons=pulumi.get(__ret__, 'status_reasons'),
        tags=pulumi.get(__ret__, 'tags'))
def get_malware_protection_plan_output(malware_protection_plan_id: Optional[pulumi.Input[str]] = None,
                                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetMalwareProtectionPlanResult]:
    """
    Resource Type definition for AWS::GuardDuty::MalwareProtectionPlan


    :param str malware_protection_plan_id: A unique identifier associated with Malware Protection plan resource.
    """
    __args__ = dict()
    __args__['malwareProtectionPlanId'] = malware_protection_plan_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:guardduty:getMalwareProtectionPlan', __args__, opts=opts, typ=GetMalwareProtectionPlanResult)
    return __ret__.apply(lambda __response__: GetMalwareProtectionPlanResult(
        actions=pulumi.get(__response__, 'actions'),
        arn=pulumi.get(__response__, 'arn'),
        created_at=pulumi.get(__response__, 'created_at'),
        malware_protection_plan_id=pulumi.get(__response__, 'malware_protection_plan_id'),
        protected_resource=pulumi.get(__response__, 'protected_resource'),
        role=pulumi.get(__response__, 'role'),
        status=pulumi.get(__response__, 'status'),
        status_reasons=pulumi.get(__response__, 'status_reasons'),
        tags=pulumi.get(__response__, 'tags')))
