# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'DetectorCfnDataSourceConfigurationsArgs',
    'DetectorCfnDataSourceConfigurationsArgsDict',
    'DetectorCfnFeatureAdditionalConfigurationArgs',
    'DetectorCfnFeatureAdditionalConfigurationArgsDict',
    'DetectorCfnFeatureConfigurationArgs',
    'DetectorCfnFeatureConfigurationArgsDict',
    'DetectorCfnKubernetesAuditLogsConfigurationArgs',
    'DetectorCfnKubernetesAuditLogsConfigurationArgsDict',
    'DetectorCfnKubernetesConfigurationArgs',
    'DetectorCfnKubernetesConfigurationArgsDict',
    'DetectorCfnMalwareProtectionConfigurationArgs',
    'DetectorCfnMalwareProtectionConfigurationArgsDict',
    'DetectorCfnScanEc2InstanceWithFindingsConfigurationArgs',
    'DetectorCfnScanEc2InstanceWithFindingsConfigurationArgsDict',
    'DetectorCfns3LogsConfigurationArgs',
    'DetectorCfns3LogsConfigurationArgsDict',
    'FilterConditionArgs',
    'FilterConditionArgsDict',
    'FilterFindingCriteriaArgs',
    'FilterFindingCriteriaArgsDict',
    'MalwareProtectionPlanCfnActionsArgs',
    'MalwareProtectionPlanCfnActionsArgsDict',
    'MalwareProtectionPlanCfnProtectedResourceS3BucketPropertiesArgs',
    'MalwareProtectionPlanCfnProtectedResourceS3BucketPropertiesArgsDict',
    'MalwareProtectionPlanCfnProtectedResourceArgs',
    'MalwareProtectionPlanCfnProtectedResourceArgsDict',
    'MalwareProtectionPlanCfnTaggingArgs',
    'MalwareProtectionPlanCfnTaggingArgsDict',
]

MYPY = False

if not MYPY:
    class DetectorCfnDataSourceConfigurationsArgsDict(TypedDict):
        kubernetes: NotRequired[pulumi.Input['DetectorCfnKubernetesConfigurationArgsDict']]
        """
        Describes which Kubernetes data sources are enabled for a detector.
        """
        malware_protection: NotRequired[pulumi.Input['DetectorCfnMalwareProtectionConfigurationArgsDict']]
        """
        Describes whether Malware Protection will be enabled as a data source.
        """
        s3_logs: NotRequired[pulumi.Input['DetectorCfns3LogsConfigurationArgsDict']]
        """
        Describes whether S3 data event logs are enabled as a data source.
        """
elif False:
    DetectorCfnDataSourceConfigurationsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DetectorCfnDataSourceConfigurationsArgs:
    def __init__(__self__, *,
                 kubernetes: Optional[pulumi.Input['DetectorCfnKubernetesConfigurationArgs']] = None,
                 malware_protection: Optional[pulumi.Input['DetectorCfnMalwareProtectionConfigurationArgs']] = None,
                 s3_logs: Optional[pulumi.Input['DetectorCfns3LogsConfigurationArgs']] = None):
        """
        :param pulumi.Input['DetectorCfnKubernetesConfigurationArgs'] kubernetes: Describes which Kubernetes data sources are enabled for a detector.
        :param pulumi.Input['DetectorCfnMalwareProtectionConfigurationArgs'] malware_protection: Describes whether Malware Protection will be enabled as a data source.
        :param pulumi.Input['DetectorCfns3LogsConfigurationArgs'] s3_logs: Describes whether S3 data event logs are enabled as a data source.
        """
        if kubernetes is not None:
            pulumi.set(__self__, "kubernetes", kubernetes)
        if malware_protection is not None:
            pulumi.set(__self__, "malware_protection", malware_protection)
        if s3_logs is not None:
            pulumi.set(__self__, "s3_logs", s3_logs)

    @property
    @pulumi.getter
    def kubernetes(self) -> Optional[pulumi.Input['DetectorCfnKubernetesConfigurationArgs']]:
        """
        Describes which Kubernetes data sources are enabled for a detector.
        """
        return pulumi.get(self, "kubernetes")

    @kubernetes.setter
    def kubernetes(self, value: Optional[pulumi.Input['DetectorCfnKubernetesConfigurationArgs']]):
        pulumi.set(self, "kubernetes", value)

    @property
    @pulumi.getter(name="malwareProtection")
    def malware_protection(self) -> Optional[pulumi.Input['DetectorCfnMalwareProtectionConfigurationArgs']]:
        """
        Describes whether Malware Protection will be enabled as a data source.
        """
        return pulumi.get(self, "malware_protection")

    @malware_protection.setter
    def malware_protection(self, value: Optional[pulumi.Input['DetectorCfnMalwareProtectionConfigurationArgs']]):
        pulumi.set(self, "malware_protection", value)

    @property
    @pulumi.getter(name="s3Logs")
    def s3_logs(self) -> Optional[pulumi.Input['DetectorCfns3LogsConfigurationArgs']]:
        """
        Describes whether S3 data event logs are enabled as a data source.
        """
        return pulumi.get(self, "s3_logs")

    @s3_logs.setter
    def s3_logs(self, value: Optional[pulumi.Input['DetectorCfns3LogsConfigurationArgs']]):
        pulumi.set(self, "s3_logs", value)


if not MYPY:
    class DetectorCfnFeatureAdditionalConfigurationArgsDict(TypedDict):
        name: NotRequired[pulumi.Input[str]]
        """
        Name of the additional configuration.
        """
        status: NotRequired[pulumi.Input[str]]
        """
        Status of the additional configuration.
        """
elif False:
    DetectorCfnFeatureAdditionalConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DetectorCfnFeatureAdditionalConfigurationArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: Name of the additional configuration.
        :param pulumi.Input[str] status: Status of the additional configuration.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the additional configuration.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of the additional configuration.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


if not MYPY:
    class DetectorCfnFeatureConfigurationArgsDict(TypedDict):
        name: pulumi.Input[str]
        """
        Name of the feature. For a list of allowed values, see [DetectorFeatureConfiguration](https://docs.aws.amazon.com/guardduty/latest/APIReference/API_DetectorFeatureConfiguration.html#guardduty-Type-DetectorFeatureConfiguration-name) in the *GuardDuty API Reference* .
        """
        status: pulumi.Input['DetectorCfnFeatureConfigurationStatus']
        """
        Status of the feature configuration.
        """
        additional_configuration: NotRequired[pulumi.Input[Sequence[pulumi.Input['DetectorCfnFeatureAdditionalConfigurationArgsDict']]]]
        """
        Information about the additional configuration of a feature in your account.
        """
elif False:
    DetectorCfnFeatureConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DetectorCfnFeatureConfigurationArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 status: pulumi.Input['DetectorCfnFeatureConfigurationStatus'],
                 additional_configuration: Optional[pulumi.Input[Sequence[pulumi.Input['DetectorCfnFeatureAdditionalConfigurationArgs']]]] = None):
        """
        :param pulumi.Input[str] name: Name of the feature. For a list of allowed values, see [DetectorFeatureConfiguration](https://docs.aws.amazon.com/guardduty/latest/APIReference/API_DetectorFeatureConfiguration.html#guardduty-Type-DetectorFeatureConfiguration-name) in the *GuardDuty API Reference* .
        :param pulumi.Input['DetectorCfnFeatureConfigurationStatus'] status: Status of the feature configuration.
        :param pulumi.Input[Sequence[pulumi.Input['DetectorCfnFeatureAdditionalConfigurationArgs']]] additional_configuration: Information about the additional configuration of a feature in your account.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "status", status)
        if additional_configuration is not None:
            pulumi.set(__self__, "additional_configuration", additional_configuration)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Name of the feature. For a list of allowed values, see [DetectorFeatureConfiguration](https://docs.aws.amazon.com/guardduty/latest/APIReference/API_DetectorFeatureConfiguration.html#guardduty-Type-DetectorFeatureConfiguration-name) in the *GuardDuty API Reference* .
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def status(self) -> pulumi.Input['DetectorCfnFeatureConfigurationStatus']:
        """
        Status of the feature configuration.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: pulumi.Input['DetectorCfnFeatureConfigurationStatus']):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="additionalConfiguration")
    def additional_configuration(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DetectorCfnFeatureAdditionalConfigurationArgs']]]]:
        """
        Information about the additional configuration of a feature in your account.
        """
        return pulumi.get(self, "additional_configuration")

    @additional_configuration.setter
    def additional_configuration(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DetectorCfnFeatureAdditionalConfigurationArgs']]]]):
        pulumi.set(self, "additional_configuration", value)


if not MYPY:
    class DetectorCfnKubernetesAuditLogsConfigurationArgsDict(TypedDict):
        enable: pulumi.Input[bool]
        """
        Describes whether Kubernetes audit logs are enabled as a data source for the detector.
        """
elif False:
    DetectorCfnKubernetesAuditLogsConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DetectorCfnKubernetesAuditLogsConfigurationArgs:
    def __init__(__self__, *,
                 enable: pulumi.Input[bool]):
        """
        :param pulumi.Input[bool] enable: Describes whether Kubernetes audit logs are enabled as a data source for the detector.
        """
        pulumi.set(__self__, "enable", enable)

    @property
    @pulumi.getter
    def enable(self) -> pulumi.Input[bool]:
        """
        Describes whether Kubernetes audit logs are enabled as a data source for the detector.
        """
        return pulumi.get(self, "enable")

    @enable.setter
    def enable(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enable", value)


if not MYPY:
    class DetectorCfnKubernetesConfigurationArgsDict(TypedDict):
        audit_logs: pulumi.Input['DetectorCfnKubernetesAuditLogsConfigurationArgsDict']
        """
        Describes whether Kubernetes audit logs are enabled as a data source for the detector.
        """
elif False:
    DetectorCfnKubernetesConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DetectorCfnKubernetesConfigurationArgs:
    def __init__(__self__, *,
                 audit_logs: pulumi.Input['DetectorCfnKubernetesAuditLogsConfigurationArgs']):
        """
        :param pulumi.Input['DetectorCfnKubernetesAuditLogsConfigurationArgs'] audit_logs: Describes whether Kubernetes audit logs are enabled as a data source for the detector.
        """
        pulumi.set(__self__, "audit_logs", audit_logs)

    @property
    @pulumi.getter(name="auditLogs")
    def audit_logs(self) -> pulumi.Input['DetectorCfnKubernetesAuditLogsConfigurationArgs']:
        """
        Describes whether Kubernetes audit logs are enabled as a data source for the detector.
        """
        return pulumi.get(self, "audit_logs")

    @audit_logs.setter
    def audit_logs(self, value: pulumi.Input['DetectorCfnKubernetesAuditLogsConfigurationArgs']):
        pulumi.set(self, "audit_logs", value)


if not MYPY:
    class DetectorCfnMalwareProtectionConfigurationArgsDict(TypedDict):
        scan_ec2_instance_with_findings: NotRequired[pulumi.Input['DetectorCfnScanEc2InstanceWithFindingsConfigurationArgsDict']]
        """
        Describes the configuration of Malware Protection for EC2 instances with findings.
        """
elif False:
    DetectorCfnMalwareProtectionConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DetectorCfnMalwareProtectionConfigurationArgs:
    def __init__(__self__, *,
                 scan_ec2_instance_with_findings: Optional[pulumi.Input['DetectorCfnScanEc2InstanceWithFindingsConfigurationArgs']] = None):
        """
        :param pulumi.Input['DetectorCfnScanEc2InstanceWithFindingsConfigurationArgs'] scan_ec2_instance_with_findings: Describes the configuration of Malware Protection for EC2 instances with findings.
        """
        if scan_ec2_instance_with_findings is not None:
            pulumi.set(__self__, "scan_ec2_instance_with_findings", scan_ec2_instance_with_findings)

    @property
    @pulumi.getter(name="scanEc2InstanceWithFindings")
    def scan_ec2_instance_with_findings(self) -> Optional[pulumi.Input['DetectorCfnScanEc2InstanceWithFindingsConfigurationArgs']]:
        """
        Describes the configuration of Malware Protection for EC2 instances with findings.
        """
        return pulumi.get(self, "scan_ec2_instance_with_findings")

    @scan_ec2_instance_with_findings.setter
    def scan_ec2_instance_with_findings(self, value: Optional[pulumi.Input['DetectorCfnScanEc2InstanceWithFindingsConfigurationArgs']]):
        pulumi.set(self, "scan_ec2_instance_with_findings", value)


if not MYPY:
    class DetectorCfnScanEc2InstanceWithFindingsConfigurationArgsDict(TypedDict):
        ebs_volumes: NotRequired[pulumi.Input[bool]]
        """
        Describes the configuration for scanning EBS volumes as data source.
        """
elif False:
    DetectorCfnScanEc2InstanceWithFindingsConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DetectorCfnScanEc2InstanceWithFindingsConfigurationArgs:
    def __init__(__self__, *,
                 ebs_volumes: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[bool] ebs_volumes: Describes the configuration for scanning EBS volumes as data source.
        """
        if ebs_volumes is not None:
            pulumi.set(__self__, "ebs_volumes", ebs_volumes)

    @property
    @pulumi.getter(name="ebsVolumes")
    def ebs_volumes(self) -> Optional[pulumi.Input[bool]]:
        """
        Describes the configuration for scanning EBS volumes as data source.
        """
        return pulumi.get(self, "ebs_volumes")

    @ebs_volumes.setter
    def ebs_volumes(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ebs_volumes", value)


if not MYPY:
    class DetectorCfns3LogsConfigurationArgsDict(TypedDict):
        enable: pulumi.Input[bool]
        """
        The status of S3 data event logs as a data source.
        """
elif False:
    DetectorCfns3LogsConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DetectorCfns3LogsConfigurationArgs:
    def __init__(__self__, *,
                 enable: pulumi.Input[bool]):
        """
        :param pulumi.Input[bool] enable: The status of S3 data event logs as a data source.
        """
        pulumi.set(__self__, "enable", enable)

    @property
    @pulumi.getter
    def enable(self) -> pulumi.Input[bool]:
        """
        The status of S3 data event logs as a data source.
        """
        return pulumi.get(self, "enable")

    @enable.setter
    def enable(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enable", value)


if not MYPY:
    class FilterConditionArgsDict(TypedDict):
        eq: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        equals: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        greater_than: NotRequired[pulumi.Input[int]]
        greater_than_or_equal: NotRequired[pulumi.Input[int]]
        gt: NotRequired[pulumi.Input[int]]
        gte: NotRequired[pulumi.Input[int]]
        less_than: NotRequired[pulumi.Input[int]]
        less_than_or_equal: NotRequired[pulumi.Input[int]]
        lt: NotRequired[pulumi.Input[int]]
        lte: NotRequired[pulumi.Input[int]]
        neq: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        not_equals: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
elif False:
    FilterConditionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FilterConditionArgs:
    def __init__(__self__, *,
                 eq: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 equals: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 greater_than: Optional[pulumi.Input[int]] = None,
                 greater_than_or_equal: Optional[pulumi.Input[int]] = None,
                 gt: Optional[pulumi.Input[int]] = None,
                 gte: Optional[pulumi.Input[int]] = None,
                 less_than: Optional[pulumi.Input[int]] = None,
                 less_than_or_equal: Optional[pulumi.Input[int]] = None,
                 lt: Optional[pulumi.Input[int]] = None,
                 lte: Optional[pulumi.Input[int]] = None,
                 neq: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 not_equals: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        if eq is not None:
            pulumi.set(__self__, "eq", eq)
        if equals is not None:
            pulumi.set(__self__, "equals", equals)
        if greater_than is not None:
            pulumi.set(__self__, "greater_than", greater_than)
        if greater_than_or_equal is not None:
            pulumi.set(__self__, "greater_than_or_equal", greater_than_or_equal)
        if gt is not None:
            pulumi.set(__self__, "gt", gt)
        if gte is not None:
            pulumi.set(__self__, "gte", gte)
        if less_than is not None:
            pulumi.set(__self__, "less_than", less_than)
        if less_than_or_equal is not None:
            pulumi.set(__self__, "less_than_or_equal", less_than_or_equal)
        if lt is not None:
            pulumi.set(__self__, "lt", lt)
        if lte is not None:
            pulumi.set(__self__, "lte", lte)
        if neq is not None:
            pulumi.set(__self__, "neq", neq)
        if not_equals is not None:
            pulumi.set(__self__, "not_equals", not_equals)

    @property
    @pulumi.getter
    def eq(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "eq")

    @eq.setter
    def eq(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "eq", value)

    @property
    @pulumi.getter
    def equals(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "equals")

    @equals.setter
    def equals(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "equals", value)

    @property
    @pulumi.getter(name="greaterThan")
    def greater_than(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "greater_than")

    @greater_than.setter
    def greater_than(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "greater_than", value)

    @property
    @pulumi.getter(name="greaterThanOrEqual")
    def greater_than_or_equal(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "greater_than_or_equal")

    @greater_than_or_equal.setter
    def greater_than_or_equal(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "greater_than_or_equal", value)

    @property
    @pulumi.getter
    def gt(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "gt")

    @gt.setter
    def gt(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "gt", value)

    @property
    @pulumi.getter
    def gte(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "gte")

    @gte.setter
    def gte(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "gte", value)

    @property
    @pulumi.getter(name="lessThan")
    def less_than(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "less_than")

    @less_than.setter
    def less_than(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "less_than", value)

    @property
    @pulumi.getter(name="lessThanOrEqual")
    def less_than_or_equal(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "less_than_or_equal")

    @less_than_or_equal.setter
    def less_than_or_equal(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "less_than_or_equal", value)

    @property
    @pulumi.getter
    def lt(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "lt")

    @lt.setter
    def lt(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "lt", value)

    @property
    @pulumi.getter
    def lte(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "lte")

    @lte.setter
    def lte(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "lte", value)

    @property
    @pulumi.getter
    def neq(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "neq")

    @neq.setter
    def neq(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "neq", value)

    @property
    @pulumi.getter(name="notEquals")
    def not_equals(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "not_equals")

    @not_equals.setter
    def not_equals(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "not_equals", value)


if not MYPY:
    class FilterFindingCriteriaArgsDict(TypedDict):
        criterion: NotRequired[pulumi.Input[Mapping[str, pulumi.Input['FilterConditionArgsDict']]]]
        """
        Represents a map of finding properties that match specified conditions and values when querying findings.

        For information about JSON criterion mapping to their console equivalent, see [Finding criteria](https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_filter-findings.html#filter_criteria) . The following are the available criterion:

        - accountId
        - id
        - region
        - severity

        To filter on the basis of severity, the API and AWS CLI use the following input list for the `FindingCriteria` condition:

        - *Low* : `["1", "2", "3"]`
        - *Medium* : `["4", "5", "6"]`
        - *High* : `["7", "8", "9"]`

        For more information, see [Severity levels for GuardDuty findings](https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_findings.html#guardduty_findings-severity) in the *Amazon GuardDuty User Guide* .
        - type
        - updatedAt

        Type: ISO 8601 string format: `YYYY-MM-DDTHH:MM:SS.SSSZ` or `YYYY-MM-DDTHH:MM:SSZ` depending on whether the value contains milliseconds.
        - resource.accessKeyDetails.accessKeyId
        - resource.accessKeyDetails.principalId
        - resource.accessKeyDetails.userName
        - resource.accessKeyDetails.userType
        - resource.instanceDetails.iamInstanceProfile.id
        - resource.instanceDetails.imageId
        - resource.instanceDetails.instanceId
        - resource.instanceDetails.tags.key
        - resource.instanceDetails.tags.value
        - resource.instanceDetails.networkInterfaces.ipv6Addresses
        - resource.instanceDetails.networkInterfaces.privateIpAddresses.privateIpAddress
        - resource.instanceDetails.networkInterfaces.publicDnsName
        - resource.instanceDetails.networkInterfaces.publicIp
        - resource.instanceDetails.networkInterfaces.securityGroups.groupId
        - resource.instanceDetails.networkInterfaces.securityGroups.groupName
        - resource.instanceDetails.networkInterfaces.subnetId
        - resource.instanceDetails.networkInterfaces.vpcId
        - resource.instanceDetails.outpostArn
        - resource.resourceType
        - resource.s3BucketDetails.publicAccess.effectivePermissions
        - resource.s3BucketDetails.name
        - resource.s3BucketDetails.tags.key
        - resource.s3BucketDetails.tags.value
        - resource.s3BucketDetails.type
        - service.action.actionType
        - service.action.awsApiCallAction.api
        - service.action.awsApiCallAction.callerType
        - service.action.awsApiCallAction.errorCode
        - service.action.awsApiCallAction.remoteIpDetails.city.cityName
        - service.action.awsApiCallAction.remoteIpDetails.country.countryName
        - service.action.awsApiCallAction.remoteIpDetails.ipAddressV4
        - service.action.awsApiCallAction.remoteIpDetails.ipAddressV6
        - service.action.awsApiCallAction.remoteIpDetails.organization.asn
        - service.action.awsApiCallAction.remoteIpDetails.organization.asnOrg
        - service.action.awsApiCallAction.serviceName
        - service.action.dnsRequestAction.domain
        - service.action.dnsRequestAction.domainWithSuffix
        - service.action.networkConnectionAction.blocked
        - service.action.networkConnectionAction.connectionDirection
        - service.action.networkConnectionAction.localPortDetails.port
        - service.action.networkConnectionAction.protocol
        - service.action.networkConnectionAction.remoteIpDetails.city.cityName
        - service.action.networkConnectionAction.remoteIpDetails.country.countryName
        - service.action.networkConnectionAction.remoteIpDetails.ipAddressV4
        - service.action.networkConnectionAction.remoteIpDetails.ipAddressV6
        - service.action.networkConnectionAction.remoteIpDetails.organization.asn
        - service.action.networkConnectionAction.remoteIpDetails.organization.asnOrg
        - service.action.networkConnectionAction.remotePortDetails.port
        - service.action.awsApiCallAction.remoteAccountDetails.affiliated
        - service.action.kubernetesApiCallAction.remoteIpDetails.ipAddressV4
        - service.action.kubernetesApiCallAction.remoteIpDetails.ipAddressV6
        - service.action.kubernetesApiCallAction.namespace
        - service.action.kubernetesApiCallAction.remoteIpDetails.organization.asn
        - service.action.kubernetesApiCallAction.requestUri
        - service.action.kubernetesApiCallAction.statusCode
        - service.action.networkConnectionAction.localIpDetails.ipAddressV4
        - service.action.networkConnectionAction.localIpDetails.ipAddressV6
        - service.action.networkConnectionAction.protocol
        - service.action.awsApiCallAction.serviceName
        - service.action.awsApiCallAction.remoteAccountDetails.accountId
        - service.additionalInfo.threatListName
        - service.resourceRole
        - resource.eksClusterDetails.name
        - resource.kubernetesDetails.kubernetesWorkloadDetails.name
        - resource.kubernetesDetails.kubernetesWorkloadDetails.namespace
        - resource.kubernetesDetails.kubernetesUserDetails.username
        - resource.kubernetesDetails.kubernetesWorkloadDetails.containers.image
        - resource.kubernetesDetails.kubernetesWorkloadDetails.containers.imagePrefix
        - service.ebsVolumeScanDetails.scanId
        - service.ebsVolumeScanDetails.scanDetections.threatDetectedByName.threatNames.name
        - service.ebsVolumeScanDetails.scanDetections.threatDetectedByName.threatNames.severity
        - service.ebsVolumeScanDetails.scanDetections.threatDetectedByName.threatNames.filePaths.hash
        - service.malwareScanDetails.threats.name
        - resource.ecsClusterDetails.name
        - resource.ecsClusterDetails.taskDetails.containers.image
        - resource.ecsClusterDetails.taskDetails.definitionArn
        - resource.containerDetails.image
        - resource.rdsDbInstanceDetails.dbInstanceIdentifier
        - resource.rdsDbInstanceDetails.dbClusterIdentifier
        - resource.rdsDbInstanceDetails.engine
        - resource.rdsDbUserDetails.user
        - resource.rdsDbInstanceDetails.tags.key
        - resource.rdsDbInstanceDetails.tags.value
        - service.runtimeDetails.process.executableSha256
        - service.runtimeDetails.process.name
        - service.runtimeDetails.process.name
        - resource.lambdaDetails.functionName
        - resource.lambdaDetails.functionArn
        - resource.lambdaDetails.tags.key
        - resource.lambdaDetails.tags.value
        """
elif False:
    FilterFindingCriteriaArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FilterFindingCriteriaArgs:
    def __init__(__self__, *,
                 criterion: Optional[pulumi.Input[Mapping[str, pulumi.Input['FilterConditionArgs']]]] = None):
        """
        :param pulumi.Input[Mapping[str, pulumi.Input['FilterConditionArgs']]] criterion: Represents a map of finding properties that match specified conditions and values when querying findings.
               
               For information about JSON criterion mapping to their console equivalent, see [Finding criteria](https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_filter-findings.html#filter_criteria) . The following are the available criterion:
               
               - accountId
               - id
               - region
               - severity
               
               To filter on the basis of severity, the API and AWS CLI use the following input list for the `FindingCriteria` condition:
               
               - *Low* : `["1", "2", "3"]`
               - *Medium* : `["4", "5", "6"]`
               - *High* : `["7", "8", "9"]`
               
               For more information, see [Severity levels for GuardDuty findings](https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_findings.html#guardduty_findings-severity) in the *Amazon GuardDuty User Guide* .
               - type
               - updatedAt
               
               Type: ISO 8601 string format: `YYYY-MM-DDTHH:MM:SS.SSSZ` or `YYYY-MM-DDTHH:MM:SSZ` depending on whether the value contains milliseconds.
               - resource.accessKeyDetails.accessKeyId
               - resource.accessKeyDetails.principalId
               - resource.accessKeyDetails.userName
               - resource.accessKeyDetails.userType
               - resource.instanceDetails.iamInstanceProfile.id
               - resource.instanceDetails.imageId
               - resource.instanceDetails.instanceId
               - resource.instanceDetails.tags.key
               - resource.instanceDetails.tags.value
               - resource.instanceDetails.networkInterfaces.ipv6Addresses
               - resource.instanceDetails.networkInterfaces.privateIpAddresses.privateIpAddress
               - resource.instanceDetails.networkInterfaces.publicDnsName
               - resource.instanceDetails.networkInterfaces.publicIp
               - resource.instanceDetails.networkInterfaces.securityGroups.groupId
               - resource.instanceDetails.networkInterfaces.securityGroups.groupName
               - resource.instanceDetails.networkInterfaces.subnetId
               - resource.instanceDetails.networkInterfaces.vpcId
               - resource.instanceDetails.outpostArn
               - resource.resourceType
               - resource.s3BucketDetails.publicAccess.effectivePermissions
               - resource.s3BucketDetails.name
               - resource.s3BucketDetails.tags.key
               - resource.s3BucketDetails.tags.value
               - resource.s3BucketDetails.type
               - service.action.actionType
               - service.action.awsApiCallAction.api
               - service.action.awsApiCallAction.callerType
               - service.action.awsApiCallAction.errorCode
               - service.action.awsApiCallAction.remoteIpDetails.city.cityName
               - service.action.awsApiCallAction.remoteIpDetails.country.countryName
               - service.action.awsApiCallAction.remoteIpDetails.ipAddressV4
               - service.action.awsApiCallAction.remoteIpDetails.ipAddressV6
               - service.action.awsApiCallAction.remoteIpDetails.organization.asn
               - service.action.awsApiCallAction.remoteIpDetails.organization.asnOrg
               - service.action.awsApiCallAction.serviceName
               - service.action.dnsRequestAction.domain
               - service.action.dnsRequestAction.domainWithSuffix
               - service.action.networkConnectionAction.blocked
               - service.action.networkConnectionAction.connectionDirection
               - service.action.networkConnectionAction.localPortDetails.port
               - service.action.networkConnectionAction.protocol
               - service.action.networkConnectionAction.remoteIpDetails.city.cityName
               - service.action.networkConnectionAction.remoteIpDetails.country.countryName
               - service.action.networkConnectionAction.remoteIpDetails.ipAddressV4
               - service.action.networkConnectionAction.remoteIpDetails.ipAddressV6
               - service.action.networkConnectionAction.remoteIpDetails.organization.asn
               - service.action.networkConnectionAction.remoteIpDetails.organization.asnOrg
               - service.action.networkConnectionAction.remotePortDetails.port
               - service.action.awsApiCallAction.remoteAccountDetails.affiliated
               - service.action.kubernetesApiCallAction.remoteIpDetails.ipAddressV4
               - service.action.kubernetesApiCallAction.remoteIpDetails.ipAddressV6
               - service.action.kubernetesApiCallAction.namespace
               - service.action.kubernetesApiCallAction.remoteIpDetails.organization.asn
               - service.action.kubernetesApiCallAction.requestUri
               - service.action.kubernetesApiCallAction.statusCode
               - service.action.networkConnectionAction.localIpDetails.ipAddressV4
               - service.action.networkConnectionAction.localIpDetails.ipAddressV6
               - service.action.networkConnectionAction.protocol
               - service.action.awsApiCallAction.serviceName
               - service.action.awsApiCallAction.remoteAccountDetails.accountId
               - service.additionalInfo.threatListName
               - service.resourceRole
               - resource.eksClusterDetails.name
               - resource.kubernetesDetails.kubernetesWorkloadDetails.name
               - resource.kubernetesDetails.kubernetesWorkloadDetails.namespace
               - resource.kubernetesDetails.kubernetesUserDetails.username
               - resource.kubernetesDetails.kubernetesWorkloadDetails.containers.image
               - resource.kubernetesDetails.kubernetesWorkloadDetails.containers.imagePrefix
               - service.ebsVolumeScanDetails.scanId
               - service.ebsVolumeScanDetails.scanDetections.threatDetectedByName.threatNames.name
               - service.ebsVolumeScanDetails.scanDetections.threatDetectedByName.threatNames.severity
               - service.ebsVolumeScanDetails.scanDetections.threatDetectedByName.threatNames.filePaths.hash
               - service.malwareScanDetails.threats.name
               - resource.ecsClusterDetails.name
               - resource.ecsClusterDetails.taskDetails.containers.image
               - resource.ecsClusterDetails.taskDetails.definitionArn
               - resource.containerDetails.image
               - resource.rdsDbInstanceDetails.dbInstanceIdentifier
               - resource.rdsDbInstanceDetails.dbClusterIdentifier
               - resource.rdsDbInstanceDetails.engine
               - resource.rdsDbUserDetails.user
               - resource.rdsDbInstanceDetails.tags.key
               - resource.rdsDbInstanceDetails.tags.value
               - service.runtimeDetails.process.executableSha256
               - service.runtimeDetails.process.name
               - service.runtimeDetails.process.name
               - resource.lambdaDetails.functionName
               - resource.lambdaDetails.functionArn
               - resource.lambdaDetails.tags.key
               - resource.lambdaDetails.tags.value
        """
        if criterion is not None:
            pulumi.set(__self__, "criterion", criterion)

    @property
    @pulumi.getter
    def criterion(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['FilterConditionArgs']]]]:
        """
        Represents a map of finding properties that match specified conditions and values when querying findings.

        For information about JSON criterion mapping to their console equivalent, see [Finding criteria](https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_filter-findings.html#filter_criteria) . The following are the available criterion:

        - accountId
        - id
        - region
        - severity

        To filter on the basis of severity, the API and AWS CLI use the following input list for the `FindingCriteria` condition:

        - *Low* : `["1", "2", "3"]`
        - *Medium* : `["4", "5", "6"]`
        - *High* : `["7", "8", "9"]`

        For more information, see [Severity levels for GuardDuty findings](https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_findings.html#guardduty_findings-severity) in the *Amazon GuardDuty User Guide* .
        - type
        - updatedAt

        Type: ISO 8601 string format: `YYYY-MM-DDTHH:MM:SS.SSSZ` or `YYYY-MM-DDTHH:MM:SSZ` depending on whether the value contains milliseconds.
        - resource.accessKeyDetails.accessKeyId
        - resource.accessKeyDetails.principalId
        - resource.accessKeyDetails.userName
        - resource.accessKeyDetails.userType
        - resource.instanceDetails.iamInstanceProfile.id
        - resource.instanceDetails.imageId
        - resource.instanceDetails.instanceId
        - resource.instanceDetails.tags.key
        - resource.instanceDetails.tags.value
        - resource.instanceDetails.networkInterfaces.ipv6Addresses
        - resource.instanceDetails.networkInterfaces.privateIpAddresses.privateIpAddress
        - resource.instanceDetails.networkInterfaces.publicDnsName
        - resource.instanceDetails.networkInterfaces.publicIp
        - resource.instanceDetails.networkInterfaces.securityGroups.groupId
        - resource.instanceDetails.networkInterfaces.securityGroups.groupName
        - resource.instanceDetails.networkInterfaces.subnetId
        - resource.instanceDetails.networkInterfaces.vpcId
        - resource.instanceDetails.outpostArn
        - resource.resourceType
        - resource.s3BucketDetails.publicAccess.effectivePermissions
        - resource.s3BucketDetails.name
        - resource.s3BucketDetails.tags.key
        - resource.s3BucketDetails.tags.value
        - resource.s3BucketDetails.type
        - service.action.actionType
        - service.action.awsApiCallAction.api
        - service.action.awsApiCallAction.callerType
        - service.action.awsApiCallAction.errorCode
        - service.action.awsApiCallAction.remoteIpDetails.city.cityName
        - service.action.awsApiCallAction.remoteIpDetails.country.countryName
        - service.action.awsApiCallAction.remoteIpDetails.ipAddressV4
        - service.action.awsApiCallAction.remoteIpDetails.ipAddressV6
        - service.action.awsApiCallAction.remoteIpDetails.organization.asn
        - service.action.awsApiCallAction.remoteIpDetails.organization.asnOrg
        - service.action.awsApiCallAction.serviceName
        - service.action.dnsRequestAction.domain
        - service.action.dnsRequestAction.domainWithSuffix
        - service.action.networkConnectionAction.blocked
        - service.action.networkConnectionAction.connectionDirection
        - service.action.networkConnectionAction.localPortDetails.port
        - service.action.networkConnectionAction.protocol
        - service.action.networkConnectionAction.remoteIpDetails.city.cityName
        - service.action.networkConnectionAction.remoteIpDetails.country.countryName
        - service.action.networkConnectionAction.remoteIpDetails.ipAddressV4
        - service.action.networkConnectionAction.remoteIpDetails.ipAddressV6
        - service.action.networkConnectionAction.remoteIpDetails.organization.asn
        - service.action.networkConnectionAction.remoteIpDetails.organization.asnOrg
        - service.action.networkConnectionAction.remotePortDetails.port
        - service.action.awsApiCallAction.remoteAccountDetails.affiliated
        - service.action.kubernetesApiCallAction.remoteIpDetails.ipAddressV4
        - service.action.kubernetesApiCallAction.remoteIpDetails.ipAddressV6
        - service.action.kubernetesApiCallAction.namespace
        - service.action.kubernetesApiCallAction.remoteIpDetails.organization.asn
        - service.action.kubernetesApiCallAction.requestUri
        - service.action.kubernetesApiCallAction.statusCode
        - service.action.networkConnectionAction.localIpDetails.ipAddressV4
        - service.action.networkConnectionAction.localIpDetails.ipAddressV6
        - service.action.networkConnectionAction.protocol
        - service.action.awsApiCallAction.serviceName
        - service.action.awsApiCallAction.remoteAccountDetails.accountId
        - service.additionalInfo.threatListName
        - service.resourceRole
        - resource.eksClusterDetails.name
        - resource.kubernetesDetails.kubernetesWorkloadDetails.name
        - resource.kubernetesDetails.kubernetesWorkloadDetails.namespace
        - resource.kubernetesDetails.kubernetesUserDetails.username
        - resource.kubernetesDetails.kubernetesWorkloadDetails.containers.image
        - resource.kubernetesDetails.kubernetesWorkloadDetails.containers.imagePrefix
        - service.ebsVolumeScanDetails.scanId
        - service.ebsVolumeScanDetails.scanDetections.threatDetectedByName.threatNames.name
        - service.ebsVolumeScanDetails.scanDetections.threatDetectedByName.threatNames.severity
        - service.ebsVolumeScanDetails.scanDetections.threatDetectedByName.threatNames.filePaths.hash
        - service.malwareScanDetails.threats.name
        - resource.ecsClusterDetails.name
        - resource.ecsClusterDetails.taskDetails.containers.image
        - resource.ecsClusterDetails.taskDetails.definitionArn
        - resource.containerDetails.image
        - resource.rdsDbInstanceDetails.dbInstanceIdentifier
        - resource.rdsDbInstanceDetails.dbClusterIdentifier
        - resource.rdsDbInstanceDetails.engine
        - resource.rdsDbUserDetails.user
        - resource.rdsDbInstanceDetails.tags.key
        - resource.rdsDbInstanceDetails.tags.value
        - service.runtimeDetails.process.executableSha256
        - service.runtimeDetails.process.name
        - service.runtimeDetails.process.name
        - resource.lambdaDetails.functionName
        - resource.lambdaDetails.functionArn
        - resource.lambdaDetails.tags.key
        - resource.lambdaDetails.tags.value
        """
        return pulumi.get(self, "criterion")

    @criterion.setter
    def criterion(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['FilterConditionArgs']]]]):
        pulumi.set(self, "criterion", value)


if not MYPY:
    class MalwareProtectionPlanCfnActionsArgsDict(TypedDict):
        tagging: NotRequired[pulumi.Input['MalwareProtectionPlanCfnTaggingArgsDict']]
        """
        Contains information about tagging status of the Malware Protection plan resource.
        """
elif False:
    MalwareProtectionPlanCfnActionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MalwareProtectionPlanCfnActionsArgs:
    def __init__(__self__, *,
                 tagging: Optional[pulumi.Input['MalwareProtectionPlanCfnTaggingArgs']] = None):
        """
        :param pulumi.Input['MalwareProtectionPlanCfnTaggingArgs'] tagging: Contains information about tagging status of the Malware Protection plan resource.
        """
        if tagging is not None:
            pulumi.set(__self__, "tagging", tagging)

    @property
    @pulumi.getter
    def tagging(self) -> Optional[pulumi.Input['MalwareProtectionPlanCfnTaggingArgs']]:
        """
        Contains information about tagging status of the Malware Protection plan resource.
        """
        return pulumi.get(self, "tagging")

    @tagging.setter
    def tagging(self, value: Optional[pulumi.Input['MalwareProtectionPlanCfnTaggingArgs']]):
        pulumi.set(self, "tagging", value)


if not MYPY:
    class MalwareProtectionPlanCfnProtectedResourceS3BucketPropertiesArgsDict(TypedDict):
        """
        Information about the protected S3 bucket resource.
        """
        bucket_name: NotRequired[pulumi.Input[str]]
        """
        Name of the S3 bucket.
        """
        object_prefixes: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        Information about the specified object prefixes. The S3 object will be scanned only if it belongs to any of the specified object prefixes.
        """
elif False:
    MalwareProtectionPlanCfnProtectedResourceS3BucketPropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MalwareProtectionPlanCfnProtectedResourceS3BucketPropertiesArgs:
    def __init__(__self__, *,
                 bucket_name: Optional[pulumi.Input[str]] = None,
                 object_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Information about the protected S3 bucket resource.
        :param pulumi.Input[str] bucket_name: Name of the S3 bucket.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] object_prefixes: Information about the specified object prefixes. The S3 object will be scanned only if it belongs to any of the specified object prefixes.
        """
        if bucket_name is not None:
            pulumi.set(__self__, "bucket_name", bucket_name)
        if object_prefixes is not None:
            pulumi.set(__self__, "object_prefixes", object_prefixes)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the S3 bucket.
        """
        return pulumi.get(self, "bucket_name")

    @bucket_name.setter
    def bucket_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bucket_name", value)

    @property
    @pulumi.getter(name="objectPrefixes")
    def object_prefixes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Information about the specified object prefixes. The S3 object will be scanned only if it belongs to any of the specified object prefixes.
        """
        return pulumi.get(self, "object_prefixes")

    @object_prefixes.setter
    def object_prefixes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "object_prefixes", value)


if not MYPY:
    class MalwareProtectionPlanCfnProtectedResourceArgsDict(TypedDict):
        s3_bucket: pulumi.Input['MalwareProtectionPlanCfnProtectedResourceS3BucketPropertiesArgsDict']
        """
        Information about the protected S3 bucket resource.
        """
elif False:
    MalwareProtectionPlanCfnProtectedResourceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MalwareProtectionPlanCfnProtectedResourceArgs:
    def __init__(__self__, *,
                 s3_bucket: pulumi.Input['MalwareProtectionPlanCfnProtectedResourceS3BucketPropertiesArgs']):
        """
        :param pulumi.Input['MalwareProtectionPlanCfnProtectedResourceS3BucketPropertiesArgs'] s3_bucket: Information about the protected S3 bucket resource.
        """
        pulumi.set(__self__, "s3_bucket", s3_bucket)

    @property
    @pulumi.getter(name="s3Bucket")
    def s3_bucket(self) -> pulumi.Input['MalwareProtectionPlanCfnProtectedResourceS3BucketPropertiesArgs']:
        """
        Information about the protected S3 bucket resource.
        """
        return pulumi.get(self, "s3_bucket")

    @s3_bucket.setter
    def s3_bucket(self, value: pulumi.Input['MalwareProtectionPlanCfnProtectedResourceS3BucketPropertiesArgs']):
        pulumi.set(self, "s3_bucket", value)


if not MYPY:
    class MalwareProtectionPlanCfnTaggingArgsDict(TypedDict):
        status: NotRequired[pulumi.Input[str]]
        """
        Indicates whether or not you chose GuardDuty to add a predefined tag to the scanned S3 object.
        """
elif False:
    MalwareProtectionPlanCfnTaggingArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MalwareProtectionPlanCfnTaggingArgs:
    def __init__(__self__, *,
                 status: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] status: Indicates whether or not you chose GuardDuty to add a predefined tag to the scanned S3 object.
        """
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates whether or not you chose GuardDuty to add a predefined tag to the scanned S3 object.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


