# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetDatabaseResult',
    'AwaitableGetDatabaseResult',
    'get_database',
    'get_database_output',
]

@pulumi.output_type
class GetDatabaseResult:
    def __init__(__self__, catalog_id=None, database_input=None):
        if catalog_id and not isinstance(catalog_id, str):
            raise TypeError("Expected argument 'catalog_id' to be a str")
        pulumi.set(__self__, "catalog_id", catalog_id)
        if database_input and not isinstance(database_input, dict):
            raise TypeError("Expected argument 'database_input' to be a dict")
        pulumi.set(__self__, "database_input", database_input)

    @property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> Optional[str]:
        """
        The AWS account ID for the account in which to create the catalog object.
        """
        return pulumi.get(self, "catalog_id")

    @property
    @pulumi.getter(name="databaseInput")
    def database_input(self) -> Optional['outputs.DatabaseInput']:
        """
        The metadata for the database.
        """
        return pulumi.get(self, "database_input")


class AwaitableGetDatabaseResult(GetDatabaseResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDatabaseResult(
            catalog_id=self.catalog_id,
            database_input=self.database_input)


def get_database(database_name: Optional[str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDatabaseResult:
    """
    Resource Type definition for AWS::Glue::Database


    :param str database_name: The name of the database. For hive compatibility, this is folded to lowercase when it is store.
    """
    __args__ = dict()
    __args__['databaseName'] = database_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:glue:getDatabase', __args__, opts=opts, typ=GetDatabaseResult).value

    return AwaitableGetDatabaseResult(
        catalog_id=pulumi.get(__ret__, 'catalog_id'),
        database_input=pulumi.get(__ret__, 'database_input'))
def get_database_output(database_name: Optional[pulumi.Input[str]] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDatabaseResult]:
    """
    Resource Type definition for AWS::Glue::Database


    :param str database_name: The name of the database. For hive compatibility, this is folded to lowercase when it is store.
    """
    __args__ = dict()
    __args__['databaseName'] = database_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:glue:getDatabase', __args__, opts=opts, typ=GetDatabaseResult)
    return __ret__.apply(lambda __response__: GetDatabaseResult(
        catalog_id=pulumi.get(__response__, 'catalog_id'),
        database_input=pulumi.get(__response__, 'database_input')))
