# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'CrawlerCatalogTargetArgs',
    'CrawlerCatalogTargetArgsDict',
    'CrawlerDeltaTargetArgs',
    'CrawlerDeltaTargetArgsDict',
    'CrawlerDynamoDbTargetArgs',
    'CrawlerDynamoDbTargetArgsDict',
    'CrawlerIcebergTargetArgs',
    'CrawlerIcebergTargetArgsDict',
    'CrawlerJdbcTargetArgs',
    'CrawlerJdbcTargetArgsDict',
    'CrawlerLakeFormationConfigurationArgs',
    'CrawlerLakeFormationConfigurationArgsDict',
    'CrawlerMongoDbTargetArgs',
    'CrawlerMongoDbTargetArgsDict',
    'CrawlerRecrawlPolicyArgs',
    'CrawlerRecrawlPolicyArgsDict',
    'CrawlerS3TargetArgs',
    'CrawlerS3TargetArgsDict',
    'CrawlerScheduleArgs',
    'CrawlerScheduleArgsDict',
    'CrawlerSchemaChangePolicyArgs',
    'CrawlerSchemaChangePolicyArgsDict',
    'CrawlerTargetsArgs',
    'CrawlerTargetsArgsDict',
    'DatabaseDataLakePrincipalArgs',
    'DatabaseDataLakePrincipalArgsDict',
    'DatabaseFederatedDatabaseArgs',
    'DatabaseFederatedDatabaseArgsDict',
    'DatabaseIdentifierArgs',
    'DatabaseIdentifierArgsDict',
    'DatabaseInputArgs',
    'DatabaseInputArgsDict',
    'DatabasePrincipalPrivilegesArgs',
    'DatabasePrincipalPrivilegesArgsDict',
    'SchemaRegistryArgs',
    'SchemaRegistryArgsDict',
    'SchemaVersionSchemaArgs',
    'SchemaVersionSchemaArgsDict',
    'SchemaVersionArgs',
    'SchemaVersionArgsDict',
    'TriggerActionArgs',
    'TriggerActionArgsDict',
    'TriggerConditionArgs',
    'TriggerConditionArgsDict',
    'TriggerEventBatchingConditionArgs',
    'TriggerEventBatchingConditionArgsDict',
    'TriggerNotificationPropertyArgs',
    'TriggerNotificationPropertyArgsDict',
    'TriggerPredicateArgs',
    'TriggerPredicateArgsDict',
]

MYPY = False

if not MYPY:
    class CrawlerCatalogTargetArgsDict(TypedDict):
        """
        Specifies an AWS Glue Data Catalog target.
        """
        connection_name: NotRequired[pulumi.Input[str]]
        """
        The name of the connection for an Amazon S3-backed Data Catalog table to be a target of the crawl when using a Catalog connection type paired with a NETWORK Connection type.
        """
        database_name: NotRequired[pulumi.Input[str]]
        """
        The name of the database to be synchronized.
        """
        dlq_event_queue_arn: NotRequired[pulumi.Input[str]]
        """
        A valid Amazon dead-letter SQS ARN. For example, arn:aws:sqs:region:account:deadLetterQueue.
        """
        event_queue_arn: NotRequired[pulumi.Input[str]]
        """
        A valid Amazon SQS ARN. For example, arn:aws:sqs:region:account:sqs.
        """
        tables: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        A list of the tables to be synchronized.
        """
elif False:
    CrawlerCatalogTargetArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CrawlerCatalogTargetArgs:
    def __init__(__self__, *,
                 connection_name: Optional[pulumi.Input[str]] = None,
                 database_name: Optional[pulumi.Input[str]] = None,
                 dlq_event_queue_arn: Optional[pulumi.Input[str]] = None,
                 event_queue_arn: Optional[pulumi.Input[str]] = None,
                 tables: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Specifies an AWS Glue Data Catalog target.
        :param pulumi.Input[str] connection_name: The name of the connection for an Amazon S3-backed Data Catalog table to be a target of the crawl when using a Catalog connection type paired with a NETWORK Connection type.
        :param pulumi.Input[str] database_name: The name of the database to be synchronized.
        :param pulumi.Input[str] dlq_event_queue_arn: A valid Amazon dead-letter SQS ARN. For example, arn:aws:sqs:region:account:deadLetterQueue.
        :param pulumi.Input[str] event_queue_arn: A valid Amazon SQS ARN. For example, arn:aws:sqs:region:account:sqs.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tables: A list of the tables to be synchronized.
        """
        if connection_name is not None:
            pulumi.set(__self__, "connection_name", connection_name)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if dlq_event_queue_arn is not None:
            pulumi.set(__self__, "dlq_event_queue_arn", dlq_event_queue_arn)
        if event_queue_arn is not None:
            pulumi.set(__self__, "event_queue_arn", event_queue_arn)
        if tables is not None:
            pulumi.set(__self__, "tables", tables)

    @property
    @pulumi.getter(name="connectionName")
    def connection_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the connection for an Amazon S3-backed Data Catalog table to be a target of the crawl when using a Catalog connection type paired with a NETWORK Connection type.
        """
        return pulumi.get(self, "connection_name")

    @connection_name.setter
    def connection_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connection_name", value)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the database to be synchronized.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_name", value)

    @property
    @pulumi.getter(name="dlqEventQueueArn")
    def dlq_event_queue_arn(self) -> Optional[pulumi.Input[str]]:
        """
        A valid Amazon dead-letter SQS ARN. For example, arn:aws:sqs:region:account:deadLetterQueue.
        """
        return pulumi.get(self, "dlq_event_queue_arn")

    @dlq_event_queue_arn.setter
    def dlq_event_queue_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dlq_event_queue_arn", value)

    @property
    @pulumi.getter(name="eventQueueArn")
    def event_queue_arn(self) -> Optional[pulumi.Input[str]]:
        """
        A valid Amazon SQS ARN. For example, arn:aws:sqs:region:account:sqs.
        """
        return pulumi.get(self, "event_queue_arn")

    @event_queue_arn.setter
    def event_queue_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "event_queue_arn", value)

    @property
    @pulumi.getter
    def tables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of the tables to be synchronized.
        """
        return pulumi.get(self, "tables")

    @tables.setter
    def tables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tables", value)


if not MYPY:
    class CrawlerDeltaTargetArgsDict(TypedDict):
        """
        Specifies a Delta data store to crawl one or more Delta tables.
        """
        connection_name: NotRequired[pulumi.Input[str]]
        """
        The name of the connection to use to connect to the Delta table target.
        """
        create_native_delta_table: NotRequired[pulumi.Input[bool]]
        """
        Specifies whether the crawler will create native tables, to allow integration with query engines that support querying of the Delta transaction log directly.
        """
        delta_tables: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        A list of the Amazon S3 paths to the Delta tables.
        """
        write_manifest: NotRequired[pulumi.Input[bool]]
        """
        Specifies whether to write the manifest files to the Delta table path.
        """
elif False:
    CrawlerDeltaTargetArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CrawlerDeltaTargetArgs:
    def __init__(__self__, *,
                 connection_name: Optional[pulumi.Input[str]] = None,
                 create_native_delta_table: Optional[pulumi.Input[bool]] = None,
                 delta_tables: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 write_manifest: Optional[pulumi.Input[bool]] = None):
        """
        Specifies a Delta data store to crawl one or more Delta tables.
        :param pulumi.Input[str] connection_name: The name of the connection to use to connect to the Delta table target.
        :param pulumi.Input[bool] create_native_delta_table: Specifies whether the crawler will create native tables, to allow integration with query engines that support querying of the Delta transaction log directly.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] delta_tables: A list of the Amazon S3 paths to the Delta tables.
        :param pulumi.Input[bool] write_manifest: Specifies whether to write the manifest files to the Delta table path.
        """
        if connection_name is not None:
            pulumi.set(__self__, "connection_name", connection_name)
        if create_native_delta_table is not None:
            pulumi.set(__self__, "create_native_delta_table", create_native_delta_table)
        if delta_tables is not None:
            pulumi.set(__self__, "delta_tables", delta_tables)
        if write_manifest is not None:
            pulumi.set(__self__, "write_manifest", write_manifest)

    @property
    @pulumi.getter(name="connectionName")
    def connection_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the connection to use to connect to the Delta table target.
        """
        return pulumi.get(self, "connection_name")

    @connection_name.setter
    def connection_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connection_name", value)

    @property
    @pulumi.getter(name="createNativeDeltaTable")
    def create_native_delta_table(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the crawler will create native tables, to allow integration with query engines that support querying of the Delta transaction log directly.
        """
        return pulumi.get(self, "create_native_delta_table")

    @create_native_delta_table.setter
    def create_native_delta_table(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "create_native_delta_table", value)

    @property
    @pulumi.getter(name="deltaTables")
    def delta_tables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of the Amazon S3 paths to the Delta tables.
        """
        return pulumi.get(self, "delta_tables")

    @delta_tables.setter
    def delta_tables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "delta_tables", value)

    @property
    @pulumi.getter(name="writeManifest")
    def write_manifest(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to write the manifest files to the Delta table path.
        """
        return pulumi.get(self, "write_manifest")

    @write_manifest.setter
    def write_manifest(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "write_manifest", value)


if not MYPY:
    class CrawlerDynamoDbTargetArgsDict(TypedDict):
        """
        Specifies an Amazon DynamoDB table to crawl.
        """
        path: NotRequired[pulumi.Input[str]]
        """
        The name of the DynamoDB table to crawl.
        """
elif False:
    CrawlerDynamoDbTargetArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CrawlerDynamoDbTargetArgs:
    def __init__(__self__, *,
                 path: Optional[pulumi.Input[str]] = None):
        """
        Specifies an Amazon DynamoDB table to crawl.
        :param pulumi.Input[str] path: The name of the DynamoDB table to crawl.
        """
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the DynamoDB table to crawl.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)


if not MYPY:
    class CrawlerIcebergTargetArgsDict(TypedDict):
        """
        Specifies Apache Iceberg data store targets.
        """
        connection_name: NotRequired[pulumi.Input[str]]
        """
        The name of the connection to use to connect to the Iceberg target.
        """
        exclusions: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        A list of global patterns used to exclude from the crawl.
        """
        maximum_traversal_depth: NotRequired[pulumi.Input[int]]
        """
        The maximum depth of Amazon S3 paths that the crawler can traverse to discover the Iceberg metadata folder in your Amazon S3 path. Used to limit the crawler run time.
        """
        paths: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        One or more Amazon S3 paths that contains Iceberg metadata folders as s3://bucket/prefix .
        """
elif False:
    CrawlerIcebergTargetArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CrawlerIcebergTargetArgs:
    def __init__(__self__, *,
                 connection_name: Optional[pulumi.Input[str]] = None,
                 exclusions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 maximum_traversal_depth: Optional[pulumi.Input[int]] = None,
                 paths: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Specifies Apache Iceberg data store targets.
        :param pulumi.Input[str] connection_name: The name of the connection to use to connect to the Iceberg target.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] exclusions: A list of global patterns used to exclude from the crawl.
        :param pulumi.Input[int] maximum_traversal_depth: The maximum depth of Amazon S3 paths that the crawler can traverse to discover the Iceberg metadata folder in your Amazon S3 path. Used to limit the crawler run time.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] paths: One or more Amazon S3 paths that contains Iceberg metadata folders as s3://bucket/prefix .
        """
        if connection_name is not None:
            pulumi.set(__self__, "connection_name", connection_name)
        if exclusions is not None:
            pulumi.set(__self__, "exclusions", exclusions)
        if maximum_traversal_depth is not None:
            pulumi.set(__self__, "maximum_traversal_depth", maximum_traversal_depth)
        if paths is not None:
            pulumi.set(__self__, "paths", paths)

    @property
    @pulumi.getter(name="connectionName")
    def connection_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the connection to use to connect to the Iceberg target.
        """
        return pulumi.get(self, "connection_name")

    @connection_name.setter
    def connection_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connection_name", value)

    @property
    @pulumi.getter
    def exclusions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of global patterns used to exclude from the crawl.
        """
        return pulumi.get(self, "exclusions")

    @exclusions.setter
    def exclusions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "exclusions", value)

    @property
    @pulumi.getter(name="maximumTraversalDepth")
    def maximum_traversal_depth(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum depth of Amazon S3 paths that the crawler can traverse to discover the Iceberg metadata folder in your Amazon S3 path. Used to limit the crawler run time.
        """
        return pulumi.get(self, "maximum_traversal_depth")

    @maximum_traversal_depth.setter
    def maximum_traversal_depth(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "maximum_traversal_depth", value)

    @property
    @pulumi.getter
    def paths(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        One or more Amazon S3 paths that contains Iceberg metadata folders as s3://bucket/prefix .
        """
        return pulumi.get(self, "paths")

    @paths.setter
    def paths(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "paths", value)


if not MYPY:
    class CrawlerJdbcTargetArgsDict(TypedDict):
        """
        Specifies a JDBC data store to crawl.
        """
        connection_name: NotRequired[pulumi.Input[str]]
        """
        The name of the connection to use to connect to the JDBC target.
        """
        enable_additional_metadata: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        Specify a value of RAWTYPES or COMMENTS to enable additional metadata in table responses. RAWTYPES provides the native-level datatype. COMMENTS provides comments associated with a column or table in the database.

        If you do not need additional metadata, keep the field empty.
        """
        exclusions: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        A list of glob patterns used to exclude from the crawl. For more information, see Catalog Tables with a Crawler.
        """
        path: NotRequired[pulumi.Input[str]]
        """
        The path of the JDBC target.
        """
elif False:
    CrawlerJdbcTargetArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CrawlerJdbcTargetArgs:
    def __init__(__self__, *,
                 connection_name: Optional[pulumi.Input[str]] = None,
                 enable_additional_metadata: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 exclusions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 path: Optional[pulumi.Input[str]] = None):
        """
        Specifies a JDBC data store to crawl.
        :param pulumi.Input[str] connection_name: The name of the connection to use to connect to the JDBC target.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] enable_additional_metadata: Specify a value of RAWTYPES or COMMENTS to enable additional metadata in table responses. RAWTYPES provides the native-level datatype. COMMENTS provides comments associated with a column or table in the database.
               
               If you do not need additional metadata, keep the field empty.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] exclusions: A list of glob patterns used to exclude from the crawl. For more information, see Catalog Tables with a Crawler.
        :param pulumi.Input[str] path: The path of the JDBC target.
        """
        if connection_name is not None:
            pulumi.set(__self__, "connection_name", connection_name)
        if enable_additional_metadata is not None:
            pulumi.set(__self__, "enable_additional_metadata", enable_additional_metadata)
        if exclusions is not None:
            pulumi.set(__self__, "exclusions", exclusions)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter(name="connectionName")
    def connection_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the connection to use to connect to the JDBC target.
        """
        return pulumi.get(self, "connection_name")

    @connection_name.setter
    def connection_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connection_name", value)

    @property
    @pulumi.getter(name="enableAdditionalMetadata")
    def enable_additional_metadata(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specify a value of RAWTYPES or COMMENTS to enable additional metadata in table responses. RAWTYPES provides the native-level datatype. COMMENTS provides comments associated with a column or table in the database.

        If you do not need additional metadata, keep the field empty.
        """
        return pulumi.get(self, "enable_additional_metadata")

    @enable_additional_metadata.setter
    def enable_additional_metadata(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "enable_additional_metadata", value)

    @property
    @pulumi.getter
    def exclusions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of glob patterns used to exclude from the crawl. For more information, see Catalog Tables with a Crawler.
        """
        return pulumi.get(self, "exclusions")

    @exclusions.setter
    def exclusions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "exclusions", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        The path of the JDBC target.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)


if not MYPY:
    class CrawlerLakeFormationConfigurationArgsDict(TypedDict):
        """
        Specifies AWS Lake Formation configuration settings for the crawler
        """
        account_id: NotRequired[pulumi.Input[str]]
        """
        Required for cross account crawls. For same account crawls as the target data, this can be left as null.
        """
        use_lake_formation_credentials: NotRequired[pulumi.Input[bool]]
        """
        Specifies whether to use AWS Lake Formation credentials for the crawler instead of the IAM role credentials.
        """
elif False:
    CrawlerLakeFormationConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CrawlerLakeFormationConfigurationArgs:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[str]] = None,
                 use_lake_formation_credentials: Optional[pulumi.Input[bool]] = None):
        """
        Specifies AWS Lake Formation configuration settings for the crawler
        :param pulumi.Input[str] account_id: Required for cross account crawls. For same account crawls as the target data, this can be left as null.
        :param pulumi.Input[bool] use_lake_formation_credentials: Specifies whether to use AWS Lake Formation credentials for the crawler instead of the IAM role credentials.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if use_lake_formation_credentials is not None:
            pulumi.set(__self__, "use_lake_formation_credentials", use_lake_formation_credentials)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[str]]:
        """
        Required for cross account crawls. For same account crawls as the target data, this can be left as null.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="useLakeFormationCredentials")
    def use_lake_formation_credentials(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to use AWS Lake Formation credentials for the crawler instead of the IAM role credentials.
        """
        return pulumi.get(self, "use_lake_formation_credentials")

    @use_lake_formation_credentials.setter
    def use_lake_formation_credentials(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_lake_formation_credentials", value)


if not MYPY:
    class CrawlerMongoDbTargetArgsDict(TypedDict):
        """
        Specifies an Amazon DocumentDB or MongoDB data store to crawl.
        """
        connection_name: NotRequired[pulumi.Input[str]]
        """
        The name of the connection to use to connect to the Amazon DocumentDB or MongoDB target.
        """
        path: NotRequired[pulumi.Input[str]]
        """
        The path of the Amazon DocumentDB or MongoDB target (database/collection).
        """
elif False:
    CrawlerMongoDbTargetArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CrawlerMongoDbTargetArgs:
    def __init__(__self__, *,
                 connection_name: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None):
        """
        Specifies an Amazon DocumentDB or MongoDB data store to crawl.
        :param pulumi.Input[str] connection_name: The name of the connection to use to connect to the Amazon DocumentDB or MongoDB target.
        :param pulumi.Input[str] path: The path of the Amazon DocumentDB or MongoDB target (database/collection).
        """
        if connection_name is not None:
            pulumi.set(__self__, "connection_name", connection_name)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter(name="connectionName")
    def connection_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the connection to use to connect to the Amazon DocumentDB or MongoDB target.
        """
        return pulumi.get(self, "connection_name")

    @connection_name.setter
    def connection_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connection_name", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        The path of the Amazon DocumentDB or MongoDB target (database/collection).
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)


if not MYPY:
    class CrawlerRecrawlPolicyArgsDict(TypedDict):
        """
        When crawling an Amazon S3 data source after the first crawl is complete, specifies whether to crawl the entire dataset again or to crawl only folders that were added since the last crawler run. For more information, see Incremental Crawls in AWS Glue in the developer guide.
        """
        recrawl_behavior: NotRequired[pulumi.Input[str]]
        """
        Specifies whether to crawl the entire dataset again or to crawl only folders that were added since the last crawler run. A value of CRAWL_EVERYTHING specifies crawling the entire dataset again. A value of CRAWL_NEW_FOLDERS_ONLY specifies crawling only folders that were added since the last crawler run. A value of CRAWL_EVENT_MODE specifies crawling only the changes identified by Amazon S3 events.
        """
elif False:
    CrawlerRecrawlPolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CrawlerRecrawlPolicyArgs:
    def __init__(__self__, *,
                 recrawl_behavior: Optional[pulumi.Input[str]] = None):
        """
        When crawling an Amazon S3 data source after the first crawl is complete, specifies whether to crawl the entire dataset again or to crawl only folders that were added since the last crawler run. For more information, see Incremental Crawls in AWS Glue in the developer guide.
        :param pulumi.Input[str] recrawl_behavior: Specifies whether to crawl the entire dataset again or to crawl only folders that were added since the last crawler run. A value of CRAWL_EVERYTHING specifies crawling the entire dataset again. A value of CRAWL_NEW_FOLDERS_ONLY specifies crawling only folders that were added since the last crawler run. A value of CRAWL_EVENT_MODE specifies crawling only the changes identified by Amazon S3 events.
        """
        if recrawl_behavior is not None:
            pulumi.set(__self__, "recrawl_behavior", recrawl_behavior)

    @property
    @pulumi.getter(name="recrawlBehavior")
    def recrawl_behavior(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether to crawl the entire dataset again or to crawl only folders that were added since the last crawler run. A value of CRAWL_EVERYTHING specifies crawling the entire dataset again. A value of CRAWL_NEW_FOLDERS_ONLY specifies crawling only folders that were added since the last crawler run. A value of CRAWL_EVENT_MODE specifies crawling only the changes identified by Amazon S3 events.
        """
        return pulumi.get(self, "recrawl_behavior")

    @recrawl_behavior.setter
    def recrawl_behavior(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "recrawl_behavior", value)


if not MYPY:
    class CrawlerS3TargetArgsDict(TypedDict):
        """
        Specifies a data store in Amazon Simple Storage Service (Amazon S3).
        """
        connection_name: NotRequired[pulumi.Input[str]]
        """
        The name of a connection which allows a job or crawler to access data in Amazon S3 within an Amazon Virtual Private Cloud environment (Amazon VPC).
        """
        dlq_event_queue_arn: NotRequired[pulumi.Input[str]]
        """
        A valid Amazon dead-letter SQS ARN. For example, arn:aws:sqs:region:account:deadLetterQueue.
        """
        event_queue_arn: NotRequired[pulumi.Input[str]]
        """
        A valid Amazon SQS ARN. For example, arn:aws:sqs:region:account:sqs.
        """
        exclusions: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        A list of glob patterns used to exclude from the crawl.
        """
        path: NotRequired[pulumi.Input[str]]
        """
        The path to the Amazon S3 target.
        """
        sample_size: NotRequired[pulumi.Input[int]]
        """
        Sets the number of files in each leaf folder to be crawled when crawling sample files in a dataset. If not set, all the files are crawled. A valid value is an integer between 1 and 249.
        """
elif False:
    CrawlerS3TargetArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CrawlerS3TargetArgs:
    def __init__(__self__, *,
                 connection_name: Optional[pulumi.Input[str]] = None,
                 dlq_event_queue_arn: Optional[pulumi.Input[str]] = None,
                 event_queue_arn: Optional[pulumi.Input[str]] = None,
                 exclusions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 sample_size: Optional[pulumi.Input[int]] = None):
        """
        Specifies a data store in Amazon Simple Storage Service (Amazon S3).
        :param pulumi.Input[str] connection_name: The name of a connection which allows a job or crawler to access data in Amazon S3 within an Amazon Virtual Private Cloud environment (Amazon VPC).
        :param pulumi.Input[str] dlq_event_queue_arn: A valid Amazon dead-letter SQS ARN. For example, arn:aws:sqs:region:account:deadLetterQueue.
        :param pulumi.Input[str] event_queue_arn: A valid Amazon SQS ARN. For example, arn:aws:sqs:region:account:sqs.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] exclusions: A list of glob patterns used to exclude from the crawl.
        :param pulumi.Input[str] path: The path to the Amazon S3 target.
        :param pulumi.Input[int] sample_size: Sets the number of files in each leaf folder to be crawled when crawling sample files in a dataset. If not set, all the files are crawled. A valid value is an integer between 1 and 249.
        """
        if connection_name is not None:
            pulumi.set(__self__, "connection_name", connection_name)
        if dlq_event_queue_arn is not None:
            pulumi.set(__self__, "dlq_event_queue_arn", dlq_event_queue_arn)
        if event_queue_arn is not None:
            pulumi.set(__self__, "event_queue_arn", event_queue_arn)
        if exclusions is not None:
            pulumi.set(__self__, "exclusions", exclusions)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if sample_size is not None:
            pulumi.set(__self__, "sample_size", sample_size)

    @property
    @pulumi.getter(name="connectionName")
    def connection_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of a connection which allows a job or crawler to access data in Amazon S3 within an Amazon Virtual Private Cloud environment (Amazon VPC).
        """
        return pulumi.get(self, "connection_name")

    @connection_name.setter
    def connection_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connection_name", value)

    @property
    @pulumi.getter(name="dlqEventQueueArn")
    def dlq_event_queue_arn(self) -> Optional[pulumi.Input[str]]:
        """
        A valid Amazon dead-letter SQS ARN. For example, arn:aws:sqs:region:account:deadLetterQueue.
        """
        return pulumi.get(self, "dlq_event_queue_arn")

    @dlq_event_queue_arn.setter
    def dlq_event_queue_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dlq_event_queue_arn", value)

    @property
    @pulumi.getter(name="eventQueueArn")
    def event_queue_arn(self) -> Optional[pulumi.Input[str]]:
        """
        A valid Amazon SQS ARN. For example, arn:aws:sqs:region:account:sqs.
        """
        return pulumi.get(self, "event_queue_arn")

    @event_queue_arn.setter
    def event_queue_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "event_queue_arn", value)

    @property
    @pulumi.getter
    def exclusions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of glob patterns used to exclude from the crawl.
        """
        return pulumi.get(self, "exclusions")

    @exclusions.setter
    def exclusions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "exclusions", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        The path to the Amazon S3 target.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="sampleSize")
    def sample_size(self) -> Optional[pulumi.Input[int]]:
        """
        Sets the number of files in each leaf folder to be crawled when crawling sample files in a dataset. If not set, all the files are crawled. A valid value is an integer between 1 and 249.
        """
        return pulumi.get(self, "sample_size")

    @sample_size.setter
    def sample_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "sample_size", value)


if not MYPY:
    class CrawlerScheduleArgsDict(TypedDict):
        """
        A scheduling object using a cron statement to schedule an event.
        """
        schedule_expression: NotRequired[pulumi.Input[str]]
        """
        A cron expression used to specify the schedule. For more information, see Time-Based Schedules for Jobs and Crawlers. For example, to run something every day at 12:15 UTC, specify cron(15 12 * * ? *).
        """
elif False:
    CrawlerScheduleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CrawlerScheduleArgs:
    def __init__(__self__, *,
                 schedule_expression: Optional[pulumi.Input[str]] = None):
        """
        A scheduling object using a cron statement to schedule an event.
        :param pulumi.Input[str] schedule_expression: A cron expression used to specify the schedule. For more information, see Time-Based Schedules for Jobs and Crawlers. For example, to run something every day at 12:15 UTC, specify cron(15 12 * * ? *).
        """
        if schedule_expression is not None:
            pulumi.set(__self__, "schedule_expression", schedule_expression)

    @property
    @pulumi.getter(name="scheduleExpression")
    def schedule_expression(self) -> Optional[pulumi.Input[str]]:
        """
        A cron expression used to specify the schedule. For more information, see Time-Based Schedules for Jobs and Crawlers. For example, to run something every day at 12:15 UTC, specify cron(15 12 * * ? *).
        """
        return pulumi.get(self, "schedule_expression")

    @schedule_expression.setter
    def schedule_expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "schedule_expression", value)


if not MYPY:
    class CrawlerSchemaChangePolicyArgsDict(TypedDict):
        """
        The policy that specifies update and delete behaviors for the crawler. The policy tells the crawler what to do in the event that it detects a change in a table that already exists in the customer's database at the time of the crawl. The SchemaChangePolicy does not affect whether or how new tables and partitions are added. New tables and partitions are always created regardless of the SchemaChangePolicy on a crawler. The SchemaChangePolicy consists of two components, UpdateBehavior and DeleteBehavior.
        """
        delete_behavior: NotRequired[pulumi.Input[str]]
        """
        The deletion behavior when the crawler finds a deleted object. A value of LOG specifies that if a table or partition is found to no longer exist, do not delete it, only log that it was found to no longer exist. A value of DELETE_FROM_DATABASE specifies that if a table or partition is found to have been removed, delete it from the database. A value of DEPRECATE_IN_DATABASE specifies that if a table has been found to no longer exist, to add a property to the table that says 'DEPRECATED' and includes a timestamp with the time of deprecation.
        """
        update_behavior: NotRequired[pulumi.Input[str]]
        """
        The update behavior when the crawler finds a changed schema. A value of LOG specifies that if a table or a partition already exists, and a change is detected, do not update it, only log that a change was detected. Add new tables and new partitions (including on existing tables). A value of UPDATE_IN_DATABASE specifies that if a table or partition already exists, and a change is detected, update it. Add new tables and partitions.
        """
elif False:
    CrawlerSchemaChangePolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CrawlerSchemaChangePolicyArgs:
    def __init__(__self__, *,
                 delete_behavior: Optional[pulumi.Input[str]] = None,
                 update_behavior: Optional[pulumi.Input[str]] = None):
        """
        The policy that specifies update and delete behaviors for the crawler. The policy tells the crawler what to do in the event that it detects a change in a table that already exists in the customer's database at the time of the crawl. The SchemaChangePolicy does not affect whether or how new tables and partitions are added. New tables and partitions are always created regardless of the SchemaChangePolicy on a crawler. The SchemaChangePolicy consists of two components, UpdateBehavior and DeleteBehavior.
        :param pulumi.Input[str] delete_behavior: The deletion behavior when the crawler finds a deleted object. A value of LOG specifies that if a table or partition is found to no longer exist, do not delete it, only log that it was found to no longer exist. A value of DELETE_FROM_DATABASE specifies that if a table or partition is found to have been removed, delete it from the database. A value of DEPRECATE_IN_DATABASE specifies that if a table has been found to no longer exist, to add a property to the table that says 'DEPRECATED' and includes a timestamp with the time of deprecation.
        :param pulumi.Input[str] update_behavior: The update behavior when the crawler finds a changed schema. A value of LOG specifies that if a table or a partition already exists, and a change is detected, do not update it, only log that a change was detected. Add new tables and new partitions (including on existing tables). A value of UPDATE_IN_DATABASE specifies that if a table or partition already exists, and a change is detected, update it. Add new tables and partitions.
        """
        if delete_behavior is not None:
            pulumi.set(__self__, "delete_behavior", delete_behavior)
        if update_behavior is not None:
            pulumi.set(__self__, "update_behavior", update_behavior)

    @property
    @pulumi.getter(name="deleteBehavior")
    def delete_behavior(self) -> Optional[pulumi.Input[str]]:
        """
        The deletion behavior when the crawler finds a deleted object. A value of LOG specifies that if a table or partition is found to no longer exist, do not delete it, only log that it was found to no longer exist. A value of DELETE_FROM_DATABASE specifies that if a table or partition is found to have been removed, delete it from the database. A value of DEPRECATE_IN_DATABASE specifies that if a table has been found to no longer exist, to add a property to the table that says 'DEPRECATED' and includes a timestamp with the time of deprecation.
        """
        return pulumi.get(self, "delete_behavior")

    @delete_behavior.setter
    def delete_behavior(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "delete_behavior", value)

    @property
    @pulumi.getter(name="updateBehavior")
    def update_behavior(self) -> Optional[pulumi.Input[str]]:
        """
        The update behavior when the crawler finds a changed schema. A value of LOG specifies that if a table or a partition already exists, and a change is detected, do not update it, only log that a change was detected. Add new tables and new partitions (including on existing tables). A value of UPDATE_IN_DATABASE specifies that if a table or partition already exists, and a change is detected, update it. Add new tables and partitions.
        """
        return pulumi.get(self, "update_behavior")

    @update_behavior.setter
    def update_behavior(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "update_behavior", value)


if not MYPY:
    class CrawlerTargetsArgsDict(TypedDict):
        """
        Specifies data stores to crawl.
        """
        catalog_targets: NotRequired[pulumi.Input[Sequence[pulumi.Input['CrawlerCatalogTargetArgsDict']]]]
        """
        Specifies AWS Glue Data Catalog targets.
        """
        delta_targets: NotRequired[pulumi.Input[Sequence[pulumi.Input['CrawlerDeltaTargetArgsDict']]]]
        """
        Specifies an array of Delta data store targets.
        """
        dynamo_db_targets: NotRequired[pulumi.Input[Sequence[pulumi.Input['CrawlerDynamoDbTargetArgsDict']]]]
        """
        Specifies Amazon DynamoDB targets.
        """
        iceberg_targets: NotRequired[pulumi.Input[Sequence[pulumi.Input['CrawlerIcebergTargetArgsDict']]]]
        """
        Specifies Apache Iceberg data store targets.
        """
        jdbc_targets: NotRequired[pulumi.Input[Sequence[pulumi.Input['CrawlerJdbcTargetArgsDict']]]]
        """
        Specifies JDBC targets.
        """
        mongo_db_targets: NotRequired[pulumi.Input[Sequence[pulumi.Input['CrawlerMongoDbTargetArgsDict']]]]
        """
        A list of Mongo DB targets.
        """
        s3_targets: NotRequired[pulumi.Input[Sequence[pulumi.Input['CrawlerS3TargetArgsDict']]]]
        """
        Specifies Amazon Simple Storage Service (Amazon S3) targets.
        """
elif False:
    CrawlerTargetsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CrawlerTargetsArgs:
    def __init__(__self__, *,
                 catalog_targets: Optional[pulumi.Input[Sequence[pulumi.Input['CrawlerCatalogTargetArgs']]]] = None,
                 delta_targets: Optional[pulumi.Input[Sequence[pulumi.Input['CrawlerDeltaTargetArgs']]]] = None,
                 dynamo_db_targets: Optional[pulumi.Input[Sequence[pulumi.Input['CrawlerDynamoDbTargetArgs']]]] = None,
                 iceberg_targets: Optional[pulumi.Input[Sequence[pulumi.Input['CrawlerIcebergTargetArgs']]]] = None,
                 jdbc_targets: Optional[pulumi.Input[Sequence[pulumi.Input['CrawlerJdbcTargetArgs']]]] = None,
                 mongo_db_targets: Optional[pulumi.Input[Sequence[pulumi.Input['CrawlerMongoDbTargetArgs']]]] = None,
                 s3_targets: Optional[pulumi.Input[Sequence[pulumi.Input['CrawlerS3TargetArgs']]]] = None):
        """
        Specifies data stores to crawl.
        :param pulumi.Input[Sequence[pulumi.Input['CrawlerCatalogTargetArgs']]] catalog_targets: Specifies AWS Glue Data Catalog targets.
        :param pulumi.Input[Sequence[pulumi.Input['CrawlerDeltaTargetArgs']]] delta_targets: Specifies an array of Delta data store targets.
        :param pulumi.Input[Sequence[pulumi.Input['CrawlerDynamoDbTargetArgs']]] dynamo_db_targets: Specifies Amazon DynamoDB targets.
        :param pulumi.Input[Sequence[pulumi.Input['CrawlerIcebergTargetArgs']]] iceberg_targets: Specifies Apache Iceberg data store targets.
        :param pulumi.Input[Sequence[pulumi.Input['CrawlerJdbcTargetArgs']]] jdbc_targets: Specifies JDBC targets.
        :param pulumi.Input[Sequence[pulumi.Input['CrawlerMongoDbTargetArgs']]] mongo_db_targets: A list of Mongo DB targets.
        :param pulumi.Input[Sequence[pulumi.Input['CrawlerS3TargetArgs']]] s3_targets: Specifies Amazon Simple Storage Service (Amazon S3) targets.
        """
        if catalog_targets is not None:
            pulumi.set(__self__, "catalog_targets", catalog_targets)
        if delta_targets is not None:
            pulumi.set(__self__, "delta_targets", delta_targets)
        if dynamo_db_targets is not None:
            pulumi.set(__self__, "dynamo_db_targets", dynamo_db_targets)
        if iceberg_targets is not None:
            pulumi.set(__self__, "iceberg_targets", iceberg_targets)
        if jdbc_targets is not None:
            pulumi.set(__self__, "jdbc_targets", jdbc_targets)
        if mongo_db_targets is not None:
            pulumi.set(__self__, "mongo_db_targets", mongo_db_targets)
        if s3_targets is not None:
            pulumi.set(__self__, "s3_targets", s3_targets)

    @property
    @pulumi.getter(name="catalogTargets")
    def catalog_targets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CrawlerCatalogTargetArgs']]]]:
        """
        Specifies AWS Glue Data Catalog targets.
        """
        return pulumi.get(self, "catalog_targets")

    @catalog_targets.setter
    def catalog_targets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CrawlerCatalogTargetArgs']]]]):
        pulumi.set(self, "catalog_targets", value)

    @property
    @pulumi.getter(name="deltaTargets")
    def delta_targets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CrawlerDeltaTargetArgs']]]]:
        """
        Specifies an array of Delta data store targets.
        """
        return pulumi.get(self, "delta_targets")

    @delta_targets.setter
    def delta_targets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CrawlerDeltaTargetArgs']]]]):
        pulumi.set(self, "delta_targets", value)

    @property
    @pulumi.getter(name="dynamoDbTargets")
    def dynamo_db_targets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CrawlerDynamoDbTargetArgs']]]]:
        """
        Specifies Amazon DynamoDB targets.
        """
        return pulumi.get(self, "dynamo_db_targets")

    @dynamo_db_targets.setter
    def dynamo_db_targets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CrawlerDynamoDbTargetArgs']]]]):
        pulumi.set(self, "dynamo_db_targets", value)

    @property
    @pulumi.getter(name="icebergTargets")
    def iceberg_targets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CrawlerIcebergTargetArgs']]]]:
        """
        Specifies Apache Iceberg data store targets.
        """
        return pulumi.get(self, "iceberg_targets")

    @iceberg_targets.setter
    def iceberg_targets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CrawlerIcebergTargetArgs']]]]):
        pulumi.set(self, "iceberg_targets", value)

    @property
    @pulumi.getter(name="jdbcTargets")
    def jdbc_targets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CrawlerJdbcTargetArgs']]]]:
        """
        Specifies JDBC targets.
        """
        return pulumi.get(self, "jdbc_targets")

    @jdbc_targets.setter
    def jdbc_targets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CrawlerJdbcTargetArgs']]]]):
        pulumi.set(self, "jdbc_targets", value)

    @property
    @pulumi.getter(name="mongoDbTargets")
    def mongo_db_targets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CrawlerMongoDbTargetArgs']]]]:
        """
        A list of Mongo DB targets.
        """
        return pulumi.get(self, "mongo_db_targets")

    @mongo_db_targets.setter
    def mongo_db_targets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CrawlerMongoDbTargetArgs']]]]):
        pulumi.set(self, "mongo_db_targets", value)

    @property
    @pulumi.getter(name="s3Targets")
    def s3_targets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CrawlerS3TargetArgs']]]]:
        """
        Specifies Amazon Simple Storage Service (Amazon S3) targets.
        """
        return pulumi.get(self, "s3_targets")

    @s3_targets.setter
    def s3_targets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CrawlerS3TargetArgs']]]]):
        pulumi.set(self, "s3_targets", value)


if not MYPY:
    class DatabaseDataLakePrincipalArgsDict(TypedDict):
        """
        The AWS Lake Formation principal.
        """
        data_lake_principal_identifier: NotRequired[pulumi.Input[str]]
        """
        An identifier for the AWS Lake Formation principal.
        """
elif False:
    DatabaseDataLakePrincipalArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatabaseDataLakePrincipalArgs:
    def __init__(__self__, *,
                 data_lake_principal_identifier: Optional[pulumi.Input[str]] = None):
        """
        The AWS Lake Formation principal.
        :param pulumi.Input[str] data_lake_principal_identifier: An identifier for the AWS Lake Formation principal.
        """
        if data_lake_principal_identifier is not None:
            pulumi.set(__self__, "data_lake_principal_identifier", data_lake_principal_identifier)

    @property
    @pulumi.getter(name="dataLakePrincipalIdentifier")
    def data_lake_principal_identifier(self) -> Optional[pulumi.Input[str]]:
        """
        An identifier for the AWS Lake Formation principal.
        """
        return pulumi.get(self, "data_lake_principal_identifier")

    @data_lake_principal_identifier.setter
    def data_lake_principal_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_lake_principal_identifier", value)


if not MYPY:
    class DatabaseFederatedDatabaseArgsDict(TypedDict):
        """
        A FederatedDatabase structure that references an entity outside the AWS Glue Data Catalog.
        """
        connection_name: NotRequired[pulumi.Input[str]]
        """
        The name of the connection to the external metastore.
        """
        identifier: NotRequired[pulumi.Input[str]]
        """
        A unique identifier for the federated database.
        """
elif False:
    DatabaseFederatedDatabaseArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatabaseFederatedDatabaseArgs:
    def __init__(__self__, *,
                 connection_name: Optional[pulumi.Input[str]] = None,
                 identifier: Optional[pulumi.Input[str]] = None):
        """
        A FederatedDatabase structure that references an entity outside the AWS Glue Data Catalog.
        :param pulumi.Input[str] connection_name: The name of the connection to the external metastore.
        :param pulumi.Input[str] identifier: A unique identifier for the federated database.
        """
        if connection_name is not None:
            pulumi.set(__self__, "connection_name", connection_name)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)

    @property
    @pulumi.getter(name="connectionName")
    def connection_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the connection to the external metastore.
        """
        return pulumi.get(self, "connection_name")

    @connection_name.setter
    def connection_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connection_name", value)

    @property
    @pulumi.getter
    def identifier(self) -> Optional[pulumi.Input[str]]:
        """
        A unique identifier for the federated database.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "identifier", value)


if not MYPY:
    class DatabaseIdentifierArgsDict(TypedDict):
        """
        A structure that describes a target database for resource linking.
        """
        catalog_id: NotRequired[pulumi.Input[str]]
        """
        The ID of the Data Catalog in which the database resides.
        """
        database_name: NotRequired[pulumi.Input[str]]
        """
        The name of the catalog database.
        """
        region: NotRequired[pulumi.Input[str]]
        """
        Region of the target database.
        """
elif False:
    DatabaseIdentifierArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatabaseIdentifierArgs:
    def __init__(__self__, *,
                 catalog_id: Optional[pulumi.Input[str]] = None,
                 database_name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None):
        """
        A structure that describes a target database for resource linking.
        :param pulumi.Input[str] catalog_id: The ID of the Data Catalog in which the database resides.
        :param pulumi.Input[str] database_name: The name of the catalog database.
        :param pulumi.Input[str] region: Region of the target database.
        """
        if catalog_id is not None:
            pulumi.set(__self__, "catalog_id", catalog_id)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the Data Catalog in which the database resides.
        """
        return pulumi.get(self, "catalog_id")

    @catalog_id.setter
    def catalog_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "catalog_id", value)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the catalog database.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Region of the target database.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


if not MYPY:
    class DatabaseInputArgsDict(TypedDict):
        """
        The structure used to create or update a database.
        """
        create_table_default_permissions: NotRequired[pulumi.Input[Sequence[pulumi.Input['DatabasePrincipalPrivilegesArgsDict']]]]
        """
        Creates a set of default permissions on the table for principals. Used by AWS Lake Formation. Not used in the normal course of AWS Glue operations.
        """
        description: NotRequired[pulumi.Input[str]]
        """
        A description of the database.
        """
        federated_database: NotRequired[pulumi.Input['DatabaseFederatedDatabaseArgsDict']]
        """
        A FederatedDatabase structure that references an entity outside the AWS Glue Data Catalog.
        """
        location_uri: NotRequired[pulumi.Input[str]]
        """
        The location of the database (for example, an HDFS path).
        """
        name: NotRequired[pulumi.Input[str]]
        """
        The name of the database. For hive compatibility, this is folded to lowercase when it is stored.
        """
        parameters: NotRequired[Any]
        """
        These key-value pairs define parameters and properties of the database.
        """
        target_database: NotRequired[pulumi.Input['DatabaseIdentifierArgsDict']]
        """
        A DatabaseIdentifier structure that describes a target database for resource linking.
        """
elif False:
    DatabaseInputArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatabaseInputArgs:
    def __init__(__self__, *,
                 create_table_default_permissions: Optional[pulumi.Input[Sequence[pulumi.Input['DatabasePrincipalPrivilegesArgs']]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 federated_database: Optional[pulumi.Input['DatabaseFederatedDatabaseArgs']] = None,
                 location_uri: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[Any] = None,
                 target_database: Optional[pulumi.Input['DatabaseIdentifierArgs']] = None):
        """
        The structure used to create or update a database.
        :param pulumi.Input[Sequence[pulumi.Input['DatabasePrincipalPrivilegesArgs']]] create_table_default_permissions: Creates a set of default permissions on the table for principals. Used by AWS Lake Formation. Not used in the normal course of AWS Glue operations.
        :param pulumi.Input[str] description: A description of the database.
        :param pulumi.Input['DatabaseFederatedDatabaseArgs'] federated_database: A FederatedDatabase structure that references an entity outside the AWS Glue Data Catalog.
        :param pulumi.Input[str] location_uri: The location of the database (for example, an HDFS path).
        :param pulumi.Input[str] name: The name of the database. For hive compatibility, this is folded to lowercase when it is stored.
        :param Any parameters: These key-value pairs define parameters and properties of the database.
        :param pulumi.Input['DatabaseIdentifierArgs'] target_database: A DatabaseIdentifier structure that describes a target database for resource linking.
        """
        if create_table_default_permissions is not None:
            pulumi.set(__self__, "create_table_default_permissions", create_table_default_permissions)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if federated_database is not None:
            pulumi.set(__self__, "federated_database", federated_database)
        if location_uri is not None:
            pulumi.set(__self__, "location_uri", location_uri)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if target_database is not None:
            pulumi.set(__self__, "target_database", target_database)

    @property
    @pulumi.getter(name="createTableDefaultPermissions")
    def create_table_default_permissions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DatabasePrincipalPrivilegesArgs']]]]:
        """
        Creates a set of default permissions on the table for principals. Used by AWS Lake Formation. Not used in the normal course of AWS Glue operations.
        """
        return pulumi.get(self, "create_table_default_permissions")

    @create_table_default_permissions.setter
    def create_table_default_permissions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DatabasePrincipalPrivilegesArgs']]]]):
        pulumi.set(self, "create_table_default_permissions", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A description of the database.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="federatedDatabase")
    def federated_database(self) -> Optional[pulumi.Input['DatabaseFederatedDatabaseArgs']]:
        """
        A FederatedDatabase structure that references an entity outside the AWS Glue Data Catalog.
        """
        return pulumi.get(self, "federated_database")

    @federated_database.setter
    def federated_database(self, value: Optional[pulumi.Input['DatabaseFederatedDatabaseArgs']]):
        pulumi.set(self, "federated_database", value)

    @property
    @pulumi.getter(name="locationUri")
    def location_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The location of the database (for example, an HDFS path).
        """
        return pulumi.get(self, "location_uri")

    @location_uri.setter
    def location_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location_uri", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the database. For hive compatibility, this is folded to lowercase when it is stored.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Any]:
        """
        These key-value pairs define parameters and properties of the database.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[Any]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter(name="targetDatabase")
    def target_database(self) -> Optional[pulumi.Input['DatabaseIdentifierArgs']]:
        """
        A DatabaseIdentifier structure that describes a target database for resource linking.
        """
        return pulumi.get(self, "target_database")

    @target_database.setter
    def target_database(self, value: Optional[pulumi.Input['DatabaseIdentifierArgs']]):
        pulumi.set(self, "target_database", value)


if not MYPY:
    class DatabasePrincipalPrivilegesArgsDict(TypedDict):
        """
        The permissions granted to a principal.
        """
        permissions: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        The permissions that are granted to the principal.
        """
        principal: NotRequired[pulumi.Input['DatabaseDataLakePrincipalArgsDict']]
        """
        The principal who is granted permissions.
        """
elif False:
    DatabasePrincipalPrivilegesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatabasePrincipalPrivilegesArgs:
    def __init__(__self__, *,
                 permissions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 principal: Optional[pulumi.Input['DatabaseDataLakePrincipalArgs']] = None):
        """
        The permissions granted to a principal.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] permissions: The permissions that are granted to the principal.
        :param pulumi.Input['DatabaseDataLakePrincipalArgs'] principal: The principal who is granted permissions.
        """
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)
        if principal is not None:
            pulumi.set(__self__, "principal", principal)

    @property
    @pulumi.getter
    def permissions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The permissions that are granted to the principal.
        """
        return pulumi.get(self, "permissions")

    @permissions.setter
    def permissions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "permissions", value)

    @property
    @pulumi.getter
    def principal(self) -> Optional[pulumi.Input['DatabaseDataLakePrincipalArgs']]:
        """
        The principal who is granted permissions.
        """
        return pulumi.get(self, "principal")

    @principal.setter
    def principal(self, value: Optional[pulumi.Input['DatabaseDataLakePrincipalArgs']]):
        pulumi.set(self, "principal", value)


if not MYPY:
    class SchemaRegistryArgsDict(TypedDict):
        """
        Identifier for the registry which the schema is part of.
        """
        arn: NotRequired[pulumi.Input[str]]
        """
        Amazon Resource Name for the Registry.
        """
        name: NotRequired[pulumi.Input[str]]
        """
        Name of the registry in which the schema will be created.
        """
elif False:
    SchemaRegistryArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SchemaRegistryArgs:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        Identifier for the registry which the schema is part of.
        :param pulumi.Input[str] arn: Amazon Resource Name for the Registry.
        :param pulumi.Input[str] name: Name of the registry in which the schema will be created.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        Amazon Resource Name for the Registry.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the registry in which the schema will be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


if not MYPY:
    class SchemaVersionSchemaArgsDict(TypedDict):
        """
        Identifier for the schema where the schema version will be created.
        """
        registry_name: NotRequired[pulumi.Input[str]]
        """
        Name of the registry to identify where the Schema is located.
        """
        schema_arn: NotRequired[pulumi.Input[str]]
        """
        Amazon Resource Name for the Schema. This attribute can be used to uniquely represent the Schema.
        """
        schema_name: NotRequired[pulumi.Input[str]]
        """
        Name of the schema. This parameter requires RegistryName to be provided.
        """
elif False:
    SchemaVersionSchemaArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SchemaVersionSchemaArgs:
    def __init__(__self__, *,
                 registry_name: Optional[pulumi.Input[str]] = None,
                 schema_arn: Optional[pulumi.Input[str]] = None,
                 schema_name: Optional[pulumi.Input[str]] = None):
        """
        Identifier for the schema where the schema version will be created.
        :param pulumi.Input[str] registry_name: Name of the registry to identify where the Schema is located.
        :param pulumi.Input[str] schema_arn: Amazon Resource Name for the Schema. This attribute can be used to uniquely represent the Schema.
        :param pulumi.Input[str] schema_name: Name of the schema. This parameter requires RegistryName to be provided.
        """
        if registry_name is not None:
            pulumi.set(__self__, "registry_name", registry_name)
        if schema_arn is not None:
            pulumi.set(__self__, "schema_arn", schema_arn)
        if schema_name is not None:
            pulumi.set(__self__, "schema_name", schema_name)

    @property
    @pulumi.getter(name="registryName")
    def registry_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the registry to identify where the Schema is located.
        """
        return pulumi.get(self, "registry_name")

    @registry_name.setter
    def registry_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "registry_name", value)

    @property
    @pulumi.getter(name="schemaArn")
    def schema_arn(self) -> Optional[pulumi.Input[str]]:
        """
        Amazon Resource Name for the Schema. This attribute can be used to uniquely represent the Schema.
        """
        return pulumi.get(self, "schema_arn")

    @schema_arn.setter
    def schema_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "schema_arn", value)

    @property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the schema. This parameter requires RegistryName to be provided.
        """
        return pulumi.get(self, "schema_name")

    @schema_name.setter
    def schema_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "schema_name", value)


if not MYPY:
    class SchemaVersionArgsDict(TypedDict):
        """
        Specify checkpoint version for update. This is only required to update the Compatibility.
        """
        is_latest: NotRequired[pulumi.Input[bool]]
        """
        Indicates if the latest version needs to be updated.
        """
        version_number: NotRequired[pulumi.Input[int]]
        """
        Indicates the version number in the schema to update.
        """
elif False:
    SchemaVersionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SchemaVersionArgs:
    def __init__(__self__, *,
                 is_latest: Optional[pulumi.Input[bool]] = None,
                 version_number: Optional[pulumi.Input[int]] = None):
        """
        Specify checkpoint version for update. This is only required to update the Compatibility.
        :param pulumi.Input[bool] is_latest: Indicates if the latest version needs to be updated.
        :param pulumi.Input[int] version_number: Indicates the version number in the schema to update.
        """
        if is_latest is not None:
            pulumi.set(__self__, "is_latest", is_latest)
        if version_number is not None:
            pulumi.set(__self__, "version_number", version_number)

    @property
    @pulumi.getter(name="isLatest")
    def is_latest(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates if the latest version needs to be updated.
        """
        return pulumi.get(self, "is_latest")

    @is_latest.setter
    def is_latest(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_latest", value)

    @property
    @pulumi.getter(name="versionNumber")
    def version_number(self) -> Optional[pulumi.Input[int]]:
        """
        Indicates the version number in the schema to update.
        """
        return pulumi.get(self, "version_number")

    @version_number.setter
    def version_number(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "version_number", value)


if not MYPY:
    class TriggerActionArgsDict(TypedDict):
        """
        The actions initiated by this trigger.
        """
        arguments: NotRequired[Any]
        """
        The job arguments used when this trigger fires. For this job run, they replace the default arguments set in the job definition itself.
        """
        crawler_name: NotRequired[pulumi.Input[str]]
        """
        The name of the crawler to be used with this action.
        """
        job_name: NotRequired[pulumi.Input[str]]
        """
        The name of a job to be executed.
        """
        notification_property: NotRequired[pulumi.Input['TriggerNotificationPropertyArgsDict']]
        """
        Specifies configuration properties of a job run notification.
        """
        security_configuration: NotRequired[pulumi.Input[str]]
        """
        The name of the SecurityConfiguration structure to be used with this action.
        """
        timeout: NotRequired[pulumi.Input[int]]
        """
        The JobRun timeout in minutes. This is the maximum time that a job run can consume resources before it is terminated and enters TIMEOUT status. The default is 2,880 minutes (48 hours). This overrides the timeout value set in the parent job.
        """
elif False:
    TriggerActionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TriggerActionArgs:
    def __init__(__self__, *,
                 arguments: Optional[Any] = None,
                 crawler_name: Optional[pulumi.Input[str]] = None,
                 job_name: Optional[pulumi.Input[str]] = None,
                 notification_property: Optional[pulumi.Input['TriggerNotificationPropertyArgs']] = None,
                 security_configuration: Optional[pulumi.Input[str]] = None,
                 timeout: Optional[pulumi.Input[int]] = None):
        """
        The actions initiated by this trigger.
        :param Any arguments: The job arguments used when this trigger fires. For this job run, they replace the default arguments set in the job definition itself.
        :param pulumi.Input[str] crawler_name: The name of the crawler to be used with this action.
        :param pulumi.Input[str] job_name: The name of a job to be executed.
        :param pulumi.Input['TriggerNotificationPropertyArgs'] notification_property: Specifies configuration properties of a job run notification.
        :param pulumi.Input[str] security_configuration: The name of the SecurityConfiguration structure to be used with this action.
        :param pulumi.Input[int] timeout: The JobRun timeout in minutes. This is the maximum time that a job run can consume resources before it is terminated and enters TIMEOUT status. The default is 2,880 minutes (48 hours). This overrides the timeout value set in the parent job.
        """
        if arguments is not None:
            pulumi.set(__self__, "arguments", arguments)
        if crawler_name is not None:
            pulumi.set(__self__, "crawler_name", crawler_name)
        if job_name is not None:
            pulumi.set(__self__, "job_name", job_name)
        if notification_property is not None:
            pulumi.set(__self__, "notification_property", notification_property)
        if security_configuration is not None:
            pulumi.set(__self__, "security_configuration", security_configuration)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter
    def arguments(self) -> Optional[Any]:
        """
        The job arguments used when this trigger fires. For this job run, they replace the default arguments set in the job definition itself.
        """
        return pulumi.get(self, "arguments")

    @arguments.setter
    def arguments(self, value: Optional[Any]):
        pulumi.set(self, "arguments", value)

    @property
    @pulumi.getter(name="crawlerName")
    def crawler_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the crawler to be used with this action.
        """
        return pulumi.get(self, "crawler_name")

    @crawler_name.setter
    def crawler_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "crawler_name", value)

    @property
    @pulumi.getter(name="jobName")
    def job_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of a job to be executed.
        """
        return pulumi.get(self, "job_name")

    @job_name.setter
    def job_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "job_name", value)

    @property
    @pulumi.getter(name="notificationProperty")
    def notification_property(self) -> Optional[pulumi.Input['TriggerNotificationPropertyArgs']]:
        """
        Specifies configuration properties of a job run notification.
        """
        return pulumi.get(self, "notification_property")

    @notification_property.setter
    def notification_property(self, value: Optional[pulumi.Input['TriggerNotificationPropertyArgs']]):
        pulumi.set(self, "notification_property", value)

    @property
    @pulumi.getter(name="securityConfiguration")
    def security_configuration(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the SecurityConfiguration structure to be used with this action.
        """
        return pulumi.get(self, "security_configuration")

    @security_configuration.setter
    def security_configuration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_configuration", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[int]]:
        """
        The JobRun timeout in minutes. This is the maximum time that a job run can consume resources before it is terminated and enters TIMEOUT status. The default is 2,880 minutes (48 hours). This overrides the timeout value set in the parent job.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout", value)


if not MYPY:
    class TriggerConditionArgsDict(TypedDict):
        """
        Defines a condition under which a trigger fires.
        """
        crawl_state: NotRequired[pulumi.Input[str]]
        """
        The state of the crawler to which this condition applies.
        """
        crawler_name: NotRequired[pulumi.Input[str]]
        """
        The name of the crawler to which this condition applies.
        """
        job_name: NotRequired[pulumi.Input[str]]
        """
        The name of the job whose JobRuns this condition applies to, and on which this trigger waits.
        """
        logical_operator: NotRequired[pulumi.Input[str]]
        """
        A logical operator.
        """
        state: NotRequired[pulumi.Input[str]]
        """
        The condition state. Currently, the values supported are SUCCEEDED, STOPPED, TIMEOUT, and FAILED.
        """
elif False:
    TriggerConditionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TriggerConditionArgs:
    def __init__(__self__, *,
                 crawl_state: Optional[pulumi.Input[str]] = None,
                 crawler_name: Optional[pulumi.Input[str]] = None,
                 job_name: Optional[pulumi.Input[str]] = None,
                 logical_operator: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None):
        """
        Defines a condition under which a trigger fires.
        :param pulumi.Input[str] crawl_state: The state of the crawler to which this condition applies.
        :param pulumi.Input[str] crawler_name: The name of the crawler to which this condition applies.
        :param pulumi.Input[str] job_name: The name of the job whose JobRuns this condition applies to, and on which this trigger waits.
        :param pulumi.Input[str] logical_operator: A logical operator.
        :param pulumi.Input[str] state: The condition state. Currently, the values supported are SUCCEEDED, STOPPED, TIMEOUT, and FAILED.
        """
        if crawl_state is not None:
            pulumi.set(__self__, "crawl_state", crawl_state)
        if crawler_name is not None:
            pulumi.set(__self__, "crawler_name", crawler_name)
        if job_name is not None:
            pulumi.set(__self__, "job_name", job_name)
        if logical_operator is not None:
            pulumi.set(__self__, "logical_operator", logical_operator)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="crawlState")
    def crawl_state(self) -> Optional[pulumi.Input[str]]:
        """
        The state of the crawler to which this condition applies.
        """
        return pulumi.get(self, "crawl_state")

    @crawl_state.setter
    def crawl_state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "crawl_state", value)

    @property
    @pulumi.getter(name="crawlerName")
    def crawler_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the crawler to which this condition applies.
        """
        return pulumi.get(self, "crawler_name")

    @crawler_name.setter
    def crawler_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "crawler_name", value)

    @property
    @pulumi.getter(name="jobName")
    def job_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the job whose JobRuns this condition applies to, and on which this trigger waits.
        """
        return pulumi.get(self, "job_name")

    @job_name.setter
    def job_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "job_name", value)

    @property
    @pulumi.getter(name="logicalOperator")
    def logical_operator(self) -> Optional[pulumi.Input[str]]:
        """
        A logical operator.
        """
        return pulumi.get(self, "logical_operator")

    @logical_operator.setter
    def logical_operator(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "logical_operator", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The condition state. Currently, the values supported are SUCCEEDED, STOPPED, TIMEOUT, and FAILED.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)


if not MYPY:
    class TriggerEventBatchingConditionArgsDict(TypedDict):
        """
        Batch condition that must be met (specified number of events received or batch time window expired) before EventBridge event trigger fires.
        """
        batch_size: pulumi.Input[int]
        """
        Number of events that must be received from Amazon EventBridge before EventBridge event trigger fires.
        """
        batch_window: NotRequired[pulumi.Input[int]]
        """
        Window of time in seconds after which EventBridge event trigger fires. Window starts when first event is received.
        """
elif False:
    TriggerEventBatchingConditionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TriggerEventBatchingConditionArgs:
    def __init__(__self__, *,
                 batch_size: pulumi.Input[int],
                 batch_window: Optional[pulumi.Input[int]] = None):
        """
        Batch condition that must be met (specified number of events received or batch time window expired) before EventBridge event trigger fires.
        :param pulumi.Input[int] batch_size: Number of events that must be received from Amazon EventBridge before EventBridge event trigger fires.
        :param pulumi.Input[int] batch_window: Window of time in seconds after which EventBridge event trigger fires. Window starts when first event is received.
        """
        pulumi.set(__self__, "batch_size", batch_size)
        if batch_window is not None:
            pulumi.set(__self__, "batch_window", batch_window)

    @property
    @pulumi.getter(name="batchSize")
    def batch_size(self) -> pulumi.Input[int]:
        """
        Number of events that must be received from Amazon EventBridge before EventBridge event trigger fires.
        """
        return pulumi.get(self, "batch_size")

    @batch_size.setter
    def batch_size(self, value: pulumi.Input[int]):
        pulumi.set(self, "batch_size", value)

    @property
    @pulumi.getter(name="batchWindow")
    def batch_window(self) -> Optional[pulumi.Input[int]]:
        """
        Window of time in seconds after which EventBridge event trigger fires. Window starts when first event is received.
        """
        return pulumi.get(self, "batch_window")

    @batch_window.setter
    def batch_window(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "batch_window", value)


if not MYPY:
    class TriggerNotificationPropertyArgsDict(TypedDict):
        """
        Specifies configuration properties of a job run notification.
        """
        notify_delay_after: NotRequired[pulumi.Input[int]]
        """
        After a job run starts, the number of minutes to wait before sending a job run delay notification
        """
elif False:
    TriggerNotificationPropertyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TriggerNotificationPropertyArgs:
    def __init__(__self__, *,
                 notify_delay_after: Optional[pulumi.Input[int]] = None):
        """
        Specifies configuration properties of a job run notification.
        :param pulumi.Input[int] notify_delay_after: After a job run starts, the number of minutes to wait before sending a job run delay notification
        """
        if notify_delay_after is not None:
            pulumi.set(__self__, "notify_delay_after", notify_delay_after)

    @property
    @pulumi.getter(name="notifyDelayAfter")
    def notify_delay_after(self) -> Optional[pulumi.Input[int]]:
        """
        After a job run starts, the number of minutes to wait before sending a job run delay notification
        """
        return pulumi.get(self, "notify_delay_after")

    @notify_delay_after.setter
    def notify_delay_after(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "notify_delay_after", value)


if not MYPY:
    class TriggerPredicateArgsDict(TypedDict):
        """
        The predicate of this trigger, which defines when it will fire.
        """
        conditions: NotRequired[pulumi.Input[Sequence[pulumi.Input['TriggerConditionArgsDict']]]]
        """
        A list of the conditions that determine when the trigger will fire.
        """
        logical: NotRequired[pulumi.Input[str]]
        """
        An optional field if only one condition is listed. If multiple conditions are listed, then this field is required.
        """
elif False:
    TriggerPredicateArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TriggerPredicateArgs:
    def __init__(__self__, *,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input['TriggerConditionArgs']]]] = None,
                 logical: Optional[pulumi.Input[str]] = None):
        """
        The predicate of this trigger, which defines when it will fire.
        :param pulumi.Input[Sequence[pulumi.Input['TriggerConditionArgs']]] conditions: A list of the conditions that determine when the trigger will fire.
        :param pulumi.Input[str] logical: An optional field if only one condition is listed. If multiple conditions are listed, then this field is required.
        """
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if logical is not None:
            pulumi.set(__self__, "logical", logical)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TriggerConditionArgs']]]]:
        """
        A list of the conditions that determine when the trigger will fire.
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TriggerConditionArgs']]]]):
        pulumi.set(self, "conditions", value)

    @property
    @pulumi.getter
    def logical(self) -> Optional[pulumi.Input[str]]:
        """
        An optional field if only one condition is listed. If multiple conditions are listed, then this field is required.
        """
        return pulumi.get(self, "logical")

    @logical.setter
    def logical(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "logical", value)


