# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AliasRoutingStrategy',
    'BuildStorageLocation',
    'ContainerGroupDefinitionContainerDefinition',
    'ContainerGroupDefinitionContainerDependency',
    'ContainerGroupDefinitionContainerEnvironment',
    'ContainerGroupDefinitionContainerHealthCheck',
    'ContainerGroupDefinitionContainerPortRange',
    'ContainerGroupDefinitionMemoryLimits',
    'ContainerGroupDefinitionPortConfiguration',
    'FleetAnywhereConfiguration',
    'FleetCertificateConfiguration',
    'FleetConnectionPortRange',
    'FleetContainerGroupsConfiguration',
    'FleetContainerGroupsPerInstance',
    'FleetIpPermission',
    'FleetLocationCapacity',
    'FleetLocationConfiguration',
    'FleetResourceCreationLimitPolicy',
    'FleetRuntimeConfiguration',
    'FleetScalingPolicy',
    'FleetServerProcess',
    'FleetTargetConfiguration',
    'GameServerGroupAutoScalingPolicy',
    'GameServerGroupInstanceDefinition',
    'GameServerGroupLaunchTemplate',
    'GameServerGroupTargetTrackingConfiguration',
    'GameSessionQueueDestination',
    'GameSessionQueueFilterConfiguration',
    'GameSessionQueuePlayerLatencyPolicy',
    'GameSessionQueuePriorityConfiguration',
    'MatchmakingConfigurationGameProperty',
    'ScriptS3Location',
]

@pulumi.output_type
class AliasRoutingStrategy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fleetId":
            suggest = "fleet_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AliasRoutingStrategy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AliasRoutingStrategy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AliasRoutingStrategy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: 'AliasRoutingStrategyType',
                 fleet_id: Optional[str] = None,
                 message: Optional[str] = None):
        """
        :param 'AliasRoutingStrategyType' type: Simple routing strategy. The alias resolves to one specific fleet. Use this type when routing to active fleets.
        :param str fleet_id: A unique identifier for a fleet that the alias points to. If you specify SIMPLE for the Type property, you must specify this property.
        :param str message: The message text to be used with a terminal routing strategy. If you specify TERMINAL for the Type property, you must specify this property.
        """
        pulumi.set(__self__, "type", type)
        if fleet_id is not None:
            pulumi.set(__self__, "fleet_id", fleet_id)
        if message is not None:
            pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def type(self) -> 'AliasRoutingStrategyType':
        """
        Simple routing strategy. The alias resolves to one specific fleet. Use this type when routing to active fleets.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="fleetId")
    def fleet_id(self) -> Optional[str]:
        """
        A unique identifier for a fleet that the alias points to. If you specify SIMPLE for the Type property, you must specify this property.
        """
        return pulumi.get(self, "fleet_id")

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        """
        The message text to be used with a terminal routing strategy. If you specify TERMINAL for the Type property, you must specify this property.
        """
        return pulumi.get(self, "message")


@pulumi.output_type
class BuildStorageLocation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "roleArn":
            suggest = "role_arn"
        elif key == "objectVersion":
            suggest = "object_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BuildStorageLocation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BuildStorageLocation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BuildStorageLocation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket: str,
                 key: str,
                 role_arn: str,
                 object_version: Optional[str] = None):
        """
        :param str bucket: An Amazon S3 bucket identifier. This is the name of the S3 bucket.
        :param str key: The name of the zip file that contains the build files or script files.
        :param str role_arn: The Amazon Resource Name (ARN) for an IAM role that allows Amazon GameLift to access the S3 bucket.
        :param str object_version: The version of the file, if object versioning is turned on for the bucket. Amazon GameLift uses this information when retrieving files from your S3 bucket. To retrieve a specific version of the file, provide an object version. To retrieve the latest version of the file, do not set this parameter.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "role_arn", role_arn)
        if object_version is not None:
            pulumi.set(__self__, "object_version", object_version)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        An Amazon S3 bucket identifier. This is the name of the S3 bucket.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The name of the zip file that contains the build files or script files.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> str:
        """
        The Amazon Resource Name (ARN) for an IAM role that allows Amazon GameLift to access the S3 bucket.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="objectVersion")
    def object_version(self) -> Optional[str]:
        """
        The version of the file, if object versioning is turned on for the bucket. Amazon GameLift uses this information when retrieving files from your S3 bucket. To retrieve a specific version of the file, provide an object version. To retrieve the latest version of the file, do not set this parameter.
        """
        return pulumi.get(self, "object_version")


@pulumi.output_type
class ContainerGroupDefinitionContainerDefinition(dict):
    """
    Details about a container that is used in a container fleet
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerName":
            suggest = "container_name"
        elif key == "imageUri":
            suggest = "image_uri"
        elif key == "dependsOn":
            suggest = "depends_on"
        elif key == "entryPoint":
            suggest = "entry_point"
        elif key == "healthCheck":
            suggest = "health_check"
        elif key == "memoryLimits":
            suggest = "memory_limits"
        elif key == "portConfiguration":
            suggest = "port_configuration"
        elif key == "resolvedImageDigest":
            suggest = "resolved_image_digest"
        elif key == "workingDirectory":
            suggest = "working_directory"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerGroupDefinitionContainerDefinition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerGroupDefinitionContainerDefinition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerGroupDefinitionContainerDefinition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_name: str,
                 image_uri: str,
                 command: Optional[Sequence[str]] = None,
                 cpu: Optional[int] = None,
                 depends_on: Optional[Sequence['outputs.ContainerGroupDefinitionContainerDependency']] = None,
                 entry_point: Optional[Sequence[str]] = None,
                 environment: Optional[Sequence['outputs.ContainerGroupDefinitionContainerEnvironment']] = None,
                 essential: Optional[bool] = None,
                 health_check: Optional['outputs.ContainerGroupDefinitionContainerHealthCheck'] = None,
                 memory_limits: Optional['outputs.ContainerGroupDefinitionMemoryLimits'] = None,
                 port_configuration: Optional['outputs.ContainerGroupDefinitionPortConfiguration'] = None,
                 resolved_image_digest: Optional[str] = None,
                 working_directory: Optional[str] = None):
        """
        Details about a container that is used in a container fleet
        :param str container_name: A descriptive label for the container definition. Container definition names must be unique with a container group definition.
        :param str image_uri: Specifies the image URI of this container.
        :param Sequence[str] command: The command that's passed to the container.
        :param int cpu: The maximum number of CPU units reserved for this container. The value is expressed as an integer amount of CPU units. 1 vCPU is equal to 1024 CPU units
        :param Sequence['ContainerGroupDefinitionContainerDependency'] depends_on: A list of container dependencies that determines when this container starts up and shuts down. For container groups with multiple containers, dependencies let you define a startup/shutdown sequence across the containers.
        :param Sequence[str] entry_point: The entry point that's passed to the container so that it will run as an executable. If there are multiple arguments, each argument is a string in the array.
        :param Sequence['ContainerGroupDefinitionContainerEnvironment'] environment: The environment variables to pass to a container.
        :param bool essential: Specifies if the container is essential. If an essential container fails a health check, then all containers in the container group will be restarted. You must specify exactly 1 essential container in a container group.
        :param 'ContainerGroupDefinitionContainerHealthCheck' health_check: Specifies how the health of the containers will be checked.
        :param 'ContainerGroupDefinitionMemoryLimits' memory_limits: Specifies how much memory is available to the container. You must specify at least this parameter or the TotalMemoryLimit parameter of the ContainerGroupDefinition.
        :param 'ContainerGroupDefinitionPortConfiguration' port_configuration: Defines the ports on the container.
        :param str resolved_image_digest: The digest of the container image.
        :param str working_directory: The working directory to run commands inside the container in.
        """
        pulumi.set(__self__, "container_name", container_name)
        pulumi.set(__self__, "image_uri", image_uri)
        if command is not None:
            pulumi.set(__self__, "command", command)
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if depends_on is not None:
            pulumi.set(__self__, "depends_on", depends_on)
        if entry_point is not None:
            pulumi.set(__self__, "entry_point", entry_point)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if essential is not None:
            pulumi.set(__self__, "essential", essential)
        if health_check is not None:
            pulumi.set(__self__, "health_check", health_check)
        if memory_limits is not None:
            pulumi.set(__self__, "memory_limits", memory_limits)
        if port_configuration is not None:
            pulumi.set(__self__, "port_configuration", port_configuration)
        if resolved_image_digest is not None:
            pulumi.set(__self__, "resolved_image_digest", resolved_image_digest)
        if working_directory is not None:
            pulumi.set(__self__, "working_directory", working_directory)

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> str:
        """
        A descriptive label for the container definition. Container definition names must be unique with a container group definition.
        """
        return pulumi.get(self, "container_name")

    @property
    @pulumi.getter(name="imageUri")
    def image_uri(self) -> str:
        """
        Specifies the image URI of this container.
        """
        return pulumi.get(self, "image_uri")

    @property
    @pulumi.getter
    def command(self) -> Optional[Sequence[str]]:
        """
        The command that's passed to the container.
        """
        return pulumi.get(self, "command")

    @property
    @pulumi.getter
    def cpu(self) -> Optional[int]:
        """
        The maximum number of CPU units reserved for this container. The value is expressed as an integer amount of CPU units. 1 vCPU is equal to 1024 CPU units
        """
        return pulumi.get(self, "cpu")

    @property
    @pulumi.getter(name="dependsOn")
    def depends_on(self) -> Optional[Sequence['outputs.ContainerGroupDefinitionContainerDependency']]:
        """
        A list of container dependencies that determines when this container starts up and shuts down. For container groups with multiple containers, dependencies let you define a startup/shutdown sequence across the containers.
        """
        return pulumi.get(self, "depends_on")

    @property
    @pulumi.getter(name="entryPoint")
    def entry_point(self) -> Optional[Sequence[str]]:
        """
        The entry point that's passed to the container so that it will run as an executable. If there are multiple arguments, each argument is a string in the array.
        """
        return pulumi.get(self, "entry_point")

    @property
    @pulumi.getter
    def environment(self) -> Optional[Sequence['outputs.ContainerGroupDefinitionContainerEnvironment']]:
        """
        The environment variables to pass to a container.
        """
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter
    def essential(self) -> Optional[bool]:
        """
        Specifies if the container is essential. If an essential container fails a health check, then all containers in the container group will be restarted. You must specify exactly 1 essential container in a container group.
        """
        return pulumi.get(self, "essential")

    @property
    @pulumi.getter(name="healthCheck")
    def health_check(self) -> Optional['outputs.ContainerGroupDefinitionContainerHealthCheck']:
        """
        Specifies how the health of the containers will be checked.
        """
        return pulumi.get(self, "health_check")

    @property
    @pulumi.getter(name="memoryLimits")
    def memory_limits(self) -> Optional['outputs.ContainerGroupDefinitionMemoryLimits']:
        """
        Specifies how much memory is available to the container. You must specify at least this parameter or the TotalMemoryLimit parameter of the ContainerGroupDefinition.
        """
        return pulumi.get(self, "memory_limits")

    @property
    @pulumi.getter(name="portConfiguration")
    def port_configuration(self) -> Optional['outputs.ContainerGroupDefinitionPortConfiguration']:
        """
        Defines the ports on the container.
        """
        return pulumi.get(self, "port_configuration")

    @property
    @pulumi.getter(name="resolvedImageDigest")
    def resolved_image_digest(self) -> Optional[str]:
        """
        The digest of the container image.
        """
        return pulumi.get(self, "resolved_image_digest")

    @property
    @pulumi.getter(name="workingDirectory")
    def working_directory(self) -> Optional[str]:
        """
        The working directory to run commands inside the container in.
        """
        return pulumi.get(self, "working_directory")


@pulumi.output_type
class ContainerGroupDefinitionContainerDependency(dict):
    """
    A dependency that impacts a container's startup and shutdown.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerName":
            suggest = "container_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerGroupDefinitionContainerDependency. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerGroupDefinitionContainerDependency.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerGroupDefinitionContainerDependency.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 condition: 'ContainerGroupDefinitionContainerDependencyCondition',
                 container_name: str):
        """
        A dependency that impacts a container's startup and shutdown.
        :param 'ContainerGroupDefinitionContainerDependencyCondition' condition: The type of dependency.
        :param str container_name: A descriptive label for the container definition. The container being defined depends on this container's condition.
        """
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "container_name", container_name)

    @property
    @pulumi.getter
    def condition(self) -> 'ContainerGroupDefinitionContainerDependencyCondition':
        """
        The type of dependency.
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> str:
        """
        A descriptive label for the container definition. The container being defined depends on this container's condition.
        """
        return pulumi.get(self, "container_name")


@pulumi.output_type
class ContainerGroupDefinitionContainerEnvironment(dict):
    """
    An environment variable to set inside a container, in the form of a key-value pair.
    """
    def __init__(__self__, *,
                 name: str,
                 value: str):
        """
        An environment variable to set inside a container, in the form of a key-value pair.
        :param str name: The environment variable name.
        :param str value: The environment variable value.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The environment variable name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The environment variable value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ContainerGroupDefinitionContainerHealthCheck(dict):
    """
    Specifies how the process manager checks the health of containers.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "startPeriod":
            suggest = "start_period"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerGroupDefinitionContainerHealthCheck. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerGroupDefinitionContainerHealthCheck.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerGroupDefinitionContainerHealthCheck.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 command: Sequence[str],
                 interval: Optional[int] = None,
                 retries: Optional[int] = None,
                 start_period: Optional[int] = None,
                 timeout: Optional[int] = None):
        """
        Specifies how the process manager checks the health of containers.
        :param Sequence[str] command: A string array representing the command that the container runs to determine if it is healthy.
        :param int interval: How often (in seconds) the health is checked.
        :param int retries: How many times the process manager will retry the command after a timeout. (The first run of the command does not count as a retry.)
        :param int start_period: The optional grace period (in seconds) to give a container time to boostrap before teh health check is declared failed.
        :param int timeout: How many seconds the process manager allows the command to run before canceling it.
        """
        pulumi.set(__self__, "command", command)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if retries is not None:
            pulumi.set(__self__, "retries", retries)
        if start_period is not None:
            pulumi.set(__self__, "start_period", start_period)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter
    def command(self) -> Sequence[str]:
        """
        A string array representing the command that the container runs to determine if it is healthy.
        """
        return pulumi.get(self, "command")

    @property
    @pulumi.getter
    def interval(self) -> Optional[int]:
        """
        How often (in seconds) the health is checked.
        """
        return pulumi.get(self, "interval")

    @property
    @pulumi.getter
    def retries(self) -> Optional[int]:
        """
        How many times the process manager will retry the command after a timeout. (The first run of the command does not count as a retry.)
        """
        return pulumi.get(self, "retries")

    @property
    @pulumi.getter(name="startPeriod")
    def start_period(self) -> Optional[int]:
        """
        The optional grace period (in seconds) to give a container time to boostrap before teh health check is declared failed.
        """
        return pulumi.get(self, "start_period")

    @property
    @pulumi.getter
    def timeout(self) -> Optional[int]:
        """
        How many seconds the process manager allows the command to run before canceling it.
        """
        return pulumi.get(self, "timeout")


@pulumi.output_type
class ContainerGroupDefinitionContainerPortRange(dict):
    """
    A set of one or more port numbers that can be opened on the container.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fromPort":
            suggest = "from_port"
        elif key == "toPort":
            suggest = "to_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerGroupDefinitionContainerPortRange. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerGroupDefinitionContainerPortRange.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerGroupDefinitionContainerPortRange.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 from_port: int,
                 protocol: 'ContainerGroupDefinitionContainerPortRangeProtocol',
                 to_port: int):
        """
        A set of one or more port numbers that can be opened on the container.
        :param int from_port: A starting value for the range of allowed port numbers.
        :param 'ContainerGroupDefinitionContainerPortRangeProtocol' protocol: Defines the protocol of these ports.
        :param int to_port: An ending value for the range of allowed port numbers. Port numbers are end-inclusive. This value must be equal to or greater than FromPort.
        """
        pulumi.set(__self__, "from_port", from_port)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "to_port", to_port)

    @property
    @pulumi.getter(name="fromPort")
    def from_port(self) -> int:
        """
        A starting value for the range of allowed port numbers.
        """
        return pulumi.get(self, "from_port")

    @property
    @pulumi.getter
    def protocol(self) -> 'ContainerGroupDefinitionContainerPortRangeProtocol':
        """
        Defines the protocol of these ports.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="toPort")
    def to_port(self) -> int:
        """
        An ending value for the range of allowed port numbers. Port numbers are end-inclusive. This value must be equal to or greater than FromPort.
        """
        return pulumi.get(self, "to_port")


@pulumi.output_type
class ContainerGroupDefinitionMemoryLimits(dict):
    """
    Specifies how much memory is available to the container.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hardLimit":
            suggest = "hard_limit"
        elif key == "softLimit":
            suggest = "soft_limit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerGroupDefinitionMemoryLimits. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerGroupDefinitionMemoryLimits.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerGroupDefinitionMemoryLimits.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hard_limit: Optional[int] = None,
                 soft_limit: Optional[int] = None):
        """
        Specifies how much memory is available to the container.
        :param int hard_limit: The hard limit of memory to reserve for the container.
        :param int soft_limit: The amount of memory that is reserved for the container.
        """
        if hard_limit is not None:
            pulumi.set(__self__, "hard_limit", hard_limit)
        if soft_limit is not None:
            pulumi.set(__self__, "soft_limit", soft_limit)

    @property
    @pulumi.getter(name="hardLimit")
    def hard_limit(self) -> Optional[int]:
        """
        The hard limit of memory to reserve for the container.
        """
        return pulumi.get(self, "hard_limit")

    @property
    @pulumi.getter(name="softLimit")
    def soft_limit(self) -> Optional[int]:
        """
        The amount of memory that is reserved for the container.
        """
        return pulumi.get(self, "soft_limit")


@pulumi.output_type
class ContainerGroupDefinitionPortConfiguration(dict):
    """
    Defines the ports on a container.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerPortRanges":
            suggest = "container_port_ranges"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerGroupDefinitionPortConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerGroupDefinitionPortConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerGroupDefinitionPortConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_port_ranges: Sequence['outputs.ContainerGroupDefinitionContainerPortRange']):
        """
        Defines the ports on a container.
        :param Sequence['ContainerGroupDefinitionContainerPortRange'] container_port_ranges: Specifies one or more ranges of ports on a container.
        """
        pulumi.set(__self__, "container_port_ranges", container_port_ranges)

    @property
    @pulumi.getter(name="containerPortRanges")
    def container_port_ranges(self) -> Sequence['outputs.ContainerGroupDefinitionContainerPortRange']:
        """
        Specifies one or more ranges of ports on a container.
        """
        return pulumi.get(self, "container_port_ranges")


@pulumi.output_type
class FleetAnywhereConfiguration(dict):
    """
    Configuration for Anywhere fleet.
    """
    def __init__(__self__, *,
                 cost: str):
        """
        Configuration for Anywhere fleet.
        :param str cost: Cost of compute can be specified on Anywhere Fleets to prioritize placement across Queue destinations based on Cost.
        """
        pulumi.set(__self__, "cost", cost)

    @property
    @pulumi.getter
    def cost(self) -> str:
        """
        Cost of compute can be specified on Anywhere Fleets to prioritize placement across Queue destinations based on Cost.
        """
        return pulumi.get(self, "cost")


@pulumi.output_type
class FleetCertificateConfiguration(dict):
    """
    Information about the use of a TLS/SSL certificate for a fleet. TLS certificate generation is enabled at the fleet level, with one certificate generated for the fleet. When this feature is enabled, the certificate can be retrieved using the GameLift Server SDK call GetInstanceCertificate. All instances in a fleet share the same certificate.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateType":
            suggest = "certificate_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FleetCertificateConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FleetCertificateConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FleetCertificateConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate_type: 'FleetCertificateConfigurationCertificateType'):
        """
        Information about the use of a TLS/SSL certificate for a fleet. TLS certificate generation is enabled at the fleet level, with one certificate generated for the fleet. When this feature is enabled, the certificate can be retrieved using the GameLift Server SDK call GetInstanceCertificate. All instances in a fleet share the same certificate.
        :param 'FleetCertificateConfigurationCertificateType' certificate_type: Indicates whether a TLS/SSL certificate is generated for a fleet.
               
               Valid values include:
               
               - *GENERATED* - Generate a TLS/SSL certificate for this fleet.
               - *DISABLED* - (default) Do not generate a TLS/SSL certificate for this fleet.
        """
        pulumi.set(__self__, "certificate_type", certificate_type)

    @property
    @pulumi.getter(name="certificateType")
    def certificate_type(self) -> 'FleetCertificateConfigurationCertificateType':
        """
        Indicates whether a TLS/SSL certificate is generated for a fleet.

        Valid values include:

        - *GENERATED* - Generate a TLS/SSL certificate for this fleet.
        - *DISABLED* - (default) Do not generate a TLS/SSL certificate for this fleet.
        """
        return pulumi.get(self, "certificate_type")


@pulumi.output_type
class FleetConnectionPortRange(dict):
    """
    Defines the range of ports on the instance that allow inbound traffic to connect with containers in a fleet.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fromPort":
            suggest = "from_port"
        elif key == "toPort":
            suggest = "to_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FleetConnectionPortRange. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FleetConnectionPortRange.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FleetConnectionPortRange.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 from_port: int,
                 to_port: int):
        """
        Defines the range of ports on the instance that allow inbound traffic to connect with containers in a fleet.
        :param int from_port: A starting value for a range of allowed port numbers.
        :param int to_port: An ending value for a range of allowed port numbers. Port numbers are end-inclusive. This value must be higher than FromPort.
        """
        pulumi.set(__self__, "from_port", from_port)
        pulumi.set(__self__, "to_port", to_port)

    @property
    @pulumi.getter(name="fromPort")
    def from_port(self) -> int:
        """
        A starting value for a range of allowed port numbers.
        """
        return pulumi.get(self, "from_port")

    @property
    @pulumi.getter(name="toPort")
    def to_port(self) -> int:
        """
        An ending value for a range of allowed port numbers. Port numbers are end-inclusive. This value must be higher than FromPort.
        """
        return pulumi.get(self, "to_port")


@pulumi.output_type
class FleetContainerGroupsConfiguration(dict):
    """
    Specifies container groups that this instance will hold. You must specify exactly one replica group. Optionally, you may specify exactly one daemon group. You can't change this property after you create the fleet.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionPortRange":
            suggest = "connection_port_range"
        elif key == "containerGroupDefinitionNames":
            suggest = "container_group_definition_names"
        elif key == "containerGroupsPerInstance":
            suggest = "container_groups_per_instance"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FleetContainerGroupsConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FleetContainerGroupsConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FleetContainerGroupsConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection_port_range: 'outputs.FleetConnectionPortRange',
                 container_group_definition_names: Sequence[str],
                 container_groups_per_instance: Optional['outputs.FleetContainerGroupsPerInstance'] = None):
        """
        Specifies container groups that this instance will hold. You must specify exactly one replica group. Optionally, you may specify exactly one daemon group. You can't change this property after you create the fleet.
        :param 'FleetConnectionPortRange' connection_port_range: A set of ports to allow inbound traffic, including game clients, to connect to processes running in the container fleet.
               
               Connection ports are dynamically mapped to container ports, which are assigned to individual processes running in a container. The connection port range must have enough ports to map to all container ports across a fleet instance. To calculate the minimum connection ports needed, use the following formula:
               
               *[Total number of container ports as defined for containers in the replica container group] * [Desired or calculated number of replica container groups per instance] + [Total number of container ports as defined for containers in the daemon container group]*
               
               As a best practice, double the minimum number of connection ports.
               
               > Use the fleet's `EC2InboundPermissions` property to control external access to connection ports. Set this property to the connection port numbers that you want to open access to. See `IpPermission` for more details.
        :param Sequence[str] container_group_definition_names: The names of the container group definitions that will be created in an instance. You must specify exactly one REPLICA container group. You have the option to also specify one DAEMON container group.
        """
        pulumi.set(__self__, "connection_port_range", connection_port_range)
        pulumi.set(__self__, "container_group_definition_names", container_group_definition_names)
        if container_groups_per_instance is not None:
            pulumi.set(__self__, "container_groups_per_instance", container_groups_per_instance)

    @property
    @pulumi.getter(name="connectionPortRange")
    def connection_port_range(self) -> 'outputs.FleetConnectionPortRange':
        """
        A set of ports to allow inbound traffic, including game clients, to connect to processes running in the container fleet.

        Connection ports are dynamically mapped to container ports, which are assigned to individual processes running in a container. The connection port range must have enough ports to map to all container ports across a fleet instance. To calculate the minimum connection ports needed, use the following formula:

        *[Total number of container ports as defined for containers in the replica container group] * [Desired or calculated number of replica container groups per instance] + [Total number of container ports as defined for containers in the daemon container group]*

        As a best practice, double the minimum number of connection ports.

        > Use the fleet's `EC2InboundPermissions` property to control external access to connection ports. Set this property to the connection port numbers that you want to open access to. See `IpPermission` for more details.
        """
        return pulumi.get(self, "connection_port_range")

    @property
    @pulumi.getter(name="containerGroupDefinitionNames")
    def container_group_definition_names(self) -> Sequence[str]:
        """
        The names of the container group definitions that will be created in an instance. You must specify exactly one REPLICA container group. You have the option to also specify one DAEMON container group.
        """
        return pulumi.get(self, "container_group_definition_names")

    @property
    @pulumi.getter(name="containerGroupsPerInstance")
    def container_groups_per_instance(self) -> Optional['outputs.FleetContainerGroupsPerInstance']:
        return pulumi.get(self, "container_groups_per_instance")


@pulumi.output_type
class FleetContainerGroupsPerInstance(dict):
    """
    The number of container groups per instance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "desiredReplicaContainerGroupsPerInstance":
            suggest = "desired_replica_container_groups_per_instance"
        elif key == "maxReplicaContainerGroupsPerInstance":
            suggest = "max_replica_container_groups_per_instance"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FleetContainerGroupsPerInstance. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FleetContainerGroupsPerInstance.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FleetContainerGroupsPerInstance.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 desired_replica_container_groups_per_instance: Optional[int] = None,
                 max_replica_container_groups_per_instance: Optional[int] = None):
        """
        The number of container groups per instance.
        :param int desired_replica_container_groups_per_instance: Use this parameter to override the number of replica container groups GameLift will launch per instance with a number that is lower than that calculated maximum.
        :param int max_replica_container_groups_per_instance: GameLift calculates the maximum number of replica container groups it can launch per instance based on instance properties such as CPU, memory, and connection ports.
        """
        if desired_replica_container_groups_per_instance is not None:
            pulumi.set(__self__, "desired_replica_container_groups_per_instance", desired_replica_container_groups_per_instance)
        if max_replica_container_groups_per_instance is not None:
            pulumi.set(__self__, "max_replica_container_groups_per_instance", max_replica_container_groups_per_instance)

    @property
    @pulumi.getter(name="desiredReplicaContainerGroupsPerInstance")
    def desired_replica_container_groups_per_instance(self) -> Optional[int]:
        """
        Use this parameter to override the number of replica container groups GameLift will launch per instance with a number that is lower than that calculated maximum.
        """
        return pulumi.get(self, "desired_replica_container_groups_per_instance")

    @property
    @pulumi.getter(name="maxReplicaContainerGroupsPerInstance")
    def max_replica_container_groups_per_instance(self) -> Optional[int]:
        """
        GameLift calculates the maximum number of replica container groups it can launch per instance based on instance properties such as CPU, memory, and connection ports.
        """
        return pulumi.get(self, "max_replica_container_groups_per_instance")


@pulumi.output_type
class FleetIpPermission(dict):
    """
    A range of IP addresses and port settings that allow inbound traffic to connect to server processes on an Amazon GameLift hosting resource. New game sessions that are started on the fleet are assigned an IP address/port number combination, which must fall into the fleet's allowed ranges. For fleets created with a custom game server, the ranges reflect the server's game session assignments. For Realtime Servers fleets, Amazon GameLift automatically opens two port ranges, one for TCP messaging and one for UDP, for use by the Realtime servers.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fromPort":
            suggest = "from_port"
        elif key == "ipRange":
            suggest = "ip_range"
        elif key == "toPort":
            suggest = "to_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FleetIpPermission. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FleetIpPermission.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FleetIpPermission.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 from_port: int,
                 ip_range: str,
                 protocol: 'FleetIpPermissionProtocol',
                 to_port: int):
        """
        A range of IP addresses and port settings that allow inbound traffic to connect to server processes on an Amazon GameLift hosting resource. New game sessions that are started on the fleet are assigned an IP address/port number combination, which must fall into the fleet's allowed ranges. For fleets created with a custom game server, the ranges reflect the server's game session assignments. For Realtime Servers fleets, Amazon GameLift automatically opens two port ranges, one for TCP messaging and one for UDP, for use by the Realtime servers.
        :param int from_port: A starting value for a range of allowed port numbers.
        :param str ip_range: A range of allowed IP addresses. This value must be expressed in CIDR notation. Example: "000.000.000.000/[subnet mask]" or optionally the shortened version "0.0.0.0/[subnet mask]".
        :param 'FleetIpPermissionProtocol' protocol: The network communication protocol used by the fleet.
        :param int to_port: An ending value for a range of allowed port numbers. Port numbers are end-inclusive. This value must be higher than FromPort.
        """
        pulumi.set(__self__, "from_port", from_port)
        pulumi.set(__self__, "ip_range", ip_range)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "to_port", to_port)

    @property
    @pulumi.getter(name="fromPort")
    def from_port(self) -> int:
        """
        A starting value for a range of allowed port numbers.
        """
        return pulumi.get(self, "from_port")

    @property
    @pulumi.getter(name="ipRange")
    def ip_range(self) -> str:
        """
        A range of allowed IP addresses. This value must be expressed in CIDR notation. Example: "000.000.000.000/[subnet mask]" or optionally the shortened version "0.0.0.0/[subnet mask]".
        """
        return pulumi.get(self, "ip_range")

    @property
    @pulumi.getter
    def protocol(self) -> 'FleetIpPermissionProtocol':
        """
        The network communication protocol used by the fleet.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="toPort")
    def to_port(self) -> int:
        """
        An ending value for a range of allowed port numbers. Port numbers are end-inclusive. This value must be higher than FromPort.
        """
        return pulumi.get(self, "to_port")


@pulumi.output_type
class FleetLocationCapacity(dict):
    """
    Current resource capacity settings in a specified fleet or location. The location value might refer to a fleet's remote location or its home Region.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "desiredEc2Instances":
            suggest = "desired_ec2_instances"
        elif key == "maxSize":
            suggest = "max_size"
        elif key == "minSize":
            suggest = "min_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FleetLocationCapacity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FleetLocationCapacity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FleetLocationCapacity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 desired_ec2_instances: int,
                 max_size: int,
                 min_size: int):
        """
        Current resource capacity settings in a specified fleet or location. The location value might refer to a fleet's remote location or its home Region.
        :param int desired_ec2_instances: The number of EC2 instances you want to maintain in the specified fleet location. This value must fall between the minimum and maximum size limits.
        :param int max_size: The maximum value that is allowed for the fleet's instance count for a location. When creating a new fleet, GameLift automatically sets this value to "1". Once the fleet is active, you can change this value.
        :param int min_size: The minimum value allowed for the fleet's instance count for a location. When creating a new fleet, GameLift automatically sets this value to "0". After the fleet is active, you can change this value.
        """
        pulumi.set(__self__, "desired_ec2_instances", desired_ec2_instances)
        pulumi.set(__self__, "max_size", max_size)
        pulumi.set(__self__, "min_size", min_size)

    @property
    @pulumi.getter(name="desiredEc2Instances")
    def desired_ec2_instances(self) -> int:
        """
        The number of EC2 instances you want to maintain in the specified fleet location. This value must fall between the minimum and maximum size limits.
        """
        return pulumi.get(self, "desired_ec2_instances")

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> int:
        """
        The maximum value that is allowed for the fleet's instance count for a location. When creating a new fleet, GameLift automatically sets this value to "1". Once the fleet is active, you can change this value.
        """
        return pulumi.get(self, "max_size")

    @property
    @pulumi.getter(name="minSize")
    def min_size(self) -> int:
        """
        The minimum value allowed for the fleet's instance count for a location. When creating a new fleet, GameLift automatically sets this value to "0". After the fleet is active, you can change this value.
        """
        return pulumi.get(self, "min_size")


@pulumi.output_type
class FleetLocationConfiguration(dict):
    """
    A remote location where a multi-location fleet can deploy EC2 instances for game hosting.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "locationCapacity":
            suggest = "location_capacity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FleetLocationConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FleetLocationConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FleetLocationConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 location: str,
                 location_capacity: Optional['outputs.FleetLocationCapacity'] = None):
        """
        A remote location where a multi-location fleet can deploy EC2 instances for game hosting.
        :param str location: An AWS Region code, such as `us-west-2` . For a list of supported Regions and Local Zones, see [Amazon GameLift service locations](https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-regions.html) for managed hosting.
        :param 'FleetLocationCapacity' location_capacity: Current resource capacity settings for managed EC2 fleets and container fleets. For multi-location fleets, location values might refer to a fleet's remote location or its home Region.
               
               *Returned by:* [DescribeFleetCapacity](https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetCapacity.html) , [DescribeFleetLocationCapacity](https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetLocationCapacity.html) , [UpdateFleetCapacity](https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateFleetCapacity.html)
        """
        pulumi.set(__self__, "location", location)
        if location_capacity is not None:
            pulumi.set(__self__, "location_capacity", location_capacity)

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        An AWS Region code, such as `us-west-2` . For a list of supported Regions and Local Zones, see [Amazon GameLift service locations](https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-regions.html) for managed hosting.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="locationCapacity")
    def location_capacity(self) -> Optional['outputs.FleetLocationCapacity']:
        """
        Current resource capacity settings for managed EC2 fleets and container fleets. For multi-location fleets, location values might refer to a fleet's remote location or its home Region.

        *Returned by:* [DescribeFleetCapacity](https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetCapacity.html) , [DescribeFleetLocationCapacity](https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetLocationCapacity.html) , [UpdateFleetCapacity](https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateFleetCapacity.html)
        """
        return pulumi.get(self, "location_capacity")


@pulumi.output_type
class FleetResourceCreationLimitPolicy(dict):
    """
    A policy that limits the number of game sessions a player can create on the same fleet. This optional policy gives game owners control over how players can consume available game server resources. A resource creation policy makes the following statement: "An individual player can create a maximum number of new game sessions within a specified time period".

    The policy is evaluated when a player tries to create a new game session. For example, assume you have a policy of 10 new game sessions and a time period of 60 minutes. On receiving a CreateGameSession request, Amazon GameLift checks that the player (identified by CreatorId) has created fewer than 10 game sessions in the past 60 minutes.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "newGameSessionsPerCreator":
            suggest = "new_game_sessions_per_creator"
        elif key == "policyPeriodInMinutes":
            suggest = "policy_period_in_minutes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FleetResourceCreationLimitPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FleetResourceCreationLimitPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FleetResourceCreationLimitPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 new_game_sessions_per_creator: Optional[int] = None,
                 policy_period_in_minutes: Optional[int] = None):
        """
        A policy that limits the number of game sessions a player can create on the same fleet. This optional policy gives game owners control over how players can consume available game server resources. A resource creation policy makes the following statement: "An individual player can create a maximum number of new game sessions within a specified time period".

        The policy is evaluated when a player tries to create a new game session. For example, assume you have a policy of 10 new game sessions and a time period of 60 minutes. On receiving a CreateGameSession request, Amazon GameLift checks that the player (identified by CreatorId) has created fewer than 10 game sessions in the past 60 minutes.
        :param int new_game_sessions_per_creator: The maximum number of game sessions that an individual can create during the policy period.
        :param int policy_period_in_minutes: The time span used in evaluating the resource creation limit policy.
        """
        if new_game_sessions_per_creator is not None:
            pulumi.set(__self__, "new_game_sessions_per_creator", new_game_sessions_per_creator)
        if policy_period_in_minutes is not None:
            pulumi.set(__self__, "policy_period_in_minutes", policy_period_in_minutes)

    @property
    @pulumi.getter(name="newGameSessionsPerCreator")
    def new_game_sessions_per_creator(self) -> Optional[int]:
        """
        The maximum number of game sessions that an individual can create during the policy period.
        """
        return pulumi.get(self, "new_game_sessions_per_creator")

    @property
    @pulumi.getter(name="policyPeriodInMinutes")
    def policy_period_in_minutes(self) -> Optional[int]:
        """
        The time span used in evaluating the resource creation limit policy.
        """
        return pulumi.get(self, "policy_period_in_minutes")


@pulumi.output_type
class FleetRuntimeConfiguration(dict):
    """
    A collection of server process configurations that describe the processes to run on each instance in a fleet. All fleets must have a runtime configuration. Each instance in the fleet maintains server processes as specified in the runtime configuration, launching new ones as existing processes end. Each instance regularly checks for an updated runtime configuration makes adjustments as called for.

    The runtime configuration enables the instances in a fleet to run multiple processes simultaneously. Potential scenarios are as follows: (1) Run multiple processes of a single game server executable to maximize usage of your hosting resources. (2) Run one or more processes of different executables, such as your game server and a metrics tracking program. (3) Run multiple processes of a single game server but with different launch parameters, for example to run one process on each instance in debug mode.

    An Amazon GameLift instance is limited to 50 processes running simultaneously. A runtime configuration must specify fewer than this limit. To calculate the total number of processes specified in a runtime configuration, add the values of the ConcurrentExecutions parameter for each ServerProcess object in the runtime configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "gameSessionActivationTimeoutSeconds":
            suggest = "game_session_activation_timeout_seconds"
        elif key == "maxConcurrentGameSessionActivations":
            suggest = "max_concurrent_game_session_activations"
        elif key == "serverProcesses":
            suggest = "server_processes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FleetRuntimeConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FleetRuntimeConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FleetRuntimeConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 game_session_activation_timeout_seconds: Optional[int] = None,
                 max_concurrent_game_session_activations: Optional[int] = None,
                 server_processes: Optional[Sequence['outputs.FleetServerProcess']] = None):
        """
        A collection of server process configurations that describe the processes to run on each instance in a fleet. All fleets must have a runtime configuration. Each instance in the fleet maintains server processes as specified in the runtime configuration, launching new ones as existing processes end. Each instance regularly checks for an updated runtime configuration makes adjustments as called for.

        The runtime configuration enables the instances in a fleet to run multiple processes simultaneously. Potential scenarios are as follows: (1) Run multiple processes of a single game server executable to maximize usage of your hosting resources. (2) Run one or more processes of different executables, such as your game server and a metrics tracking program. (3) Run multiple processes of a single game server but with different launch parameters, for example to run one process on each instance in debug mode.

        An Amazon GameLift instance is limited to 50 processes running simultaneously. A runtime configuration must specify fewer than this limit. To calculate the total number of processes specified in a runtime configuration, add the values of the ConcurrentExecutions parameter for each ServerProcess object in the runtime configuration.
        :param int game_session_activation_timeout_seconds: The maximum amount of time (in seconds) that a game session can remain in status ACTIVATING. If the game session is not active before the timeout, activation is terminated and the game session status is changed to TERMINATED.
        :param int max_concurrent_game_session_activations: The maximum number of game sessions with status ACTIVATING to allow on an instance simultaneously. This setting limits the amount of instance resources that can be used for new game activations at any one time.
        :param Sequence['FleetServerProcess'] server_processes: A collection of server process configurations that describe which server processes to run on each instance in a fleet.
        """
        if game_session_activation_timeout_seconds is not None:
            pulumi.set(__self__, "game_session_activation_timeout_seconds", game_session_activation_timeout_seconds)
        if max_concurrent_game_session_activations is not None:
            pulumi.set(__self__, "max_concurrent_game_session_activations", max_concurrent_game_session_activations)
        if server_processes is not None:
            pulumi.set(__self__, "server_processes", server_processes)

    @property
    @pulumi.getter(name="gameSessionActivationTimeoutSeconds")
    def game_session_activation_timeout_seconds(self) -> Optional[int]:
        """
        The maximum amount of time (in seconds) that a game session can remain in status ACTIVATING. If the game session is not active before the timeout, activation is terminated and the game session status is changed to TERMINATED.
        """
        return pulumi.get(self, "game_session_activation_timeout_seconds")

    @property
    @pulumi.getter(name="maxConcurrentGameSessionActivations")
    def max_concurrent_game_session_activations(self) -> Optional[int]:
        """
        The maximum number of game sessions with status ACTIVATING to allow on an instance simultaneously. This setting limits the amount of instance resources that can be used for new game activations at any one time.
        """
        return pulumi.get(self, "max_concurrent_game_session_activations")

    @property
    @pulumi.getter(name="serverProcesses")
    def server_processes(self) -> Optional[Sequence['outputs.FleetServerProcess']]:
        """
        A collection of server process configurations that describe which server processes to run on each instance in a fleet.
        """
        return pulumi.get(self, "server_processes")


@pulumi.output_type
class FleetScalingPolicy(dict):
    """
    Rule that controls how a fleet is scaled. Scaling policies are uniquely identified by the combination of name and fleet ID.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metricName":
            suggest = "metric_name"
        elif key == "comparisonOperator":
            suggest = "comparison_operator"
        elif key == "evaluationPeriods":
            suggest = "evaluation_periods"
        elif key == "policyType":
            suggest = "policy_type"
        elif key == "scalingAdjustment":
            suggest = "scaling_adjustment"
        elif key == "scalingAdjustmentType":
            suggest = "scaling_adjustment_type"
        elif key == "targetConfiguration":
            suggest = "target_configuration"
        elif key == "updateStatus":
            suggest = "update_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FleetScalingPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FleetScalingPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FleetScalingPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 metric_name: 'FleetScalingPolicyMetricName',
                 name: str,
                 comparison_operator: Optional['FleetScalingPolicyComparisonOperator'] = None,
                 evaluation_periods: Optional[int] = None,
                 location: Optional[str] = None,
                 policy_type: Optional['FleetScalingPolicyPolicyType'] = None,
                 scaling_adjustment: Optional[int] = None,
                 scaling_adjustment_type: Optional['FleetScalingPolicyScalingAdjustmentType'] = None,
                 status: Optional['FleetScalingPolicyStatus'] = None,
                 target_configuration: Optional['outputs.FleetTargetConfiguration'] = None,
                 threshold: Optional[float] = None,
                 update_status: Optional['FleetScalingPolicyUpdateStatus'] = None):
        """
        Rule that controls how a fleet is scaled. Scaling policies are uniquely identified by the combination of name and fleet ID.
        :param 'FleetScalingPolicyMetricName' metric_name: Name of the Amazon GameLift-defined metric that is used to trigger a scaling adjustment.
        :param str name: A descriptive label that is associated with a fleet's scaling policy. Policy names do not need to be unique.
        :param 'FleetScalingPolicyComparisonOperator' comparison_operator: Comparison operator to use when measuring a metric against the threshold value.
        :param int evaluation_periods: Length of time (in minutes) the metric must be at or beyond the threshold before a scaling event is triggered.
        :param str location: The fleet location.
        :param 'FleetScalingPolicyPolicyType' policy_type: The type of scaling policy to create. For a target-based policy, set the parameter MetricName to 'PercentAvailableGameSessions' and specify a TargetConfiguration. For a rule-based policy set the following parameters: MetricName, ComparisonOperator, Threshold, EvaluationPeriods, ScalingAdjustmentType, and ScalingAdjustment.
        :param int scaling_adjustment: Amount of adjustment to make, based on the scaling adjustment type.
        :param 'FleetScalingPolicyScalingAdjustmentType' scaling_adjustment_type: The type of adjustment to make to a fleet's instance count.
        :param 'FleetScalingPolicyStatus' status: Current status of the scaling policy. The scaling policy can be in force only when in an ACTIVE status. Scaling policies can be suspended for individual fleets. If the policy is suspended for a fleet, the policy status does not change.
        :param 'FleetTargetConfiguration' target_configuration: An object that contains settings for a target-based scaling policy.
        :param float threshold: Metric value used to trigger a scaling event.
        :param 'FleetScalingPolicyUpdateStatus' update_status: The current status of the fleet's scaling policies in a requested fleet location. The status PENDING_UPDATE indicates that an update was requested for the fleet but has not yet been completed for the location.
        """
        pulumi.set(__self__, "metric_name", metric_name)
        pulumi.set(__self__, "name", name)
        if comparison_operator is not None:
            pulumi.set(__self__, "comparison_operator", comparison_operator)
        if evaluation_periods is not None:
            pulumi.set(__self__, "evaluation_periods", evaluation_periods)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if policy_type is not None:
            pulumi.set(__self__, "policy_type", policy_type)
        if scaling_adjustment is not None:
            pulumi.set(__self__, "scaling_adjustment", scaling_adjustment)
        if scaling_adjustment_type is not None:
            pulumi.set(__self__, "scaling_adjustment_type", scaling_adjustment_type)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if target_configuration is not None:
            pulumi.set(__self__, "target_configuration", target_configuration)
        if threshold is not None:
            pulumi.set(__self__, "threshold", threshold)
        if update_status is not None:
            pulumi.set(__self__, "update_status", update_status)

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> 'FleetScalingPolicyMetricName':
        """
        Name of the Amazon GameLift-defined metric that is used to trigger a scaling adjustment.
        """
        return pulumi.get(self, "metric_name")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A descriptive label that is associated with a fleet's scaling policy. Policy names do not need to be unique.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="comparisonOperator")
    def comparison_operator(self) -> Optional['FleetScalingPolicyComparisonOperator']:
        """
        Comparison operator to use when measuring a metric against the threshold value.
        """
        return pulumi.get(self, "comparison_operator")

    @property
    @pulumi.getter(name="evaluationPeriods")
    def evaluation_periods(self) -> Optional[int]:
        """
        Length of time (in minutes) the metric must be at or beyond the threshold before a scaling event is triggered.
        """
        return pulumi.get(self, "evaluation_periods")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        The fleet location.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="policyType")
    def policy_type(self) -> Optional['FleetScalingPolicyPolicyType']:
        """
        The type of scaling policy to create. For a target-based policy, set the parameter MetricName to 'PercentAvailableGameSessions' and specify a TargetConfiguration. For a rule-based policy set the following parameters: MetricName, ComparisonOperator, Threshold, EvaluationPeriods, ScalingAdjustmentType, and ScalingAdjustment.
        """
        return pulumi.get(self, "policy_type")

    @property
    @pulumi.getter(name="scalingAdjustment")
    def scaling_adjustment(self) -> Optional[int]:
        """
        Amount of adjustment to make, based on the scaling adjustment type.
        """
        return pulumi.get(self, "scaling_adjustment")

    @property
    @pulumi.getter(name="scalingAdjustmentType")
    def scaling_adjustment_type(self) -> Optional['FleetScalingPolicyScalingAdjustmentType']:
        """
        The type of adjustment to make to a fleet's instance count.
        """
        return pulumi.get(self, "scaling_adjustment_type")

    @property
    @pulumi.getter
    def status(self) -> Optional['FleetScalingPolicyStatus']:
        """
        Current status of the scaling policy. The scaling policy can be in force only when in an ACTIVE status. Scaling policies can be suspended for individual fleets. If the policy is suspended for a fleet, the policy status does not change.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="targetConfiguration")
    def target_configuration(self) -> Optional['outputs.FleetTargetConfiguration']:
        """
        An object that contains settings for a target-based scaling policy.
        """
        return pulumi.get(self, "target_configuration")

    @property
    @pulumi.getter
    def threshold(self) -> Optional[float]:
        """
        Metric value used to trigger a scaling event.
        """
        return pulumi.get(self, "threshold")

    @property
    @pulumi.getter(name="updateStatus")
    def update_status(self) -> Optional['FleetScalingPolicyUpdateStatus']:
        """
        The current status of the fleet's scaling policies in a requested fleet location. The status PENDING_UPDATE indicates that an update was requested for the fleet but has not yet been completed for the location.
        """
        return pulumi.get(self, "update_status")


@pulumi.output_type
class FleetServerProcess(dict):
    """
    A set of instructions for launching server processes on each instance in a fleet. Each instruction set identifies the location of the server executable, optional launch parameters, and the number of server processes with this configuration to maintain concurrently on the instance. Server process configurations make up a fleet's RuntimeConfiguration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "concurrentExecutions":
            suggest = "concurrent_executions"
        elif key == "launchPath":
            suggest = "launch_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FleetServerProcess. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FleetServerProcess.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FleetServerProcess.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 concurrent_executions: int,
                 launch_path: str,
                 parameters: Optional[str] = None):
        """
        A set of instructions for launching server processes on each instance in a fleet. Each instruction set identifies the location of the server executable, optional launch parameters, and the number of server processes with this configuration to maintain concurrently on the instance. Server process configurations make up a fleet's RuntimeConfiguration.
        :param int concurrent_executions: The number of server processes that use this configuration to run concurrently on an instance.
        :param str launch_path: The location of the server executable in a custom game build or the name of the Realtime script file that contains the Init() function. Game builds and Realtime scripts are installed on instances at the root:
               
               Windows (for custom game builds only): C:\\game. Example: "C:\\game\\MyGame\\server.exe"
               
               Linux: /local/game. Examples: "/local/game/MyGame/server.exe" or "/local/game/MyRealtimeScript.js"
        :param str parameters: An optional list of parameters to pass to the server executable or Realtime script on launch.
        """
        pulumi.set(__self__, "concurrent_executions", concurrent_executions)
        pulumi.set(__self__, "launch_path", launch_path)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter(name="concurrentExecutions")
    def concurrent_executions(self) -> int:
        """
        The number of server processes that use this configuration to run concurrently on an instance.
        """
        return pulumi.get(self, "concurrent_executions")

    @property
    @pulumi.getter(name="launchPath")
    def launch_path(self) -> str:
        """
        The location of the server executable in a custom game build or the name of the Realtime script file that contains the Init() function. Game builds and Realtime scripts are installed on instances at the root:

        Windows (for custom game builds only): C:\\game. Example: "C:\\game\\MyGame\\server.exe"

        Linux: /local/game. Examples: "/local/game/MyGame/server.exe" or "/local/game/MyRealtimeScript.js"
        """
        return pulumi.get(self, "launch_path")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[str]:
        """
        An optional list of parameters to pass to the server executable or Realtime script on launch.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class FleetTargetConfiguration(dict):
    """
    Settings for a target-based scaling policy. A target-based policy tracks a particular fleet metric specifies a target value for the metric. As player usage changes, the policy triggers Amazon GameLift to adjust capacity so that the metric returns to the target value. The target configuration specifies settings as needed for the target based policy, including the target value.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetValue":
            suggest = "target_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FleetTargetConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FleetTargetConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FleetTargetConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_value: float):
        """
        Settings for a target-based scaling policy. A target-based policy tracks a particular fleet metric specifies a target value for the metric. As player usage changes, the policy triggers Amazon GameLift to adjust capacity so that the metric returns to the target value. The target configuration specifies settings as needed for the target based policy, including the target value.
        :param float target_value: Desired value to use with a target-based scaling policy. The value must be relevant for whatever metric the scaling policy is using. For example, in a policy using the metric PercentAvailableGameSessions, the target value should be the preferred size of the fleet's buffer (the percent of capacity that should be idle and ready for new game sessions).
        """
        pulumi.set(__self__, "target_value", target_value)

    @property
    @pulumi.getter(name="targetValue")
    def target_value(self) -> float:
        """
        Desired value to use with a target-based scaling policy. The value must be relevant for whatever metric the scaling policy is using. For example, in a policy using the metric PercentAvailableGameSessions, the target value should be the preferred size of the fleet's buffer (the percent of capacity that should be idle and ready for new game sessions).
        """
        return pulumi.get(self, "target_value")


@pulumi.output_type
class GameServerGroupAutoScalingPolicy(dict):
    """
    Configuration settings to define a scaling policy for the Auto Scaling group that is optimized for game hosting. Updating this game server group property will not take effect for the created EC2 Auto Scaling group, please update the EC2 Auto Scaling group directly after creating the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetTrackingConfiguration":
            suggest = "target_tracking_configuration"
        elif key == "estimatedInstanceWarmup":
            suggest = "estimated_instance_warmup"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GameServerGroupAutoScalingPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GameServerGroupAutoScalingPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GameServerGroupAutoScalingPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_tracking_configuration: 'outputs.GameServerGroupTargetTrackingConfiguration',
                 estimated_instance_warmup: Optional[float] = None):
        """
        Configuration settings to define a scaling policy for the Auto Scaling group that is optimized for game hosting. Updating this game server group property will not take effect for the created EC2 Auto Scaling group, please update the EC2 Auto Scaling group directly after creating the resource.
        :param 'GameServerGroupTargetTrackingConfiguration' target_tracking_configuration: Settings for a target-based scaling policy applied to Auto Scaling group. These settings are used to create a target-based policy that tracks the GameLift FleetIQ metric `PercentUtilizedGameServers` and specifies a target value for the metric. As player usage changes, the policy triggers to adjust the game server group capacity so that the metric returns to the target value.
        :param float estimated_instance_warmup: Length of time, in seconds, it takes for a new instance to start new game server processes and register with Amazon GameLift FleetIQ. Specifying a warm-up time can be useful, particularly with game servers that take a long time to start up, because it avoids prematurely starting new instances.
        """
        pulumi.set(__self__, "target_tracking_configuration", target_tracking_configuration)
        if estimated_instance_warmup is not None:
            pulumi.set(__self__, "estimated_instance_warmup", estimated_instance_warmup)

    @property
    @pulumi.getter(name="targetTrackingConfiguration")
    def target_tracking_configuration(self) -> 'outputs.GameServerGroupTargetTrackingConfiguration':
        """
        Settings for a target-based scaling policy applied to Auto Scaling group. These settings are used to create a target-based policy that tracks the GameLift FleetIQ metric `PercentUtilizedGameServers` and specifies a target value for the metric. As player usage changes, the policy triggers to adjust the game server group capacity so that the metric returns to the target value.
        """
        return pulumi.get(self, "target_tracking_configuration")

    @property
    @pulumi.getter(name="estimatedInstanceWarmup")
    def estimated_instance_warmup(self) -> Optional[float]:
        """
        Length of time, in seconds, it takes for a new instance to start new game server processes and register with Amazon GameLift FleetIQ. Specifying a warm-up time can be useful, particularly with game servers that take a long time to start up, because it avoids prematurely starting new instances.
        """
        return pulumi.get(self, "estimated_instance_warmup")


@pulumi.output_type
class GameServerGroupInstanceDefinition(dict):
    """
    An allowed instance type for your game server group.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceType":
            suggest = "instance_type"
        elif key == "weightedCapacity":
            suggest = "weighted_capacity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GameServerGroupInstanceDefinition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GameServerGroupInstanceDefinition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GameServerGroupInstanceDefinition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_type: str,
                 weighted_capacity: Optional[str] = None):
        """
        An allowed instance type for your game server group.
        """
        pulumi.set(__self__, "instance_type", instance_type)
        if weighted_capacity is not None:
            pulumi.set(__self__, "weighted_capacity", weighted_capacity)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="weightedCapacity")
    def weighted_capacity(self) -> Optional[str]:
        return pulumi.get(self, "weighted_capacity")


@pulumi.output_type
class GameServerGroupLaunchTemplate(dict):
    """
    The EC2 launch template that contains configuration settings and game server code to be deployed to all instances in the game server group. Updating this game server group property will not take effect for the created EC2 Auto Scaling group, please update the EC2 Auto Scaling group directly after creating the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "launchTemplateId":
            suggest = "launch_template_id"
        elif key == "launchTemplateName":
            suggest = "launch_template_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GameServerGroupLaunchTemplate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GameServerGroupLaunchTemplate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GameServerGroupLaunchTemplate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 launch_template_id: Optional[str] = None,
                 launch_template_name: Optional[str] = None,
                 version: Optional[str] = None):
        """
        The EC2 launch template that contains configuration settings and game server code to be deployed to all instances in the game server group. Updating this game server group property will not take effect for the created EC2 Auto Scaling group, please update the EC2 Auto Scaling group directly after creating the resource.
        :param str launch_template_id: A unique identifier for an existing Amazon EC2 launch template.
        :param str launch_template_name: A readable identifier for an existing Amazon EC2 launch template.
        :param str version: The version of the Amazon EC2 launch template to use. If no version is specified, the default version will be used. With Amazon EC2, you can specify a default version for a launch template. If none is set, the default is the first version created.
        """
        if launch_template_id is not None:
            pulumi.set(__self__, "launch_template_id", launch_template_id)
        if launch_template_name is not None:
            pulumi.set(__self__, "launch_template_name", launch_template_name)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="launchTemplateId")
    def launch_template_id(self) -> Optional[str]:
        """
        A unique identifier for an existing Amazon EC2 launch template.
        """
        return pulumi.get(self, "launch_template_id")

    @property
    @pulumi.getter(name="launchTemplateName")
    def launch_template_name(self) -> Optional[str]:
        """
        A readable identifier for an existing Amazon EC2 launch template.
        """
        return pulumi.get(self, "launch_template_name")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        The version of the Amazon EC2 launch template to use. If no version is specified, the default version will be used. With Amazon EC2, you can specify a default version for a launch template. If none is set, the default is the first version created.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GameServerGroupTargetTrackingConfiguration(dict):
    """
    Settings for a target-based scaling policy applied to Auto Scaling group.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetValue":
            suggest = "target_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GameServerGroupTargetTrackingConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GameServerGroupTargetTrackingConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GameServerGroupTargetTrackingConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_value: float):
        """
        Settings for a target-based scaling policy applied to Auto Scaling group.
        :param float target_value: Desired value to use with a game server group target-based scaling policy.
        """
        pulumi.set(__self__, "target_value", target_value)

    @property
    @pulumi.getter(name="targetValue")
    def target_value(self) -> float:
        """
        Desired value to use with a game server group target-based scaling policy.
        """
        return pulumi.get(self, "target_value")


@pulumi.output_type
class GameSessionQueueDestination(dict):
    """
    A fleet or alias designated in a game session queue.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destinationArn":
            suggest = "destination_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GameSessionQueueDestination. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GameSessionQueueDestination.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GameSessionQueueDestination.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 destination_arn: Optional[str] = None):
        """
        A fleet or alias designated in a game session queue.
        :param str destination_arn: The Amazon Resource Name (ARN) that is assigned to fleet or fleet alias. ARNs, which include a fleet ID or alias ID and a Region name, provide a unique identifier across all Regions.
        """
        if destination_arn is not None:
            pulumi.set(__self__, "destination_arn", destination_arn)

    @property
    @pulumi.getter(name="destinationArn")
    def destination_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) that is assigned to fleet or fleet alias. ARNs, which include a fleet ID or alias ID and a Region name, provide a unique identifier across all Regions.
        """
        return pulumi.get(self, "destination_arn")


@pulumi.output_type
class GameSessionQueueFilterConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedLocations":
            suggest = "allowed_locations"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GameSessionQueueFilterConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GameSessionQueueFilterConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GameSessionQueueFilterConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_locations: Optional[Sequence[str]] = None):
        """
        :param Sequence[str] allowed_locations: A list of locations to allow game session placement in, in the form of AWS Region codes such as `us-west-2` .
        """
        if allowed_locations is not None:
            pulumi.set(__self__, "allowed_locations", allowed_locations)

    @property
    @pulumi.getter(name="allowedLocations")
    def allowed_locations(self) -> Optional[Sequence[str]]:
        """
        A list of locations to allow game session placement in, in the form of AWS Region codes such as `us-west-2` .
        """
        return pulumi.get(self, "allowed_locations")


@pulumi.output_type
class GameSessionQueuePlayerLatencyPolicy(dict):
    """
    Sets a latency cap for individual players when placing a game session.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maximumIndividualPlayerLatencyMilliseconds":
            suggest = "maximum_individual_player_latency_milliseconds"
        elif key == "policyDurationSeconds":
            suggest = "policy_duration_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GameSessionQueuePlayerLatencyPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GameSessionQueuePlayerLatencyPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GameSessionQueuePlayerLatencyPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 maximum_individual_player_latency_milliseconds: Optional[int] = None,
                 policy_duration_seconds: Optional[int] = None):
        """
        Sets a latency cap for individual players when placing a game session.
        :param int maximum_individual_player_latency_milliseconds: The maximum latency value that is allowed for any player, in milliseconds. All policies must have a value set for this property.
        :param int policy_duration_seconds: The length of time, in seconds, that the policy is enforced while placing a new game session.
        """
        if maximum_individual_player_latency_milliseconds is not None:
            pulumi.set(__self__, "maximum_individual_player_latency_milliseconds", maximum_individual_player_latency_milliseconds)
        if policy_duration_seconds is not None:
            pulumi.set(__self__, "policy_duration_seconds", policy_duration_seconds)

    @property
    @pulumi.getter(name="maximumIndividualPlayerLatencyMilliseconds")
    def maximum_individual_player_latency_milliseconds(self) -> Optional[int]:
        """
        The maximum latency value that is allowed for any player, in milliseconds. All policies must have a value set for this property.
        """
        return pulumi.get(self, "maximum_individual_player_latency_milliseconds")

    @property
    @pulumi.getter(name="policyDurationSeconds")
    def policy_duration_seconds(self) -> Optional[int]:
        """
        The length of time, in seconds, that the policy is enforced while placing a new game session.
        """
        return pulumi.get(self, "policy_duration_seconds")


@pulumi.output_type
class GameSessionQueuePriorityConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "locationOrder":
            suggest = "location_order"
        elif key == "priorityOrder":
            suggest = "priority_order"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GameSessionQueuePriorityConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GameSessionQueuePriorityConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GameSessionQueuePriorityConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 location_order: Optional[Sequence[str]] = None,
                 priority_order: Optional[Sequence['GameSessionQueuePriorityOrderItem']] = None):
        """
        :param Sequence[str] location_order: The prioritization order to use for fleet locations, when the `PriorityOrder` property includes `LOCATION` . Locations are identified by AWS Region codes such as `us-west-2` . Each location can only be listed once.
        :param Sequence['GameSessionQueuePriorityOrderItem'] priority_order: The recommended sequence to use when prioritizing where to place new game sessions. Each type can only be listed once.
               
               - `LATENCY` -- FleetIQ prioritizes locations where the average player latency (provided in each game session request) is lowest.
               - `COST` -- FleetIQ prioritizes destinations with the lowest current hosting costs. Cost is evaluated based on the location, instance type, and fleet type (Spot or On-Demand) for each destination in the queue.
               - `DESTINATION` -- FleetIQ prioritizes based on the order that destinations are listed in the queue configuration.
               - `LOCATION` -- FleetIQ prioritizes based on the provided order of locations, as defined in `LocationOrder` .
        """
        if location_order is not None:
            pulumi.set(__self__, "location_order", location_order)
        if priority_order is not None:
            pulumi.set(__self__, "priority_order", priority_order)

    @property
    @pulumi.getter(name="locationOrder")
    def location_order(self) -> Optional[Sequence[str]]:
        """
        The prioritization order to use for fleet locations, when the `PriorityOrder` property includes `LOCATION` . Locations are identified by AWS Region codes such as `us-west-2` . Each location can only be listed once.
        """
        return pulumi.get(self, "location_order")

    @property
    @pulumi.getter(name="priorityOrder")
    def priority_order(self) -> Optional[Sequence['GameSessionQueuePriorityOrderItem']]:
        """
        The recommended sequence to use when prioritizing where to place new game sessions. Each type can only be listed once.

        - `LATENCY` -- FleetIQ prioritizes locations where the average player latency (provided in each game session request) is lowest.
        - `COST` -- FleetIQ prioritizes destinations with the lowest current hosting costs. Cost is evaluated based on the location, instance type, and fleet type (Spot or On-Demand) for each destination in the queue.
        - `DESTINATION` -- FleetIQ prioritizes based on the order that destinations are listed in the queue configuration.
        - `LOCATION` -- FleetIQ prioritizes based on the provided order of locations, as defined in `LocationOrder` .
        """
        return pulumi.get(self, "priority_order")


@pulumi.output_type
class MatchmakingConfigurationGameProperty(dict):
    """
    A key-value pair that contains information about a game session.
    """
    def __init__(__self__, *,
                 key: str,
                 value: str):
        """
        A key-value pair that contains information about a game session.
        :param str key: The game property identifier.
        :param str value: The game property value.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The game property identifier.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The game property value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ScriptS3Location(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "roleArn":
            suggest = "role_arn"
        elif key == "objectVersion":
            suggest = "object_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScriptS3Location. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScriptS3Location.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScriptS3Location.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket: str,
                 key: str,
                 role_arn: str,
                 object_version: Optional[str] = None):
        """
        :param str bucket: An Amazon S3 bucket identifier. This is the name of the S3 bucket.
        :param str key: The name of the zip file that contains the script files.
        :param str role_arn: The Amazon Resource Name (ARN) for an IAM role that allows Amazon GameLift to access the S3 bucket.
        :param str object_version: The version of the file, if object versioning is turned on for the bucket. Amazon GameLift uses this information when retrieving files from your S3 bucket. To retrieve a specific version of the file, provide an object version. To retrieve the latest version of the file, do not set this parameter.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "role_arn", role_arn)
        if object_version is not None:
            pulumi.set(__self__, "object_version", object_version)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        An Amazon S3 bucket identifier. This is the name of the S3 bucket.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The name of the zip file that contains the script files.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> str:
        """
        The Amazon Resource Name (ARN) for an IAM role that allows Amazon GameLift to access the S3 bucket.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="objectVersion")
    def object_version(self) -> Optional[str]:
        """
        The version of the file, if object versioning is turned on for the bucket. Amazon GameLift uses this information when retrieving files from your S3 bucket. To retrieve a specific version of the file, provide an object version. To retrieve the latest version of the file, do not set this parameter.
        """
        return pulumi.get(self, "object_version")


