# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs

__all__ = [
    'GetScriptResult',
    'AwaitableGetScriptResult',
    'get_script',
    'get_script_output',
]

@pulumi.output_type
class GetScriptResult:
    def __init__(__self__, arn=None, creation_time=None, id=None, name=None, size_on_disk=None, storage_location=None, tags=None, version=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if creation_time and not isinstance(creation_time, str):
            raise TypeError("Expected argument 'creation_time' to be a str")
        pulumi.set(__self__, "creation_time", creation_time)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if size_on_disk and not isinstance(size_on_disk, int):
            raise TypeError("Expected argument 'size_on_disk' to be a int")
        pulumi.set(__self__, "size_on_disk", size_on_disk)
        if storage_location and not isinstance(storage_location, dict):
            raise TypeError("Expected argument 'storage_location' to be a dict")
        pulumi.set(__self__, "storage_location", storage_location)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) that is assigned to a Amazon GameLift script resource and uniquely identifies it. ARNs are unique across all Regions. In a GameLift script ARN, the resource ID matches the Id value.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[str]:
        """
        A time stamp indicating when this data object was created. Format is a number expressed in Unix time as milliseconds (for example "1469498468.057").
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        A unique identifier for the Realtime script
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        A descriptive label that is associated with a script. Script names do not need to be unique.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="sizeOnDisk")
    def size_on_disk(self) -> Optional[int]:
        """
        The file size of the uploaded Realtime script, expressed in bytes. When files are uploaded from an S3 location, this value remains at "0".
        """
        return pulumi.get(self, "size_on_disk")

    @property
    @pulumi.getter(name="storageLocation")
    def storage_location(self) -> Optional['outputs.ScriptS3Location']:
        """
        The location of the Amazon S3 bucket where a zipped file containing your Realtime scripts is stored. The storage location must specify the Amazon S3 bucket name, the zip file name (the "key"), and a role ARN that allows Amazon GameLift to access the Amazon S3 storage location. The S3 bucket must be in the same Region where you want to create a new script. By default, Amazon GameLift uploads the latest version of the zip file; if you have S3 object versioning turned on, you can use the ObjectVersion parameter to specify an earlier version.
        """
        return pulumi.get(self, "storage_location")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        The version that is associated with a script. Version strings do not need to be unique.
        """
        return pulumi.get(self, "version")


class AwaitableGetScriptResult(GetScriptResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetScriptResult(
            arn=self.arn,
            creation_time=self.creation_time,
            id=self.id,
            name=self.name,
            size_on_disk=self.size_on_disk,
            storage_location=self.storage_location,
            tags=self.tags,
            version=self.version)


def get_script(id: Optional[str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetScriptResult:
    """
    The AWS::GameLift::Script resource creates a new script record for your Realtime Servers script. Realtime scripts are JavaScript that provide configuration settings and optional custom game logic for your game. The script is deployed when you create a Realtime Servers fleet to host your game sessions. Script logic is executed during an active game session.


    :param str id: A unique identifier for the Realtime script
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:gamelift:getScript', __args__, opts=opts, typ=GetScriptResult).value

    return AwaitableGetScriptResult(
        arn=pulumi.get(__ret__, 'arn'),
        creation_time=pulumi.get(__ret__, 'creation_time'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        size_on_disk=pulumi.get(__ret__, 'size_on_disk'),
        storage_location=pulumi.get(__ret__, 'storage_location'),
        tags=pulumi.get(__ret__, 'tags'),
        version=pulumi.get(__ret__, 'version'))
def get_script_output(id: Optional[pulumi.Input[str]] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetScriptResult]:
    """
    The AWS::GameLift::Script resource creates a new script record for your Realtime Servers script. Realtime scripts are JavaScript that provide configuration settings and optional custom game logic for your game. The script is deployed when you create a Realtime Servers fleet to host your game sessions. Script logic is executed during an active game session.


    :param str id: A unique identifier for the Realtime script
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:gamelift:getScript', __args__, opts=opts, typ=GetScriptResult)
    return __ret__.apply(lambda __response__: GetScriptResult(
        arn=pulumi.get(__response__, 'arn'),
        creation_time=pulumi.get(__response__, 'creation_time'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        size_on_disk=pulumi.get(__response__, 'size_on_disk'),
        storage_location=pulumi.get(__response__, 'storage_location'),
        tags=pulumi.get(__response__, 'tags'),
        version=pulumi.get(__response__, 'version')))
