# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'DetectorEntityTypeArgs',
    'DetectorEntityTypeArgsDict',
    'DetectorEventTypeArgs',
    'DetectorEventTypeArgsDict',
    'DetectorEventVariableArgs',
    'DetectorEventVariableArgsDict',
    'DetectorLabelArgs',
    'DetectorLabelArgsDict',
    'DetectorModelArgs',
    'DetectorModelArgsDict',
    'DetectorOutcomeArgs',
    'DetectorOutcomeArgsDict',
    'DetectorRuleArgs',
    'DetectorRuleArgsDict',
    'DetectorTagArgs',
    'DetectorTagArgsDict',
    'EventTypeEntityTypeArgs',
    'EventTypeEntityTypeArgsDict',
    'EventTypeEventVariableArgs',
    'EventTypeEventVariableArgsDict',
    'EventTypeLabelArgs',
    'EventTypeLabelArgsDict',
    'EventTypeTagArgs',
    'EventTypeTagArgsDict',
]

MYPY = False

if not MYPY:
    class DetectorEntityTypeArgsDict(TypedDict):
        arn: NotRequired[pulumi.Input[str]]
        """
        The entity type ARN.
        """
        created_time: NotRequired[pulumi.Input[str]]
        """
        The time when the entity type was created.
        """
        description: NotRequired[pulumi.Input[str]]
        """
        The description.
        """
        inline: NotRequired[pulumi.Input[bool]]
        """
        Indicates whether the resource is defined within this CloudFormation template and impacts the create, update, and delete behavior of the stack. If the value is `true` , CloudFormation will create/update/delete the resource when creating/updating/deleting the stack. If the value is `false` , CloudFormation will validate that the object exists and then use it within the resource without making changes to the object.

        For example, when creating `AWS::FraudDetector::Detector` you must define at least two variables. You can set `Inline=true` for these Variables and CloudFormation will create/update/delete the variables as part of stack operations. However, if you set `Inline=false` , CloudFormation will associate the variables to your detector but not execute any changes to the variables.
        """
        last_updated_time: NotRequired[pulumi.Input[str]]
        """
        The time when the entity type was last updated.
        """
        name: NotRequired[pulumi.Input[str]]
        """
        The entity type name.
        """
        tags: NotRequired[pulumi.Input[Sequence[pulumi.Input['DetectorTagArgsDict']]]]
        """
        Tags associated with this entity type.
        """
elif False:
    DetectorEntityTypeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DetectorEntityTypeArgs:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None,
                 created_time: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 inline: Optional[pulumi.Input[bool]] = None,
                 last_updated_time: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['DetectorTagArgs']]]] = None):
        """
        :param pulumi.Input[str] arn: The entity type ARN.
        :param pulumi.Input[str] created_time: The time when the entity type was created.
        :param pulumi.Input[str] description: The description.
        :param pulumi.Input[bool] inline: Indicates whether the resource is defined within this CloudFormation template and impacts the create, update, and delete behavior of the stack. If the value is `true` , CloudFormation will create/update/delete the resource when creating/updating/deleting the stack. If the value is `false` , CloudFormation will validate that the object exists and then use it within the resource without making changes to the object.
               
               For example, when creating `AWS::FraudDetector::Detector` you must define at least two variables. You can set `Inline=true` for these Variables and CloudFormation will create/update/delete the variables as part of stack operations. However, if you set `Inline=false` , CloudFormation will associate the variables to your detector but not execute any changes to the variables.
        :param pulumi.Input[str] last_updated_time: The time when the entity type was last updated.
        :param pulumi.Input[str] name: The entity type name.
        :param pulumi.Input[Sequence[pulumi.Input['DetectorTagArgs']]] tags: Tags associated with this entity type.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if created_time is not None:
            pulumi.set(__self__, "created_time", created_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if inline is not None:
            pulumi.set(__self__, "inline", inline)
        if last_updated_time is not None:
            pulumi.set(__self__, "last_updated_time", last_updated_time)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        The entity type ARN.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time when the entity type was created.
        """
        return pulumi.get(self, "created_time")

    @created_time.setter
    def created_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_time", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def inline(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether the resource is defined within this CloudFormation template and impacts the create, update, and delete behavior of the stack. If the value is `true` , CloudFormation will create/update/delete the resource when creating/updating/deleting the stack. If the value is `false` , CloudFormation will validate that the object exists and then use it within the resource without making changes to the object.

        For example, when creating `AWS::FraudDetector::Detector` you must define at least two variables. You can set `Inline=true` for these Variables and CloudFormation will create/update/delete the variables as part of stack operations. However, if you set `Inline=false` , CloudFormation will associate the variables to your detector but not execute any changes to the variables.
        """
        return pulumi.get(self, "inline")

    @inline.setter
    def inline(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "inline", value)

    @property
    @pulumi.getter(name="lastUpdatedTime")
    def last_updated_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time when the entity type was last updated.
        """
        return pulumi.get(self, "last_updated_time")

    @last_updated_time.setter
    def last_updated_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_updated_time", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The entity type name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DetectorTagArgs']]]]:
        """
        Tags associated with this entity type.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DetectorTagArgs']]]]):
        pulumi.set(self, "tags", value)


if not MYPY:
    class DetectorEventTypeArgsDict(TypedDict):
        arn: NotRequired[pulumi.Input[str]]
        """
        The ARN of the event type.
        """
        created_time: NotRequired[pulumi.Input[str]]
        """
        The time when the event type was created.
        """
        description: NotRequired[pulumi.Input[str]]
        """
        The description of the event type.
        """
        entity_types: NotRequired[pulumi.Input[Sequence[pulumi.Input['DetectorEntityTypeArgsDict']]]]
        """
        The event type entity types.
        """
        event_variables: NotRequired[pulumi.Input[Sequence[pulumi.Input['DetectorEventVariableArgsDict']]]]
        """
        The event type event variables.
        """
        inline: NotRequired[pulumi.Input[bool]]
        """
        Indicates whether the resource is defined within this CloudFormation template and impacts the create, update, and delete behavior of the stack. If the value is `true` , CloudFormation will create/update/delete the resource when creating/updating/deleting the stack. If the value is `false` , CloudFormation will validate that the object exists and then use it within the resource without making changes to the object.

        For example, when creating `AWS::FraudDetector::Detector` you must define at least two variables. You can set `Inline=true` for these variables and CloudFormation will create/update/delete the Variables as part of stack operations. However, if you set `Inline=false` , CloudFormation will associate the variables to your detector but not execute any changes to the variables.
        """
        labels: NotRequired[pulumi.Input[Sequence[pulumi.Input['DetectorLabelArgsDict']]]]
        """
        The event type labels.
        """
        last_updated_time: NotRequired[pulumi.Input[str]]
        """
        The time when the event type was last updated.
        """
        name: NotRequired[pulumi.Input[str]]
        """
        The name for the event type
        """
        tags: NotRequired[pulumi.Input[Sequence[pulumi.Input['DetectorTagArgsDict']]]]
        """
        Tags associated with this event type.
        """
elif False:
    DetectorEventTypeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DetectorEventTypeArgs:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None,
                 created_time: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 entity_types: Optional[pulumi.Input[Sequence[pulumi.Input['DetectorEntityTypeArgs']]]] = None,
                 event_variables: Optional[pulumi.Input[Sequence[pulumi.Input['DetectorEventVariableArgs']]]] = None,
                 inline: Optional[pulumi.Input[bool]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input['DetectorLabelArgs']]]] = None,
                 last_updated_time: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['DetectorTagArgs']]]] = None):
        """
        :param pulumi.Input[str] arn: The ARN of the event type.
        :param pulumi.Input[str] created_time: The time when the event type was created.
        :param pulumi.Input[str] description: The description of the event type.
        :param pulumi.Input[Sequence[pulumi.Input['DetectorEntityTypeArgs']]] entity_types: The event type entity types.
        :param pulumi.Input[Sequence[pulumi.Input['DetectorEventVariableArgs']]] event_variables: The event type event variables.
        :param pulumi.Input[bool] inline: Indicates whether the resource is defined within this CloudFormation template and impacts the create, update, and delete behavior of the stack. If the value is `true` , CloudFormation will create/update/delete the resource when creating/updating/deleting the stack. If the value is `false` , CloudFormation will validate that the object exists and then use it within the resource without making changes to the object.
               
               For example, when creating `AWS::FraudDetector::Detector` you must define at least two variables. You can set `Inline=true` for these variables and CloudFormation will create/update/delete the Variables as part of stack operations. However, if you set `Inline=false` , CloudFormation will associate the variables to your detector but not execute any changes to the variables.
        :param pulumi.Input[Sequence[pulumi.Input['DetectorLabelArgs']]] labels: The event type labels.
        :param pulumi.Input[str] last_updated_time: The time when the event type was last updated.
        :param pulumi.Input[str] name: The name for the event type
        :param pulumi.Input[Sequence[pulumi.Input['DetectorTagArgs']]] tags: Tags associated with this event type.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if created_time is not None:
            pulumi.set(__self__, "created_time", created_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if entity_types is not None:
            pulumi.set(__self__, "entity_types", entity_types)
        if event_variables is not None:
            pulumi.set(__self__, "event_variables", event_variables)
        if inline is not None:
            pulumi.set(__self__, "inline", inline)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if last_updated_time is not None:
            pulumi.set(__self__, "last_updated_time", last_updated_time)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the event type.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time when the event type was created.
        """
        return pulumi.get(self, "created_time")

    @created_time.setter
    def created_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_time", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the event type.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="entityTypes")
    def entity_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DetectorEntityTypeArgs']]]]:
        """
        The event type entity types.
        """
        return pulumi.get(self, "entity_types")

    @entity_types.setter
    def entity_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DetectorEntityTypeArgs']]]]):
        pulumi.set(self, "entity_types", value)

    @property
    @pulumi.getter(name="eventVariables")
    def event_variables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DetectorEventVariableArgs']]]]:
        """
        The event type event variables.
        """
        return pulumi.get(self, "event_variables")

    @event_variables.setter
    def event_variables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DetectorEventVariableArgs']]]]):
        pulumi.set(self, "event_variables", value)

    @property
    @pulumi.getter
    def inline(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether the resource is defined within this CloudFormation template and impacts the create, update, and delete behavior of the stack. If the value is `true` , CloudFormation will create/update/delete the resource when creating/updating/deleting the stack. If the value is `false` , CloudFormation will validate that the object exists and then use it within the resource without making changes to the object.

        For example, when creating `AWS::FraudDetector::Detector` you must define at least two variables. You can set `Inline=true` for these variables and CloudFormation will create/update/delete the Variables as part of stack operations. However, if you set `Inline=false` , CloudFormation will associate the variables to your detector but not execute any changes to the variables.
        """
        return pulumi.get(self, "inline")

    @inline.setter
    def inline(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "inline", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DetectorLabelArgs']]]]:
        """
        The event type labels.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DetectorLabelArgs']]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="lastUpdatedTime")
    def last_updated_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time when the event type was last updated.
        """
        return pulumi.get(self, "last_updated_time")

    @last_updated_time.setter
    def last_updated_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_updated_time", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name for the event type
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DetectorTagArgs']]]]:
        """
        Tags associated with this event type.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DetectorTagArgs']]]]):
        pulumi.set(self, "tags", value)


if not MYPY:
    class DetectorEventVariableArgsDict(TypedDict):
        arn: NotRequired[pulumi.Input[str]]
        """
        The event variable ARN.
        """
        created_time: NotRequired[pulumi.Input[str]]
        """
        The time when the event variable was created.
        """
        data_source: NotRequired[pulumi.Input['DetectorEventVariableDataSource']]
        """
        The data source of the event variable.

        Valid values: `EVENT | EXTERNAL_MODEL_SCORE`

        When defining a variable within a detector, you can only use the `EVENT` value for DataSource when the *Inline* property is set to true. If the *Inline* property is set false, you can use either `EVENT` or `MODEL_SCORE` for DataSource.
        """
        data_type: NotRequired[pulumi.Input['DetectorEventVariableDataType']]
        """
        The data type of the event variable.

        Valid values: `STRING | INTEGER | BOOLEAN | FLOAT`
        """
        default_value: NotRequired[pulumi.Input[str]]
        """
        The default value of the event variable. This is required if you are providing the details of your variables instead of the ARN.
        """
        description: NotRequired[pulumi.Input[str]]
        """
        The description.
        """
        inline: NotRequired[pulumi.Input[bool]]
        """
        Indicates whether the resource is defined within this CloudFormation template and impacts the create, update, and delete behavior of the stack. If the value is `true` , CloudFormation will create/update/delete the resource when creating/updating/deleting the stack. If the value is `false` , CloudFormation will validate that the object exists and then use it within the resource without making changes to the object.

        For example, when creating `AWS::FraudDetector::Detector` you must define at least two variables. You can set `Inline=true` for these variables and CloudFormation will create/update/delete the variables as part of stack operations. However, if you set `Inline=false` , CloudFormation will associate the variables to your detector but not execute any changes to the variables.
        """
        last_updated_time: NotRequired[pulumi.Input[str]]
        """
        The time when the event variable was last updated.
        """
        name: NotRequired[pulumi.Input[str]]
        """
        The name of the event variable.
        """
        tags: NotRequired[pulumi.Input[Sequence[pulumi.Input['DetectorTagArgsDict']]]]
        """
        Tags associated with this event variable.
        """
        variable_type: NotRequired[pulumi.Input['DetectorEventVariableVariableType']]
        """
        The type of event variable. For more information, see [Variable types](https://docs.aws.amazon.com/frauddetector/latest/ug/create-a-variable.html#variable-types) .
        """
elif False:
    DetectorEventVariableArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DetectorEventVariableArgs:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None,
                 created_time: Optional[pulumi.Input[str]] = None,
                 data_source: Optional[pulumi.Input['DetectorEventVariableDataSource']] = None,
                 data_type: Optional[pulumi.Input['DetectorEventVariableDataType']] = None,
                 default_value: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 inline: Optional[pulumi.Input[bool]] = None,
                 last_updated_time: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['DetectorTagArgs']]]] = None,
                 variable_type: Optional[pulumi.Input['DetectorEventVariableVariableType']] = None):
        """
        :param pulumi.Input[str] arn: The event variable ARN.
        :param pulumi.Input[str] created_time: The time when the event variable was created.
        :param pulumi.Input['DetectorEventVariableDataSource'] data_source: The data source of the event variable.
               
               Valid values: `EVENT | EXTERNAL_MODEL_SCORE`
               
               When defining a variable within a detector, you can only use the `EVENT` value for DataSource when the *Inline* property is set to true. If the *Inline* property is set false, you can use either `EVENT` or `MODEL_SCORE` for DataSource.
        :param pulumi.Input['DetectorEventVariableDataType'] data_type: The data type of the event variable.
               
               Valid values: `STRING | INTEGER | BOOLEAN | FLOAT`
        :param pulumi.Input[str] default_value: The default value of the event variable. This is required if you are providing the details of your variables instead of the ARN.
        :param pulumi.Input[str] description: The description.
        :param pulumi.Input[bool] inline: Indicates whether the resource is defined within this CloudFormation template and impacts the create, update, and delete behavior of the stack. If the value is `true` , CloudFormation will create/update/delete the resource when creating/updating/deleting the stack. If the value is `false` , CloudFormation will validate that the object exists and then use it within the resource without making changes to the object.
               
               For example, when creating `AWS::FraudDetector::Detector` you must define at least two variables. You can set `Inline=true` for these variables and CloudFormation will create/update/delete the variables as part of stack operations. However, if you set `Inline=false` , CloudFormation will associate the variables to your detector but not execute any changes to the variables.
        :param pulumi.Input[str] last_updated_time: The time when the event variable was last updated.
        :param pulumi.Input[str] name: The name of the event variable.
        :param pulumi.Input[Sequence[pulumi.Input['DetectorTagArgs']]] tags: Tags associated with this event variable.
        :param pulumi.Input['DetectorEventVariableVariableType'] variable_type: The type of event variable. For more information, see [Variable types](https://docs.aws.amazon.com/frauddetector/latest/ug/create-a-variable.html#variable-types) .
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if created_time is not None:
            pulumi.set(__self__, "created_time", created_time)
        if data_source is not None:
            pulumi.set(__self__, "data_source", data_source)
        if data_type is not None:
            pulumi.set(__self__, "data_type", data_type)
        if default_value is not None:
            pulumi.set(__self__, "default_value", default_value)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if inline is not None:
            pulumi.set(__self__, "inline", inline)
        if last_updated_time is not None:
            pulumi.set(__self__, "last_updated_time", last_updated_time)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if variable_type is not None:
            pulumi.set(__self__, "variable_type", variable_type)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        The event variable ARN.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time when the event variable was created.
        """
        return pulumi.get(self, "created_time")

    @created_time.setter
    def created_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_time", value)

    @property
    @pulumi.getter(name="dataSource")
    def data_source(self) -> Optional[pulumi.Input['DetectorEventVariableDataSource']]:
        """
        The data source of the event variable.

        Valid values: `EVENT | EXTERNAL_MODEL_SCORE`

        When defining a variable within a detector, you can only use the `EVENT` value for DataSource when the *Inline* property is set to true. If the *Inline* property is set false, you can use either `EVENT` or `MODEL_SCORE` for DataSource.
        """
        return pulumi.get(self, "data_source")

    @data_source.setter
    def data_source(self, value: Optional[pulumi.Input['DetectorEventVariableDataSource']]):
        pulumi.set(self, "data_source", value)

    @property
    @pulumi.getter(name="dataType")
    def data_type(self) -> Optional[pulumi.Input['DetectorEventVariableDataType']]:
        """
        The data type of the event variable.

        Valid values: `STRING | INTEGER | BOOLEAN | FLOAT`
        """
        return pulumi.get(self, "data_type")

    @data_type.setter
    def data_type(self, value: Optional[pulumi.Input['DetectorEventVariableDataType']]):
        pulumi.set(self, "data_type", value)

    @property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> Optional[pulumi.Input[str]]:
        """
        The default value of the event variable. This is required if you are providing the details of your variables instead of the ARN.
        """
        return pulumi.get(self, "default_value")

    @default_value.setter
    def default_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_value", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def inline(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether the resource is defined within this CloudFormation template and impacts the create, update, and delete behavior of the stack. If the value is `true` , CloudFormation will create/update/delete the resource when creating/updating/deleting the stack. If the value is `false` , CloudFormation will validate that the object exists and then use it within the resource without making changes to the object.

        For example, when creating `AWS::FraudDetector::Detector` you must define at least two variables. You can set `Inline=true` for these variables and CloudFormation will create/update/delete the variables as part of stack operations. However, if you set `Inline=false` , CloudFormation will associate the variables to your detector but not execute any changes to the variables.
        """
        return pulumi.get(self, "inline")

    @inline.setter
    def inline(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "inline", value)

    @property
    @pulumi.getter(name="lastUpdatedTime")
    def last_updated_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time when the event variable was last updated.
        """
        return pulumi.get(self, "last_updated_time")

    @last_updated_time.setter
    def last_updated_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_updated_time", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the event variable.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DetectorTagArgs']]]]:
        """
        Tags associated with this event variable.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DetectorTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="variableType")
    def variable_type(self) -> Optional[pulumi.Input['DetectorEventVariableVariableType']]:
        """
        The type of event variable. For more information, see [Variable types](https://docs.aws.amazon.com/frauddetector/latest/ug/create-a-variable.html#variable-types) .
        """
        return pulumi.get(self, "variable_type")

    @variable_type.setter
    def variable_type(self, value: Optional[pulumi.Input['DetectorEventVariableVariableType']]):
        pulumi.set(self, "variable_type", value)


if not MYPY:
    class DetectorLabelArgsDict(TypedDict):
        arn: NotRequired[pulumi.Input[str]]
        """
        The label ARN.
        """
        created_time: NotRequired[pulumi.Input[str]]
        """
        The time when the label was created.
        """
        description: NotRequired[pulumi.Input[str]]
        """
        The description.
        """
        inline: NotRequired[pulumi.Input[bool]]
        """
        Indicates whether the resource is defined within this CloudFormation template and impacts the create, update, and delete behavior of the stack. If the value is `true` , CloudFormation will create/update/delete the resource when creating/updating/deleting the stack. If the value is `false` , CloudFormation will validate that the object exists and then use it within the resource without making changes to the object.

        For example, when creating `AWS::FraudDetector::Detector` you must define at least two variables. You can set `Inline=true` for these variables and CloudFormation will create/update/delete the variables as part of stack operations. However, if you set `Inline=false` , CloudFormation will associate the variables to your detector but not execute any changes to the variables.
        """
        last_updated_time: NotRequired[pulumi.Input[str]]
        """
        The time when the label was last updated.
        """
        name: NotRequired[pulumi.Input[str]]
        """
        The label name.
        """
        tags: NotRequired[pulumi.Input[Sequence[pulumi.Input['DetectorTagArgsDict']]]]
        """
        Tags associated with this label.
        """
elif False:
    DetectorLabelArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DetectorLabelArgs:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None,
                 created_time: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 inline: Optional[pulumi.Input[bool]] = None,
                 last_updated_time: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['DetectorTagArgs']]]] = None):
        """
        :param pulumi.Input[str] arn: The label ARN.
        :param pulumi.Input[str] created_time: The time when the label was created.
        :param pulumi.Input[str] description: The description.
        :param pulumi.Input[bool] inline: Indicates whether the resource is defined within this CloudFormation template and impacts the create, update, and delete behavior of the stack. If the value is `true` , CloudFormation will create/update/delete the resource when creating/updating/deleting the stack. If the value is `false` , CloudFormation will validate that the object exists and then use it within the resource without making changes to the object.
               
               For example, when creating `AWS::FraudDetector::Detector` you must define at least two variables. You can set `Inline=true` for these variables and CloudFormation will create/update/delete the variables as part of stack operations. However, if you set `Inline=false` , CloudFormation will associate the variables to your detector but not execute any changes to the variables.
        :param pulumi.Input[str] last_updated_time: The time when the label was last updated.
        :param pulumi.Input[str] name: The label name.
        :param pulumi.Input[Sequence[pulumi.Input['DetectorTagArgs']]] tags: Tags associated with this label.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if created_time is not None:
            pulumi.set(__self__, "created_time", created_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if inline is not None:
            pulumi.set(__self__, "inline", inline)
        if last_updated_time is not None:
            pulumi.set(__self__, "last_updated_time", last_updated_time)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        The label ARN.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time when the label was created.
        """
        return pulumi.get(self, "created_time")

    @created_time.setter
    def created_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_time", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def inline(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether the resource is defined within this CloudFormation template and impacts the create, update, and delete behavior of the stack. If the value is `true` , CloudFormation will create/update/delete the resource when creating/updating/deleting the stack. If the value is `false` , CloudFormation will validate that the object exists and then use it within the resource without making changes to the object.

        For example, when creating `AWS::FraudDetector::Detector` you must define at least two variables. You can set `Inline=true` for these variables and CloudFormation will create/update/delete the variables as part of stack operations. However, if you set `Inline=false` , CloudFormation will associate the variables to your detector but not execute any changes to the variables.
        """
        return pulumi.get(self, "inline")

    @inline.setter
    def inline(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "inline", value)

    @property
    @pulumi.getter(name="lastUpdatedTime")
    def last_updated_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time when the label was last updated.
        """
        return pulumi.get(self, "last_updated_time")

    @last_updated_time.setter
    def last_updated_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_updated_time", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The label name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DetectorTagArgs']]]]:
        """
        Tags associated with this label.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DetectorTagArgs']]]]):
        pulumi.set(self, "tags", value)


if not MYPY:
    class DetectorModelArgsDict(TypedDict):
        """
        A model to associate with a detector.
        """
        arn: NotRequired[pulumi.Input[str]]
        """
        The ARN of the model.
        """
elif False:
    DetectorModelArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DetectorModelArgs:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None):
        """
        A model to associate with a detector.
        :param pulumi.Input[str] arn: The ARN of the model.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the model.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)


if not MYPY:
    class DetectorOutcomeArgsDict(TypedDict):
        arn: NotRequired[pulumi.Input[str]]
        """
        The outcome ARN.
        """
        created_time: NotRequired[pulumi.Input[str]]
        """
        The time when the outcome was created.
        """
        description: NotRequired[pulumi.Input[str]]
        """
        The description.
        """
        inline: NotRequired[pulumi.Input[bool]]
        """
        Indicates whether the resource is defined within this CloudFormation template and impacts the create, update, and delete behavior of the stack. If the value is `true` , CloudFormation will create/update/delete the resource when creating/updating/deleting the stack. If the value is `false` , CloudFormation will validate that the object exists and then use it within the resource without making changes to the object.

        For example, when creating `AWS::FraudDetector::Detector` you must define at least two variables. You can set `Inline=true` for these variables and CloudFormation will create/update/delete the variables as part of stack operations. However, if you set `Inline=false` , CloudFormation will associate the variables to your detector but not execute any changes to the variables.
        """
        last_updated_time: NotRequired[pulumi.Input[str]]
        """
        The time when the outcome was last updated.
        """
        name: NotRequired[pulumi.Input[str]]
        """
        The outcome name.
        """
        tags: NotRequired[pulumi.Input[Sequence[pulumi.Input['DetectorTagArgsDict']]]]
        """
        Tags associated with this outcome.
        """
elif False:
    DetectorOutcomeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DetectorOutcomeArgs:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None,
                 created_time: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 inline: Optional[pulumi.Input[bool]] = None,
                 last_updated_time: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['DetectorTagArgs']]]] = None):
        """
        :param pulumi.Input[str] arn: The outcome ARN.
        :param pulumi.Input[str] created_time: The time when the outcome was created.
        :param pulumi.Input[str] description: The description.
        :param pulumi.Input[bool] inline: Indicates whether the resource is defined within this CloudFormation template and impacts the create, update, and delete behavior of the stack. If the value is `true` , CloudFormation will create/update/delete the resource when creating/updating/deleting the stack. If the value is `false` , CloudFormation will validate that the object exists and then use it within the resource without making changes to the object.
               
               For example, when creating `AWS::FraudDetector::Detector` you must define at least two variables. You can set `Inline=true` for these variables and CloudFormation will create/update/delete the variables as part of stack operations. However, if you set `Inline=false` , CloudFormation will associate the variables to your detector but not execute any changes to the variables.
        :param pulumi.Input[str] last_updated_time: The time when the outcome was last updated.
        :param pulumi.Input[str] name: The outcome name.
        :param pulumi.Input[Sequence[pulumi.Input['DetectorTagArgs']]] tags: Tags associated with this outcome.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if created_time is not None:
            pulumi.set(__self__, "created_time", created_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if inline is not None:
            pulumi.set(__self__, "inline", inline)
        if last_updated_time is not None:
            pulumi.set(__self__, "last_updated_time", last_updated_time)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        The outcome ARN.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time when the outcome was created.
        """
        return pulumi.get(self, "created_time")

    @created_time.setter
    def created_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_time", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def inline(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether the resource is defined within this CloudFormation template and impacts the create, update, and delete behavior of the stack. If the value is `true` , CloudFormation will create/update/delete the resource when creating/updating/deleting the stack. If the value is `false` , CloudFormation will validate that the object exists and then use it within the resource without making changes to the object.

        For example, when creating `AWS::FraudDetector::Detector` you must define at least two variables. You can set `Inline=true` for these variables and CloudFormation will create/update/delete the variables as part of stack operations. However, if you set `Inline=false` , CloudFormation will associate the variables to your detector but not execute any changes to the variables.
        """
        return pulumi.get(self, "inline")

    @inline.setter
    def inline(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "inline", value)

    @property
    @pulumi.getter(name="lastUpdatedTime")
    def last_updated_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time when the outcome was last updated.
        """
        return pulumi.get(self, "last_updated_time")

    @last_updated_time.setter
    def last_updated_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_updated_time", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The outcome name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DetectorTagArgs']]]]:
        """
        Tags associated with this outcome.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DetectorTagArgs']]]]):
        pulumi.set(self, "tags", value)


if not MYPY:
    class DetectorRuleArgsDict(TypedDict):
        arn: NotRequired[pulumi.Input[str]]
        """
        The rule ARN.
        """
        created_time: NotRequired[pulumi.Input[str]]
        """
        The time when the event type was created.
        """
        description: NotRequired[pulumi.Input[str]]
        """
        The description.
        """
        detector_id: NotRequired[pulumi.Input[str]]
        """
        The detector for which the rule is associated.
        """
        expression: NotRequired[pulumi.Input[str]]
        """
        The rule expression. A rule expression captures the business logic. For more information, see [Rule language reference](https://docs.aws.amazon.com/frauddetector/latest/ug/rule-language-reference.html) .
        """
        language: NotRequired[pulumi.Input['DetectorRuleLanguage']]
        """
        The rule language.

        Valid Value: DETECTORPL
        """
        last_updated_time: NotRequired[pulumi.Input[str]]
        """
        The time when the event type was last updated.
        """
        outcomes: NotRequired[pulumi.Input[Sequence[pulumi.Input['DetectorOutcomeArgsDict']]]]
        """
        The rule outcome.
        """
        rule_id: NotRequired[pulumi.Input[str]]
        """
        The rule ID.
        """
        rule_version: NotRequired[pulumi.Input[str]]
        """
        The rule version.
        """
        tags: NotRequired[pulumi.Input[Sequence[pulumi.Input['DetectorTagArgsDict']]]]
        """
        Tags associated with this event type.
        """
elif False:
    DetectorRuleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DetectorRuleArgs:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None,
                 created_time: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 detector_id: Optional[pulumi.Input[str]] = None,
                 expression: Optional[pulumi.Input[str]] = None,
                 language: Optional[pulumi.Input['DetectorRuleLanguage']] = None,
                 last_updated_time: Optional[pulumi.Input[str]] = None,
                 outcomes: Optional[pulumi.Input[Sequence[pulumi.Input['DetectorOutcomeArgs']]]] = None,
                 rule_id: Optional[pulumi.Input[str]] = None,
                 rule_version: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['DetectorTagArgs']]]] = None):
        """
        :param pulumi.Input[str] arn: The rule ARN.
        :param pulumi.Input[str] created_time: The time when the event type was created.
        :param pulumi.Input[str] description: The description.
        :param pulumi.Input[str] detector_id: The detector for which the rule is associated.
        :param pulumi.Input[str] expression: The rule expression. A rule expression captures the business logic. For more information, see [Rule language reference](https://docs.aws.amazon.com/frauddetector/latest/ug/rule-language-reference.html) .
        :param pulumi.Input['DetectorRuleLanguage'] language: The rule language.
               
               Valid Value: DETECTORPL
        :param pulumi.Input[str] last_updated_time: The time when the event type was last updated.
        :param pulumi.Input[Sequence[pulumi.Input['DetectorOutcomeArgs']]] outcomes: The rule outcome.
        :param pulumi.Input[str] rule_id: The rule ID.
        :param pulumi.Input[str] rule_version: The rule version.
        :param pulumi.Input[Sequence[pulumi.Input['DetectorTagArgs']]] tags: Tags associated with this event type.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if created_time is not None:
            pulumi.set(__self__, "created_time", created_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if detector_id is not None:
            pulumi.set(__self__, "detector_id", detector_id)
        if expression is not None:
            pulumi.set(__self__, "expression", expression)
        if language is not None:
            pulumi.set(__self__, "language", language)
        if last_updated_time is not None:
            pulumi.set(__self__, "last_updated_time", last_updated_time)
        if outcomes is not None:
            pulumi.set(__self__, "outcomes", outcomes)
        if rule_id is not None:
            pulumi.set(__self__, "rule_id", rule_id)
        if rule_version is not None:
            pulumi.set(__self__, "rule_version", rule_version)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        The rule ARN.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time when the event type was created.
        """
        return pulumi.get(self, "created_time")

    @created_time.setter
    def created_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_time", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="detectorId")
    def detector_id(self) -> Optional[pulumi.Input[str]]:
        """
        The detector for which the rule is associated.
        """
        return pulumi.get(self, "detector_id")

    @detector_id.setter
    def detector_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "detector_id", value)

    @property
    @pulumi.getter
    def expression(self) -> Optional[pulumi.Input[str]]:
        """
        The rule expression. A rule expression captures the business logic. For more information, see [Rule language reference](https://docs.aws.amazon.com/frauddetector/latest/ug/rule-language-reference.html) .
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter
    def language(self) -> Optional[pulumi.Input['DetectorRuleLanguage']]:
        """
        The rule language.

        Valid Value: DETECTORPL
        """
        return pulumi.get(self, "language")

    @language.setter
    def language(self, value: Optional[pulumi.Input['DetectorRuleLanguage']]):
        pulumi.set(self, "language", value)

    @property
    @pulumi.getter(name="lastUpdatedTime")
    def last_updated_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time when the event type was last updated.
        """
        return pulumi.get(self, "last_updated_time")

    @last_updated_time.setter
    def last_updated_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_updated_time", value)

    @property
    @pulumi.getter
    def outcomes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DetectorOutcomeArgs']]]]:
        """
        The rule outcome.
        """
        return pulumi.get(self, "outcomes")

    @outcomes.setter
    def outcomes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DetectorOutcomeArgs']]]]):
        pulumi.set(self, "outcomes", value)

    @property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> Optional[pulumi.Input[str]]:
        """
        The rule ID.
        """
        return pulumi.get(self, "rule_id")

    @rule_id.setter
    def rule_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rule_id", value)

    @property
    @pulumi.getter(name="ruleVersion")
    def rule_version(self) -> Optional[pulumi.Input[str]]:
        """
        The rule version.
        """
        return pulumi.get(self, "rule_version")

    @rule_version.setter
    def rule_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rule_version", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DetectorTagArgs']]]]:
        """
        Tags associated with this event type.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DetectorTagArgs']]]]):
        pulumi.set(self, "tags", value)


if not MYPY:
    class DetectorTagArgsDict(TypedDict):
        key: pulumi.Input[str]
        """
        A tag key.
        """
        value: pulumi.Input[str]
        """
        A value assigned to a tag key.
        """
elif False:
    DetectorTagArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DetectorTagArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        :param pulumi.Input[str] key: A tag key.
        :param pulumi.Input[str] value: A value assigned to a tag key.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        A tag key.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        A value assigned to a tag key.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


if not MYPY:
    class EventTypeEntityTypeArgsDict(TypedDict):
        arn: NotRequired[pulumi.Input[str]]
        """
        The entity type ARN.
        """
        created_time: NotRequired[pulumi.Input[str]]
        """
        The time when the event type was created.
        """
        description: NotRequired[pulumi.Input[str]]
        """
        The description.
        """
        inline: NotRequired[pulumi.Input[bool]]
        """
        Indicates whether the resource is defined within this CloudFormation template and impacts the create, update, and delete behavior of the stack. If the value is `true` , CloudFormation will create/update/delete the resource when creating/updating/deleting the stack. If the value is `false` , CloudFormation will validate that the object exists and then use it within the resource without making changes to the object.

        For example, when creating `AWS::FraudDetector::EventType` you must define at least two variables. You can set `Inline=true` for these variables and CloudFormation will create/update/delete the variables as part of stack operations. However, if you set `Inline=false` , CloudFormation will associate the variables to your event type but not execute any changes to the variables.
        """
        last_updated_time: NotRequired[pulumi.Input[str]]
        """
        The time when the event type was last updated.
        """
        name: NotRequired[pulumi.Input[str]]
        """
        The entity type name.

        `^[0-9a-z_-]+$`
        """
        tags: NotRequired[pulumi.Input[Sequence[pulumi.Input['EventTypeTagArgsDict']]]]
        """
        Tags associated with this event type.
        """
elif False:
    EventTypeEntityTypeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class EventTypeEntityTypeArgs:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None,
                 created_time: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 inline: Optional[pulumi.Input[bool]] = None,
                 last_updated_time: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['EventTypeTagArgs']]]] = None):
        """
        :param pulumi.Input[str] arn: The entity type ARN.
        :param pulumi.Input[str] created_time: The time when the event type was created.
        :param pulumi.Input[str] description: The description.
        :param pulumi.Input[bool] inline: Indicates whether the resource is defined within this CloudFormation template and impacts the create, update, and delete behavior of the stack. If the value is `true` , CloudFormation will create/update/delete the resource when creating/updating/deleting the stack. If the value is `false` , CloudFormation will validate that the object exists and then use it within the resource without making changes to the object.
               
               For example, when creating `AWS::FraudDetector::EventType` you must define at least two variables. You can set `Inline=true` for these variables and CloudFormation will create/update/delete the variables as part of stack operations. However, if you set `Inline=false` , CloudFormation will associate the variables to your event type but not execute any changes to the variables.
        :param pulumi.Input[str] last_updated_time: The time when the event type was last updated.
        :param pulumi.Input[str] name: The entity type name.
               
               `^[0-9a-z_-]+$`
        :param pulumi.Input[Sequence[pulumi.Input['EventTypeTagArgs']]] tags: Tags associated with this event type.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if created_time is not None:
            pulumi.set(__self__, "created_time", created_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if inline is not None:
            pulumi.set(__self__, "inline", inline)
        if last_updated_time is not None:
            pulumi.set(__self__, "last_updated_time", last_updated_time)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        The entity type ARN.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time when the event type was created.
        """
        return pulumi.get(self, "created_time")

    @created_time.setter
    def created_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_time", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def inline(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether the resource is defined within this CloudFormation template and impacts the create, update, and delete behavior of the stack. If the value is `true` , CloudFormation will create/update/delete the resource when creating/updating/deleting the stack. If the value is `false` , CloudFormation will validate that the object exists and then use it within the resource without making changes to the object.

        For example, when creating `AWS::FraudDetector::EventType` you must define at least two variables. You can set `Inline=true` for these variables and CloudFormation will create/update/delete the variables as part of stack operations. However, if you set `Inline=false` , CloudFormation will associate the variables to your event type but not execute any changes to the variables.
        """
        return pulumi.get(self, "inline")

    @inline.setter
    def inline(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "inline", value)

    @property
    @pulumi.getter(name="lastUpdatedTime")
    def last_updated_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time when the event type was last updated.
        """
        return pulumi.get(self, "last_updated_time")

    @last_updated_time.setter
    def last_updated_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_updated_time", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The entity type name.

        `^[0-9a-z_-]+$`
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EventTypeTagArgs']]]]:
        """
        Tags associated with this event type.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EventTypeTagArgs']]]]):
        pulumi.set(self, "tags", value)


if not MYPY:
    class EventTypeEventVariableArgsDict(TypedDict):
        arn: NotRequired[pulumi.Input[str]]
        """
        The event variable ARN.
        """
        created_time: NotRequired[pulumi.Input[str]]
        """
        The time when the event type was created.
        """
        data_source: NotRequired[pulumi.Input['EventTypeEventVariableDataSource']]
        """
        The source of the event variable.

        Valid values: `EVENT | EXTERNAL_MODEL_SCORE`

        When defining a variable within a event type, you can only use the `EVENT` value for DataSource when the *Inline* property is set to true. If the *Inline* property is set false, you can use either `EVENT` or `MODEL_SCORE` for DataSource.
        """
        data_type: NotRequired[pulumi.Input['EventTypeEventVariableDataType']]
        """
        The data type of the event variable. For more information, see [Data types](https://docs.aws.amazon.com/frauddetector/latest/ug/variables.html#data-types) .
        """
        default_value: NotRequired[pulumi.Input[str]]
        """
        The default value of the event variable
        """
        description: NotRequired[pulumi.Input[str]]
        """
        The description.
        """
        inline: NotRequired[pulumi.Input[bool]]
        """
        Indicates whether the resource is defined within this CloudFormation template and impacts the create, update, and delete behavior of the stack. If the value is `true` , CloudFormation will create/update/delete the resource when creating/updating/deleting the stack. If the value is `false` , CloudFormation will validate that the object exists and then use it within the resource without making changes to the object.

        For example, when creating `AWS::FraudDetector::EventType` you must define at least two variables. You can set `Inline=true` for these variables and CloudFormation will create/update/delete the Variables as part of stack operations. However, if you set `Inline=false` , CloudFormation will associate the variables to your event type but not execute any changes to the variables.
        """
        last_updated_time: NotRequired[pulumi.Input[str]]
        """
        The time when the event type was last updated.
        """
        name: NotRequired[pulumi.Input[str]]
        """
        The name of the event variable.
        """
        tags: NotRequired[pulumi.Input[Sequence[pulumi.Input['EventTypeTagArgsDict']]]]
        """
        Tags associated with this event type.
        """
        variable_type: NotRequired[pulumi.Input['EventTypeEventVariableVariableType']]
        """
        The type of event variable. For more information, see [Variable types](https://docs.aws.amazon.com/frauddetector/latest/ug/variables.html#variable-types) .
        """
elif False:
    EventTypeEventVariableArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class EventTypeEventVariableArgs:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None,
                 created_time: Optional[pulumi.Input[str]] = None,
                 data_source: Optional[pulumi.Input['EventTypeEventVariableDataSource']] = None,
                 data_type: Optional[pulumi.Input['EventTypeEventVariableDataType']] = None,
                 default_value: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 inline: Optional[pulumi.Input[bool]] = None,
                 last_updated_time: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['EventTypeTagArgs']]]] = None,
                 variable_type: Optional[pulumi.Input['EventTypeEventVariableVariableType']] = None):
        """
        :param pulumi.Input[str] arn: The event variable ARN.
        :param pulumi.Input[str] created_time: The time when the event type was created.
        :param pulumi.Input['EventTypeEventVariableDataSource'] data_source: The source of the event variable.
               
               Valid values: `EVENT | EXTERNAL_MODEL_SCORE`
               
               When defining a variable within a event type, you can only use the `EVENT` value for DataSource when the *Inline* property is set to true. If the *Inline* property is set false, you can use either `EVENT` or `MODEL_SCORE` for DataSource.
        :param pulumi.Input['EventTypeEventVariableDataType'] data_type: The data type of the event variable. For more information, see [Data types](https://docs.aws.amazon.com/frauddetector/latest/ug/variables.html#data-types) .
        :param pulumi.Input[str] default_value: The default value of the event variable
        :param pulumi.Input[str] description: The description.
        :param pulumi.Input[bool] inline: Indicates whether the resource is defined within this CloudFormation template and impacts the create, update, and delete behavior of the stack. If the value is `true` , CloudFormation will create/update/delete the resource when creating/updating/deleting the stack. If the value is `false` , CloudFormation will validate that the object exists and then use it within the resource without making changes to the object.
               
               For example, when creating `AWS::FraudDetector::EventType` you must define at least two variables. You can set `Inline=true` for these variables and CloudFormation will create/update/delete the Variables as part of stack operations. However, if you set `Inline=false` , CloudFormation will associate the variables to your event type but not execute any changes to the variables.
        :param pulumi.Input[str] last_updated_time: The time when the event type was last updated.
        :param pulumi.Input[str] name: The name of the event variable.
        :param pulumi.Input[Sequence[pulumi.Input['EventTypeTagArgs']]] tags: Tags associated with this event type.
        :param pulumi.Input['EventTypeEventVariableVariableType'] variable_type: The type of event variable. For more information, see [Variable types](https://docs.aws.amazon.com/frauddetector/latest/ug/variables.html#variable-types) .
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if created_time is not None:
            pulumi.set(__self__, "created_time", created_time)
        if data_source is not None:
            pulumi.set(__self__, "data_source", data_source)
        if data_type is not None:
            pulumi.set(__self__, "data_type", data_type)
        if default_value is not None:
            pulumi.set(__self__, "default_value", default_value)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if inline is not None:
            pulumi.set(__self__, "inline", inline)
        if last_updated_time is not None:
            pulumi.set(__self__, "last_updated_time", last_updated_time)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if variable_type is not None:
            pulumi.set(__self__, "variable_type", variable_type)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        The event variable ARN.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time when the event type was created.
        """
        return pulumi.get(self, "created_time")

    @created_time.setter
    def created_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_time", value)

    @property
    @pulumi.getter(name="dataSource")
    def data_source(self) -> Optional[pulumi.Input['EventTypeEventVariableDataSource']]:
        """
        The source of the event variable.

        Valid values: `EVENT | EXTERNAL_MODEL_SCORE`

        When defining a variable within a event type, you can only use the `EVENT` value for DataSource when the *Inline* property is set to true. If the *Inline* property is set false, you can use either `EVENT` or `MODEL_SCORE` for DataSource.
        """
        return pulumi.get(self, "data_source")

    @data_source.setter
    def data_source(self, value: Optional[pulumi.Input['EventTypeEventVariableDataSource']]):
        pulumi.set(self, "data_source", value)

    @property
    @pulumi.getter(name="dataType")
    def data_type(self) -> Optional[pulumi.Input['EventTypeEventVariableDataType']]:
        """
        The data type of the event variable. For more information, see [Data types](https://docs.aws.amazon.com/frauddetector/latest/ug/variables.html#data-types) .
        """
        return pulumi.get(self, "data_type")

    @data_type.setter
    def data_type(self, value: Optional[pulumi.Input['EventTypeEventVariableDataType']]):
        pulumi.set(self, "data_type", value)

    @property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> Optional[pulumi.Input[str]]:
        """
        The default value of the event variable
        """
        return pulumi.get(self, "default_value")

    @default_value.setter
    def default_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_value", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def inline(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether the resource is defined within this CloudFormation template and impacts the create, update, and delete behavior of the stack. If the value is `true` , CloudFormation will create/update/delete the resource when creating/updating/deleting the stack. If the value is `false` , CloudFormation will validate that the object exists and then use it within the resource without making changes to the object.

        For example, when creating `AWS::FraudDetector::EventType` you must define at least two variables. You can set `Inline=true` for these variables and CloudFormation will create/update/delete the Variables as part of stack operations. However, if you set `Inline=false` , CloudFormation will associate the variables to your event type but not execute any changes to the variables.
        """
        return pulumi.get(self, "inline")

    @inline.setter
    def inline(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "inline", value)

    @property
    @pulumi.getter(name="lastUpdatedTime")
    def last_updated_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time when the event type was last updated.
        """
        return pulumi.get(self, "last_updated_time")

    @last_updated_time.setter
    def last_updated_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_updated_time", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the event variable.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EventTypeTagArgs']]]]:
        """
        Tags associated with this event type.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EventTypeTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="variableType")
    def variable_type(self) -> Optional[pulumi.Input['EventTypeEventVariableVariableType']]:
        """
        The type of event variable. For more information, see [Variable types](https://docs.aws.amazon.com/frauddetector/latest/ug/variables.html#variable-types) .
        """
        return pulumi.get(self, "variable_type")

    @variable_type.setter
    def variable_type(self, value: Optional[pulumi.Input['EventTypeEventVariableVariableType']]):
        pulumi.set(self, "variable_type", value)


if not MYPY:
    class EventTypeLabelArgsDict(TypedDict):
        arn: NotRequired[pulumi.Input[str]]
        """
        The label ARN.
        """
        created_time: NotRequired[pulumi.Input[str]]
        """
        The time when the event type was created.
        """
        description: NotRequired[pulumi.Input[str]]
        """
        The description.
        """
        inline: NotRequired[pulumi.Input[bool]]
        """
        Indicates whether the resource is defined within this CloudFormation template and impacts the create, update, and delete behavior of the stack. If the value is `true` , CloudFormation will create/update/delete the resource when creating/updating/deleting the stack. If the value is `false` , CloudFormation will validate that the object exists and then use it within the resource without making changes to the object.

        For example, when creating `AWS::FraudDetector::EventType` you must define at least two variables. You can set `Inline=true` for these variables and CloudFormation will create/update/delete the variables as part of stack operations. However, if you set `Inline=false` , CloudFormation will associate the variables to your EventType but not execute any changes to the variables.
        """
        last_updated_time: NotRequired[pulumi.Input[str]]
        """
        The time when the event type was last updated.
        """
        name: NotRequired[pulumi.Input[str]]
        """
        The label name.
        """
        tags: NotRequired[pulumi.Input[Sequence[pulumi.Input['EventTypeTagArgsDict']]]]
        """
        Tags associated with this event type.
        """
elif False:
    EventTypeLabelArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class EventTypeLabelArgs:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None,
                 created_time: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 inline: Optional[pulumi.Input[bool]] = None,
                 last_updated_time: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['EventTypeTagArgs']]]] = None):
        """
        :param pulumi.Input[str] arn: The label ARN.
        :param pulumi.Input[str] created_time: The time when the event type was created.
        :param pulumi.Input[str] description: The description.
        :param pulumi.Input[bool] inline: Indicates whether the resource is defined within this CloudFormation template and impacts the create, update, and delete behavior of the stack. If the value is `true` , CloudFormation will create/update/delete the resource when creating/updating/deleting the stack. If the value is `false` , CloudFormation will validate that the object exists and then use it within the resource without making changes to the object.
               
               For example, when creating `AWS::FraudDetector::EventType` you must define at least two variables. You can set `Inline=true` for these variables and CloudFormation will create/update/delete the variables as part of stack operations. However, if you set `Inline=false` , CloudFormation will associate the variables to your EventType but not execute any changes to the variables.
        :param pulumi.Input[str] last_updated_time: The time when the event type was last updated.
        :param pulumi.Input[str] name: The label name.
        :param pulumi.Input[Sequence[pulumi.Input['EventTypeTagArgs']]] tags: Tags associated with this event type.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if created_time is not None:
            pulumi.set(__self__, "created_time", created_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if inline is not None:
            pulumi.set(__self__, "inline", inline)
        if last_updated_time is not None:
            pulumi.set(__self__, "last_updated_time", last_updated_time)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        The label ARN.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time when the event type was created.
        """
        return pulumi.get(self, "created_time")

    @created_time.setter
    def created_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_time", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def inline(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether the resource is defined within this CloudFormation template and impacts the create, update, and delete behavior of the stack. If the value is `true` , CloudFormation will create/update/delete the resource when creating/updating/deleting the stack. If the value is `false` , CloudFormation will validate that the object exists and then use it within the resource without making changes to the object.

        For example, when creating `AWS::FraudDetector::EventType` you must define at least two variables. You can set `Inline=true` for these variables and CloudFormation will create/update/delete the variables as part of stack operations. However, if you set `Inline=false` , CloudFormation will associate the variables to your EventType but not execute any changes to the variables.
        """
        return pulumi.get(self, "inline")

    @inline.setter
    def inline(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "inline", value)

    @property
    @pulumi.getter(name="lastUpdatedTime")
    def last_updated_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time when the event type was last updated.
        """
        return pulumi.get(self, "last_updated_time")

    @last_updated_time.setter
    def last_updated_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_updated_time", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The label name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EventTypeTagArgs']]]]:
        """
        Tags associated with this event type.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EventTypeTagArgs']]]]):
        pulumi.set(self, "tags", value)


if not MYPY:
    class EventTypeTagArgsDict(TypedDict):
        key: pulumi.Input[str]
        """
        A tag key.
        """
        value: pulumi.Input[str]
        """
        A value assigned to a tag key.
        """
elif False:
    EventTypeTagArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class EventTypeTagArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        :param pulumi.Input[str] key: A tag key.
        :param pulumi.Input[str] value: A value assigned to a tag key.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        A tag key.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        A value assigned to a tag key.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


