# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetDatasetResult',
    'AwaitableGetDatasetResult',
    'get_dataset',
    'get_dataset_output',
]

@pulumi.output_type
class GetDatasetResult:
    def __init__(__self__, arn=None, data_frequency=None, dataset_type=None, domain=None, encryption_config=None, schema=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if data_frequency and not isinstance(data_frequency, str):
            raise TypeError("Expected argument 'data_frequency' to be a str")
        pulumi.set(__self__, "data_frequency", data_frequency)
        if dataset_type and not isinstance(dataset_type, str):
            raise TypeError("Expected argument 'dataset_type' to be a str")
        pulumi.set(__self__, "dataset_type", dataset_type)
        if domain and not isinstance(domain, str):
            raise TypeError("Expected argument 'domain' to be a str")
        pulumi.set(__self__, "domain", domain)
        if encryption_config and not isinstance(encryption_config, dict):
            raise TypeError("Expected argument 'encryption_config' to be a dict")
        pulumi.set(__self__, "encryption_config", encryption_config)
        if schema and not isinstance(schema, dict):
            raise TypeError("Expected argument 'schema' to be a dict")
        pulumi.set(__self__, "schema", schema)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the dataset.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="dataFrequency")
    def data_frequency(self) -> Optional[str]:
        """
        Frequency of data collection. This parameter is required for RELATED_TIME_SERIES
        """
        return pulumi.get(self, "data_frequency")

    @property
    @pulumi.getter(name="datasetType")
    def dataset_type(self) -> Optional['DatasetType']:
        """
        The dataset type
        """
        return pulumi.get(self, "dataset_type")

    @property
    @pulumi.getter
    def domain(self) -> Optional['DatasetDomain']:
        """
        The domain associated with the dataset
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="encryptionConfig")
    def encryption_config(self) -> Optional['outputs.EncryptionConfigProperties']:
        """
        A Key Management Service (KMS) key and the Identity and Access Management (IAM) role that Amazon Forecast can assume to access the key.
        """
        return pulumi.get(self, "encryption_config")

    @property
    @pulumi.getter
    def schema(self) -> Optional['outputs.SchemaProperties']:
        """
        The schema for the dataset. The schema attributes and their order must match the fields in your data. The dataset `Domain` and `DatasetType` that you choose determine the minimum required fields in your training data. For information about the required fields for a specific dataset domain and type, see [Dataset Domains and Dataset Types](https://docs.aws.amazon.com/forecast/latest/dg/howitworks-domains-ds-types.html) .
        """
        return pulumi.get(self, "schema")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        An array of key-value pairs to apply to this resource.

        For more information, see [Tag](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html) .
        """
        return pulumi.get(self, "tags")


class AwaitableGetDatasetResult(GetDatasetResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDatasetResult(
            arn=self.arn,
            data_frequency=self.data_frequency,
            dataset_type=self.dataset_type,
            domain=self.domain,
            encryption_config=self.encryption_config,
            schema=self.schema,
            tags=self.tags)


def get_dataset(arn: Optional[str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDatasetResult:
    """
    Resource Type Definition for AWS::Forecast::Dataset


    :param str arn: The Amazon Resource Name (ARN) of the dataset.
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:forecast:getDataset', __args__, opts=opts, typ=GetDatasetResult).value

    return AwaitableGetDatasetResult(
        arn=pulumi.get(__ret__, 'arn'),
        data_frequency=pulumi.get(__ret__, 'data_frequency'),
        dataset_type=pulumi.get(__ret__, 'dataset_type'),
        domain=pulumi.get(__ret__, 'domain'),
        encryption_config=pulumi.get(__ret__, 'encryption_config'),
        schema=pulumi.get(__ret__, 'schema'),
        tags=pulumi.get(__ret__, 'tags'))
def get_dataset_output(arn: Optional[pulumi.Input[str]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDatasetResult]:
    """
    Resource Type Definition for AWS::Forecast::Dataset


    :param str arn: The Amazon Resource Name (ARN) of the dataset.
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:forecast:getDataset', __args__, opts=opts, typ=GetDatasetResult)
    return __ret__.apply(lambda __response__: GetDatasetResult(
        arn=pulumi.get(__response__, 'arn'),
        data_frequency=pulumi.get(__response__, 'data_frequency'),
        dataset_type=pulumi.get(__response__, 'dataset_type'),
        domain=pulumi.get(__response__, 'domain'),
        encryption_config=pulumi.get(__response__, 'encryption_config'),
        schema=pulumi.get(__response__, 'schema'),
        tags=pulumi.get(__response__, 'tags')))
