# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = ['DatasetGroupArgs', 'DatasetGroup']

@pulumi.input_type
class DatasetGroupArgs:
    def __init__(__self__, *,
                 domain: pulumi.Input['DatasetGroupDomain'],
                 dataset_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 dataset_group_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a DatasetGroup resource.
        :param pulumi.Input['DatasetGroupDomain'] domain: The domain associated with the dataset group. When you add a dataset to a dataset group, this value and the value specified for the Domain parameter of the CreateDataset operation must match.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dataset_arns: An array of Amazon Resource Names (ARNs) of the datasets that you want to include in the dataset group.
        :param pulumi.Input[str] dataset_group_name: A name for the dataset group.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: The tags of Application Insights application.
        """
        pulumi.set(__self__, "domain", domain)
        if dataset_arns is not None:
            pulumi.set(__self__, "dataset_arns", dataset_arns)
        if dataset_group_name is not None:
            pulumi.set(__self__, "dataset_group_name", dataset_group_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def domain(self) -> pulumi.Input['DatasetGroupDomain']:
        """
        The domain associated with the dataset group. When you add a dataset to a dataset group, this value and the value specified for the Domain parameter of the CreateDataset operation must match.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: pulumi.Input['DatasetGroupDomain']):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter(name="datasetArns")
    def dataset_arns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An array of Amazon Resource Names (ARNs) of the datasets that you want to include in the dataset group.
        """
        return pulumi.get(self, "dataset_arns")

    @dataset_arns.setter
    def dataset_arns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "dataset_arns", value)

    @property
    @pulumi.getter(name="datasetGroupName")
    def dataset_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        A name for the dataset group.
        """
        return pulumi.get(self, "dataset_group_name")

    @dataset_group_name.setter
    def dataset_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dataset_group_name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        The tags of Application Insights application.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


class DatasetGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dataset_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 dataset_group_name: Optional[pulumi.Input[str]] = None,
                 domain: Optional[pulumi.Input['DatasetGroupDomain']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        Represents a dataset group that holds a collection of related datasets

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dataset_arns: An array of Amazon Resource Names (ARNs) of the datasets that you want to include in the dataset group.
        :param pulumi.Input[str] dataset_group_name: A name for the dataset group.
        :param pulumi.Input['DatasetGroupDomain'] domain: The domain associated with the dataset group. When you add a dataset to a dataset group, this value and the value specified for the Domain parameter of the CreateDataset operation must match.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: The tags of Application Insights application.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DatasetGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Represents a dataset group that holds a collection of related datasets

        :param str resource_name: The name of the resource.
        :param DatasetGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DatasetGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dataset_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 dataset_group_name: Optional[pulumi.Input[str]] = None,
                 domain: Optional[pulumi.Input['DatasetGroupDomain']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DatasetGroupArgs.__new__(DatasetGroupArgs)

            __props__.__dict__["dataset_arns"] = dataset_arns
            __props__.__dict__["dataset_group_name"] = dataset_group_name
            if domain is None and not opts.urn:
                raise TypeError("Missing required property 'domain'")
            __props__.__dict__["domain"] = domain
            __props__.__dict__["tags"] = tags
            __props__.__dict__["dataset_group_arn"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["datasetGroupName"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(DatasetGroup, __self__).__init__(
            'aws-native:forecast:DatasetGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'DatasetGroup':
        """
        Get an existing DatasetGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = DatasetGroupArgs.__new__(DatasetGroupArgs)

        __props__.__dict__["dataset_arns"] = None
        __props__.__dict__["dataset_group_arn"] = None
        __props__.__dict__["dataset_group_name"] = None
        __props__.__dict__["domain"] = None
        __props__.__dict__["tags"] = None
        return DatasetGroup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="datasetArns")
    def dataset_arns(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        An array of Amazon Resource Names (ARNs) of the datasets that you want to include in the dataset group.
        """
        return pulumi.get(self, "dataset_arns")

    @property
    @pulumi.getter(name="datasetGroupArn")
    def dataset_group_arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN) of the dataset group to delete.
        """
        return pulumi.get(self, "dataset_group_arn")

    @property
    @pulumi.getter(name="datasetGroupName")
    def dataset_group_name(self) -> pulumi.Output[str]:
        """
        A name for the dataset group.
        """
        return pulumi.get(self, "dataset_group_name")

    @property
    @pulumi.getter
    def domain(self) -> pulumi.Output['DatasetGroupDomain']:
        """
        The domain associated with the dataset group. When you add a dataset to a dataset group, this value and the value specified for the Domain parameter of the CreateDataset operation must match.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        The tags of Application Insights application.
        """
        return pulumi.get(self, "tags")

