# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'DatasetAttributesItemPropertiesArgs',
    'DatasetAttributesItemPropertiesArgsDict',
    'EncryptionConfigPropertiesArgs',
    'EncryptionConfigPropertiesArgsDict',
    'SchemaPropertiesArgs',
    'SchemaPropertiesArgsDict',
]

MYPY = False

if not MYPY:
    class DatasetAttributesItemPropertiesArgsDict(TypedDict):
        attribute_name: NotRequired[pulumi.Input[str]]
        """
        Name of the dataset field
        """
        attribute_type: NotRequired[pulumi.Input['DatasetAttributesItemPropertiesAttributeType']]
        """
        Data type of the field
        """
elif False:
    DatasetAttributesItemPropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DatasetAttributesItemPropertiesArgs:
    def __init__(__self__, *,
                 attribute_name: Optional[pulumi.Input[str]] = None,
                 attribute_type: Optional[pulumi.Input['DatasetAttributesItemPropertiesAttributeType']] = None):
        """
        :param pulumi.Input[str] attribute_name: Name of the dataset field
        :param pulumi.Input['DatasetAttributesItemPropertiesAttributeType'] attribute_type: Data type of the field
        """
        if attribute_name is not None:
            pulumi.set(__self__, "attribute_name", attribute_name)
        if attribute_type is not None:
            pulumi.set(__self__, "attribute_type", attribute_type)

    @property
    @pulumi.getter(name="attributeName")
    def attribute_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the dataset field
        """
        return pulumi.get(self, "attribute_name")

    @attribute_name.setter
    def attribute_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "attribute_name", value)

    @property
    @pulumi.getter(name="attributeType")
    def attribute_type(self) -> Optional[pulumi.Input['DatasetAttributesItemPropertiesAttributeType']]:
        """
        Data type of the field
        """
        return pulumi.get(self, "attribute_type")

    @attribute_type.setter
    def attribute_type(self, value: Optional[pulumi.Input['DatasetAttributesItemPropertiesAttributeType']]):
        pulumi.set(self, "attribute_type", value)


if not MYPY:
    class EncryptionConfigPropertiesArgsDict(TypedDict):
        """
        A Key Management Service (KMS) key and the Identity and Access Management (IAM) role that Amazon Forecast can assume to access the key.
        """
        kms_key_arn: NotRequired[pulumi.Input[str]]
        """
        The Amazon Resource Name (ARN) of the KMS key.
        """
        role_arn: NotRequired[pulumi.Input[str]]
        """
        The ARN of the IAM role that Amazon Forecast can assume to access the AWS KMS key.

        Passing a role across AWS accounts is not allowed. If you pass a role that isn't in your account, you get an `InvalidInputException` error.
        """
elif False:
    EncryptionConfigPropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class EncryptionConfigPropertiesArgs:
    def __init__(__self__, *,
                 kms_key_arn: Optional[pulumi.Input[str]] = None,
                 role_arn: Optional[pulumi.Input[str]] = None):
        """
        A Key Management Service (KMS) key and the Identity and Access Management (IAM) role that Amazon Forecast can assume to access the key.
        :param pulumi.Input[str] kms_key_arn: The Amazon Resource Name (ARN) of the KMS key.
        :param pulumi.Input[str] role_arn: The ARN of the IAM role that Amazon Forecast can assume to access the AWS KMS key.
               
               Passing a role across AWS accounts is not allowed. If you pass a role that isn't in your account, you get an `InvalidInputException` error.
        """
        if kms_key_arn is not None:
            pulumi.set(__self__, "kms_key_arn", kms_key_arn)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)

    @property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) of the KMS key.
        """
        return pulumi.get(self, "kms_key_arn")

    @kms_key_arn.setter
    def kms_key_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_arn", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the IAM role that Amazon Forecast can assume to access the AWS KMS key.

        Passing a role across AWS accounts is not allowed. If you pass a role that isn't in your account, you get an `InvalidInputException` error.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role_arn", value)


if not MYPY:
    class SchemaPropertiesArgsDict(TypedDict):
        """
        The schema for the dataset. The schema attributes and their order must match the fields in your data. The dataset `Domain` and `DatasetType` that you choose determine the minimum required fields in your training data. For information about the required fields for a specific dataset domain and type, see [Dataset Domains and Dataset Types](https://docs.aws.amazon.com/forecast/latest/dg/howitworks-domains-ds-types.html) .
        """
        attributes: NotRequired[pulumi.Input[Sequence[pulumi.Input['DatasetAttributesItemPropertiesArgsDict']]]]
        """
        An array of attributes specifying the name and type of each field in a dataset.
        """
elif False:
    SchemaPropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SchemaPropertiesArgs:
    def __init__(__self__, *,
                 attributes: Optional[pulumi.Input[Sequence[pulumi.Input['DatasetAttributesItemPropertiesArgs']]]] = None):
        """
        The schema for the dataset. The schema attributes and their order must match the fields in your data. The dataset `Domain` and `DatasetType` that you choose determine the minimum required fields in your training data. For information about the required fields for a specific dataset domain and type, see [Dataset Domains and Dataset Types](https://docs.aws.amazon.com/forecast/latest/dg/howitworks-domains-ds-types.html) .
        :param pulumi.Input[Sequence[pulumi.Input['DatasetAttributesItemPropertiesArgs']]] attributes: An array of attributes specifying the name and type of each field in a dataset.
        """
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)

    @property
    @pulumi.getter
    def attributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DatasetAttributesItemPropertiesArgs']]]]:
        """
        An array of attributes specifying the name and type of each field in a dataset.
        """
        return pulumi.get(self, "attributes")

    @attributes.setter
    def attributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DatasetAttributesItemPropertiesArgs']]]]):
        pulumi.set(self, "attributes", value)


