# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetFeatureResult',
    'AwaitableGetFeatureResult',
    'get_feature',
    'get_feature_output',
]

@pulumi.output_type
class GetFeatureResult:
    def __init__(__self__, arn=None, default_variation=None, description=None, entity_overrides=None, evaluation_strategy=None, tags=None, variations=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if default_variation and not isinstance(default_variation, str):
            raise TypeError("Expected argument 'default_variation' to be a str")
        pulumi.set(__self__, "default_variation", default_variation)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if entity_overrides and not isinstance(entity_overrides, list):
            raise TypeError("Expected argument 'entity_overrides' to be a list")
        pulumi.set(__self__, "entity_overrides", entity_overrides)
        if evaluation_strategy and not isinstance(evaluation_strategy, str):
            raise TypeError("Expected argument 'evaluation_strategy' to be a str")
        pulumi.set(__self__, "evaluation_strategy", evaluation_strategy)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if variations and not isinstance(variations, list):
            raise TypeError("Expected argument 'variations' to be a list")
        pulumi.set(__self__, "variations", variations)

    @property
    @pulumi.getter
    def arn(self) -> Optional[str]:
        """
        The ARN of the feature. For example, `arn:aws:evidently:us-west-2:0123455678912:project/myProject/feature/myFeature` .
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="defaultVariation")
    def default_variation(self) -> Optional[str]:
        """
        The name of the variation to use as the default variation. The default variation is served to users who are not allocated to any ongoing launches or experiments of this feature.

        This variation must also be listed in the `Variations` structure.

        If you omit `DefaultVariation` , the first variation listed in the `Variations` structure is used as the default variation.
        """
        return pulumi.get(self, "default_variation")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        An optional description of the feature.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="entityOverrides")
    def entity_overrides(self) -> Optional[Sequence['outputs.FeatureEntityOverride']]:
        """
        Specify users that should always be served a specific variation of a feature. Each user is specified by a key-value pair . For each key, specify a user by entering their user ID, account ID, or some other identifier. For the value, specify the name of the variation that they are to be served.
        """
        return pulumi.get(self, "entity_overrides")

    @property
    @pulumi.getter(name="evaluationStrategy")
    def evaluation_strategy(self) -> Optional['FeatureEvaluationStrategy']:
        """
        Specify `ALL_RULES` to activate the traffic allocation specified by any ongoing launches or experiments. Specify `DEFAULT_VARIATION` to serve the default variation to all users instead.
        """
        return pulumi.get(self, "evaluation_strategy")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def variations(self) -> Optional[Sequence['outputs.FeatureVariationObject']]:
        """
        An array of structures that contain the configuration of the feature's different variations.

        Each `VariationObject` in the `Variations` array for a feature must have the same type of value ( `BooleanValue` , `DoubleValue` , `LongValue` or `StringValue` ).
        """
        return pulumi.get(self, "variations")


class AwaitableGetFeatureResult(GetFeatureResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFeatureResult(
            arn=self.arn,
            default_variation=self.default_variation,
            description=self.description,
            entity_overrides=self.entity_overrides,
            evaluation_strategy=self.evaluation_strategy,
            tags=self.tags,
            variations=self.variations)


def get_feature(arn: Optional[str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFeatureResult:
    """
    Resource Type definition for AWS::Evidently::Feature.


    :param str arn: The ARN of the feature. For example, `arn:aws:evidently:us-west-2:0123455678912:project/myProject/feature/myFeature` .
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:evidently:getFeature', __args__, opts=opts, typ=GetFeatureResult).value

    return AwaitableGetFeatureResult(
        arn=pulumi.get(__ret__, 'arn'),
        default_variation=pulumi.get(__ret__, 'default_variation'),
        description=pulumi.get(__ret__, 'description'),
        entity_overrides=pulumi.get(__ret__, 'entity_overrides'),
        evaluation_strategy=pulumi.get(__ret__, 'evaluation_strategy'),
        tags=pulumi.get(__ret__, 'tags'),
        variations=pulumi.get(__ret__, 'variations'))
def get_feature_output(arn: Optional[pulumi.Input[str]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetFeatureResult]:
    """
    Resource Type definition for AWS::Evidently::Feature.


    :param str arn: The ARN of the feature. For example, `arn:aws:evidently:us-west-2:0123455678912:project/myProject/feature/myFeature` .
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:evidently:getFeature', __args__, opts=opts, typ=GetFeatureResult)
    return __ret__.apply(lambda __response__: GetFeatureResult(
        arn=pulumi.get(__response__, 'arn'),
        default_variation=pulumi.get(__response__, 'default_variation'),
        description=pulumi.get(__response__, 'description'),
        entity_overrides=pulumi.get(__response__, 'entity_overrides'),
        evaluation_strategy=pulumi.get(__response__, 'evaluation_strategy'),
        tags=pulumi.get(__response__, 'tags'),
        variations=pulumi.get(__response__, 'variations')))
