# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetExperimentResult',
    'AwaitableGetExperimentResult',
    'get_experiment',
    'get_experiment_output',
]

@pulumi.output_type
class GetExperimentResult:
    def __init__(__self__, arn=None, description=None, metric_goals=None, online_ab_config=None, randomization_salt=None, remove_segment=None, running_status=None, sampling_rate=None, segment=None, tags=None, treatments=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if metric_goals and not isinstance(metric_goals, list):
            raise TypeError("Expected argument 'metric_goals' to be a list")
        pulumi.set(__self__, "metric_goals", metric_goals)
        if online_ab_config and not isinstance(online_ab_config, dict):
            raise TypeError("Expected argument 'online_ab_config' to be a dict")
        pulumi.set(__self__, "online_ab_config", online_ab_config)
        if randomization_salt and not isinstance(randomization_salt, str):
            raise TypeError("Expected argument 'randomization_salt' to be a str")
        pulumi.set(__self__, "randomization_salt", randomization_salt)
        if remove_segment and not isinstance(remove_segment, bool):
            raise TypeError("Expected argument 'remove_segment' to be a bool")
        pulumi.set(__self__, "remove_segment", remove_segment)
        if running_status and not isinstance(running_status, dict):
            raise TypeError("Expected argument 'running_status' to be a dict")
        pulumi.set(__self__, "running_status", running_status)
        if sampling_rate and not isinstance(sampling_rate, int):
            raise TypeError("Expected argument 'sampling_rate' to be a int")
        pulumi.set(__self__, "sampling_rate", sampling_rate)
        if segment and not isinstance(segment, str):
            raise TypeError("Expected argument 'segment' to be a str")
        pulumi.set(__self__, "segment", segment)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if treatments and not isinstance(treatments, list):
            raise TypeError("Expected argument 'treatments' to be a list")
        pulumi.set(__self__, "treatments", treatments)

    @property
    @pulumi.getter
    def arn(self) -> Optional[str]:
        """
        The ARN of the experiment. For example, `arn:aws:evidently:us-west-2:0123455678912:project/myProject/experiment/myExperiment`
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        An optional description of the experiment.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="metricGoals")
    def metric_goals(self) -> Optional[Sequence['outputs.ExperimentMetricGoalObject']]:
        """
        An array of structures that defines the metrics used for the experiment, and whether a higher or lower value for each metric is the goal. You can use up to three metrics in an experiment.
        """
        return pulumi.get(self, "metric_goals")

    @property
    @pulumi.getter(name="onlineAbConfig")
    def online_ab_config(self) -> Optional['outputs.ExperimentOnlineAbConfigObject']:
        """
        A structure that contains the configuration of which variation to use as the "control" version. The "control" version is used for comparison with other variations. This structure also specifies how much experiment traffic is allocated to each variation.
        """
        return pulumi.get(self, "online_ab_config")

    @property
    @pulumi.getter(name="randomizationSalt")
    def randomization_salt(self) -> Optional[str]:
        """
        When Evidently assigns a particular user session to an experiment, it must use a randomization ID to determine which variation the user session is served. This randomization ID is a combination of the entity ID and `randomizationSalt` . If you omit `randomizationSalt` , Evidently uses the experiment name as the `randomizationSalt` .
        """
        return pulumi.get(self, "randomization_salt")

    @property
    @pulumi.getter(name="removeSegment")
    def remove_segment(self) -> Optional[bool]:
        """
        Set this to `true` to remove the segment that is associated with this experiment. You can't use this parameter if the experiment is currently running.
        """
        return pulumi.get(self, "remove_segment")

    @property
    @pulumi.getter(name="runningStatus")
    def running_status(self) -> Optional['outputs.ExperimentRunningStatusObject']:
        """
        Start Experiment. Default is False
        """
        return pulumi.get(self, "running_status")

    @property
    @pulumi.getter(name="samplingRate")
    def sampling_rate(self) -> Optional[int]:
        """
        The portion of the available audience that you want to allocate to this experiment, in thousandths of a percent. The available audience is the total audience minus the audience that you have allocated to overrides or current launches of this feature.

        This is represented in thousandths of a percent. For example, specify 10,000 to allocate 10% of the available audience.
        """
        return pulumi.get(self, "sampling_rate")

    @property
    @pulumi.getter
    def segment(self) -> Optional[str]:
        """
        Specifies an audience *segment* to use in the experiment. When a segment is used in an experiment, only user sessions that match the segment pattern are used in the experiment.

        For more information, see [Segment rule pattern syntax](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Evidently-segments.html#CloudWatch-Evidently-segments-syntax) .
        """
        return pulumi.get(self, "segment")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def treatments(self) -> Optional[Sequence['outputs.ExperimentTreatmentObject']]:
        """
        An array of structures that describe the configuration of each feature variation used in the experiment.
        """
        return pulumi.get(self, "treatments")


class AwaitableGetExperimentResult(GetExperimentResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetExperimentResult(
            arn=self.arn,
            description=self.description,
            metric_goals=self.metric_goals,
            online_ab_config=self.online_ab_config,
            randomization_salt=self.randomization_salt,
            remove_segment=self.remove_segment,
            running_status=self.running_status,
            sampling_rate=self.sampling_rate,
            segment=self.segment,
            tags=self.tags,
            treatments=self.treatments)


def get_experiment(arn: Optional[str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetExperimentResult:
    """
    Resource Type definition for AWS::Evidently::Experiment.


    :param str arn: The ARN of the experiment. For example, `arn:aws:evidently:us-west-2:0123455678912:project/myProject/experiment/myExperiment`
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:evidently:getExperiment', __args__, opts=opts, typ=GetExperimentResult).value

    return AwaitableGetExperimentResult(
        arn=pulumi.get(__ret__, 'arn'),
        description=pulumi.get(__ret__, 'description'),
        metric_goals=pulumi.get(__ret__, 'metric_goals'),
        online_ab_config=pulumi.get(__ret__, 'online_ab_config'),
        randomization_salt=pulumi.get(__ret__, 'randomization_salt'),
        remove_segment=pulumi.get(__ret__, 'remove_segment'),
        running_status=pulumi.get(__ret__, 'running_status'),
        sampling_rate=pulumi.get(__ret__, 'sampling_rate'),
        segment=pulumi.get(__ret__, 'segment'),
        tags=pulumi.get(__ret__, 'tags'),
        treatments=pulumi.get(__ret__, 'treatments'))
def get_experiment_output(arn: Optional[pulumi.Input[str]] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetExperimentResult]:
    """
    Resource Type definition for AWS::Evidently::Experiment.


    :param str arn: The ARN of the experiment. For example, `arn:aws:evidently:us-west-2:0123455678912:project/myProject/experiment/myExperiment`
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:evidently:getExperiment', __args__, opts=opts, typ=GetExperimentResult)
    return __ret__.apply(lambda __response__: GetExperimentResult(
        arn=pulumi.get(__response__, 'arn'),
        description=pulumi.get(__response__, 'description'),
        metric_goals=pulumi.get(__response__, 'metric_goals'),
        online_ab_config=pulumi.get(__response__, 'online_ab_config'),
        randomization_salt=pulumi.get(__response__, 'randomization_salt'),
        remove_segment=pulumi.get(__response__, 'remove_segment'),
        running_status=pulumi.get(__response__, 'running_status'),
        sampling_rate=pulumi.get(__response__, 'sampling_rate'),
        segment=pulumi.get(__response__, 'segment'),
        tags=pulumi.get(__response__, 'tags'),
        treatments=pulumi.get(__response__, 'treatments')))
