# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['ExperimentArgs', 'Experiment']

@pulumi.input_type
class ExperimentArgs:
    def __init__(__self__, *,
                 metric_goals: pulumi.Input[Sequence[pulumi.Input['ExperimentMetricGoalObjectArgs']]],
                 online_ab_config: pulumi.Input['ExperimentOnlineAbConfigObjectArgs'],
                 project: pulumi.Input[str],
                 treatments: pulumi.Input[Sequence[pulumi.Input['ExperimentTreatmentObjectArgs']]],
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 randomization_salt: Optional[pulumi.Input[str]] = None,
                 remove_segment: Optional[pulumi.Input[bool]] = None,
                 running_status: Optional[pulumi.Input['ExperimentRunningStatusObjectArgs']] = None,
                 sampling_rate: Optional[pulumi.Input[int]] = None,
                 segment: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a Experiment resource.
        :param pulumi.Input[Sequence[pulumi.Input['ExperimentMetricGoalObjectArgs']]] metric_goals: An array of structures that defines the metrics used for the experiment, and whether a higher or lower value for each metric is the goal. You can use up to three metrics in an experiment.
        :param pulumi.Input['ExperimentOnlineAbConfigObjectArgs'] online_ab_config: A structure that contains the configuration of which variation to use as the "control" version. The "control" version is used for comparison with other variations. This structure also specifies how much experiment traffic is allocated to each variation.
        :param pulumi.Input[str] project: The name or the ARN of the project where this experiment is to be created.
        :param pulumi.Input[Sequence[pulumi.Input['ExperimentTreatmentObjectArgs']]] treatments: An array of structures that describe the configuration of each feature variation used in the experiment.
        :param pulumi.Input[str] description: An optional description of the experiment.
        :param pulumi.Input[str] name: A name for the new experiment.
        :param pulumi.Input[str] randomization_salt: When Evidently assigns a particular user session to an experiment, it must use a randomization ID to determine which variation the user session is served. This randomization ID is a combination of the entity ID and `randomizationSalt` . If you omit `randomizationSalt` , Evidently uses the experiment name as the `randomizationSalt` .
        :param pulumi.Input[bool] remove_segment: Set this to `true` to remove the segment that is associated with this experiment. You can't use this parameter if the experiment is currently running.
        :param pulumi.Input['ExperimentRunningStatusObjectArgs'] running_status: Start Experiment. Default is False
        :param pulumi.Input[int] sampling_rate: The portion of the available audience that you want to allocate to this experiment, in thousandths of a percent. The available audience is the total audience minus the audience that you have allocated to overrides or current launches of this feature.
               
               This is represented in thousandths of a percent. For example, specify 10,000 to allocate 10% of the available audience.
        :param pulumi.Input[str] segment: Specifies an audience *segment* to use in the experiment. When a segment is used in an experiment, only user sessions that match the segment pattern are used in the experiment.
               
               For more information, see [Segment rule pattern syntax](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Evidently-segments.html#CloudWatch-Evidently-segments-syntax) .
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: An array of key-value pairs to apply to this resource.
        """
        pulumi.set(__self__, "metric_goals", metric_goals)
        pulumi.set(__self__, "online_ab_config", online_ab_config)
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "treatments", treatments)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if randomization_salt is not None:
            pulumi.set(__self__, "randomization_salt", randomization_salt)
        if remove_segment is not None:
            pulumi.set(__self__, "remove_segment", remove_segment)
        if running_status is not None:
            pulumi.set(__self__, "running_status", running_status)
        if sampling_rate is not None:
            pulumi.set(__self__, "sampling_rate", sampling_rate)
        if segment is not None:
            pulumi.set(__self__, "segment", segment)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="metricGoals")
    def metric_goals(self) -> pulumi.Input[Sequence[pulumi.Input['ExperimentMetricGoalObjectArgs']]]:
        """
        An array of structures that defines the metrics used for the experiment, and whether a higher or lower value for each metric is the goal. You can use up to three metrics in an experiment.
        """
        return pulumi.get(self, "metric_goals")

    @metric_goals.setter
    def metric_goals(self, value: pulumi.Input[Sequence[pulumi.Input['ExperimentMetricGoalObjectArgs']]]):
        pulumi.set(self, "metric_goals", value)

    @property
    @pulumi.getter(name="onlineAbConfig")
    def online_ab_config(self) -> pulumi.Input['ExperimentOnlineAbConfigObjectArgs']:
        """
        A structure that contains the configuration of which variation to use as the "control" version. The "control" version is used for comparison with other variations. This structure also specifies how much experiment traffic is allocated to each variation.
        """
        return pulumi.get(self, "online_ab_config")

    @online_ab_config.setter
    def online_ab_config(self, value: pulumi.Input['ExperimentOnlineAbConfigObjectArgs']):
        pulumi.set(self, "online_ab_config", value)

    @property
    @pulumi.getter
    def project(self) -> pulumi.Input[str]:
        """
        The name or the ARN of the project where this experiment is to be created.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[str]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def treatments(self) -> pulumi.Input[Sequence[pulumi.Input['ExperimentTreatmentObjectArgs']]]:
        """
        An array of structures that describe the configuration of each feature variation used in the experiment.
        """
        return pulumi.get(self, "treatments")

    @treatments.setter
    def treatments(self, value: pulumi.Input[Sequence[pulumi.Input['ExperimentTreatmentObjectArgs']]]):
        pulumi.set(self, "treatments", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        An optional description of the experiment.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A name for the new experiment.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="randomizationSalt")
    def randomization_salt(self) -> Optional[pulumi.Input[str]]:
        """
        When Evidently assigns a particular user session to an experiment, it must use a randomization ID to determine which variation the user session is served. This randomization ID is a combination of the entity ID and `randomizationSalt` . If you omit `randomizationSalt` , Evidently uses the experiment name as the `randomizationSalt` .
        """
        return pulumi.get(self, "randomization_salt")

    @randomization_salt.setter
    def randomization_salt(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "randomization_salt", value)

    @property
    @pulumi.getter(name="removeSegment")
    def remove_segment(self) -> Optional[pulumi.Input[bool]]:
        """
        Set this to `true` to remove the segment that is associated with this experiment. You can't use this parameter if the experiment is currently running.
        """
        return pulumi.get(self, "remove_segment")

    @remove_segment.setter
    def remove_segment(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "remove_segment", value)

    @property
    @pulumi.getter(name="runningStatus")
    def running_status(self) -> Optional[pulumi.Input['ExperimentRunningStatusObjectArgs']]:
        """
        Start Experiment. Default is False
        """
        return pulumi.get(self, "running_status")

    @running_status.setter
    def running_status(self, value: Optional[pulumi.Input['ExperimentRunningStatusObjectArgs']]):
        pulumi.set(self, "running_status", value)

    @property
    @pulumi.getter(name="samplingRate")
    def sampling_rate(self) -> Optional[pulumi.Input[int]]:
        """
        The portion of the available audience that you want to allocate to this experiment, in thousandths of a percent. The available audience is the total audience minus the audience that you have allocated to overrides or current launches of this feature.

        This is represented in thousandths of a percent. For example, specify 10,000 to allocate 10% of the available audience.
        """
        return pulumi.get(self, "sampling_rate")

    @sampling_rate.setter
    def sampling_rate(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "sampling_rate", value)

    @property
    @pulumi.getter
    def segment(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies an audience *segment* to use in the experiment. When a segment is used in an experiment, only user sessions that match the segment pattern are used in the experiment.

        For more information, see [Segment rule pattern syntax](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Evidently-segments.html#CloudWatch-Evidently-segments-syntax) .
        """
        return pulumi.get(self, "segment")

    @segment.setter
    def segment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "segment", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


class Experiment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 metric_goals: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ExperimentMetricGoalObjectArgs', 'ExperimentMetricGoalObjectArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 online_ab_config: Optional[pulumi.Input[Union['ExperimentOnlineAbConfigObjectArgs', 'ExperimentOnlineAbConfigObjectArgsDict']]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 randomization_salt: Optional[pulumi.Input[str]] = None,
                 remove_segment: Optional[pulumi.Input[bool]] = None,
                 running_status: Optional[pulumi.Input[Union['ExperimentRunningStatusObjectArgs', 'ExperimentRunningStatusObjectArgsDict']]] = None,
                 sampling_rate: Optional[pulumi.Input[int]] = None,
                 segment: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 treatments: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ExperimentTreatmentObjectArgs', 'ExperimentTreatmentObjectArgsDict']]]]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::Evidently::Experiment.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: An optional description of the experiment.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ExperimentMetricGoalObjectArgs', 'ExperimentMetricGoalObjectArgsDict']]]] metric_goals: An array of structures that defines the metrics used for the experiment, and whether a higher or lower value for each metric is the goal. You can use up to three metrics in an experiment.
        :param pulumi.Input[str] name: A name for the new experiment.
        :param pulumi.Input[Union['ExperimentOnlineAbConfigObjectArgs', 'ExperimentOnlineAbConfigObjectArgsDict']] online_ab_config: A structure that contains the configuration of which variation to use as the "control" version. The "control" version is used for comparison with other variations. This structure also specifies how much experiment traffic is allocated to each variation.
        :param pulumi.Input[str] project: The name or the ARN of the project where this experiment is to be created.
        :param pulumi.Input[str] randomization_salt: When Evidently assigns a particular user session to an experiment, it must use a randomization ID to determine which variation the user session is served. This randomization ID is a combination of the entity ID and `randomizationSalt` . If you omit `randomizationSalt` , Evidently uses the experiment name as the `randomizationSalt` .
        :param pulumi.Input[bool] remove_segment: Set this to `true` to remove the segment that is associated with this experiment. You can't use this parameter if the experiment is currently running.
        :param pulumi.Input[Union['ExperimentRunningStatusObjectArgs', 'ExperimentRunningStatusObjectArgsDict']] running_status: Start Experiment. Default is False
        :param pulumi.Input[int] sampling_rate: The portion of the available audience that you want to allocate to this experiment, in thousandths of a percent. The available audience is the total audience minus the audience that you have allocated to overrides or current launches of this feature.
               
               This is represented in thousandths of a percent. For example, specify 10,000 to allocate 10% of the available audience.
        :param pulumi.Input[str] segment: Specifies an audience *segment* to use in the experiment. When a segment is used in an experiment, only user sessions that match the segment pattern are used in the experiment.
               
               For more information, see [Segment rule pattern syntax](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Evidently-segments.html#CloudWatch-Evidently-segments-syntax) .
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: An array of key-value pairs to apply to this resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ExperimentTreatmentObjectArgs', 'ExperimentTreatmentObjectArgsDict']]]] treatments: An array of structures that describe the configuration of each feature variation used in the experiment.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ExperimentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::Evidently::Experiment.

        :param str resource_name: The name of the resource.
        :param ExperimentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ExperimentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 metric_goals: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ExperimentMetricGoalObjectArgs', 'ExperimentMetricGoalObjectArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 online_ab_config: Optional[pulumi.Input[Union['ExperimentOnlineAbConfigObjectArgs', 'ExperimentOnlineAbConfigObjectArgsDict']]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 randomization_salt: Optional[pulumi.Input[str]] = None,
                 remove_segment: Optional[pulumi.Input[bool]] = None,
                 running_status: Optional[pulumi.Input[Union['ExperimentRunningStatusObjectArgs', 'ExperimentRunningStatusObjectArgsDict']]] = None,
                 sampling_rate: Optional[pulumi.Input[int]] = None,
                 segment: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 treatments: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ExperimentTreatmentObjectArgs', 'ExperimentTreatmentObjectArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ExperimentArgs.__new__(ExperimentArgs)

            __props__.__dict__["description"] = description
            if metric_goals is None and not opts.urn:
                raise TypeError("Missing required property 'metric_goals'")
            __props__.__dict__["metric_goals"] = metric_goals
            __props__.__dict__["name"] = name
            if online_ab_config is None and not opts.urn:
                raise TypeError("Missing required property 'online_ab_config'")
            __props__.__dict__["online_ab_config"] = online_ab_config
            if project is None and not opts.urn:
                raise TypeError("Missing required property 'project'")
            __props__.__dict__["project"] = project
            __props__.__dict__["randomization_salt"] = randomization_salt
            __props__.__dict__["remove_segment"] = remove_segment
            __props__.__dict__["running_status"] = running_status
            __props__.__dict__["sampling_rate"] = sampling_rate
            __props__.__dict__["segment"] = segment
            __props__.__dict__["tags"] = tags
            if treatments is None and not opts.urn:
                raise TypeError("Missing required property 'treatments'")
            __props__.__dict__["treatments"] = treatments
            __props__.__dict__["arn"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["name", "project"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Experiment, __self__).__init__(
            'aws-native:evidently:Experiment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Experiment':
        """
        Get an existing Experiment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ExperimentArgs.__new__(ExperimentArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["metric_goals"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["online_ab_config"] = None
        __props__.__dict__["project"] = None
        __props__.__dict__["randomization_salt"] = None
        __props__.__dict__["remove_segment"] = None
        __props__.__dict__["running_status"] = None
        __props__.__dict__["sampling_rate"] = None
        __props__.__dict__["segment"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["treatments"] = None
        return Experiment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The ARN of the experiment. For example, `arn:aws:evidently:us-west-2:0123455678912:project/myProject/experiment/myExperiment`
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        An optional description of the experiment.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="metricGoals")
    def metric_goals(self) -> pulumi.Output[Sequence['outputs.ExperimentMetricGoalObject']]:
        """
        An array of structures that defines the metrics used for the experiment, and whether a higher or lower value for each metric is the goal. You can use up to three metrics in an experiment.
        """
        return pulumi.get(self, "metric_goals")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        A name for the new experiment.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="onlineAbConfig")
    def online_ab_config(self) -> pulumi.Output['outputs.ExperimentOnlineAbConfigObject']:
        """
        A structure that contains the configuration of which variation to use as the "control" version. The "control" version is used for comparison with other variations. This structure also specifies how much experiment traffic is allocated to each variation.
        """
        return pulumi.get(self, "online_ab_config")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The name or the ARN of the project where this experiment is to be created.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="randomizationSalt")
    def randomization_salt(self) -> pulumi.Output[Optional[str]]:
        """
        When Evidently assigns a particular user session to an experiment, it must use a randomization ID to determine which variation the user session is served. This randomization ID is a combination of the entity ID and `randomizationSalt` . If you omit `randomizationSalt` , Evidently uses the experiment name as the `randomizationSalt` .
        """
        return pulumi.get(self, "randomization_salt")

    @property
    @pulumi.getter(name="removeSegment")
    def remove_segment(self) -> pulumi.Output[Optional[bool]]:
        """
        Set this to `true` to remove the segment that is associated with this experiment. You can't use this parameter if the experiment is currently running.
        """
        return pulumi.get(self, "remove_segment")

    @property
    @pulumi.getter(name="runningStatus")
    def running_status(self) -> pulumi.Output[Optional['outputs.ExperimentRunningStatusObject']]:
        """
        Start Experiment. Default is False
        """
        return pulumi.get(self, "running_status")

    @property
    @pulumi.getter(name="samplingRate")
    def sampling_rate(self) -> pulumi.Output[Optional[int]]:
        """
        The portion of the available audience that you want to allocate to this experiment, in thousandths of a percent. The available audience is the total audience minus the audience that you have allocated to overrides or current launches of this feature.

        This is represented in thousandths of a percent. For example, specify 10,000 to allocate 10% of the available audience.
        """
        return pulumi.get(self, "sampling_rate")

    @property
    @pulumi.getter
    def segment(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies an audience *segment* to use in the experiment. When a segment is used in an experiment, only user sessions that match the segment pattern are used in the experiment.

        For more information, see [Segment rule pattern syntax](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Evidently-segments.html#CloudWatch-Evidently-segments-syntax) .
        """
        return pulumi.get(self, "segment")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def treatments(self) -> pulumi.Output[Sequence['outputs.ExperimentTreatmentObject']]:
        """
        An array of structures that describe the configuration of each feature variation used in the experiment.
        """
        return pulumi.get(self, "treatments")

